/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.helpers;

import com.ejie.r01d.datastore.R01DContentInDataStore;
import com.ejie.r01d.exceptions.R01DContentModelPersistenceException;
import com.ejie.r01d.gestorcontenidos.dbhelppers.R01DContentModelLoaderHelper;
import com.ejie.r01d.util.R01DUtils;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MDeleteModelObjectException;
import com.ejie.r01m.exceptions.R01MDuplicateModelObjectException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.misc.R01MOperationInModelObjectResult;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MURLHelpper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class R01DContentMigrationHelper {
    private R01MUserContext _userCtx;

    public R01DContentMigrationHelper() {
    }

    public R01DContentMigrationHelper(R01MUserContext userCtx) {
        this._userCtx = userCtx;
    }

    public void doGenerateContentXMLDescriptorFromDBRecords(String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("Error en la migraci\u00f3n: No se tiene contexto de usuario.");
        }
        StringBuffer dbg = new StringBuffer("");
        R01MContent content = null;
        try {
            R01DContentModelLoaderHelper loader = new R01DContentModelLoaderHelper(this._userCtx);
            content = loader.loadContentFromDBRecords(contentOid);
        }
        catch (R01DContentModelPersistenceException pEx) {
            throw new R01MContentModelException("NO se puede cargar el contenido " + contentOid + " a partir de los registros de BD: " + pEx.getMessage(), (Exception)((Object)pEx));
        }
        try {
            R01MClientFactory.getContentAdminAPI((R01MUserContext)this._userCtx).saveContentDescriptor(contentOid, R01DUtils.obtainXMLFromContentObj((R01MContent)content), false);
        }
        catch (XOMarshallerException xoEx) {
            throw new R01MContentModelException("NO se puede obtener el XML del contenido " + contentOid + ": " + xoEx.getMessage(), (Exception)((Object)xoEx));
        }
        R01MURLHelpper.reCalculateContentURLs((R01MContent)content);
        try {
            R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).saveContent(content);
            dbg.append("\t-descriptor OK\r\n");
        }
        catch (R01MDuplicateModelObjectException ex) {
            ex.printStackTrace(System.out);
        }
        catch (R01MDeleteModelObjectException ex) {
            ex.printStackTrace(System.out);
        }
        catch (R01MContentModelObjectsValidatorException ex) {
            ex.printStackTrace(System.out);
            throw new R01MContentModelException("Error al validar el contenido: " + ex.getMessage(), (Exception)((Object)ex));
        }
        R01DContentInDataStore dataStore = new R01DContentInDataStore(this._userCtx, content);
        try {
            dataStore.createContentDefaultDirs();
            if (content.getDocuments() != null) {
                Iterator it = content.getDocuments().keySet().iterator();
                while (it.hasNext()) {
                    dataStore.createDocument((String)it.next());
                }
            }
        }
        catch (R01MDataStoreException dsEx) {
            dsEx.printStackTrace(System.out);
            throw new R01MContentModelException("Error al crear los directorios del contenido por defecto (publish...): " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
        System.out.println(dbg.toString());
    }

    public List[] doGenerateLocationContentsXMLDescriptorFromDBRecords(R01MContentLocation loc) throws R01MSecurityException, R01MContentModelException {
        int i;
        if (this._userCtx == null) {
            throw new R01MSecurityException("No se tiene contexto de usuario.");
        }
        if (loc == null || loc.getServerOid() == null || loc.getDataRepositoryOid() == null || loc.getAreaOid() == null || loc.getWorkAreaOid() == null) {
            throw new IllegalArgumentException("La workArea suministrada para la migracion NO es correcta!!!");
        }
        List[] results = new List[]{new ArrayList(), new ArrayList()};
        String[] workAreaContOids = R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).loadWorkAreaContentsOids(loc);
        if (workAreaContOids != null) {
            for (i = 0; i < workAreaContOids.length; ++i) {
                try {
                    this.doGenerateContentXMLDescriptorFromDBRecords(workAreaContOids[i]);
                    R01MOperationInModelObjectResult res = new R01MOperationInModelObjectResult(workAreaContOids[i], 0, true, null);
                    results[0].add(res);
                    continue;
                }
                catch (R01MContentModelException cmEx) {
                    cmEx.printStackTrace(System.out);
                    R01MOperationInModelObjectResult res = new R01MOperationInModelObjectResult(workAreaContOids[i], 0, false, cmEx.getMessage());
                    results[1].add(res);
                }
            }
        }
        System.out.println("\r\n\r\nIMPORTACION >>>>###################### Relaci\u00f3n de contenidos migrados correctamente (" + results[0].size() + "):\r\n");
        for (i = 0; i < results[0].size(); ++i) {
            System.out.println("\t-" + ((R01MOperationInModelObjectResult)results[0].get(i)).composeDebugInfo());
        }
        System.out.println("\r\n\r\nIMPORTACION >>>>####################### Relaci\u00f3n de contenidos NO migrados correctamente(" + results[1].size() + "):\r\n");
        for (i = 0; i < results[1].size(); ++i) {
            System.out.println("\t-" + ((R01MOperationInModelObjectResult)results[1].get(i)).composeDebugInfo());
        }
        return results;
    }
}

