/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.helpers;

import com.ejie.r01d.datastore.R01DContentInDataStore;
import com.ejie.r01d.exceptions.R01DContentModelPersistenceException;
import com.ejie.r01d.filters.R01DContentResourcesFileFilter;
import com.ejie.r01d.gestorcontenidos.dbhelppers.dao.R01DDAOContentModelLoader;
import com.ejie.r01d.services.R01DContentModelManager;
import com.ejie.r01d.services.helpers.R01DIndexerHelper;
import com.ejie.r01f.exceptions.ExceptionUtils;
import com.ejie.r01f.file.DirectoryExtractor;
import com.ejie.r01f.file.FileUtils;
import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.publisher.R01MPublicationConfig;
import com.ejie.r01m.config.objects.typologymanagement.R01MContentTypeTemplateConfig;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.datastore.R01MDataStoreAuthObject;
import com.ejie.r01m.datastore.R01MDataStoreManager;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MDataStoreAuthenticationException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MDeleteModelObjectException;
import com.ejie.r01m.exceptions.R01MDuplicateModelObjectException;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.contentmodel.R01MBaseDocumentInterface;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MDataFile;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.datastore.R01MDataStoreItem;
import com.ejie.r01m.objects.misc.R01MOperationInModelObjectResult;
import com.ejie.r01m.objects.resources.R01MLinkedResource;
import com.ejie.r01m.objects.resources.R01MLinkedResourcesGroup;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexDefinition;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentDataAPI;
import com.ejie.r01m.services.R01MContentModelAPI;
import com.ejie.r01m.services.R01MRawDataAPI;
import com.ejie.r01m.services.R01MTypologyManagementConfigAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MPathHelpper;
import com.ejie.r01m.utils.R01MURLHelpper;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.contentmanager.R01MContentModelObjectsValidator;
import com.ejie.r01m.utils.jms.R01MJMSUtils;
import com.ejie.r01m.utils.jms.R01MJmsQueueParam;
import com.ejie.r01m.utils.url.R01MPortalURL;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class R01DContentImportHelper {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.import").intValue() != Level.OFF.intValue();
    private static final String DATASTORE_MANAGER_CLASS_NAME = XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"dataStoreManager/implClassName");
    private static final String DESTINATION_IMPORT_FILE = XMLProperties.get((String)R01MConstants.SYSTEMADMINISTRATION_APPCODE, (String)"uploadServlet/digesters/digester[@id='importFileContentsDigester']/config/dir", (String)"/datos/r01nt/file/import/");
    private static final String PATHSEPARATOR = File.separator;
    private R01MUserContext _userCtx;
    private R01MDataStoreManager _dsMgr;
    private R01DContentModelManager _cmManager = new R01DContentModelManager();

    public R01DContentImportHelper() {
    }

    public R01DContentImportHelper(R01MUserContext userCtx) {
        this();
        this._userCtx = userCtx;
    }

    public void doImportContentsFromZipFile(String fileName, String prefix) throws R01MContentModelException {
        ArrayList<R01MJmsQueueParam> params = new ArrayList<R01MJmsQueueParam>();
        params.add(new R01MJmsQueueParam(1, "fileName", (Object)fileName));
        params.add(new R01MJmsQueueParam(1, "directoryImportSufix", (Object)prefix));
        try {
            R01MJMSUtils.sendJMSMessage((String)"r01ImportContents", params);
        }
        catch (R01MJMSException jmsExc) {
            R01FLog.to((String)"r01n.upload").severe("Error en el env\u00edo del mensaje para el procesado del fichero " + fileName + ".Error:" + jmsExc.getMessage());
            throw new R01MContentModelException("Error en el env\u00edo del mensaje para el procesado del fichero " + fileName + ".Error:" + jmsExc.getMessage());
        }
    }

    public R01MOperationInModelObjectResult doImportContent(R01MContentLocation loc, String contentType, String contentName, boolean importDataFilesToSystemArea) {
        R01MOperationInModelObjectResult outResult = new R01MOperationInModelObjectResult(contentType + ":" + contentName, 0, true, "OK");
        if (this._userCtx == null) {
            outResult.setMsg("Error en la importacion: No se tiene contexto de usuario.");
            outResult.setOperationOK(false);
        }
        if (!outResult.isOperationOK()) {
            return outResult;
        }
        StringBuffer dbg = new StringBuffer(69);
        R01MContent content = null;
        try {
            if (this._dsMgr == null) {
                this._dsMgr = this._obtainDataStoreManager();
            }
            InputStream descriptorXML = this._dsMgr.doReadFile((R01MBaseLocationObject)loc, contentType + PATHSEPARATOR + contentName + PATHSEPARATOR + contentName + "-content.xml");
            content = (R01MContent)XOManager.getObject((String)R01MConstants.CONTENTMODEL_MAPFILE, (InputStream)descriptorXML);
            dbg.append("Contenido: ").append(content.getOid()).append(" (").append(content.getDocuments() != null ? content.getDocuments().size() : 0).append(" documents)\r\n");
        }
        catch (R01MDataStoreAuthenticationException authEx) {
            outResult.setMsg("No se ha podido realizar la autenticaci\u00f3n: " + authEx.getMessage());
            outResult.setOperationOK(false);
        }
        catch (R01MDataStoreException dsEx) {
            outResult.setMsg("No se ha podido cargar el descriptor del contenido: " + dsEx.getMessage());
            outResult.setOperationOK(false);
        }
        catch (XOMarshallerException xoEx) {
            outResult.setMsg("No se ha podido pasar el XML de contenido a objeto: " + xoEx.getMessage());
            outResult.setOperationOK(false);
        }
        if (content == null) {
            outResult.setMsg("NO se ha podido cargar el contenido");
            outResult.setOperationOK(false);
        }
        if (!outResult.isOperationOK()) {
            return outResult;
        }
        content.setStoreLocation(loc);
        R01MURLHelpper.reCalculateContentURLs(content);
        if (content.getDocuments() != null) {
            for (R01MDocument currDoc : content.getDocuments().values()) {
                currDoc.setPublicationInfo(new ArrayList());
                currDoc.setRequestedPublications(new HashMap());
            }
        }
        try {
            List defaultLabels = R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).getDefaultLabels(loc, content.getTypo());
            if (defaultLabels != null && !defaultLabels.isEmpty()) {
                content.getLabels().addAll(defaultLabels);
            }
        }
        catch (R01MContentModelException e) {
            e.printStackTrace(System.out);
            outResult.setMsg("Error al poner las catalogaciones por defecto del contenido: " + e.getMessage());
            outResult.setOperationOK(false);
        }
        try {
            R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).saveContent(content);
            dbg.append("\t-descriptor OK\r\n");
        }
        catch (R01MDuplicateModelObjectException dupEx) {
            dupEx.printStackTrace(System.out);
        }
        catch (R01MDeleteModelObjectException delEx) {
            delEx.printStackTrace(System.out);
        }
        catch (R01MContentModelObjectsValidatorException cmValEx) {
            cmValEx.printStackTrace(System.out);
            outResult.setMsg("Error al validar el contenido: " + cmValEx.getMessage());
            outResult.setOperationOK(false);
        }
        catch (R01MContentModelException cmEx) {
            cmEx.printStackTrace(System.out);
            outResult.setMsg("Error en el modelo de contenido: " + cmEx.getMessage());
            outResult.setOperationOK(false);
        }
        catch (R01MSecurityException secEx) {
            secEx.printStackTrace(System.out);
            outResult.setMsg("Error de seguridad: " + secEx.getMessage());
            outResult.setOperationOK(false);
        }
        if (!outResult.isOperationOK()) {
            return outResult;
        }
        R01DContentInDataStore dataStore = new R01DContentInDataStore(this._userCtx, content);
        try {
            dataStore.createContentDefaultDirs();
            if (content.getDocuments() != null) {
                Iterator it = content.getDocuments().keySet().iterator();
                while (it.hasNext()) {
                    dataStore.createDocument((String)it.next());
                }
            }
            if (importDataFilesToSystemArea) {
                this._copyDataFilesFromDocumentFolderToDataStoreSystemFolder(content);
            } else {
                this._setContentDataFilesExtAttrs(content);
            }
        }
        catch (R01MDataStoreException dsEx) {
            dsEx.printStackTrace(System.out);
            outResult.setMsg("Error al crear los directorios del contenido por defecto (publish...) o al establecer los atributos extendidos : " + dsEx.getMessage());
            outResult.setOperationOK(false);
        }
        if (!outResult.isOperationOK()) {
            return outResult;
        }
        dbg.append("\t-importacion OK\r\n");
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info(dbg.toString());
        }
        return outResult;
    }

    public List[] doImportLocationContents(R01MContentLocation loc, boolean importDataFilesToSystemArea) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("No se tiene contexto de usuario.");
        }
        String ignoredDirs = "[templatedata],[directorio_centro],[informes],[estudios],[memorias],[articulos_documentales],[publicaciones][publicaci\u00f3n_periodica],[planes],[programas],[proyectos],[enlaces],[estadisticas],[eventos][congresos],[jornadas_seminarios],[cursos],[actos_publicos],[galerias_fotograficas][d1_territorio_historico],[normativas],[guias_departamento],[guias_organo][novedades],[notas_prensa],[ayudas_subvenciones],[autorizaciones],[carnets][registros],[inspecciones],[multas_sanciones],[denuncias_reclamaciones],[contrataciones_administrativas][convocatorias],[otros_procedimientos],[recursos_humanos],[procedimiento_informacion]";
        if (loc == null || loc.getServerOid() == null || loc.getDataRepositoryOid() == null || loc.getAreaOid() == null || loc.getWorkAreaOid() == null) {
            throw new IllegalArgumentException("La workArea suministrada para la importacion NO es correcta!!!");
        }
        List[] results = new List[]{new ArrayList(), new ArrayList()};
        StringBuffer dbg = new StringBuffer("");
        try {
            R01MDataStoreItem[] typoFolders;
            if (this._dsMgr == null) {
                this._dsMgr = this._obtainDataStoreManager();
            }
            if ((typoFolders = this._dsMgr.doGetFolderContents((R01MBaseLocationObject)loc, "/", false, null, null)) != null) {
                for (int i = 0; i < typoFolders.length; ++i) {
                    R01MDataStoreItem[] contFolders;
                    if (ignoredDirs.indexOf("[" + typoFolders[i].getItemName() + "]") >= 0 || typoFolders[i].getItemType() != 1 || (contFolders = this._dsMgr.doGetFolderContents((R01MBaseLocationObject)loc, typoFolders[i].getWorkAreaRelativePath(), false, null, null)) == null) continue;
                    dbg.append("WorkArea " + loc.composeMemoCode() + ": Tipo " + typoFolders[i].getItemName() + "(" + contFolders.length + " contenidos)\r\n");
                    for (int j = 0; j < contFolders.length; ++j) {
                        dbg.append(">>>>>Contenido: " + contFolders[j].getItemName() + "\r\n");
                        try {
                            R01MOperationInModelObjectResult currRes = this.doImportContent(loc, typoFolders[i].getItemName(), contFolders[j].getItemName(), importDataFilesToSystemArea);
                            if (currRes.isOperationOK()) {
                                results[0].add(currRes);
                                dbg.append("[OK]");
                            } else {
                                results[1].add(currRes);
                                dbg.append("[ERROR]");
                            }
                            if (DEBUG) {
                                R01FLog.to((String)"r01d.import").info(dbg.toString());
                            }
                            dbg = new StringBuffer("");
                            continue;
                        }
                        catch (Throwable th) {
                            R01MOperationInModelObjectResult errResult = new R01MOperationInModelObjectResult(typoFolders[i].getItemName() + ":" + contFolders[j].getItemName(), 0, false, th.getMessage());
                            results[1].add(errResult);
                            th.printStackTrace(System.out);
                        }
                    }
                }
            }
        }
        catch (R01MDataStoreAuthenticationException dsAuthEx) {
            dsAuthEx.printStackTrace(System.out);
            throw new R01MContentModelException((Exception)((Object)dsAuthEx));
        }
        catch (R01MDataStoreException dsEx) {
            dsEx.printStackTrace(System.out);
            throw new R01MContentModelException((Exception)((Object)dsEx));
        }
        if (DEBUG) {
            int i;
            R01FLog.to((String)"r01d.import").info("\r\n\r\nIMPORTACION >>>>###################### Relaci\u00f3n de contenidos importados correctamente (" + results[0].size() + "):\r\n");
            for (i = 0; i < results[0].size(); ++i) {
                R01FLog.to((String)"r01d.import").info("\t-" + ((R01MOperationInModelObjectResult)results[0].get(i)).composeDebugInfo());
            }
            R01FLog.to((String)"r01d.import").info("\r\n\r\nIMPORTACION >>>>####################### Relaci\u00f3n de contenidos NO importados correctamente(" + results[1].size() + "):\r\n");
            for (i = 0; i < results[1].size(); ++i) {
                R01FLog.to((String)"r01d.import").info("\t-" + ((R01MOperationInModelObjectResult)results[1].get(i)).composeDebugInfo());
            }
        }
        return results;
    }

    public List[] doCopyDataFilesFromSystemAreaToDocumentFolder(R01MContentLocation loc) throws R01MSecurityException, R01MContentModelException {
        int i;
        if (this._userCtx == null) {
            throw new R01MSecurityException("No se tiene contexto de usuario.");
        }
        if (loc == null || loc.getServerOid() == null || loc.getDataRepositoryOid() == null || loc.getAreaOid() == null || loc.getWorkAreaOid() == null) {
            throw new IllegalArgumentException("La workArea suministrada para la importacion NO es correcta!!!");
        }
        List[] results = new List[]{new ArrayList(), new ArrayList()};
        StringBuffer dbg = new StringBuffer();
        String[] locContentOids = R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).loadWorkAreaContentsOids(loc);
        if (locContentOids == null) {
            dbg.append("NO hay contenidos en la workArea ").append(loc.composeMemoCode());
            if (DEBUG) {
                R01FLog.to((String)"r01d.import").info(dbg.toString());
            }
            return null;
        }
        R01DContentInDataStore contInDs = null;
        R01MContent currCont = null;
        for (i = 0; i < locContentOids.length; ++i) {
            currCont = R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).loadContent(locContentOids[i]);
            if (currCont == null || currCont.getDocuments() == null) continue;
            contInDs = new R01DContentInDataStore(this._userCtx, currCont);
            for (R01MDocument currDoc : currCont.getDocuments().values()) {
                dbg.append("\r\n>>>Contenido: " + currCont.getOid() + " : " + currCont.getName() + "\r\n");
                if (currDoc.getDataFiles() == null) continue;
                dbg.append("\t-Documento: " + currDoc.getOid() + " : " + currDoc.getLanguage() + "_" + currDoc.getInternalName() + "\r\n");
                try {
                    contInDs.createContentDefaultDirs();
                    for (R01MDataFile currDF : currDoc.getDataFiles().values()) {
                        dbg.append("\t\t-DataFile: " + currDF.getOid() + " : " + currDF.getName());
                        contInDs.copyDataFileFromSystemAreaToDocumentFolder(currDoc.getOid(), currDF.getOid());
                        dbg.append("[OK]");
                        R01MOperationInModelObjectResult res = new R01MOperationInModelObjectResult(currDF.getOid(), 2, true, "OK");
                        results[0].add(res);
                    }
                }
                catch (R01MDataStoreException dsEx) {
                    dsEx.printStackTrace(System.out);
                    dbg.append("[ERROR]: ").append(dsEx.getMessage());
                }
                if (DEBUG) {
                    R01FLog.to((String)"r01d.import").info(dbg.toString());
                }
                dbg = new StringBuffer("");
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("\r\n\r\nIMPORTACION >>>>###################### Relaci\u00f3n de dataFiles copiados correctamente (" + results[0].size() + "):\r\n");
            for (i = 0; i < results[0].size(); ++i) {
                R01FLog.to((String)"r01d.import").info("\t-" + ((R01MOperationInModelObjectResult)results[0].get(i)).composeDebugInfo());
            }
            R01FLog.to((String)"r01d.import").info("\r\n\r\nIMPORTACION >>>>####################### Relaci\u00f3n de dataFiles NO copiados correctamente(" + results[1].size() + "):\r\n");
            for (i = 0; i < results[1].size(); ++i) {
                R01FLog.to((String)"r01d.import").info("\t-" + ((R01MOperationInModelObjectResult)results[1].get(i)).composeDebugInfo());
            }
        }
        return results;
    }

    public List[] doImportContentFromArchives(String effectiveImportRootDir, Properties contentToImportData) throws R01MSecurityException, R01MContentModelException {
        boolean keepOids = false;
        if (this._userCtx == null) {
            throw new R01MSecurityException("No se tiene contexto de usuario.");
        }
        if (this._dsMgr == null) {
            try {
                this._dsMgr = this._obtainDataStoreManager();
            }
            catch (R01MDataStoreException ex) {
                ex.printStackTrace();
            }
            catch (R01MDataStoreAuthenticationException ex) {
                ex.printStackTrace();
            }
        }
        List[] results = new List[]{new ArrayList(), new ArrayList()};
        String contentInternalName = contentToImportData.getProperty("contentInternalName");
        String operation = contentToImportData.getProperty("operation");
        R01MContentLocation loc = new R01MContentLocation(contentToImportData.getProperty("serverOid"), contentToImportData.getProperty("dataRepositoryOid"), contentToImportData.getProperty("areaOid"), contentToImportData.getProperty("workareaOid"));
        R01MContentTypologyInfo typo = new R01MContentTypologyInfo(contentToImportData.getProperty("clusterOid"), contentToImportData.getProperty("familyOid"), contentToImportData.getProperty("typeOid"));
        if (!StringUtils.isEmptyString((String)contentToImportData.getProperty("keepOids"))) {
            keepOids = Boolean.valueOf(contentToImportData.getProperty("keepOids"));
        }
        boolean publishContent = false;
        boolean generateHtmlDataFiles = false;
        if (contentToImportData.getProperty("publishContent").equalsIgnoreCase("S")) {
            publishContent = true;
        } else if (contentToImportData.getProperty("publishContent").equalsIgnoreCase("GS")) {
            publishContent = true;
            generateHtmlDataFiles = true;
        } else if (contentToImportData.getProperty("publishContent").equalsIgnoreCase("GN")) {
            generateHtmlDataFiles = true;
        }
        R01MContentModelAPI contentAPI = R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx);
        R01MContent sourceContent = null;
        boolean isContentLoaded = false;
        try {
            File[] documentDirectories;
            sourceContent = (R01MContent)XOManager.getObject((String)R01MConstants.CONTENTMODEL_MAPFILE, (InputStream)new FileInputStream(effectiveImportRootDir + PATHSEPARATOR + contentInternalName + PATHSEPARATOR + contentInternalName + "-content.xml"));
            ArrayList<String> documentDescriptors = new ArrayList<String>();
            File dir = new File(effectiveImportRootDir + PATHSEPARATOR + contentInternalName + PATHSEPARATOR);
            for (File currentDocument : documentDirectories = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.matches(".._.*");
                }
            })) {
                File[] currentDocumentDescriptors = currentDocument.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.matches(".._.*-document\\.xml");
                    }
                });
                if (currentDocumentDescriptors == null || currentDocumentDescriptors.length <= 0) continue;
                documentDescriptors.add(currentDocumentDescriptors[0].getPath());
            }
            if (documentDescriptors != null && documentDescriptors.size() > 0) {
                HashMap<String, File> finalDocuments = new HashMap<String, File>();
                for (String currentDocumentPath : documentDescriptors) {
                    File currentDocument;
                    currentDocument = (R01MDocument)XOManager.getObject((String)R01MConstants.CONTENTMODEL_MAPFILE, (InputStream)new FileInputStream(currentDocumentPath));
                    finalDocuments.put(currentDocument.getOid(), currentDocument);
                }
                sourceContent.setDocuments(finalDocuments);
            }
            isContentLoaded = true;
        }
        catch (FileNotFoundException filExc) {
            results[1].add(new R01MOperationInModelObjectResult("unknown", 0, false, "Error al cargar el archivo del XML de definici\u00f3n del contenido " + contentInternalName + "Error:" + filExc.getMessage()));
            isContentLoaded = false;
        }
        catch (XOMarshallerException mapExc) {
            results[1].add(new R01MOperationInModelObjectResult("unknown", 0, false, "Error al mapear el XML de definici\u00f3n del contenido " + contentInternalName + "Error:" + mapExc.getMessage()));
            isContentLoaded = false;
        }
        if (isContentLoaded) {
            List<R01MOperationInModelObjectResult> dcrPrepareNamesErrors;
            if (("N".equals(operation) || "U".equals(operation)) && (dcrPrepareNamesErrors = this._prepareDCRFiles(sourceContent, effectiveImportRootDir)) != null && !dcrPrepareNamesErrors.isEmpty()) {
                results[1].addAll(dcrPrepareNamesErrors);
            }
            if (DEBUG) {
                R01FLog.to((String)"r01d.import").info(">>>> Importando el contenido " + sourceContent.getInternalName());
                R01FLog.to((String)"r01d.import").info(">>>> Los datos leidos son " + contentToImportData);
            }
            boolean operationHasErrors = false;
            if ("N".equals(operation)) {
                operationHasErrors = this._importNewContent(contentAPI, sourceContent, contentInternalName, loc, typo, effectiveImportRootDir, results, keepOids);
            } else {
                R01MContent searchedContent = null;
                String searchedContentOid = null;
                try {
                    searchedContentOid = contentAPI.getContentOidFromContentTypeAndName(typo.getTypeOid(), sourceContent.getInternalName());
                }
                catch (Exception e) {
                    R01FLog.to((String)"r01d.import").warning("Importando (" + sourceContent.getInternalName() + "): Error al buscar el Oid del contenido a modificar/Borrar.");
                    results[1].add(new R01MOperationInModelObjectResult("unknown", 0, false, "Error al buscar el Oid del contenido " + sourceContent.getInternalName() + "Error:" + e.getMessage()));
                }
                if (!StringUtils.isEmptyString((String)searchedContentOid)) {
                    try {
                        searchedContent = contentAPI.loadContent(searchedContentOid);
                    }
                    catch (Exception e) {
                        R01FLog.to((String)"r01d.import").warning("Importando (" + searchedContentOid + "-" + sourceContent.getInternalName() + "): Error al cargar el contenido.");
                        results[1].add(new R01MOperationInModelObjectResult(searchedContentOid, 0, false, "Error al cargar el contenido " + sourceContent.getInternalName() + "Error:" + e.getMessage()));
                        operationHasErrors = true;
                    }
                    if (!operationHasErrors) {
                        if ("U".equals(operation)) {
                            sourceContent.setOid(searchedContent.getOid());
                            operationHasErrors = this._updateContent(contentAPI, sourceContent, searchedContent, effectiveImportRootDir, results);
                        } else if ("D".equals(operation)) {
                            operationHasErrors = this._deleteContent(searchedContent, results);
                        }
                    }
                } else {
                    operationHasErrors = this._importNewContent(contentAPI, sourceContent, contentInternalName, loc, typo, effectiveImportRootDir, results, keepOids);
                }
            }
            if (!operationHasErrors && !"D".equals(operation)) {
                R01MOperationInModelObjectResult error;
                if (generateHtmlDataFiles) {
                    for (R01MDocument doc : sourceContent.getDocuments().values()) {
                        if (doc.getDataFiles() == null) continue;
                        for (R01MDataFile dataFile : doc.getDataFiles().values()) {
                            String generateURL = dataFile.getGenerateUrl();
                            if (StringUtils.isEmptyString((String)generateURL)) {
                                if (!DEBUG) continue;
                                R01FLog.to((String)"r01d.import").severe("IMPORT CONTENT >> Generaci\u00f3n del archivo " + dataFile.getName() + " en " + "ERROR: el campo de URL de generacion es nulo o vacio. " + "No se tratara este datafile.");
                                continue;
                            }
                            String iwTemplatingPattern = "/[^/]+/main/[^/]+/WORKAREA/[^/]+/templatedata/[^/]+/[^/]+/presentation/[^/]+/data/[^/]+/.+";
                            Pattern p = Pattern.compile(iwTemplatingPattern);
                            Matcher m = p.matcher(generateURL);
                            boolean uploadToDocumentFolder = true;
                            uploadToDocumentFolder = !m.matches();
                            contentAPI.generateDataFileContent(sourceContent.getOid(), doc.getOid(), dataFile.getOid(), false, true, "", true, uploadToDocumentFolder);
                        }
                    }
                }
                if (DEBUG) {
                    if (publishContent) {
                        R01FLog.to((String)"r01d.import").info("Importando (" + sourceContent.getInternalName() + "): Se solicita publicar los documentos.");
                    } else {
                        R01FLog.to((String)"r01d.import").info("Importando (" + sourceContent.getInternalName() + "): NO se solicita publicar los documentos.");
                    }
                }
                if ((error = this._publishContent(publishContent, sourceContent.getOid(), sourceContent.getInternalName(), contentAPI)) != null) {
                    results[1].add(error);
                    operationHasErrors = true;
                }
            }
            if (!operationHasErrors) {
                results[0].add(new R01MOperationInModelObjectResult(sourceContent.getOid(), 0, true, "El contenido " + contentInternalName + " se ha importado correctamente."));
            }
        }
        return results;
    }

    public List[] doImportContentLinkedData(String effectiveImportRootDir, Properties contentToLinkData, R01MContent newCreatedContent) throws R01MSecurityException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("No se tiene contexto de usuario.");
        }
        List[] results = new List[]{new ArrayList(), new ArrayList()};
        R01DDAOContentModelLoader loader = new R01DDAOContentModelLoader();
        if (newCreatedContent.getDocuments() != null && !newCreatedContent.getDocuments().isEmpty()) {
            for (R01MDocument newCreatedDoc : newCreatedContent.getDocuments().values()) {
                FileInputStream fis;
                File f;
                String linkedDescriptorPath = effectiveImportRootDir + PATHSEPARATOR + newCreatedContent.getInternalName() + PATHSEPARATOR + newCreatedDoc.getLanguage() + "_" + newCreatedDoc.getInternalName() + PATHSEPARATOR + R01MPathHelpper.getDocumentLinkedDescriptorDocumentRelativePath((String)newCreatedDoc.getLanguage(), (String)newCreatedDoc.getInternalName());
                if (DEBUG) {
                    R01FLog.to((String)"r01d.import").info("Comprobar la existencia del archivo " + linkedDescriptorPath + " para ser importado.");
                }
                if (!(f = new File(linkedDescriptorPath)).exists()) continue;
                try {
                    fis = new FileInputStream(f);
                }
                catch (FileNotFoundException filExc) {
                    results[0].add(new R01MOperationInModelObjectResult(newCreatedDoc.getOid(), 1, true, "El documento " + newCreatedContent.getInternalName() + "/" + newCreatedDoc.getInternalName() + " no tiene vinculaciones asociadas."));
                    continue;
                }
                R01MLinkedResourcesGroup linkedResourcesGroup = null;
                try {
                    linkedResourcesGroup = (R01MLinkedResourcesGroup)XOManager.getObject((String)R01MConstants.LINK_MAPFILE, (InputStream)fis);
                }
                catch (XOMarshallerException xoExc) {
                    results[1].add(new R01MOperationInModelObjectResult(newCreatedDoc.getOid(), 1, false, "No se puede transformar a objetos el archivo '" + linkedDescriptorPath + "'. Error:" + xoExc.getMessage()));
                    continue;
                }
                if (linkedResourcesGroup.getResources() != null && !linkedResourcesGroup.getResources().isEmpty()) {
                    R01MLinkedResourcesGroup newLinkedResourcesGroup = new R01MLinkedResourcesGroup();
                    newLinkedResourcesGroup.setTitleGroupLabel(linkedResourcesGroup.getTitleGroupLabel());
                    for (R01MLinkedResource currRes : linkedResourcesGroup.getResources().values()) {
                        if (!currRes.isRelationOwner()) continue;
                        if (currRes.getLinkType() == 2) {
                            R01MContent contentToLink;
                            String contentOid;
                            String documentInternalName;
                            String documentLang;
                            block23: {
                                R01MPortalURL url = new R01MPortalURL(currRes.getLinkUrl());
                                String contentType = url.getURLPart("contentType");
                                String contentInternalName = url.getURLPart("contentName");
                                documentLang = url.getURLPart("documentLang");
                                documentInternalName = url.getURLPart("documentInternalName");
                                try {
                                    contentOid = loader.executeGetContentOidByTypeAndName(contentType, contentInternalName);
                                    if (contentOid == null) {
                                        results[1].add(new R01MOperationInModelObjectResult(newCreatedDoc.getOid(), 1, false, "El contenido a relacionar '" + contentInternalName + "' no existe."));
                                    }
                                    break block23;
                                }
                                catch (R01DContentModelPersistenceException ex) {
                                    results[1].add(new R01MOperationInModelObjectResult(newCreatedDoc.getOid(), 1, false, "No se encuentra el contenido a relacionar '" + contentInternalName + "'. Error:" + ex.getMessage()));
                                }
                                continue;
                            }
                            try {
                                contentToLink = this._cmManager.doLoadContent(this._userCtx, contentOid);
                            }
                            catch (R01MContentModelException ex) {
                                results[1].add(new R01MOperationInModelObjectResult(newCreatedDoc.getOid(), 1, false, "No se encuentra el contenido a relacionar '" + contentOid + "'. Error:" + ex.getMessage()));
                                continue;
                            }
                            if (contentToLink.getDocuments() == null || contentToLink.getDocuments().isEmpty()) continue;
                            String docToLinkOid = "";
                            for (R01MDocument docToLink : contentToLink.getDocuments().values()) {
                                if (!docToLink.getInternalName().equals(documentInternalName) || !docToLink.getLanguage().equals(documentLang)) continue;
                                docToLinkOid = docToLink.getOid();
                                break;
                            }
                            if (!StringUtils.isEmptyString((String)docToLinkOid)) {
                                newLinkedResourcesGroup.addLinkToContent(contentOid, docToLinkOid, currRes);
                                continue;
                            }
                            results[1].add(new R01MOperationInModelObjectResult(newCreatedDoc.getOid(), 1, false, "El documento a relacionar no existe."));
                            continue;
                        }
                        String newOid = currRes.getOid();
                        try {
                            newOid = R01MUtils.generateNewOid((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"content");
                        }
                        catch (GUIDDispenserException guidDispEx) {
                            // empty catch block
                        }
                        currRes.setOid(newOid);
                        newLinkedResourcesGroup.getResources().put(newOid, currRes);
                    }
                    if (!newLinkedResourcesGroup.getResources().isEmpty()) {
                        String repositoryOid = ((R01MDocumentPublicationTarget)newCreatedDoc.getPublicationInfo().get(0)).getOid();
                        try {
                            this._cmManager.doSetDocumentLinkedResources(this._userCtx, newCreatedContent.getOid(), newCreatedDoc.getOid(), repositoryOid, newLinkedResourcesGroup, null, true);
                        }
                        catch (Exception ex) {
                            results[1].add(new R01MOperationInModelObjectResult(newCreatedDoc.getOid(), 1, false, "Error al crear las relaciones del documento '" + newCreatedDoc.getInternalName() + "'. Error:" + ex.getMessage()));
                            continue;
                        }
                    }
                }
                results[0].add(new R01MOperationInModelObjectResult(newCreatedDoc.getOid(), 1, true, "El documento " + newCreatedContent.getInternalName() + "/" + newCreatedDoc.getInternalName() + " se ha vinculado correctamente."));
            }
        }
        return results;
    }

    public List[] doImportContentsFromArchiveFile(String fileToImport, String prefix) throws R01MSecurityException {
        return this.doImportContentsFromArchiveFile(fileToImport, prefix, false);
    }

    public List[] doImportContentsFromArchiveFile(String fileToImport, String prefix, boolean keepOids) throws R01MSecurityException {
        List fileLines;
        if (this._userCtx == null) {
            throw new R01MSecurityException("No se tiene contexto de usuario.");
        }
        List[] results = new List[]{new ArrayList(), new ArrayList()};
        String effectiveImportRootDir = StringUtils.isEmptyString((String)prefix) ? DESTINATION_IMPORT_FILE + fileToImport.substring(0, fileToImport.indexOf(46)) : DESTINATION_IMPORT_FILE + prefix + "_" + fileToImport.substring(0, fileToImport.indexOf(46));
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Leer fichero de definicion de la importacion " + effectiveImportRootDir + PATHSEPARATOR + "contents-description.txt");
        }
        try {
            fileLines = FileUtils.readLinesFromStream((InputStream)new FileInputStream(new File(effectiveImportRootDir + PATHSEPARATOR + "contents-description.txt")));
        }
        catch (FileNotFoundException ex) {
            results[1].add(new R01MOperationInModelObjectResult("", -1, false, "No se encuentra el fichero contents-description.txt a nivel raiz dentro del archivo comprimido. Error:" + ex.getMessage()));
            return results;
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Leido fichero de definicion de la importacion " + effectiveImportRootDir + PATHSEPARATOR + "contents-description.txt");
            R01FLog.to((String)"r01d.import").info("Tratando " + fileLines.size() + " contenidos.......");
        }
        boolean isDescriptorError = false;
        String[] values = null;
        for (String currContentData : fileLines) {
            block22: {
                isDescriptorError = false;
                if (!StringUtils.isEmptyString((String)currContentData)) {
                    values = currContentData.split("\\|");
                    if (values.length == 10) {
                        ArrayList<R01MJmsQueueParam> params = new ArrayList<R01MJmsQueueParam>();
                        params.add(new R01MJmsQueueParam(1, "effectiveImportRootDir", (Object)effectiveImportRootDir));
                        params.add(new R01MJmsQueueParam(1, "contentImportDescriptor", (Object)currContentData));
                        params.add(new R01MJmsQueueParam(1, "contentImportLink", (Object)"false"));
                        if (keepOids) {
                            params.add(new R01MJmsQueueParam(1, "keepOids", (Object)"true"));
                        }
                        try {
                            R01MJMSUtils.sendJMSMessage((String)"r01ImportContentFromFile", params, (int)1);
                            break block22;
                        }
                        catch (R01MJMSException jmsExc) {
                            R01FLog.to((String)"r01n.upload").severe("Error en el env\u00edo del mensaje de notificaci\u00f3n de la importaci\u00f3n del contenido de nombre interno" + values[0] + ".Error:" + jmsExc.getMessage());
                            results[1].add(new R01MOperationInModelObjectResult("", 0, false, "Error en el env\u00edo del mensaje de notificaci\u00f3n de la importaci\u00f3n del contenido de nombre interno" + values[0] + ".Error:" + jmsExc.getMessage()));
                            continue;
                        }
                    }
                    isDescriptorError = true;
                } else {
                    isDescriptorError = true;
                }
            }
            if (!isDescriptorError) continue;
            results[1].add(new R01MOperationInModelObjectResult("", 0, false, "La l\u00ednea del fichero descriptor " + (values != null ? StringUtils.printArrayStrings((String[])values) : "null") + " es incorrecta."));
        }
        long waitToLinkedDocuments = Long.parseLong(XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"importContents/waitToImportLinkedData", (String)"300000"));
        try {
            Thread.sleep(waitToLinkedDocuments);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        for (String currContentData : fileLines) {
            block23: {
                isDescriptorError = false;
                if (!StringUtils.isEmptyString((String)currContentData)) {
                    values = currContentData.split("\\|");
                    if (values.length == 10) {
                        ArrayList<R01MJmsQueueParam> params = new ArrayList<R01MJmsQueueParam>();
                        params.add(new R01MJmsQueueParam(1, "effectiveImportRootDir", (Object)effectiveImportRootDir));
                        params.add(new R01MJmsQueueParam(1, "contentImportDescriptor", (Object)currContentData));
                        params.add(new R01MJmsQueueParam(1, "contentImportLink", (Object)"true"));
                        if (keepOids) {
                            params.add(new R01MJmsQueueParam(1, "keepOids", (Object)"true"));
                        }
                        try {
                            R01MJMSUtils.sendJMSMessage((String)"r01ImportContentFromFile", params, (int)0);
                            break block23;
                        }
                        catch (R01MJMSException jmsExc) {
                            R01FLog.to((String)"r01n.upload").severe("Error en el env\u00edo del mensaje de notificaci\u00f3n de la importaci\u00f3n de vinculaciones del contenido de nombre interno" + values[0] + ".Error:" + jmsExc.getMessage());
                            results[1].add(new R01MOperationInModelObjectResult("", 0, false, "Error en el env\u00edo del mensaje de notificaci\u00f3n de la importaci\u00f3n de vinculaciones del contenido de nombre interno" + values[0] + ".Error:" + jmsExc.getMessage()));
                            continue;
                        }
                    }
                    isDescriptorError = true;
                } else {
                    isDescriptorError = true;
                }
            }
            if (!isDescriptorError) continue;
            results[1].add(new R01MOperationInModelObjectResult("", 0, false, "La l\u00ednea del fichero descriptor " + (values != null ? StringUtils.printArrayStrings((String[])values) : "null") + " es incorrecta."));
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info(">>>> Fin del proceso de importacion masiva del empaquetado de contenidos.");
        }
        return results;
    }

    public List<R01MOperationInModelObjectResult>[] doImportAttachmentsFromContent(String effectiveImportRootDir, String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (this._userCtx == null) {
            throw new R01MSecurityException("No se tiene contexto de usuario.");
        }
        List[] results = new List[]{new ArrayList(), new ArrayList()};
        R01MContentModelAPI contentAPI = R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx);
        R01MContent content = null;
        boolean operationHasErrors = false;
        try {
            content = contentAPI.loadContent(contentOid);
        }
        catch (Exception e) {
            R01FLog.to((String)"r01d.import").warning("Importando (" + contentOid + "-" + (content == null ? "null" : content.getInternalName()) + "): Error al cargar el contenido.");
            results[1].add(new R01MOperationInModelObjectResult(contentOid, 0, false, "Error al cargar el contenido " + (content == null ? "null" : content.getInternalName()) + ". " + "Error:" + e.getMessage()));
            operationHasErrors = true;
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info(">>>> Importando el contenido " + content.getInternalName());
        }
        List<R01MOperationInModelObjectResult> resultAux = null;
        if (!operationHasErrors && (resultAux = this._uploadContentFiles(content, effectiveImportRootDir)) != null && !resultAux.isEmpty()) {
            results[1].addAll(resultAux);
        }
        if (!operationHasErrors) {
            results[0].add(new R01MOperationInModelObjectResult(contentOid, 0, true, "El contenido " + content.getInternalName() + " se ha importado correctamente."));
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Importando (" + contentOid + "-" + content.getInternalName() + "): Fin de la importacion.");
        }
        return results;
    }

    private R01MDataStoreManager _obtainDataStoreManager() throws R01MDataStoreException, R01MDataStoreAuthenticationException {
        try {
            R01MDataStoreAuthObject authenticationObject = new R01MDataStoreAuthObject(R01MConstants.API_APPCODE);
            authenticationObject.fillAuthInfo(R01MConstants.API_APPCODE, this._userCtx);
            R01MDataStoreManager dsManager = (R01MDataStoreManager)ReflectionUtils.getObjectInstance((String)DATASTORE_MANAGER_CLASS_NAME);
            dsManager.doBeginSession(authenticationObject);
            R01FLog.to((String)"r01d.dataStoreManager").info("SESION DE USUARIO PARA ACCEDER AL GESTOR DE CONTENIDOS CREADA !!!!!");
            return dsManager;
        }
        catch (ReflectionException refEx) {
            throw new R01MDataStoreException("NO se ha podido instanciar el manager del DataStore con la clase " + DATASTORE_MANAGER_CLASS_NAME + ": " + refEx.getMessage(), (Exception)((Object)refEx));
        }
    }

    private List<R01MStructureCatalog> _obtainLabels(R01MContent sourceContent, List<R01MStructureCatalog> defaultLabels) {
        List<R01MStructureCatalog> labels = new ArrayList<R01MStructureCatalog>();
        if (defaultLabels != null && !defaultLabels.isEmpty()) {
            labels = defaultLabels;
        }
        if (sourceContent.getLabels() != null && !sourceContent.getLabels().isEmpty()) {
            for (R01MStructureCatalog contentLabel : sourceContent.getLabels()) {
                if (contentLabel == null) continue;
                boolean existLabel = false;
                try {
                    contentLabel.validateObject();
                    if (labels != null && !labels.isEmpty()) {
                        for (R01MStructureCatalog structureCatalog : labels) {
                            if (!structureCatalog.getOid().equals(contentLabel.getOid()) || !structureCatalog.getRole().equals(contentLabel.getRole()) || !structureCatalog.getStructureOid().equals(contentLabel.getStructureOid())) continue;
                            existLabel = true;
                            break;
                        }
                    }
                    if (existLabel) continue;
                    labels.add(contentLabel);
                }
                catch (R01MContentModelObjectsValidatorException ex) {}
            }
        }
        return labels;
    }

    private void _copyDataFilesFromDocumentFolderToDataStoreSystemFolder(R01MContent cont) throws R01MDataStoreException {
        if (cont.getDocuments() == null) {
            return;
        }
        for (R01MDocument currDoc : cont.getDocuments().values()) {
            if (currDoc.getDataFiles() == null) continue;
            for (R01MDataFile currDf : currDoc.getDataFiles().values()) {
                R01DContentInDataStore contInDs = new R01DContentInDataStore(this._userCtx, cont);
                contInDs.copyDataFileFromDocumentFolderToSystemArea(currDoc.getOid(), currDf.getOid());
            }
        }
    }

    private void _setContentDataFilesExtAttrs(R01MContent cont) throws R01MDataStoreException {
        if (cont.getDocuments() == null) {
            return;
        }
        for (R01MDocument currDoc : cont.getDocuments().values()) {
            if (currDoc.getDataFiles() == null) continue;
            for (R01MDataFile currDf : currDoc.getDataFiles().values()) {
                Properties properties = new Properties();
                String atributo = XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentServices/propertyTemplateArchive");
                String templateArchive = this._obtainDataCaptureTemplateName(cont.getStoreLocation(), cont.getTypo(), currDf.getTemplateOid());
                properties.put(atributo, templateArchive);
                try {
                    R01MContentDataAPI dataAPI = R01MClientFactory.getContentDataAPI((R01MUserContext)this._userCtx, (R01MContent)cont);
                    dataAPI.setDataFileAttributes(currDoc.getOid(), currDf.getOid(), properties);
                }
                catch (R01MSecurityException secEx) {
                    secEx.printStackTrace(System.out);
                }
                catch (R01MContentModelException cmEx) {
                    cmEx.printStackTrace(System.out);
                }
            }
        }
    }

    private String _obtainDataCaptureTemplateName(R01MContentLocation loc, R01MContentTypologyInfo typo, String templateOid) throws R01MDataStoreException {
        R01MContentTypeTemplateConfig templateConfig;
        try {
            R01MTypologyManagementConfigAPI typoMgmAPI = R01MClientFactory.getTypologyManagementConfigAPI();
            templateConfig = typoMgmAPI.getTemplateConfig(loc, typo, templateOid);
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            throw new R01MDataStoreException("No se puede cargar la ruta de la plantilla ", (Exception)((Object)cfgLoadEx));
        }
        return templateConfig != null ? templateConfig.getCategory() + "/" + templateConfig.getInternalName() : "";
    }

    private List<R01MOperationInModelObjectResult> _uploadDCRContentFiles(R01MContent content, String effectiveImportRootDir) {
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Importando (" + content.getOid() + "-" + content.getInternalName() + "): Upload de ficheros DCR...");
        }
        ArrayList<R01MOperationInModelObjectResult> results = new ArrayList<R01MOperationInModelObjectResult>();
        String contentRootDir = effectiveImportRootDir + PATHSEPARATOR + content.getInternalName();
        StringBuffer tmpLog = new StringBuffer();
        for (R01MDocument document : content.getDocuments().values()) {
            List dcrFiles = FileUtils.readDirFiles((String)(contentRootDir + PATHSEPARATOR + document.getLanguage() + "_" + document.getInternalName() + PATHSEPARATOR + "data"), (boolean)true, null);
            if (dcrFiles == null || dcrFiles.isEmpty()) continue;
            if (DEBUG) {
                tmpLog.setLength(0);
                tmpLog.append("Importando (");
                tmpLog.append(content.getOid());
                tmpLog.append('-');
                tmpLog.append(content.getInternalName());
                tmpLog.append("): Ficheros de datos DCR en directorio '");
                tmpLog.append(contentRootDir);
                tmpLog.append(PATHSEPARATOR);
                tmpLog.append(document.getLanguage());
                tmpLog.append('_');
                tmpLog.append(document.getInternalName());
                tmpLog.append(PATHSEPARATOR);
                tmpLog.append("data' :\n");
                Iterator itFiles = dcrFiles.iterator();
                while (itFiles.hasNext()) {
                    tmpLog.append("\n\tArchivo DCR:").append(itFiles.next());
                }
                R01FLog.to((String)"r01d.import").info(tmpLog.toString());
            }
            for (String filePath : dcrFiles) {
                if (DEBUG) {
                    R01FLog.to((String)"r01d.import").info("Importando (" + content.getOid() + "-" + content.getInternalName() + "): DCR encontrada para el archivo:" + filePath);
                }
                if (document.getDataFiles() == null || document.getDataFiles().isEmpty() || StringUtils.isEmptyString((String)filePath)) continue;
                try {
                    Properties properties = null;
                    Pattern p = Pattern.compile(".*(?:/|\\\\)(?!.*(?:/|\\\\).*)(?:[^_]*(?=_)_)?([^\\.]*)");
                    Matcher m = p.matcher(filePath);
                    if (!m.find() || StringUtils.isEmptyString((String)m.group(1))) continue;
                    String datafileNameOrOid = m.group(1);
                    if (document.getDataFileByName(datafileNameOrOid) != null || document.getDataFile(datafileNameOrOid) != null) {
                        if (DEBUG) {
                            R01FLog.to((String)"r01d.import").info("Importando (" + content.getOid() + "-" + content.getInternalName() + "): el archivo:" + filePath + " se identifica como un datafile");
                        }
                        R01MDataFile datafile = document.getDataFileByName(datafileNameOrOid) != null ? document.getDataFileByName(datafileNameOrOid) : document.getDataFile(datafileNameOrOid);
                        this.verifyXMLISOLatin1Head(filePath);
                        properties = new Properties();
                        String atributo = XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentServices/propertyTemplateArchive");
                        String templateArchive = this._obtainDataCaptureTemplateName(content, datafile.getTemplateOid());
                        properties.put(atributo, templateArchive);
                        this._dsMgr.doUpdateFile((R01MBaseLocationObject)content.getStoreLocation(), "templatedata" + PATHSEPARATOR + templateArchive + PATHSEPARATOR + "data" + PATHSEPARATOR + document.getLanguage() + "_" + datafile.getOid(), (InputStream)new FileInputStream(filePath), properties, true);
                        if (DEBUG) {
                            R01FLog.to((String)"r01d.import").info("Importando (" + content.getOid() + "-" + content.getInternalName() + "): " + "el archivo:" + filePath + " se ha subido a la carpeta templatedata: " + "templatedata" + PATHSEPARATOR + templateArchive + PATHSEPARATOR + "data" + PATHSEPARATOR + document.getLanguage() + "_" + datafile.getOid());
                        }
                        StringBuffer fileWorkAreaRelativePath = new StringBuffer(100);
                        fileWorkAreaRelativePath.append(content.getTypo().getTypeOid()).append(PATHSEPARATOR).append(content.getInternalName()).append(PATHSEPARATOR).append(document.getLanguage()).append('_').append(document.getInternalName()).append(PATHSEPARATOR).append("data").append(PATHSEPARATOR).append(document.getLanguage()).append("_").append(datafile.getOid());
                        this._dsMgr.doUpdateFile((R01MBaseLocationObject)content.getStoreLocation(), fileWorkAreaRelativePath.toString(), (InputStream)new FileInputStream(filePath), properties, true);
                        continue;
                    }
                    StringBuffer fileWorkAreaRelativePath = new StringBuffer(100);
                    fileWorkAreaRelativePath.append(content.getTypo().getTypeOid()).append(PATHSEPARATOR).append(content.getInternalName()).append(PATHSEPARATOR).append(document.getLanguage()).append('_').append(document.getInternalName()).append(PATHSEPARATOR).append("data").append(PATHSEPARATOR).append(filePath.substring(filePath.lastIndexOf(47) + 1));
                    this._dsMgr.doUpdateFile((R01MBaseLocationObject)content.getStoreLocation(), fileWorkAreaRelativePath.toString(), (InputStream)new FileInputStream(filePath), properties, true);
                    if (!DEBUG) continue;
                    R01FLog.to((String)"r01d.import").info("Importando (" + content.getOid() + "-" + content.getInternalName() + "): " + "el archivo:" + filePath + " (que no es datafile) se ha subido a la carpeta data del documento correspondiente: " + fileWorkAreaRelativePath);
                }
                catch (Exception ex) {
                    R01FLog.to((String)"r01d.import").warning("Importando (" + content.getOid() + "-" + content.getInternalName() + "): Error al subir el adjunto:" + filePath);
                    results.add(new R01MOperationInModelObjectResult(document.getOid(), 1, false, "Error al subir el archivo " + filePath + " al datastore.Error:" + ex.getMessage()));
                }
            }
        }
        return results;
    }

    private String _obtainDataCaptureTemplateName(R01MContent content, String templateOid) throws R01MDataStoreException {
        R01MContentTypeTemplateConfig templateConfig;
        try {
            R01MTypologyManagementConfigAPI typoMgmAPI = R01MClientFactory.getTypologyManagementConfigAPI();
            templateConfig = typoMgmAPI.getTemplateConfig(content.getStoreLocation(), content.getTypo(), templateOid);
        }
        catch (R01MConfigLoadException cfgLoadEx) {
            throw new R01MDataStoreException("No se puede cargar la ruta de la plantilla ", (Exception)((Object)cfgLoadEx));
        }
        return templateConfig != null ? templateConfig.getCategory() + "/" + templateConfig.getInternalName() : "";
    }

    private List<R01MOperationInModelObjectResult> _uploadContentFiles(R01MContent content, String effectiveImportRootDir) {
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Importando (" + content.getOid() + "-" + content.getInternalName() + "): Upload de ficheros adjuntos...");
        }
        String contentRootDir = effectiveImportRootDir + PATHSEPARATOR + content.getInternalName();
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Importando (" + content.getOid() + "-" + content.getInternalName() + "): Cargar archivos en el directorio " + contentRootDir);
        }
        R01MContentDataAPI contentDataAPI = R01MClientFactory.getContentDataAPI((R01MUserContext)this._userCtx, (String)content.getOid());
        ArrayList<R01MOperationInModelObjectResult> results = new ArrayList<R01MOperationInModelObjectResult>();
        StringBuffer tmpLog = new StringBuffer();
        for (R01MDocument document : content.getDocuments().values()) {
            List files;
            List excludeDirs = null;
            if (DEBUG) {
                R01FLog.to((String)"r01d.import").info("Importando (" + content.getOid() + "-" + content.getInternalName() + "): Cargar archivos en el directorio " + contentRootDir + PATHSEPARATOR + document.getLanguage() + "_" + document.getInternalName());
            }
            if ((files = FileUtils.readDirFiles((String)(contentRootDir + PATHSEPARATOR + document.getLanguage() + '_' + document.getInternalName()), (boolean)true, excludeDirs)) != null && !files.isEmpty()) {
                if (DEBUG) {
                    tmpLog.setLength(0);
                    tmpLog.append("Importando (");
                    tmpLog.append(content.getOid());
                    tmpLog.append('-');
                    tmpLog.append(content.getInternalName());
                    tmpLog.append("): Ficheros adjuntos en directorio '");
                    tmpLog.append(contentRootDir);
                    tmpLog.append(PATHSEPARATOR);
                    tmpLog.append(document.getLanguage());
                    tmpLog.append('_');
                    tmpLog.append(document.getInternalName());
                    tmpLog.append("' excepto los directorios 'data':\n");
                    Iterator itFiles = files.iterator();
                    while (itFiles.hasNext()) {
                        tmpLog.append("\n\tArchivo:").append((String)itFiles.next());
                    }
                    R01FLog.to((String)"r01d.import").info(tmpLog.toString());
                }
                String documentDir = document.getLanguage() + "_" + document.getInternalName();
                for (String fileAbsolutePath : files) {
                    if (DEBUG) {
                        R01FLog.to((String)"r01d.import").info("Importando (" + content.getOid() + "-" + content.getInternalName() + "): Subiendo el archivo " + fileAbsolutePath + " al directorio " + documentDir);
                    }
                    try {
                        this.uploadContentFile(contentDataAPI, content, (R01MBaseDocumentInterface)document, documentDir, fileAbsolutePath);
                    }
                    catch (Exception ex) {
                        results.add(new R01MOperationInModelObjectResult(document.getOid(), 1, false, "Error al subir el archivo " + fileAbsolutePath + " al datastore.Error:" + ex.getMessage()));
                    }
                }
                continue;
            }
            if (!DEBUG) continue;
            R01FLog.to((String)"r01d.import").info("Importando (" + content.getOid() + "-" + content.getInternalName() + "): No se han encontrado archivos para subir .... ");
        }
        return results;
    }

    private void uploadContentFile(R01MContentDataAPI contentDataAPI, R01MContent content, R01MBaseDocumentInterface document, String documentDir, String fileAbsolutePath) throws Exception {
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Importando (" + content.getOid() + "-" + content.getInternalName() + "): UPLOAD FILE .............");
        }
        int index = fileAbsolutePath.lastIndexOf(PATHSEPARATOR + content.getInternalName() + PATHSEPARATOR + documentDir);
        String documentRelativePath = "";
        if (index != -1) {
            documentRelativePath = fileAbsolutePath.substring(index + (PATHSEPARATOR + content.getInternalName() + PATHSEPARATOR + documentDir).length());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Importando (" + content.getOid() + "-" + content.getInternalName() + "): Subir archivo en el directorio del documento " + documentRelativePath);
        }
        if (!StringUtils.isEmptyString((String)documentRelativePath)) {
            if (DEBUG) {
                R01FLog.to((String)"r01d.import").info("Importando (" + content.getOid() + "-" + content.getInternalName() + "): Subir el adjunto:" + documentRelativePath);
            }
            try {
                contentDataAPI.uploadAttachmentFile(document.getOid(), documentRelativePath, (InputStream)new FileInputStream(fileAbsolutePath));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                R01FLog.to((String)"r01d.import").warning("Importando (" + content.getOid() + "-" + content.getInternalName() + "): Error al subir el adjunto:" + documentRelativePath);
                throw ex;
            }
        }
    }

    private List<R01MOperationInModelObjectResult> _uploadContentDirectories(R01MContent content, String effectiveImportRootDir) {
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Importando (" + content.getOid() + "-" + content.getInternalName() + "): Upload de ficheros adjuntos...");
        }
        String contentRootDir = effectiveImportRootDir + PATHSEPARATOR + content.getInternalName();
        ArrayList<R01MOperationInModelObjectResult> results = new ArrayList<R01MOperationInModelObjectResult>();
        DirectoryExtractor dirExtract = new DirectoryExtractor(contentRootDir);
        Collection allNotDocumentFilesAndDirs = dirExtract.getFilesAndDirectories((FileFilter)new R01DContentResourcesFileFilter(contentRootDir));
        ArrayList<String> contentDirs = new ArrayList<String>();
        R01DContentInDataStore contentInDataStore = new R01DContentInDataStore(this._userCtx, content);
        for (File currFile : allNotDocumentFilesAndDirs) {
            if (contentRootDir.length() >= currFile.getAbsolutePath().length()) continue;
            String contentRelativePathAndFileName = currFile.getAbsolutePath().substring(contentRootDir.length() + 1);
            if (currFile.isFile()) {
                try {
                    contentInDataStore.uploadFileInContent(contentRelativePathAndFileName, (InputStream)new FileInputStream(currFile));
                }
                catch (R01MDataStoreException dsEx) {
                    R01FLog.to((String)"r01d.import").warning("Error al subir el archivo " + currFile.getAbsolutePath() + " al contenido " + content.getOid() + ": " + dsEx.getMessage());
                }
                catch (FileNotFoundException fnfEx) {
                    R01FLog.to((String)"r01d.import").warning("El archivo " + currFile.getAbsolutePath() + " no existe. Error: " + fnfEx.getMessage());
                }
                continue;
            }
            if (!currFile.isDirectory() || StringUtils.isEmptyString((String)contentRelativePathAndFileName)) continue;
            contentDirs.add(contentRelativePathAndFileName);
            try {
                contentInDataStore.createContentDir(contentRelativePathAndFileName);
            }
            catch (R01MDataStoreException dsEx) {
                R01FLog.to((String)"r01d.import").warning("El directorio " + currFile.getAbsolutePath() + " no se puede crear. Error: " + dsEx.getMessage());
            }
        }
        return results;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private R01MOperationInModelObjectResult _publishContent(boolean publishContent, String contentOid, String contentInternalName, R01MContentModelAPI contentAPI) {
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Importando (" + contentOid + "-" + contentInternalName + "): Procesando la publicacion o indexacion .....");
        }
        if (publishContent) {
            R01MContent r01MContent;
            if (DEBUG) {
                R01FLog.to((String)"r01d.import").info("Importando (" + contentOid + "-" + contentInternalName + "): Publicando los documentos del contenido .....");
            }
            try {
                if (this._userCtx == null) {
                    return new R01MOperationInModelObjectResult(contentOid, 0, false, "No se tiene contexto de usuario.");
                }
                r01MContent = R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).loadContent(contentOid);
            }
            catch (Exception ex) {
                R01FLog.to((String)"r01d.import").severe("Error al cargar el contenido de identificador " + contentOid + ".Error:" + ex.getMessage());
                return new R01MOperationInModelObjectResult(contentOid, 0, false, "NO se ha podido cargar el contenido " + contentOid + ".Error: " + ex.getMessage());
            }
            if (r01MContent != null && r01MContent.getDocuments() != null && !r01MContent.getDocuments().isEmpty()) {
                R01MPublicationConfig pub;
                ArrayList<String> documentOids = new ArrayList<String>();
                for (R01MDocument currDoc : r01MContent.getDocuments().values()) {
                    documentOids.add(currDoc.getOid());
                }
                try {
                    pub = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(r01MContent.getStoreLocation().getWorkAreaOid()).getAllowedPublicationTargetsConfig();
                }
                catch (R01MConfigLoadException cfgExc) {
                    R01FLog.to((String)"r01d.import").severe("Error al obtener los repositorios de publicaci\u00f3n de la workarea. Los documentos del contenido " + contentOid + " " + "no se publican. Error: " + cfgExc.getMessage());
                    return new R01MOperationInModelObjectResult(contentOid, 0, false, "Error al obtener los repositorios de publicaci\u00f3n de la workarea. Los documentos del contenido " + contentOid + " no se publican. " + "Error: " + cfgExc.getMessage());
                }
                try {
                    if (pub.getAllowedTargets() == null || pub.getAllowedTargets().isEmpty()) return null;
                    for (String repository : pub.getAllowedTargets().keySet()) {
                        Calendar launchTime = Calendar.getInstance();
                        launchTime.add(13, 15);
                        contentAPI.publishDocuments(documentOids, 1, launchTime.getTime(), repository);
                    }
                    return null;
                }
                catch (Exception ex) {
                    R01FLog.to((String)"r01d.import").warning("Importando (" + contentOid + "-" + contentInternalName + "): Error al publicar los documentos.Error:" + ex.getMessage());
                    return new R01MOperationInModelObjectResult(contentOid, 0, false, "Error al publicar los documentos del contenido.Error:" + ex.getMessage());
                }
            }
            if (!DEBUG) return null;
            R01FLog.to((String)"r01d.import").info("R01DContentImportHelper._publishContent >> El contenido con oid " + contentOid + " no tiene ning\u00fan documento por lo que no se realiza ninguna acci\u00f3n");
            return null;
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Importando (" + contentOid + "-" + contentInternalName + "): Los documentos del contenido no se publican, solamente seran indexados .....");
        }
        ArrayList arrayList = new ArrayList();
        List list = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/default/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer"));
        R01MIndexDefinition indexDefinition = new R01MIndexDefinition(0, contentOid, 0, null, list, false, -1, null, null, null);
        R01DIndexerHelper.doIndexObject(indexDefinition);
        return null;
    }

    private boolean _importNewContent(R01MContentModelAPI contentAPI, R01MContent sourceContent, String contentInternalName, R01MContentLocation loc, R01MContentTypologyInfo typo, String effectiveImportRootDir, List<R01MOperationInModelObjectResult>[] results, boolean keepOidsValue) throws R01MSecurityException, R01MContentModelException {
        Map documents;
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Importando (" + sourceContent.getInternalName() + "): El contenido es nuevo.");
        }
        sourceContent.setStoreLocation(loc);
        sourceContent.setTypo(typo);
        sourceContent.setInternalName(contentInternalName);
        if (!keepOidsValue) {
            try {
                sourceContent.setOid(R01MUtils.generateNewOid((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"content"));
            }
            catch (GUIDDispenserException ex) {
                ex.printStackTrace(System.out);
                results[1].add(new R01MOperationInModelObjectResult(sourceContent.getOid(), 0, false, "Error al crear un identificador para el contenido " + contentInternalName + ".Error:" + ex.getMessage()));
            }
        }
        List<R01MStructureCatalog> labels = null;
        try {
            labels = this._obtainLabels(sourceContent, contentAPI.getDefaultLabels(loc, typo));
        }
        catch (R01MContentModelException catExc) {
            R01FLog.to((String)"r01d.import").warning("Error al catalogar el contenido " + contentInternalName + "Error:" + catExc.getMessage());
        }
        if (labels != null && !labels.isEmpty()) {
            sourceContent.setLabels(labels);
        }
        if ((documents = sourceContent.getDocuments()) != null && !documents.isEmpty()) {
            HashMap<String, R01MDocument> auxDocuments = new HashMap<String, R01MDocument>();
            for (R01MDocument document : documents.values()) {
                if (!keepOidsValue) {
                    try {
                        document.setOid(R01MUtils.generateNewOid((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"content"));
                    }
                    catch (GUIDDispenserException guidDispEx) {
                        guidDispEx.printStackTrace(System.out);
                        results[1].add(new R01MOperationInModelObjectResult(document.getOid(), 0, false, "Error al crear un identificador para el documento del contenido " + contentInternalName + ".Error:" + guidDispEx.getMessage()));
                        break;
                    }
                }
                document.setPublicationInfo(new ArrayList());
                document.setRequestedPublications(new HashMap());
                Map datafiles = document.getDataFiles();
                if (datafiles != null && !datafiles.isEmpty()) {
                    HashMap<String, R01MDataFile> auxDataFiles = new HashMap<String, R01MDataFile>();
                    for (R01MDataFile datafile : datafiles.values()) {
                        if (!keepOidsValue) {
                            try {
                                datafile.setOid(R01MUtils.generateNewOid((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"content"));
                            }
                            catch (GUIDDispenserException guidDispEx) {
                                guidDispEx.printStackTrace(System.out);
                                results[1].add(new R01MOperationInModelObjectResult(datafile.getOid(), 0, false, "Error al crear un identificador para el archivo del contenido " + contentInternalName + ".Error:" + guidDispEx.getMessage()));
                                break;
                            }
                        }
                        auxDataFiles.put(datafile.getOid(), datafile);
                    }
                    if (results[1] != null && !results[1].isEmpty()) break;
                    document.setDataFiles(auxDataFiles);
                }
                auxDocuments.put(document.getOid(), document);
            }
            if (results[1] == null || results[1].isEmpty()) {
                sourceContent.setDocuments(auxDocuments);
                sourceContent = this._resetUrlDatafile(sourceContent);
            }
        }
        if (results[1] == null || results[1].isEmpty()) {
            if (DEBUG) {
                R01FLog.to((String)"r01d.import").info("Importando (" + sourceContent.getInternalName() + "): Se guarda con el identificador '" + sourceContent.getOid() + "'.");
            }
            List<R01MOperationInModelObjectResult> resultAux = null;
            try {
                resultAux = this._uploadDCRContentFiles(sourceContent, effectiveImportRootDir);
                contentAPI.saveContent(sourceContent);
                if (DEBUG) {
                    R01FLog.to((String)"r01d.import").info("Importando (" + sourceContent.getInternalName() + "): Subir adjuntos.");
                }
                if ((resultAux = this._uploadContentFiles(sourceContent, effectiveImportRootDir)) != null && !resultAux.isEmpty()) {
                    results[1].addAll(resultAux);
                }
                if ((resultAux = this._uploadContentDirectories(sourceContent, effectiveImportRootDir)) != null && !resultAux.isEmpty()) {
                    results[1].addAll(resultAux);
                }
            }
            catch (Exception e) {
                results[1].add(new R01MOperationInModelObjectResult(sourceContent.getOid(), 0, false, "Error al guardar el contenido " + contentInternalName + "Error:" + ExceptionUtils.serializeExceptionStackTrace((Throwable)e)));
            }
        }
        return results[1] != null && !results[1].isEmpty();
    }

    private R01MContent _resetUrlDatafile(R01MContent sourceContent) {
        R01MContent content = sourceContent;
        for (R01MDocument document : content.getDocuments().values()) {
            if (document.getDataFiles() == null || document.getDataFiles().isEmpty()) continue;
            for (R01MDataFile datafile : document.getDataFiles().values()) {
                datafile.setEditUrl(null);
                datafile.setGenerateUrl(null);
                datafile.setPreviewUrl(null);
                try {
                    R01MContentModelObjectsValidator.validateDataFile((R01MContent)content, (String)document.getOid(), (String)datafile.getOid());
                }
                catch (R01MContentModelObjectsValidatorException ex) {}
            }
        }
        return content;
    }

    private boolean _updateContent(R01MContentModelAPI contentAPI, R01MContent sourceContent, R01MContent searchedContent, String effectiveImportRootDir, List<R01MOperationInModelObjectResult>[] results) throws R01MSecurityException, R01MContentModelException {
        Map documents;
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Importando (" + searchedContent.getOid() + "-" + searchedContent.getInternalName() + "): El contenido se actualiza.");
        }
        searchedContent.setChargePerson(sourceContent.getChargePerson());
        searchedContent.setDescription(sourceContent.getDescription());
        searchedContent.setCreateDate(sourceContent.getCreateDate());
        searchedContent.setNewnessUntilDate(sourceContent.getNewnessUntilDate());
        List<R01MStructureCatalog> labels = null;
        try {
            labels = this._obtainLabels(sourceContent, contentAPI.getDefaultLabels(searchedContent.getStoreLocation(), searchedContent.getTypo()));
        }
        catch (R01MContentModelException catExc) {
            R01FLog.to((String)"r01d.import").warning("Error al catalogar el contenido " + searchedContent.getInternalName() + "Error:" + catExc.getMessage());
        }
        if (labels != null && !labels.isEmpty()) {
            searchedContent.setLabels(labels);
        }
        if ((documents = sourceContent.getDocuments()) != null && !documents.isEmpty()) {
            if (DEBUG) {
                R01FLog.to((String)"r01d.import").info("Importando (" + searchedContent.getOid() + "-" + searchedContent.getInternalName() + "): Identificando documentos nuevos y eliminados.");
            }
            HashMap<String, R01MDocument> auxDocuments = new HashMap<String, R01MDocument>();
            R01MDocument documentSearched2 = null;
            for (R01MDocument document : documents.values()) {
                Map datafiles;
                boolean bExistsDocument = false;
                if (searchedContent.getDocuments() != null && !searchedContent.getDocuments().isEmpty()) {
                    for (R01MDocument documentSearched2 : searchedContent.getDocuments().values()) {
                        if (!document.getInternalName().equals(documentSearched2.getInternalName()) || !document.getLanguage().equals(documentSearched2.getLanguage())) continue;
                        bExistsDocument = true;
                        break;
                    }
                }
                document.setPublicationInfo(new ArrayList());
                document.setRequestedPublications(new HashMap());
                if (bExistsDocument) {
                    document.setOid(documentSearched2.getOid());
                    R01MContentDataAPI contentData = new R01MContentDataAPI(this._userCtx, searchedContent.getOid());
                    R01MRawDataAPI rawData = new R01MRawDataAPI(this._userCtx);
                    R01MDataStoreItem[] files = contentData.getDocumentFolderContents(document.getOid(), "", true);
                    for (int i = 0; i < files.length; ++i) {
                        try {
                            if (!rawData.checkFile(files[i].getLocationBasePath(), files[i].getWorkAreaRelativePath()) || files[i].getWorkAreaRelativePath().indexOf("/r01Index/") != -1) continue;
                            rawData.deleteFile(files[i].getLocationBasePath(), files[i].getWorkAreaRelativePath(), true);
                            continue;
                        }
                        catch (R01MDataStoreException ex) {
                            R01FLog.to((String)"r01d.import").warning("Error al borrar el fichero: " + files[i].getLocationBasePath() + files[i].getWorkAreaRelativePath() + ".Error:" + ex.getMessage());
                        }
                    }
                } else {
                    try {
                        document.setOid(R01MUtils.generateNewOid((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"content"));
                    }
                    catch (GUIDDispenserException guidDispEx) {
                        R01FLog.to((String)"r01d.import").warning("Importando (" + searchedContent.getOid() + "-" + searchedContent.getInternalName() + "): Error al asignar un identificador al documento " + document.getInternalName() + ".");
                        results[1].add(new R01MOperationInModelObjectResult(document.getOid(), 0, false, "Error al crear un identificador para el documento del contenido " + searchedContent.getInternalName() + ".Error:" + guidDispEx.getMessage()));
                        break;
                    }
                    if (DEBUG) {
                        R01FLog.to((String)"r01d.import").info("Importando (" + searchedContent.getOid() + "-" + searchedContent.getInternalName() + "): Encontrado un documento nuevo " + document.getInternalName() + " se crea el identificador " + document.getOid());
                    }
                }
                if ((datafiles = document.getDataFiles()) != null && !datafiles.isEmpty()) {
                    HashMap<String, R01MDataFile> auxDataFiles = new HashMap<String, R01MDataFile>();
                    for (R01MDataFile datafile : datafiles.values()) {
                        try {
                            boolean bExistsDatafile = false;
                            R01MDataFile dataFileSearched2 = null;
                            if (bExistsDocument) {
                                for (R01MDataFile dataFileSearched2 : documentSearched2.getDataFiles().values()) {
                                    if (!datafile.getName().equals(dataFileSearched2.getName())) continue;
                                    bExistsDatafile = true;
                                    break;
                                }
                            }
                            if (bExistsDatafile) {
                                datafile.setOid(dataFileSearched2.getOid());
                            } else {
                                datafile.setOid(R01MUtils.generateNewOid((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"content"));
                            }
                            auxDataFiles.put(datafile.getOid(), datafile);
                        }
                        catch (GUIDDispenserException guidDispEx) {
                            R01FLog.to((String)"r01d.import").warning("Importando (" + searchedContent.getOid() + "-" + searchedContent.getInternalName() + "): Error al asignar un identificador al archivo " + datafile.getInternalName() + ".");
                            results[1].add(new R01MOperationInModelObjectResult(datafile.getOid(), 0, false, "Error al crear un identificador para el archivo del contenido " + searchedContent.getInternalName() + ".Error:" + guidDispEx.getMessage()));
                            break;
                        }
                    }
                    if (results[1] != null && !results[1].isEmpty()) break;
                    document.setDataFiles(auxDataFiles);
                }
                auxDocuments.put(document.getOid(), document);
            }
            if (results[1] == null || results[1].isEmpty()) {
                sourceContent.setDocuments(auxDocuments);
                sourceContent.setStoreLocation(searchedContent.getStoreLocation());
                sourceContent.setTypo(searchedContent.getTypo());
                sourceContent = this._resetUrlDatafile(sourceContent);
            }
        }
        if (results[1] == null || results[1].isEmpty()) {
            searchedContent.setDocuments(sourceContent.getDocuments());
            if (DEBUG) {
                R01FLog.to((String)"r01d.import").info("Importando (" + searchedContent.getOid() + "-" + searchedContent.getInternalName() + "): Actualizando el contenido.");
            }
            List<R01MOperationInModelObjectResult> resultAux = null;
            try {
                resultAux = this._uploadDCRContentFiles(sourceContent, effectiveImportRootDir);
                contentAPI.saveContent(searchedContent);
                if (DEBUG) {
                    R01FLog.to((String)"r01d.import").info("Importando (" + searchedContent.getOid() + "-" + searchedContent.getInternalName() + "): Subiendo los archivos adjuntos.");
                }
                if ((resultAux = this._uploadContentFiles(searchedContent, effectiveImportRootDir)) != null && !resultAux.isEmpty()) {
                    results[1].addAll(resultAux);
                }
                if ((resultAux = this._uploadContentDirectories(sourceContent, effectiveImportRootDir)) != null && !resultAux.isEmpty()) {
                    results[1].addAll(resultAux);
                }
            }
            catch (Exception e) {
                R01FLog.to((String)"r01d.import").warning("Importando (" + searchedContent.getOid() + "-" + searchedContent.getInternalName() + "): Error al actualizar el contenido.");
                results[1].add(new R01MOperationInModelObjectResult(searchedContent.getOid(), 0, false, "Error al guardar el contenido " + searchedContent.getInternalName() + "Error:" + e.getMessage()));
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Importando (" + searchedContent.getOid() + "-" + searchedContent.getInternalName() + "): Fin de la importacion.");
        }
        return results[1] != null && !results[1].isEmpty();
    }

    private boolean _deleteContent(R01MContent searchedContent, List<R01MOperationInModelObjectResult>[] results) {
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Importando (" + searchedContent.getOid() + "-" + searchedContent.getInternalName() + "): El contenido ser\u00e1 borrado.");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Importando (" + searchedContent.getOid() + "-" + searchedContent.getInternalName() + "): Eliminar el contenido");
        }
        try {
            this._cmManager.doForceDeleteContent(this._userCtx, searchedContent.getOid());
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01d.import").warning("Importando (" + searchedContent.getOid() + "-" + searchedContent.getInternalName() + "): Error al eliminar el contenido " + searchedContent.getOid() + ". Mensaje: " + ex.getMessage());
            results[1].add(new R01MOperationInModelObjectResult(searchedContent.getOid(), 0, false, "Error al eliminar el contenido " + searchedContent.getOid() + ".Error:" + ex.getMessage()));
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Importando (" + searchedContent.getOid() + "-" + searchedContent.getInternalName() + "): Fin del borrado del contenido.");
        }
        return results[1] != null && !results[1].isEmpty();
    }

    private List<R01MOperationInModelObjectResult> _prepareDCRFiles(R01MContent content, String effectiveImportRootDir) {
        ArrayList<R01MOperationInModelObjectResult> results = new ArrayList<R01MOperationInModelObjectResult>();
        String contentRootDir = effectiveImportRootDir + PATHSEPARATOR + content.getInternalName();
        if (content.getDocuments() != null && !content.getDocuments().isEmpty()) {
            for (R01MDocument document : content.getDocuments().values()) {
                List dcrFiles = FileUtils.readDirFiles((String)(contentRootDir + PATHSEPARATOR + document.getLanguage() + "_" + document.getInternalName() + PATHSEPARATOR + "data"), (boolean)true, null);
                if (dcrFiles == null || dcrFiles.isEmpty() || document.getDataFiles() == null || document.getDataFiles().isEmpty()) continue;
                block3: for (R01MDataFile datafile : document.getDataFiles().values()) {
                    for (String filePath : dcrFiles) {
                        if (!filePath.endsWith(document.getLanguage() + "_" + datafile.getOid())) continue;
                        try {
                            FileUtils.renameFile((String)filePath, (String)(contentRootDir + PATHSEPARATOR + document.getLanguage() + "_" + document.getInternalName() + PATHSEPARATOR + "data" + PATHSEPARATOR + document.getLanguage() + "_" + datafile.getInternalName() + ".xml"));
                            continue block3;
                        }
                        catch (Exception ex) {
                            R01FLog.to((String)"r01d.import").warning("Importando (" + content.getOid() + "-" + content.getInternalName() + "): Error al renomobrar el fichero DCR:" + filePath);
                            results.add(new R01MOperationInModelObjectResult(document.getOid(), 1, false, "Error al renomobrar el fichero DCR:" + filePath + ".Error:" + ex.getMessage()));
                        }
                    }
                }
            }
        }
        return results;
    }

    private void verifyXMLISOLatin1Head(String filePath) {
        try {
            String sDcr = org.apache.commons.io.FileUtils.readFileToString((File)new File(filePath));
            if (!(StringUtils.isEmptyString((String)sDcr) || sDcr.trim().startsWith("<?xml") || sDcr.trim().startsWith("<?XML"))) {
                sDcr = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n" + sDcr;
                org.apache.commons.io.FileUtils.writeStringToFile((File)new File(filePath), (String)sDcr);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }
}

