/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services.helpers;

import com.ejie.r01d.datastore.R01DOpenDataFilter;
import com.ejie.r01d.datastore.R01DPublishedDocumentDataStoreItemFilter;
import com.ejie.r01d.services.R01DContentModelManager;
import com.ejie.r01d.services.helpers.R01DContentStoreZipFileInfo;
import com.ejie.r01f.file.FileUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.ArrayUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.publisher.R01MLogicalPublicationInfo;
import com.ejie.r01m.config.objects.publisher.R01MPublicationConfig;
import com.ejie.r01m.config.objects.typology.R01MContentType;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.datastore.R01MDataStoreAuthObject;
import com.ejie.r01m.datastore.R01MDataStoreItemFilter;
import com.ejie.r01m.datastore.R01MDataStoreManager;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MDataStoreAuthenticationException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.datastore.R01MDataStoreItem;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.objects.searchengine.query.R01MSearchedPublishRepository;
import com.ejie.r01m.objects.searchengine.results.R01MSearchResultItem;
import com.ejie.r01m.objects.searchengine.session.R01MSearchSession;
import com.ejie.r01m.searchengine.servlet.R01MSearchEngineWebConstants;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MRawDataAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MPathHelpper;
import com.ejie.r01m.utils.jms.R01MJMSUtils;
import com.ejie.r01m.utils.jms.R01MJmsQueueParam;
import com.ejie.r01m.utils.searchengine.R01MSearchEngineUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class R01DContentExportHelper {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.import").intValue() != Level.OFF.intValue();
    private static final String DATASTORE_MANAGER_CLASS_NAME = XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"dataStoreManager/implClassName");
    private static final String DESTINATION_EXPORT_FILE = XMLProperties.get((String)R01MConstants.SYSTEMADMINISTRATION_APPCODE, (String)"uploadServlet/digesters/digester[@id='importFileContentsDigester']/config/dir", (String)"/datos/r01nt/file/import/");
    private static final String NEW_LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String COMMENT_DESTINATION_FILE = "# Ubicacion en la que se deja el empaquetado zip a generar.";
    private static final String COMMENT_ORIGIN_FILES = "# Ubicacion donde estan los ficheros zip a empaquetar.";
    private static final String PATH_SLASH_SEPARATOR = "/";
    private static final String OPENDATA_FOLDER = "opendata";
    private static final String EXTENSION_ZIP_FILE = ".zip";
    private static final String EXTENSION_TEXT_FILE = ".txt";
    private static final String FILE_WITHOUT_ATTACHMENTS = "_thin";
    private static final String SYSTEMSERVER_CONFIGS_LOCATION = XMLProperties.get((String)R01MConstants.SYSTEMADMINISTRATION_APPCODE, (String)"storageConfigServer/systemServerOid");
    private static final String SYSTEMDATASTORE_CONFIGS_LOCATION = XMLProperties.get((String)R01MConstants.SYSTEMADMINISTRATION_APPCODE, (String)"storageConfigServer/systemDataStoreOid");
    private static final String SYSTEMAREA_CONFIGS_LOCATION = XMLProperties.get((String)R01MConstants.SYSTEMADMINISTRATION_APPCODE, (String)"storageConfigServer/systemAreaOid");
    private static final String SYSTEMWORKAREA_CONFIGS_LOCATION = XMLProperties.get((String)R01MConstants.SYSTEMADMINISTRATION_APPCODE, (String)"storageConfigServer/systemWorkAreaOid");
    private static final String FOLDER_AVCOMUN_EXEC_R01PACKAGEZIP = XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"openDataScheduled/fileList/destinationFolder");
    private R01MUserContext _userCtx;
    private R01MDataStoreManager _dsMgr;
    private R01DContentModelManager _cmManager;

    public R01DContentExportHelper(R01MUserContext userCtx, R01DContentModelManager mgr) {
        this._userCtx = userCtx;
        this._cmManager = mgr;
    }

    public void doExportContentToFile(String contentOid) throws R01MContentModelException {
        R01MDataStoreItem[] notAttachmentsFiles;
        R01MDataStoreItem[] allFiles;
        R01MContent content;
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Creando un empaquetado del contenido " + contentOid);
        }
        try {
            content = this._cmManager.doLoadContent(this._userCtx, contentOid);
        }
        catch (R01MContentModelException cmEx) {
            R01FLog.to((String)"r01d.import").severe("No se ha podido cargar el contenido " + contentOid + ".Error:" + cmEx.getMessage());
            throw cmEx;
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Creando un archivo empaquetado del contenido denominado " + DESTINATION_EXPORT_FILE + content.getName() + EXTENSION_ZIP_FILE);
        }
        if (this._dsMgr == null) {
            this.instantiateDataStoreManager();
        }
        String contentWARelPath = R01MPathHelpper.getContentWorkAreaRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)contentOid, (String)content.getInternalName(), (String)content.getName());
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Obtener los archivos del directorio " + contentWARelPath + " alojado en " + content.getStoreLocation().composeMemoCode());
        }
        R01DPublishedDocumentDataStoreItemFilter filterPublishedDocuments = null;
        R01DPublishedDocumentDataStoreItemFilter filterPubDocsAndAttachments = null;
        if (content.getDocuments() != null && !content.getDocuments().isEmpty()) {
            List opendataDirsExcluded;
            R01MPublicationConfig pub;
            ArrayList<String> notPublishedDocuments = new ArrayList<String>();
            try {
                pub = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(content.getStoreLocation().getWorkAreaOid()).getAllowedPublicationTargetsConfig();
            }
            catch (R01MConfigLoadException cfgExc) {
                R01FLog.to((String)"r01d.publisherManager").severe("Error al obtener los repositorios de publicaci\u00f3n de la workarea, los documentos del contenido " + content.getOid() + " no se publican.Error:" + cfgExc.getMessage());
                throw new R01MContentModelException("Error al obtener los repositorios de publicaci\u00f3n de la workarea, los documentos del contenido " + content.getOid() + " no se publican.", (Exception)((Object)cfgExc));
            }
            if (pub.getAllowedTargets() != null && !pub.getAllowedTargets().isEmpty()) {
                for (R01MDocument currDocument : content.getDocuments().values()) {
                    boolean isDocPublished = false;
                    for (String targetRepOid : pub.getAllowedTargets().keySet()) {
                        if (!this._cmManager.isDocumentPublished(this._userCtx, targetRepOid, currDocument.getOid())) continue;
                        isDocPublished = true;
                        break;
                    }
                    if (isDocPublished) continue;
                    notPublishedDocuments.add(currDocument.getLanguage() + "_" + currDocument.getInternalName());
                }
            }
            if ((opendataDirsExcluded = XMLProperties.getPropertyList((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentServices/contentDirectories/opendata/excludedPaquetRispDirs/dirExcluded")) != null && !opendataDirsExcluded.isEmpty()) {
                Iterator itDirs = opendataDirsExcluded.iterator();
                while (itDirs.hasNext()) {
                    notPublishedDocuments.add((String)itDirs.next());
                }
            }
            filterPublishedDocuments = new R01DPublishedDocumentDataStoreItemFilter(content.getInternalName(), notPublishedDocuments, true);
            filterPubDocsAndAttachments = new R01DPublishedDocumentDataStoreItemFilter(content.getInternalName(), notPublishedDocuments, false);
        }
        R01DOpenDataFilter openDataFilter = null;
        try {
            R01MContentType typeObj = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(content.getTypo().getClusterOid(), content.getTypo().getFamilyOid(), content.getTypo().getTypeOid());
            List filters = null;
            if (null != typeObj.getOpendata()) {
                filters = typeObj.getOpendata().getExcludeFilters();
            }
            openDataFilter = new R01DOpenDataFilter(filters);
        }
        catch (R01MConfigLoadException cfgExc) {
            R01FLog.to((String)"r01d.publisherManager").severe("Error al obtener la configuracion para R01DOpenDataFilter" + content.getOid() + ". Error:" + cfgExc.getMessage());
        }
        try {
            allFiles = this._dsMgr.doGetFolderContents((R01MBaseLocationObject)content.getStoreLocation(), contentWARelPath, true, filterPublishedDocuments, null);
            allFiles = this.checkFilters(allFiles, openDataFilter);
            notAttachmentsFiles = this._dsMgr.doGetFolderContents((R01MBaseLocationObject)content.getStoreLocation(), contentWARelPath, true, (R01MDataStoreItemFilter)filterPubDocsAndAttachments, null);
        }
        catch (R01MDataStoreException dsEx) {
            R01FLog.to((String)"r01d.import").severe("Error al obtener los archivos del directorio " + contentWARelPath + " alojado en " + content.getStoreLocation().composeMemoCode() + ".Error:" + dsEx.getMessage());
            throw new R01MContentModelException("Error al obtener los archivos del directorio " + contentWARelPath + " alojado en " + content.getStoreLocation().composeMemoCode() + ".", (Exception)((Object)dsEx));
        }
        try {
            this._generateZipContentFile(DESTINATION_EXPORT_FILE + content.getName() + EXTENSION_ZIP_FILE, content.getName() + EXTENSION_ZIP_FILE, allFiles, content, contentWARelPath);
            this._generateZipContentFile(DESTINATION_EXPORT_FILE + content.getName() + "_thin.zip", content.getName() + "_thin.zip", notAttachmentsFiles, content, contentWARelPath);
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01d.import").severe("Error al crear el archivo empaquetado.Error:" + ex.getMessage());
            throw new R01MContentModelException("Error al crear el archivo empaquetado", ex);
        }
    }

    private R01MDataStoreItem[] checkFilters(R01MDataStoreItem[] theAllFiles, R01DOpenDataFilter openDataFilter) {
        Object[] copy = (R01MDataStoreItem[])theAllFiles.clone();
        int adjustPos = 0;
        for (int i = 0; i < theAllFiles.length; ++i) {
            if (openDataFilter == null || openDataFilter.accept(theAllFiles[i])) continue;
            int pos = i - adjustPos;
            copy = (R01MDataStoreItem[])ArrayUtils.removeElement((Object[])copy, (int)pos);
            ++adjustPos;
        }
        return copy;
    }

    public void doExportQueryToFile(R01MQueryObject query, String fileName, R01MBaseLocationObject targetLocation, String waRelativePath, boolean exportAttachments) throws R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Generar un empaquetado de contenidos para la b\u00fasqueda " + query.composeDebugInfo() + "\n\tcon el nombre '" + fileName + "'" + "\n\ten la ubicaci\u00f3n " + targetLocation.composeMemoCode() + " de la workarea " + waRelativePath + "\n\t" + (exportAttachments ? " con adjuntos." : " sin adjuntos."));
        }
        ArrayList<R01MJmsQueueParam> params = new ArrayList<R01MJmsQueueParam>();
        params.add(new R01MJmsQueueParam(1, "query", (Object)R01MSearchEngineUtils.encodeQueryObjectInString((R01MQueryObject)query)));
        params.add(new R01MJmsQueueParam(1, "fileName", (Object)fileName));
        params.add(new R01MJmsQueueParam(1, "serverOid", (Object)targetLocation.getServerOid()));
        params.add(new R01MJmsQueueParam(1, "dataStoreOid", (Object)targetLocation.getDataRepositoryOid()));
        params.add(new R01MJmsQueueParam(1, "areaOid", (Object)targetLocation.getAreaOid()));
        params.add(new R01MJmsQueueParam(1, "workAreaOid", (Object)targetLocation.getWorkAreaOid()));
        params.add(new R01MJmsQueueParam(1, "waRelativePath", (Object)waRelativePath));
        params.add(new R01MJmsQueueParam(1, "fileName", (Object)fileName));
        params.add(new R01MJmsQueueParam(1, "exportAttachments", (Object)Boolean.toString(exportAttachments)));
        try {
            R01MJMSUtils.sendJMSMessage((String)"r01ZipQuery", params);
            R01FLog.to((String)"r01d.import").info("Notificaci\u00f3n del empaquetado de la b\u00fasqueda finalizado.");
        }
        catch (R01MJMSException jmsExc) {
            R01FLog.to((String)"r01d.import").severe("Error en la notificaci\u00f3n del empaquetado de b\u00fasqueda.Error:" + jmsExc.getMessage());
            throw new R01MContentModelException("Error al crear el archivo empaquetado a partir de la busqueda.", (Exception)((Object)jmsExc));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean doProcessExportQueryToFile(R01MQueryObject query, String fileName, R01MBaseLocationObject targetLocation, String waRelativePath, boolean exportAttachments) throws R01MContentModelException, UnsupportedEncodingException, R01MSecurityException {
        List result;
        R01MLogicalPublicationInfo logicalPublicationInfo;
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Generar un empaquetado de contenidos para la b\u00fasqueda " + query.composeDebugInfo() + "\n\tcon el nombre '" + fileName + "'" + "\n\ten la ubicaci\u00f3n " + targetLocation.composeMemoCode() + " de la workarea " + waRelativePath + "\n\t" + (exportAttachments ? " con adjuntos." : " sin adjuntos."));
        }
        if (query == null) {
            if (!DEBUG) return false;
            R01FLog.to((String)"r01d.import").info("La b\u00fasqueda especificada es NULA!!!");
            return false;
        }
        List publishRepositories = query.getPublishRepositories();
        if (publishRepositories.size() != 1) {
            if (!DEBUG) return false;
            R01FLog.to((String)"r01d.import").info("El n\u00famero de repositorios de publicaci\u00f3n por los que se ha buscado no es 1.");
            return false;
        }
        try {
            logicalPublicationInfo = R01MClientFactory.getPublisherConfigAPI().getLogicalPublicationConfig(((R01MSearchedPublishRepository)publishRepositories.get(0)).getOid());
        }
        catch (R01MConfigLoadException cfgEx) {
            throw new R01MContentModelException("Error al cargar la informaci\u00f3n l\u00f3gica de la publicaci\u00f3n de " + publishRepositories.get(0), (Exception)((Object)cfgEx));
        }
        try {
            if (!R01MClientFactory.getRawDataAPI((R01MUserContext)this._userCtx).checkFolder(R01MPathHelpper.getLocationPath((R01MBaseLocationObject)targetLocation), waRelativePath.startsWith(PATH_SLASH_SEPARATOR) ? waRelativePath.substring(1) : waRelativePath)) {
                if (!DEBUG) return false;
                R01FLog.to((String)"r01d.import").info("El destino especificado para el empaquetado es incorrecto !!!");
                return false;
            }
        }
        catch (R01MSecurityException secExc) {
            R01FLog.to((String)"r01d.import").severe("No se tiene acceso a la ubicaci\u00f3n " + targetLocation.composeMemoCode() + " de la workarea " + waRelativePath + ".Error:" + secExc.getMessage());
            throw new R01MContentModelException("No se tiene acceso a la ubicaci\u00f3n " + targetLocation.composeMemoCode() + " de la workarea " + waRelativePath, (Exception)((Object)secExc));
        }
        catch (R01MDataStoreException dsExc) {
            R01FLog.to((String)"r01d.import").severe("Error al acceder a la ubicaci\u00f3n " + targetLocation.composeMemoCode() + " de la workarea " + waRelativePath + ".Error:" + dsExc.getMessage());
            throw new R01MContentModelException("Error al acceder a la ubicaci\u00f3n " + targetLocation.composeMemoCode() + " de la workarea " + waRelativePath, (Exception)((Object)dsExc));
        }
        query.setModified(true);
        query.setPresentationProperty("r01PageSize", "" + R01MSearchEngineWebConstants.MAX_RESULTITEMS_PER_PAGE);
        try {
            R01MSearchSession session = R01MClientFactory.getSearchEngineSessionAPI().createSession(R01MConstants.DEFAULT_LANG, query);
            result = session.getTotalPagesAndSourcesSearchResultItems();
        }
        catch (Exception srchExc) {
            R01FLog.to((String)"r01d.import").severe("Error al subir ejecutar la b\u00fasqueda para crear el empaquetado " + fileName + ".Error:" + srchExc.getMessage());
            throw new R01MContentModelException("Error al subir ejecutar la b\u00fasqueda para crear el empaquetado " + fileName, srchExc);
        }
        if (result != null && !result.isEmpty()) {
            if (DEBUG) {
                R01FLog.to((String)"r01d.import").info("La b\u00fasqueda " + query.composeDebugInfo() + " ha producido " + result.size() + " resultados.");
            }
            StringBuffer contentTextFile = new StringBuffer();
            contentTextFile.append(COMMENT_DESTINATION_FILE);
            contentTextFile.append(NEW_LINE_SEPARATOR);
            contentTextFile.append(logicalPublicationInfo + "html");
            contentTextFile.append(PATH_SLASH_SEPARATOR);
            contentTextFile.append(waRelativePath);
            contentTextFile.append(PATH_SLASH_SEPARATOR);
            contentTextFile.append(fileName);
            contentTextFile.append(EXTENSION_ZIP_FILE);
            contentTextFile.append(NEW_LINE_SEPARATOR);
            int cont = 0;
            for (R01MSearchResultItem item : result) {
                if (cont == 0) {
                    contentTextFile.append(COMMENT_ORIGIN_FILES);
                    contentTextFile.append(NEW_LINE_SEPARATOR);
                }
                contentTextFile.append(logicalPublicationInfo + "html");
                contentTextFile.append(PATH_SLASH_SEPARATOR);
                contentTextFile.append(item.contentTypology.getTypeOid());
                contentTextFile.append(PATH_SLASH_SEPARATOR);
                contentTextFile.append(item.getContentName());
                contentTextFile.append(PATH_SLASH_SEPARATOR);
                contentTextFile.append(OPENDATA_FOLDER);
                contentTextFile.append(PATH_SLASH_SEPARATOR);
                contentTextFile.append(item.getContentName());
                if (!exportAttachments) {
                    contentTextFile.append(FILE_WITHOUT_ATTACHMENTS);
                }
                contentTextFile.append(EXTENSION_ZIP_FILE);
                contentTextFile.append(NEW_LINE_SEPARATOR);
                ++cont;
            }
            String filePathTXT = FOLDER_AVCOMUN_EXEC_R01PACKAGEZIP + PATH_SLASH_SEPARATOR + fileName + EXTENSION_TEXT_FILE;
            ByteArrayInputStream fileData = new ByteArrayInputStream(contentTextFile.toString().getBytes(R01MConstants.DEFAULT_WEB_ENCODING));
            R01MContentLocation targetSystemLocation = new R01MContentLocation(SYSTEMSERVER_CONFIGS_LOCATION, SYSTEMDATASTORE_CONFIGS_LOCATION, SYSTEMAREA_CONFIGS_LOCATION, SYSTEMWORKAREA_CONFIGS_LOCATION);
            try {
                targetSystemLocation.validateObject();
            }
            catch (R01MContentModelObjectsValidatorException valExc) {
                R01FLog.to((String)"r01d.import").severe("El store especificado " + targetSystemLocation.composeMemoCode() + " no existe o es incorrecto. Error: " + valExc.getMessage());
            }
            R01MRawDataAPI api = R01MClientFactory.getRawDataAPI((R01MUserContext)R01MAuthManager.createMasterSystemUserContext());
            try {
                api.updateFile(R01MPathHelpper.getLocationPath((R01MBaseLocationObject)targetSystemLocation), filePathTXT, (InputStream)fileData, null, false);
                api.submmitFile(R01MPathHelpper.getLocationPath((R01MBaseLocationObject)targetSystemLocation), filePathTXT);
                return true;
            }
            catch (R01MDataStoreException dsEx) {
                R01FLog.to((String)"r01d.import").severe("Error al subir el fichero de generacion del empaquetado '" + filePathTXT + "' de la WA " + targetSystemLocation.composeMemoCode() + ". Error:" + dsEx.getMessage());
                throw new R01MContentModelException("Error al subir el fichero de generacion del empaquetado '" + filePathTXT + "' de la WA " + targetSystemLocation.composeMemoCode() + ".", (Exception)((Object)dsEx));
            }
        }
        if (!DEBUG) return false;
        R01FLog.to((String)"r01d.import").info("La b\u00fasqueda " + query.composeDebugInfo() + " no ha producido resultados.");
        return false;
    }

    private void instantiateDataStoreManager() throws R01MContentModelException {
        try {
            this._dsMgr = this._obtainDataStoreManager();
        }
        catch (R01MDataStoreAuthenticationException authEx) {
            R01FLog.to((String)"r01d.import").severe("No se ha podido realizar la autenticaci\u00f3n: " + authEx.getMessage());
            throw new R01MContentModelException("No se ha podido realizar la autenticaci\u00f3n.", (Exception)((Object)authEx));
        }
        catch (R01MDataStoreException dsEx) {
            R01FLog.to((String)"r01d.import").severe("No se ha podido cargar el descriptor del contenido: " + dsEx.getMessage());
            throw new R01MContentModelException("No se ha podido cargar el descriptor del contenido.", (Exception)((Object)dsEx));
        }
    }

    private void _generateZipContentFile(String filePath, String fileName, R01MDataStoreItem[] filesToAdd, R01MContent content, String contentWARelPath) throws R01MContentModelException {
        File zipFile = new File(filePath);
        if (filesToAdd != null && filesToAdd.length > 0) {
            ArrayList<R01DContentStoreZipFileInfo> filesInfoZipFile = new ArrayList<R01DContentStoreZipFileInfo>();
            for (int i = 0; i < filesToAdd.length; ++i) {
                if (filesToAdd[i].getItemType() != 0) continue;
                filesInfoZipFile.add(new R01DContentStoreZipFileInfo((R01MBaseLocationObject)content.getStoreLocation(), filesToAdd[i].getWorkAreaRelativePath(), filesToAdd[i].getWorkAreaRelativePath().substring(filesToAdd[i].getWorkAreaRelativePath().indexOf(PATH_SLASH_SEPARATOR) + 1)));
            }
            this._createZipFile(zipFile, filesInfoZipFile);
        } else {
            if (DEBUG) {
                R01FLog.to((String)"r01d.import").info("No existen archivos para empaquetar......");
            }
            try {
                if (zipFile.exists() && !zipFile.delete()) {
                    throw new R01MContentModelException("El archivo empaquetado '" + DESTINATION_EXPORT_FILE + fileName + "' no se ha podido borrar.");
                }
                boolean bCreateZipFile = zipFile.createNewFile();
                if (!bCreateZipFile) {
                    throw new R01MContentModelException("El archivo empaquetado '" + DESTINATION_EXPORT_FILE + fileName + "' no se ha podido crear.");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.import").info("Subir el archivo " + DESTINATION_EXPORT_FILE + fileName + " a " + contentWARelPath + "/ de la WA " + content.getStoreLocation().composeMemoCode());
        }
        String openDataDefaultDir = XMLProperties.getProperty((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentServices/contentDirectories/opendata/opendataDefaultDir", (String)OPENDATA_FOLDER);
        try {
            File sourceImportFile = new File(DESTINATION_EXPORT_FILE + fileName);
            if (sourceImportFile.exists()) {
                this._dsMgr.doUpdateFile((R01MBaseLocationObject)content.getStoreLocation(), contentWARelPath + PATH_SLASH_SEPARATOR + openDataDefaultDir + PATH_SLASH_SEPARATOR + fileName, (InputStream)new FileInputStream(sourceImportFile), null, true);
            } else {
                R01FLog.to((String)"r01d.import").warning("El archivo empaquetado '" + DESTINATION_EXPORT_FILE + fileName + "' NO EXISTE...Por lo tanto no se sube al directorio '" + contentWARelPath + PATH_SLASH_SEPARATOR + openDataDefaultDir + PATH_SLASH_SEPARATOR + fileName + "'");
            }
        }
        catch (R01MDataStoreException dsEx) {
            R01FLog.to((String)"r01d.import").severe("Error al subir el archivo empaquetado '" + DESTINATION_EXPORT_FILE + fileName + "' al directorio " + contentWARelPath + "/data/ de la WA " + content.getStoreLocation().composeMemoCode() + ".Error:" + dsEx.getMessage());
            throw new R01MContentModelException("Error al subir el archivo empaquetado '" + DESTINATION_EXPORT_FILE + fileName + "' al directorio " + contentWARelPath + "/data/ de la WA " + content.getStoreLocation().composeMemoCode() + ".", (Exception)((Object)dsEx));
        }
        catch (FileNotFoundException filEx) {
            R01FLog.to((String)"r01d.import").severe("El archivo empaquetado '" + DESTINATION_EXPORT_FILE + fileName + "' no existe.Error:" + filEx.getMessage());
            throw new R01MContentModelException("El archivo empaquetado '" + DESTINATION_EXPORT_FILE + fileName + "' no existe.", (Exception)filEx);
        }
        finally {
            if (zipFile.exists()) {
                if (DEBUG) {
                    R01FLog.to((String)"r01d.import").info("Borrando el archivo '" + DESTINATION_EXPORT_FILE + fileName + "'");
                }
                try {
                    FileUtils.delete((File)zipFile);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
    }

    private R01MDataStoreManager _obtainDataStoreManager() throws R01MDataStoreException, R01MDataStoreAuthenticationException {
        try {
            R01MDataStoreAuthObject authenticationObject = new R01MDataStoreAuthObject(R01MConstants.API_APPCODE);
            authenticationObject.fillAuthInfo(R01MConstants.API_APPCODE, this._userCtx);
            R01MDataStoreManager dsManager = (R01MDataStoreManager)ReflectionUtils.getObjectInstance((String)DATASTORE_MANAGER_CLASS_NAME);
            dsManager.doBeginSession(authenticationObject);
            R01FLog.to((String)"r01d.dataStoreManager").info("SESION DE USUARIO PARA ACCEDER AL GESTOR DE CONTENIDOS CREADA !!!!!");
            return dsManager;
        }
        catch (ReflectionException refEx) {
            throw new R01MDataStoreException("NO se ha podido instanciar el manager del DataStore con la clase " + DATASTORE_MANAGER_CLASS_NAME + ": " + refEx.getMessage(), (Exception)((Object)refEx));
        }
    }

    private void _createZipFile(File zipFile, List<R01DContentStoreZipFileInfo> filesInfoZipFile) throws R01MContentModelException {
        if (this._dsMgr == null) {
            this.instantiateDataStoreManager();
        }
        ZipArchiveOutputStream zipOutput = null;
        InputStream fileIS = null;
        try {
            zipOutput = new ZipArchiveOutputStream(zipFile);
            zipOutput.setEncoding("CP437");
            for (R01DContentStoreZipFileInfo fileInfo : filesInfoZipFile) {
                if (DEBUG) {
                    R01FLog.to((String)"r01d.import").info("Empaquetando el archivo " + fileInfo.waRelPath + " en el archivo '" + zipFile.getAbsolutePath() + "'.");
                }
                try {
                    fileIS = this._dsMgr.doReadFile(fileInfo.loc, fileInfo.waRelPath);
                }
                catch (R01MDataStoreException dsEx) {
                    R01FLog.to((String)"r01d.import").warning("Error al leer el archivo " + fileInfo.waRelPath + ".Error:" + dsEx.getMessage());
                    continue;
                }
                ZipArchiveEntry entry = new ZipArchiveEntry(fileInfo.entry);
                zipOutput.putArchiveEntry((ArchiveEntry)entry);
                IOUtils.copy((InputStream)fileIS, (OutputStream)zipOutput);
                zipOutput.closeArchiveEntry();
            }
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01d.import").severe("Error al crear el archivo '" + zipFile.getAbsolutePath() + "'.Error:" + ex.getMessage());
            throw new R01MContentModelException("Error al crear el archivo '" + zipFile.getAbsolutePath(), ex);
        }
        finally {
            try {
                if (fileIS != null) {
                    fileIS.close();
                }
                if (zipOutput != null) {
                    zipOutput.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }
}

