/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services;

import com.ejie.r01f.file.FileUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.datastore.R01MDataStoreAuthObject;
import com.ejie.r01m.datastore.R01MDataStoreItemFilter;
import com.ejie.r01m.datastore.R01MRawDataStoreManager;
import com.ejie.r01m.datastore.R01MWithoutHoleFilter;
import com.ejie.r01m.exceptions.R01MDataStoreAuthenticationException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.datastore.R01MDataStoreItem;
import com.ejie.r01m.services.bzd.R01MRawDataManagerBzd;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.jms.R01MJMSUtils;
import com.ejie.r01m.utils.jms.R01MJmsQueueParam;
import com.ejie.r01m.utils.jms.R01MMessageCallBackBean;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class R01DRawDataManager
implements R01MRawDataManagerBzd {
    private static final String RAW_DATASTORE_MANAGER_CLASS_NAME = XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"dataStoreManager/rawImplClassName");
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01m.dataAPI").intValue() != Level.OFF.intValue();
    private R01MUserContext _userCtx;

    public R01DRawDataManager() {
    }

    public R01DRawDataManager(R01MUserContext userCtx) throws R01MSecurityException {
        this();
        this._userCtx = userCtx;
    }

    private R01MRawDataStoreManager _obtainRawDataStoreManager(R01MUserContext userCtx) throws R01MSecurityException, R01MDataStoreException {
        try {
            R01MUserContext theUserCtx = userCtx == null ? this._userCtx : userCtx;
            R01MDataStoreAuthObject authenticationObject = new R01MDataStoreAuthObject();
            authenticationObject.fillAuthInfo(R01MConstants.API_APPCODE, theUserCtx);
            R01MRawDataStoreManager rawDSMgr = (R01MRawDataStoreManager)ReflectionUtils.getObjectInstance((String)RAW_DATASTORE_MANAGER_CLASS_NAME);
            rawDSMgr.doBeginSession(authenticationObject);
            return rawDSMgr;
        }
        catch (ReflectionException refEx) {
            refEx.printStackTrace(System.out);
            throw new R01MDataStoreException("NO se ha podido instanciar el manager del DataStore con la clase " + RAW_DATASTORE_MANAGER_CLASS_NAME + ": " + refEx.getMessage());
        }
        catch (R01MDataStoreAuthenticationException authEx) {
            authEx.printStackTrace();
            throw new R01MDataStoreException("No se ha podido realizar la autenticaci\u00f3n: " + authEx.getMessage(), (Exception)((Object)authEx));
        }
    }

    public String doGetPathSeparator(R01MUserContext userCtx) {
        try {
            R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
            return rawDSMgr.doGetPathSeparator();
        }
        catch (R01MDataStoreException dsEx) {
            dsEx.printStackTrace(System.out);
        }
        catch (R01MSecurityException secEx) {
            secEx.printStackTrace(System.out);
        }
        return null;
    }

    public boolean doCheckFolder(R01MUserContext userCtx, String waPath, String folderWARelativePath) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doCheckFolder";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        return rawDSMgr.doCheckFolder(waPath, folderWARelativePath);
    }

    public R01MDataStoreItem[] doGetFolderContents(R01MUserContext userCtx, String waPath, String folderWARelativePath, boolean recursive) throws R01MSecurityException, R01MDataStoreException {
        return this.doGetFolderContents(userCtx, waPath, folderWARelativePath, recursive, (R01MDataStoreItemFilter)new R01MWithoutHoleFilter());
    }

    public R01MDataStoreItem[] doGetFolderContents(R01MUserContext userCtx, String waPath, String folderWARelativePath, boolean recursive, R01MDataStoreItemFilter filter) throws R01MSecurityException, R01MDataStoreException {
        return this.doGetFolderContents(userCtx, waPath, folderWARelativePath, recursive, filter, null);
    }

    public R01MDataStoreItem[] doGetFolderContents(R01MUserContext userCtx, String waPath, String folderWARelativePath, boolean recursive, R01MDataStoreItemFilter filter, R01MDataStoreItemFilter readOnlyFilter) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doGetFolderContents";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        return rawDSMgr.doGetFolderContents(waPath, folderWARelativePath, recursive, filter, readOnlyFilter);
    }

    public void doCreateFolder(R01MUserContext userCtx, String waPath, String folderWARelativePath) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doCreateFolder";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doCreateFolder(waPath, folderWARelativePath);
    }

    public void doDeleteFolder(R01MUserContext userCtx, String waPath, String folderWARelativePath, boolean consolidate) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doDeleteFolder";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doDeleteFolder(waPath, folderWARelativePath, consolidate);
    }

    public void doRenameFolder(R01MUserContext userCtx, String waPath, String folderWARelativePath, String newFolderName) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doRenameFolder";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doRenameFolder(waPath, folderWARelativePath, newFolderName);
    }

    public void doMoveFolderInWorkArea(R01MUserContext userCtx, String waPath, String folderWARelativePath, String newFolderWARelativePath) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doMoveFolderInWorkArea";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doMoveFolderInWorkArea(waPath, folderWARelativePath, newFolderWARelativePath);
    }

    public void doMoveFolderToAnotherWorkArea(R01MUserContext userCtx, String waPathSrc, String waPathDst, String[] foldersWARelativePaths) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doMoveFolderToAnotherWorkArea";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doMoveFolderToAnotherWorkArea(waPathSrc, waPathDst, foldersWARelativePaths);
    }

    public void doCopyFolderToAnotherWorkArea(R01MUserContext userCtx, String srcWAPath, String srcFolderWARelativePath, String dstWAPath, String dstFolderWARelativePath, String[] folderWARelatviePaths) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doCopyFolderToAnotherWorkArea";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doCopyFolderToAnotherWorkArea(srcWAPath, srcFolderWARelativePath, dstWAPath, dstFolderWARelativePath, folderWARelatviePaths);
    }

    public void doSubmmitFolder(R01MUserContext userCtx, String waPath, String folderWARelativePath) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doSubmmitFolder";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doSubmmitFolder(waPath, folderWARelativePath);
    }

    public Properties doGetFolderAttributes(R01MUserContext userCtx, String waPath, String folderWARelativePath) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doGetFolderAttributes";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        return rawDSMgr.doGetFolderAttributes(waPath, folderWARelativePath);
    }

    public void doSetFolderAttributes(R01MUserContext userCtx, String waPath, String folderWARelativePath, Properties attrs) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doSetFolderAttributes";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doSetFolderAttributes(waPath, folderWARelativePath, attrs);
    }

    public boolean doCheckFile(R01MUserContext userCtx, String waPath, String fileWARelativePath) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doCheckFile";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        return rawDSMgr.doCheckFile(waPath, fileWARelativePath);
    }

    public void doCopyFiles(R01MUserContext userCtx, String srcWAPath, String srcFolderWARelativePath, String dstWAPath, String dstFolderWARelativePath, String[] filesWARelativePaths) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doCopyFiles";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doCopyFiles(srcWAPath, srcFolderWARelativePath, dstWAPath, dstFolderWARelativePath, filesWARelativePaths);
    }

    public void doMoveFileInWorkArea(R01MUserContext userCtx, String waPath, String fileWARelativePath, String newFileWorkAreaRelativePath) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doMoveFileInWorkArea";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doMoveFileInWorkArea(waPath, fileWARelativePath, newFileWorkAreaRelativePath);
    }

    public void doUpdateFile(R01MUserContext userCtx, String waPath, String fileWARelativePath, InputStream fileData, Properties properties, boolean createFilePath) throws R01MSecurityException, R01MDataStoreException {
        this.doUpdateFile(userCtx, waPath, fileWARelativePath, fileData, properties, createFilePath, false);
    }

    public void doCreateUpdateFile(R01MUserContext userCtx, String waPath, String fileWARelativePath, byte[] fileData, Properties properties, boolean appendToFile) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doCreateUpdateFile";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doUpdateFile(waPath, fileWARelativePath, (InputStream)new ByteArrayInputStream(fileData), properties, true, appendToFile);
    }

    public void doUpdateFile(R01MUserContext userCtx, String waPath, String fileWARelativePath, InputStream fileData, Properties properties, boolean createFilePath, boolean appendToFile) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doUpdateFile";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doUpdateFile(waPath, fileWARelativePath, fileData, properties, createFilePath, appendToFile);
    }

    public void doUpdateFileChunk(R01MUserContext userCtx, String waPath, String fileWARelativePath, byte[] fileDataChunk, long offset, Properties properties) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doUpdateFileChunk";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doUpdateFileChunk(waPath, fileWARelativePath, fileDataChunk, offset, properties);
    }

    public InputStream doReadFile(R01MUserContext userCtx, String waPath, String fileWARelativePath) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doReadFile";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        return rawDSMgr.doReadFile(waPath, fileWARelativePath);
    }

    public byte[] doReadFileChunk(R01MUserContext userCtx, String waPath, String fileWARelativePath, long offset, int length) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doReadFile";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        return rawDSMgr.doReadFileChunk(waPath, fileWARelativePath, offset, length);
    }

    public InputStream doReadConfigFile(R01MUserContext userCtx, String pathLocation, String fileWARelativePath) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doReadConfigFile";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        return rawDSMgr.doReadConfigFile(pathLocation, fileWARelativePath);
    }

    public void doDeleteFile(R01MUserContext userCtx, String waPath, String fileWARelativePath, boolean consolidate) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doDeleteFile";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doDeleteFile(waPath, fileWARelativePath.startsWith("/") ? fileWARelativePath.substring(1) : fileWARelativePath, consolidate);
    }

    public void doRenameFile(R01MUserContext userCtx, String waPath, String fileWARelativePath, String newFileName) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doRenameFile";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doRenameFile(waPath, fileWARelativePath, newFileName);
    }

    public void doSubmmitFile(R01MUserContext userCtx, String waPath, String fileWARelativePath) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doSubmmitFile";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doSubmmitFile(waPath, fileWARelativePath);
    }

    public Properties doGetFileAttributes(R01MUserContext userCtx, String waPath, String fileWARelativePath) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doGetFileAttributes";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        return rawDSMgr.doGetFileAttributes(waPath, fileWARelativePath);
    }

    public void doSetFileAttributes(R01MUserContext userCtx, String waPath, String fileWARelativePath, Properties attrs) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doSetFileAttributes";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doSetFileAttributes(waPath, fileWARelativePath, attrs);
    }

    public void doGenerateFileUsingPresentationTemplate(R01MUserContext userCtx, String waPath, String dataFileWARelativePath, Map generatedFilesWARelativePaths, String generateURL, String templateOid, String templateInstanceId, Properties templateProperties) throws R01MSecurityException, R01MDataStoreException {
        this.doGenerateFileUsingPresentationTemplate(userCtx, waPath, dataFileWARelativePath, generatedFilesWARelativePaths, generateURL, templateOid, templateInstanceId, templateProperties, false);
    }

    public void doGenerateFileUsingPresentationTemplate(R01MUserContext userCtx, String waPath, String dataFileWARelativePath, Map generatedFilesWARelativePaths, String generateURL, String templateOid, String templateInstanceId, Properties templateProperties, boolean syncWorkflow) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doGenerateFileUsingPresentationTemplate";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        rawDSMgr.doGenerateFileUsingPresentationTemplate(waPath, dataFileWARelativePath, generatedFilesWARelativePaths, generateURL, templateOid, templateInstanceId, templateProperties, syncWorkflow);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doDownloadFileAsync(R01MUserContext userCtx, String waPath, String fileWARelativePath, String targetFileAbsolutePath, R01MMessageCallBackBean msgDataCallBack) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doDownloadFileAsync";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        Properties attrs = rawDSMgr.doGetFileAttributes(waPath, fileWARelativePath);
        long fileSize = 0L;
        if (attrs != null && attrs.containsKey("size")) {
            fileSize = Long.parseLong("" + attrs.get("size"));
        }
        if (fileSize <= 0L) throw new R01MDataStoreException("El fichero '" + waPath + fileWARelativePath + " no existe.");
        int block = R01MConstants.BUFFER_UPDOWN_SIZE_CHUNK_MAX;
        long t1 = System.currentTimeMillis();
        File targetFile = new File(targetFileAbsolutePath);
        try {
            if (fileSize <= (long)block) {
                InputStream fileIS = rawDSMgr.doReadFile(waPath, fileWARelativePath);
                FileUtils.saveFile((File)targetFile, (InputStream)fileIS);
            } else {
                long offset = 0L;
                do {
                    byte[] data = rawDSMgr.doReadFileChunk(waPath, fileWARelativePath, offset, block);
                    FileUtils.appendToFile((File)targetFile, (InputStream)new ByteArrayInputStream(data), (boolean)true);
                    if ((offset += (long)block) + (long)block <= fileSize) continue;
                    block = (int)(fileSize - offset);
                } while (offset < fileSize);
            }
            if (!DEBUG) return;
            long t2 = System.currentTimeMillis();
            R01FLog.to((String)"r01m.dataAPI").info("El tiempo en descargar el archivo " + targetFileAbsolutePath + " de tama\u00f1o " + fileSize + " bytes ha sido de " + (t2 - t1) + "msg");
            return;
        }
        catch (IOException ioExc) {
            R01FLog.to((String)"r01m.dataAPI").severe("Error al escribir el fichero " + targetFileAbsolutePath + ".Error:" + ioExc.getMessage());
            ioExc.printStackTrace(System.out);
            throw new R01MDataStoreException("Error al leer el fichero " + targetFileAbsolutePath);
        }
    }

    public void doUploadFileAsync(R01MUserContext userCtx, String sourceFileAbsolutePath, String targetWAPath, String targetFileWARelativePath, R01MMessageCallBackBean msgDataCallBack) throws R01MSecurityException, R01MDataStoreException {
        String msgDataCallBackXML;
        ArrayList<R01MJmsQueueParam> params = new ArrayList<R01MJmsQueueParam>();
        params.add(new R01MJmsQueueParam(1, "sourceFileAbsolutePath", (Object)sourceFileAbsolutePath));
        params.add(new R01MJmsQueueParam(1, "targetWaPath", (Object)targetWAPath));
        params.add(new R01MJmsQueueParam(1, "targetFileWARelativePath", (Object)targetFileWARelativePath));
        try {
            msgDataCallBackXML = XOManager.getXML((String)R01MConstants.CONTENTMODEL_MAPFILE, (Object)msgDataCallBack);
        }
        catch (XOMarshallerException xoExc) {
            R01FLog.to((String)"r01m.dataAPI").severe("Error en la notificaci\u00f3n de subida del fichero '" + sourceFileAbsolutePath + "' a '" + targetWAPath + targetFileWARelativePath + "', el objeto de respuesta es incorrecto.Error:" + xoExc.getMessage());
            throw new R01MDataStoreException("Error en la notificaci\u00f3n de subida del fichero '" + sourceFileAbsolutePath + "' a '" + targetWAPath + targetFileWARelativePath + "', el objeto de respuesta es incorrecto.", (Exception)((Object)xoExc));
        }
        params.add(new R01MJmsQueueParam(1, "messageCallBackOid", (Object)msgDataCallBack.getProcessOid()));
        params.add(new R01MJmsQueueParam(1, "msgCallBack", (Object)msgDataCallBackXML));
        try {
            R01MJMSUtils.sendJMSMessage((String)"r01UploadFileAsync", params);
            if (DEBUG) {
                R01FLog.to((String)"r01m.dataAPI").info("Notificaci\u00f3n de subir el fichero '" + sourceFileAbsolutePath + "' a " + targetWAPath + targetFileWARelativePath + ", respuesta en " + msgDataCallBack.composeMemoCode());
            }
        }
        catch (R01MJMSException jmsExc) {
            R01FLog.to((String)"r01m.dataAPI").severe("Error en la notificaci\u00f3n de subir el fichero '" + sourceFileAbsolutePath + "' a '" + targetWAPath + targetFileWARelativePath + "', respuesta en " + msgDataCallBack.composeMemoCode() + ".Error:" + jmsExc.getMessage());
            throw new R01MDataStoreException("Error en la notificaci\u00f3n de subir el fichero '" + sourceFileAbsolutePath + "' a '" + targetWAPath + targetFileWARelativePath + "', respuesta en " + msgDataCallBack.composeMemoCode(), (Exception)((Object)jmsExc));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doUploadFileAsyncFromMDB(R01MUserContext userCtx, String sourceFileAbsolutePath, String targetWaPath, String targetFileWARelativePath, R01MMessageCallBackBean msgDataCallBack) throws R01MSecurityException, R01MDataStoreException {
        String opDesc = "doUploadFileAsync";
        if (DEBUG) {
            R01FLog.to((String)"r01m.dataAPI").info("SERVER DATA API (init): " + opDesc);
        }
        R01MRawDataStoreManager rawDSMgr = this._obtainRawDataStoreManager(userCtx);
        File file = new File(sourceFileAbsolutePath);
        if (!file.exists()) throw new R01MDataStoreException("El fichero '" + sourceFileAbsolutePath + " no existe.");
        FileInputStream fileIS = null;
        try {
            fileIS = new FileInputStream(file);
            long fileSize = file.length();
            int block = R01MConstants.BUFFER_UPDOWN_SIZE_CHUNK_MAX;
            long t1 = System.currentTimeMillis();
            if (fileSize < (long)block) {
                rawDSMgr.doUpdateFile(targetWaPath, targetFileWARelativePath, (InputStream)fileIS, null, true);
            } else {
                long offset = 0L;
                do {
                    byte[] data = new byte[block];
                    fileIS.read(data);
                    rawDSMgr.doUpdateFileChunk(targetWaPath, targetFileWARelativePath, data, offset, null);
                    if ((offset += (long)block) + (long)block <= fileSize) continue;
                    block = (int)(fileSize - offset);
                } while (offset < fileSize);
            }
            if (!DEBUG) return;
            long t2 = System.currentTimeMillis();
            R01FLog.to((String)"r01m.dataAPI").info("El tiempo en subir el archivo " + sourceFileAbsolutePath + " de tama\u00f1o " + fileSize + " bytes ha sido de " + (t2 - t1) + "msg");
            return;
        }
        catch (FileNotFoundException filExc) {
            R01FLog.to((String)"r01m.dataAPI").severe("Error al obtener un inputStream al fichero " + sourceFileAbsolutePath + ".Error:" + filExc.getMessage());
            filExc.printStackTrace(System.out);
            throw new R01MDataStoreException("Error al obtener un inputStream al fichero " + sourceFileAbsolutePath + ".Error:" + filExc.getMessage());
        }
        catch (IOException ioExc) {
            R01FLog.to((String)"r01m.dataAPI").severe("Error al leer el fichero " + sourceFileAbsolutePath + ".Error:" + ioExc.getMessage());
            ioExc.printStackTrace(System.out);
            throw new R01MDataStoreException("Error al leer el fichero " + sourceFileAbsolutePath + ".Error:" + ioExc.getMessage());
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01m.dataAPI").severe("Error general al leer el fichero " + sourceFileAbsolutePath + ".Error:" + ex.getMessage());
            ex.printStackTrace(System.out);
            throw new R01MDataStoreException("Error general al leer el fichero " + sourceFileAbsolutePath + ".Error:" + ex.getMessage());
        }
        finally {
            if (fileIS != null) {
                try {
                    fileIS.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
    }
}

