/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services;

import com.ejie.r01d.datastore.R01DContentInDataStore;
import com.ejie.r01d.exceptions.R01DContentModelPersistenceException;
import com.ejie.r01d.filters.R01DContentResourcesFilter;
import com.ejie.r01d.gestorcontenidos.dbhelppers.R01DContentModelLoaderHelper;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.alias.R01DDocumentAliasCMPUtil;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.content.R01DContentCMPLocal;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.content.R01DContentCMPPK;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.content.R01DContentCMPUtil;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.document.R01DDocumentCMPLocal;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.document.R01DDocumentCMPPK;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.document.R01DDocumentCMPUtil;
import com.ejie.r01d.services.R01DAliasAdminManager;
import com.ejie.r01d.services.R01DContentModelManager;
import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.publisher.R01MLogicalPublicationInfo;
import com.ejie.r01m.config.objects.typology.R01MContentType;
import com.ejie.r01m.config.objects.typology.R01MTypologyPubConfig;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.datastore.R01MDataStoreAuthObject;
import com.ejie.r01m.datastore.R01MDataStoreItemFilter;
import com.ejie.r01m.datastore.R01MDataStoreManager;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MDataStoreAuthenticationException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MDeleteContentException;
import com.ejie.r01m.exceptions.R01MDeleteModelObjectException;
import com.ejie.r01m.exceptions.R01MDirtyContentModelException;
import com.ejie.r01m.exceptions.R01MDuplicateModelObjectException;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.exceptions.R01MPublisherModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.objects.R01MBasePublicationTarget;
import com.ejie.r01m.objects.R01MURLAlias;
import com.ejie.r01m.objects.contentmodel.R01MBaseDocumentInterface;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MDataFile;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.contentmodel.R01MDocumentRevisionState;
import com.ejie.r01m.objects.datastore.R01MDataStoreItem;
import com.ejie.r01m.objects.publisher.R01MPublicationDestination;
import com.ejie.r01m.objects.publisher.R01MPublicationResourceItem;
import com.ejie.r01m.objects.publisher.R01MPublish;
import com.ejie.r01m.objects.publisher.R01MPublishActionObject;
import com.ejie.r01m.objects.resources.R01MLinkedResource;
import com.ejie.r01m.objects.resources.R01MLinkedResourcesGroup;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexDefinition;
import com.ejie.r01m.objects.searchengine.indexer.R01MRispDocument;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentModelAPI;
import com.ejie.r01m.services.R01MPublisherAPI;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDateUtils;
import com.ejie.r01m.utils.R01MPathHelpper;
import com.ejie.r01m.utils.R01MURLHelpper;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.jms.R01MJMSUtils;
import com.ejie.r01m.utils.jms.R01MJmsQueueParam;
import com.ejie.r01p.objects.publisher.R01PPublishDefinition;
import com.ejie.r01p.services.R01PAliasManagerAPI;
import com.ejie.r01p.services.R01PClientFactory;
import com.ejie.r01p.services.bzd.R01PPublisherManagerBzd;
import com.ejie.r01p.utils.publisher.R01MPublisherUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.FinderException;
import javax.naming.NamingException;

public class R01DPublisherManager
implements R01PPublisherManagerBzd {
    private static final String LOG_TYPE_ID = "r01d.publisherManager";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.publisherManager").intValue() != Level.OFF.intValue();
    private final transient R01MUserContext _userCtx;

    public R01DPublisherManager(R01MUserContext userCtx) {
        this._userCtx = userCtx;
    }

    public void prepareToPublish(R01PPublishDefinition pubDef) throws R01MPublisherException {
        boolean inputParamsOK = true;
        try {
            this._checkPublishProcessInputParams(0, pubDef);
        }
        catch (R01MPublisherException pEx) {
            pubDef.setPublicationState(-1);
            this._managePublishException(pubDef, pEx, 0);
            inputParamsOK = false;
        }
        if (inputParamsOK) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("R01DPublisherManager.prepareToPublish >> Par\u00e1metros de entrada:\r\n" + pubDef.debugInfo(""));
            }
            boolean objectLoadedOK = false;
            R01MDocument document = null;
            R01MContent content = null;
            if (!StringUtils.isEmptyString((String)pubDef.getObjectOid())) {
                Object[] object = null;
                try {
                    object = this._getContentAndDocument(pubDef.getObjectOid(), pubDef.getObjectType());
                }
                catch (R01MPublisherException pEx) {
                    pubDef.setPublicationState(-1);
                    this._managePublishException(pubDef, pEx, 0);
                }
                if (object != null) {
                    content = (R01MContent)object[0];
                    document = (R01MDocument)object[1];
                    objectLoadedOK = true;
                }
            }
            if (objectLoadedOK) {
                if (pubDef.getAggregatorPacketOid() != null && pubDef.getAggregatorItemOid() != null) {
                    try {
                        ArrayList<R01MDocumentPublicationTarget> docPublicationInfoInDB = document.getPublicationInfo();
                        if (docPublicationInfoInDB == null) {
                            docPublicationInfoInDB = new ArrayList<R01MDocumentPublicationTarget>();
                        } else {
                            List<R01MDocumentPublicationTarget> objectsToRemove = this._getRunningPublicationsForClean(docPublicationInfoInDB, pubDef, document);
                            docPublicationInfoInDB.removeAll(objectsToRemove);
                        }
                        R01MDocumentPublicationTarget newPublicationTarget = this._setNewPublicationTarget(pubDef, content, document);
                        docPublicationInfoInDB.add(newPublicationTarget);
                        document.setPublicationInfo(docPublicationInfoInDB);
                        R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).saveDocument(content, document);
                    }
                    catch (Exception ex) {
                        throw new R01MPublisherException(ex);
                    }
                }
                boolean loadFilelistOK = true;
                List<R01MPublicationResourceItem> resourcesToPublishList = null;
                try {
                    resourcesToPublishList = this._prepareFilelistToPublish(content, document, pubDef.getObjectType(), pubDef.getResourcesRelativePaths());
                }
                catch (R01MPublisherException pEx) {
                    pubDef.setPublicationState(-1);
                    loadFilelistOK = false;
                    this._managePublishException(pubDef, pEx, 0);
                }
                if (loadFilelistOK) {
                    try {
                        if (pubDef.getObjectType() == 9 || pubDef.getObjectType() == 8 || pubDef.getObjectType() == 21) {
                            R01MDataStoreManager dsManager = this._getDsManager();
                            this._updateLangUrlInContentApacheVarFile(pubDef.getRepositoryOid(), content.getStoreLocation(), dsManager, content.getTypo().getTypeOid() + "/" + content.getInternalName(), pubDef.getObjectType() == 9 ? document.getLanguage() + "_" + document.getInternalName() : null);
                        }
                    }
                    catch (R01MDataStoreException dsEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish >> Error al acceder al dataStore: " + dsEx.getMessage());
                    }
                    boolean allCommitedCorrectly = this._consolidateResources(pubDef.getObjectType(), content, document == null ? null : document.getOid(), resourcesToPublishList);
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("R01DPublisherManager.prepareToPublish >>  ... recursos consolidados " + (allCommitedCorrectly ? "CORRECTAMENTE" : "CON ERRORES") + " para el objeto " + (StringUtils.isEmptyString((String)pubDef.getObjectOid()) ? " [empty / null] " : pubDef.getObjectOid()) + " de tipo " + Integer.toString(pubDef.getObjectType()));
                    }
                    boolean executedSpecificMethodOK = true;
                    if (pubDef.getStepsActions() != null && !pubDef.getStepsActions().isEmpty()) {
                        R01MPublishActionObject prepareToPublishAction = (R01MPublishActionObject)pubDef.getStepsActions().get(0);
                        Object prepareToPublishActionManager = null;
                        if (prepareToPublishAction.getStep() == 0) {
                            try {
                                prepareToPublishActionManager = ReflectionUtils.getObjectInstance((String)prepareToPublishAction.getActionClass(), null, null, (boolean)true);
                            }
                            catch (ReflectionException rEx) {
                                throw new R01MPublisherException("R01DPublisherManager.prepareToPublish >> Error al instanciar la clase manejadora de las acciones de preparaci\u00f3n de la publicaci\u00f3n: " + prepareToPublishAction.getActionClass() + "Al llamar a la ejecuci\u00f3n de la publicaci\u00f3n del " + "objeto " + pubDef.getObjectOid() + " de " + "tipo " + R01MConstants.OBJECT_DESCS[pubDef.getObjectType()] + ". " + "Error: " + rEx.getMessage(), (Exception)((Object)rEx));
                            }
                            try {
                                ReflectionUtils.invokeMethod((Object)prepareToPublishActionManager, (String)prepareToPublishAction.getMethod(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{prepareToPublishAction.getObjectOid(), prepareToPublishAction.getParam()});
                            }
                            catch (ReflectionException refEx) {
                                pubDef.setPublicationState(-1);
                                executedSpecificMethodOK = false;
                                this._managePublishException(pubDef, refEx, 0);
                            }
                            catch (Throwable ex) {
                                pubDef.setPublicationState(-1);
                                executedSpecificMethodOK = false;
                                this._managePublishException(pubDef, ex, 0);
                            }
                        }
                    }
                    if (executedSpecificMethodOK) {
                        try {
                            pubDef.setPublicationState(-1);
                            this._sendStepFinishedMessage("OK", "Prepare to publish finished correctly", 0, pubDef);
                        }
                        catch (R01MPublisherException pubEx) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish >> Error al mandar el mensaje de finished: " + pubEx.getMessage() + " de OK");
                            throw pubEx;
                        }
                    }
                }
            }
        }
    }

    public void prePublish(R01PPublishDefinition pubDef) throws R01MPublisherException {
        boolean inputParamsOK = true;
        try {
            this._checkPublishProcessInputParams(1, pubDef);
        }
        catch (R01MPublisherException pEx) {
            pubDef.setPublicationState(-1);
            inputParamsOK = false;
            this._managePublishException(pubDef, pEx, 1);
        }
        if (inputParamsOK) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("R01DPublisherManager.prePublish >> Par\u00e1metros de entrada: USUARIO QUE LANZA LA PUBLICACI\u00d3N: " + pubDef.debugInfo("").toString());
            }
            if (pubDef.getObjectType() == 16) {
                boolean updateFileStructure = true;
                R01DContentModelLoaderHelper loader = new R01DContentModelLoaderHelper();
                try {
                    if ((loader.loadDocumentAliasesInState(pubDef.getObjectOid(), 1) == null || loader.loadDocumentAliasesInState(pubDef.getObjectOid(), 1).isEmpty()) && (loader.loadDocumentAliasesInState(pubDef.getObjectOid(), 0) == null || loader.loadDocumentAliasesInState(pubDef.getObjectOid(), 0).isEmpty())) {
                        updateFileStructure = false;
                    }
                }
                catch (R01DContentModelPersistenceException cmEx) {
                    throw new R01MPublisherException("R01DPublisherManager.prePublish >> Error al cargar los alias del documento: Al llamar a la ejecuci\u00f3n de la publicaci\u00f3n del objeto " + pubDef.getObjectOid() + " de " + "tipo " + R01MConstants.OBJECT_DESCS[pubDef.getObjectType()] + ". " + "Error: " + cmEx.getMessage(), (Exception)((Object)cmEx));
                }
                if (updateFileStructure) {
                    R01MContentModelAPI contentAPI = R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx);
                    try {
                        R01MContent content = contentAPI.loadContent(contentAPI.getDocumentParentContent(pubDef.getObjectOid()));
                        new R01PAliasManagerAPI().updateApacheRules(pubDef.getObjectOid(), 1, true);
                        this._consolidateResources(pubDef.getObjectType(), content, pubDef.getObjectOid(), null);
                    }
                    catch (R01MSecurityException secEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prePublish >> Error en el paso prePub de la publicaci\u00f3n de alias de contenido.Error al obtener el objeto contenido. Error:" + secEx.getMessage());
                        throw new R01MPublisherException("Error en el paso prePub de la publicaci\u00f3n de alias de contenido.Error al obtener el objeto contenido. Error:" + secEx.getMessage(), (Exception)((Object)secEx));
                    }
                    catch (R01MContentModelException cmEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prePublish >> Error en el paso prePub de la publicaci\u00f3n de alias de contenido.Error al obtener el objeto contenido. Error:" + cmEx.getMessage());
                        throw new R01MPublisherException("Error en el paso prePub de la publicaci\u00f3n de alias de contenido.Error al obtener el objeto contenido. Error:" + cmEx.getMessage(), (Exception)((Object)cmEx));
                    }
                }
            }
            boolean executedSpecificMethodOK = true;
            if (pubDef.getStepsActions() != null && !pubDef.getStepsActions().isEmpty()) {
                R01MPublishActionObject prePublishAction = (R01MPublishActionObject)pubDef.getStepsActions().get(0);
                Object prepareToPublishActionManager = null;
                if (prePublishAction.getStep() == 1) {
                    try {
                        prepareToPublishActionManager = ReflectionUtils.getObjectInstance((String)prePublishAction.getActionClass(), null, null, (boolean)true);
                    }
                    catch (ReflectionException rEx) {
                        throw new R01MPublisherException("R01DPublisherManager.prePublish >> Error al instanciar la clase manejadora de las acciones de pre-publicaci\u00f3n: " + prePublishAction.getActionClass() + "Al llamar a la ejecuci\u00f3n de la publicaci\u00f3n del " + "objeto " + pubDef.getObjectOid() + " de " + "tipo " + R01MConstants.OBJECT_DESCS[pubDef.getObjectType()] + ". " + "Error: " + rEx.getMessage(), (Exception)((Object)rEx));
                    }
                    try {
                        ReflectionUtils.invokeMethod((Object)prepareToPublishActionManager, (String)prePublishAction.getMethod(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{prePublishAction.getObjectOid(), prePublishAction.getParam()});
                    }
                    catch (ReflectionException refEx) {
                        pubDef.setPublicationState(-1);
                        executedSpecificMethodOK = false;
                        this._managePublishException(pubDef, refEx, 1);
                    }
                    catch (Throwable ex) {
                        pubDef.setPublicationState(-1);
                        executedSpecificMethodOK = false;
                        this._managePublishException(pubDef, ex, 1);
                    }
                }
            }
            if (executedSpecificMethodOK) {
                try {
                    pubDef.setPublicationState(-1);
                    this._sendStepFinishedMessage("OK", "PrePublish finished correctly", 1, pubDef);
                }
                catch (R01MPublisherException pubEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prePublish >> Error al mandar el mensaje de finished: " + pubEx.getMessage() + " de OK");
                    throw pubEx;
                }
            }
        }
    }

    public void publish(R01PPublishDefinition pubDef) throws R01MPublisherException {
    }

    public void postPublish(R01PPublishDefinition pubDef) throws R01MPublisherException {
        boolean inputParamsOK = true;
        try {
            this._checkPublishProcessInputParams(3, pubDef);
            if (pubDef.getPublicationState() == -1) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.postPublish >> Se ha solicitado el proceso de postPublish y el estado final de la publicaci\u00f3n no tiene valor.");
                throw new R01MPublisherException("Se ha solicitado el proceso de postPublish y el estado final de la publicaci\u00f3n no tiene valor.");
            }
        }
        catch (R01MPublisherException pEx) {
            this._managePublishException(pubDef, pEx, 3);
            inputParamsOK = false;
        }
        if (inputParamsOK) {
            R01MPublishActionObject postPublishAction;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("R01DPublisherManager.postPublish >> Par\u00e1metros de entrada:" + pubDef.debugInfo("").toString() + "\n ESTADO FINAL DE LA PUBLICACI\u00d3N: " + R01MBasePublicationTarget.getPublicationStateLabel((int)pubDef.getPublicationState()));
            }
            R01MContentModelAPI contentAPI = R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx);
            R01MDocument document = null;
            R01MContent content = null;
            if (pubDef.getObjectType() == 0 || pubDef.getObjectType() == 1) {
                boolean objectLoadedOK = true;
                if (!StringUtils.isEmptyString((String)pubDef.getObjectOid())) {
                    Object[] object = null;
                    try {
                        object = this._getContentAndDocument(pubDef.getObjectOid(), pubDef.getObjectType());
                    }
                    catch (R01MPublisherException pEx) {
                        this._managePublishException(pubDef, pEx, 3);
                        objectLoadedOK = false;
                    }
                    if (objectLoadedOK) {
                        content = (R01MContent)object[0];
                        document = (R01MDocument)object[1];
                    }
                } else {
                    objectLoadedOK = false;
                }
                if (objectLoadedOK && content != null) {
                    this._injectAutonomyUnindexInPostPublish(content, document, pubDef);
                    boolean publicationInfoOK = true;
                    R01MLogicalPublicationInfo logicalPublicationInfo = null;
                    try {
                        logicalPublicationInfo = R01MClientFactory.getPublisherConfigAPI().getLogicalPublicationConfig(pubDef.getRepositoryOid());
                    }
                    catch (R01MConfigLoadException cfgEx) {
                        this._managePublishException(pubDef, cfgEx, 3);
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.postPublish >> Error al cargar la informaci\u00f3n l\u00f3gica de la publicaci\u00f3n de " + pubDef.getRepositoryOid() + "Error:" + cfgEx.getMessage());
                        publicationInfoOK = false;
                    }
                    if (publicationInfoOK) {
                        List<String> logicalDestinationNames = Arrays.asList(logicalPublicationInfo.getDestinationSystemsOids());
                        ArrayList<R01MPublicationDestination> publicationDestinationList = new ArrayList<R01MPublicationDestination>(logicalDestinationNames.size());
                        Iterator<String> iteratorLogicalDestinationNames = logicalDestinationNames.iterator();
                        while (iteratorLogicalDestinationNames.hasNext()) {
                            R01MPublicationDestination logicalDest = new R01MPublicationDestination(iteratorLogicalDestinationNames.next());
                            publicationDestinationList.add(logicalDest);
                        }
                        ArrayList<Object> documentsToPublish = new ArrayList<R01MDocument>();
                        if (pubDef.getObjectType() == 0) {
                            if (content != null && content.getDocuments() != null && !content.getDocuments().isEmpty()) {
                                documentsToPublish = new ArrayList(content.getDocuments().values());
                            }
                        } else if (pubDef.getObjectType() == 1 && document != null) {
                            if (content.getDocument(document.getOid()) == null) {
                                try {
                                    documentsToPublish.add(R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).loadDocument(document.getOid()));
                                }
                                catch (Exception ex) {
                                    throw new R01MPublisherException("R01DPublisherManager.postPublish >> Error al cargar el documento:  " + document.getOid());
                                }
                            } else {
                                documentsToPublish.add(content.getDocument(document.getOid()));
                            }
                        }
                        R01DContentModelManager contentManager = new R01DContentModelManager();
                        for (R01MDocument currDocument : documentsToPublish) {
                            boolean previousDocumentPublicationState = false;
                            try {
                                previousDocumentPublicationState = contentManager.isDocumentPublished(this._userCtx, logicalPublicationInfo.getOid(), currDocument.getOid());
                            }
                            catch (R01MContentModelException cmExc) {
                                R01FLog.to((String)LOG_TYPE_ID).warning("Error en la validaci\u00f3n del estado de publicaci\u00f3n del documento '" + currDocument.getOid() + "' en el repositorio '" + logicalPublicationInfo.getOid() + "'");
                            }
                            boolean updateInfoOK = true;
                            try {
                                this._updatePublishInfo(content, currDocument, pubDef.getRepositoryOid(), pubDef.getPublicationType(), publicationDestinationList, pubDef.getPublicationDate(), pubDef.getPublicationState());
                            }
                            catch (R01MPublisherException pEx) {
                                this._managePublishException(pubDef, pEx, 3);
                                R01FLog.to((String)LOG_TYPE_ID).severe("Post publish finished with errors. Error: " + pEx.getMessage());
                                updateInfoOK = false;
                            }
                            if (!updateInfoOK) continue;
                            contentManager._sendHistoryMessage(pubDef.getUserName(), content, (R01MBaseDocumentInterface)currDocument, null, 1, pubDef.getPublicationState() == 0 ? 20 : 10, "Documento " + (document == null ? "" : document.getInternalName()) + " " + R01MBasePublicationTarget.getPublicationStateLabel((int)pubDef.getPublicationState()) + " correctamente. Repositorio de publicaci\u00f3n: " + pubDef.getRepositoryOid());
                            boolean lastPublicationState = currDocument.isPublishedInRepository(logicalPublicationInfo.getOid());
                            if (pubDef.getAggregatorPacketOid() == null && pubDef.getAggregatorItemOid() == null) {
                                List includePatterns;
                                R01MContentType typoObj;
                                try {
                                    R01MLinkedResourcesGroup lnkResources = contentManager.doGetDocumentLinkedResources(this._userCtx, currDocument.getOid());
                                    for (R01MLinkedResource lnkResource : lnkResources.getResources().values()) {
                                        if (StringUtils.isEmptyString((String)lnkResource.getRelatedDocumentContentOid()) || StringUtils.isEmptyString((String)lnkResource.getRelatedDocumentDocumentOid()) || lastPublicationState == previousDocumentPublicationState) continue;
                                        ArrayList<String> repositories = new ArrayList<String>();
                                        repositories.add(lnkResource.getRelatedDocumentContentRepositoryOid());
                                        try {
                                            R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).renderAndPublishDocumentLinkedResources(lnkResource.getRelatedDocumentContentOid(), lnkResource.getRelatedDocumentDocumentOid(), repositories);
                                        }
                                        catch (R01MSecurityException secExc) {
                                            R01FLog.to((String)LOG_TYPE_ID).warning("Error al regenerar y republicar las vinculaciones de contenidos.Error:" + secExc.getMessage());
                                        }
                                    }
                                }
                                catch (R01MContentModelException cmExc) {
                                    R01FLog.to((String)LOG_TYPE_ID).warning("Error al regenerar y republicar las vinculaciones de contenidos.Error:" + cmExc.getMessage());
                                }
                                try {
                                    typoObj = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(content.getTypo().getClusterOid(), content.getTypo().getFamilyOid(), content.getTypo().getTypeOid());
                                }
                                catch (R01MConfigLoadException clEx) {
                                    this._managePublishException(pubDef, clEx, 3);
                                    R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.postPublish >> Error al mandar el mensaje de inedxacion: " + clEx.getMessage());
                                    throw new R01MPublisherException((Exception)((Object)clEx));
                                }
                                R01MTypologyPubConfig typoPubConfig = typoObj.getPublisherConfig();
                                if (typoPubConfig == null || (includePatterns = typoPubConfig.getIncludeContentPatterns()) == null || includePatterns.isEmpty() || document == null) continue;
                                String include = "";
                                HashMap<String, String> langMap = new HashMap<String, String>();
                                langMap.put("lang", document.getLanguage());
                                for (String includePattern : includePatterns) {
                                    include = include + StringUtils.replaceVariableValues((String)includePattern, (char)'$', langMap) + "|";
                                }
                                if (!include.endsWith("|")) continue;
                                include = include.substring(0, include.length() - 1);
                                this._sendDocumentRelativeResourcesInContentPath(pubDef, include);
                                continue;
                            }
                            if (StringUtils.isEmptyString((String)pubDef.getAggregatorPacketOid()) || StringUtils.isEmptyString((String)pubDef.getAggregatorItemOid())) continue;
                            HashMap<String, Boolean> states = new HashMap<String, Boolean>();
                            states.put(logicalPublicationInfo.getOid(), lastPublicationState != previousDocumentPublicationState);
                            this._sendAggregatorItemFinishedMessage(pubDef.getAggregatorItemOid(), pubDef.getAggregatorPacketOid(), states);
                        }
                        this._sendAliasMessage(pubDef, content);
                        this._executePendingAction(content, document);
                    }
                }
            } else if (pubDef.getObjectType() == 16) {
                try {
                    if (contentAPI.checkDocumentExistence(pubDef.getObjectOid())) {
                        R01DAliasAdminManager aliasManager = new R01DAliasAdminManager(this._userCtx);
                        try {
                            aliasManager.doDeleteDocumentAliasesInState(pubDef.getObjectOid(), 0);
                        }
                        catch (R01MContentModelException cmEx) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.postPublish >> Error en el paso postPub de la publicaci\u00f3n de alias de contenido.Error al eliminar los alias del documento " + pubDef.getObjectOid() + ". " + "Error:" + cmEx.getMessage());
                        }
                    }
                }
                catch (R01MSecurityException ex) {
                    throw new R01MPublisherException((Exception)((Object)ex));
                }
                catch (R01MContentModelException ex) {
                    throw new R01MPublisherException((Exception)((Object)ex));
                }
            }
            if (pubDef.getStepsActions() != null && !pubDef.getStepsActions().isEmpty() && (postPublishAction = (R01MPublishActionObject)pubDef.getStepsActions().get(0)).getStep() == 3) {
                Object prepareToPublishActionManager;
                try {
                    prepareToPublishActionManager = ReflectionUtils.getObjectInstance((String)postPublishAction.getActionClass(), null, null, (boolean)true);
                }
                catch (ReflectionException rEx) {
                    throw new R01MPublisherException("R01DPublisherManager.postPublish >> Error al instanciar la clase manejadora de las acciones de publicaci\u00f3n: " + postPublishAction.debugInfo("").toString() + ". " + "Error: " + rEx.getMessage(), (Exception)((Object)rEx));
                }
                try {
                    ReflectionUtils.invokeMethod((Object)prepareToPublishActionManager, (String)postPublishAction.getMethod(), (Class[])new Class[]{String.class, String.class}, (Object[])new Object[]{postPublishAction.getObjectOid(), postPublishAction.getParam()});
                    try {
                        this._sendStepFinishedMessage("OK", "PostPublish finished correctly", 3, pubDef);
                    }
                    catch (R01MPublisherException pubEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.postPublish >> Error al mandar el mensaje de finished: " + pubEx.getMessage() + " de OK");
                        throw pubEx;
                    }
                }
                catch (ReflectionException refEx) {
                    this._managePublishException(pubDef, refEx, 3);
                    pubDef.setPublicationState(-1);
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.postPublish >> Error al ejecutar las acciones mandar el mensaje de finished con el error: " + refEx.getMessage());
                }
                catch (Throwable ex) {
                    try {
                        pubDef.setPublicationState(-1);
                        this._sendStepFinishedMessage("ERROR", "PostPublish finished with errors. Error: " + ex.getMessage(), 3, pubDef);
                    }
                    catch (R01MPublisherException pubEx) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.postPublish >> Error al mandar el mensaje de finished: " + pubEx.getMessage() + " " + "con el error: " + ex.getMessage());
                    }
                }
            }
        }
    }

    public void postPublishIndex(R01PPublishDefinition pubDef) throws R01MPublisherException {
        if ((pubDef.getObjectType() == 0 || pubDef.getObjectType() == 1) && pubDef.isExecuteIndexOnPostPublish()) {
            try {
                this._sendIndexMessage(pubDef.getObjectOid(), pubDef.getObjectType(), pubDef.getRepositoryOid(), pubDef.getPublicationType(), pubDef.getPublicationDate());
            }
            catch (R01MPublisherException pEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.postPublishIndex >> Error al mandar el mensaje de indexacion tras haber finalizado el postPublish: " + pEx.getMessage());
                throw pEx;
            }
        }
    }

    public void updateStatePublishInfo(String objectOid, int objectType, String publicationOid, int publicationState) throws R01MPublisherException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("R01DPublisherManager.updateStatePublishInfo >> Actualizando el estado de las publicaciones...");
        }
        if (objectType != 0 && objectType != 1) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.updateStatePublishInfo >> Desde el modelo de contenidos s\u00f3lo se actualizar\u00e1 el estado de los objetos de tipo contenido o documento. \nNo se actualiza la petici\u00f3n para el objeto " + objectOid + " de " + "tipo " + objectType + " con " + "oid de publicaci\u00f3n " + publicationOid + " para el " + "estado de publicaci\u00f3n: " + publicationState);
        } else {
            if (StringUtils.isEmptyString((String)publicationOid)) {
                throw new R01MPublisherException("Se ha solicitado una actualizaci\u00f3n de estado de publicaci\u00f3n y no se ha indicado el Oid de la publicaci\u00f3n a actualizar. No se actualiza la petici\u00f3n para el objeto " + objectOid + " de " + "tipo " + objectType + " con " + "oid de publicaci\u00f3n " + publicationOid + " para el " + "estado de publicaci\u00f3n: " + publicationState);
            }
            Object[] object = this._getContentAndDocument(objectOid, objectType);
            R01MContent content = (R01MContent)object[0];
            R01MDocument document = (R01MDocument)object[1];
            ArrayList<Object> documentsToUpdate = new ArrayList<Object>();
            if (document != null) {
                documentsToUpdate.add(document);
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("R01DPublisherManager.updateStatePublishInfo >> Actualizar el documento '" + document.getOid() + "' del contenido '" + content.getOid() + "'");
                }
            } else {
                documentsToUpdate.addAll(content.getDocuments().values());
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("R01DPublisherManager.updateStatePublishInfo >> Actualizar TODOS los documentos del contenido '" + content.getOid() + "'");
                }
            }
            R01DContentModelManager contentManager = new R01DContentModelManager();
            block8: for (R01MDocument r01MDocument : documentsToUpdate) {
                if (r01MDocument.getPublicationInfo() == null || r01MDocument.getPublicationInfo().isEmpty()) {
                    if (!DEBUG) continue;
                    R01FLog.to((String)LOG_TYPE_ID).warning("R01DPublisherManager.updateStatePublishInfo >> Error al actualizar la publicaci\u00f3n. No existe ninguna publicaci\u00f3n de OID '" + publicationOid + "' " + "para el documento '" + document.getOid() + "' " + "del contenido '" + content.getOid() + "'.");
                    continue;
                }
                for (R01MDocumentPublicationTarget newPublicationTarget : r01MDocument.getPublicationInfo()) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("R01DPublisherManager.updateStatePublishInfo >> Actualizar la publicaci\u00f3n '" + newPublicationTarget.getPublicationOid() + "' del documento '" + document.getOid() + "' del contenido '" + content.getOid() + "'");
                    }
                    if (!publicationOid.equals(newPublicationTarget.getPublicationOid())) continue;
                    newPublicationTarget.setState(publicationState);
                    newPublicationTarget.setPublishDate(R01MDateUtils.today());
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("R01DPublisherManager.updateStatePublishInfo >> Actualizar el estado de la publicaci\u00f3n '" + newPublicationTarget.getPublicationOid() + "' del documento '" + document.getOid() + "' del contenido '" + content.getOid() + "' al estado " + publicationState);
                    }
                    try {
                        contentManager.doSaveDocument(this._userCtx, content.getOid(), r01MDocument);
                        continue block8;
                    }
                    catch (R01MSecurityException secEx) {
                        throw new R01MPublisherException((Exception)((Object)secEx));
                    }
                    catch (R01MContentModelException cmEx) {
                        throw new R01MPublisherException((Exception)((Object)cmEx));
                    }
                    catch (R01MDeleteModelObjectException delEx) {
                        throw new R01MPublisherException((Exception)((Object)delEx));
                    }
                    catch (R01MDuplicateModelObjectException dupEx) {
                        throw new R01MPublisherException((Exception)((Object)dupEx));
                    }
                    catch (R01MDirtyContentModelException ex) {
                        continue block8;
                    }
                }
            }
        }
    }

    private List<R01MDocumentPublicationTarget> _getRunningPublicationsForClean(List<R01MDocumentPublicationTarget> docPublicationInfoInDB, R01PPublishDefinition currentPublication, R01MDocument document) {
        ArrayList<R01MDocumentPublicationTarget> objectsToRemove = new ArrayList<R01MDocumentPublicationTarget>();
        for (R01MDocumentPublicationTarget pubInDB : docPublicationInfoInDB) {
            if (!pubInDB.getOid().equals(currentPublication.getRepositoryOid()) || (pubInDB.getState() != 4 || currentPublication.getPublicationType() != 1 && currentPublication.getPublicationType() != 0) && (pubInDB.getState() != 5 || currentPublication.getPublicationType() != 3 && currentPublication.getPublicationType() != 2)) continue;
            try {
                if (pubInDB.getPublishDate() != null && pubInDB.getPublishDate().after(new Date())) {
                    R01MPublisherAPI publisherAPI = R01MClientFactory.getPublisherAPI();
                    R01MPublish pub = publisherAPI.obtainPublicationInfoObject(null, document.getOid(), 1, null, null, null, pubInDB.getOid(), currentPublication.getPublicationType(), pubInDB.getPublishDate());
                    pub.setOid(pubInDB.getPublicationOid());
                    publisherAPI.removeDeployment(pub);
                }
            }
            catch (Exception pEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish >> Error al cargar o guardar la informaci\u00f3n de publicaci\u00f3n del documento " + document.getOid() + ": " + pEx.getMessage());
            }
            objectsToRemove.add(pubInDB);
            break;
        }
        return objectsToRemove;
    }

    private R01MDocumentPublicationTarget _setNewPublicationTarget(R01PPublishDefinition currentPublication, R01MContent content, R01MDocument document) {
        R01MLogicalPublicationInfo logicalPublicationInfo;
        R01MDataFile datafileInitialPage;
        R01MDocumentPublicationTarget newPublicationTarget;
        block13: {
            block12: {
                newPublicationTarget = new R01MDocumentPublicationTarget();
                newPublicationTarget.setOid(currentPublication.getRepositoryOid());
                try {
                    newPublicationTarget.setPublicationOid(R01MUtils.generateNewOid((String)R01MConstants.PUBLISHER_APPCODE));
                }
                catch (GUIDDispenserException gdEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish(_setNewPublicationTarget) >> Error al crear el OID de publicaci\u00f3n para el documento " + document.getOid() + " en el repositorio " + currentPublication.getRepositoryOid() + " para el tipo de publicaci\u00f3n " + currentPublication.getPublicationType() + ". Error: " + gdEx.getMessage());
                }
                newPublicationTarget.setState(currentPublication.getPublicationType() == 0 || currentPublication.getPublicationType() == 1 ? 4 : 5);
                newPublicationTarget.setPublishDate(currentPublication.getPublicationType() == 0 || currentPublication.getPublicationType() == 2 ? new Date() : currentPublication.getPublicationDate());
                datafileInitialPage = null;
                try {
                    R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(R01MAuthManager.createMasterSystemUserContext());
                    datafileInitialPage = document.getDocumentInitialDataFile() instanceof R01MDataFile ? document.getDocumentInitialDataFile() : loaderHelper.loadDocumentDataFileLazy(document.getOid(), document.getDocumentInitialDataFile().getOid());
                }
                catch (R01DContentModelPersistenceException cmEx) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish(_setNewPublicationTarget) >> Error al cargar el datafile principal del documento " + document.getOid() + ". " + "Error: " + cmEx.getMessage());
                    }
                }
                catch (R01MSecurityException secEx) {
                    if (!DEBUG) break block12;
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish(_setNewPublicationTarget) >> Error al cargar el datafile principal del documento " + document.getOid() + ". " + "Error: " + secEx.getMessage());
                }
            }
            logicalPublicationInfo = null;
            try {
                logicalPublicationInfo = R01MClientFactory.getPublisherConfigAPI().getLogicalPublicationConfig(currentPublication.getRepositoryOid());
            }
            catch (R01MConfigLoadException cfgEx) {
                if (!DEBUG) break block13;
                R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish(_setNewPublicationTarget) >> Error al cargar la informaci\u00f3n l\u00f3gica de la publicaci\u00f3n de " + currentPublication.getRepositoryOid() + ". " + "Error: " + cfgEx.getMessage());
            }
        }
        List<Object> logicalDestinationNames = logicalPublicationInfo == null ? new ArrayList() : Arrays.asList(logicalPublicationInfo.getDestinationSystemsOids());
        ArrayList<R01MPublicationDestination> publicationDestinationList = new ArrayList<R01MPublicationDestination>(logicalDestinationNames.size());
        Iterator<Object> iteratorLogicalDestinationNames = logicalDestinationNames.iterator();
        while (iteratorLogicalDestinationNames.hasNext()) {
            R01MPublicationDestination logicalDest = new R01MPublicationDestination((String)iteratorLogicalDestinationNames.next());
            publicationDestinationList.add(logicalDest);
        }
        newPublicationTarget.setUrl(currentPublication.getPublicationType() == 0 || currentPublication.getPublicationType() == 1 ? R01MURLHelpper.getDefaultGeneratedDataFileViewURL((String)document.getLanguage(), (R01MContentTypologyInfo)content.getTypo(), (R01MContentLocation)content.getStoreLocation(), (String)content.getOid(), (String)content.getInternalName(), (String)content.getName(), (String)document.getOid(), (String)document.getLanguage(), (String)document.getInternalName(), (String)datafileInitialPage.getOid(), (String)datafileInitialPage.getInternalName(), (String)datafileInitialPage.getName(), (String)datafileInitialPage.getTemplateOid(), (String)currentPublication.getRepositoryOid(), (String)((R01MPublicationDestination)publicationDestinationList.get(0)).getOid()) : "/");
        if (document.getUrlAliases() != null && !document.getUrlAliases().isEmpty()) {
            for (int i = 0; i < document.getUrlAliases().size(); ++i) {
                R01MURLAlias alias = (R01MURLAlias)document.getUrlAliases().get(i);
                if (!alias.isBaseAlias()) continue;
                newPublicationTarget.setMainAlias(((R01MURLAlias)document.getUrlAliases().get(i)).getAlias());
            }
            if (StringUtils.isEmptyString((String)newPublicationTarget.getMainAlias())) {
                newPublicationTarget.setMainAlias(((R01MURLAlias)document.getUrlAliases().get(0)).getAlias());
            }
        }
        return newPublicationTarget;
    }

    private R01MDocumentPublicationTarget _getNewPublicationTarget(String publicationOid, int publicationType, Date publicationDate, int publicationState, R01MContent content, R01MDocument document, String repositoryOid, List<R01MPublicationDestination> publicationDestinationList) throws R01MPublisherException {
        R01MDataFile datafileInitialPage = null;
        try {
            R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(R01MAuthManager.createMasterSystemUserContext());
            datafileInitialPage = document.getDocumentInitialDataFile() instanceof R01MDataFile ? document.getDocumentInitialDataFile() : loaderHelper.loadDocumentDataFileLazy(document.getOid(), document.getDocumentInitialDataFile().getOid());
        }
        catch (R01DContentModelPersistenceException cmEx) {
            throw new R01MPublisherException("\u00a1\u00a1\u00a1 En el documento de oid " + document.getOid() + " no se ha podido cargar el datafile de inicio: " + cmEx.getMessage());
        }
        catch (R01MSecurityException secEx) {
            throw new R01MPublisherException("\u00a1\u00a1\u00a1 En el documento de oid " + document.getOid() + " no se ha podido cargar el datafile de inicio: " + secEx.getMessage());
        }
        if (datafileInitialPage == null) {
            throw new R01MPublisherException("\u00a1\u00a1\u00a1 El documento de oid " + document.getOid() + " no tiene ARCHIVO DE INICIO !!!");
        }
        R01MDocumentPublicationTarget newPublicationTarget = new R01MDocumentPublicationTarget();
        newPublicationTarget.setOid(repositoryOid);
        try {
            newPublicationTarget.setPublicationOid(R01MUtils.generateNewOid((String)R01MConstants.PUBLISHER_APPCODE));
        }
        catch (GUIDDispenserException gdEx) {
            throw new R01MPublisherException("Error al crear el OID de publicaci\u00f3n para el documento " + document.getOid() + " en el repositorio " + repositoryOid + " para el tipo de publicaci\u00f3n " + publicationType + ". Error: " + gdEx.getMessage(), (Exception)((Object)gdEx));
        }
        newPublicationTarget.setState(publicationState);
        newPublicationTarget.setPublishDate(publicationDate);
        newPublicationTarget.setUrl(publicationType == 0 || publicationType == 1 ? R01MURLHelpper.getDefaultGeneratedDataFileViewURL((String)document.getLanguage(), (R01MContentTypologyInfo)content.getTypo(), (R01MContentLocation)content.getStoreLocation(), (String)content.getOid(), (String)content.getInternalName(), (String)content.getName(), (String)document.getOid(), (String)document.getLanguage(), (String)document.getInternalName(), (String)datafileInitialPage.getOid(), (String)datafileInitialPage.getInternalName(), (String)datafileInitialPage.getName(), (String)datafileInitialPage.getTemplateOid(), (String)repositoryOid, (String)publicationDestinationList.get(0).getOid()) : "/");
        if (document.getUrlAliases() != null && !document.getUrlAliases().isEmpty()) {
            for (int i = 0; i < document.getUrlAliases().size(); ++i) {
                if (!((R01MURLAlias)document.getUrlAliases().get(i)).isBaseAlias()) continue;
                newPublicationTarget.setMainAlias(((R01MURLAlias)document.getUrlAliases().get(i)).getAlias());
            }
            if (StringUtils.isEmptyString((String)newPublicationTarget.getMainAlias())) {
                newPublicationTarget.setMainAlias(((R01MURLAlias)document.getUrlAliases().get(0)).getAlias());
            }
        }
        if (!StringUtils.isEmptyString((String)publicationOid)) {
            newPublicationTarget.setPublicationOid(publicationOid);
        }
        return newPublicationTarget;
    }

    private void _managePublishException(R01PPublishDefinition currentPublication, Throwable pEx, int source) {
        String sourceString = "unknown";
        if (source == 0) {
            sourceString = "prepareToPublish";
        } else if (source == 1) {
            sourceString = "prePublish";
        } else if (source == 2) {
            sourceString = "publish";
        } else if (source == 3) {
            sourceString = "postpublish";
        }
        try {
            this._updateErrorPublicationState(currentPublication);
            this._sendStepFinishedMessage("ERROR", sourceString + " finished with errors. Error: " + pEx.getMessage(), source, currentPublication);
        }
        catch (R01MPublisherException pubEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager." + sourceString + " >> " + "Error al mandar el mensaje de finished: " + pubEx.getMessage() + " " + "con el error: " + pEx.getMessage());
        }
    }

    private void _injectAutonomyUnindexInPostPublish(R01MContent content, R01MDocument document, R01PPublishDefinition currentPublication) {
        if (!(document == null || document.getPublicationInfo() == null || document.getPublicationInfo().isEmpty() || StringUtils.isEmptyString((String)currentPublication.getRepositoryOid()) || currentPublication.getPublicationType() != 2 && currentPublication.getPublicationType() != 3)) {
            for (R01MDocumentPublicationTarget publicationInDB : document.getPublicationInfo()) {
                if (!publicationInDB.getOid().equals(currentPublication.getRepositoryOid()) || publicationInDB.getState() != 1 && publicationInDB.getState() != 4) continue;
                String gendataDomainPrefix = XMLProperties.getProperty((String)R01MConstants.INTERNALAPI_APPCODE, (String)("autonomy/gendataPrefixInAutonomy/" + currentPublication.getRepositoryOid()), (String)"http://www.euskadi.net");
                StringBuffer gendataUrl = new StringBuffer();
                gendataUrl.append(gendataDomainPrefix).append(!publicationInDB.getUrl().startsWith("/contenidos/") ? "/contenidos/" : "").append(publicationInDB.getUrl().substring(0, publicationInDB.getUrl().lastIndexOf(47))).append("/").append(XMLProperties.getProperty((String)R01MConstants.INTERNALAPI_APPCODE, (String)"autonomy/autonomyIndexService/gendataFileName", (String)"r01_gendata.txt"));
                try {
                    R01PClientFactory.getSearchEngineIndexerAPI().injectDataForIndexInAutonomy(content.getOid(), document.getOid(), 1, "-", gendataUrl.toString(), currentPublication.getRepositoryOid());
                }
                catch (R01MSearchIndexerException siEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.postPublish(_injectAutonomyUnindexInPostPublish) >> Error al mandar a desindexar directamente en el autonomy el documento " + document.getOid() + ": " + siEx.getMessage());
                }
                break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<R01MPublicationResourceItem> _prepareFilelistToPublish(R01MContent content, R01MDocument document, int objectType, List<String> resourcesRelativePaths) throws R01MPublisherException {
        block41: {
            resourcesToPublishList = new ArrayList<R01MPublicationResourceItem>();
            fileListName = "";
            if (objectType == 9) {
                fileListName = "publicationDocumentIndexFilesFileList-" + document.getLanguage() + "_" + document.getInternalName() + ".txt";
            } else if (objectType == 8) {
                fileListName = "publicationContentIndexFilesFileList-" + content.getInternalName() + ".txt";
            } else if (objectType == 21) {
                fileListName = "publicationContentOpendataFilesFileList-" + content.getInternalName() + ".txt";
            } else if (objectType == 11) {
                fileListName = "publicationContentResourceFilesFileList-" + content.getInternalName() + ".txt";
            } else if (objectType == 16) {
                fileListName = "publicationDocumentAliasFileList-" + document.getLanguage() + "_" + document.getInternalName() + ".txt";
            }
            publishFileWARelPath = R01MPathHelpper.getContentWorkAreaRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)content.getOid(), (String)content.getName(), (String)content.getName()) + "/" + XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentServices/contentDirectories/publishDir") + "/" + fileListName;
            try {
                itemToPublish = new R01MPublicationResourceItem();
                if (objectType == 0) {
                    itemToPublish.type = "filedir";
                    itemToPublish.description = "/";
                    resourcesToPublishList.add(itemToPublish);
                } else if (objectType == 1) {
                    itemToPublish.type = "filedir";
                    itemToPublish.description = "/" + document.getLanguage() + "_" + document.getInternalName() + "/";
                    resourcesToPublishList.add(itemToPublish);
                } else if (objectType == 9) {
                    if (resourcesRelativePaths != null && !resourcesRelativePaths.isEmpty()) {
                        for (String relativePath : resourcesRelativePaths) {
                            itemToPublish = new R01MPublicationResourceItem();
                            itemToPublish.type = "filedir";
                            itemToPublish.description = "/" + document.getLanguage() + "_" + document.getInternalName() + "/" + R01MConstants.DOCUMENT_INDEX_FOLDER + "/" + relativePath;
                            resourcesToPublishList.add(itemToPublish);
                        }
                    } else if (document != null) {
                        itemToPublish.type = "filedir";
                        itemToPublish.description = "/" + document.getLanguage() + "_" + document.getInternalName() + "/" + R01MConstants.DOCUMENT_INDEX_FOLDER + "/";
                        resourcesToPublishList.add(itemToPublish);
                    }
                } else if (objectType == 8) {
                    if (resourcesRelativePaths != null && !resourcesRelativePaths.isEmpty()) {
                        itemToPublish = new R01MPublicationResourceItem();
                        itemToPublish.type = "filedir";
                        itemToPublish.description = "/r01Index/" + content.getName() + "-idxContent.xml";
                        resourcesToPublishList.add(itemToPublish);
                    } else {
                        itemToPublish = new R01MPublicationResourceItem();
                        itemToPublish.type = "filedir";
                        itemToPublish.description = "/" + R01MConstants.DOCUMENT_INDEX_FOLDER + "/";
                        resourcesToPublishList.add(itemToPublish);
                        try {
                            generateRispFiles = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(content.getTypo().getClusterOid(), content.getTypo().getFamilyOid(), content.getTypo().getTypeOid()).getOpendata().isGenerateRispFiles();
                            if (!generateRispFiles) ** GOTO lbl106
                            contentWARelPath = R01MPathHelpper.getContentWorkAreaRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)content.getOid(), (String)content.getInternalName(), (String)content.getName());
                            rispContentDocumentsInfo = R01MPathHelpper.composeRispContentDocumentsInfo((String)R01MPathHelpper.getLocationPath((R01MBaseLocationObject)content.getStoreLocation()), (String)contentWARelPath, (String)content.getInternalName());
                            for (R01MRispDocument currentRispDocument : rispContentDocumentsInfo.values()) {
                                rispItemToPublish = new R01MPublicationResourceItem();
                                rispItemToPublish.type = "filedir";
                                rispItemToPublish.description = currentRispDocument.getContentRelativePath();
                                resourcesToPublishList.add(rispItemToPublish);
                            }
                        }
                        catch (R01MConfigLoadException ex) {
                            R01FLog.to((String)"r01k.index").severe("Error al obtener la informaci\u00f3n de la tipolog\u00eda " + content.getTypo().composeMemoCode() + ".Error:" + ex.getMessage());
                        }
                    }
                } else if (objectType == 11) {
                    for (String relativePath : resourcesRelativePaths) {
                        itemToPublish = new R01MPublicationResourceItem();
                        itemToPublish.type = "filedir";
                        itemToPublish.description = "/" + relativePath;
                        resourcesToPublishList.add(itemToPublish);
                    }
                } else if (objectType == 16) {
                    apacheFileName = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"aliasManagement/documentFriendlyUrl/apacheFileName", (String)".htaccess");
                    friendlyURLRelativePath = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"aliasManagement/documentFriendlyUrl/friendlyRelativePath", (String)"/r01FriendlyUrl/");
                    currentDocumentAliasesBystate = null;
                    try {
                        currentDocumentAliasesBystate = new R01DContentModelLoaderHelper().loadDocumentAliasesByState(document.getOid());
                    }
                    catch (R01DContentModelPersistenceException cmEx) {
                        R01FLog.to((String)"r01d.publisherManager").severe("R01DPublisherManager.prepareToPublish._prepareFilelistToPublish >> Error al recoger los aliases a publicar del documento " + document.getOid() + ": " + cmEx.getMessage());
                    }
                    if (currentDocumentAliasesBystate != null && currentDocumentAliasesBystate.values() != null) {
                        for (List aliasesInState : currentDocumentAliasesBystate.values()) {
                            for (R01MURLAlias currentAlias : aliasesInState) {
                                itemToPublish = new R01MPublicationResourceItem();
                                itemToPublish.type = "filedir";
                                itemToPublish.description = StringUtils.replaceString((String)("/" + friendlyURLRelativePath + currentAlias.getAlias() + "/" + apacheFileName), (String)"//", (String)"/");
                                resourcesToPublishList.add(itemToPublish);
                            }
                        }
                    }
                }
lbl106:
                // 14 sources

                if (R01DPublisherManager.DEBUG) {
                    R01FLog.to((String)"r01d.publisherManager").info("R01DPublisherManager.prepareToPublish._prepareFilelistToPublish >> Lista de recursos (carpetas y ficheros) a publicar obtenida...");
                }
                if (objectType == 0 || objectType == 1 || objectType == 20) break block41;
                dsManager = new R01DContentInDataStore(this._userCtx, content);
                byteArrayInputStreamFileList = R01MPublisherUtils.generatePublicationFilelistInputStream(resourcesToPublishList);
                try {
                    dsManager.uploadPublishFile(publishFileWARelPath, (InputStream)byteArrayInputStreamFileList);
                }
                catch (R01MDataStoreException dsEx) {
                    R01FLog.to((String)"r01d.publisherManager").severe("R01DPublisherManager.prepareToPublish._prepareFilelistToPublish >> Error al subir el fichero de elementos a publicar " + publishFileWARelPath + " al " + "Gestor de Contenidos. Error: " + dsEx.getMessage());
                    throw new R01MPublisherException("Error al subir el fichero de elementos a publicar " + publishFileWARelPath + " " + "al Gestor de Contenidos." + dsEx.getMessage(), (Exception)dsEx);
                }
                if (R01DPublisherManager.DEBUG) {
                    R01FLog.to((String)"r01d.publisherManager").info("R01DPublisherManager.prepareToPublish._prepareFilelistToPublish >> Lista de recursos a publicar submitida a " + publishFileWARelPath + " en el \u00e1rea de staging");
                }
            }
            catch (R01MPublisherException pubEx) {
                R01FLog.to((String)"r01d.publisherManager").severe("R01DPublisherManager.prepareToPublish._prepareFilelistToPublish >> Error al consolidar el contenido de oid " + content.getOid() + ": " + pubEx.getMessage());
                throw new R01MPublisherException("Error al consolidar el contenido de oid " + content.getOid() + ": " + pubEx.getMessage(), (Exception)pubEx);
            }
        }
        return resourcesToPublishList;
    }

    private boolean _consolidateResources(int objectType, R01MContent content, String documentOid, List<R01MPublicationResourceItem> resourcesRelativePaths) {
        boolean allCommitedCorrectly;
        block47: {
            List includePatterns;
            R01MContentType typoObj;
            block54: {
                block53: {
                    block52: {
                        block51: {
                            block50: {
                                block49: {
                                    R01DContentInDataStore contentDataStore;
                                    block48: {
                                        block46: {
                                            allCommitedCorrectly = true;
                                            contentDataStore = new R01DContentInDataStore(this._userCtx, content);
                                            if (resourcesRelativePaths == null || resourcesRelativePaths.isEmpty()) break block46;
                                            Iterator<R01MPublicationResourceItem> itResourcesRelativePaths = resourcesRelativePaths.iterator();
                                            while (itResourcesRelativePaths.hasNext()) {
                                                String resourcePath = itResourcesRelativePaths.next().description;
                                                if (objectType == 16) {
                                                    resourcePath = "/" + content.getDocument(documentOid).getLanguage() + "-" + content.getDocument(documentOid).getInternalName() + resourcePath;
                                                }
                                                try {
                                                    R01MClientFactory.getContentDataAPI((R01MUserContext)this._userCtx, (String)content.getOid()).submmitFileInContent(resourcePath);
                                                }
                                                catch (R01MContentModelException cmEx) {
                                                    R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._consolidateResources >> Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n.Error en la consolidaci\u00f3n del recurso: " + resourcePath + " para el contenido " + content.getOid() + "Error:" + cmEx.getMessage());
                                                    allCommitedCorrectly = false;
                                                }
                                                catch (R01MSecurityException secEx) {
                                                    R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._consolidateResources >> Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n.Error en la consolidaci\u00f3n del recurso: " + resourcePath + " para el contenido " + content.getOid() + "Error:" + secEx.getMessage());
                                                    allCommitedCorrectly = false;
                                                }
                                            }
                                            break block47;
                                        }
                                        if (objectType != 0) break block48;
                                        try {
                                            contentDataStore.consolidate();
                                        }
                                        catch (R01MDataStoreException dstExc) {
                                            R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._consolidateResources >> Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n.Error en la consolidaci\u00f3n del contenido: " + content.getOid() + "Error:" + dstExc.getMessage());
                                            allCommitedCorrectly = false;
                                        }
                                        break block47;
                                    }
                                    if (objectType != 1) break block49;
                                    try {
                                        contentDataStore.consolidateDocument(documentOid);
                                    }
                                    catch (R01MDataStoreException dstExc) {
                                        R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._consolidateResources >> Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n.Error en la consolidaci\u00f3n del documento: " + documentOid + "Error:" + dstExc.getMessage());
                                        allCommitedCorrectly = false;
                                    }
                                    break block47;
                                }
                                if (objectType != 8) break block50;
                                List resourcesList = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"contentModel/indexContentResourcesPaths/indexPath", (String[])new String[]{"/r01Index/"});
                                Properties values = new Properties();
                                values.put("contentInternalName", content.getInternalName());
                                for (String resourcePath : resourcesList) {
                                    try {
                                        String composedResourcePath = StringUtils.replaceVariableValues((String)resourcePath, (char)'$', (Map)values);
                                        R01MClientFactory.getContentDataAPI((R01MUserContext)this._userCtx, (String)content.getOid()).submmitFileInContent(composedResourcePath);
                                    }
                                    catch (R01MContentModelException cmEx) {
                                        R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._consolidateResources >> Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n.Error en la consolidaci\u00f3n del recurso: " + resourcePath + " para el contenido " + content.getOid() + "Error:" + cmEx.getMessage());
                                        allCommitedCorrectly = false;
                                    }
                                    catch (R01MSecurityException secEx) {
                                        R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._consolidateResources >> Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n.Error en la consolidaci\u00f3n del recurso: " + resourcePath + " para el contenido " + content.getOid() + "Error:" + secEx.getMessage());
                                        allCommitedCorrectly = false;
                                    }
                                }
                                break block47;
                            }
                            if (objectType != 21) break block51;
                            List resourcesList = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"contentModel/indexContentResourcesPaths/indexPath", (String[])new String[]{"/opendata/"});
                            Properties values = new Properties();
                            values.put("contentInternalName", content.getInternalName());
                            for (String resourcePath : resourcesList) {
                                try {
                                    String composedResourcePath = StringUtils.replaceVariableValues((String)resourcePath, (char)'$', (Map)values);
                                    R01MClientFactory.getContentDataAPI((R01MUserContext)this._userCtx, (String)content.getOid()).submmitFileInContent(composedResourcePath);
                                }
                                catch (R01MContentModelException cmEx) {
                                    R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._consolidateResources >> Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n.Error en la consolidaci\u00f3n del recurso: " + resourcePath + " para el contenido " + content.getOid() + "Error:" + cmEx.getMessage());
                                    allCommitedCorrectly = false;
                                }
                                catch (R01MSecurityException secEx) {
                                    R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._consolidateResources >> Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n.Error en la consolidaci\u00f3n del recurso: " + resourcePath + " para el contenido " + content.getOid() + "Error:" + secEx.getMessage());
                                    allCommitedCorrectly = false;
                                }
                            }
                            break block47;
                        }
                        if (objectType != 9) break block52;
                        List resourcesList = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"contentModel/indexDocumentResourcesPaths/indexPath", (String[])new String[]{"/$documentName$/r01Index/"});
                        Properties values = new Properties();
                        ArrayList<String> documentNames = new ArrayList<String>();
                        if (content.getDocument(documentOid) != null) {
                            documentNames.add(content.getDocument(documentOid).getLanguage() + "_" + content.getDocument(documentOid).getInternalName());
                        } else {
                            for (R01MDocument document : content.getDocuments().values()) {
                                documentNames.add(document.getLanguage() + "_" + document.getInternalName());
                            }
                        }
                        for (String resourcePath : resourcesList) {
                            try {
                                if (resourcePath.indexOf("documentName") > 0) {
                                    for (String documentName : documentNames) {
                                        values.put("documentName", documentName);
                                        String composedResourcePath = StringUtils.replaceVariableValues((String)resourcePath, (char)'$', (Map)values);
                                        R01MClientFactory.getContentDataAPI((R01MUserContext)this._userCtx, (String)content.getOid()).submmitFileInContent(composedResourcePath);
                                    }
                                    continue;
                                }
                                String composedResourcePath = StringUtils.replaceVariableValues((String)resourcePath, (char)'$', (Map)values);
                                R01MClientFactory.getContentDataAPI((R01MUserContext)this._userCtx, (String)content.getOid()).submmitFileInContent(composedResourcePath);
                            }
                            catch (R01MContentModelException cmEx) {
                                R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._consolidateResources >> Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n.Error en la consolidaci\u00f3n del recurso: " + resourcePath + " para el contenido " + content.getOid() + "Error:" + cmEx.getMessage());
                                allCommitedCorrectly = false;
                            }
                            catch (R01MSecurityException secEx) {
                                R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._consolidateResources >> Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n.Error en la consolidaci\u00f3n del recurso: " + resourcePath + " para el contenido " + content.getOid() + "Error:" + secEx.getMessage());
                                allCommitedCorrectly = false;
                            }
                        }
                        break block47;
                    }
                    if (objectType != 11) break block53;
                    Iterator<R01MPublicationResourceItem> itResourcesRelativePaths = resourcesRelativePaths.iterator();
                    while (itResourcesRelativePaths.hasNext()) {
                        String resourcePath = itResourcesRelativePaths.next().description;
                        try {
                            R01MClientFactory.getContentDataAPI((R01MUserContext)this._userCtx, (String)content.getOid()).submmitFileInContent(resourcePath);
                        }
                        catch (R01MContentModelException cmEx) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._consolidateResources >> Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n.Error en la consolidaci\u00f3n del recurso: " + resourcePath + " para el contenido " + content.getOid() + "Error:" + cmEx.getMessage());
                            allCommitedCorrectly = false;
                        }
                        catch (R01MSecurityException secEx) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._consolidateResources >> Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n.Error en la consolidaci\u00f3n del recurso: " + resourcePath + " para el contenido " + content.getOid() + "Error:" + secEx.getMessage());
                            allCommitedCorrectly = false;
                        }
                    }
                    break block47;
                }
                if (objectType != 16) break block54;
                String apacheFileName = XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"aliasManagement/documentFriendlyUrl/apacheFileName", (String)".htaccess");
                Properties relativePathsValues = new Properties();
                relativePathsValues.put("lang", content.getDocument(documentOid).getLanguage());
                relativePathsValues.put("documentInternalName", content.getDocument(documentOid).getInternalName());
                String friendlyURLRelativePath = StringUtils.replaceVariableValues((String)XMLProperties.getProperty((String)R01MConstants.API_APPCODE, (String)"aliasManagement/documentFriendlyUrl/friendlyURLContentRelativePath", (String)"/$lang$_$documentInternalName$/r01FriendlyUrl/"), (char)'$', (Map)relativePathsValues);
                Map currentDocumentAliasesBystate = null;
                try {
                    currentDocumentAliasesBystate = new R01DContentModelLoaderHelper().loadDocumentAliasesByState(documentOid);
                }
                catch (R01DContentModelPersistenceException cmEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._prepareFilelistToPublish >> Error al recoger los aliases a publicar del documento " + documentOid + ": " + cmEx.getMessage());
                }
                if (currentDocumentAliasesBystate == null || currentDocumentAliasesBystate.values() == null) break block47;
                for (List aliasesInState : currentDocumentAliasesBystate.values()) {
                    Iterator itAliases = aliasesInState.iterator();
                    while (itAliases.hasNext()) {
                        String resourcePath = friendlyURLRelativePath + ((R01MURLAlias)itAliases.next()).getAlias() + "/" + apacheFileName;
                        try {
                            R01MClientFactory.getContentDataAPI((R01MUserContext)this._userCtx, (String)content.getOid()).submmitFileInContent(resourcePath);
                        }
                        catch (R01MContentModelException cmEx) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._consolidateResources >> Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n.Error en la consolidaci\u00f3n del recurso: " + resourcePath + " para el contenido " + content.getOid() + "Error:" + cmEx.getMessage());
                            allCommitedCorrectly = false;
                        }
                        catch (R01MSecurityException secEx) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._consolidateResources >> Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n.Error en la consolidaci\u00f3n del recurso: " + resourcePath + " para el contenido " + content.getOid() + "Error:" + secEx.getMessage());
                            allCommitedCorrectly = false;
                        }
                    }
                }
                break block47;
            }
            if (objectType != 20) break block47;
            ArrayList<String> includeFiles = new ArrayList<String>();
            try {
                typoObj = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(content.getTypo().getClusterOid(), content.getTypo().getFamilyOid(), content.getTypo().getTypeOid());
            }
            catch (R01MConfigLoadException clEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish._consolidateResources >> Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n.\nError al cargar los datos de la tipologia para publicar los recursos relativos al contenido: " + content.getOid() + "\nError:" + clEx.getMessage());
                return false;
            }
            R01MTypologyPubConfig typoPubConfig = typoObj.getPublisherConfig();
            if (typoPubConfig != null && (includePatterns = typoPubConfig.getIncludeContentPatterns()) != null && !includePatterns.isEmpty()) {
                HashMap<String, String> langMap = new HashMap<String, String>();
                for (R01MDocument currentDocument : content.getDocuments().values()) {
                    langMap.put("lang", currentDocument.getLanguage());
                    for (String includePattern : includePatterns) {
                        includeFiles.add(StringUtils.replaceVariableValues((String)includePattern, (char)'$', langMap));
                    }
                }
            }
            R01DContentResourcesFilter filter = new R01DContentResourcesFilter(R01MPathHelpper.getLocationPath((R01MBaseLocationObject)content.getStoreLocation()) + R01MPathHelpper.getContentWorkAreaRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)content.getOid(), (String)content.getInternalName(), (String)content.getName()) + "/", includeFiles);
            try {
                R01MDataStoreManager dsManager = this._getDsManager();
                R01MDataStoreItem[] items = dsManager.doGetFolderContents((R01MBaseLocationObject)content.getStoreLocation(), R01MPathHelpper.getContentWorkAreaRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)content.getOid(), (String)content.getName(), (String)content.getName()), true, (R01MDataStoreItemFilter)filter, null);
                for (R01MDataStoreItem fileToSubmit : Arrays.asList(items)) {
                    if (fileToSubmit.getItemType() == 1) {
                        dsManager.doSubmmitFolder((R01MBaseLocationObject)content.getStoreLocation(), fileToSubmit.getWorkAreaRelativePath());
                        continue;
                    }
                    dsManager.doSubmmitFile((R01MBaseLocationObject)content.getStoreLocation(), fileToSubmit.getWorkAreaRelativePath());
                }
            }
            catch (R01MDataStoreException dsEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager.prepareToPublish >> Error al acceder al dataStore: " + dsEx.getMessage());
            }
        }
        return allCommitedCorrectly;
    }

    private void _updatePublishInfo(R01MContent content, R01MDocument document, String repositoryOid, int publicationType, List<R01MPublicationDestination> publicationDestinationList, Date publicationDate, int publicationState) throws R01MPublisherException {
        ArrayList<R01MDocumentPublicationTarget> docPublicationInfoInDB = document.getPublicationInfo();
        String publicationOid = null;
        if (docPublicationInfoInDB == null) {
            docPublicationInfoInDB = new ArrayList<R01MDocumentPublicationTarget>();
        } else if (!docPublicationInfoInDB.isEmpty()) {
            ArrayList<R01MDocumentPublicationTarget> docPublicationInfoToDelete = new ArrayList<R01MDocumentPublicationTarget>();
            for (R01MDocumentPublicationTarget pubTargetInDB : docPublicationInfoInDB) {
                if (pubTargetInDB.getState() == publicationState && pubTargetInDB.getOid().equals(repositoryOid)) {
                    docPublicationInfoToDelete.add(pubTargetInDB);
                    continue;
                }
                if (!pubTargetInDB.getOid().equals(repositoryOid) || pubTargetInDB.getState() != 3 && pubTargetInDB.getState() != 2 && (publicationState != 1 && publicationState != 3 || pubTargetInDB.getState() != 4) && (publicationState != 0 && publicationState != 2 || pubTargetInDB.getState() != 5)) continue;
                if (pubTargetInDB.getState() == 4 || pubTargetInDB.getState() == 5) {
                    publicationOid = pubTargetInDB.getPublicationOid();
                }
                docPublicationInfoToDelete.add(pubTargetInDB);
            }
            docPublicationInfoInDB.removeAll(docPublicationInfoToDelete);
        }
        R01MDocumentPublicationTarget newPublicationTarget = this._getNewPublicationTarget(publicationOid, publicationType, publicationDate, publicationState, content, document, repositoryOid, publicationDestinationList);
        docPublicationInfoInDB.add(newPublicationTarget);
        document.setPublicationInfo(docPublicationInfoInDB);
        document.setRevisionState(new R01MDocumentRevisionState(0));
        try {
            R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).saveDocument(content, document);
        }
        catch (R01MContentModelException cmEx) {
            throw new R01MPublisherException((Exception)((Object)cmEx));
        }
        catch (R01MDeleteModelObjectException delEx) {
            throw new R01MPublisherException((Exception)((Object)delEx));
        }
        catch (R01MDuplicateModelObjectException dupEx) {
            throw new R01MPublisherException((Exception)((Object)dupEx));
        }
        catch (R01MContentModelObjectsValidatorException ex) {
            throw new R01MPublisherException((Exception)((Object)ex));
        }
        catch (R01MSecurityException ex) {
            throw new R01MPublisherException((Exception)((Object)ex));
        }
    }

    private void _sendIndexMessage(String objectOid, int objectType, String repositoryOid, int publicationType, Date publicationDate) throws R01MPublisherException {
        R01MIndexDefinition indexDefinition = new R01MIndexDefinition();
        List indexers = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/onPublish/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KApacheMetaVarsIndexer", "com.ejie.r01k.searchorchestrator.indexer.indexers.R01KAutonomyIndexer", "com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer", "com.ejie.r01k.searchorchestrator.indexer.indexers.R01KRispIndexer"));
        indexDefinition.setIndexType(0);
        System.out.println("#### Enviar petici\u00f3n de indexaci\u00f3n de indexersConfigurations/onPublish/indexer ####");
        indexDefinition.setIndexers(indexers);
        indexDefinition.setObjectOid(objectOid);
        indexDefinition.setObjectType(objectType);
        indexDefinition.setMetadataFileNames(null);
        indexDefinition.setPublishIndexData(publicationType == 0 || publicationType == 1);
        ArrayList<String> repositoryOids = new ArrayList<String>();
        repositoryOids.add(repositoryOid);
        indexDefinition.setRepositoryOids(repositoryOids);
        indexDefinition.setPublicationType(0);
        indexDefinition.setPublicationDate(publicationDate);
        indexDefinition.setIndexFilesToPublish("");
        indexDefinition.setIteration(0);
        try {
            R01PClientFactory.getSearchEngineIndexerAPI().index(indexDefinition, R01MConstants.CONTENT_INDEXER_MANAGER);
        }
        catch (R01MSearchIndexerException ex) {
            throw new R01MPublisherException("Error al indexar el objeto.Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
    }

    private void _sendAliasMessage(R01PPublishDefinition pubDef, R01MContent content) throws R01MPublisherException {
        ArrayList<String> aliasMessage = new ArrayList<String>();
        if (pubDef.getObjectType() == 0) {
            if (content.getDocuments() != null && !content.getDocuments().isEmpty()) {
                for (String documentOid : content.getDocuments().keySet()) {
                    Collection documentAlias = null;
                    try {
                        documentAlias = R01DDocumentAliasCMPUtil.getLocalHome().findByDocumentOid(documentOid);
                        if (documentAlias == null || documentAlias.isEmpty()) continue;
                        aliasMessage.add(documentOid);
                    }
                    catch (FinderException ex) {
                        throw new R01MPublisherException((Exception)((Object)ex));
                    }
                    catch (NamingException ex) {
                        throw new R01MPublisherException((Exception)ex);
                    }
                }
            }
        } else if (pubDef.getObjectType() == 1) {
            Collection documentAlias;
            try {
                documentAlias = R01DDocumentAliasCMPUtil.getLocalHome().findByDocumentOid(pubDef.getObjectOid());
            }
            catch (FinderException ex) {
                throw new R01MPublisherException((Exception)((Object)ex));
            }
            catch (NamingException ex) {
                throw new R01MPublisherException((Exception)ex);
            }
            if (documentAlias != null && !documentAlias.isEmpty()) {
                aliasMessage.add(pubDef.getObjectOid());
            }
        }
        if (aliasMessage != null && !aliasMessage.isEmpty()) {
            for (String objectOid : aliasMessage) {
                R01PPublishDefinition pubDefinition = new R01PPublishDefinition(pubDef.getUserName(), objectOid, 16, pubDef.getPublicationOid(), null, null, pubDef.getRepositoryOid(), pubDef.getPublicationType() == 0 || pubDef.getPublicationType() == 1 ? 0 : 2, null, null, true, null, null);
                R01PClientFactory.getPublisherAPI().publish(pubDefinition);
            }
        }
    }

    private void _sendDocumentRelativeResourcesInContentPath(R01PPublishDefinition pubDef, String includePattern) throws R01MPublisherException {
        R01PPublishDefinition pubDefinition = new R01PPublishDefinition(pubDef.getUserName(), pubDef.getObjectOid(), 20, pubDef.getPublicationOid(), includePattern, null, pubDef.getRepositoryOid(), pubDef.getPublicationType() == 0 || pubDef.getPublicationType() == 1 ? 0 : 2, null, null, false, null, null);
        R01PClientFactory.getPublisherAPI().publish(pubDefinition);
    }

    private void _sendAggregatorItemFinishedMessage(String itemOid, String packetOid, Map<String, Boolean> states) throws R01MPublisherException {
        ArrayList<R01MJmsQueueParam> jmsParams = new ArrayList<R01MJmsQueueParam>();
        jmsParams.add(new R01MJmsQueueParam(3, "messageType", (Object)Integer.toString(R01MJMSUtils.MSG_AGGREGATOR_ITEM_REPONSE_TYPE)));
        jmsParams.add(new R01MJmsQueueParam(1, "oid", (Object)itemOid));
        jmsParams.add(new R01MJmsQueueParam(1, "packetOid", (Object)packetOid));
        jmsParams.add(new R01MJmsQueueParam(1, "states", (Object)states.toString()));
        String JMSQueueId = "r01CustomAggregatorResponses";
        try {
            R01MJMSUtils.sendJMSMessage((String)JMSQueueId, jmsParams);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("R01DPublisherManager._sendAggregatorItemFinishedMessage >> Enviado mensaje de la respuesta de un Item del patr\u00f3n aggregator. \n\tItem " + (itemOid == null ? "[no definido]" : itemOid) + "\n\tPaquete " + (packetOid == null ? "[no definido]" : packetOid) + "\n\tstates: " + states.toString());
            }
        }
        catch (R01MJMSException jmsExc) {
            throw new R01MPublisherException("R01DPublisherManager._sendAggregatorItemFinishedMessage >> Error al enviar un mensaje de respuesta de un Item del patr\u00f3n aggregator. \n\tItem " + (itemOid == null ? "[no definido]" : itemOid) + "\n\tPaquete " + (packetOid == null ? "[no definido]" : packetOid) + "\n\tstates: " + states.toString(), (Exception)((Object)jmsExc));
        }
    }

    private Object[] _getContentAndDocument(String objectOid, int objectType) throws R01MPublisherException {
        R01MContent content;
        String[] contentOids = null;
        try {
            contentOids = R01DContentModelLoaderHelper.getContentModelOids((String)objectOid, (int)objectType);
        }
        catch (R01DContentModelPersistenceException cmpEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager._getContentAndDocument >> Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n del objeto de tipo " + objectType + " y de identificador '" + objectOid + "'." + "No se puede obtener los OIDs de los objetos padre. " + "Error:" + cmpEx.getMessage());
            throw new R01MPublisherException("No se han podido obtener los OIDs del objeto " + objectOid + " de tipo " + Integer.toString(objectType) + ": " + cmpEx.getMessage(), (Exception)((Object)cmpEx));
        }
        String contentOid = contentOids[0];
        String documentOid = contentOids[1];
        R01MContentModelAPI contentAPI = R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx);
        try {
            content = contentAPI.loadContent(contentOid);
        }
        catch (Exception ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01DPublisherManager._getContentAndDocument >> Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n del objeto de tipo " + objectType + " y de identificador '" + objectOid + "'." + "No se puede cargar el contenido. Error:" + ex.getMessage());
            throw new R01MPublisherException("Error en el proceso de preparaci\u00f3n de la publicaci\u00f3n del objeto de tipo " + objectType + " y de identificador '" + objectOid + "'." + "No se puede cargar el contenido. Error:" + ex.getMessage(), ex);
        }
        R01MDocument document = null;
        if (objectType == 1 || objectType == 9 || objectType == 16 || objectType == 20) {
            try {
                document = content.getDocument(documentOid) == null ? contentAPI.loadDocument(documentOid) : content.getDocument(documentOid);
            }
            catch (Exception ex) {
                throw new R01MPublisherException(new StringBuffer().append("R01JPublisherServices._getContentAndDocument >> Error al cargar el documento: ").append(documentOid == null ? "[null]" : documentOid).toString());
            }
        }
        return new Object[]{content, document};
    }

    private void _checkPublishProcessInputParams(int step, R01PPublishDefinition pubDef) throws R01MPublisherException {
        String processStep = "undefined";
        if (step == 0) {
            processStep = "prepareToPublish";
        } else if (step == 1) {
            processStep = "prePublish";
        } else if (step == 2) {
            processStep = "publish";
        } else if (step == 3) {
            processStep = "postPublish";
        }
        try {
            pubDef.validateObject();
        }
        catch (R01MPublisherModelObjectsValidatorException pubExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe(new StringBuffer("R01DPublisherManager.").append(processStep).append(" >> La publicaci\u00f3n no es v\u00e1lida para ejecutar la operaci\u00f3n ").append(" ").append(pubDef.debugInfo("")).toString());
            throw new R01MPublisherException("La publicaci\u00f3n no es v\u00e1lida para ejecutar la operaci\u00f3n " + processStep, (Exception)((Object)pubExc));
        }
        if (this._userCtx == null) {
            R01FLog.to((String)LOG_TYPE_ID).severe(new StringBuffer("R01DPublisherManager.").append(processStep).append(" >> El objeto no tiene inicializado un contexto de usuario y es necesario para ejecutar la operaci\u00f3n ").append(processStep).toString());
            throw new R01MPublisherException("El objeto no tiene inicializado un contexto de usuario y es necesario para ejecutar la operaci\u00f3n " + processStep);
        }
    }

    private void _sendStepFinishedMessage(String messageType, String MessageDescription, int step, R01PPublishDefinition pubDef) throws R01MPublisherException {
        StringBuffer msg = new StringBuffer(MessageDescription);
        msg.append('\n');
        msg.append(pubDef.debugInfo(""));
        if (step == 3) {
            msg.append("\npublicationState:       ");
            msg.append(pubDef.getPublicationState());
        }
        HashMap<String, String> publicationsMap = new HashMap<String, String>();
        publicationsMap.put("default", msg.toString());
        if (step == 0) {
            R01PClientFactory.getPublisherAPI().prepareToPublishFinished(pubDef.getObjectOid(), pubDef.getObjectType(), messageType, publicationsMap);
        } else if (step == 1) {
            R01PClientFactory.getPublisherAPI().prePublishFinished(pubDef.getObjectOid(), pubDef.getObjectType(), messageType, publicationsMap);
        } else if (step == 2) {
            R01PClientFactory.getPublisherAPI().publishFinished(pubDef.getObjectOid(), pubDef.getObjectType(), messageType, publicationsMap);
        } else if (step == 3) {
            R01PClientFactory.getPublisherAPI().postPublishFinished(pubDef.getObjectOid(), pubDef.getObjectType(), messageType, publicationsMap);
        }
    }

    private void _updateErrorPublicationState(R01PPublishDefinition pubDef) throws R01MPublisherException {
        if (StringUtils.isEmptyString((String)pubDef.getPublicationOid())) {
            Object[] object = this._getContentAndDocument(pubDef.getObjectOid(), pubDef.getObjectType());
            R01MContent content = (R01MContent)object[0];
            R01MDocument document = (R01MDocument)object[1];
            ArrayList<Object> documentsToUpdate = new ArrayList<Object>();
            if (document != null) {
                documentsToUpdate.add(document);
            } else {
                documentsToUpdate.addAll(content.getDocuments().values());
            }
            block2: for (R01MDocument r01MDocument : documentsToUpdate) {
                if (r01MDocument.getPublicationInfo() == null || r01MDocument.getPublicationInfo().isEmpty()) continue;
                for (R01MDocumentPublicationTarget currentPublicationTarget : r01MDocument.getPublicationInfo()) {
                    if (!currentPublicationTarget.getOid().equals(pubDef.getRepositoryOid()) || (pubDef.getPublicationState() != 1 && pubDef.getPublicationState() != 3 && pubDef.getPublicationState() != 4 || currentPublicationTarget.getState() != 1 && currentPublicationTarget.getState() != 3 && currentPublicationTarget.getState() != 4) && (pubDef.getPublicationState() != 0 && pubDef.getPublicationState() != 2 && pubDef.getPublicationState() != 5 || currentPublicationTarget.getState() != 0 && currentPublicationTarget.getState() != 2 && currentPublicationTarget.getState() != 5)) continue;
                    pubDef.setPublicationOid(currentPublicationTarget.getPublicationOid());
                    break block2;
                }
            }
        }
        this.updateStatePublishInfo(pubDef.getObjectOid(), pubDef.getObjectType(), pubDef.getPublicationOid(), pubDef.getPublicationState() == 1 || pubDef.getPublicationState() == 3 ? 3 : 2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _executePendingAction(R01MContent content, R01MDocument document) throws R01MPublisherException {
        R01DDocumentCMPLocal documentCMP;
        R01DContentCMPLocal contentCMP = null;
        if (content != null) {
            try {
                contentCMP = R01DContentCMPUtil.getLocalHome().findByPrimaryKey(new R01DContentCMPPK(content.getOid()));
            }
            catch (FinderException findEx) {
                throw new R01MPublisherException("Error al encontrar el contenido " + content.getOid() + ": " + findEx.getMessage(), (Exception)((Object)findEx));
            }
            catch (NamingException nameEx) {
                throw new R01MPublisherException("Error al encontrar el contenido " + content.getOid() + ": " + nameEx.getMessage(), (Exception)nameEx);
            }
        }
        if (contentCMP != null && contentCMP.getActionPost() == 1) {
            try {
                if (!R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).checkContentExistence(content.getOid())) return;
                try {
                    R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).deleteContent(content.getOid());
                    return;
                }
                catch (R01MDeleteContentException ex) {
                    throw new R01MPublisherException("Error al borrar el contenido:" + content.getOid(), (Exception)((Object)ex));
                }
            }
            catch (R01MContentModelException cmEx) {
                throw new R01MPublisherException("Acciones solicitadas en el proceso de publicaci\u00f3n: al borrar un contenido de OID " + content.getOid() + "Error en el modelo de contenidos", (Exception)((Object)cmEx));
            }
            catch (R01MSecurityException dcEx) {
                throw new R01MPublisherException("Acciones solicitadas en el proceso de publicaci\u00f3n: al borrar un contenido de OID " + content.getOid() + "Error de seguridad", (Exception)((Object)dcEx));
            }
        }
        if (document == null) return;
        try {
            documentCMP = R01DDocumentCMPUtil.getLocalHome().findByPrimaryKey(new R01DDocumentCMPPK(document.getOid()));
        }
        catch (FinderException findEx) {
            throw new R01MPublisherException("Error al encontrar el documento " + document.getOid() + ": " + findEx.getMessage(), (Exception)((Object)findEx));
        }
        catch (NamingException nameEx) {
            throw new R01MPublisherException("Error al encontrar el documento " + document.getOid() + ": " + nameEx.getMessage(), (Exception)nameEx);
        }
        if (documentCMP.getActionPost() != 1) return;
        if (content.getDocument(document.getOid()) != null) {
            content.getDocuments().remove(document.getOid());
        }
        try {
            if (!R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).checkDocumentExistence(document.getOid())) return;
            R01MClientFactory.getContentModelAPI((R01MUserContext)this._userCtx).saveContent(content);
            return;
        }
        catch (Exception ex) {
            throw new R01MPublisherException("Error al borrar el documento:" + document.getOid(), ex);
        }
    }

    private void _updateLangUrlInContentApacheVarFile(String repositoryOid, R01MContentLocation location, R01MDataStoreManager dsManager, String contentWorkareaRelativePath, String docInternalName) throws R01MPublisherException {
        block27: {
            try {
                if (!dsManager.doCheckFile((R01MBaseLocationObject)location, contentWorkareaRelativePath + "/" + R01MConstants.DOCUMENT_INDEX_FOLDER + "/" + "r01ContVars." + docInternalName + ".index.shtml")) break block27;
                InputStream fileStream = dsManager.doReadFile((R01MBaseLocationObject)location, contentWorkareaRelativePath + "/" + R01MConstants.CONTENT_INDEX_FOLDER + "/" + "r01ContVars." + docInternalName + ".index.shtml");
                String line = null;
                StringBuffer fileBuffer = new StringBuffer(17);
                HashMap friendlyReferencesByDocument = new HashMap();
                HashMap referencesByDocument = new HashMap();
                if (fileStream == null) break block27;
                BufferedReader reader = new BufferedReader(new InputStreamReader(fileStream));
                Pattern patternLang = Pattern.compile("rlByLanguage_name-([^\\\"]+)_repo-[^\\\"]+_lang-([^\\\"]+)\"");
                Pattern patternUrl = Pattern.compile("value=\"([^\\\"]+)\"");
                try {
                    while ((line = reader.readLine()) != null) {
                        String url;
                        String language;
                        String documentName;
                        Matcher matcherUrl;
                        Matcher matcherLang;
                        if (line.indexOf("friendlyUrlByLanguage_name-") > 0 && line.indexOf("_repo-" + repositoryOid) > 0) {
                            matcherLang = patternLang.matcher(line);
                            matcherUrl = patternUrl.matcher(line);
                            documentName = null;
                            language = null;
                            url = null;
                            if (matcherLang.find()) {
                                documentName = matcherLang.group(1);
                                language = matcherLang.group(2);
                            }
                            if (matcherUrl.find()) {
                                url = matcherUrl.group(1);
                            }
                            if (documentName != null && language != null && url != null) {
                                if (friendlyReferencesByDocument.get(documentName) == null) {
                                    friendlyReferencesByDocument.put(documentName, new HashMap());
                                }
                                ((Map)friendlyReferencesByDocument.get(documentName)).put(language, url);
                            }
                        }
                        if (line.indexOf("urlByLanguage_name-") <= 0 || line.indexOf("_repo-" + repositoryOid) <= 0) continue;
                        matcherLang = patternLang.matcher(line);
                        matcherUrl = patternUrl.matcher(line);
                        documentName = null;
                        language = null;
                        url = null;
                        if (matcherLang != null && matcherLang.find()) {
                            documentName = matcherLang.group(1);
                            language = matcherLang.group(2);
                        }
                        if (matcherUrl != null && matcherUrl.find()) {
                            url = matcherUrl.group(1);
                        }
                        if (documentName == null || language == null || url == null) continue;
                        if (referencesByDocument.get(documentName) == null) {
                            referencesByDocument.put(documentName, new HashMap());
                        }
                        ((Map)referencesByDocument.get(documentName)).put(language, url);
                    }
                    for (Map.Entry referencesEntry : referencesByDocument.entrySet()) {
                        String documentInternalName = (String)referencesEntry.getKey();
                        Map effectiveUrlsByLanguage = (Map)referencesEntry.getValue();
                        Map effectiveFriendlyUrlsByLanguage = (Map)friendlyReferencesByDocument.get(documentInternalName);
                        if ((effectiveUrlsByLanguage == null || effectiveUrlsByLanguage.isEmpty()) && (effectiveFriendlyUrlsByLanguage == null || effectiveFriendlyUrlsByLanguage.isEmpty())) continue;
                        fileBuffer.append("<!--#if expr=\"$R01_DOC_INTERNAL_NAME = /^" + documentInternalName + "$/\" -->\r\n");
                        if (effectiveUrlsByLanguage != null) {
                            for (Map.Entry entry : effectiveUrlsByLanguage.entrySet()) {
                                fileBuffer.append("\t<!--#set var=\"r01_effective_url_by_language_").append((String)entry.getKey()).append("\" value=\"").append((String)entry.getValue()).append("\" -->\r\n");
                            }
                        }
                        if (effectiveFriendlyUrlsByLanguage != null) {
                            for (Map.Entry entry : effectiveFriendlyUrlsByLanguage.entrySet()) {
                                fileBuffer.append("\t<!--#set var=\"r01_effective_friendly_url_by_language_").append((String)entry.getKey()).append("\" value=\"").append((String)entry.getValue()).append("\" -->\r\n");
                            }
                        }
                        fileBuffer.append("<!--#endif-->\r\n");
                    }
                    dsManager.doUpdateFile((R01MBaseLocationObject)location, contentWorkareaRelativePath + "/" + R01MConstants.DOCUMENT_INDEX_FOLDER + "/" + "r01ContVars." + docInternalName + ".publish.shtml", (InputStream)new ByteArrayInputStream(fileBuffer.toString().getBytes()), null, true);
                    dsManager.doSubmmitFile((R01MBaseLocationObject)location, contentWorkareaRelativePath + "/" + R01MConstants.DOCUMENT_INDEX_FOLDER + "/" + "r01ContVars." + docInternalName + ".publish.shtml");
                }
                catch (IOException ioEx) {
                    throw new R01MPublisherException("Error al leer o actualizar el fichero de variables de apache para el los ficheros de: " + contentWorkareaRelativePath, (Exception)ioEx);
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        if (fileStream != null) {
                            fileStream.close();
                        }
                    }
                    catch (IOException ioEx) {
                        throw new R01MPublisherException("Error al cerrar el reader / stream del fichero de variables de apache para el los ficheros de: " + contentWorkareaRelativePath, (Exception)ioEx);
                    }
                }
            }
            catch (R01MDataStoreException dsEx) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener el fichero de variables de apache para el los ficheros de: " + contentWorkareaRelativePath + ": " + dsEx.getMessage());
                dsEx.printStackTrace();
            }
        }
    }

    private R01MDataStoreManager _getDsManager() throws R01MDataStoreException {
        String dataStoreManagerClassName = XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"dataStoreManager/implClassName");
        R01MDataStoreManager dsManager = null;
        R01MDataStoreAuthObject authenticationObject = null;
        try {
            authenticationObject = new R01MDataStoreAuthObject();
            authenticationObject.fillAuthInfo(R01MConstants.API_APPCODE, this._userCtx);
        }
        catch (R01MDataStoreAuthenticationException dsaEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al autenticarse en el datastore: " + dsaEx.getMessage());
            throw new R01MDataStoreException("Error al autenticarse en el datastore", (Exception)((Object)dsaEx));
        }
        try {
            dsManager = (R01MDataStoreManager)ReflectionUtils.getObjectInstance((String)dataStoreManagerClassName);
            dsManager.doBeginSession(authenticationObject);
        }
        catch (ReflectionException refEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al instanciar el DataStore (" + dataStoreManagerClassName == null ? "NULL" : dataStoreManagerClassName + "): " + refEx.getMessage());
            throw new R01MDataStoreException("Error al instanciar el DataStore (" + dataStoreManagerClassName == null ? "NULL" : dataStoreManagerClassName + ").", (Exception)((Object)refEx));
        }
        catch (R01MDataStoreAuthenticationException authEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al instanciar el DataStore (" + dataStoreManagerClassName == null ? "NULL" : dataStoreManagerClassName + "): " + authEx.getMessage());
            throw new R01MDataStoreException("Error al instanciar el DataStore (" + dataStoreManagerClassName == null ? "NULL" : dataStoreManagerClassName + ").", (Exception)((Object)authEx));
        }
        return dsManager;
    }
}

