/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services;

import com.ejie.r01d.config.loaders.R01DOperationsConfigLoader;
import com.ejie.r01d.contentmanager.helppers.R01DOperationExecHelpper;
import com.ejie.r01d.exceptions.R01DContentModelPersistenceException;
import com.ejie.r01d.gestorcontenidos.dbhelppers.dao.R01DDAOContentModelLoader;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.content.R01DContentCMPLocal;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.content.R01DContentCMPPK;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.content.R01DContentCMPUtil;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.document.R01DDocumentCMPLocal;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.document.R01DDocumentCMPPK;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.document.R01DDocumentCMPUtil;
import com.ejie.r01d.objects.R01DOperationDelegate;
import com.ejie.r01d.objects.R01DOperationMethod;
import com.ejie.r01d.objects.R01DOperationParam;
import com.ejie.r01d.services.R01DContentModelManager;
import com.ejie.r01f.jvt.JVTComparator;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.contentmodel.R01MBaseDocumentInterface;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MDataFile;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.contentmodel.R01MDocumentRevisionState;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MDozerMappingUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

public class R01DModelUpdateOperationsLauncher {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.operationLauncher").intValue() > Level.FINE.intValue();
    private static transient Map _operationsMap = null;
    private R01MUserContext _userCtx;

    private void _init() throws R01DContentModelPersistenceException {
        if (_operationsMap == null) {
            if (DEBUG) {
                R01FLog.to((String)"r01d.operationlauncher").info("......Inicializaci\u00f3n de la Definici\u00f3n de Operaciones: Mapeo de los objetos con los EJBs que los gestionan");
            }
            try {
                R01DOperationsConfigLoader loader = new R01DOperationsConfigLoader();
                _operationsMap = loader.loadOperationsConfig();
            }
            catch (R01MConfigLoadException cfgEx) {
                throw new R01DContentModelPersistenceException((Exception)((Object)cfgEx));
            }
        }
    }

    public R01DModelUpdateOperationsLauncher() {
    }

    public R01DModelUpdateOperationsLauncher(R01MUserContext usrCtx) {
        this();
        this._userCtx = usrCtx;
    }

    public void perform(JVTComparator operations) throws R01DContentModelPersistenceException {
        this._init();
        int operationExecuted = 0;
        JVTComparator.PlanTableOperation operation = null;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.operationlauncher").info(".....Operaciones a realizar:");
            }
            if (DEBUG) {
                R01FLog.to((String)"r01d.operationlauncher").info(JVTComparator.composeDebugInfo((List)operations.getPlanTable()));
            }
            Iterator it = operations.getPlanTableIterator();
            while (it.hasNext()) {
                operation = (JVTComparator.PlanTableOperation)it.next();
                R01FLog.to((String)"r01d.operationlauncher").finer(JVTComparator.OPERATION_DESCS[operation.operation] + ": " + "argumentos(" + this._printArgs(operation.args) + ")");
                this._executeOperation(operation);
                R01FLog.to((String)"r01d.operationlauncher").finer("-OPERATION [OK]\r\n\r\n\r\n");
                ++operationExecuted;
            }
        }
        catch (R01DContentModelPersistenceException cmEx) {
            R01FLog.to((String)"r01d.operationlauncher").severe("\tOPERATION [ERROR]\r\n" + cmEx.getDetailedMessage());
            this._rollbackOperations(operations, operationExecuted);
            throw cmEx;
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01d.operationlauncher").severe("\tOPERATIOM [ERROR]\r\n" + operation == null ? "operation null" : operation.toString() + " >> " + ex.getMessage());
            this._rollbackOperations(operations, operationExecuted);
            throw new R01DContentModelPersistenceException(operation.toString() + " >> " + ex.getMessage(), ex);
        }
    }

    private void _rollbackOperations(JVTComparator operations, int lastOperationExecuted) {
        if (DEBUG) {
            R01FLog.to((String)"r01d.operationlauncher").info("OPERATIONLAUNCHER >>>>>  ROLLBACK DE OPERACIONES EJECUTADAS");
        }
    }

    private void _executeOperation(JVTComparator.PlanTableOperation operation) throws R01DContentModelPersistenceException {
        Object[] arrParentChild = operation.args;
        if (!this._validateParamsOfOperation(operation)) {
            throw new R01DContentModelPersistenceException("Error en operacion:" + JVTComparator.OPERATION_DESCS[operation.operation] + ".N\u00famero de par\u00e1metros incorrecto.");
        }
        String className = arrParentChild.length == 1 ? arrParentChild[0].getClass().getName() : arrParentChild[1].getClass().getName();
        Map opsMap = (Map)_operationsMap.get(className);
        if (opsMap == null) {
            throw new R01DContentModelPersistenceException("No se ha definido la clase " + className + " en el fichero de mapeo objetos <-> ejbs!!!");
        }
        String opError = null;
        R01DOperationDelegate opDelegate = null;
        String opDelegateName = null;
        R01DOperationMethod opDelegateMethod = null;
        String opDelegatePKClass = null;
        opDelegate = (R01DOperationDelegate)opsMap.get(JVTComparator.OPERATION_DESCS[operation.operation]);
        if (opDelegate == null) {
            opError = "Operaci\u00f3n " + JVTComparator.OPERATION_DESCS[operation.operation] + " NO definida en el fichero de mapeo objetos <-> delegates";
        } else {
            if (opDelegate.getType().equals("no_op")) {
                if (DEBUG) {
                    R01FLog.to((String)"r01d.operationlauncher").info("La operacion " + JVTComparator.OPERATION_DESCS[operation.operation] + " sobre el objeto " + (operation.args.length > 1 ? operation.args[1] : operation.args[0]) + " SE IGNORA tal y como se ha establecido en el fichero de definici\u00f3n de operaciones!");
                }
                if (operation.args[0] instanceof R01MDocument && operation.args[1] instanceof R01MDocumentRevisionState) {
                    R01MDocument doc = (R01MDocument)operation.args[0];
                    R01MDocumentRevisionState docRevState = (R01MDocumentRevisionState)operation.args[1];
                    try {
                        R01DDocumentCMPLocal docCMP = R01DDocumentCMPUtil.getLocalHome().findByPrimaryKey(new R01DDocumentCMPPK(doc.getOid()));
                        docCMP.setState(docRevState.getState());
                    }
                    catch (FinderException findEx) {
                        throw new R01DContentModelPersistenceException("Error al actualizar el estado del documento " + doc.getOid() + ": " + findEx.getMessage(), (Exception)((Object)findEx));
                    }
                    catch (NamingException nameEx) {
                        throw new R01DContentModelPersistenceException("Error al actualizar el estado del documento " + doc.getOid() + ": " + nameEx.getMessage(), (Exception)nameEx);
                    }
                }
                return;
            }
            opDelegateName = opDelegate.getOperationExecuteComponent();
            if (opDelegateName == null) {
                opError = "Nombre (jndi) del objeto delegate " + opDelegate.getOperationExecuteComponent() + " NO definido en el fichero de mapeo objetos <-> delegates";
            } else {
                opDelegatePKClass = opDelegate.getPk();
                if (opDelegatePKClass == null) {
                    opError = "Clase de clave primaria " + opDelegate.getPk() + " NO definida en el fichero de mapeo objetos <-> delegates";
                } else {
                    opDelegateMethod = opDelegate.getOperationExecuteMethod();
                    if (opDelegateMethod == null) {
                        opError = "M\u00e9todo " + opDelegate.getOperationExecuteMethod() + " a ejecutar NO definido en el fichero de mapeo objetos <-> delegates";
                    } else if (operation.operation == 3 && opDelegateMethod.getParams() == null && opDelegateMethod.getParams().size() <= 0) {
                        opError = "N\u00famero de par\u00e1metros incorrecto en fichero de configuraci\u00f3n de mapeo objetos <-> delegates";
                    }
                }
            }
        }
        if (opError != null) {
            throw new R01DContentModelPersistenceException("Error en la definici\u00f3n de la operacion:" + JVTComparator.OPERATION_DESCS[operation.operation] + " sobre la clase " + className + ". Error en fichero de mapeo objetos <-> delegates: " + opError);
        }
        StringBuffer debugMsg = new StringBuffer("");
        debugMsg.append("\tObjeto                : " + className + "\r\n");
        debugMsg.append("\t\t\tDelegate Type         : " + opDelegate.getType() + "\r\n");
        debugMsg.append("\t\t\tDelegate Name (jndi)  : " + opDelegateName + "\r\n");
        debugMsg.append("\t\t\tDelegate PK           : " + opDelegatePKClass + "\r\n");
        debugMsg.append("\t\t\tDelegate Method       : " + opDelegateMethod.getMethod() + "\r\n");
        debugMsg.append("\t\t\tDelegate Method Params: ");
        if (opDelegateMethod.getParams() != null) {
            Iterator it = opDelegateMethod.getParams().iterator();
            while (it.hasNext()) {
                R01DOperationParam paramData = (R01DOperationParam)it.next();
                debugMsg.append("class:" + paramData.getClassName() + " - mapping:" + paramData.isMapping() + " - valueObject:" + paramData.isValueObject());
                if (!it.hasNext()) continue;
                debugMsg.append(",");
            }
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.operationlauncher").info(debugMsg.toString());
        }
        R01DOperationParam[] mappedParams = null;
        if (opDelegateMethod.getParams() != null && opDelegateMethod.getParams().size() > 0) {
            mappedParams = new R01DOperationParam[opDelegateMethod.getParams().size()];
            if (DEBUG) {
                R01FLog.to((String)"r01d.operationlauncher").info("\t\tMapear " + opDelegateMethod.getParams().size() + " parametros del metodo del business delegate");
            }
            int i = 0;
            for (R01DOperationParam opParamDef : opDelegateMethod.getParams()) {
                R01DOperationParam opParam;
                mappedParams[i] = opParam = new R01DOperationParam(opParamDef.getClassName(), opParamDef.isValueObject(), opParamDef.isMapping(), null);
                if (DEBUG) {
                    R01FLog.to((String)"r01d.operationlauncher").info("\t\t\t- parametro " + opParam.getClassName() + " " + (opParam.isValueObject() ? "(valueObject)" : ""));
                }
                if (opParam.isValueObject()) {
                    Object opDlgtMthdParamValue;
                    if (opParam.isMapping()) {
                        try {
                            opDlgtMthdParamValue = ReflectionUtils.getObjectInstance((String)opParam.getClassName());
                        }
                        catch (ReflectionException refEx) {
                            throw new R01DContentModelPersistenceException("Error al obtener una instancia de la clase " + opParam.getClassName() + ": " + refEx.getMessage(), (Exception)((Object)refEx));
                        }
                        if (operation.operation == 5 || operation.operation == 6 || operation.operation == 3 || operation.operation == 4 || operation.operation == 0) {
                            R01MDozerMappingUtils.map((String)R01MConstants.CONTENTMANAGER_APPCODE, (Object)arrParentChild[1], (Object)opDlgtMthdParamValue);
                            if (arrParentChild[0] != null) {
                                R01MDozerMappingUtils.map((String)R01MConstants.CONTENTMANAGER_APPCODE, (Object)arrParentChild[0], (Object)opDlgtMthdParamValue);
                            }
                        } else if (operation.operation == 1 || operation.operation == 2) {
                            R01MDozerMappingUtils.map((String)R01MConstants.CONTENTMANAGER_APPCODE, (Object)arrParentChild[0], (Object)opDlgtMthdParamValue);
                        }
                    } else {
                        opDlgtMthdParamValue = arrParentChild.length == 2 ? arrParentChild[1] : arrParentChild[0];
                    }
                    opParam.setValue(opDlgtMthdParamValue);
                } else if (opParam.getClassName().equals(R01MUserContext.class.getName())) {
                    opParam.setValue((Object)this._userCtx);
                }
                ++i;
            }
        }
        try {
            Object[] paramEJB = new Object[]{};
            if (mappedParams != null && mappedParams.length > 0) {
                paramEJB = new Object[mappedParams.length];
                for (int i = 0; i < mappedParams.length; ++i) {
                    paramEJB[i] = mappedParams[i].getValue();
                }
            }
            if (DEBUG) {
                R01FLog.to((String)"r01d.operationlauncher").info("\t\tInvocar al metodo " + opDelegateMethod.getMethod() + " del EJB " + opDelegateName + " para realizar la operacion " + JVTComparator.OPERATION_DESCS[operation.operation]);
            }
            R01DOperationExecHelpper execHelpper = new R01DOperationExecHelpper();
            Object pk = this._composePK(arrParentChild, opDelegatePKClass);
            if (operation.operation == 5) {
                execHelpper.createNew(opDelegateName, opDelegateMethod.getMethod(), paramEJB);
            } else if (operation.operation == 6) {
                execHelpper.delete(opDelegateName, opDelegateMethod.getMethod(), pk, paramEJB);
            } else if (operation.operation == 3) {
                execHelpper.update(opDelegateName, opDelegateMethod.getMethod(), pk, paramEJB, null);
            } else if (operation.operation == 4) {
                execHelpper.update(opDelegateName, opDelegateMethod.getMethod(), pk, null, null);
            } else if (operation.operation == 0) {
                execHelpper.update(opDelegateName, opDelegateMethod.getMethod(), pk, paramEJB, null);
            } else if (operation.operation == 1) {
                execHelpper.createNew(opDelegateName, opDelegateMethod.getMethod(), paramEJB);
            } else if (operation.operation == 2) {
                execHelpper.delete(opDelegateName, opDelegateMethod.getMethod(), pk, paramEJB);
            }
            this._sendHistoryMessage(arrParentChild, operation.operation);
        }
        catch (EJBException ejbEx) {
            R01FLog.to((String)"r01d.operationlauncher").severe("Error en la operacion:" + JVTComparator.OPERATION_DESCS[operation.operation] + (Object)((Object)ejbEx));
            throw new R01DContentModelPersistenceException((Exception)((Object)ejbEx));
        }
    }

    private boolean _validateParamsOfOperation(JVTComparator.PlanTableOperation operation) {
        boolean validParamsOperation = true;
        if (operation.args == null) {
            validParamsOperation = false;
        }
        if ((operation.operation == 1 || operation.operation == 2) && operation.args.length != 1) {
            validParamsOperation = false;
        }
        if ((operation.operation == 5 || operation.operation == 6 || operation.operation == 3 || operation.operation == 4 || operation.operation == 0) && operation.args.length != 2) {
            validParamsOperation = false;
        }
        return validParamsOperation;
    }

    private Object _composePK(Object[] arrParentChild, String pkClass) throws R01DContentModelPersistenceException {
        Object pk = null;
        try {
            Object objParent = null;
            Object objChild = null;
            if (arrParentChild.length == 2) {
                objParent = arrParentChild[0];
                objChild = arrParentChild[1];
            } else if (arrParentChild.length == 1) {
                objChild = arrParentChild[0];
            }
            if (objChild instanceof R01MContent) {
                Object pkChild = ReflectionUtils.getMethod(objChild.getClass(), (String)"getOid", null).invoke(objChild, new Object[0]);
                pk = ReflectionUtils.getObjectInstance((String)pkClass, (Class[])new Class[]{String.class}, (Object[])new Object[]{pkChild}, (boolean)true);
            } else if (objChild instanceof R01MDocument) {
                Object pkChild = ReflectionUtils.getMethod(objChild.getClass(), (String)"getOid", null).invoke(objChild, new Object[0]);
                pk = ReflectionUtils.getObjectInstance((String)pkClass, (Class[])new Class[]{String.class}, (Object[])new Object[]{pkChild}, (boolean)true);
            } else if (objChild instanceof R01MDataFile) {
                Object pkChild = ReflectionUtils.getMethod(objChild.getClass(), (String)"getOid", null).invoke(objChild, new Object[0]);
                pk = ReflectionUtils.getObjectInstance((String)pkClass, (Class[])new Class[]{String.class}, (Object[])new Object[]{pkChild}, (boolean)true);
            } else if (objChild instanceof R01MContentLocation || objChild instanceof R01MContentTypologyInfo) {
                Object pkContent = ReflectionUtils.getMethod(objParent.getClass(), (String)"getOid", null).invoke(objParent, new Object[0]);
                pk = ReflectionUtils.getObjectInstance((String)pkClass, (Class[])new Class[]{String.class}, (Object[])new Object[]{pkContent}, (boolean)true);
            } else if (objChild instanceof R01MStructureCatalog) {
                Object pkContent = ReflectionUtils.getMethod(objParent.getClass(), (String)"getOid", null).invoke(objParent, new Object[0]);
                Object pkLabel = ReflectionUtils.getMethod(objChild.getClass(), (String)"getOid", null).invoke(objChild, new Object[0]);
                Object pkStructure = ReflectionUtils.getMethod(objChild.getClass(), (String)"getStructureOid", null).invoke(objChild, new Object[0]);
                pk = ReflectionUtils.getObjectInstance((String)pkClass, (Class[])new Class[]{String.class, String.class, String.class}, (Object[])new Object[]{pkContent, pkLabel, pkStructure}, (boolean)true);
            } else if (objChild instanceof R01MDocumentPublicationTarget) {
                Object pkDocument = ReflectionUtils.getMethod(objParent.getClass(), (String)"getOid", null).invoke(objParent, new Object[0]);
                Object pkPublicationTarget = ReflectionUtils.getMethod(objChild.getClass(), (String)"getOid", null).invoke(objChild, new Object[0]);
                Object stateInPublicationTarget = ReflectionUtils.getMethod(objChild.getClass(), (String)"getState", null).invoke(objChild, new Object[0]);
                pk = ReflectionUtils.getObjectInstance((String)pkClass, (Class[])new Class[]{String.class, String.class, Integer.TYPE}, (Object[])new Object[]{pkDocument, pkPublicationTarget, stateInPublicationTarget}, (boolean)true);
            } else {
                Object pkChild = ReflectionUtils.getMethod(objChild.getClass(), (String)"getOid", null).invoke(objChild, new Object[0]);
                pk = ReflectionUtils.getObjectInstance((String)pkClass, (Class[])new Class[]{String.class}, (Object[])new Object[]{pkChild}, (boolean)true);
            }
        }
        catch (IllegalArgumentException illArgEx) {
            throw new R01DContentModelPersistenceException("Error al obtener la PK de clase " + pkClass + " > " + illArgEx.getMessage(), (Exception)illArgEx);
        }
        catch (IllegalAccessException illAccEx) {
            throw new R01DContentModelPersistenceException("Error al obtener la PK de clase " + pkClass + " > " + illAccEx.getMessage(), (Exception)illAccEx);
        }
        catch (InvocationTargetException invTgtEx) {
            throw new R01DContentModelPersistenceException("Error al obtener la PK de clase " + pkClass + " > " + invTgtEx.getMessage(), (Exception)invTgtEx);
        }
        catch (NoSuchMethodException nsmEx) {
            throw new R01DContentModelPersistenceException("Error al obtener la PK de clase " + pkClass + " > " + nsmEx.getMessage(), (Exception)nsmEx);
        }
        catch (ReflectionException refEx) {
            throw new R01DContentModelPersistenceException("Error al obtener la PK de clase " + pkClass + " > " + refEx.getMessage(), (Exception)((Object)refEx));
        }
        return pk;
    }

    private String _printArgs(Object[] args) {
        StringBuffer printarg = new StringBuffer("");
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) {
                    printarg.append(args[i].getClass().getName());
                } else {
                    printarg.append("null");
                }
                printarg.append(",");
            }
            return printarg.substring(0, printarg.length() - 1);
        }
        return "(no args)";
    }

    private void _sendHistoryMessage(Object[] arrParentChild, int operation) throws R01DContentModelPersistenceException {
        R01MContent content = null;
        R01MDocument document = null;
        R01MDataFile datafile = null;
        int targetObjType = 0;
        R01DContentModelManager contentManager = new R01DContentModelManager();
        Object objParent = null;
        Object objChild = null;
        if (arrParentChild.length == 2) {
            objParent = arrParentChild[0];
            objChild = arrParentChild[1];
        } else if (arrParentChild.length == 1) {
            objChild = arrParentChild[0];
        }
        if (objChild instanceof R01MContent) {
            content = (R01MContent)objChild;
            targetObjType = 0;
        } else if (objChild instanceof R01MDocument) {
            block30: {
                try {
                    if (operation == 6 || operation == 5 && !contentManager.doCheckContentExistence(((R01MContent)objParent).getOid()) || operation == 1 && !contentManager.doCheckContentExistence(((R01MContent)objParent).getOid())) {
                        content = (R01MContent)objParent;
                        break block30;
                    }
                    if (contentManager.doCheckContentExistence(((R01MContent)objParent).getOid())) {
                        try {
                            R01DContentCMPLocal contCMP = R01DContentCMPUtil.getLocalHome().findByPrimaryKey(new R01DContentCMPPK(((R01MContent)objParent).getOid()));
                            if (contCMP != null) {
                                content = contCMP.getDescriptor() != null ? contentManager.doLoadContent(this._userCtx, ((R01MContent)objParent).getOid()) : (R01MContent)objParent;
                                break block30;
                            }
                            content = (R01MContent)objParent;
                        }
                        catch (Exception ex) {
                            content = (R01MContent)objParent;
                        }
                        break block30;
                    }
                    content = (R01MContent)objParent;
                }
                catch (R01MContentModelException ex) {
                    content = (R01MContent)objParent;
                }
            }
            document = (R01MDocument)objChild;
            targetObjType = 1;
        } else if (objChild instanceof R01MDataFile) {
            try {
                String contentOid = contentManager.doGetDocumentParentContent(((R01MDocument)objParent).getOid());
                R01DDAOContentModelLoader lazyContentLoader = new R01DDAOContentModelLoader(this._userCtx);
                if (!StringUtils.isEmptyString((String)contentOid)) {
                    content = lazyContentLoader.executeLoadContent(contentOid);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            document = (R01MDocument)objParent;
            datafile = (R01MDataFile)objChild;
            targetObjType = 2;
        }
        if (content != null) {
            int historyActionOid = 0;
            String comments = "";
            switch (operation) {
                case 0: {
                    if (objChild instanceof R01MContent) {
                        historyActionOid = 4;
                        comments = "Contenido modificado correctamente";
                        break;
                    }
                    if (objChild instanceof R01MDocument) {
                        historyActionOid = 5;
                        comments = "Documento modificado correctamente";
                        break;
                    }
                    if (!(objChild instanceof R01MDataFile)) break;
                    historyActionOid = 6;
                    comments = "Archivo modificado correctamente";
                    break;
                }
                case 1: 
                case 5: {
                    if (objChild instanceof R01MContent) {
                        historyActionOid = 1;
                        comments = "Contenido creado correctamente";
                        break;
                    }
                    if (objChild instanceof R01MDocument) {
                        historyActionOid = 2;
                        comments = "Documento creado correctamente";
                        break;
                    }
                    if (!(objChild instanceof R01MDataFile)) break;
                    historyActionOid = 3;
                    comments = "Archivo creado correctamente";
                    break;
                }
                case 2: 
                case 6: {
                    if (objChild instanceof R01MContent) {
                        historyActionOid = 14;
                        comments = "Contenido borrado correctamente";
                        break;
                    }
                    if (objChild instanceof R01MDocument) {
                        historyActionOid = 15;
                        comments = "Documento borrado correctamente";
                        break;
                    }
                    if (!(objChild instanceof R01MDataFile)) break;
                    historyActionOid = 16;
                    comments = "Archivo borrado correctamente";
                    break;
                }
            }
            contentManager._sendHistoryMessage(this._userCtx.getUserName(), content, (R01MBaseDocumentInterface)document, datafile, targetObjType, historyActionOid, comments);
        }
    }
}

