/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services;

import com.ejie.r01d.datastore.R01DContentInDataStore;
import com.ejie.r01d.exceptions.R01DContentIndexException;
import com.ejie.r01d.exceptions.R01DContentModelPersistenceException;
import com.ejie.r01d.gestorcontenidos.dbhelppers.R01DContentModelLoaderHelper;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MIndexerModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexDefinition;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableContent;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableDocument;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01p.objects.searchengine.indexer.R01PContentToIndexableConverter;
import com.ejie.r01p.services.R01PClientFactory;
import java.util.HashMap;
import java.util.logging.Level;

public class R01DIndexerManager {
    private static String LOG_TYPE_ID = "r01d.indexerProcessor";
    private static boolean DEBUG = R01FLog.getLogLevel((String)LOG_TYPE_ID).intValue() != Level.OFF.intValue();
    private R01PContentToIndexableConverter _converter = null;

    public void prepareToIndex(R01MIndexDefinition indexElement) throws R01DContentIndexException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("R01DIndexerManager.prepareToIndex >>");
            R01FLog.to((String)LOG_TYPE_ID).info(indexElement.debugInfo("").toString());
        }
        try {
            indexElement.validateObject();
        }
        catch (R01MIndexerModelObjectsValidatorException pubExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("R01DIndexerManager.prepareToIndex >> El objeto de indexaci\u00f3n no es v\u00e1lido.");
            R01FLog.to((String)LOG_TYPE_ID).severe(indexElement.debugInfo("").toString());
            throw new R01DContentIndexException("El objeto de indexaci\u00f3n no es v\u00e1lido (paso R01DIndexerManager.prepareToIndex).", (Exception)((Object)pubExc));
        }
        String objectOid = indexElement.getObjectOid();
        int objectType = indexElement.getObjectType();
        try {
            if (indexElement.getIndexType() == 0) {
                String[] contentOids;
                R01MUserContext adminContext = null;
                try {
                    adminContext = R01MAuthManager.createMasterSystemUserContext();
                }
                catch (R01MSecurityException secEx) {
                    throw new R01DContentIndexException("Error al tratar de obtener el contexto del usuario administrador", (Exception)((Object)secEx));
                }
                try {
                    contentOids = R01DContentModelLoaderHelper.getContentModelOids((String)objectOid, (int)objectType);
                }
                catch (R01DContentModelPersistenceException cmpEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error en el proceso previo a la indexaci\u00f3n del objeto de \n\t-tipo " + R01MConstants.OBJECT_DESCS[objectType] + " y de " + "\n\t-identificador '" + objectOid + "'." + "\nNo se puede obtener los OIDs de los objetos padre. " + "\nError:" + cmpEx.getMessage());
                    throw new R01DContentIndexException("No se han podido obtener los OIDs del objeto " + (objectOid == null ? "[null / empty]" : objectOid) + " de tipo " + Integer.toString(objectType) + ": " + cmpEx.getMessage(), (Exception)((Object)cmpEx));
                }
                String contentOid = contentOids[0];
                String documentOid = contentOids[1];
                R01MContent content = this._getContent(adminContext, contentOid);
                if (content != null) {
                    boolean copyIndexableXMLToContentFolder;
                    this._converter = new R01PContentToIndexableConverter(adminContext, content);
                    try {
                        this._converter.setSearchMetadataStorage(R01MClientFactory.getSearchMetaDataStorageConfigAPI().getSearchMetaDataStorageConfig(content.getStoreLocation().getServerOid(), content.getStoreLocation().getDataRepositoryOid()));
                    }
                    catch (R01MConfigLoadException clEx) {
                        throw new R01DContentIndexException("Error al cargar la configuraci\u00f3n completa de los metadatos para obtener el objeto indexable del contenido " + content.getOid() + " de las tablas de r01d: " + clEx.getMessage(), (Exception)((Object)clEx));
                    }
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("R01DIndexerManager.prepareToIndex (" + indexElement.getObjectOid() + ")>> Cargar el objeto indexable........");
                    }
                    R01MIndexableContent idxCont = this._getIndexableContent(adminContext, objectType, contentOid, documentOid);
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("R01DIndexerManager.prepareToIndex (" + indexElement.getObjectOid() + ")>> Subir el XML indexable........");
                    }
                    if (copyIndexableXMLToContentFolder = XMLProperties.getBoolean((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentIndexPrepareOps/copyIndexableXMLToContentFolder", (boolean)true)) {
                        R01DContentInDataStore contInDS = new R01DContentInDataStore(adminContext, content);
                        try {
                            String idxDescriptorXML = "<?xml version='1.0' encoding='ISO-8859-1'?>" + XOManager.getXML((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (Object)idxCont);
                            contInDS.updateIndexableDescriptor(idxDescriptorXML);
                        }
                        catch (XOMarshallerException xoEx) {
                            throw new R01DContentIndexException("No se ha podido convertir el contenido indexable en XML: " + xoEx.getMessage(), (Exception)((Object)xoEx));
                        }
                        catch (R01MDataStoreException dsEx) {
                            throw new R01DContentIndexException("NO se ha podido subir el XML indexable al dataStore: " + dsEx.getMessage(), (Exception)((Object)dsEx));
                        }
                    }
                } else {
                    R01FLog.to((String)LOG_TYPE_ID).severe("R01DIndexerManager.index >> El contenido de identificador '" + contentOid + "' no se ha podido cargar desde el XML de Base de datos.");
                    throw new R01DContentIndexException("R01DIndexerManager.index >> El contenido de identificador '" + contentOid + "' no se ha podido cargar desde el XML de Base de Datos.");
                }
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("R01DIndexerManager.prepareToIndex (" + indexElement.getObjectOid() + ")>> Notificar fin de prepareToIndex........");
            }
            HashMap<String, String> indexersMap = new HashMap<String, String>();
            indexersMap.put("default", "Prepare to index finished correctly.");
            try {
                R01PClientFactory.getSearchEngineIndexerAPI().prepareToIndexFinished(indexElement.getObjectOid(), indexElement.getObjectType(), "OK", indexersMap);
            }
            catch (R01MSearchIndexerException siEx) {
                throw new R01DContentIndexException((Exception)((Object)siEx));
            }
        }
        catch (Exception e) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en el prepareToIndex del contenido del objeto de identificador '" + objectOid + "' del tipo " + objectType + ".Error:" + e.getMessage());
            throw new R01DContentIndexException("Error en el prepareToIndex del contenido del objeto de identificador '" + objectOid + "' del tipo " + objectType, e);
        }
        catch (Throwable th) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en el prepareToIndex del contenido del objeto de identificador '" + objectOid + " ' del tipo " + objectType + ".Error:" + th.getMessage());
            throw new R01DContentIndexException("Error en el prepareToIndex del contenido del objeto de identificador '" + objectOid + "' del tipo " + objectType + ".Error:" + th.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("R01DIndexerManager.prepareToIndex (" + indexElement.getObjectOid() + ")>> Fin de prepareToIndex........");
        }
    }

    private R01MIndexableContent _getIndexableContentFromContentModel(String contentOid) throws R01DContentIndexException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n%%%%% R01DIndexerManager._getIndexableContentFromContentModel: Preparando el contenido " + contentOid + " para su indexaci\u00f3n....");
        }
        R01MIndexableContent idxCont = null;
        try {
            idxCont = this._converter.getIndexableContent();
        }
        catch (R01MSecurityException secEx) {
            throw new R01DContentIndexException("Error al tratar de obtener el objeto indexable para el contenido de OID " + contentOid, (Exception)((Object)secEx));
        }
        if (idxCont == null) {
            throw new R01DContentIndexException("No se puede transformar en objeto indexable el contenido con OID " + contentOid);
        }
        return idxCont;
    }

    private R01MIndexableDocument _getIndexableDocumentFromContentModel(String documentOid) throws R01DContentIndexException {
        if (StringUtils.isEmptyString((String)documentOid)) {
            throw new R01DContentIndexException("Error al tratar de obtener el documento indexable. Oid del documento pasado es vac\u00edo o nulo");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n%%%%% R01DIndexerManager._getIndexableDocumentFromContentModel: Preparando el documento " + documentOid + " para su indexaci\u00f3n....");
        }
        R01MIndexableDocument idxDoc = null;
        try {
            idxDoc = this._converter.getIndexableDocument(documentOid);
        }
        catch (R01MSecurityException secEx) {
            throw new R01DContentIndexException("Error al tratar de obtener el objeto indexable para el documento de OID " + documentOid, (Exception)((Object)secEx));
        }
        if (idxDoc == null) {
            throw new R01DContentIndexException("No se puede transformar en objeto indexable el documento con OID " + documentOid);
        }
        return idxDoc;
    }

    private R01MContent _getContent(R01MUserContext usrContext, String contentOid) {
        if (StringUtils.isEmptyString((String)contentOid)) {
            return null;
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n%%%%% R01DIndexerManager._getContent: Cargando el contenido " + contentOid + ".");
        }
        R01MContent content = null;
        try {
            R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(usrContext);
            content = loaderHelper.loadContentFromDBXML(contentOid);
        }
        catch (R01DContentModelPersistenceException cmEx) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Error al cargar el contenido de oid: " + contentOid);
            }
            return null;
        }
        if (content != null) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\r\n\r\n%%%%% R01DIndexerManager._getContent: Contenido " + contentOid + " cargado. Validando la tipolog\u00eda y el storage del mismo.");
            }
            try {
                if (content.getStoreLocation() == null || content.getTypo() == null) {
                    if (content.getStoreLocation() == null && DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("Store nulo para el contenido de OID " + contentOid);
                    }
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("Typo nulo para el contenido de OID " + contentOid);
                    }
                    return null;
                }
                content.getStoreLocation().validateObject();
                content.getTypo().validateObject();
            }
            catch (R01MContentModelObjectsValidatorException cmExc) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("La tipolog\u00eda o el almacenamiento del contenido " + contentOid + " es incorrecta.Error:" + cmExc.getMessage());
                }
                return null;
            }
        }
        return content;
    }

    private R01MIndexableContent _getIndexableContent(R01MUserContext usrContext, int objType, String contentOid, String documentOid) throws R01DContentIndexException {
        R01MIndexableContent idxCont;
        block15: {
            if (StringUtils.isEmptyString((String)contentOid)) {
                throw new R01DContentIndexException("Error al tratar de obtener el contenido indexable. Oid del contentOid pasado es vac\u00edo o nulo");
            }
            if (objType != 0 && objType != 1) {
                throw new R01DContentIndexException("Error al tratar de obtener el contenido indexable con un documento actualizado. tipo de objeto no permitido par ala indexaci\u00f3n: " + Integer.toString(objType));
            }
            if (objType == 1 && StringUtils.isEmptyString((String)documentOid)) {
                throw new R01DContentIndexException("Error al tratar de obtener el contenido indexable con un documento actualizado. Oid del documentOid pasado es vac\u00edo o nulo");
            }
            idxCont = null;
            if (objType == 0) {
                idxCont = this._getIndexableContentFromContentModel(contentOid);
            } else if (objType == 1) {
                if (StringUtils.isEmptyString((String)documentOid)) {
                    throw new R01DContentIndexException("Oid del documento a indexar nulo o vac\u00edo: " + documentOid);
                }
                try {
                    if (R01PClientFactory.getSearchEngineIndexerAPI().checkObjectExistence(contentOid)) {
                        try {
                            idxCont = R01PClientFactory.getSearchEngineIndexerAPI().loadIndexableContent(usrContext, contentOid);
                            this._converter.updateCommonDataIndexableContent(idxCont);
                            R01MIndexableDocument idxDoc = this._getIndexableDocumentFromContentModel(documentOid);
                            HashMap<String, R01MIndexableDocument> documents = idxCont.getDocuments();
                            if (documents == null) {
                                documents = new HashMap<String, R01MIndexableDocument>();
                            }
                            documents.put(documentOid, idxDoc);
                            idxCont.setDocuments(documents);
                        }
                        catch (R01MSearchIndexerException siEx) {
                            if (DEBUG) {
                                R01FLog.to((String)LOG_TYPE_ID).warning("\r\n\r\n%%%%% R01DIndexerManager.preIndex: Error al obtener el objeto indexable de las tablas de r01k: " + siEx.getMessage() + ". Se tratar\u00e1 de obtener el objeto indexable del modelo de contenidos.");
                            }
                            idxCont = this._getIndexableContentFromContentModel(contentOid);
                        }
                    } else {
                        idxCont = this._getIndexableContentFromContentModel(contentOid);
                    }
                }
                catch (R01MSearchIndexerException siEx) {
                    if (!DEBUG) break block15;
                    R01FLog.to((String)LOG_TYPE_ID).warning("\r\n\r\n%%%%% R01DIndexerManager.preIndex: Error al comprobar si existe el objeto indexable de las tablas de r01k: " + siEx.getMessage() + ". Se tratar\u00e1 de obtener el objeto indexable del modelo de contenidos.");
                    idxCont = this._getIndexableContentFromContentModel(contentOid);
                }
            }
        }
        return idxCont;
    }
}

