/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services;

import com.ejie.r01d.gestorcontenidos.ejb.bmp.gip.R01DGipBMPLocal;
import com.ejie.r01d.gestorcontenidos.ejb.bmp.gip.R01DGipBMPLocalHome;
import com.ejie.r01d.gestorcontenidos.ejb.bmp.gip.R01DGipBMPUtil;
import com.ejie.r01f.exceptions.ExceptionUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.objects.listelements.ListElement;
import com.ejie.r01f.objects.listelements.ListElementCollection;
import com.ejie.r01f.objects.tree.TreeImpl;
import com.ejie.r01f.objects.tree.TreeNode;
import com.ejie.r01f.sql.BDConnectionHelpper;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MGIPException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.gip.R01MGipOrgChartElement;
import com.ejie.r01m.objects.gip.R01MGipOrgDetails;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01p.services.bzd.R01PGipManagerBzd;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

public class R01DGipManager
implements R01PGipManagerBzd {
    private static final String EU = "eu";
    private static final String EN = "en";
    private static final String FR = "fr";
    private static final String DE = "de";
    private static final String ES_GIPCOD = "_cast";
    private static final String EU_GIPCOD = "_eusk";
    private static final String EN_GIPCOD = "_ingl";
    private static final String FR_GIPCOD = "_fran";
    private static final String DE_GIPCOD = "_alem";

    public R01MGipOrgDetails doGetGipOrgDetails(R01MUserContext userCtx, String gipOrgCode) throws EJBException, R01MSecurityException, R01MGIPException {
        try {
            R01DGipBMPLocalHome home = R01DGipBMPUtil.getLocalHome();
            R01DGipBMPLocal gipBMP = home.findByPrimaryKey(gipOrgCode);
            return gipBMP.getGipOrgDetails();
        }
        catch (NamingException nameEx) {
            throw new R01MGIPException("NO se puede instanciar el EJB BMP que maneja los detalles de un organismo gip: " + nameEx.getMessage(), (Exception)nameEx);
        }
        catch (FinderException findEx) {
            throw new R01MGIPException("NO se ha podido encontrar el registro para el codigo de organismo " + gipOrgCode + ": " + findEx.getMessage(), (Exception)((Object)findEx));
        }
    }

    public TreeImpl doGetArbolDepartamento(R01MUserContext userCtx, String langCod, String codDpto) throws R01MSecurityException, R01MGIPException {
        StringBuffer dbg = new StringBuffer(">>>doGetArbolDepartamento\r\n");
        String lang = this._translateLanguage(langCod);
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        Hashtable<String, TreeNode> raices = new Hashtable<String, TreeNode>();
        TreeNode nodo = null;
        ListElement datos = null;
        TreeImpl arbol = null;
        String raizEstructura = null;
        String descDpto = null;
        String sql = null;
        if (codDpto == null) {
            throw new R01MGIPException("getArbolEstructura: El c\u00f3digo del departamento no puede ser null");
        }
        try {
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            sql = "SELECT descr" + lang + " " + "FROM R01L.R01LLAV00 " + "WHERE codorgno='" + codDpto + "'";
            dbg.append("\tObtener el nombre del departamento -> " + sql);
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (!rs.next()) {
                dbg.append("----->NULL ---> ERROR: No se ha podido obtener el nombre del dpto");
                TreeImpl treeImpl = null;
                return treeImpl;
            }
            descDpto = rs.getString("descr" + lang);
            dbg.append("----->" + descDpto + "\r\n");
            rs.close();
            sql = "SELECT cenorg, codestr_us, descr" + lang + " " + "FROM R01L.R01LLBV00 " + "WHERE codorgno='" + codDpto + "' " + "ORDER BY codestr_us";
            dbg.append("\tObtener los datos de la estructura: " + sql + "\r\n");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (!rs.next()) {
                TreeImpl treeImpl = null;
                return treeImpl;
            }
            raizEstructura = rs.getString("codestr_us");
            datos = new ListElement(raizEstructura, (Object)descDpto);
            arbol = new TreeImpl((Object)datos);
            raices.put(raizEstructura, arbol.getRootNode());
            dbg.append("\tConstruir el arbol: ");
            TreeNode nodoPadre = null;
            String codEstructura = null;
            String raiz = null;
            while (rs.next()) {
                codEstructura = rs.getString("codestr_us");
                codEstructura = codEstructura + "00000000";
                codEstructura = codEstructura.substring(0, 8);
                try {
                    datos = new ListElement(rs.getString("cenorg"), (Object)rs.getString("descr" + lang));
                    nodo = arbol.createNode((Object)datos);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace(System.out);
                }
                if (!raices.containsKey(raiz = this._getRaizEstructura(codEstructura))) continue;
                nodoPadre = (TreeNode)raices.get(raiz);
                nodoPadre.appendChild(nodo);
                raices.put(codEstructura, nodo);
            }
            dbg.append("OK\r\n");
            TreeImpl treeImpl = arbol;
            return treeImpl;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            dbg.append("\r\nERROR\r\n" + ExceptionUtils.serializeExceptionStackTrace((Throwable)e));
            throw new R01MGIPException("getArbolEstructura(String): " + e.getMessage());
        }
        finally {
            System.out.println(dbg.toString());
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (qry != null) {
                    qry.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (conx != null) {
                    conx.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public TreeImpl doGetArbolDepartamento(R01MUserContext userCtx, String langCod, String codDpto, int nivel) throws R01MSecurityException, R01MGIPException {
        StringBuffer dbg = new StringBuffer(">>>doGetArbolDepartamento con nivel\r\n");
        String lang = this._translateLanguage(langCod);
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        Hashtable<String, TreeNode> raices = new Hashtable<String, TreeNode>();
        TreeNode nodo = null;
        ListElement datos = null;
        TreeImpl arbol = null;
        String raizEstructura = null;
        String descDpto = null;
        String sql = null;
        if (codDpto == null) {
            throw new R01MGIPException("getArbolEstructura: El c\u00f3digo del departamento no puede ser null");
        }
        try {
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            sql = "SELECT descr" + lang + " " + "FROM R01L.R01LLAV00 " + "WHERE codorgno='" + codDpto + "'";
            dbg.append("\tObtener el nombre del departamento -> " + sql);
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (!rs.next()) {
                dbg.append("----->NULL ---> ERROR: No se ha podido obtener el nombre del dpto");
                TreeImpl treeImpl = null;
                return treeImpl;
            }
            descDpto = rs.getString("descr" + lang);
            dbg.append("----->" + descDpto + "\r\n");
            rs.close();
            sql = "SELECT cenorg, codestr_us, descr" + lang + " " + "FROM R01L.R01LLBV00 " + "WHERE codorgno='" + codDpto + "' " + "ORDER BY codestr_us";
            dbg.append("\tObtener los datos de la estructura: " + sql + "\r\n");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (!rs.next()) {
                TreeImpl e = null;
                return e;
            }
            raizEstructura = rs.getString("codestr_us");
            int nivelRaiz = this._getLevelFromCode(raizEstructura);
            datos = new ListElement(raizEstructura, (Object)descDpto);
            arbol = new TreeImpl((Object)datos, nivelRaiz);
            raices.put(raizEstructura, arbol.getRootNode());
            dbg.append("\tConstruir el arbol: ");
            TreeNode nodoPadre = null;
            String codEstructura = null;
            String raiz = null;
            int newNivel = 0;
            while (rs.next()) {
                codEstructura = rs.getString("codestr_us");
                codEstructura = codEstructura + "00000000";
                newNivel = this._getLevelFromCode(codEstructura = codEstructura.substring(0, 8));
                if (newNivel > nivel) continue;
                try {
                    datos = new ListElement(rs.getString("cenorg"), (Object)rs.getString("descr" + lang));
                    nodo = arbol.createNode((Object)datos);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace(System.out);
                }
                if (!raices.containsKey(raiz = this._getRaizEstructura(codEstructura))) continue;
                nodoPadre = (TreeNode)raices.get(raiz);
                nodoPadre.appendChild(nodo, newNivel);
                raices.put(codEstructura, nodo);
            }
            dbg.append("OK\r\n");
            TreeImpl treeImpl = arbol;
            return treeImpl;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            dbg.append("\r\nERROR\r\n" + ExceptionUtils.serializeExceptionStackTrace((Throwable)e));
            throw new R01MGIPException("getArbolDepartamento: " + e.getMessage());
        }
        finally {
            System.out.println(dbg.toString());
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (qry != null) {
                    qry.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (conx != null) {
                    conx.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public TreeImpl doGetArbolEstructura(R01MUserContext userCtx, String langCod) throws R01MSecurityException, R01MGIPException {
        StringBuffer dbg = new StringBuffer(">>>doGetArbolEstructura\r\n");
        String lang = this._translateLanguage(langCod);
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        Hashtable<String, TreeNode> raices = new Hashtable<String, TreeNode>();
        TreeNode nodo = null;
        ListElement datos = null;
        TreeImpl arbol = null;
        try {
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            datos = new ListElement("0", (Object)"Arbol Gobierno Vasco");
            arbol = new TreeImpl((Object)datos);
            String sql = "SELECT cenorg, codestr_us, descr" + lang + " " + "FROM R01L.R01LLBV00 " + "ORDER BY codestr_us";
            dbg.append("\tObtener registros de la estructura: " + sql + "\r\n");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            TreeNode nodoPadre = null;
            String codEstructura = null;
            String raiz = null;
            dbg.append("\tProcesar arbol...");
            if (rs.next()) {
                do {
                    codEstructura = rs.getString("codestr_us");
                    codEstructura = codEstructura + "00000000";
                    codEstructura = codEstructura.substring(0, 8);
                    try {
                        datos = new ListElement(rs.getString("cenorg"), (Object)rs.getString("descr" + lang));
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace(System.out);
                    }
                    nodo = arbol.createNode((Object)datos);
                    raiz = this._getRaizEstructura(codEstructura);
                    if (raices.containsKey(raiz)) {
                        nodoPadre = (TreeNode)raices.get(raiz);
                        nodoPadre.appendChild(nodo);
                        raices.put(codEstructura, nodo);
                        continue;
                    }
                    nodoPadre = arbol.getRootNode();
                    nodoPadre.appendChild(nodo);
                    raices.put(raiz, nodo);
                } while (rs.next());
                dbg.append("OK\r\n");
                TreeImpl treeImpl = arbol;
                return treeImpl;
            }
            dbg.append("no hay hijos\r\n;");
            TreeImpl treeImpl = null;
            return treeImpl;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            dbg.append("\r\nERROR:\r\n" + ExceptionUtils.serializeExceptionStackTrace((Throwable)e));
            throw new R01MGIPException("getArbolEstructura(): " + e.getMessage(), e);
        }
        finally {
            System.out.println(dbg.toString());
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (qry != null) {
                    qry.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (conx != null) {
                    conx.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public TreeImpl doGetArbolEstructura(R01MUserContext userCtx, String langCod, String codNodo) throws R01MSecurityException, R01MGIPException {
        StringBuffer dbg = new StringBuffer(">>>doGetArbolEstructura\r\n");
        String lang = this._translateLanguage(langCod);
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        Hashtable<String, TreeNode> raices = new Hashtable<String, TreeNode>();
        TreeNode nodo = null;
        ListElement datos = null;
        TreeImpl arbol = null;
        String raizEstructura = null;
        if (codNodo == null) {
            throw new R01MGIPException("getArbolEstructura: El c\u00f3digo del nodo no puede ser null");
        }
        try {
            raizEstructura = this.doGetCodigoEstructura(userCtx, codNodo);
            if (raizEstructura == null) {
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (raizEstructura != null) {
            while (raizEstructura.charAt(raizEstructura.length() - 1) == '0' && raizEstructura.length() > 1) {
                raizEstructura = raizEstructura.substring(0, raizEstructura.length() - 1);
            }
        }
        try {
            String sql = "SELECT cenorg, codestr_us, descr" + lang + " " + "FROM R01L.R01LLBV00 " + "WHERE codestr_us LIKE '" + raizEstructura + "%' " + "ORDER BY codestr_us";
            dbg.append("\tObtener los datos del arbol: " + sql + "\r\n");
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (!rs.next()) {
                dbg.append("\t-NO se ha podido obtener la raiz del arbol\r\n");
                TreeImpl treeImpl = null;
                return treeImpl;
            }
            R01FLog.to((String)"r01d.gip").info("--Recuperacion el codigo CODESTR_US en GETARBOLESTRUCTURA(,)" + rs.getString("codestr_us"));
            raizEstructura = rs.getString("codestr_us");
            datos = new ListElement(raizEstructura, (Object)rs.getString("descr" + lang));
            arbol = new TreeImpl((Object)datos);
            raices.put(raizEstructura, arbol.getRootNode());
            dbg.append("\t-Raiz del arbol OK\r\n");
            dbg.append("\t-Construir el arbol...");
            TreeNode nodoPadre = null;
            String codEstructura = null;
            String raiz = null;
            while (rs.next()) {
                codEstructura = rs.getString("codestr_us");
                codEstructura = codEstructura + "00000000";
                codEstructura = codEstructura.substring(0, 8);
                try {
                    datos = new ListElement(rs.getString("cenorg"), (Object)rs.getString("descr" + lang));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace(System.out);
                }
                nodo = arbol.createNode((Object)datos);
                raiz = this._getRaizEstructura(codEstructura);
                if (!raices.containsKey(raiz)) continue;
                nodoPadre = (TreeNode)raices.get(raiz);
                nodoPadre.appendChild(nodo);
                raices.put(codEstructura, nodo);
            }
            dbg.append("OK\r\n");
            TreeImpl treeImpl = arbol;
            return treeImpl;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            dbg.append("\r\nError:\r\n" + ExceptionUtils.serializeExceptionStackTrace((Throwable)e));
            throw new R01MGIPException("getArbolEstructura(String): " + e.getMessage());
        }
        finally {
            System.out.println(dbg.toString());
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (qry != null) {
                    qry.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (conx != null) {
                    conx.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public TreeImpl doGetArbolEstructura(R01MUserContext userCtx, String langCod, String codNodo, int nivel) throws R01MSecurityException, R01MGIPException {
        StringBuffer dbg = new StringBuffer(">>>doGetArbolEstructura\r\n");
        String lang = this._translateLanguage(langCod);
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        Hashtable<String, TreeNode> raices = new Hashtable<String, TreeNode>();
        TreeNode nodo = null;
        ListElement datos = null;
        TreeImpl arbol = null;
        String raizEstructura = null;
        if (codNodo == null) {
            throw new R01MGIPException("getArbolEstructura: El c\u00f3digo del nodo no puede ser null");
        }
        try {
            raizEstructura = this.doGetCodigoEstructura(userCtx, codNodo);
            if (raizEstructura == null) {
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        if (raizEstructura != null) {
            while (raizEstructura.charAt(raizEstructura.length() - 1) == '0' && raizEstructura.length() > 1) {
                raizEstructura = raizEstructura.substring(0, raizEstructura.length() - 1);
            }
        }
        try {
            String sql = "SELECT cenorg, codestr_us, descr" + lang + " " + "FROM R01L.R01LLBV00 " + "WHERE codestr_us LIKE '" + raizEstructura + "%' " + "ORDER BY codestr_us";
            dbg.append("\t-Obtener el arbol: " + sql + "\r\n");
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (!rs.next()) {
                dbg.append("\t-Raiz NOK\r\n");
                TreeImpl treeImpl = null;
                return treeImpl;
            }
            R01FLog.to((String)"r01d.gip").info("En la recuperaci\u00f3n el c\u00f3digo CODESTR_US en GETARBOLESTRUCTURA(,)" + rs.getString("codestr_us"));
            raizEstructura = rs.getString("codestr_us");
            datos = new ListElement(raizEstructura, (Object)rs.getString("descr" + lang));
            arbol = new TreeImpl((Object)datos);
            raices.put(raizEstructura, arbol.getRootNode());
            dbg.append("\t-Raiz OK\r\n");
            dbg.append("\t-Crear arbol...");
            TreeNode nodoPadre = null;
            String codEstructura = null;
            String raiz = null;
            while (rs.next()) {
                codEstructura = rs.getString("codestr_us");
                codEstructura = codEstructura + "00000000";
                codEstructura = codEstructura.substring(0, 8);
                try {
                    datos = new ListElement(rs.getString("cenorg"), (Object)rs.getString("descr" + lang));
                    nodo = arbol.createNode((Object)datos);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace(System.out);
                }
                if (!raices.containsKey(raiz = this._getRaizEstructura(codEstructura)) || (nodoPadre = (TreeNode)raices.get(raiz)).getNodeLevel() == nivel) continue;
                nodoPadre.appendChild(nodo);
                raices.put(codEstructura, nodo);
            }
            dbg.append("OK\r\n");
            TreeImpl treeImpl = arbol;
            return treeImpl;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            dbg.append("\r\nERROR:\r\n" + ExceptionUtils.serializeExceptionStackTrace((Throwable)e));
            throw new R01MGIPException("getArbolEstructura(String,int): " + e.getMessage());
        }
        finally {
            System.out.println(dbg.toString());
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (qry != null) {
                    qry.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (conx != null) {
                    conx.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public TreeImpl doGetOrganigrama(R01MUserContext userCtx, String langCod, String codDpto, int nivel) throws R01MSecurityException, R01MGIPException {
        StringBuffer dbg = new StringBuffer(">>>doGetOrganigrama\r\n");
        String lang = this._translateLanguage(langCod);
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        String sql = null;
        Hashtable<String, TreeNode> raices = new Hashtable<String, TreeNode>();
        TreeNode nodo = null;
        R01MGipOrgChartElement datos = null;
        TreeImpl arbol = null;
        String raizEstructura = null;
        String descDpto = null;
        String tipoOrg = null;
        if (codDpto == null) {
            throw new R01MGIPException("getOrganigrama: El c\u00f3digo del departamento no puede ser null");
        }
        try {
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            sql = "SELECT descr" + lang + ", TIPO_NIV " + "FROM R01L.R01LLAV00 " + "WHERE codorgno='" + codDpto + "'";
            dbg.append("\tObtener el nombre del departamento -> " + sql);
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (!rs.next()) {
                dbg.append("--->NULL\r\n");
                TreeImpl treeImpl = null;
                return treeImpl;
            }
            descDpto = rs.getString("descr" + lang);
            tipoOrg = rs.getString("TIPO_NIV");
            dbg.append("---> " + descDpto + "(" + tipoOrg + ")\r\n");
            sql = "SELECT cenorg, codestr_us, InitCap(responsable) AS responsable, descr" + lang + " " + "FROM R01L.R01LLBV00 " + "WHERE codorgno='" + codDpto + "' " + "ORDER BY codestr_us";
            dbg.append("\t-Obtener datos de la estructura: " + sql + "\r\n");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (!rs.next()) {
                dbg.append("\t-Raiz NOK\r\n");
                TreeImpl e = null;
                return e;
            }
            raizEstructura = rs.getString("codestr_us");
            int nivelRaiz = this._getLevelFromCode(raizEstructura);
            datos = new R01MGipOrgChartElement(rs.getString("cenorg"), descDpto, this._toLowerCaseParticulas(rs.getString("responsable")), tipoOrg);
            arbol = new TreeImpl((Object)datos, nivelRaiz);
            raices.put(raizEstructura, arbol.getRootNode());
            dbg.append("\t-Raiz OK\r\n");
            dbg.append("\t-Procesar estructura....");
            TreeNode nodoPadre = null;
            String codEstructura = null;
            String raiz = null;
            int newNivel = 0;
            while (rs.next()) {
                codEstructura = rs.getString("codestr_us");
                newNivel = this._getLevelFromCode(codEstructura);
                codEstructura = codEstructura + "00000000";
                codEstructura = codEstructura.substring(0, 8);
                try {
                    datos = new R01MGipOrgChartElement(rs.getString("cenorg"), rs.getString("descr" + lang), this._toLowerCaseParticulas(rs.getString("responsable")));
                    nodo = arbol.createNode((Object)datos);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace(System.out);
                }
                if (!raices.containsKey(raiz = this._getRaizEstructura(codEstructura))) continue;
                nodoPadre = (TreeNode)raices.get(raiz);
                if (newNivel > nivel) continue;
                nodoPadre.appendChild(nodo, newNivel);
                raices.put(codEstructura, nodo);
            }
            dbg.append("OK\r\n");
            TreeImpl treeImpl = arbol;
            return treeImpl;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            dbg.append("\r\nERROR\r\n" + ExceptionUtils.serializeExceptionStackTrace((Throwable)e));
            throw new R01MGIPException("getOrganigrama(String,int): " + e.getMessage());
        }
        finally {
            System.out.println(dbg.toString());
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (qry != null) {
                    qry.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (conx != null) {
                    conx.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public String doGetCodigoEstructura(R01MUserContext userCtx, String codNodo) throws R01MSecurityException, R01MGIPException {
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        String resultado = null;
        try {
            String sql = "SELECT codestr_us FROM R01L.R01LLBV00 WHERE cenorg='" + codNodo + "'";
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (rs.next()) {
                resultado = rs.getString("codestr_us");
            }
            String string = resultado;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new R01MGIPException("getCodigoEstructura(String codNodo): " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (qry != null) {
                    qry.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (conx != null) {
                    conx.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public String doGetDepartamentoFromNodoEstructura(R01MUserContext userCtx, String codNodo) throws R01MSecurityException, R01MGIPException {
        StringBuffer dbg = new StringBuffer(">>>doGetDepartamentoFromNodoEstructura\r\n");
        String outName = null;
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        if (codNodo == null) {
            throw new R01MGIPException("getDepartamentoFromNodoEstructura: El c\u00f3digo del nodo no puede ser null");
        }
        try {
            String sql = "SELECT CODORGNO FROM R01L.R01LLBV00 WHERE CENORG = '" + codNodo + "'";
            dbg.append("\t-Obtener el nombre del departamento de la estructura " + codNodo + ": " + sql);
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (rs.next()) {
                outName = rs.getString("CODORGNO");
                dbg.append(">>>>>" + outName + "\r\n");
            }
            String string = outName;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new R01MGIPException(" getDepartamentoFromNodoEstructura(String codNodo): " + e.getMessage());
        }
        finally {
            System.out.println(dbg.toString());
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (qry != null) {
                    qry.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (conx != null) {
                    conx.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public String doGetNodoEstructuraFromDepartamento(R01MUserContext userCtx, String codDpto) throws R01MSecurityException, R01MGIPException {
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        if (codDpto == null) {
            throw new R01MGIPException("getNodoEstructuraFromDepartamento: El c\u00f3digo del departamento no puede ser null");
        }
        try {
            String sql = "SELECT CENORG,CODESTR_US FROM R01L.R01LLBV00 WHERE CODORGNO = '" + codDpto + "' " + "ORDER BY CODESTR_US";
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            qry = conx.prepareStatement(sql);
            qry.setMaxRows(1);
            rs = qry.executeQuery();
            if (rs.next()) {
                String string = rs.getString("CENORG");
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new R01MGIPException("getNodoEstructuraFromDepartamento: " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (qry != null) {
                    qry.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (conx != null) {
                    conx.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public ListElementCollection doGetNombreDepartamentos(R01MUserContext userCtx, String langCod) throws R01MSecurityException, R01MGIPException {
        String lang = this._translateLanguage(langCod);
        Connection conx = null;
        Statement qry = null;
        ResultSet rs = null;
        ListElementCollection departamentos = null;
        ListElement elemento = null;
        try {
            String sql = "SELECT codorgno, descr" + lang + " " + "FROM R01L.R01LLAV00 " + "ORDER BY DPTORGUS";
            conx = BDConnectionHelpper.getConnection((String)R01MConstants.USERINTERFACE_APPCODE, (String)"gipConnection");
            qry = conx.prepareStatement(sql);
            rs = qry.executeQuery();
            if (rs.next()) {
                departamentos = new ListElementCollection();
                do {
                    elemento = new ListElement(rs.getString("codorgno"), (Object)rs.getString("descr" + lang));
                    departamentos.add((Object)elemento);
                } while (rs.next());
            }
            ListElementCollection listElementCollection = departamentos;
            return listElementCollection;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new R01MGIPException("getNombreDepartamentos: " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (qry != null) {
                    qry.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            try {
                if (conx != null) {
                    conx.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    private int _getLevelFromCode(String codigo) {
        int nivel = 0;
        String theCode = new String(codigo);
        try {
            while (theCode.charAt(theCode.length() - 1) == '0' && theCode.length() > 1) {
                theCode = theCode.substring(0, theCode.length() - 1);
                ++nivel;
            }
            if (theCode.charAt(theCode.length() - 1) != '0') {
                if (nivel == 7) {
                    nivel = 1;
                } else if ((nivel -= 7) < 0) {
                    nivel *= -1;
                }
            } else {
                nivel = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return nivel;
    }

    private String _getRaizEstructura(String codEstructura) {
        String raiz = codEstructura;
        while (raiz.charAt(raiz.length() - 1) == '0' && raiz.length() > 1) {
            raiz = raiz.substring(0, raiz.length() - 1);
        }
        if (raiz.length() > 1) {
            raiz = raiz.substring(0, raiz.length() - 1);
            while (raiz.charAt(raiz.length() - 1) == '0' && raiz.length() > 1) {
                raiz = raiz.substring(0, raiz.length() - 1);
            }
        }
        raiz = raiz + "00000000";
        raiz = raiz.substring(0, 8);
        return raiz;
    }

    private String _translateLanguage(String langCod) {
        String outLang = ES_GIPCOD;
        if (langCod != null) {
            outLang = langCod.equalsIgnoreCase(DE) ? DE_GIPCOD : (langCod.equalsIgnoreCase(FR) ? FR_GIPCOD : (langCod.equalsIgnoreCase(EN) ? EN_GIPCOD : (langCod.equalsIgnoreCase(EU) ? EU_GIPCOD : ES_GIPCOD)));
        }
        return outLang;
    }

    private String _toLowerCaseParticula(String cadena, String particula) {
        StringBuffer strBufCadena = new StringBuffer(cadena);
        int posicion = cadena.indexOf(particula);
        while (posicion > -1) {
            strBufCadena.replace(posicion, posicion + particula.length(), particula.toLowerCase());
            posicion = cadena.indexOf(particula, posicion + 1);
        }
        return strBufCadena.toString();
    }

    private String _toLowerCaseParticulas(String cadena) {
        if (cadena.indexOf(" De ") > -1) {
            cadena = this._toLowerCaseParticula(cadena, " De ");
        }
        if (cadena.indexOf(" Del ") > -1) {
            cadena = this._toLowerCaseParticula(cadena, " Del ");
        }
        if (cadena.indexOf(" La ") > -1) {
            cadena = this._toLowerCaseParticula(cadena, " La ");
        }
        return cadena;
    }
}

