/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services;

import com.ejie.r01d.datastore.R01DContentInDataStore;
import com.ejie.r01d.ejb.services.labelslistener.R01DLabelsListenerSLUtil;
import com.ejie.r01d.exceptions.R01DContentModelException;
import com.ejie.r01d.exceptions.R01DContentModelPersistenceException;
import com.ejie.r01d.gestorcontenidos.dbhelppers.R01DContentModelLoaderHelper;
import com.ejie.r01d.gestorcontenidos.dbhelppers.R01DContentModelUpdateHelper;
import com.ejie.r01d.gestorcontenidos.dbhelppers.dao.R01DDAOContentModelLoader;
import com.ejie.r01d.gestorcontenidos.dbhelppers.dao.R01DDAOHistoryManager;
import com.ejie.r01d.gestorcontenidos.dbhelppers.dao.R01DDAOStorageContentsLoader;
import com.ejie.r01d.gestorcontenidos.dbhelppers.ejb.R01DEjbContentModelLoader;
import com.ejie.r01d.gestorcontenidos.dbhelppers.ejb.R01DEjbCoreModelObjsManager;
import com.ejie.r01d.gestorcontenidos.dbhelppers.ejb.R01DEjbModelHierarchyNavigator;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.alias.R01DDocumentAliasCMPLocal;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.alias.R01DDocumentAliasCMPPK;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.alias.R01DDocumentAliasCMPUtil;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.alias.R01DDocumentAliasCMPValue;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.businessErrors.R01DBusinessErrorsCMPLocal;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.businessErrors.R01DBusinessErrorsCMPPK;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.businessErrors.R01DBusinessErrorsCMPUtil;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.businessErrors.R01DBusinessErrorsCMPValue;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.notice.R01DNoticeCMPLocal;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.notice.R01DNoticeCMPLocalHome;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.notice.R01DNoticeCMPPK;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.notice.R01DNoticeCMPUtil;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.notice.R01DNoticeCMPValue;
import com.ejie.r01d.objects.R01DComposeResourceResult;
import com.ejie.r01d.renderer.interfaces.R01DResourcesRendererInterface;
import com.ejie.r01d.services.R01DModelUpdateOperationsLauncher;
import com.ejie.r01d.services.helpers.R01DContentModelInDataStoreHelper;
import com.ejie.r01d.services.helpers.R01DContentModelObjectsCopyHelper;
import com.ejie.r01d.services.helpers.R01DDataFileGenerationHelper;
import com.ejie.r01d.services.helpers.R01DDocumentStateHelper;
import com.ejie.r01d.services.helpers.R01DHistoryHelper;
import com.ejie.r01d.services.helpers.R01DIndexerHelper;
import com.ejie.r01d.services.helpers.R01DModelUpdateValidatorHelper;
import com.ejie.r01d.services.helpers.R01DNoticeHelper;
import com.ejie.r01d.services.helpers.R01DTypoMetadataGeneratorHelper;
import com.ejie.r01d.services.resources.R01DGalleryResourcesManager;
import com.ejie.r01d.services.resources.R01DLinkedResourcesManager;
import com.ejie.r01d.util.R01DUtils;
import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.jvt.JVTComparator;
import com.ejie.r01f.jvt.JVTComparatorException;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.CollectionConverterException;
import com.ejie.r01f.util.CollectionUtils;
import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsPacket;
import com.ejie.r01m.config.objects.cataloguing.R01MDefaultLabelConfig;
import com.ejie.r01m.config.objects.cataloguing.R01MStructureCataloguingConfig;
import com.ejie.r01m.config.objects.cataloguing.R01MStructureGroupCataloguingConfig;
import com.ejie.r01m.config.objects.publisher.R01MAllowedPublicationTarget;
import com.ejie.r01m.config.objects.publisher.R01MLogicalPublicationInfo;
import com.ejie.r01m.config.objects.publisher.R01MPublicationConfig;
import com.ejie.r01m.config.objects.storage.R01MWorkArea;
import com.ejie.r01m.config.objects.typology.R01MContentType;
import com.ejie.r01m.config.objects.typology.R01MResourcesRenderConfig;
import com.ejie.r01m.config.objects.typology.R01MResourcesRenderGroup;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MRoleRights;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.datastore.R01MDataStoreAuthObject;
import com.ejie.r01m.datastore.R01MDataStoreManager;
import com.ejie.r01m.exceptions.R01MCatalogElementNotFoundException;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MConfigControllerException;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MDataStoreAuthenticationException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MDeleteContentException;
import com.ejie.r01m.exceptions.R01MDeleteDataFileException;
import com.ejie.r01m.exceptions.R01MDeleteDocumentException;
import com.ejie.r01m.exceptions.R01MDeleteModelObjectException;
import com.ejie.r01m.exceptions.R01MDirtyContentModelException;
import com.ejie.r01m.exceptions.R01MDuplicateContentException;
import com.ejie.r01m.exceptions.R01MDuplicateDataFileException;
import com.ejie.r01m.exceptions.R01MDuplicateDocumentException;
import com.ejie.r01m.exceptions.R01MDuplicateModelObjectException;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.exceptions.R01MLinkResourcesException;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.objects.R01MBasePublicationTarget;
import com.ejie.r01m.objects.R01MURLAlias;
import com.ejie.r01m.objects.businesserrors.R01MBusinessErrors;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalogPairSelected;
import com.ejie.r01m.objects.cataloguing.picks.R01MGeoPicks;
import com.ejie.r01m.objects.cataloguing.structures.R01MBag;
import com.ejie.r01m.objects.cataloguing.structures.R01MLabel;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructure;
import com.ejie.r01m.objects.cataloguing.structures.R01MStructureItem;
import com.ejie.r01m.objects.contentmodel.R01MBaseDocumentInterface;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentHistory;
import com.ejie.r01m.objects.contentmodel.R01MContentHistoryFilter;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentPublishResume;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MDataFile;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationRequested;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublishResume;
import com.ejie.r01m.objects.contentmodel.R01MDocumentRevisionState;
import com.ejie.r01m.objects.contentmodel.R01MLinkedRelationsGroup;
import com.ejie.r01m.objects.contentmodel.R01MSaveContentResult;
import com.ejie.r01m.objects.contentmodel.R01MSearchedDocuments;
import com.ejie.r01m.objects.entities.R01MEntity;
import com.ejie.r01m.objects.link.R01MLink;
import com.ejie.r01m.objects.notice.R01MNotice;
import com.ejie.r01m.objects.publisher.R01MPublicationDestination;
import com.ejie.r01m.objects.publisher.R01MPublish;
import com.ejie.r01m.objects.publisher.R01MPublishActionObject;
import com.ejie.r01m.objects.resources.R01MGallery;
import com.ejie.r01m.objects.resources.R01MGalleryResource;
import com.ejie.r01m.objects.resources.R01MGalleryResourcesGroup;
import com.ejie.r01m.objects.resources.R01MLinkedResource;
import com.ejie.r01m.objects.resources.R01MLinkedResourcesGroup;
import com.ejie.r01m.objects.resources.R01MResourceInterface;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexDefinition;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableContent;
import com.ejie.r01m.services.R01MCatalogManagerAPI;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.R01MContentDataAPI;
import com.ejie.r01m.services.R01MPublisherAPI;
import com.ejie.r01m.services.bzd.R01MContentModelManagerBzd;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MConstantsReferencerConfig;
import com.ejie.r01m.utils.R01MDateUtils;
import com.ejie.r01m.utils.R01MDozerMappingUtils;
import com.ejie.r01m.utils.R01MPathHelpper;
import com.ejie.r01m.utils.R01MURLHelpper;
import com.ejie.r01m.utils.R01MUtils;
import com.ejie.r01m.utils.R01MVariables;
import com.ejie.r01m.utils.catalog.R01MCatalogUtils;
import com.ejie.r01m.utils.contentmanager.R01MContentModelObjectsValidator;
import com.ejie.r01m.utils.contentmanager.R01MContentObjectsComparator;
import com.ejie.r01m.utils.contentmanager.R01MDocumentResourcesUtils;
import com.ejie.r01m.utils.jms.R01MJMSUtils;
import com.ejie.r01m.utils.jms.R01MJmsQueueParam;
import com.ejie.r01m.utils.link.R01MLinkUtils;
import com.ejie.r01m.utils.url.R01MPortalURL;
import com.ejie.r01p.exceptions.R01PMessagePatternsManagerException;
import com.ejie.r01p.objects.publisher.R01PPublishDefinition;
import com.ejie.r01p.objects.searchengine.indexer.R01PContentToIndexableConverter;
import com.ejie.r01p.services.R01PAliasManagerAPI;
import com.ejie.r01p.services.R01PClientFactory;
import com.ejie.r01p.services.R01PMessagePatternsManagerAPI;
import com.ejie.r01p.utils.R01PConstants;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

public class R01DContentModelManager
implements R01MContentModelManagerBzd {
    private static final String LOG_TYPE_ID = "r01d.manager";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.manager").intValue() != Level.OFF.intValue();
    private static final String TRACE_FORMAT = "dd/MM/yyyy HH:mm:ss.S";
    private static final boolean COPY_DATAFILES_TO_DOCUMENTFOLDER = XMLProperties.getBoolean((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentIndexPrepareOps/copyDataFilesToDocumentFolder", (boolean)true);
    private static final String HISTORY_BASE_PATH = XMLProperties.getProperty((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"history/baseConfig", (String)"interwoven");
    private static final String CONTENT_HEADER_ENTITY_STRUCTUREOID_XPATH = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"contentHeader/entityStructureXpath", (String)"structures/cabeceraContexto/cabeceraContexto/structureOid");
    private static final int CONTENT_MOVE = 0;

    public R01MRoleRights doGetRoleRightsInContent(R01MUserContext userCtx, String contentOid) throws R01MSecurityException, R01MContentModelException {
        R01MContentLocation loc = this.doLoadContentLocation(userCtx, contentOid);
        if (loc == null) {
            throw new R01MContentModelException("NO se ha podido cargar la localizaci\u00f3n en el gestor de contenido del contenido " + contentOid);
        }
        return R01MAuthManager.getRoleRights((R01MBaseLocationObject)loc, (R01MUserContext)userCtx);
    }

    public R01MIndexableContent doGetIndexableContent(R01MUserContext userCtx, String contentOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Cargando la versi\u00f3n indexable del contenido " + contentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01MContent theContent = this.doLoadContent(userCtx, contentOid);
        R01DContentInDataStore contInDS = new R01DContentInDataStore(userCtx, theContent);
        R01MIndexableContent outIdxCont = null;
        try {
            String indexableContentXML = contInDS.downloadIndexableDescriptor();
            if (indexableContentXML == null) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("...en el almacenamiento de contenidos NO existe el fichero XML con la versi\u00f3n indexable del contenido " + contentOid + "... se crea el contenido indexable!");
                }
                outIdxCont = R01MClientFactory.getContentModelAPI((R01MUserContext)userCtx).prepareContentToBeIndexed(contentOid);
            } else {
                outIdxCont = (R01MIndexableContent)XOManager.getObject((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (String)indexableContentXML);
            }
        }
        catch (XOMarshallerException xoEx) {
            xoEx.printStackTrace(System.out);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("...en el almacenamiento de contenidos NO existe el fichero XML con la versi\u00f3n indexable del contenido " + contentOid + "... se crea el contenido indexable!");
            }
            outIdxCont = R01MClientFactory.getContentModelAPI((R01MUserContext)userCtx).prepareContentToBeIndexed(contentOid);
        }
        catch (R01MDataStoreException dsEx) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("...en el almacenamiento de contenidos NO existe el fichero XML con la versi\u00f3n indexable del contenido " + contentOid + "... se crea el contenido indexable!");
            }
            outIdxCont = R01MClientFactory.getContentModelAPI((R01MUserContext)userCtx).prepareContentToBeIndexed(contentOid);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return outIdxCont;
    }

    public Map<String, Long> doSaveContent(R01MUserContext userCtx, R01MContent content) throws R01MDuplicateContentException, R01MDuplicateDocumentException, R01MDuplicateDataFileException, R01MDeleteContentException, R01MDeleteDocumentException, R01MContentModelException, R01MDirtyContentModelException, R01MSecurityException {
        return this.doSaveContentReturningPlanTable(userCtx, content).getContentTS();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public R01MSaveContentResult doSaveContentReturningPlanTable(R01MUserContext userCtx, R01MContent content) throws R01MDuplicateContentException, R01MDuplicateDocumentException, R01MDuplicateDataFileException, R01MDeleteContentException, R01MDeleteDocumentException, R01MContentModelException, R01MDirtyContentModelException, R01MSecurityException {
        if (content == null) {
            throw new R01MContentModelException("Contenido nulo");
        }
        String opDesc = "Salvando el contenido " + content.getOid();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        if (this._validateContent(content)) {
            R01MDocument document;
            HashMap<String, Long> resultLastUpdateTS;
            String contentDescriptorXML;
            ArrayList<Object> documentXMLToCreateOrUpdate;
            boolean catalogChanged;
            boolean updateContentXML;
            JVTComparator modelUpdateOps;
            R01MContent initialContent;
            block61: {
                boolean updateDocumentsXML;
                boolean areDocumentsInContentXML;
                block60: {
                    boolean existContent = this.doCheckContentExistence(content.getOid());
                    areDocumentsInContentXML = false;
                    initialContent = null;
                    modelUpdateOps = null;
                    updateContentXML = false;
                    updateDocumentsXML = true;
                    catalogChanged = false;
                    if (!this._validateCatalogationsContent(content, userCtx)) {
                        throw new R01MContentModelException("Catalogaciones del contenido " + content.getOid() + " no v\u00e1lidas");
                    }
                    if (content != null && content.getDocuments() != null) {
                        for (Map.Entry currentDocumentElement : content.getDocuments().entrySet()) {
                            R01MDocument currentDocument = null;
                            currentDocument = (R01MDocument)currentDocumentElement.getValue();
                            this._reviseDocumentAlias(currentDocument);
                        }
                    }
                    try {
                        if (existContent) {
                            R01DContentModelLoaderHelper loaderHelper;
                            if (DEBUG) {
                                R01FLog.to((String)LOG_TYPE_ID).info("\t... el contenido ya existe es una actualizacion");
                            }
                            boolean bl = areDocumentsInContentXML = (initialContent = (loaderHelper = new R01DContentModelLoaderHelper()).loadContentFromDBXML(content.getOid())) != null && initialContent.getDocuments() != null && !initialContent.getDocuments().isEmpty();
                            if (R01MConstants.VALIDATE_CONTENT_MODEL_TS == 1 && initialContent.getLastUpdateTS() != content.getLastUpdateTS()) {
                                R01FLog.to((String)LOG_TYPE_ID).warning("El contenido '" + content.getInternalName() + "' de identificador '" + content.getOid() + "' que se intenta modificar ha sido modificado.Se debe volver a cargar!!!");
                                throw new R01MDirtyContentModelException(content.getOid(), null, "Lectura sucia del contenido '" + content.getInternalName() + "' de identificador '" + content.getOid() + "'.");
                            }
                        } else {
                            if (DEBUG) {
                                R01FLog.to((String)LOG_TYPE_ID).info("\t... el contenido es NUEVO");
                            }
                            initialContent = null;
                            if (content.getTypo() != null) {
                                try {
                                    R01MContentType contentType = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(content.getTypo().getClusterOid(), content.getTypo().getFamilyOid(), content.getTypo().getTypeOid());
                                    content.setHideEntityHeader(contentType.isHideEntityInContentHeader());
                                    content.setHideTypeHeader(contentType.isHideTypeInContentHeader());
                                }
                                catch (R01MConfigLoadException cfgExc) {
                                    R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener las la configuraci\u00f3n de la cabecera del contenido por defecto de la tipolog\u00eda " + content.getTypo().composeMemoCode() + ".Error:" + cfgExc.getMessage());
                                }
                            }
                        }
                        if ((modelUpdateOps = R01MContentObjectsComparator.compare(initialContent, (Object)content)) == null) break block60;
                        JVTComparator.PlanTableOperation operation = null;
                        Iterator it = modelUpdateOps.getPlanTableIterator();
                        while (it.hasNext()) {
                            operation = (JVTComparator.PlanTableOperation)it.next();
                            if (operation.operation == 6 && operation.args[0] instanceof R01MContent && operation.args[1] instanceof R01MDocument) {
                                R01MDocument doc = (R01MDocument)operation.args[1];
                                if (content.getDocuments() == null || content.getDocuments().isEmpty() || !content.getDocuments().containsKey(doc.getOid()) || !this._isUnpublishDocumentRunning(doc)) continue;
                                content.getDocument(doc.getOid()).setActionPost(new Integer(1));
                                modelUpdateOps.getPlanTable().remove(operation);
                                updateContentXML = false;
                                break;
                            }
                            if (operation.operation != 5 && operation.operation != 6 || !(operation.args[0] instanceof R01MContent) || !(operation.args[1] instanceof R01MStructureCatalog)) continue;
                            catalogChanged = true;
                        }
                        try {
                            if (modelUpdateOps.getPlanTableIterator() != null) {
                                this.doDeleteLinkedRelations(userCtx, modelUpdateOps.getPlanTableIterator());
                            }
                        }
                        catch (Exception e) {
                            R01FLog.to((String)LOG_TYPE_ID).warning("Error al notificar el borrado de los datos de vinculaciones de los documentos a ser borrados.");
                        }
                        R01DModelUpdateValidatorHelper updateValidator = new R01DModelUpdateValidatorHelper(userCtx, content);
                        updateValidator.processOperations(modelUpdateOps.getPlanTable());
                        R01DModelUpdateOperationsLauncher opLauncher = new R01DModelUpdateOperationsLauncher(userCtx);
                        opLauncher.perform(modelUpdateOps);
                    }
                    catch (R01DContentModelPersistenceException cmEx) {
                        cmEx.printStackTrace(System.out);
                        throw new R01MContentModelException("Error al actualizar el modelo del contenido " + content.getOid() + ": " + cmEx.getMessage());
                    }
                    catch (JVTComparatorException jvtEx) {
                        jvtEx.printStackTrace(System.out);
                        throw new R01MContentModelException("Error al comparar los contenidos en su estado inicial y modificado: " + jvtEx.getMessage());
                    }
                }
                documentXMLToCreateOrUpdate = new ArrayList<Object>();
                if (initialContent != null && initialContent.getDocuments() != null && areDocumentsInContentXML) {
                    updateContentXML = true;
                    documentXMLToCreateOrUpdate.addAll(content.getDocuments().keySet());
                }
                if (modelUpdateOps == null || content.getDocuments() != null && !content.getDocuments().isEmpty() && documentXMLToCreateOrUpdate.size() >= content.getDocuments().size()) {
                    if (initialContent != null && initialContent.getDocuments() != null && !initialContent.getDocuments().isEmpty() && (content.getDocuments() == null || content.getDocuments().isEmpty())) {
                        updateContentXML = true;
                    }
                } else {
                    for (JVTComparator.PlanTableOperation operation : modelUpdateOps.getPlanTable()) {
                        Object obj = null;
                        Object objParent = null;
                        if (operation.args.length == 1) {
                            obj = operation.args[0];
                        } else {
                            obj = operation.args[1];
                            objParent = operation.args[0];
                        }
                        if (obj instanceof R01MContent || obj instanceof R01MStructureCatalog || obj instanceof R01MGeoPicks || obj instanceof R01MContentLocation) {
                            updateContentXML = true;
                            continue;
                        }
                        if (obj instanceof R01MDocument && (operation.operation == 1 || operation.operation == 5 || operation.operation == 0 && !initialContent.getDocument(((R01MDocument)obj).getOid()).getName().equals(content.getDocument(((R01MDocument)obj).getOid()).getName()))) {
                            updateContentXML = true;
                            if (documentXMLToCreateOrUpdate.contains(((R01MDocument)obj).getOid())) continue;
                            documentXMLToCreateOrUpdate.add(((R01MDocument)obj).getOid());
                            continue;
                        }
                        if (obj instanceof R01MDocument && (operation.operation == 2 || operation.operation == 6)) {
                            updateContentXML = true;
                            continue;
                        }
                        if (obj instanceof R01MDocument) {
                            if (documentXMLToCreateOrUpdate.contains(((R01MDocument)obj).getOid())) continue;
                            documentXMLToCreateOrUpdate.add(((R01MDocument)obj).getOid());
                            continue;
                        }
                        if (!(objParent instanceof R01MDocument) || documentXMLToCreateOrUpdate.contains(((R01MDocument)objParent).getOid())) continue;
                        documentXMLToCreateOrUpdate.add(((R01MDocument)objParent).getOid());
                    }
                }
                R01DContentModelUpdateHelper updateHelper = new R01DContentModelUpdateHelper(userCtx);
                contentDescriptorXML = null;
                resultLastUpdateTS = new HashMap<String, Long>();
                try {
                    if (updateContentXML) {
                        long updatedContentTS = System.currentTimeMillis();
                        content.setLastUpdateTS(updatedContentTS);
                        if (DEBUG) {
                            String dateTS = DateUtils.getDateFormated((Date)DateUtils.getDateFromMillis((long)updatedContentTS), (String)"dd/MM/yyyy hh:mm:ss:SS");
                            R01FLog.to((String)LOG_TYPE_ID).info("El Timestamp del contenido '" + content.getOid() + "' es " + dateTS);
                        }
                        try {
                            updateHelper.setContentUpdatedTS(content.getOid(), updatedContentTS);
                        }
                        catch (R01DContentModelPersistenceException cmEx) {
                            cmEx.printStackTrace(System.out);
                            throw new R01MContentModelException("Error al actualizar el TimeStamp de actualizaci\u00f3n del contenido.Error:" + cmEx.getMessage());
                        }
                        resultLastUpdateTS.put(content.getOid(), Long.valueOf("" + updatedContentTS));
                        contentDescriptorXML = R01DUtils.obtainXMLFromContentObj((R01MContent)content);
                        try {
                            updateHelper.updateContentDescriptor(content.getOid(), contentDescriptorXML);
                        }
                        catch (R01DContentModelPersistenceException cmEx) {
                            cmEx.printStackTrace(System.out);
                            throw new R01MContentModelException("Error al actualizar el descriptor del contenido.Error:" + cmEx.getMessage());
                        }
                    }
                    resultLastUpdateTS.put(content.getOid(), Long.valueOf("" + content.getLastUpdateTS()));
                    if (content.getDocuments() == null || documentXMLToCreateOrUpdate.isEmpty()) break block61;
                    for (String string : documentXMLToCreateOrUpdate) {
                        document = content.getDocument(string);
                        if (!updateDocumentsXML) continue;
                        long updatedDocumentTS = System.currentTimeMillis();
                        document.setLastUpdateTS(updatedDocumentTS);
                        if (DEBUG) {
                            String dateTS = DateUtils.getDateFormated((Date)DateUtils.getDateFromMillis((long)updatedDocumentTS), (String)"dd/MM/yyyy hh:mm:ss:SS");
                            R01FLog.to((String)LOG_TYPE_ID).info("El Timestamp del documento '" + document.getOid() + "' es " + dateTS);
                        }
                        try {
                            updateHelper.setDocumentUpdatedTS(document.getOid(), updatedDocumentTS);
                        }
                        catch (R01DContentModelPersistenceException cmEx) {
                            cmEx.printStackTrace(System.out);
                            throw new R01MContentModelException("Error al actualizar el TimeStamp de actualizaci\u00f3n del documento.Error:" + cmEx.getMessage());
                        }
                        resultLastUpdateTS.put(document.getOid(), Long.valueOf("" + updatedDocumentTS));
                        try {
                            updateHelper.updateDocumentDescriptor(document.getOid(), R01DUtils.obtainXMLFromDocumentObj((R01MDocument)document));
                        }
                        catch (R01DContentModelPersistenceException cmEx) {
                            cmEx.printStackTrace(System.out);
                            throw new R01MContentModelException("Error al actualizar el descriptor del documento.Error:" + cmEx.getMessage());
                        }
                    }
                }
                catch (XOMarshallerException xoEx) {
                    xoEx.printStackTrace(System.out);
                    throw new R01MContentModelException("Error al transformar el descriptor XML del contenido a objeto: " + xoEx.getMessage());
                }
            }
            if (content != null && content.getDocuments() != null && !content.getDocuments().isEmpty()) {
                for (Map.Entry entry : content.getDocuments().entrySet()) {
                    document = (R01MDocument)entry.getValue();
                    R01MDocument initialDocument = initialContent == null ? null : initialContent.getDocument((String)entry.getKey());
                    this._updateDocumentFriendlyUrl(userCtx, initialDocument, document);
                }
            }
            try {
                R01MContent mergedContent = this._mergeContentObjects(userCtx, initialContent, content);
                R01DContentModelInDataStoreHelper r01DContentModelInDataStoreHelper = new R01DContentModelInDataStoreHelper(userCtx, mergedContent);
                if (modelUpdateOps != null) {
                    r01DContentModelInDataStoreHelper.processOperations(modelUpdateOps.getPlanTable());
                }
                if (updateContentXML && !StringUtils.isEmptyString((String)contentDescriptorXML)) {
                    r01DContentModelInDataStoreHelper.updateContentDescriptor(contentDescriptorXML);
                }
                if (content.getDocuments() != null && !content.getDocuments().isEmpty()) {
                    Iterator itDocumentOids = documentXMLToCreateOrUpdate.iterator();
                    while (itDocumentOids.hasNext()) {
                        r01DContentModelInDataStoreHelper.updateDocumentDescriptor(content.getDocument((String)itDocumentOids.next()));
                    }
                }
            }
            catch (R01MDataStoreException dstExc) {
                dstExc.printStackTrace(System.out);
                throw new R01MContentModelException("Error al acceder al dataStore para el contenido " + content.getOid() + ": " + dstExc.getMessage());
            }
            if (catalogChanged && content != null && content.getDocuments() != null && !content.getDocuments().isEmpty()) {
                for (R01MDocument r01MDocument : content.getDocuments().values()) {
                    this._createcontentHeader(userCtx, content, r01MDocument);
                }
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            if (modelUpdateOps != null) {
                return new R01MSaveContentResult(modelUpdateOps.getPlanTableIterator(), resultLastUpdateTS);
            }
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : Content not valid - " + opDesc);
        }
        throw new R01MContentModelException("Contenido no v\u00e1lido");
    }

    public Long doSaveDocument(R01MUserContext userCtx, String contentOid, R01MDocument document) throws R01MSecurityException, R01MDuplicateContentException, R01MDuplicateDocumentException, R01MDuplicateDataFileException, R01MDeleteContentException, R01MDeleteDocumentException, R01MDeleteDataFileException, R01MContentModelException, R01MDirtyContentModelException {
        R01MSaveContentResult result = this.doSaveDocumentReturningPlanTable(userCtx, contentOid, document);
        if (result != null && result.getContentTS().containsKey(document.getOid())) {
            return (Long)result.getContentTS().get(document.getOid());
        }
        return Long.valueOf("0");
    }

    public R01MSaveContentResult doSaveDocumentReturningPlanTable(R01MUserContext userCtx, String contentOid, R01MDocument document) throws R01MDuplicateContentException, R01MDuplicateDocumentException, R01MDuplicateDataFileException, R01MDeleteContentException, R01MDeleteDocumentException, R01MContentModelException, R01MDirtyContentModelException, R01MSecurityException {
        HashMap<String, Long> resultLastUpdateTS;
        JVTComparator modelUpdateOps;
        String opDesc;
        block32: {
            opDesc = "Salvado del documento " + document.getOid();
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            if (!this.doCheckDocumentExistence(document.getOid())) {
                return null;
            }
            modelUpdateOps = null;
            resultLastUpdateTS = new HashMap<String, Long>();
            try {
                R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
                if (!loaderHelper.hasDocumentXMLInformation(document.getOid())) {
                    R01MContent content = this.doLoadContent(userCtx, contentOid);
                    content.getDocuments().put(document.getOid(), document);
                    try {
                        this.doSaveContent(userCtx, content);
                    }
                    catch (R01MDirtyContentModelException ex) {
                        ex.printStackTrace();
                    }
                    break block32;
                }
                R01MDocument initialDocument = null;
                try {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("\t... el documento ya existe es una actualizacion");
                    }
                    initialDocument = loaderHelper.loadDocumentFromDBXML(document.getOid());
                    if (R01MConstants.VALIDATE_CONTENT_MODEL_TS == 1 && initialDocument != null && initialDocument.getLastUpdateTS() != document.getLastUpdateTS()) {
                        R01FLog.to((String)LOG_TYPE_ID).warning("El documento '" + document.getInternalName() + "' de " + "identificador '" + document.getOid() + "' que se intenta modificar " + "ha sido modificado previamente.Se debe volver a cargar!!!\n " + "Valor del timestamp del documento inicial: " + initialDocument.getLastUpdateTS() + "\n" + "Valor del timestamp del documento pasado: " + document.getLastUpdateTS());
                        throw new R01MDirtyContentModelException(null, document.getOid(), "Lectura sucia del documento '" + document.getInternalName() + "' de " + "identificador '" + document.getOid() + "'.\n " + "Valor del timestamp del documento inicial: " + initialDocument.getLastUpdateTS() + "\n" + "Valor del timestamp del documento pasado: " + document.getLastUpdateTS());
                    }
                    modelUpdateOps = R01MContentObjectsComparator.compare((Object)initialDocument, (Object)document);
                    if (modelUpdateOps != null) {
                        Iterator opsIt = modelUpdateOps.getPlanTableIterator();
                        while (opsIt.hasNext()) {
                            JVTComparator.PlanTableOperation operation = (JVTComparator.PlanTableOperation)opsIt.next();
                            Object obj = operation.args[0];
                            if (obj != null) continue;
                            R01MContent content = new R01MContent();
                            content.setOid(contentOid);
                            operation.args[0] = content;
                        }
                    }
                    R01DModelUpdateValidatorHelper updateValidator = new R01DModelUpdateValidatorHelper(userCtx, document);
                    if (modelUpdateOps != null) {
                        updateValidator.processOperations(modelUpdateOps.getPlanTable());
                    }
                    R01DModelUpdateOperationsLauncher opLauncher = new R01DModelUpdateOperationsLauncher(userCtx);
                    opLauncher.perform(modelUpdateOps);
                    this._updateDocumentFriendlyUrl(userCtx, initialDocument, document);
                }
                catch (R01DContentModelPersistenceException cmEx) {
                    cmEx.printStackTrace(System.out);
                    throw new R01MContentModelException("Error al actualizar el modelo del documento " + document.getOid() + ": " + cmEx.getMessage());
                }
                catch (JVTComparatorException jvtEx) {
                    jvtEx.printStackTrace(System.out);
                    throw new R01MContentModelException("Error al comparar los documentos en su estado inicial y modificado: " + jvtEx.getMessage());
                }
                R01DContentModelUpdateHelper updateHelper = new R01DContentModelUpdateHelper(userCtx);
                long updatedDocumentTS = System.currentTimeMillis();
                document.setLastUpdateTS(updatedDocumentTS);
                resultLastUpdateTS.put(document.getOid(), Long.valueOf("" + updatedDocumentTS));
                if (DEBUG) {
                    String dateTS = DateUtils.getDateFormated((Date)DateUtils.getDateFromMillis((long)updatedDocumentTS), (String)"dd/MM/yyyy hh:mm:ss:SS");
                    R01FLog.to((String)LOG_TYPE_ID).info("El Timestamp del documento '" + document.getOid() + "' es " + dateTS);
                }
                try {
                    updateHelper.setDocumentUpdatedTS(document.getOid(), updatedDocumentTS);
                }
                catch (R01DContentModelPersistenceException cmEx) {
                    cmEx.printStackTrace(System.out);
                    throw new R01MContentModelException("Error al actualizar el TimeStamp de actualizaci\u00f3n del documento.Error:" + cmEx.getMessage());
                }
                try {
                    updateHelper.updateDocumentDescriptor(document.getOid(), R01DUtils.obtainXMLFromDocumentObj((R01MDocument)document));
                }
                catch (XOMarshallerException xoEx) {
                    xoEx.printStackTrace(System.out);
                    throw new R01MContentModelException("Error al transformar el descriptor XML del documento " + document.getOid() + " a objeto: " + xoEx.getMessage());
                }
                catch (R01DContentModelPersistenceException cmEx) {
                    cmEx.printStackTrace(System.out);
                    throw new R01MContentModelException(cmEx.getMessage());
                }
                R01MContent theContent = this.doLoadContent(userCtx, contentOid);
                if (initialDocument != null) {
                    theContent.getDocuments().put(initialDocument.getOid(), this._mergeDocumentObjects(userCtx, initialDocument, document));
                }
                R01DContentModelInDataStoreHelper dataStoreHelper = new R01DContentModelInDataStoreHelper(userCtx, theContent);
                try {
                    if (modelUpdateOps != null) {
                        dataStoreHelper.processOperations(modelUpdateOps.getPlanTable());
                    }
                    dataStoreHelper.updateDocumentDescriptor(document);
                }
                catch (R01MDataStoreException dstExc) {
                    throw new R01MContentModelException("Error al acceder al dataStore para el documento " + document.getOid() + ": " + dstExc.getMessage());
                }
                if (initialDocument == null || document.getName().equals(initialDocument.getName())) break block32;
                String contentDescriptorXML = null;
                try {
                    theContent.getDocument(document.getOid()).setName(document.getName());
                    contentDescriptorXML = R01DUtils.obtainXMLFromContentObj((R01MContent)theContent);
                    updateHelper.updateContentDescriptor(contentOid, contentDescriptorXML);
                }
                catch (XOMarshallerException xoEx) {
                    xoEx.printStackTrace(System.out);
                    throw new R01MContentModelException("Error al transformar el descriptor XML del contenido a objeto: " + xoEx.getMessage());
                }
                catch (R01DContentModelPersistenceException cmEx) {
                    cmEx.printStackTrace(System.out);
                    throw new R01MContentModelException("Error al actualizar el XML del contenido del documento " + document.getOid() + ": " + cmEx.getMessage());
                }
                try {
                    dataStoreHelper.updateContentDescriptor(contentDescriptorXML);
                }
                catch (R01MDataStoreException dstExc) {
                    throw new R01MContentModelException("Error al acceder al dataStore para actualizar el XML del contenido del documento " + document.getOid() + ": " + dstExc.getMessage());
                }
            }
            catch (R01DContentModelPersistenceException ex) {
                ex.printStackTrace(System.out);
                throw new R01MContentModelException("Error al comprobar si el documento tiene descriptor de XML. Documento: " + document.getOid() + ": " + ex.getMessage());
            }
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : Content not valid - " + opDesc);
        }
        if (modelUpdateOps != null) {
            return new R01MSaveContentResult(modelUpdateOps.getPlanTableIterator(), resultLastUpdateTS);
        }
        return null;
    }

    public void doDeleteLinkedRelations(R01MUserContext userCtx, Iterator<JVTComparator.PlanTableOperation> itPlanTable) {
        HashSet<String> documentsToRemove = new HashSet<String>();
        while (itPlanTable.hasNext()) {
            JVTComparator.PlanTableOperation operation = itPlanTable.next();
            Object obj = null;
            obj = operation.args.length == 1 ? operation.args[0] : operation.args[1];
            if (!(obj instanceof R01MDocument) || operation.operation != 2 && operation.operation != 6) continue;
            documentsToRemove.add(((R01MDocument)obj).getOid());
        }
        if (!documentsToRemove.isEmpty()) {
            this._doRemoveLinkedRelations(userCtx, documentsToRemove);
        }
    }

    public void doIndexContent(R01MContent content, Iterator<JVTComparator.PlanTableOperation> itPlanTable) {
        ArrayList<String> documentsUpdated = new ArrayList<String>();
        ArrayList<String> documentsDeleted = new ArrayList<String>();
        String documentOid = "";
        boolean executeFullContentIndex = true;
        if (content != null && content.getDocuments() != null) {
            for (R01MDocument document : content.getDocuments().values()) {
                if (!document.isPublishedInAnyRepository()) continue;
                executeFullContentIndex = false;
                break;
            }
        }
        if (!executeFullContentIndex) {
            while (itPlanTable.hasNext()) {
                JVTComparator.PlanTableOperation operation = itPlanTable.next();
                Object obj = null;
                Object objParent = null;
                if (operation.args.length == 1) {
                    obj = operation.args[0];
                } else {
                    obj = operation.args[1];
                    objParent = operation.args[0];
                }
                if (obj instanceof R01MContent && (operation.operation == 1 || operation.operation == 5 || operation.operation == 2 || operation.operation == 6)) {
                    executeFullContentIndex = true;
                    continue;
                }
                if (obj instanceof R01MDocument && (operation.operation == 1 || operation.operation == 5)) {
                    documentOid = ((R01MDocument)obj).getOid();
                    if (documentsUpdated.contains(documentOid)) continue;
                    documentsUpdated.add(documentOid);
                    continue;
                }
                if (obj instanceof R01MDocument && (operation.operation == 2 || operation.operation == 6)) {
                    documentOid = ((R01MDocument)obj).getOid();
                    documentsDeleted.add(documentOid);
                    continue;
                }
                if (obj instanceof R01MDocument && !((R01MDocument)obj).isPublishedInAnyRepository()) {
                    documentOid = ((R01MDocument)obj).getOid();
                    documentsDeleted.add(documentOid);
                    continue;
                }
                if (!(obj instanceof R01MDataFile) || operation.operation != 1 && operation.operation != 5 || documentsUpdated.contains(documentOid = ((R01MDocument)objParent).getOid())) continue;
                documentsUpdated.add(documentOid);
            }
        }
        List indexers = new ArrayList();
        indexers = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/default/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer"));
        System.out.println("#### Enviar petici\u00f3n de indexaci\u00f3n de indexersConfigurations/default/indexer ####");
        if (content != null && (executeFullContentIndex || content.getDocuments() != null && content.getDocuments().size() == documentsUpdated.size())) {
            R01MIndexDefinition indexDefinition = new R01MIndexDefinition(0, content.getOid(), 0, null, indexers, false, -1, null, null, null);
            R01DIndexerHelper.doIndexObject(indexDefinition);
        } else {
            R01MIndexDefinition indexDefinition;
            for (String oid : documentsUpdated) {
                indexDefinition = new R01MIndexDefinition(0, oid, 1, null, indexers, false, -1, null, null, null);
                R01DIndexerHelper.doIndexObject(indexDefinition);
            }
            for (String oid : documentsDeleted) {
                indexDefinition = new R01MIndexDefinition(1, oid, 1, null, null, false, -1, null, null, null);
                R01DIndexerHelper.doUnIndexObject(indexDefinition);
            }
        }
    }

    public void doIndexDocument(String documentOid, Iterator<JVTComparator.PlanTableOperation> itPlanTable) {
        boolean requestIndex = false;
        try {
            R01MDocument document = this.doLoadDocument(R01MAuthManager.createMasterSystemUserContext(), documentOid);
            if (!document.isPublishedInAnyRepository()) {
                requestIndex = true;
            }
        }
        catch (R01MContentModelException cmEx) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tERROR al cargar el documento " + documentOid + " para lanzar su indexaci\u00f3n. Error: " + cmEx.getMessage());
        }
        catch (R01MSecurityException secEx) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tERROR al cargar el documento " + documentOid + " para lanzar su indexaci\u00f3n. Error: " + secEx.getMessage());
        }
        if (!requestIndex) {
            while (itPlanTable.hasNext()) {
                JVTComparator.PlanTableOperation operation = itPlanTable.next();
                Object obj = operation.args.length == 1 ? operation.args[0] : operation.args[1];
                if (!(obj instanceof R01MDataFile) || operation.operation != 1 && operation.operation != 5 && operation.operation != 2 && operation.operation != 6) continue;
                requestIndex = true;
                break;
            }
        }
        if (requestIndex) {
            List indexers = new ArrayList();
            indexers = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/default/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer"));
            System.out.println("#### Enviar petici\u00f3n de indexaci\u00f3n de indexersConfigurations/default/indexer ####");
            R01MIndexDefinition indexDefinition = new R01MIndexDefinition(0, documentOid, 1, null, indexers, false, -1, null, null, null);
            R01DIndexerHelper.doIndexObject(indexDefinition);
        }
    }

    public void doInsertHistoryRecord(R01MUserContext userCtx, R01MContentHistory historyReg, int type) throws R01MContentModelObjectsValidatorException, R01MContentModelException {
        R01DHistoryHelper historyHelper = new R01DHistoryHelper();
        if (type == 0) {
            historyReg.validateObject();
            historyHelper.doInsertHistoryInBD(historyReg);
        } else {
            historyHelper.doInsertHistoryInFile();
        }
    }

    public void doChangeContentCluster(R01MUserContext userCtx, String contentOid, String clusterOid) throws R01MContentModelException, R01MSecurityException {
        R01MContent content;
        String opDesc = "Cambiando el cluster del contenido " + contentOid + " al oid " + clusterOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        if ((content = this.doLoadContent(userCtx, contentOid)) == null) {
            throw new R01MContentModelException("NO se ha podido cargar el contenido " + contentOid);
        }
        content.getTypo().setClusterOid(clusterOid);
        try {
            this.doSaveContent(userCtx, content);
        }
        catch (R01MDeleteModelObjectException delEx) {
        }
        catch (R01MDuplicateModelObjectException dupEx) {
        }
        catch (R01MDirtyContentModelException ex) {
            // empty catch block
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public void doChangeContentLocation(R01MUserContext userCtx, String contentOid, R01MContentLocation targetLoc) throws R01MContentModelException, R01MSecurityException {
        R01MContent content;
        String opDesc = "Moviendo el contenido de oid " + contentOid + " a la localizaci\u00f3n " + targetLoc.getServerOid() + "/" + targetLoc.getDataRepositoryOid() + "/" + targetLoc.getAreaOid() + "/" + targetLoc.getWorkAreaOid();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        if ((content = this.doLoadContent(userCtx, contentOid)) == null) {
            throw new R01MContentModelException("NO se ha podido cargar el contenido " + contentOid);
        }
        R01MContentLocation srcLoc = content.getStoreLocation();
        content.setStoreLocation(targetLoc);
        Map documents = content.getDocuments();
        if (documents != null) {
            for (Map.Entry meDoc : documents.entrySet()) {
                R01MDocument document = (R01MDocument)meDoc.getValue();
                Map dataFiles = document.getDataFiles();
                if (dataFiles == null) continue;
                for (Map.Entry meDataFile : dataFiles.entrySet()) {
                    R01MDataFile datafile = (R01MDataFile)meDataFile.getValue();
                    try {
                        datafile.setEditUrl(null);
                        datafile.setGenerateUrl(null);
                        datafile.setPreviewUrl(null);
                        R01MContentModelObjectsValidator.validateDataFile((R01MContent)content, (String)document.getOid(), (String)datafile.getOid());
                    }
                    catch (R01MContentModelObjectsValidatorException validEx) {
                        throw new R01MContentModelException("Error al actualizar las URLs del archivo de datos de oid " + datafile.getOid() + ": " + validEx.getMessage());
                    }
                }
            }
        }
        try {
            this.doSaveContent(userCtx, content);
        }
        catch (R01MDeleteModelObjectException delEx) {
        }
        catch (R01MDuplicateModelObjectException dupEx) {
        }
        catch (R01MDirtyContentModelException ex) {
            // empty catch block
        }
        try {
            content.setStoreLocation(srcLoc);
            R01DContentInDataStore contentDataStore = new R01DContentInDataStore(userCtx, content);
            contentDataStore.moveContent(targetLoc);
        }
        catch (R01MDataStoreException dsEx) {
            dsEx.printStackTrace();
            throw new R01MContentModelException("Error al mover el contenido " + content.getOid() + " a la workarea " + targetLoc.composeMemoCode());
        }
        content.setStoreLocation(targetLoc);
        this._sendHistoryMessage(userCtx.getUserName(), content, null, null, 0, 19, "Contenido " + content.getName() + " movido a : " + targetLoc.getAreaOid() + "/" + targetLoc.getWorkAreaOid());
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public String doCopyContent(R01MUserContext userCtx, String contentOid, R01MContentLocation targetLoc, String newContentName) throws R01MDuplicateContentException, R01MContentModelException, R01MSecurityException {
        String opDesc = "Copiando el contenido de oid " + contentOid + " a la localizaci\u00f3n " + targetLoc.getServerOid() + "/" + targetLoc.getDataRepositoryOid() + "/" + targetLoc.getAreaOid() + "/" + targetLoc.getWorkAreaOid() + " con el nuevo nombre " + newContentName;
        try {
            R01MContent content;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            if ((content = this.doLoadContent(userCtx, contentOid)) == null) {
                throw new R01MContentModelException("NO se ha podido cargar el contenido " + contentOid);
            }
            R01DContentModelObjectsCopyHelper contCopyHelper = new R01DContentModelObjectsCopyHelper(this);
            R01MContent copyOfContent = null;
            try {
                copyOfContent = contCopyHelper.copyContent(userCtx, content, targetLoc, newContentName, true);
                if (!content.getStoreLocation().getWorkAreaOid().equalsIgnoreCase(targetLoc.getWorkAreaOid())) {
                    R01MDataStoreManager dsManager = this._obtainDataStoreManager(userCtx);
                    String folderWARelativePath = copyOfContent.getTypo().getTypeOid() + "/" + content.getName();
                    if (dsManager.doCheckFolder((R01MBaseLocationObject)copyOfContent.getStoreLocation(), folderWARelativePath)) {
                        dsManager.doDeleteFolder((R01MBaseLocationObject)copyOfContent.getStoreLocation(), folderWARelativePath, false);
                    }
                }
            }
            catch (R01MDuplicateModelObjectException dupObjEx) {
                if (dupObjEx instanceof R01MDuplicateContentException) {
                    throw (R01MDuplicateContentException)dupObjEx;
                }
            }
            catch (R01MDeleteModelObjectException delObjEx) {
            }
            catch (R01MDirtyContentModelException ex) {
            }
            catch (R01MDataStoreAuthenticationException authEx) {
                // empty catch block
            }
            this._sendHistoryMessage(userCtx.getUserName(), content, null, null, 0, 19, "Contenido " + newContentName + " copiado correctamente.");
            List indexers = new ArrayList();
            indexers = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/default/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer"));
            if (copyOfContent != null) {
                indexers = new ArrayList();
                indexers = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/default/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer"));
                System.out.println("#### Enviar petici\u00f3n de indexaci\u00f3n de indexersConfigurations/default/indexer ####");
                R01MIndexDefinition indexDefinition = new R01MIndexDefinition(0, copyOfContent.getOid(), 0, null, indexers, false, -1, null, null, null);
                R01DIndexerHelper.doIndexObject(indexDefinition);
                return copyOfContent.getOid();
            }
            return null;
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException((Exception)((Object)dsEx));
        }
    }

    public String doMoveContentToAnotherArea(R01MUserContext userCtx, String contentOid, String newAreaOid, String newWorkAreaOid, boolean publishDocuments, int actionType, String contentNameTarget, String newDataRepositoryOid, String newServerOid) throws R01MSecurityException, R01MContentModelException {
        return null;
    }

    public Object[] doMoveContentToAnotherAreaTX(R01MUserContext userCtx, String contentOid, String newAreaOid, String newWorkAreaOid, boolean publishDocuments, int actionType, String contentNameTarget, String newDataRepositoryOid, String newServerOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Moviendo el contenido de oid " + contentOid + " al area " + newAreaOid + " y workarea " + newWorkAreaOid;
        Object[] objectToReturn = new Object[2];
        try {
            R01MContent content;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            if ((content = this.doLoadContent(userCtx, contentOid)) == null) {
                throw new R01MContentModelException("NO se ha podido cargar el contenido " + contentOid);
            }
            try {
                R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(content.getStoreLocation().getServerOid(), newDataRepositoryOid, newAreaOid, newWorkAreaOid);
            }
            catch (R01MConfigLoadException cfgExc) {
                throw new R01MContentModelException("El store destino :" + content.getStoreLocation().getServerOid() + " - " + content.getStoreLocation().getDataRepositoryOid() + " - " + newAreaOid + " - " + newWorkAreaOid + " no EXISTE.");
            }
            R01DContentModelObjectsCopyHelper contCopyHelper = new R01DContentModelObjectsCopyHelper(this);
            objectToReturn = contCopyHelper.moveContentToAnotherArea(userCtx, contentOid, newAreaOid, newWorkAreaOid, publishDocuments, actionType, contentNameTarget, newDataRepositoryOid, newServerOid);
            R01MContentLocation targetLoc = null;
            targetLoc = actionType == 0 ? new R01MContentLocation(content.getStoreLocation().getServerOid(), content.getStoreLocation().getDataRepositoryOid(), content.getStoreLocation().getAreaOid(), content.getStoreLocation().getWorkAreaOid()) : new R01MContentLocation(newServerOid, newDataRepositoryOid, newAreaOid, newWorkAreaOid);
            try {
                targetLoc.validateObject();
                R01MDataStoreManager dsManager = this._obtainDataStoreManager(userCtx);
                String folderWARelativePath = content.getTypo().getTypeOid() + "/" + content.getName();
                if (dsManager.doCheckFolder((R01MBaseLocationObject)targetLoc, folderWARelativePath)) {
                    dsManager.doDeleteFolder((R01MBaseLocationObject)targetLoc, folderWARelativePath, true);
                }
            }
            catch (R01MContentModelObjectsValidatorException valExc) {
            }
            catch (R01MDataStoreAuthenticationException authEx) {
                // empty catch block
            }
            this._sendHistoryMessage(userCtx.getUserName(), content, null, null, 0, 19, "Contenido " + content.getName() + " movido a : " + newAreaOid + "/" + newWorkAreaOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return objectToReturn;
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException((Exception)((Object)dsEx));
        }
    }

    public void doDeleteContent(R01MUserContext userCtx, String contentOid) throws R01MDeleteContentException, R01MContentModelException {
        R01MContent content = null;
        try {
            content = this.doLoadContent(userCtx, contentOid);
        }
        catch (R01MContentModelException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException("NO se ha podido cargar el contenido " + contentOid + ": " + cmEx.getMessage());
        }
        this.doDeleteContent(userCtx, content);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doDeleteContent(R01MUserContext userCtx, R01MContent content) throws R01MDeleteContentException, R01MContentModelException {
        String opDesc = "Borrar el contenido " + content.getOid();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        if (!this._isUnpublishDocumentRunning(content)) {
            JVTComparator modelUpdateOps = null;
            try {
                modelUpdateOps = R01MContentObjectsComparator.compare((Object)content, null);
                R01DModelUpdateValidatorHelper updateValidator = new R01DModelUpdateValidatorHelper(userCtx, content);
                updateValidator.processOperations(modelUpdateOps.getPlanTable());
            }
            catch (JVTComparatorException compEx) {
                compEx.printStackTrace(System.out);
                throw new R01MDeleteContentException(compEx.getMessage());
            }
            catch (R01MDuplicateModelObjectException dupObjEx) {
            }
            catch (R01MDeleteDocumentException delDocEx) {
            }
            catch (R01MContentModelException cmEx) {
                throw new R01MDeleteContentException((Exception)((Object)cmEx));
            }
            try {
                R01DModelUpdateOperationsLauncher opLauncher = new R01DModelUpdateOperationsLauncher(userCtx);
                opLauncher.perform(modelUpdateOps);
                this._doRemoveLinkedRelations(userCtx, content.getDocuments() == null ? null : content.getDocuments().keySet());
                R01DContentInDataStore contentDataStore = new R01DContentInDataStore(userCtx, content);
                try {
                    contentDataStore.delete();
                }
                catch (R01MDataStoreException dstExc) {
                    throw new R01MContentModelException("Error al borrar la estructura del contenido de oid " + content.getOid() + ": " + dstExc.getMessage());
                }
                if (!DEBUG) return;
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
                return;
            }
            catch (R01DContentModelPersistenceException cmEx) {
                cmEx.printStackTrace(System.out);
                throw new R01MContentModelException(cmEx.getMessage());
            }
        }
        content.setActionPost(Integer.valueOf(1));
        for (R01MDocument document : content.getDocuments().values()) {
            content.getDocument(document.getOid()).setActionPost(Integer.valueOf(1));
        }
        try {
            this.doSaveContent(userCtx, content);
            return;
        }
        catch (Exception ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al salvar antes de borrar el contenido de oid " + content.getOid() + ".Error: " + ex.getMessage());
            ex.printStackTrace(System.out);
            throw new R01MContentModelException("Error al salvar antes de borrar el contenido de oid " + content.getOid() + ".Error: " + ex.getMessage());
        }
    }

    public void doForceDeleteContent(R01MUserContext userCtx, String contentOid) throws R01MContentModelException {
        String opDesc = "Forzar el borrado del contenido " + contentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01MContent content = null;
        try {
            content = R01MClientFactory.getContentModelAPI((R01MUserContext)userCtx).loadContentLazy(contentOid);
        }
        catch (R01MSecurityException secExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar el contenido de identificador '" + contentOid + "'.Error:" + secExc.getMessage());
            throw new R01MContentModelException("Error al cargar el contenido de identificador '" + contentOid + "'.", (Exception)((Object)secExc));
        }
        R01MPublicationConfig pubConfig = null;
        try {
            pubConfig = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(content.getStoreLocation().getServerOid(), content.getStoreLocation().getDataRepositoryOid(), content.getStoreLocation().getAreaOid(), content.getStoreLocation().getWorkAreaOid()).getAllowedPublicationTargetsConfig();
        }
        catch (R01MConfigLoadException cfgExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar la configuraci\u00f3n de publicaciones del contenido de identificador '" + contentOid + "'.Error:" + cfgExc.getMessage());
            throw new R01MContentModelException("Error al cargar la configuraci\u00f3n de publicaciones del contenido de identificador '" + contentOid + "'.", (Exception)((Object)cfgExc));
        }
        ArrayList<R01MPublishActionObject> stepsActions = new ArrayList<R01MPublishActionObject>();
        R01MPublishActionObject postPublishAction = new R01MPublishActionObject();
        postPublishAction.setStep(3);
        postPublishAction.setObjectOid(contentOid);
        postPublishAction.setActionClass("com.ejie.r01p.publisher.R01PContentModelPublisherActions");
        postPublishAction.setMethod("deleteContent");
        postPublishAction.setParam("");
        stepsActions.add(postPublishAction);
        Map allowedTargets = pubConfig.getAllowedTargets();
        if (allowedTargets != null && !allowedTargets.isEmpty()) {
            for (R01MAllowedPublicationTarget repo : allowedTargets.values()) {
                R01PPublishDefinition pubDefinition = null;
                try {
                    pubDefinition = new R01PPublishDefinition(userCtx.getUserName(), contentOid, 0, R01MUtils.generateNewOid((String)R01MConstants.PUBLISHER_APPCODE), null, null, repo.getTargetOid(), 2, null, stepsActions, false, null, null);
                    R01PClientFactory.getPublisherAPI().publish(pubDefinition);
                }
                catch (R01MPublisherException ex) {
                    throw new R01MContentModelException("Error al despublicar el contenido" + contentOid + ". ERROR:  " + ex.getMessage());
                }
                catch (GUIDDispenserException ex1) {
                    ex1.printStackTrace(System.out);
                    throw new R01MContentModelException("Error al obtener el oid de publicacion. Error:" + ex1.getMessage());
                }
            }
        }
    }

    public void doForceDeleteDocuments(R01MUserContext userCtx, String contentOid, List<String> documentOids, boolean deleteLinked, boolean forceLinkedUnpublish, boolean deleteEmptyContents) throws R01MContentModelException {
        R01MContent content = null;
        try {
            content = this.doLoadContent(userCtx, contentOid);
        }
        catch (R01MContentModelException secExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar el contenido de identificador '" + contentOid + "'.Error:" + secExc.getMessage());
            throw new R01MContentModelException("Error al cargar el contenido de identificador '" + contentOid + "'.", (Exception)((Object)secExc));
        }
        R01MPublicationConfig pubConfig = null;
        try {
            pubConfig = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(content.getStoreLocation().getServerOid(), content.getStoreLocation().getDataRepositoryOid(), content.getStoreLocation().getAreaOid(), content.getStoreLocation().getWorkAreaOid()).getAllowedPublicationTargetsConfig();
        }
        catch (R01MConfigLoadException cfgExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar la configuraci\u00f3n de publicaciones del contenido de identificador '" + contentOid + "'.Error:" + cfgExc.getMessage());
            throw new R01MContentModelException("Error al cargar la configuraci\u00f3n de publicaciones del contenido de identificador '" + contentOid + "'.", (Exception)((Object)cfgExc));
        }
        if (documentOids != null && !documentOids.isEmpty()) {
            for (String documentOid : documentOids) {
                String opDesc = "Forzar el borrado del documento " + documentOid;
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
                }
                if (!this.doCheckContentDocumentRelation(contentOid, documentOid)) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("La relacion contenido <-> documento de identificador '" + contentOid + " <-> " + documentOid + "' NO EXISTE, Luego no se procede al borrado");
                }
                ArrayList<R01MPublishActionObject> stepsActions = new ArrayList<R01MPublishActionObject>();
                R01MPublishActionObject postPublishAction = new R01MPublishActionObject();
                postPublishAction.setStep(3);
                postPublishAction.setObjectOid(contentOid + "," + documentOid);
                postPublishAction.setActionClass("com.ejie.r01p.publisher.R01PContentModelPublisherActions");
                postPublishAction.setMethod("deleteDocument");
                postPublishAction.setParam(String.valueOf(deleteLinked) + "," + String.valueOf(forceLinkedUnpublish) + "," + String.valueOf(deleteEmptyContents));
                stepsActions.add(postPublishAction);
                Map allowedTargets = pubConfig.getAllowedTargets();
                if (allowedTargets == null || allowedTargets.isEmpty()) continue;
                for (Map.Entry me : allowedTargets.entrySet()) {
                    R01MAllowedPublicationTarget repo = (R01MAllowedPublicationTarget)me.getValue();
                    R01PPublishDefinition pubDefinition = null;
                    try {
                        pubDefinition = new R01PPublishDefinition(userCtx.getUserName(), documentOid, 1, R01MUtils.generateNewOid((String)R01MConstants.PUBLISHER_APPCODE), null, null, repo.getTargetOid(), 2, null, stepsActions, true, null, null);
                        R01PClientFactory.getPublisherAPI().publish(pubDefinition);
                    }
                    catch (R01MPublisherException ex) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("Error al despublicar el documento " + documentOid + ". ERROR:  " + ex.getMessage());
                    }
                    catch (GUIDDispenserException ex1) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener el oid de publicacion");
                    }
                }
            }
        }
    }

    public void doDeleteDocuments(R01MUserContext userCtx, Map<String, List<String>> documentsContentOids, boolean deleteLinked, boolean forceUnpublish, boolean forceLinkedUnpublish, boolean deleteEmptyContents) throws R01MSecurityException {
        for (Map.Entry<String, List<String>> me : documentsContentOids.entrySet()) {
            String contentOid = me.getKey();
            R01MContent content = null;
            try {
                R01FLog.to((String)LOG_TYPE_ID).info("Obtenemos el contenido " + contentOid);
                content = this.doLoadContent(userCtx, contentOid);
            }
            catch (R01MContentModelException ex) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener el contentido " + contentOid + " No se trata el borrado de los documentos indicados. ERROR:  " + ex.getMessage());
                continue;
            }
            if (content == null) continue;
            List<String> documentOids = me.getValue();
            for (String documentOid : documentOids) {
                R01MLinkedResourcesGroup lnkResGroup;
                block31: {
                    try {
                        R01FLog.to((String)LOG_TYPE_ID).info("chekea la relacion contenido <-> documento de identificador '" + contentOid + " <-> " + documentOid + "'");
                        if (!this.doCheckContentDocumentRelation(contentOid, documentOid)) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("La relacion contenido <-> documento de identificador '" + contentOid + " <-> " + documentOid + "' NO EXISTE, Luego no se procede al borrado");
                        }
                        break block31;
                    }
                    catch (R01MContentModelException ex1) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("Error al comprobar la relaci\u00f3n del contentido " + contentOid + " con el documento " + documentOid + " No se trata el borrado de los documentos indicados. ERROR:  " + ex1.getMessage());
                    }
                    continue;
                }
                R01MDocument document = null;
                try {
                    R01FLog.to((String)LOG_TYPE_ID).info("Cargamos el documento " + documentOid);
                    document = this.doLoadDocument(userCtx, documentOid);
                }
                catch (R01MContentModelException ex) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener el documento " + documentOid + " No se puede borrar. ERROR:  " + ex.getMessage());
                    continue;
                }
                if (document == null) continue;
                if (document.isPublishedInAnyRepository()) {
                    R01FLog.to((String)LOG_TYPE_ID).info("El documento " + documentOid + " est\u00e1 publicado.");
                    if (forceUnpublish) {
                        R01FLog.to((String)LOG_TYPE_ID).info("Se fuerza la despublicaci\u00f3n");
                        ArrayList<String> documentToPublish = new ArrayList<String>();
                        documentToPublish.add(documentOid);
                        try {
                            this.doForceDeleteDocuments(userCtx, contentOid, documentToPublish, deleteLinked, forceLinkedUnpublish, deleteEmptyContents);
                        }
                        catch (R01MContentModelException ex) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("Error al forzar la despublicaci\u00f3n del documento " + documentOid + ". ERROR:  " + ex.getMessage());
                        }
                        continue;
                    }
                    R01FLog.to((String)LOG_TYPE_ID).info("No se fuerza la despublicaci\u00f3n. Luego no se borra.");
                    continue;
                }
                R01FLog.to((String)LOG_TYPE_ID).info("El documento " + documentOid + " no est\u00e1 publicado. Luego se puede borrar");
                if (deleteLinked) {
                    R01FLog.to((String)LOG_TYPE_ID).info("Hay que borrar vinculados");
                    try {
                        lnkResGroup = this.doGetDocumentLinkedResources(userCtx, documentOid);
                        HashMap<String, List<String>> lnkResDocumentsContentsOids = new HashMap<String, List<String>>();
                        for (R01MLinkedResource lnk : lnkResGroup.getResources().values()) {
                            if (!lnk.isRelationOwner() || lnk.getLinkType() != 2 || lnk.getLink().getFirstLinkItem() == null) continue;
                            String lnkContentOid = (String)lnk.getLink().getFirstLinkItem().getData().get("contentOid");
                            String lnkDocumentOid = (String)lnk.getLink().getFirstLinkItem().getData().get("documentOid");
                            if (!lnkResDocumentsContentsOids.containsKey(lnkContentOid)) {
                                lnkResDocumentsContentsOids.put(lnkContentOid, new ArrayList());
                            }
                            lnkResDocumentsContentsOids.get(lnkContentOid).add(lnkDocumentOid);
                            R01FLog.to((String)LOG_TYPE_ID).info("Vinculo a documento '" + lnkDocumentOid + "' del contenido '" + lnkContentOid + "'");
                        }
                        if (!lnkResDocumentsContentsOids.isEmpty()) {
                            R01FLog.to((String)LOG_TYPE_ID).info("Borrando vinculados");
                            this.doDeleteDocuments(userCtx, lnkResDocumentsContentsOids, false, forceLinkedUnpublish, false, deleteEmptyContents);
                        }
                    }
                    catch (R01MContentModelException ex) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener los recursos vinculados  al documento " + documentOid + ". ERROR:  " + ex.getMessage());
                    }
                }
                lnkResGroup = null;
                try {
                    lnkResGroup = this.doGetDocumentLinkedResources(userCtx, documentOid);
                }
                catch (R01MContentModelException cmExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener las vinculaciones del documento '" + documentOid + "'.Error:" + cmExc.getMessage());
                }
                R01MDocument documentToDelete = (R01MDocument)content.getDocuments().remove(documentOid);
                try {
                    this.doSaveContent(userCtx, content);
                }
                catch (Exception ex) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error al borrar el documento " + documentOid + ".ERROR: " + ex.getMessage());
                    if (documentToDelete == null) continue;
                    content.getDocuments().put(documentToDelete.getOid(), documentToDelete);
                    continue;
                }
                if (lnkResGroup != null && lnkResGroup.getResources() != null && !lnkResGroup.getResources().isEmpty()) {
                    R01DLinkedResourcesManager manager = new R01DLinkedResourcesManager();
                    for (Map.Entry meRes : lnkResGroup.getResources().entrySet()) {
                        R01MLinkedResource lnkRes = (R01MLinkedResource)meRes.getValue();
                        if (lnkRes.getLinkType() != 2) continue;
                        manager.notifyNewLinkedRelationsInContent(lnkRes.getRelatedDocumentContentOid(), lnkRes.getRelatedDocumentDocumentOid(), lnkRes.getRelatedDocumentContentRepositoryOid(), 0, lnkRes.getRelatedDocumentLinkedResourceOid(), null);
                    }
                }
                R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
                try {
                    boolean contentEmpty = true;
                    if (!content.getDocuments().isEmpty()) {
                        for (String currentDocument : content.getDocuments().keySet()) {
                            if (loaderHelper.loadContentDocumentLazy(contentOid, currentDocument) == null) continue;
                            contentEmpty = false;
                        }
                    }
                    if (!deleteEmptyContents || !content.getDocuments().isEmpty() && !contentEmpty) continue;
                    R01FLog.to((String)LOG_TYPE_ID).info("Borrando contenido");
                    this.doDeleteContent(userCtx, content);
                }
                catch (R01MDeleteContentException ex) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error al borrar el contenido de oid " + contentOid + ". ERROR:  " + ex.getMessage());
                }
                catch (R01MContentModelException ex) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error al borrar el contenido de oid " + contentOid + ". ERROR:  " + ex.getMessage());
                }
                catch (Exception ex) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error al borrar el contenido de oid " + contentOid + ". ERROR:  " + ex.getMessage());
                }
            }
        }
    }

    public boolean doCheckContentCatalogs(R01MUserContext userCtx, R01MContent content) throws R01MContentModelException {
        boolean catOK;
        String opDesc;
        block32: {
            opDesc = "Comprobar las catalogaciones del contenido " + content != null ? content.getOid() : "null";
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (init): " + opDesc);
            catOK = true;
            try {
                R01MWorkArea workArea = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(content.getStoreLocation().getServerOid(), content.getStoreLocation().getDataRepositoryOid(), content.getStoreLocation().getAreaOid(), content.getStoreLocation().getWorkAreaOid());
                R01MContentType typology = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(content.getTypo().getClusterOid(), content.getTypo().getFamilyOid(), content.getTypo().getTypeOid());
                R01MCatalogManagerAPI catalogationManagerAPI = R01MClientFactory.getCatalogAPI((R01MUserContext)userCtx);
                HashMap mandatoryStructures = new HashMap();
                if (workArea != null && workArea.getCataloguingConfig() != null && workArea.getCataloguingConfig().getMandatoryStructures() != null) {
                    mandatoryStructures.putAll(workArea.getCataloguingConfig().getMandatoryStructures());
                }
                if (typology != null && typology.getCataloguingConfig() != null && typology.getCataloguingConfig().getMandatoryStructures() != null) {
                    mandatoryStructures.putAll(typology.getCataloguingConfig().getMandatoryStructures());
                }
                HashMap mandatoryStructuresGroup = new HashMap();
                if (workArea != null && workArea.getCataloguingConfig() != null && workArea.getCataloguingConfig().getMandatoryStructureGroups() != null) {
                    mandatoryStructuresGroup.putAll(workArea.getCataloguingConfig().getMandatoryStructureGroups());
                }
                if (typology != null && typology.getCataloguingConfig() != null && typology.getCataloguingConfig().getMandatoryStructureGroups() != null) {
                    mandatoryStructuresGroup.putAll(typology.getCataloguingConfig().getMandatoryStructureGroups());
                }
                HashMap<String, String> waMap = new HashMap<String, String>();
                HashMap<String, String> contentMap = new HashMap<String, String>();
                ArrayList<String> arrGroups = new ArrayList<String>();
                HashMap allowedBags = new HashMap();
                if (workArea != null && workArea.getCataloguingConfig() != null && workArea.getCataloguingConfig().getAllowedBags() != null) {
                    allowedBags.putAll(workArea.getCataloguingConfig().getAllowedBags());
                }
                if (typology != null && typology.getCataloguingConfig() != null && typology.getCataloguingConfig().getAllowedBags() != null) {
                    allowedBags.putAll(typology.getCataloguingConfig().getAllowedBags());
                }
                Iterator mandatoryIterator = mandatoryStructures.keySet().iterator();
                R01MStructureCataloguingConfig mandatoryStructure = null;
                String structureOid2 = null;
                String role = null;
                while (mandatoryIterator.hasNext()) {
                    mandatoryStructure = (R01MStructureCataloguingConfig)mandatoryStructures.get(mandatoryIterator.next());
                    if (mandatoryStructure.isIgnorable()) continue;
                    structureOid2 = mandatoryStructure.getStructureOid();
                    try {
                        R01MStructure structureToCheck = R01MClientFactory.getCatalogAPI((R01MUserContext)userCtx).loadStructure(structureOid2, false);
                        R01MBag bagToCheck = R01MClientFactory.getCatalogAPI((R01MUserContext)userCtx).loadBag(structureToCheck.getSDefinition().getBagId());
                        if (allowedBags != null && !allowedBags.isEmpty()) {
                            if (!allowedBags.containsKey(bagToCheck.getBagGUID())) continue;
                            role = mandatoryStructure.getRole();
                            if (waMap.get(structureOid2) != null && Integer.parseInt((String)waMap.get(structureOid2)) >= Integer.parseInt(role)) continue;
                            waMap.put(structureOid2, role);
                            continue;
                        }
                        if (waMap.get(structureOid2) != null && Integer.parseInt((String)waMap.get(structureOid2)) >= Integer.parseInt(role)) continue;
                        waMap.put(structureOid2, role);
                    }
                    catch (R01MCatalogElementNotFoundException ex) {
                        R01FLog.to((String)LOG_TYPE_ID).info("No existe la estructura obligatoria : " + structureOid2);
                    }
                }
                Iterator mandatoryGroupIterator = mandatoryStructuresGroup.keySet().iterator();
                while (mandatoryGroupIterator.hasNext()) {
                    R01MStructureGroupCataloguingConfig mandatoryGroup = (R01MStructureGroupCataloguingConfig)mandatoryStructuresGroup.get(mandatoryGroupIterator.next());
                    String groupOid = mandatoryGroup.getGroupOid();
                    if (arrGroups.contains(groupOid)) continue;
                    arrGroups.add(groupOid);
                }
                if (waMap.isEmpty() && arrGroups.isEmpty()) {
                    return true;
                }
                if (content.getLabels() != null && !content.getLabels().isEmpty()) {
                    for (R01MStructureCatalog contentStructure : content.getLabels()) {
                        R01MStructureItem structureItem = null;
                        try {
                            structureItem = catalogationManagerAPI.getStructureItem(contentStructure.getStructureOid(), contentStructure.getOid(), Integer.parseInt(contentStructure.getRole()));
                        }
                        catch (R01MCatalogElementNotFoundException ex) {
                            // empty catch block
                        }
                        if (structureItem == null) {
                            R01FLog.to((String)LOG_TYPE_ID).warning("La etiqueta de identificador '" + contentStructure.getOid() + "' no existe en la estructura '" + contentStructure.getStructureOid() + "' a nivel " + contentStructure.getRole() + ".");
                            return false;
                        }
                        structureOid2 = contentStructure.getStructureOid();
                        String string = role = !structureItem.hasChildren() ? "-1" : contentStructure.getRole();
                        if (contentMap.get(structureOid2) != null && !role.equals("-1") && (((String)contentMap.get(structureOid2)).equals("-1") || Integer.parseInt(role) <= Integer.parseInt((String)contentMap.get(structureOid2)))) continue;
                        contentMap.put(contentStructure.getStructureOid(), role);
                    }
                }
                if (contentMap.isEmpty()) {
                    return false;
                }
                for (String structureOid2 : waMap.keySet()) {
                    String catalogationRole = (String)contentMap.get(structureOid2);
                    if (catalogationRole != null && (catalogationRole.equals("-1") || Integer.parseInt(catalogationRole) >= Integer.parseInt((String)waMap.get(structureOid2)))) continue;
                    return false;
                }
                if (arrGroups == null || arrGroups.isEmpty()) break block32;
                for (String groupOid : arrGroups) {
                    List structuresOfGroup = catalogationManagerAPI.loadStructuresInGroup(groupOid);
                    if (structuresOfGroup == null || structuresOfGroup.isEmpty()) continue;
                    boolean inGroup = false;
                    int structureFound = 0;
                    for (String structureInGroup : structuresOfGroup) {
                        try {
                            String structurechecked;
                            R01MStructure structureToCheck = R01MClientFactory.getCatalogAPI((R01MUserContext)userCtx).loadStructure(structureOid2, false);
                            R01MBag bagToCheck = R01MClientFactory.getCatalogAPI((R01MUserContext)userCtx).loadBag(structureToCheck.getSDefinition().getBagId());
                            if (allowedBags != null) {
                                if (allowedBags.containsKey(bagToCheck.getBagGUID())) {
                                    ++structureFound;
                                    structurechecked = (String)contentMap.get(structureInGroup);
                                    if (structurechecked != null) {
                                        inGroup = true;
                                    }
                                }
                            } else {
                                ++structureFound;
                                structurechecked = (String)contentMap.get(structureInGroup);
                                if (structurechecked != null) {
                                    inGroup = true;
                                }
                            }
                        }
                        catch (R01MCatalogElementNotFoundException ex) {
                            R01FLog.to((String)LOG_TYPE_ID).info("No existe la estructura obligatoria : " + structureOid2);
                        }
                        if (structureFound != 0) continue;
                        inGroup = true;
                    }
                    if (inGroup) continue;
                    return false;
                }
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace(System.out);
                throw new R01MContentModelException(ex.getMessage());
            }
            catch (R01MConfigLoadException cfgLoadEx) {
                throw new R01MContentModelException((Exception)((Object)cfgLoadEx));
            }
            catch (R01MCatalogException catEx) {
                throw new R01MContentModelException((Exception)((Object)catEx));
            }
        }
        R01FLog.to((String)LOG_TYPE_ID).info("CLIENT API (end) : " + opDesc);
        return catOK;
    }

    public boolean doCheckContentExistence(String contentOid) throws R01MContentModelException {
        if (StringUtils.isEmptyString((String)contentOid)) {
            return false;
        }
        String opDesc = "Comprobar la existencia del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DDAOContentModelLoader modelLoader = new R01DDAOContentModelLoader();
            boolean exist = modelLoader.executeCheckContentExistence(contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return exist;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public boolean doCheckAliasExistence(String alias) throws R01MContentModelException {
        if (StringUtils.isEmptyString((String)alias)) {
            return false;
        }
        String opDesc = "Comprobar la existencia del alias " + alias;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DDAOContentModelLoader modelLoader = new R01DDAOContentModelLoader();
            boolean exist = modelLoader.executeCheckAliasExistence(alias);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return exist;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public boolean doCheckDocumentExistence(String documentOid) throws R01MContentModelException {
        if (StringUtils.isEmptyString((String)documentOid)) {
            return false;
        }
        String opDesc = "Comprobar la existencia del documento " + documentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DDAOContentModelLoader modelLoader = new R01DDAOContentModelLoader();
            boolean exist = modelLoader.executeCheckDocumentExistence(documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return exist;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public boolean doCheckDatafileExistence(String datafileOid) throws R01MContentModelException {
        if (StringUtils.isEmptyString((String)datafileOid)) {
            return false;
        }
        String opDesc = "Comprobar la existencia del archivo " + datafileOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DDAOContentModelLoader modelLoader = new R01DDAOContentModelLoader();
            boolean exist = modelLoader.executeCheckDatafileExistence(datafileOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return exist;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public boolean doCheckContentDocumentRelation(String contentOid, String documentOid) throws R01MContentModelException {
        if (StringUtils.isEmptyString((String)contentOid) || StringUtils.isEmptyString((String)documentOid)) {
            return false;
        }
        String opDesc = "Comprobar la relaci\u00f3n del [contenido,documento] [" + contentOid + "," + documentOid + "]";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DDAOContentModelLoader modelLoader = new R01DDAOContentModelLoader();
            boolean exist = modelLoader.executeCheckContentDocumentRelation(contentOid, documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return exist;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public boolean doCheckContentDocumentDatafileRelation(String contentOid, String documentOid, String datafileOid) throws R01MContentModelException {
        if (StringUtils.isEmptyString((String)contentOid) || StringUtils.isEmptyString((String)documentOid) || StringUtils.isEmptyString((String)datafileOid)) {
            return false;
        }
        String opDesc = "Comprobar la relaci\u00f3n del [contenido,documento,archivo] [" + contentOid + "," + documentOid + "," + datafileOid + "]";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DDAOContentModelLoader modelLoader = new R01DDAOContentModelLoader();
            boolean exist = modelLoader.executeCheckContentDocumentDatafileRelation(contentOid, documentOid, datafileOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return exist;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public boolean doCheckDocumentDatafileRelation(String documentOid, String datafileOid) throws R01MContentModelException {
        if (StringUtils.isEmptyString((String)documentOid) || StringUtils.isEmptyString((String)datafileOid)) {
            return false;
        }
        String opDesc = "Comprobar la relaci\u00f3n del [documento,archivo] [" + documentOid + "," + datafileOid + "]";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DDAOContentModelLoader modelLoader = new R01DDAOContentModelLoader();
            boolean exist = modelLoader.executeCheckDocumentDatafileRelation(documentOid, datafileOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return exist;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public R01MContent doLoadContent(R01MUserContext userCtx, String contentOid) throws R01MContentModelException {
        String opDesc = "Carga del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
            R01MContent cont = loaderHelper.loadContentFromDBXML(contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return cont;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public R01MDocument doLoadDocument(R01MUserContext userCtx, String documentOid) throws R01MContentModelException {
        String opDesc = "Carga del documento " + documentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
            R01MDocument doc = null;
            if (loaderHelper.hasDocumentXMLInformation(documentOid)) {
                doc = loaderHelper.loadDocumentFromDBXML(documentOid);
            } else {
                R01MContent content = this.doLoadContent(userCtx, this.doGetDocumentParentContent(documentOid));
                doc = content.getDocument(documentOid);
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return doc;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public R01MContent doLoadContentLazy(R01MUserContext userCtx, String contentOid) throws R01MContentModelException {
        String opDesc = "Carga ligera del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
            R01MContent cont = loaderHelper.loadContentLazy(contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return cont;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public Map<String, R01MBasePublicationTarget> doLoadRunningPublications(R01MUserContext userCtx) throws R01MContentModelException {
        String opDesc = "Carga de las publicaciones y despublicaciones en estado RUNNING";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
            Map runningPublications = loaderHelper.loadRunningPublications();
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return runningPublications;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public Date doLoadContentIndexStartDate(R01MUserContext userCtx, String contentOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Carga de la fecha de inicio de la indexaci\u00f3n para el contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
            Date indexStartDate = loaderHelper.loadContentIndexStartDate(contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return indexStartDate;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public Date doLoadDocumentIndexStartDate(R01MUserContext userCtx, String documentOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Carga de la fecha de inicio de la indexaci\u00f3n para el documento " + documentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
            Date indexStartDate = loaderHelper.loadDocumentIndexStartDate(documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return indexStartDate;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public List<R01MURLAlias> doLoadDocumentAliasesInState(R01MUserContext userCtx, String documentOid, int state) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Carga la lista de aliases del documento " + documentOid + " que se encuentran en estado " + state;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
            List aliases = loaderHelper.loadDocumentAliasesInState(documentOid, state);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return aliases;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public void doSetContentIndexStartDate(R01MUserContext userCtx, String contentOid, Date indexStartDate) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Establece la fecha de inicio de la indexaci\u00f3n para el contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelUpdateHelper updateHelper = new R01DContentModelUpdateHelper(userCtx);
            updateHelper.setContentIndexStartDate(contentOid, indexStartDate);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public void doSetContentPublishIndexFiles(R01MUserContext userCtx, String contentOid, boolean hasToPublishIndexFiles) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Establece en flag de publicaci\u00f3n de los ficheros de indexaci\u00f3n para el contenido " + contentOid + " el valor " + (hasToPublishIndexFiles ? "1" : "0");
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelUpdateHelper updateHelper = new R01DContentModelUpdateHelper(userCtx);
            updateHelper.setContentPublishIndexFiles(contentOid, hasToPublishIndexFiles);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public void doSetDocumentIndexStartDate(R01MUserContext userCtx, String documentOid, Date indexStartDate) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Establece la fecha de inicio de la indexaci\u00f3n para el documento " + documentOid + " a " + (indexStartDate != null ? DateUtils.getDateFormated((Date)indexStartDate, (String)"dd/MM/yyyy HH:mm:ss") : "null");
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelUpdateHelper updateHelper = new R01DContentModelUpdateHelper(userCtx);
            updateHelper.setDocumentIndexStartDate(documentOid, indexStartDate);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public void doSetDocumentPublishIndexFiles(R01MUserContext userCtx, String documentOid, boolean hasToPublishIndexFiles) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Establece en flag de publicaci\u00f3n de los ficheros de indexaci\u00f3n para el documento " + documentOid + " el valor " + (hasToPublishIndexFiles ? "1" : "0");
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelUpdateHelper updateHelper = new R01DContentModelUpdateHelper(userCtx);
            updateHelper.setDocumentPublishIndexFiles(documentOid, hasToPublishIndexFiles);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public String doLoadContentIndexersState(R01MUserContext userCtx, String contentOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Carga del estado de los indexadores para el contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
            String indexersState = loaderHelper.loadContentIndexersState(contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return indexersState;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public void doSetContentIndexersState(R01MUserContext userCtx, String contentOid, String indexersState) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Establece el xml de estado de los indexadores para el contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelUpdateHelper updateHelper = new R01DContentModelUpdateHelper(userCtx);
            updateHelper.setContentIndexersState(contentOid, indexersState);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public String doLoadDocumentIndexersState(R01MUserContext userCtx, String documentOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Carga del estado de los indexadores para el documento " + documentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
            String indexersState = loaderHelper.loadDocumentIndexersState(documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return indexersState;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public void doSetDocumentIndexersState(R01MUserContext userCtx, String documentOid, String indexersState) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Establece el xml de estado de los indexadores para el documento " + documentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelUpdateHelper updateHelper = new R01DContentModelUpdateHelper(userCtx);
            updateHelper.setDocumentIndexersState(documentOid, indexersState);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public List doGetDefaultLabels(R01MContentLocation loc, R01MContentTypologyInfo typo) throws R01MContentModelException {
        ArrayList<R01MStructureCatalog> defLabels = new ArrayList<R01MStructureCatalog>();
        if (typo != null) {
            R01MContentType tipoContenido;
            try {
                tipoContenido = R01MClientFactory.getTypologyConfigAPI().getTypeConfig(typo.getClusterOid(), typo.getFamilyOid(), typo.getTypeOid());
            }
            catch (R01MConfigLoadException cfgExc) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener las etiquetas por defecto de la tipolog\u00eda " + typo.composeMemoCode() + ".Error:" + cfgExc.getMessage());
                throw new R01MContentModelException("Error al obtener las etiquetas por defecto de la tipolog\u00eda " + typo.composeMemoCode() + ".", (Exception)((Object)cfgExc));
            }
            List defaultLabelsTypo = tipoContenido.getCataloguingConfig().getDefaultLabels();
            if (defaultLabelsTypo != null && !defaultLabelsTypo.isEmpty()) {
                for (R01MDefaultLabelConfig lbConf : defaultLabelsTypo) {
                    defLabels.add((R01MStructureCatalog)R01MDozerMappingUtils.map((String)R01MConstants.CONTENTMANAGER_APPCODE, (Object)lbConf, R01MStructureCatalog.class));
                }
            }
        }
        if (loc != null) {
            List defaultLabelsWorkArea;
            try {
                defaultLabelsWorkArea = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(loc.getServerOid(), loc.getDataRepositoryOid(), loc.getAreaOid(), loc.getWorkAreaOid()).getCataloguingConfig().getDefaultLabels();
            }
            catch (R01MConfigLoadException cfgExc) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener las etiquetas por defecto de la workarea " + loc.composeMemoCode() + ".Error:" + cfgExc.getMessage());
                throw new R01MContentModelException("Error al obtener las etiquetas por defecto de la workarea " + loc.composeMemoCode() + ".", (Exception)((Object)cfgExc));
            }
            if (defaultLabelsWorkArea != null && !defaultLabelsWorkArea.isEmpty()) {
                for (R01MDefaultLabelConfig lbConf : defaultLabelsWorkArea) {
                    boolean bExists = false;
                    if (!defLabels.isEmpty()) {
                        for (R01MStructureCatalog currLabelConfig : defLabels) {
                            if (!lbConf.getStructureOid().equals(currLabelConfig.getStructureOid()) || !lbConf.getLabelOid().equals(currLabelConfig.getOid())) continue;
                            bExists = true;
                        }
                    }
                    if (bExists) continue;
                    defLabels.add((R01MStructureCatalog)R01MDozerMappingUtils.map((String)R01MConstants.CONTENTMANAGER_APPCODE, (Object)lbConf, R01MStructureCatalog.class));
                }
            }
        }
        return defLabels.isEmpty() ? null : defLabels;
    }

    public R01MContentLocation doLoadContentLocation(R01MUserContext userCtx, String contentOid) throws R01MContentModelException {
        String opDesc = "Carga de la informaci\u00f3n de localizaci\u00f3n en el almacenamiento del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DDAOContentModelLoader contAuxObjsHelper = new R01DDAOContentModelLoader(userCtx);
            R01MContentLocation loc = contAuxObjsHelper.executeLoadContentLocation(contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return loc;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public R01MContentTypologyInfo doLoadContentTypology(R01MUserContext userCtx, String contentOid) throws R01MContentModelException {
        String opDesc = "Carga de la informaci\u00f3n de tipolog\u00eda del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DDAOContentModelLoader contAuxObjsHelper = new R01DDAOContentModelLoader(userCtx);
            R01MContentTypologyInfo typo = contAuxObjsHelper.executeLoadContentTypology(contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return typo;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public R01MContentTypologyInfo doLoadContentTypology(R01MUserContext userCtx, String objectOid, int objectType) throws R01MContentModelException {
        String opDesc = "Carga de la informaci\u00f3n de tipolog\u00eda del objeto " + objectOid + " de tipo " + objectType;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DDAOContentModelLoader contAuxObjsHelper = new R01DDAOContentModelLoader(userCtx);
            R01MContentTypologyInfo typo = contAuxObjsHelper.executeLoadContentTypology(objectOid, objectType);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return typo;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public List<R01MStructureCatalog> doLoadContentStructureLabels(R01MUserContext userCtx, String contentOid, String structureOid, String role, boolean strictRole) throws R01MContentModelException {
        String opDesc = "Carga de las etiquetas de catalogacion en ejes del contenido " + contentOid;
        try {
            R01DDAOContentModelLoader contAuxObjsHelper;
            ArrayList<R01MStructureCatalog> structCats;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            if (((structCats = (contAuxObjsHelper = new R01DDAOContentModelLoader(userCtx)).executeLoadContentStructureLabels(contentOid, structureOid, role)) == null || structCats.isEmpty()) && structureOid != null && role != null && !strictRole) {
                structCats = new ArrayList<R01MStructureCatalog>();
                List structCatsWithOutRole = contAuxObjsHelper.executeLoadContentStructureLabels(contentOid, structureOid, null);
                if (structCatsWithOutRole != null && !structCatsWithOutRole.isEmpty()) {
                    R01MStructure struct;
                    try {
                        struct = R01MClientFactory.getCatalogAPI((R01MUserContext)userCtx).loadStructure(structureOid);
                    }
                    catch (R01MCatalogElementNotFoundException catExc) {
                        throw new R01MContentModelException("La estructura " + structureOid + " no existe.", (Exception)((Object)catExc));
                    }
                    catch (R01MCatalogException catEx) {
                        throw new R01MContentModelException((Exception)((Object)catEx));
                    }
                    for (R01MStructureCatalog currCat : structCatsWithOutRole) {
                        Collection branches = struct.findLabel(currCat.getOid());
                        if (branches == null) continue;
                        R01MStructureItem currItem = null;
                        for (R01MStructureItem currBranchRootItem : branches) {
                            currItem = struct.findLabelInSubBranch(currBranchRootItem, currCat.getOid());
                            if (currItem.getChildren() != null && currItem.getChildren().size() != 0) continue;
                            structCats.add(currCat);
                        }
                    }
                }
                if (structCats.isEmpty()) {
                    structCats = null;
                }
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return structCats;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public R01MGeoPicks doLoadContentGeoLabels(R01MUserContext userCtx, String contentOid) throws R01MContentModelException {
        String opDesc = "Carga de las etiquetas de catalogacion geogr\u00e1fica del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DDAOContentModelLoader contAuxObjsHelper = new R01DDAOContentModelLoader(userCtx);
            R01MGeoPicks geoCats = contAuxObjsHelper.executeLoadContentGeoLabels(contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return geoCats;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public void doSaveContentGeoLabels(R01MUserContext userCtx, String contentOid, R01MGeoPicks geoCatalog) throws R01MSecurityException, R01MContentModelException {
        String geoCatalogXML;
        String opDesc = "Guardando la catalogaci\u00f3n geogr\u00e1fica del contenido " + contentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        try {
            geoCatalogXML = R01DUtils.obtainXMLFromGeoCatalogObj((R01MGeoPicks)geoCatalog);
        }
        catch (XOMarshallerException xoEx) {
            xoEx.printStackTrace(System.out);
            throw new R01MContentModelException("Error al transformar el descriptor XML del contenido a objeto: " + xoEx.getMessage());
        }
        try {
            R01DContentModelUpdateHelper updateHelper = new R01DContentModelUpdateHelper(userCtx);
            updateHelper.updateContentGeoLabels(geoCatalog.getOid(), contentOid, geoCatalogXML);
        }
        catch (R01DContentModelPersistenceException cmExc) {
            cmExc.printStackTrace(System.out);
            throw new R01MContentModelException("Error al actualizar el XML de catalogaciones geogr\u00e1ficas del contenido: " + cmExc.getMessage());
        }
        R01MContent theContent = this.doLoadContent(userCtx, contentOid);
        R01DContentInDataStore contInDS = new R01DContentInDataStore(userCtx, theContent);
        try {
            contInDS.uploadFileInContent(R01MPathHelpper.getGeoCatalogDescriptorContentRelativePath((String)theContent.getInternalName()), (InputStream)new ByteArrayInputStream(geoCatalogXML.getBytes()));
        }
        catch (R01MDataStoreException dsExc) {
            dsExc.printStackTrace(System.out);
            throw new R01MContentModelException("Error al actualizar el XML de catalogaciones geogr\u00e1ficas en el store del contenido: " + dsExc.getMessage());
        }
        ArrayList<R01MJmsQueueParam> params = new ArrayList<R01MJmsQueueParam>();
        try {
            params.add(new R01MJmsQueueParam(1, "geoCatalogXML", (Object)XOManager.getXML((String)R01MConstants.CONTENTMODEL_MAPFILE, (Object)geoCatalog)));
        }
        catch (XOMarshallerException e) {
            R01FLog.to((String)LOG_TYPE_ID).warning("Error al crear el renderizado del HTML de catalogaci\u00f3n geogr\u00e1fica.Error:" + e.getMessage());
        }
        for (R01MDocument document : theContent.getDocuments().values()) {
            this._sendRenderMessage(userCtx, theContent, document, "geocatalog", null, params);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public List<R01MContentHistory> doLoadContentHistory(R01MUserContext userCtx, String contentOid, R01MContentHistoryFilter filter) throws R01MContentModelException {
        String opDesc = "Obtener la historia del contenido " + contentOid + "\r\nFiltro: " + (filter == null ? "[No hay]" : "\r\n" + filter.composeDebugInfo());
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DDAOHistoryManager historyManager = new R01DDAOHistoryManager();
            List outList = historyManager.executeLoadHistory(contentOid, filter, userCtx.getUserLang());
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return outList;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public List doLoadUserContentLastActions(R01MUserContext userCtx, int numActions, String lang) throws R01MContentModelException {
        String opDesc = "Obtener del hist\u00f3rico las \u00faltimas " + numActions + " acciones  del usuario " + userCtx.getUserName();
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DDAOHistoryManager historyManager = new R01DDAOHistoryManager();
            if (StringUtils.isEmptyString((String)lang)) {
                lang = userCtx.getUserLang();
            }
            List outList = historyManager.executeLoadUserLastActions(userCtx.getUserName(), numActions, lang);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return outList;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public List doFrequentlyModifyUserActivity(R01MUserContext userCtx, int numActions) throws R01MContentModelException {
        String opDesc = "Obtener del hist\u00f3rico de los \u00faltimas " + numActions + " las acciones  del usuario " + userCtx.getUserName();
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DDAOHistoryManager historyManager = new R01DDAOHistoryManager();
            List outList = historyManager.executeFrequentlyModifyUserActivity(userCtx.getUserName(), numActions, userCtx.getUserLang());
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return outList;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public List doFrequentlyCreatedUserActivity(R01MUserContext userCtx, int numActions) throws R01MContentModelException {
        String opDesc = "Obtener del hist\u00f3rico de los \u00faltimas " + numActions + " las acciones  del usuario " + userCtx.getUserName();
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DDAOHistoryManager historyManager = new R01DDAOHistoryManager();
            List outList = historyManager.executeFrequentlyCreatedUserActivity(userCtx.getUserName(), numActions, userCtx.getUserLang());
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return outList;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public boolean isDocumentPublished(R01MUserContext userCtx, String target, String documentOid) throws R01MContentModelException {
        String opDesc = "Validar si el documento " + documentOid + " est\u00e1 publicado en el repositorio " + target;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01MDocument doc = this.doLoadDocument(userCtx, documentOid);
        boolean isDocumentPublished = false;
        isDocumentPublished = StringUtils.isEmptyString((String)target) ? doc.isPublishedInAnyRepository() : doc.isPublishedInRepository(target);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return isDocumentPublished;
    }

    public R01MContent doLoadContentDocumentLazy(R01MUserContext userCtx, R01MContent inContent, String documentOid) throws R01MContentModelException, R01MSecurityException {
        String opDesc = "Carga ligera del documento " + documentOid + " en el contenido " + inContent.getOid();
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
            R01MDocument doc = loaderHelper.loadContentDocumentLazy(inContent.getOid(), documentOid);
            if (inContent.getDocuments() == null) {
                inContent.setDocuments(new HashMap());
            }
            inContent.getDocuments().put(doc.getOid(), doc);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return inContent;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public String doGetContentOidFromContentTypeAndName(String contentType, String contentName) throws R01MContentModelException {
        String opDesc = "Obtiene el oid del contenido de tipo " + contentType + " y nombre " + contentName;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DEjbContentModelLoader modelLoader = new R01DEjbContentModelLoader();
            String outOid = modelLoader.executeGetContentOidByTypeAndName(contentType, contentName);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return outOid;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public String doGetDocumentParentContent(String documentOid) throws R01MContentModelException {
        String opDesc = "Obtener el contenido padre del documento " + documentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DEjbModelHierarchyNavigator modelNavigator = new R01DEjbModelHierarchyNavigator();
            String contOid = modelNavigator.executeGetDocumentParentContentOid(documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return contOid;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public Map doGetAvailableLanguagesToTranslateDocument(R01MUserContext userCtx, String documentOid) throws R01MContentModelException {
        String opDesc = "Carga de identificadores de languages disponibles para traducci\u00f3n del documento " + documentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DDAOContentModelLoader docAuxObjsLoader = new R01DDAOContentModelLoader(userCtx);
            Map languages = docAuxObjsLoader.executeLoadDocumentAvailableLanguagesToTranslate(documentOid, userCtx.getUserLang());
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return languages;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public R01MDocumentRevisionState doRequestDocumentRevision(R01MUserContext userCtx, String contentOid, String documentOid) throws R01MContentModelException {
        R01MContent content;
        String opDesc = "Peticion de REVISION del documento " + documentOid + " en el contenido " + contentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        if ((content = this.doLoadContent(userCtx, contentOid)) == null) {
            throw new R01MContentModelException("NO se ha podido cargar el contenido " + contentOid);
        }
        R01MDocument doc = content.getDocument(documentOid);
        if (doc == null) {
            throw new R01MContentModelException("NO se ha podido cargar el documento " + documentOid + " del contenido " + contentOid);
        }
        R01DDocumentStateHelper stateHelper = new R01DDocumentStateHelper();
        R01MDocumentRevisionState newState = stateHelper.doRequestDocumentRevision(content, doc);
        doc.setRevisionState(newState);
        try {
            this.doSaveDocument(userCtx, content.getOid(), content.getDocument(documentOid));
        }
        catch (R01MDeleteModelObjectException delEx) {
        }
        catch (R01MDuplicateModelObjectException dupEx) {
        }
        catch (R01MSecurityException secEx) {
        }
        catch (R01MDirtyContentModelException ex) {
            // empty catch block
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return doc.getRevisionState();
    }

    public R01MContent doPublishAllDocuments(R01MUserContext userCtx, String contentOid, int publicationType, Date publicationDate, boolean onlyPublished) throws R01MContentModelException {
        String opDesc = "Peticion de publicacion/despublicacion de todos los documentos del contenido " + contentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01MContent content = this._publishDocuments(userCtx, contentOid, null, true, publicationType, publicationDate, false, null);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return content;
    }

    public R01MContent doPublishAllDocuments(R01MUserContext userCtx, String contentOid, int publicationType, Date publicationDate, boolean onlyPublished, List<R01MPublishActionObject> stepsActions) throws R01MContentModelException {
        String opDesc = "Peticion de publicacion/despublicacion de todos los documentos del contenido " + contentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01MContent content = this._publishDocuments(userCtx, contentOid, null, true, publicationType, publicationDate, false, stepsActions);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return content;
    }

    public R01MDocument doPublishDocument(R01MUserContext userCtx, String documentOid, int publicationType, Date publicationDate) throws R01MPublisherException, R01MContentModelException {
        R01MDocumentRevisionState revisionState;
        R01MPublicationConfig pub;
        if (publicationType != 0 && publicationType != 2 && publicationType != 1 && publicationType != 3) {
            throw new R01MContentModelException("El tipo de publicaci\u00f3n '" + publicationType + "' es incorrecto.Ver R01MDocumenPublicationRequested");
        }
        if (!(publicationType != 1 && publicationType != 3 || publicationDate != null && !publicationDate.before(R01MDateUtils.today()))) {
            throw new R01MContentModelException("La fecha de publicaci\u00f3n '" + publicationType + "' es incorrecta.");
        }
        R01DContentModelManager cmManager = new R01DContentModelManager();
        R01MDocument doc = cmManager.doLoadDocument(userCtx, documentOid);
        String contentOid = cmManager.doGetDocumentParentContent(doc.getOid());
        R01MContent content = cmManager.doLoadContent(userCtx, contentOid);
        try {
            pub = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(content.getStoreLocation().getWorkAreaOid()).getAllowedPublicationTargetsConfig();
        }
        catch (R01MConfigLoadException cfgExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener los repositorios de publicaci\u00f3n de la workarea. Los documentos del contenido " + content.getOid() + " " + "no se publican. Error:" + cfgExc.getMessage());
            throw new R01MContentModelException("Error al obtener los repositorios de publicaci\u00f3n de la workarea. Los documentos del contenido " + content.getOid() + " " + "no se publican.", (Exception)((Object)cfgExc));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER >> Obtenida la informaci\u00f3n de publicaci\u00f3n del workarea donde se encuentra el contenido contenido con oid " + content.getOid() + ".");
        }
        if (pub.getAllowedTargets() != null && !pub.getAllowedTargets().isEmpty()) {
            for (String targetRepOid : pub.getAllowedTargets().keySet()) {
                R01MDocumentPublicationRequested newPublicationRequested = new R01MDocumentPublicationRequested();
                newPublicationRequested.setRepositoryOid(targetRepOid);
                newPublicationRequested.setOperationDate(publicationDate);
                newPublicationRequested.setOperationType(publicationType);
                doc.addPublicationRequest(newPublicationRequested);
            }
            doc.setRevisionState(cmManager.doRequestDocumentRevision(userCtx, content.getOid(), documentOid));
        }
        while ((revisionState = cmManager.doAproveDocument(userCtx, contentOid, doc.getOid())).getRemainingRevisions() != 0) {
        }
        return doc;
    }

    public R01MContent doPublishDocuments(R01MUserContext userCtx, String contentOid, List<String> documentOids, int publicationType, Date publicationDate, boolean onlyPublished, List<R01MPublishActionObject> stepsActions) throws R01MContentModelException {
        String opDesc = "Peticion de publicacion/despublicacion de los documentos " + documentOids + " del contenido " + contentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01MContent content = this._publishDocuments(userCtx, contentOid, documentOids, false, publicationType, publicationDate, onlyPublished, stepsActions);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return content;
    }

    public void doPublishDocuments(R01MUserContext userCtx, List<String> documentOids, int publicationType, Date publicationDate, List<R01MPublishActionObject> stepsActions, String pubRepositoryOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Peticion de publicacion/despublicacion de los documentos " + documentOids;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        this._publishDocuments(documentOids, publicationType, publicationDate, stepsActions, userCtx.getUserName(), pubRepositoryOid);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public void doPublishDocuments(R01MUserContext userCtx, List<String> documentOids, int publicationType, Date publicationDate, List<R01MPublishActionObject> stepsActions) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Peticion de publicacion/despublicacion de los documentos " + documentOids;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        this._publishDocuments(documentOids, publicationType, publicationDate, stepsActions, userCtx.getUserName(), null);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    public R01MDocumentRevisionState doAproveDocument(R01MUserContext userCtx, String contentOid, String documentOid) throws R01MPublisherException, R01MContentModelException {
        return this.doAproveDocument(userCtx, contentOid, documentOid, null);
    }

    public R01MDocumentRevisionState doAproveDocument(R01MUserContext userCtx, String contentOid, String documentOid, List<R01MPublishActionObject> stepsActions) throws R01MPublisherException, R01MContentModelException {
        R01MContent content = this.doLoadContent(userCtx, contentOid);
        if (content == null) {
            throw new R01MContentModelException("NO se ha podido cargar el contenido " + contentOid);
        }
        return this.doAproveDocument(userCtx, content, documentOid, stepsActions);
    }

    public R01MDocumentRevisionState doAproveDocument(R01MUserContext userCtx, R01MContent content, String documentOid, List<R01MPublishActionObject> stepsActions) throws R01MPublisherException, R01MContentModelException {
        R01MDocument doc;
        block29: {
            block28: {
                String opDesc = "Aprobaci\u00f3n del documento " + documentOid + " en el contenido " + content.getOid();
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
                }
                StringBuffer errorMessage = new StringBuffer(37);
                doc = content.getDocument(documentOid);
                if (doc == null) {
                    throw new R01MContentModelException("NO se ha podido cargar el documento " + documentOid + " del contenido " + content.getOid());
                }
                R01DDocumentStateHelper stateHelper = new R01DDocumentStateHelper();
                R01MDocumentRevisionState newState = stateHelper.doAproveDocument(content, doc);
                doc.setRevisionState(newState);
                if (newState.getRemainingRevisions() != 0) break block28;
                HashMap requestedPublications = new HashMap();
                requestedPublications.putAll(doc.getRequestedPublications());
                if (requestedPublications == null || requestedPublications.isEmpty()) break block29;
                for (R01MDocumentPublicationRequested currPublicationRequested : requestedPublications.values()) {
                    int publicationType = currPublicationRequested.getOperationType();
                    String repositoryOid = currPublicationRequested.getRepositoryOid();
                    Date publicationDate = currPublicationRequested.getOperationDate();
                    doc.getRequestedPublications().remove(currPublicationRequested.getOid());
                    R01MDocumentPublicationTarget newPublicationTarget = null;
                    try {
                        newPublicationTarget = this.doUpdatePublicationState(content, documentOid, publicationType, publicationDate, repositoryOid);
                    }
                    catch (R01MSecurityException secEx) {
                        // empty catch block
                    }
                    List docPublicationInfoInDB = doc.getPublicationInfo();
                    try {
                        this.doSaveDocument(userCtx, content.getOid(), doc);
                    }
                    catch (R01MDeleteModelObjectException delEx) {
                    }
                    catch (R01MDuplicateModelObjectException dupEx) {
                    }
                    catch (R01MSecurityException secEx) {
                    }
                    catch (R01MDirtyContentModelException ex) {
                        // empty catch block
                    }
                    if (!StringUtils.isEmptyString((String)currPublicationRequested.getCallbackUrl())) {
                        if (stepsActions == null) {
                            stepsActions = new ArrayList<R01MPublishActionObject>();
                        }
                        StringBuffer callBackUrlParam = new StringBuffer(100);
                        callBackUrlParam.append(currPublicationRequested.getCallbackUrl());
                        if (currPublicationRequested.getCallbackUrlParameters() != null && !currPublicationRequested.getCallbackUrlParameters().isEmpty()) {
                            callBackUrlParam.append(';');
                            for (Map.Entry me : currPublicationRequested.getCallbackUrlParameters().entrySet()) {
                                callBackUrlParam.append((String)me.getKey());
                                callBackUrlParam.append(',');
                                callBackUrlParam.append((String)me.getValue());
                                callBackUrlParam.append(';');
                            }
                            callBackUrlParam.deleteCharAt(callBackUrlParam.length() - 1);
                        }
                        R01MPublishActionObject postPublishAction = new R01MPublishActionObject();
                        postPublishAction.setStep(3);
                        postPublishAction.setObjectOid(documentOid);
                        postPublishAction.setActionClass("com.ejie.r01p.publisher.R01PPublisherActions");
                        postPublishAction.setMethod("invokeCallbackUrl");
                        postPublishAction.setParam(callBackUrlParam.toString());
                        stepsActions.add(postPublishAction);
                    }
                    R01PPublishDefinition pubDefinition = new R01PPublishDefinition(userCtx.getUserName(), documentOid, 1, newPublicationTarget == null ? null : newPublicationTarget.getPublicationOid(), null, null, repositoryOid, publicationType, publicationDate, stepsActions, true, null, null);
                    try {
                        R01PClientFactory.getPublisherAPI().publish(pubDefinition);
                    }
                    catch (R01MPublisherException pubEx) {
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("MODEL SERVER (doAproveContent): Error al publicar el documento " + documentOid + " en el repositorio " + repositoryOid + " con el tipo de publicaci\u00f3n " + currPublicationRequested.getOperationType() + ". ERROR: " + pubEx.getMessage());
                        }
                        errorMessage.append("Repositorio: " + repositoryOid + "Tipo de publicaci\u00f3n: " + currPublicationRequested.getOperationType() + " \n");
                        newPublicationTarget.setState(publicationType == 0 || publicationType == 1 ? 3 : 2);
                        for (R01MDocumentPublicationTarget currentPublication : docPublicationInfoInDB) {
                            if (!currentPublication.getPublicationOid().equals(newPublicationTarget.getOid())) continue;
                            docPublicationInfoInDB.remove(currentPublication);
                            break;
                        }
                        docPublicationInfoInDB.add(newPublicationTarget);
                        doc.setPublicationInfo(docPublicationInfoInDB);
                        try {
                            this.doSaveDocument(userCtx, content.getOid(), doc);
                        }
                        catch (R01MDeleteModelObjectException delEx) {
                        }
                        catch (R01MDuplicateModelObjectException dupEx) {
                        }
                        catch (R01MSecurityException secEx) {
                        }
                        catch (R01MDirtyContentModelException ex) {}
                    }
                }
                break block29;
            }
            try {
                this.doSaveDocument(userCtx, content.getOid(), content.getDocument(documentOid));
            }
            catch (R01MDeleteModelObjectException delEx) {
            }
            catch (R01MDuplicateModelObjectException dupEx) {
            }
            catch (R01MSecurityException secEx) {
            }
            catch (R01MDirtyContentModelException ex) {
                // empty catch block
            }
        }
        return doc.getRevisionState();
    }

    public R01MDocumentRevisionState doRejectDocument(R01MUserContext userCtx, String contentOid, String documentOid, String notes) throws R01MContentModelException {
        R01MContent content;
        String opDesc = "Rechazo del documento " + documentOid + " en el contenido " + contentOid + " - " + notes;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        if ((content = this.doLoadContent(userCtx, contentOid)) == null) {
            throw new R01MContentModelException("NO se ha podido cargar el contenido " + contentOid);
        }
        R01MDocument doc = content.getDocument(documentOid);
        if (doc == null) {
            throw new R01MContentModelException("NO se ha podido cargar el documento " + documentOid + " del contenido " + contentOid);
        }
        doc.setRevisionState(new R01MDocumentRevisionState());
        try {
            this.doSaveDocument(userCtx, content.getOid(), content.getDocument(documentOid));
        }
        catch (R01MDeleteModelObjectException delEx) {
        }
        catch (R01MDuplicateModelObjectException dupEx) {
        }
        catch (R01MSecurityException secEx) {
        }
        catch (R01MDirtyContentModelException ex) {
            // empty catch block
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return doc.getRevisionState();
    }

    public R01MDocumentRevisionState doEditDocument(R01MUserContext userCtx, String contentOid, String documentOid, String notes) throws R01MContentModelException {
        R01MContent content;
        String opDesc = "Enviar a redacci\u00f3n el documento " + documentOid + " en el contenido " + contentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        if ((content = this.doLoadContent(userCtx, contentOid)) == null) {
            throw new R01MContentModelException("NO se ha podido cargar el contenido " + contentOid);
        }
        R01MDocument doc = content.getDocument(documentOid);
        if (doc == null) {
            throw new R01MContentModelException("NO se ha podido cargar el documento " + documentOid + " del contenido " + contentOid);
        }
        doc.setRevisionState(new R01MDocumentRevisionState());
        try {
            this.doSaveDocument(userCtx, contentOid, content.getDocument(documentOid));
        }
        catch (R01MDeleteModelObjectException delEx) {
        }
        catch (R01MDuplicateModelObjectException dupEx) {
        }
        catch (R01MSecurityException secEx) {
        }
        catch (R01MDirtyContentModelException ex) {
            // empty catch block
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return doc.getRevisionState();
    }

    public R01MDocument doTranslateDocument(R01MUserContext userCtx, String contentOid, String documentOid, String languageOid, boolean copyAttachment) throws R01MDuplicateDocumentException, R01MContentModelException {
        String opDesc = "Traducci\u00f3n del documento " + documentOid + " en el contenido " + contentOid + ". Copiar adjuntos : " + copyAttachment;
        try {
            R01MContent content;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            if ((content = this.doLoadContent(userCtx, contentOid)) == null) {
                throw new R01MContentModelException("NO se ha podido cargar el contenido " + contentOid);
            }
            R01MDocument srcDoc = content.getDocument(documentOid);
            if (srcDoc == null) {
                throw new R01MContentModelException("NO se ha podido cargar el documento " + documentOid + " del contenido " + contentOid);
            }
            R01DContentModelObjectsCopyHelper contCopyHelper = new R01DContentModelObjectsCopyHelper(this);
            R01MDocument docTranslation = null;
            try {
                docTranslation = contCopyHelper.copyDocument(userCtx, content, content, srcDoc, languageOid, null, copyAttachment);
            }
            catch (R01MDuplicateModelObjectException dupObjEx) {
                if (dupObjEx instanceof R01MDuplicateDocumentException) {
                    throw (R01MDuplicateDocumentException)dupObjEx;
                }
            }
            catch (R01MDeleteModelObjectException delObjEx) {
            }
            catch (R01MDirtyContentModelException ex) {
                // empty catch block
            }
            this._sendHistoryMessage(userCtx.getUserName(), content, (R01MBaseDocumentInterface)srcDoc, null, 1, 8, "Documento traducido " + srcDoc.getLanguage() + "_" + srcDoc.getInternalName() + "(" + documentOid + ") al lenguaje " + languageOid + ".Adjuntos: " + copyAttachment);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return docTranslation;
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException((Exception)((Object)dsEx));
        }
    }

    public R01MDocument doCopyDocument(R01MUserContext userCtx, String contentOid, String documentOid, String newInternalName, boolean copyAttachment) throws R01MDuplicateDocumentException, R01MContentModelException {
        String opDesc = "Copia del documento " + documentOid + " en el contenido " + contentOid + ". Copiar adjuntos : " + copyAttachment;
        try {
            R01MContent content;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            if ((content = this.doLoadContent(userCtx, contentOid)) == null) {
                throw new R01MContentModelException("NO se ha podido cargar el contenido " + contentOid);
            }
            R01MDocument srcDoc = content.getDocument(documentOid);
            if (srcDoc == null) {
                throw new R01MContentModelException("NO se ha podido cargar el documento " + documentOid + " del contenido " + contentOid);
            }
            Date pubDate = null;
            String pubOid = null;
            int pubState = 0;
            if (srcDoc.getPublicationInfo() != null) {
                for (R01MDocumentPublicationTarget publicationTarget : srcDoc.getPublicationInfo()) {
                    if (StringUtils.isEmptyString(pubOid)) {
                        pubDate = publicationTarget.getPublishDate();
                        pubOid = publicationTarget.getOid();
                        pubState = publicationTarget.getState();
                        continue;
                    }
                    if (!publicationTarget.getPublishDate().after(pubDate)) continue;
                    pubDate = publicationTarget.getPublishDate();
                    pubOid = publicationTarget.getOid();
                    pubState = publicationTarget.getState();
                }
            }
            if (pubState == 0) {
                pubOid = null;
            }
            R01DContentModelObjectsCopyHelper contCopyHelper = new R01DContentModelObjectsCopyHelper(this);
            R01MDocument docTranslation = null;
            try {
                docTranslation = contCopyHelper.copyDocument(userCtx, content, content, srcDoc, null, newInternalName, copyAttachment);
            }
            catch (R01MDuplicateModelObjectException dupObjEx) {
                if (dupObjEx instanceof R01MDuplicateDocumentException) {
                    throw (R01MDuplicateDocumentException)dupObjEx;
                }
            }
            catch (R01MDeleteModelObjectException delObjEx) {
            }
            catch (R01MDirtyContentModelException ex) {
                // empty catch block
            }
            if (docTranslation != null && docTranslation.getOid() != null) {
                R01MGallery gallery = (R01MGallery)this.doGetDocumentGalleryResources(userCtx, documentOid).getGalleries().get(documentOid);
                try {
                    if (gallery != null) {
                        this.doSetDocumentGalleryResources(userCtx, contentOid, docTranslation.getOid(), pubOid, gallery);
                    }
                }
                catch (R01MContentModelObjectsValidatorException ex) {
                    R01FLog.to((String)LOG_TYPE_ID).info("ERROR al copiar las galerias del documento : " + ex.getMessage());
                }
            }
            this._sendHistoryMessage(userCtx.getUserName(), content, (R01MBaseDocumentInterface)srcDoc, null, 1, 21, "Copia del documento " + srcDoc.getInternalName() + " a " + newInternalName + " realizado correctamente.");
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return docTranslation;
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException((Exception)((Object)dsEx));
        }
    }

    public List<R01MDocument> doCopyDocumentInto(R01MUserContext userCtx, String contentOid, String sourceDocumentOid, String targetDocumentOid, boolean copyAttachment) throws R01MDuplicateDocumentException, R01MContentModelException {
        String opDesc = "Copia del documento original " + sourceDocumentOid + " al documento destino " + targetDocumentOid + " en el " + "contenido " + contentOid + ". Copiar adjuntos : " + copyAttachment;
        try {
            R01MContent content;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            if ((content = this.doLoadContent(userCtx, contentOid)) == null) {
                throw new R01MContentModelException("NO se ha podido cargar el contenido " + contentOid);
            }
            R01MDocument srcDoc = content.getDocument(sourceDocumentOid);
            if (srcDoc == null) {
                throw new R01MContentModelException("NO se ha podido cargar el documento origen " + sourceDocumentOid + " del contenido " + contentOid);
            }
            R01MDocument dstDoc = content.getDocument(targetDocumentOid);
            if (dstDoc == null) {
                throw new R01MContentModelException("NO se ha podido cargar el documento destino " + targetDocumentOid + " del contenido " + contentOid);
            }
            R01DContentModelObjectsCopyHelper contCopyHelper = new R01DContentModelObjectsCopyHelper(this);
            List<R01MDocument> result = null;
            try {
                result = contCopyHelper.copyDocumentInto(userCtx, content, srcDoc, dstDoc, copyAttachment);
            }
            catch (R01MDuplicateModelObjectException dupObjEx) {
                if (dupObjEx instanceof R01MDuplicateDocumentException) {
                    throw (R01MDuplicateDocumentException)dupObjEx;
                }
            }
            catch (R01MDeleteModelObjectException delObjEx) {
            }
            catch (R01MDirtyContentModelException ex) {
                // empty catch block
            }
            this._sendHistoryMessage(userCtx.getUserName(), content, (R01MBaseDocumentInterface)srcDoc, null, 1, 21, "Copia del documento " + srcDoc.getOid() + " a " + dstDoc.getOid() + " realizado correctamente.");
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return result;
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException((Exception)((Object)dsEx));
        }
    }

    public R01MDocument doSetDocumentInitialPage(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid) throws R01MContentModelException {
        R01MContent content;
        String opDesc = "Establecer el fichero de datos " + dataFileOid + " como fichero de inicio en el documento " + documentOid + " del contenido " + contentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        if ((content = this.doLoadContent(userCtx, contentOid)) == null) {
            throw new R01MContentModelException("NO se ha podido cargar el contenido " + contentOid);
        }
        R01MDocument document = content.getDocument(documentOid);
        if (document == null) {
            throw new R01MContentModelException("NO se ha podido cargar el documento " + documentOid + " del contenido " + contentOid);
        }
        for (Map.Entry meDataFile : document.getDataFiles().entrySet()) {
            R01MDataFile datafile = (R01MDataFile)meDataFile.getValue();
            if (datafile.getOid().equals(dataFileOid)) {
                datafile.setInitialPage(1);
                continue;
            }
            datafile.setInitialPage(0);
        }
        R01MDocument newDocument = content.getDocument(documentOid);
        try {
            this.doSaveDocument(userCtx, contentOid, newDocument);
        }
        catch (R01MDeleteModelObjectException delEx) {
        }
        catch (R01MDuplicateModelObjectException dupEx) {
        }
        catch (R01MSecurityException secEx) {
        }
        catch (R01MDirtyContentModelException ex) {
            // empty catch block
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end): " + opDesc);
        }
        return newDocument;
    }

    public R01MLinkedResourcesGroup doSetDocumentLinkedResources(R01MUserContext userCtx, String contentOid, String documentOid, String docPublishRepoOid, R01MLinkedResourcesGroup documentLinkedResourcesGroup, Map inversePresentationTagIds, boolean generateHTMLAsync) throws R01MContentModelException, R01MContentModelObjectsValidatorException {
        HashMap documentLinkedResources;
        String opDesc = "Asociando los recursos de vinculaci\u00f3n al documento '" + documentOid + "' del contenido '" + contentOid + "'";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        HashMap newDocumentLinkedResources = documentLinkedResourcesGroup.getResources();
        if (documentLinkedResourcesGroup.getResources() == null) {
            newDocumentLinkedResources = new HashMap();
        }
        ArrayList<String> documentRelations = new ArrayList<String>();
        for (R01MLinkedResource currResource : newDocumentLinkedResources.values()) {
            if (currResource instanceof R01MLinkedResource) {
                R01MLinkUtils.composeHtmlLinks((R01MLink)currResource.getLink());
                if (!StringUtils.isEmptyString((String)currResource.getRelatedDocumentContentOid())) {
                    if (currResource.getRelatedDocumentContentOid().equals(contentOid)) {
                        throw new R01MContentModelObjectsValidatorException("El contenido no puede tener relaciones consigo mismo....");
                    }
                    if (documentRelations.contains(currResource.getRelatedDocumentDocumentOid())) {
                        throw new R01MContentModelObjectsValidatorException("El contenido ya estaba relacionado con el documento '" + currResource.getRelatedDocumentDocumentOid() + "' no puede volver a relacionarse.");
                    }
                    documentRelations.add(currResource.getRelatedDocumentDocumentOid());
                }
            } else {
                throw new R01MContentModelObjectsValidatorException("Existe un recurso que no es del tipo vinculaciones.");
            }
            currResource.validateObject();
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Validaci\u00f3n de objetos realizada con exito para el documento con oid: " + documentOid + " del contenido " + contentOid);
        }
        R01MContent content = this.doLoadContent(userCtx, contentOid);
        R01DLinkedResourcesManager manager = new R01DLinkedResourcesManager();
        if (!newDocumentLinkedResources.isEmpty()) {
            manager.validateResourcesContainer(content.getStoreLocation().getWorkAreaOid(), content.getTypo().getTypeOid(), newDocumentLinkedResources);
        }
        if ((documentLinkedResources = this.doGetDocumentLinkedResources(userCtx, documentOid).getResources()) == null) {
            documentLinkedResources = new HashMap();
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("XML de vinculaciones obtenido documento con oid: " + documentOid + " del contenido " + contentOid);
        }
        Collection[] changes = CollectionUtils.obtainChangesInMap(documentLinkedResources, newDocumentLinkedResources);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Identificar los recursos a borrar,crear o actualizar documento con oid: " + documentOid + " del contenido " + contentOid);
        }
        HashMap<String, Object> paramObj = new HashMap<String, Object>();
        paramObj.put("content", content);
        paramObj.put("documentOid", documentOid);
        paramObj.put("docPublishRepoOid", docPublishRepoOid);
        paramObj.put("titleGroup", documentLinkedResourcesGroup.getTitleGroupLabel() != null ? documentLinkedResourcesGroup.getTitleGroupLabel() : "");
        paramObj.put("inversePresentationTagIds", inversePresentationTagIds);
        if (changes[0] != null) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Nuevos recursos documento con oid: " + documentOid + " del contenido " + contentOid);
            }
            for (String resourceOid : changes[0]) {
                if (!((R01MLinkedResource)newDocumentLinkedResources.get(resourceOid)).isRelationOwner()) continue;
                String relationOid = null;
                try {
                    relationOid = manager.onLinkToObject(userCtx, (R01MResourceInterface)((R01MLinkedResource)newDocumentLinkedResources.get(resourceOid)), paramObj);
                }
                catch (R01MLinkResourcesException lnkExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error al vincular el recurso '" + resourceOid + "' al documento '" + documentOid + "'.Error:" + lnkExc.getMessage());
                }
                if (relationOid == null) continue;
                ((R01MLinkedResource)newDocumentLinkedResources.get(resourceOid)).setRelatedDocumentLinkedResourceOid(relationOid);
            }
        }
        if (changes[2] != null) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Modificar recursos documento con oid: " + documentOid + " del contenido " + contentOid);
            }
            for (String resourceOid : changes[2]) {
                if (!((R01MLinkedResource)documentLinkedResources.get(resourceOid)).isRelationOwner()) continue;
                try {
                    manager.onUpdatedLinkInObject(userCtx, (R01MResourceInterface)documentLinkedResources.get(resourceOid), (R01MResourceInterface)newDocumentLinkedResources.get(resourceOid), paramObj);
                }
                catch (R01MLinkResourcesException lnkExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error al actualizar el v\u00ednculo del recurso '" + resourceOid + "' al documento '" + documentOid + "'.Error:" + lnkExc.getMessage());
                }
            }
        }
        if (changes[1] != null) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Borrar recursos documento con oid: " + documentOid + " del contenido " + contentOid);
            }
            for (String resourceOid : changes[1]) {
                R01MLinkedResource linkedResourceToRemove = (R01MLinkedResource)documentLinkedResources.get(resourceOid);
                if (!linkedResourceToRemove.isRelationOwner()) continue;
                try {
                    manager.onUnlinkFromObject(userCtx, (R01MResourceInterface)linkedResourceToRemove, paramObj);
                }
                catch (R01MLinkResourcesException lnkExc) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error al eliminar el v\u00ednculo del recurso '" + resourceOid + "' al documento '" + documentOid + "'.Error:" + lnkExc.getMessage());
                }
            }
        }
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Actualiza la persistencia de la informaci\u00f3n (Base de Datos y XML de IW) documento con oid: " + documentOid + " del contenido " + contentOid);
            }
            manager.saveResourcesObjectInfo(userCtx, newDocumentLinkedResources, paramObj);
        }
        catch (R01MLinkResourcesException lnkExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al actualizar la informaci\u00f3n de vinculaci\u00f3n del documento '" + documentOid + "'.Error:" + lnkExc.getMessage());
            throw new R01MContentModelException("Error al actualizar la informaci\u00f3n de vinculaci\u00f3n del documento '" + documentOid + "'.", (Exception)((Object)lnkExc));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Actualizar los recursos en el objeto documento con oid: " + documentOid + " del contenido " + contentOid);
        }
        documentLinkedResourcesGroup.setResources(newDocumentLinkedResources);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Generar el HTML de vinculaciones para el documento '" + documentOid + "' de forma " + (generateHTMLAsync ? "ASINCRONA" : "SINCRONA"));
        }
        if (!generateHTMLAsync) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Identificar los contenedores previos para borrar el html generado si ya no existen recursos en el contenedor.");
            }
            ArrayList<String> originalResourcesContainers = new ArrayList<String>();
            if (!documentLinkedResources.isEmpty()) {
                Iterator itResources = documentLinkedResources.values().iterator();
                while (itResources.hasNext()) {
                    String containerId = ((R01MLinkedResource)itResources.next()).getContainerId();
                    if (originalResourcesContainers.contains(containerId)) continue;
                    originalResourcesContainers.add(containerId);
                }
            }
            paramObj.put("originalResourcesContainers", originalResourcesContainers);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Contenedores de recursos previos al procesado:" + originalResourcesContainers);
            }
            try {
                ArrayList<String> repositories = new ArrayList<String>();
                repositories.add(docPublishRepoOid);
                manager.onFinishRenderPresentationFile(userCtx, newDocumentLinkedResources, paramObj, true, repositories);
            }
            catch (R01MLinkResourcesException lnkExc) {
                R01FLog.to((String)LOG_TYPE_ID).warning("Error al generar el HTML con la informaci\u00f3n de vinculaci\u00f3n del documento '" + documentOid + "'.Error:" + lnkExc.getMessage());
            }
        } else {
            R01DLinkedResourcesManager lnkManager = new R01DLinkedResourcesManager();
            lnkManager.notifyNewLinkedRelationsInContent(content.getOid(), documentOid, docPublishRepoOid, 3, null, null);
        }
        List indexers = new ArrayList();
        indexers = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/default/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer"));
        System.out.println("#### Enviar petici\u00f3n de indexaci\u00f3n de indexersConfigurations/default/indexer ####");
        R01MIndexDefinition indexDef = new R01MIndexDefinition();
        indexDef.setIndexType(0);
        indexDef.setIndexers(indexers);
        indexDef.setObjectOid(documentOid);
        indexDef.setObjectType(1);
        indexDef.setIndexFilesToPublish(XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentServices/contentDirectories/contentFilesPathsAndNames/docLinkedIndexFile", (String)"content-linked.idx"));
        indexDef.setPublishIndexData(true);
        ArrayList<String> repositoryOids = new ArrayList<String>();
        repositoryOids.add(docPublishRepoOid);
        indexDef.setRepositoryOids(repositoryOids);
        indexDef.setPublicationType(0);
        indexDef.setPublicationDate(R01MDateUtils.today());
        try {
            R01PClientFactory.getSearchEngineIndexerAPI().index(indexDef, R01MConstants.CONTENT_INDEXER_MANAGER);
        }
        catch (R01MSearchIndexerException srchExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la indexacion del documento '" + documentOid + "'.Error:" + srchExc.getMessage());
            throw new R01MContentModelException("Error en la indexacion del documento '" + documentOid + "'.", (Exception)((Object)srchExc));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end): " + opDesc);
        }
        return documentLinkedResourcesGroup;
    }

    public void doRenderAndPublishDocumentLinkedResources(R01MUserContext userCtx, String contentOid, String documentOid, List repositories) throws R01MContentModelException {
        String opDesc = "Renderizar y republicar los recursos de vinculaciones del documento '" + documentOid + "'.";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01DLinkedResourcesManager manager = new R01DLinkedResourcesManager();
        R01MLinkedResourcesGroup resourcesGroup = this.doGetDocumentLinkedResources(userCtx, documentOid);
        HashMap<String, Object> paramObj = new HashMap<String, Object>();
        paramObj.put("content", this.doLoadContent(userCtx, contentOid));
        paramObj.put("documentOid", documentOid);
        paramObj.put("titleGroup", resourcesGroup.getTitleGroupLabel());
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info(" Identificar los contenedores previos para borrar el html generado si ya no existen recursos en el contenedor, para el (contenido;documento) (" + contentOid + ";" + documentOid + ")");
        }
        ArrayList<String> originalResourcesContainers = new ArrayList<String>();
        if (!resourcesGroup.getResources().isEmpty()) {
            for (R01MLinkedResource resource : resourcesGroup.getResources().values()) {
                String containerId = resource.getContainerId();
                if (originalResourcesContainers.contains(containerId)) continue;
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("A\u00f1adir el contenedor " + containerId);
                }
                originalResourcesContainers.add(containerId);
            }
        }
        paramObj.put("originalResourcesContainers", originalResourcesContainers);
        try {
            manager.onFinishRenderPresentationFile(userCtx, resourcesGroup.getResources(), paramObj, true, repositories);
        }
        catch (R01MLinkResourcesException lnkEx) {
            lnkEx.printStackTrace(System.out);
            throw new R01MContentModelException(lnkEx.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end): " + opDesc);
        }
    }

    public R01MLinkedResourcesGroup doGetDocumentLinkedResources(R01MUserContext userCtx, String documentOid) throws R01MContentModelException {
        R01MLinkedResourcesGroup resources;
        String opDesc = "Obtener los recursos de vinculaciones del documento '" + documentOid + "'.";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
        try {
            resources = loaderHelper.loadDocumentLinkedResourcesFromDBXML(documentOid);
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end): " + opDesc);
        }
        return resources;
    }

    public R01MLinkedRelationsGroup doGetDocumentAvailableLinkedRelations(R01MUserContext userCtx, String documentSrcOid, String documentDstOid, String containerId) throws EJBException, R01MContentModelException {
        String opDesc = "Obtener las relaciones de vinculacion permitidas entre los documentos '" + documentSrcOid + "' y '" + documentDstOid + "'.";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01MLinkedRelationsGroup availableRelations = null;
        try {
            availableRelations = R01MClientFactory.getLinkedRelationsConfigAPI().getLinkedRelationsConfig();
        }
        catch (Exception cfgExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar la configuracion de las relaciones: " + cfgExc.getMessage());
            cfgExc.printStackTrace(System.out);
            throw new R01MContentModelException("Error al cargar la configuracion de las relaciones. Error:" + cfgExc.getMessage());
        }
        if (availableRelations != null) {
            R01FLog.to((String)LOG_TYPE_ID).info("La informacion de las relaciones es:\r\n");
            List containerLinkedResources = this.doGetDocumentLinkedResources(userCtx, documentSrcOid).getContainerLinkedResources(containerId);
            for (R01MLinkedResource currResource : containerLinkedResources) {
                if (!currResource.getRelatedDocumentDocumentOid().equals(documentDstOid)) continue;
                availableRelations.getRelations().remove(currResource.getRelationId());
            }
        } else {
            R01FLog.to((String)"r01m.test").severe("NO EXISTEN RELACIONES.Revisar la configuracion");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end): " + opDesc);
        }
        return availableRelations;
    }

    public void doSetDocumentGalleryResources(R01MUserContext userCtx, String contentOid, String documentOid, String docPublishRepoOid, R01MGallery gallery) throws R01MContentModelException, R01MContentModelObjectsValidatorException {
        String opDesc = "Asociando los recursos de tipo galer\u00eda al documento '" + documentOid + "' del contenido '" + contentOid + "'";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        if (gallery != null) {
            Map newDocumentGalleryResources = gallery.getResources() != null ? gallery.getResources() : new HashMap();
            R01MContent content = this.doLoadContent(userCtx, contentOid);
            R01DGalleryResourcesManager manager = new R01DGalleryResourcesManager();
            manager.validateContainer(content.getStoreLocation().getWorkAreaOid(), content.getTypo().getTypeOid(), gallery.getContainerId());
            Map currentDocumentGalleries = this.doGetDocumentGalleryResources(userCtx, documentOid).getGalleries();
            Map documentGalleryResources = null;
            if (currentDocumentGalleries.containsKey(gallery.getId())) {
                documentGalleryResources = ((R01MGallery)currentDocumentGalleries.get(gallery.getId())).getResources();
            }
            if (documentGalleryResources == null) {
                documentGalleryResources = new HashMap();
            }
            Collection[] changes = CollectionUtils.obtainChangesInMap(documentGalleryResources, (Map)newDocumentGalleryResources);
            HashMap<String, Object> paramObj = new HashMap<String, Object>();
            paramObj.put("content", content);
            paramObj.put("documentOid", documentOid);
            paramObj.put("resources", newDocumentGalleryResources);
            if (changes[0] != null) {
                for (String resourceOid : changes[0]) {
                    try {
                        manager.onLinkToObject(userCtx, (R01MResourceInterface)newDocumentGalleryResources.get(resourceOid), paramObj);
                    }
                    catch (R01MLinkResourcesException lnkExc) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("Error al agregar el recurso '" + resourceOid + "' a la galer\u00eda '" + gallery.getId() + "' del documento '" + documentOid + "'.Error:" + lnkExc.getMessage());
                    }
                }
            }
            if (changes[2] != null) {
                for (String resourceOid : changes[2]) {
                    R01MGalleryResource newGalleryResource = (R01MGalleryResource)newDocumentGalleryResources.get(resourceOid);
                    R01MGalleryResource oldGalleryResource = (R01MGalleryResource)documentGalleryResources.get(resourceOid);
                    try {
                        manager.onUpdatedLinkInObject(userCtx, (R01MResourceInterface)oldGalleryResource, (R01MResourceInterface)newGalleryResource, paramObj);
                    }
                    catch (R01MLinkResourcesException lnkExc) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("Error al actualizar el recurso '" + resourceOid + "' de la galer\u00eda '" + gallery.getId() + "' del documento '" + documentOid + "'.Error:" + lnkExc.getMessage());
                    }
                }
            }
            if (changes[1] != null) {
                for (String resourceOid : changes[1]) {
                    R01MResourceInterface galleryResourceToRemove = (R01MResourceInterface)documentGalleryResources.get(resourceOid);
                    try {
                        manager.onUnlinkFromObject(userCtx, galleryResourceToRemove, null);
                    }
                    catch (R01MLinkResourcesException lnkExc) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("Error al eliminar el recurso '" + resourceOid + "' de la galer\u00eda '" + gallery.getId() + "' del documento '" + documentOid + "'.Error:" + lnkExc.getMessage());
                        throw new R01MContentModelException("Error al eliminar el recurso '" + resourceOid + "' de la galer\u00eda '" + gallery.getId() + "' del documento '" + documentOid + "'.", (Exception)((Object)lnkExc));
                    }
                }
            }
            try {
                paramObj = new HashMap();
                paramObj.put("content", content);
                paramObj.put("documentOid", documentOid);
                paramObj.put("galleryId", gallery.getId());
                currentDocumentGalleries.put(gallery.getId(), gallery);
                paramObj.put("galleries", currentDocumentGalleries);
                manager.saveResourcesObjectInfo(userCtx, paramObj);
            }
            catch (R01MLinkResourcesException lnkExc) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error actualizar la informaci\u00f3n de la galer\u00eda '" + gallery.getId() + "' del documento '" + documentOid + "'.Error:" + lnkExc.getMessage());
                throw new R01MContentModelException("Error actualizar la informaci\u00f3n de la galer\u00eda '" + gallery.getId() + "' del documento '" + documentOid + "'.", (Exception)((Object)lnkExc));
            }
            ArrayList<R01MJmsQueueParam> params = new ArrayList<R01MJmsQueueParam>();
            try {
                params.add(new R01MJmsQueueParam(1, "galleryXML", (Object)XOManager.getXML((String)R01MConstants.LINK_MAPFILE, (Object)gallery)));
            }
            catch (XOMarshallerException e) {
                R01FLog.to((String)LOG_TYPE_ID).warning("Error al crear el renderizado del HTML de galerias.Error:" + e.getMessage());
            }
            this._sendRenderMessage(userCtx, content, content.getDocument(documentOid), "gallery", null, params);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end): " + opDesc);
            }
        }
    }

    public R01MGalleryResourcesGroup doGetDocumentGalleryResources(R01MUserContext userCtx, String documentOid) throws R01MContentModelException {
        R01MGalleryResourcesGroup resources;
        String opDesc = "Obtener los recursos de galer\u00edas del documento '" + documentOid + "'.";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
        try {
            resources = loaderHelper.loadDocumentGalleryResourcesFromDBXML(documentOid);
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end): " + opDesc);
        }
        return resources;
    }

    public R01MContent doLoadContentDataFileLazy(R01MUserContext userCtx, R01MContent inContent, String documentOid, String dataFileOid) throws R01MContentModelException {
        String opDesc = "Carga ligera del archivo de datos " + dataFileOid + " del documento " + documentOid + " en el contenido " + inContent.getOid();
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
            R01MDataFile dataFile = loaderHelper.loadDocumentDataFileLazy(documentOid, dataFileOid);
            R01MDocument theDoc = null;
            if (inContent.getDocuments() != null) {
                theDoc = (R01MDocument)inContent.getDocuments().get(documentOid);
            }
            if (theDoc != null && theDoc.getDataFiles() == null) {
                theDoc.setDataFiles(new HashMap());
            }
            if (theDoc != null && theDoc.getDataFiles() != null) {
                theDoc.getDataFiles().put(dataFile.getOid(), dataFile);
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return inContent;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public String doGetDataFileParentDocument(String dataFileOid) throws R01MContentModelException {
        String opDesc = "Obtener el documento padre del dataFile " + dataFileOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DEjbModelHierarchyNavigator modelNavigator = new R01DEjbModelHierarchyNavigator();
            String docOid = modelNavigator.executeGetDataFileParentDocumentOid(dataFileOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return docOid;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public void doGenerateDataFileUsingAllPresentationTemplates(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid) throws R01MContentModelException {
        this.doGenerateDataFileContent(userCtx, contentOid, documentOid, dataFileOid, false, true, "", false, false);
    }

    public void doGenerateDataFileUsingAllPresentationTemplates(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, boolean syncWorkflow) throws R01MContentModelException {
        this.doGenerateDataFileContent(userCtx, contentOid, documentOid, dataFileOid, false, true, "", syncWorkflow, false);
    }

    public void doGenerateDataFileUsingPresentationTemplate(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, String presentationTemplateOid) throws R01MContentModelException {
        this.doGenerateDataFileContent(userCtx, contentOid, documentOid, dataFileOid, false, false, presentationTemplateOid, false, false);
    }

    public void doGenerateDataFileUsingPresentationTemplate(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, String presentationTemplateOid, boolean syncWorkflow) throws R01MContentModelException {
        this.doGenerateDataFileContent(userCtx, contentOid, documentOid, dataFileOid, false, false, presentationTemplateOid, syncWorkflow, false);
    }

    public int doGetStateOfGeneratedDatafile(R01MUserContext userCtx, String dataFileOid) throws R01MContentModelException {
        R01DEjbContentModelLoader loader = new R01DEjbContentModelLoader();
        try {
            return loader.executeGetDataFileStateOfGeneration(dataFileOid);
        }
        catch (R01DContentModelPersistenceException sqlExc) {
            sqlExc.printStackTrace(System.out);
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la consulta del estado de la regeneraci\u00f3n del datafile " + dataFileOid + ".Error:" + sqlExc.getMessage());
            throw new R01MContentModelException("No se puede consultar el estado de generaci\u00f3n del dataFile.Error:" + sqlExc.getMessage());
        }
    }

    public void doGenerateRenders(R01MUserContext userCtx, R01MContent content, R01MDocument document, String renderGroup, String renderId) throws R01MContentModelException {
        this._sendRenderMessage(userCtx, content, document, renderGroup, renderId, null);
    }

    public void doGenerateRenders(R01MUserContext userCtx, List<R01MResourcesRenderConfig> renders, Map<String, List<?>> values, Properties props) throws R01MContentModelException {
        String documentLanguage;
        String typeOid;
        String documentOid;
        if (renders == null || renders.isEmpty() || props == null) {
            return;
        }
        String contentOid = props.getProperty("contentOid");
        if (StringUtils.isEmptyString((String)contentOid)) {
            R01FLog.to((String)LOG_TYPE_ID).severe("[RENDER] Error al ejecutar el renderizado. El contentOid no puede ser nulo.");
        }
        if (StringUtils.isEmptyString((String)(documentOid = props.getProperty("documentOid")))) {
            R01FLog.to((String)LOG_TYPE_ID).severe("[RENDER] Error al ejecutar el renderizado. El documentOid no puede ser nulo.");
        }
        if (StringUtils.isEmptyString((String)(typeOid = props.getProperty("typeOid")))) {
            R01FLog.to((String)LOG_TYPE_ID).severe("[RENDER] Error al ejecutar el renderizado. El typeOid no puede ser nulo.");
        }
        if (StringUtils.isEmptyString((String)(documentLanguage = props.getProperty("documentLanguage")))) {
            R01FLog.to((String)LOG_TYPE_ID).severe("[RENDER] Error al ejecutar el renderizado. El documentLanguage no puede ser nulo.");
        }
        for (R01MResourcesRenderConfig render : renders) {
            props.put("renderId", render.getId());
            props.put("container", "default");
            try {
                R01DResourcesRendererInterface renderImpl = (R01DResourcesRendererInterface)ReflectionUtils.getObjectInstance((String)render.getImplClass());
                renderImpl.setProperties(render.getProperties());
                R01DComposeResourceResult htmlRenderResult = renderImpl.render(documentLanguage, values.get(render.getId()), props);
                R01MContentDataAPI contentDataAPI = R01MClientFactory.getContentDataAPI((R01MUserContext)userCtx, (String)contentOid);
                String configFileName = render.getProperties().get("fileName").toString();
                String fileName = R01MVariables.customize((String)configFileName, (Properties)props);
                if (htmlRenderResult != null && htmlRenderResult.getCodeRenderResults() != null && !StringUtils.isEmptyString((String)((StringBuffer)htmlRenderResult.getCodeRenderResults().get("html")).toString())) {
                    contentDataAPI.uploadAttachmentFile(documentOid, fileName, htmlRenderResult.getResourceResultAsInputStream("html"), true);
                    continue;
                }
                contentDataAPI.deleteAttachmentFile(documentOid, fileName);
            }
            catch (ReflectionException ex) {
                R01FLog.to((String)LOG_TYPE_ID).severe("[RENDER] Error al ejecutar el renderizado '" + render.getId() + "' contenido: '" + contentOid + "'.Error:" + ex.getMessage());
            }
            catch (R01DContentModelException e) {
                R01FLog.to((String)LOG_TYPE_ID).severe("[RENDER] Error al ejecutar el renderizado '" + render.getId() + "' contenido: '" + contentOid + "'.Error:" + e.getMessage());
            }
            catch (R01MSecurityException e) {
                R01FLog.to((String)LOG_TYPE_ID).severe("[RENDER] Error al ejecutar el renderizado '" + render.getId() + "' contenido: '" + contentOid + "'.Error:" + e.getMessage());
            }
        }
    }

    public void doGenerateDataFileContent(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, boolean generateAsync, boolean useAllPresentationTemplates, String presentationTemplateOid, boolean syncWorkflow, boolean uploadToDocumentFolder) throws R01MContentModelException {
        R01DEjbCoreModelObjsManager mngr = new R01DEjbCoreModelObjsManager();
        if (generateAsync) {
            R01DEjbContentModelLoader loader = new R01DEjbContentModelLoader();
            try {
                int initState = loader.executeGetDataFileStateOfGeneration(dataFileOid);
                if (initState == 1) {
                    mngr.updateDataFileStateOfGeneration(dataFileOid, 2);
                    return;
                }
                if (initState == 2) {
                    return;
                }
                mngr.updateDataFileStateOfGeneration(dataFileOid, 1);
            }
            catch (R01DContentModelPersistenceException sqlExc) {
                sqlExc.printStackTrace(System.out);
                R01FLog.to((String)LOG_TYPE_ID).severe("Error en la actualizaci\u00f3n del estado de la regeneraci\u00f3n del datafile " + dataFileOid + ".Error:" + sqlExc.getMessage());
                throw new R01MContentModelException("No se puede inicializar el estado de generaci\u00f3n del dataFile.Error:" + sqlExc.getMessage());
            }
            try {
                R01FLog.to((String)LOG_TYPE_ID).info("NOMBRE ASINCRONA ***************************************************** " + userCtx.getUserName());
                this._generateDataFileContentAsync(userCtx, contentOid, documentOid, dataFileOid, useAllPresentationTemplates, presentationTemplateOid, syncWorkflow, uploadToDocumentFolder);
            }
            catch (R01MContentModelException cmExc) {
                try {
                    mngr.updateDataFileStateOfGeneration(dataFileOid, -1);
                }
                catch (R01DContentModelPersistenceException sqlExc) {
                    sqlExc.printStackTrace(System.out);
                    throw new R01MContentModelException("No se puede actualizar el estado de generaci\u00f3n del dataFile.Error:" + sqlExc.getMessage());
                }
                throw cmExc;
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    mngr.updateDataFileStateOfGeneration(dataFileOid, -1);
                }
                catch (R01DContentModelPersistenceException sqlExc) {
                    sqlExc.printStackTrace(System.out);
                    throw new R01MContentModelException("No se puede actualizar el estado de generaci\u00f3n del dataFile.Error:" + sqlExc.getMessage());
                }
                throw new R01MContentModelException("Error en la generaci\u00f3n del contenido del dataFile '" + dataFileOid + ".Error:" + e.getMessage());
            }
        }
        try {
            mngr.updateDataFileStateOfGeneration(dataFileOid, 1);
        }
        catch (R01DContentModelPersistenceException sqlExc) {
            sqlExc.printStackTrace(System.out);
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la actualizaci\u00f3n del estado de la regeneraci\u00f3n del datafile " + dataFileOid + ".Error:" + sqlExc.getMessage());
            throw new R01MContentModelException("No se puede inicializar el estado de generaci\u00f3n del dataFile.Error:" + sqlExc.getMessage());
        }
        try {
            this._generateDataFileContentSync(userCtx, contentOid, documentOid, dataFileOid, useAllPresentationTemplates, presentationTemplateOid, syncWorkflow, 0, uploadToDocumentFolder);
        }
        catch (R01MContentModelException cmExc) {
            try {
                mngr.updateDataFileStateOfGeneration(dataFileOid, -1);
            }
            catch (R01DContentModelPersistenceException sqlExc) {
                sqlExc.printStackTrace(System.out);
                throw new R01MContentModelException("No se puede actualizar el estado de generaci\u00f3n del dataFile.Error:" + sqlExc.getMessage());
            }
            throw cmExc;
        }
        catch (Exception e) {
            try {
                mngr.updateDataFileStateOfGeneration(dataFileOid, -1);
            }
            catch (R01DContentModelPersistenceException sqlExc) {
                sqlExc.printStackTrace(System.out);
                throw new R01MContentModelException("No se puede actualizar el estado de generaci\u00f3n del dataFile.Error:" + sqlExc.getMessage());
            }
            throw new R01MContentModelException("Error en la generaci\u00f3n del contenido del dataFile '" + dataFileOid + ".Error:" + e.getMessage());
        }
    }

    public Map doLoadWorkAreaContents(R01MUserContext userCtx, R01MContentLocation loc) throws R01MContentModelException {
        String opDesc = "Carga de los contenidos de la workArea > " + loc.getServerOid() + ":" + loc.getDataRepositoryOid() + ":" + loc.getAreaOid() + ":" + loc.getWorkAreaOid();
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init):" + opDesc);
            }
            R01DDAOStorageContentsLoader loader = new R01DDAOStorageContentsLoader(userCtx);
            Map outContents = loader.executeLoadWorkareaContentsByType(loc);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end):" + opDesc);
            }
            return outContents;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public String[] doLoadWorkAreaContentsOids(R01MUserContext userCtx, R01MContentLocation loc) throws R01MContentModelException {
        String opDesc = "Carga de los oids de los contenidos de la workArea > " + loc.getServerOid() + ":" + loc.getDataRepositoryOid() + ":" + loc.getAreaOid() + ":" + loc.getWorkAreaOid();
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init):" + opDesc);
            }
            R01DDAOStorageContentsLoader loader = new R01DDAOStorageContentsLoader(userCtx);
            String[] outContentsOids = loader.executeLoadWorkareaContentsOids(loc);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end):" + opDesc);
            }
            return outContentsOids;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public R01MIndexableContent doPrepareContentToBeIndexed(R01MUserContext userCtx, String contentOid) throws R01MSecurityException, R01MContentModelException {
        R01PContentToIndexableConverter converter;
        R01MIndexableContent outIdxCont;
        R01MContent content;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Preparando el contenido " + contentOid + " para su indexaci\u00f3n....");
        }
        if ((content = this.doLoadContent(userCtx, contentOid)) == null) {
            return null;
        }
        try {
            if (content.getStoreLocation() == null || content.getTypo() == null) {
                return null;
            }
            content.getStoreLocation().validateObject();
            content.getTypo().validateObject();
        }
        catch (R01MContentModelObjectsValidatorException cmExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("La tipolog\u00eda o el almacenamiento del contenido " + contentOid + " es incorrecta.Error:" + cmExc.getMessage());
            return null;
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PASO 1: Obtener el contenido indexable");
        }
        if ((outIdxCont = (converter = new R01PContentToIndexableConverter(userCtx, content)).getIndexableContent()) == null) {
            return null;
        }
        boolean copyIndexableXMLToContentFolder = XMLProperties.getBoolean((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentIndexPrepareOps/copyIndexableXMLToContentFolder", (boolean)true);
        if (copyIndexableXMLToContentFolder) {
            R01DContentInDataStore contInDS = new R01DContentInDataStore(userCtx, content);
            this.doUploadIndexableObject(userCtx, content, outIdxCont);
            try {
                boolean copyDataFilesToDocumentFolder = XMLProperties.getBoolean((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentIndexPrepareOps/copyDataFilesToDocumentFolder", (boolean)true);
                if (copyDataFilesToDocumentFolder) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("PASO 3: Copiar los dataFiles desde la carpeta del sistema a la carpeta del documento");
                    }
                    if (content.getDocuments() != null) {
                        for (R01MDocument currDoc : content.getDocuments().values()) {
                            if (currDoc.getDataFiles() == null) continue;
                            for (R01MDataFile currDf : currDoc.getDataFiles().values()) {
                                try {
                                    contInDS.copyDataFileFromSystemAreaToDocumentFolder(currDoc.getOid(), currDf.getOid());
                                }
                                catch (R01MDataStoreException dsEx) {
                                    R01FLog.to((String)LOG_TYPE_ID).warning("Preparacion de la indexacion: NO se ha podido copiar el dataFile " + currDf.getOid() + " del contenido:documento " + contentOid + ":" + currDoc.getOid() + " desde el area de sistema a la carpeta del documento > " + dsEx.getMessage());
                                    dsEx.printStackTrace(System.out);
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex) {
                R01FLog.to((String)LOG_TYPE_ID).severe("NO se puede copiar el dataFile desde la carpeta del sistema a la carpeta del documento: " + ex.getMessage());
                ex.printStackTrace(System.out);
            }
        }
        return outIdxCont;
    }

    public void doUploadIndexableObject(R01MUserContext userCtx, R01MContent content, R01MIndexableContent idxCont) throws R01MContentModelException {
        boolean copyIndexableXMLToContentFolder = XMLProperties.getBoolean((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentIndexPrepareOps/copyIndexableXMLToContentFolder", (boolean)true);
        if (copyIndexableXMLToContentFolder) {
            R01DContentInDataStore contInDS = new R01DContentInDataStore(userCtx, content);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Subir el XML indexable a la carpeta del contenido");
            }
            try {
                String idxDescriptorXML = "<?xml version='1.0' encoding='ISO-8859-1'?>" + XOManager.getXML((String)R01MConstants.INDEXABLEOBJECTS_MAPFILE, (Object)idxCont);
                contInDS.updateIndexableDescriptor(idxDescriptorXML);
            }
            catch (XOMarshallerException xoEx) {
                xoEx.printStackTrace(System.out);
                throw new R01MContentModelException("No se ha podido convertir el contenido indexable en XML: " + xoEx.getMessage());
            }
            catch (R01MDataStoreException dsEx) {
                throw new R01MContentModelException("NO se ha podido subir el XML indexable al dataStore: " + dsEx.getMessage(), (Exception)((Object)dsEx));
            }
        }
    }

    public void doUpdateDocumentAliasesState(R01MUserContext userCtx, String documentOid, int initialState, int finalState) throws R01MContentModelException {
        String opDesc = "Actualiza el estado de los aliases del documento " + documentOid + ". " + "Los aliases con estado " + initialState + " quedar\u00e1n con estado " + finalState;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelUpdateHelper updateHelper = new R01DContentModelUpdateHelper(userCtx);
            updateHelper.updateDocumentAliasesState(documentOid, initialState, finalState);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public Map doGetOperationsGroupByContents(R01MUserContext userCtx, R01MChangesLabelsPacket changesPacket) throws R01MContentModelException, R01MSecurityException {
        if (!this._validateAdminContext(userCtx)) {
            throw new R01MSecurityException("El usuario no tiene permisos para ejecutar esta operaci\u00f3n.");
        }
        try {
            return R01DLabelsListenerSLUtil.getLocalHome().create().doCreateOperationsGroup(changesPacket);
        }
        catch (Exception ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la creaci\u00f3n de los grupos de operaciones.Error:" + ex.getMessage());
            ex.printStackTrace(System.out);
            throw new R01MContentModelException("Error en la creaci\u00f3n de los grupos de operaciones.Error:" + ex.getMessage());
        }
    }

    public R01MBusinessErrors doLoadBusinessErrors(R01MUserContext userCtx, String documentOid) throws R01MSecurityException, R01MContentModelException {
        R01MBusinessErrors bussinesErrors;
        String opDesc = "Cargando los errores de negocio";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DDAOContentModelLoader contentLoader = new R01DDAOContentModelLoader(userCtx);
        try {
            bussinesErrors = contentLoader.executeBusinessErrors(documentOid);
        }
        catch (R01DContentModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar los errores de negocio. Error:" + ex.getMessage());
            ex.printStackTrace(System.out);
            throw new R01MContentModelException("Error al cargar llos errores de negocio. Error:" + ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return bussinesErrors;
    }

    public List doLoadBusinessErrorsList(R01MUserContext userCtx, List documentOids) throws R01MSecurityException, R01MContentModelException {
        List bussinesErrorsList;
        String opDesc = "Cargando los errores de negocio de varios documentos";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DDAOContentModelLoader contentLoader = new R01DDAOContentModelLoader(userCtx);
        try {
            bussinesErrorsList = contentLoader.executeLoadBusinessErrorsList(documentOids);
        }
        catch (R01DContentModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar los errores de negocio. Error:" + ex.getMessage());
            ex.printStackTrace(System.out);
            throw new R01MContentModelException("Error al cargar llos errores de negocio. Error:" + ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return bussinesErrorsList;
    }

    public void doSetBusinessErrors(R01MUserContext userCtx, String documentOid, R01MBusinessErrors documentErrors) throws R01MContentModelException {
        String opDesc = "Errores de negocio";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        if (documentErrors == null) {
            this._removeBusinessErrors(documentOid);
            return;
        }
        R01DBusinessErrorsCMPLocal errorsCMPUtil = null;
        try {
            errorsCMPUtil = R01DBusinessErrorsCMPUtil.getLocalHome().findByPrimaryKey(new R01DBusinessErrorsCMPPK(documentOid));
        }
        catch (FinderException fndExc) {
            this._registerNewBusinessErrors(documentErrors);
            return;
        }
        catch (NamingException namExc) {
            R01FLog.to((String)LOG_TYPE_ID).info("BUSINESSERRORS MANAGER.doSetBusinessErrors > Error al encontrar el CMP de businessErrors:" + namExc.getMessage());
            namExc.printStackTrace(System.out);
            throw new R01MContentModelException("No se encuentra el CMP de los businessErrors. Error:" + namExc.getMessage());
        }
        this._updateBusinessErrors(documentErrors, errorsCMPUtil);
    }

    public String doComposeContentName(R01MUserContext userCtx, String typologyOid, String metadataOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Generando el nombre del contenido";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DTypoMetadataGeneratorHelper miHelp = new R01DTypoMetadataGeneratorHelper(userCtx);
        String contenName = miHelp.obtainComposeMetadataValue(typologyOid, metadataOid);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return contenName;
    }

    public int doGetUiState(R01MUserContext userCtx, String target, String oidDcocument) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Obteniendo el nuevo estado uistate";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DDocumentStateHelper miHelp = new R01DDocumentStateHelper(userCtx);
        int uiState = miHelp.obtainUiState(target, oidDcocument);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return uiState;
    }

    protected void _sendHistoryMessage(String currentUser, R01MContent content, R01MBaseDocumentInterface document, R01MDataFile datafile, int targetObjType, int historyActionOid, String historyNotes) {
        String waPath = "";
        R01DHistoryHelper historyHelper = new R01DHistoryHelper();
        try {
            waPath = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(content.getStoreLocation().getWorkAreaOid()).getAbsolutePath();
            if (HISTORY_BASE_PATH.equals("fileSystem")) {
                waPath = waPath.replaceFirst("//iwmnt", XMLProperties.getProperty((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"history/baseConfigFileSystem", (String)""));
            }
        }
        catch (R01MConfigLoadException ex) {
            R01FLog.to((String)LOG_TYPE_ID).warning("Error al enviar el mensaje de registro del hist\u00f3rico, no se hace nada. Error:" + ex.getMessage());
            return;
        }
        String fileWARelativePath = R01MPathHelpper.getContentWorkAreaRelativePath((R01MContentTypologyInfo)content.getTypo(), (R01MBaseLocationObject)content.getStoreLocation(), (String)content.getOid(), (String)content.getInternalName(), (String)content.getName());
        String targetObjOid = "";
        String targetObjName = "";
        switch (targetObjType) {
            case 0: {
                targetObjOid = content.getOid();
                targetObjName = content.getName();
                fileWARelativePath = fileWARelativePath + historyHelper.getFileName(content, historyActionOid);
                break;
            }
            case 1: {
                targetObjOid = document.getOid();
                targetObjName = document.getLanguage() + "_" + document.getInternalName();
                fileWARelativePath = fileWARelativePath + historyHelper.getFileName(document, historyActionOid);
                break;
            }
            case 2: {
                targetObjOid = datafile.getOid();
                targetObjName = document.getLanguage() + "_" + document.getInternalName() + "/" + datafile.getInternalName();
                fileWARelativePath = fileWARelativePath + historyHelper.getFileName(document, historyActionOid);
            }
        }
        ArrayList<R01MJmsQueueParam> paramList = new ArrayList<R01MJmsQueueParam>();
        paramList.add(new R01MJmsQueueParam(1, "currentUser", (Object)currentUser));
        paramList.add(new R01MJmsQueueParam(1, "contentOid", (Object)content.getOid()));
        paramList.add(new R01MJmsQueueParam(1, "targetObjOid", (Object)targetObjOid));
        paramList.add(new R01MJmsQueueParam(1, "targetObjName", (Object)targetObjName));
        paramList.add(new R01MJmsQueueParam(3, "targetObjType", (Object)Integer.toString(targetObjType)));
        paramList.add(new R01MJmsQueueParam(3, "historyActionOid", (Object)Integer.toString(historyActionOid)));
        paramList.add(new R01MJmsQueueParam(1, "historyNotes", (Object)historyNotes));
        paramList.add(new R01MJmsQueueParam(1, "waPath", (Object)waPath));
        paramList.add(new R01MJmsQueueParam(1, "fileWARelativePath", (Object)fileWARelativePath));
        paramList.add(new R01MJmsQueueParam(3, "operationType", (Object)Integer.toString(0)));
        try {
            R01MJMSUtils.sendJMSMessage((String)"r01ContentHistory", paramList);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Mensaje enviado a r01ContentHistory");
            }
        }
        catch (Exception jmsExc) {
            jmsExc.printStackTrace();
            R01FLog.to((String)LOG_TYPE_ID).warning("Error al enviar el mensaje r01ContentHistory. Error:" + jmsExc.getMessage());
        }
    }

    public R01MContent doChangeContentCatalog(R01MUserContext userCtx, String contentOid, List newLabels) throws R01MContentModelException, R01MSecurityException {
        String opDesc = "Estableciendo catalogaci\u00f3n del contenido";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01MContent content = null;
        if (contentOid != null && (content = R01MClientFactory.getContentModelAPI((R01MUserContext)userCtx).loadContent(contentOid)) != null) {
            ArrayList<R01MStructureCatalog> labelsToSave = new ArrayList<R01MStructureCatalog>();
            for (R01MStructureCatalogPairSelected structureItemCatalog : newLabels) {
                List items;
                try {
                    items = R01MClientFactory.getCatalogAPI((R01MUserContext)userCtx).loadLabelInStructureWithRole(structureItemCatalog.getStructureCatalog().getStructureOid(), structureItemCatalog.getStructureCatalog().getOid(), Integer.parseInt(structureItemCatalog.getStructureCatalog().getRole()));
                }
                catch (NumberFormatException numExc) {
                    numExc.printStackTrace(System.out);
                    throw new R01MContentModelException("Error al obtener las catalogaciones, el nivel '" + structureItemCatalog.getStructureCatalog().getRole() + "' no es un valor num\u00e9rico. Error:" + numExc.getMessage());
                }
                catch (R01MCatalogException catExc) {
                    throw new R01MContentModelException("Error al obtener las catalogaciones heredadas de la estructura '" + structureItemCatalog.getStructureCatalog().getStructureOid() + "', y etiqueta '" + structureItemCatalog.getStructureCatalog().getOid() + "'.", (Exception)((Object)catExc));
                }
                if (items != null && !items.isEmpty()) {
                    R01MStructureItem structureItem = (R01MStructureItem)items.get(0);
                    labelsToSave.add(new R01MStructureCatalog(structureItem.getStructureGuid(), structureItem.getRootLabelOid(), structureItem.getRole() + ""));
                    if (structureItemCatalog.isSelectParentLabels() && structureItem.getParent() != null) {
                        R01MStructureItem structureItemParent = structureItem.getParent();
                        labelsToSave.add(new R01MStructureCatalog(structureItemParent.getStructureGuid(), structureItemParent.getRootLabelOid(), structureItemParent.getRole() + ""));
                        while (structureItemParent.getParent() != null) {
                            structureItemParent = structureItemParent.getParent();
                            labelsToSave.add(new R01MStructureCatalog(structureItemParent.getStructureGuid(), structureItemParent.getRootLabelOid(), structureItemParent.getRole() + ""));
                        }
                    }
                }
                content.setLabels(labelsToSave);
                try {
                    R01MClientFactory.getContentModelAPI((R01MUserContext)userCtx).saveContent(content);
                }
                catch (Exception ex) {
                    R01FLog.to((String)"r01d.operationlauncher").info("ADMIN SERVER ERROR: no se ha podido realizar la catalogaci\u00f3n con las etiquetas seleccionadas debido a " + ex.getMessage());
                    throw new R01MContentModelException("Error al realizar la catalogaci\u00f3n con las etiquetas seleccionadas. Error:" + ex.getMessage());
                }
                if (!DEBUG) continue;
                R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end): nuevas etiquetas seleccionadas");
            }
        }
        return content;
    }

    public List<R01MNotice> doGetActiveNotices(R01MUserContext userCtx, String lang) throws R01MContentModelException {
        R01DNoticeHelper noticeHelper = new R01DNoticeHelper(userCtx);
        List<R01MNotice> activeNotices = noticeHelper.getActiveNotices(lang);
        if (activeNotices == null || activeNotices.isEmpty()) {
            return null;
        }
        Map<String, R01MNotice> noticeRead = this.doGetNoticesReadByUserLazy(userCtx);
        for (R01MNotice notice : activeNotices) {
            if (noticeRead == null || noticeRead.isEmpty() || !noticeRead.containsKey(notice.getContentOid())) continue;
            notice.setReadByUser(true);
        }
        return activeNotices;
    }

    public List<R01MNotice> doGetNoticesNotReadByUser(R01MUserContext userCtx, String lang) throws R01MContentModelException {
        R01DNoticeHelper noticeHelper = new R01DNoticeHelper(userCtx);
        List<R01MNotice> activeNotices = noticeHelper.getActiveNotices(lang);
        if (activeNotices == null || activeNotices.isEmpty()) {
            return null;
        }
        Map<String, R01MNotice> noticeRead = this.doGetNoticesReadByUserLazy(userCtx);
        ArrayList<R01MNotice> noticeNotRead = new ArrayList<R01MNotice>();
        for (R01MNotice notice : activeNotices) {
            if (noticeRead != null && !noticeRead.isEmpty() && noticeRead.containsKey(notice.getContentOid())) continue;
            notice.setReadByUser(false);
            noticeNotRead.add(notice);
        }
        return noticeNotRead;
    }

    public void doSetNoticeReadByUser(R01MUserContext userCtx, List readList) throws R01MContentModelException {
        R01DNoticeCMPLocalHome home;
        R01DNoticeHelper noticeHelper = new R01DNoticeHelper(userCtx);
        try {
            home = R01DNoticeCMPUtil.getLocalHome();
        }
        catch (NamingException namEx) {
            throw new R01MContentModelException("Error al encontrar el home del CMP de avisos: " + namEx.getMessage(), (Exception)namEx);
        }
        R01DNoticeCMPLocal noticeCMP = null;
        try {
            noticeCMP = home.findByPrimaryKey(new R01DNoticeCMPPK(userCtx.getUserName()));
        }
        catch (FinderException findEx) {
            R01DNoticeCMPValue vo = new R01DNoticeCMPValue();
            vo.setUserId(userCtx.getUserName());
            vo.setContentsReadOids(noticeHelper.convertContentsOidToString(null, readList));
            try {
                home.create(vo);
            }
            catch (CreateException ex) {
                throw new R01MContentModelException("Error al crear el home del CMP de avisos: " + ex.getMessage(), (Exception)((Object)ex));
            }
            return;
        }
        String init = noticeCMP.getContentsReadOids() != null ? noticeCMP.getContentsReadOids() : "";
        String oidList = init + noticeHelper.convertContentsOidToString(noticeCMP.getContentsReadOids(), readList);
        int startClean = 70;
        String[] oidContents = null;
        if (!StringUtils.isEmptyString((String)oidList) && (oidContents = oidList.split(";")).length >= startClean) {
            oidList = noticeHelper.cleanExpiredNotice(oidList, userCtx.getUserLang());
        }
        R01DNoticeCMPValue vo = noticeCMP.getR01DNoticeCMPValue();
        vo.setContentsReadOids(oidList);
        noticeCMP.setR01DNoticeCMPValue(vo);
    }

    public Map<String, R01MNotice> doGetNoticesReadByUserLazy(R01MUserContext userCtx) throws R01MContentModelException {
        R01DNoticeCMPValue noticeVO;
        R01DNoticeCMPLocal noticeCMP = null;
        try {
            noticeCMP = R01DNoticeCMPUtil.getLocalHome().findByPrimaryKey(new R01DNoticeCMPPK(userCtx.getUserName()));
        }
        catch (FinderException findEx) {
            return null;
        }
        catch (NamingException namEx) {
            throw new R01MContentModelException("Error al encontrar el home del CMP de avisos: " + namEx.getMessage(), (Exception)namEx);
        }
        String[] noticeReadFromBBDD = null;
        if (noticeCMP != null && !StringUtils.isEmptyString((String)(noticeVO = noticeCMP.getR01DNoticeCMPValue()).getContentsReadOids())) {
            noticeReadFromBBDD = noticeVO.getContentsReadOids().split(";");
        }
        HashMap<String, R01MNotice> noticeRead = new HashMap<String, R01MNotice>();
        if (noticeReadFromBBDD != null && noticeReadFromBBDD.length > 0) {
            for (int i = 0; i < noticeReadFromBBDD.length; ++i) {
                R01MNotice notice = new R01MNotice();
                notice.setContentOid(noticeReadFromBBDD[i]);
                notice.setReadByUser(true);
                noticeRead.put(notice.getContentOid(), notice);
            }
        }
        return noticeRead;
    }

    private boolean _validateAdminContext(R01MUserContext userCtx) {
        if (userCtx == null) {
            return false;
        }
        return userCtx.getUserProfile().equals("masterSystem");
    }

    private boolean _validateContent(R01MContent content) throws R01MContentModelException {
        if (StringUtils.isEmptyString((String)content.getOid())) {
            return false;
        }
        if (content.getStoreLocation() == null) {
            return false;
        }
        return content.getTypo() != null;
    }

    private boolean _validateCatalogationsContent(R01MContent content, R01MUserContext userCtx) throws R01MContentModelException, R01MSecurityException {
        boolean validate = true;
        if (content.getTypo().getTypeOid().equalsIgnoreCase("anuncio_contratacion")) {
            int processFlag = 1;
            try {
                processFlag = R01MClientFactory.getConfigControllerAPI().doGetProcessFlag(R01PConstants.AC_CATALOG_PROCESS_APLIC, R01PConstants.AC_CATALOG_PROCESS_CLUSTER, R01PConstants.AC_CATALOG_PROCESS_NAME);
            }
            catch (R01MConfigControllerException conEx) {
                R01FLog.to((String)LOG_TYPE_ID).info(DateUtils.getDateFormated((Date)R01MDateUtils.today(), (String)TRACE_FORMAT) + "CHEQUEO CATALOGACIONES: Error al obtener el flag para el chequeo de las catalogaciones del tipo anuncion_contratacion:" + conEx.getMessage());
            }
            if (processFlag == 99 || processFlag == 0) {
                validate = true;
            } else {
                String structureOid = XMLProperties.getProperty((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)("contentCatalogations/contentTypo[@oid='" + content.getTypo().getTypeOid() + "']/structureOid"), (String)"r01epd01197b29fdf84a50ddff1c0947eb523ed9d");
                String labelOid = XMLProperties.getProperty((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)("contentCatalogations/contentTypo[@oid='" + content.getTypo().getTypeOid() + "']/labelOid"), (String)"r01epd01197b2aaddb4a50ddf50f48805bac8fe21");
                List contentStructureCatalog = content.getLabels();
                if (contentStructureCatalog != null && !contentStructureCatalog.isEmpty()) {
                    for (R01MStructureCatalog contentCatalog : contentStructureCatalog) {
                        List labelInStructureWithRole = null;
                        try {
                            labelInStructureWithRole = R01MClientFactory.getCatalogAPI((R01MUserContext)userCtx).loadLabelInStructureWithRole(contentCatalog.getStructureOid(), contentCatalog.getOid(), Integer.parseInt(contentCatalog.getRole()));
                            if (labelInStructureWithRole != null && !labelInStructureWithRole.isEmpty()) continue;
                            validate = false;
                        }
                        catch (R01MCatalogException e) {
                            validate = false;
                            R01FLog.to((String)LOG_TYPE_ID).severe("La catalogaci\u00f3n --> Estructura: '" + contentCatalog.getStructureOid() + "', " + "Label: '" + contentCatalog.getOid() + "' y " + "Rol: '" + contentCatalog.getRole() + "' no existe.");
                        }
                        break;
                    }
                    if (validate) {
                        boolean hasOrganoContratacionStructureOid = false;
                        HashMap<String, R01MStructureCatalog> labelsInOrganoContratacion = new HashMap<String, R01MStructureCatalog>();
                        for (R01MStructureCatalog contentCatalog : contentStructureCatalog) {
                            if (!contentCatalog.getStructureOid().equalsIgnoreCase(structureOid)) continue;
                            hasOrganoContratacionStructureOid = true;
                            if (!labelsInOrganoContratacion.containsKey(contentCatalog.getRole())) {
                                labelsInOrganoContratacion.put(contentCatalog.getRole(), contentCatalog);
                                continue;
                            }
                            validate = false;
                            R01FLog.to((String)LOG_TYPE_ID).severe("El contenido " + content.getOid() + " tiene dos etiquetas de la estructura Poder Adjudicador/Organo de Contratacion con el mismo role !!!!");
                            break;
                        }
                        if (validate && hasOrganoContratacionStructureOid && labelsInOrganoContratacion.size() >= 3) {
                            if (labelsInOrganoContratacion.containsKey("1") && labelsInOrganoContratacion.containsKey("2") && labelsInOrganoContratacion.containsKey("3")) {
                                if (((R01MStructureCatalog)labelsInOrganoContratacion.get("2")).getOid().equalsIgnoreCase(labelOid) && !labelsInOrganoContratacion.containsKey("4")) {
                                    validate = false;
                                    R01FLog.to((String)LOG_TYPE_ID).severe("El contenido " + content.getOid() + " en la estructura Poder Adjudicador/Organo de Contrataci\u00f3n que es de Gobierno Vasco no tiene etiqueta en role 4 !!!");
                                }
                            } else {
                                validate = false;
                                R01FLog.to((String)LOG_TYPE_ID).severe("El contenido " + content.getOid() + " no tiene etiquetas en la estructura Poder Adjudicador/Organo de Contrataci\u00f3n de role 1,2 y 3 !!!");
                            }
                            if (validate) {
                                // empty if block
                            }
                        } else if (validate) {
                            validate = false;
                            R01FLog.to((String)LOG_TYPE_ID).severe("El contenido " + content.getOid() + " debe de estar catalogado en la Estructura: '" + structureOid + "' (Poder Adjudicador/Organo de Contrataci\u00f3n) y adem\u00e1s que al menos sean 3.");
                        }
                    }
                } else {
                    validate = false;
                    R01FLog.to((String)LOG_TYPE_ID).severe("El contenido " + content.getOid() + " debe de estar catalogado!!!!");
                }
            }
        }
        return validate;
    }

    private R01MContent _mergeContentObjects(R01MUserContext userCtx, R01MContent initialContent, R01MContent updatedContent) throws R01MContentModelException {
        R01MContent outContent;
        R01MContent r01MContent = outContent = initialContent != null ? initialContent : updatedContent;
        if (initialContent != null && updatedContent != null && updatedContent.getDocuments() != null) {
            for (R01MDocument doc : updatedContent.getDocuments().values()) {
                if (outContent.getDocuments() != null && outContent.getDocuments().containsKey(doc.getOid())) continue;
                outContent.addDocument(doc);
            }
            if (outContent.getDocuments() != null && !outContent.getDocuments().isEmpty()) {
                for (R01MDocument doc : outContent.getDocuments().values()) {
                    R01MDocument updatedDoc = updatedContent.getDocument(doc.getOid());
                    this._mergeDocumentObjects(userCtx, doc, updatedDoc);
                }
            }
        }
        return outContent;
    }

    private R01MDocument _mergeDocumentObjects(R01MUserContext userCtx, R01MDocument initialDocument, R01MDocument updatedDocument) throws R01MContentModelException {
        R01MDocument outDocument;
        R01MDocument r01MDocument = outDocument = initialDocument != null ? initialDocument : updatedDocument;
        if (initialDocument != null && updatedDocument != null && updatedDocument.getDataFiles() != null) {
            for (R01MDataFile dataFile : updatedDocument.getDataFiles().values()) {
                if (outDocument.getDataFiles() != null && outDocument.getDataFiles().containsKey(dataFile.getOid())) continue;
                outDocument.addDataFile(dataFile);
            }
        }
        return outDocument;
    }

    private void _doRemoveLinkedRelations(R01MUserContext userCtx, Set<String> documentsToRemoveLinkedRelations) {
        if (documentsToRemoveLinkedRelations != null && !documentsToRemoveLinkedRelations.isEmpty()) {
            R01DLinkedResourcesManager manager = new R01DLinkedResourcesManager();
            for (String currDocumentOid : documentsToRemoveLinkedRelations) {
                try {
                    R01MLinkedResourcesGroup linkedResources = this.doGetDocumentLinkedResources(userCtx, currDocumentOid);
                    if (linkedResources == null || linkedResources.getResources() == null || linkedResources.getResources().isEmpty()) continue;
                    for (R01MLinkedResource currLinkedResource : linkedResources.getResources().values()) {
                        if (StringUtils.isEmptyString((String)currLinkedResource.getRelatedDocumentContentOid()) || StringUtils.isEmptyString((String)currLinkedResource.getRelatedDocumentDocumentOid())) continue;
                        manager.notifyNewLinkedRelationsInContent(currLinkedResource.getRelatedDocumentContentOid(), currLinkedResource.getRelatedDocumentDocumentOid(), currLinkedResource.getRelatedDocumentContentRepositoryOid(), 0, currLinkedResource.getRelatedDocumentLinkedResourceOid(), null);
                    }
                }
                catch (R01MContentModelException cmExc) {
                    R01FLog.to((String)LOG_TYPE_ID).warning("Error al tratar las vinculaciones del documento '" + currDocumentOid + "', no seran actualizadas.");
                }
            }
        }
    }

    private boolean _isUnpublishDocumentRunning(Object objectToUpdate) {
        ArrayList<R01MDocument> documents = new ArrayList<R01MDocument>();
        if (objectToUpdate instanceof R01MDocument) {
            documents.add((R01MDocument)objectToUpdate);
        } else if (objectToUpdate instanceof R01MContent && ((R01MContent)objectToUpdate).getDocuments() != null && !((R01MContent)objectToUpdate).getDocuments().values().isEmpty()) {
            for (R01MDocument document : ((R01MContent)objectToUpdate).getDocuments().values()) {
                documents.add(document);
            }
        }
        boolean isUnpublishDocumentRunning = false;
        if (documents != null && !documents.isEmpty()) {
            block1: for (R01MDocument document : documents) {
                List publicationInfo = document.getPublicationInfo();
                if (publicationInfo == null || publicationInfo.isEmpty()) continue;
                for (R01MDocumentPublicationTarget documentPublication : publicationInfo) {
                    if (documentPublication.getState() != 5) continue;
                    isUnpublishDocumentRunning = true;
                    continue block1;
                }
            }
        }
        return isUnpublishDocumentRunning;
    }

    private boolean _saveDataBaseDocumentAlias(R01MUserContext userCtx, R01MDocument initialDocument, R01MDocument document, List<R01MURLAlias> requestedAliases) throws R01MContentModelException {
        Map requestedAliasesMap;
        String documentOid = document.getOid();
        ArrayList aliasToCreate = requestedAliases == null ? new ArrayList() : new ArrayList<R01MURLAlias>(requestedAliases);
        ArrayList<R01MURLAlias> aliasInDB = initialDocument == null ? null : initialDocument.getUrlAliases();
        boolean sendAliasMessage = false;
        List<R01MURLAlias> aliasDeletedBD = null;
        try {
            aliasDeletedBD = this.doLoadDocumentAliasesInState(userCtx, documentOid, 0);
            if (aliasDeletedBD != null && !aliasDeletedBD.isEmpty()) {
                if (aliasInDB == null) {
                    aliasInDB = new ArrayList<R01MURLAlias>();
                }
                aliasInDB.addAll(aliasDeletedBD);
            }
        }
        catch (R01MSecurityException ex1) {
        }
        catch (R01MContentModelException ex1) {
            // empty catch block
        }
        Map aliasInDBMap = new HashMap();
        if (aliasInDB != null) {
            try {
                aliasInDBMap = CollectionUtils.convertListIntoMap((List)aliasInDB, (String)"oid", (boolean)false);
            }
            catch (CollectionConverterException ccEx) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("ALIAS: salvando en BD los alias del documento " + documentOid + ". " + "Error al componer los datos actuales y " + "nuevos para la comparaci\u00f3n: " + ccEx.getMessage());
                }
                ccEx.printStackTrace(System.out);
                throw new R01MContentModelException("Error al convertir la lista de alias de BD del documento '" + documentOid + " a mapa. " + "Error:" + ccEx.getMessage());
            }
        }
        try {
            requestedAliasesMap = CollectionUtils.convertListIntoMap(aliasToCreate, (String)"oid", (boolean)false);
        }
        catch (CollectionConverterException ccEx) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).severe("ALIAS: salvando en BD los alias del documento " + documentOid + ". " + "Error al componer los datos actuales y " + "nuevos para la comparaci\u00f3n: " + ccEx.getMessage());
            }
            ccEx.printStackTrace(System.out);
            throw new R01MContentModelException("Error al convertir la lista de alias nuevos del documento '" + documentOid + " a mapa.Error:" + ccEx.getMessage());
        }
        Collection[] changes = CollectionUtils.obtainChangesInMap(aliasInDBMap, (Map)requestedAliasesMap);
        if (changes[0] != null) {
            for (String oidAliasToCreate : changes[0]) {
                R01MURLAlias newAlias = (R01MURLAlias)requestedAliasesMap.get(oidAliasToCreate);
                for (R01MURLAlias alias : aliasInDBMap.values()) {
                    if (!newAlias.getAlias().equals(alias.getAlias()) || newAlias.getOid().equals(alias.getOid())) continue;
                    this._removeAlias(alias.getOid(), documentOid);
                    break;
                }
                this._createAlias(newAlias, documentOid);
            }
            sendAliasMessage = true;
        }
        if (changes[1] != null) {
            for (String oidAliasToRemove : changes[1]) {
                R01MURLAlias aliasToRemove = (R01MURLAlias)aliasInDBMap.get(oidAliasToRemove);
                if (aliasToRemove == null) continue;
                this._updateAlias((R01MURLAlias)aliasInDBMap.get(oidAliasToRemove), documentOid, 0);
            }
            sendAliasMessage = true;
        }
        if (changes[2] != null) {
            for (String oidAliasToUpdate : changes[2]) {
                R01MURLAlias requestedAlias = (R01MURLAlias)requestedAliasesMap.get(oidAliasToUpdate);
                R01MURLAlias aliasInBD = (R01MURLAlias)aliasInDBMap.get(oidAliasToUpdate);
                if (requestedAlias.getAlias().equals(aliasInBD.getAlias()) && requestedAlias.isBaseAlias() == aliasInBD.isBaseAlias()) continue;
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("Se actualiza el alias " + requestedAlias.getAlias());
                }
                boolean existAliasInBD = false;
                for (R01MURLAlias alias : aliasInDBMap.values()) {
                    if (!requestedAlias.getAlias().equals(alias.getAlias())) continue;
                    existAliasInBD = true;
                    if (requestedAlias.getOid().equals(alias.getOid())) break;
                    this._removeAlias(alias.getOid(), documentOid);
                    break;
                }
                if (!existAliasInBD) {
                    R01MURLAlias newAlias = new R01MURLAlias(aliasInBD.getAlias(), aliasInBD.getUrl(), aliasInBD.getDomain(), aliasInBD.getLang());
                    this._createAlias(newAlias, documentOid);
                    this._updateAlias(newAlias, documentOid, 0);
                }
                this._updateAlias(requestedAlias, documentOid, 1);
                sendAliasMessage = true;
            }
        }
        return sendAliasMessage;
    }

    private void _createAlias(R01MURLAlias alias, String documentOid) throws R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Se mete el alias " + alias.getAlias() + "en BD");
        }
        try {
            R01DDocumentAliasCMPValue aliasVO = new R01DDocumentAliasCMPValue();
            aliasVO.setOid(alias.getOid());
            aliasVO.setAlias(alias.getAlias());
            aliasVO.setDocumentOid(documentOid);
            aliasVO.setUrl(alias.getUrl());
            aliasVO.setBaseAlias(alias.isBaseAlias() ? 1 : 0);
            aliasVO.setState(1);
            R01DDocumentAliasCMPUtil.getLocalHome().create(aliasVO);
        }
        catch (CreateException crtEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("ALIAS (" + alias.getAlias() + ") >> Error al crear el alias.");
            crtEx.printStackTrace(System.out);
            throw new R01MContentModelException("Error al crear el alias '" + alias.getAlias() + ".Error:" + crtEx.getMessage());
        }
        catch (NamingException nameEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el EJB que gestiona los alias del documento " + documentOid + ". " + "Error:" + nameEx.getMessage());
            nameEx.printStackTrace(System.out);
            throw new R01MContentModelException("No se encuentra el EJB que gestiona los alias del documento " + documentOid + ". " + "Error:" + nameEx.getMessage());
        }
    }

    private void _removeAlias(String aliasOid, String documentOid) throws R01MContentModelException {
        R01DDocumentAliasCMPLocal documentAliasCMPLocal;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Se marca para eliminar el alias de oid " + aliasOid);
        }
        try {
            documentAliasCMPLocal = R01DDocumentAliasCMPUtil.getLocalHome().findByPrimaryKey(new R01DDocumentAliasCMPPK(aliasOid));
        }
        catch (FinderException fndExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al borrar el alias '" + aliasOid + "' del documento '" + documentOid + "'.");
            fndExc.printStackTrace(System.out);
            throw new R01MContentModelException("Error al borrar el alias '" + aliasOid + ".Error:" + fndExc.getMessage());
        }
        catch (NamingException nameEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el EJB que gestiona los alias del documento " + documentOid + ". " + "Error:" + nameEx.getMessage());
            nameEx.printStackTrace(System.out);
            throw new R01MContentModelException("No se encuentra el EJB que gestiona los alias del documento " + documentOid + ". " + "Error:" + nameEx.getMessage());
        }
        try {
            documentAliasCMPLocal.remove();
        }
        catch (EJBException EjbEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error:" + EjbEx.getMessage());
            EjbEx.printStackTrace(System.out);
            throw new R01MContentModelException("Error:" + EjbEx.getMessage());
        }
        catch (RemoveException removeEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se ha podido eliminar el alias del documento " + documentOid + ". " + "Error:" + removeEx.getMessage());
            removeEx.printStackTrace(System.out);
            throw new R01MContentModelException("No se ha podido eliminar el alias del documento " + documentOid + ". " + "Error:" + removeEx.getMessage());
        }
    }

    private void _updateAlias(R01MURLAlias alias, String documentOid, int state) throws R01MContentModelException {
        R01DDocumentAliasCMPLocal documentAliasCMPLocal;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Se marca para actualizar el alias de oid " + alias.getOid());
        }
        try {
            documentAliasCMPLocal = R01DDocumentAliasCMPUtil.getLocalHome().findByPrimaryKey(new R01DDocumentAliasCMPPK(alias.getOid()));
        }
        catch (FinderException fndExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al actualizar del alias '" + alias.getOid() + "' del documento '" + documentOid + "'.");
            fndExc.printStackTrace(System.out);
            throw new R01MContentModelException("Error al actualizar del alias '" + alias.getOid() + ".Error:" + fndExc.getMessage());
        }
        catch (NamingException nameEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("No se encuentra el EJB que gestiona los alias del documento " + documentOid + ". " + "Error:" + nameEx.getMessage());
            nameEx.printStackTrace(System.out);
            throw new R01MContentModelException("No se encuentra el EJB que gestiona los alias del documento " + documentOid + ". " + "Error:" + nameEx.getMessage());
        }
        R01DDocumentAliasCMPValue aliasInDBCMPvalue = documentAliasCMPLocal.getR01DDocumentAliasCMPValue();
        aliasInDBCMPvalue.setAlias(alias.getAlias());
        aliasInDBCMPvalue.setDocumentOid(documentOid);
        aliasInDBCMPvalue.setUrl(alias.getUrl());
        aliasInDBCMPvalue.setBaseAlias(state == 0 ? 0 : (alias.isBaseAlias() ? 1 : 0));
        aliasInDBCMPvalue.setState(state);
        documentAliasCMPLocal.setR01DDocumentAliasCMPValue(aliasInDBCMPvalue);
    }

    private void _registerNewBusinessErrors(R01MBusinessErrors businessErrors) throws R01MContentModelException {
        R01DBusinessErrorsCMPValue packageVO = new R01DBusinessErrorsCMPValue();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("PACKAGE MANAGER (" + businessErrors.getDocumentOid() + ") >> Mapeo ");
        }
        packageVO.setDocumentOid(businessErrors.getDocumentOid());
        StringBuffer dataXML = new StringBuffer();
        try {
            dataXML.append(XOManager.getXML((String)R01MConstants.CONTENTMODEL_MAPFILE, (Object)businessErrors));
        }
        catch (XOMarshallerException xoExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("MANAGER(" + businessErrors.getDocumentOid() + ") > Error al mapear el objeto empaquetado a XML. Error:" + xoExc.getMessage());
            xoExc.printStackTrace(System.out);
            throw new R01MContentModelException("Error al mapear el objeto businessErrors a XML: " + xoExc.getMessage());
        }
        packageVO.setXMLErrors(dataXML.toString());
        try {
            R01DBusinessErrorsCMPUtil.getLocalHome().create(packageVO);
        }
        catch (CreateException crtExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("MANAGER > Error al registrar los errores de negocio del documento (" + businessErrors.getDocumentOid() + "). Error:" + crtExc.getMessage());
            crtExc.printStackTrace(System.out);
            throw new R01MContentModelException(crtExc.getMessage());
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al encontrar el CMP de businessErrors. Error:" + namEx.getMessage());
            namEx.printStackTrace(System.out);
            return;
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MANAGER > Registrando el businessErrors (" + businessErrors.getDocumentOid() + ").");
        }
    }

    private void _removeBusinessErrors(String documentOid) throws R01MContentModelException {
        try {
            R01DBusinessErrorsCMPUtil.getLocalHome().findByPrimaryKey(new R01DBusinessErrorsCMPPK(documentOid)).remove();
        }
        catch (EJBException ejbEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("MANAGER (" + documentOid + ") > DELETE > Error en CMP del businessErrors.");
            ejbEx.printStackTrace(System.out);
            throw new R01MContentModelException("Error al borrar los errores de negocio " + documentOid + ": " + ejbEx.getMessage());
        }
        catch (RemoveException remEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("MANAGER (" + documentOid + ") > DELETE > No se puede borrar los errores de negocio.");
            remEx.printStackTrace(System.out);
            throw new R01MContentModelException("No se puede borrar el error de negocio " + documentOid + ": " + remEx.getMessage());
        }
        catch (FinderException findEx) {
            R01FLog.to((String)LOG_TYPE_ID).info("MANAGER (" + documentOid + ")> El documento no tiene errores de negocio.");
        }
        catch (NamingException namEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("MANAGER (" + documentOid + ")> DELETE > Error al localizar el home del CMP del empaquetado.");
            namEx.printStackTrace(System.out);
            throw new R01MContentModelException("Error al localizar el home del CMP de empaquetado: " + namEx.getMessage());
        }
    }

    private void _updateBusinessErrors(R01MBusinessErrors businessErrors, R01DBusinessErrorsCMPLocal errorsCMPUtil) throws R01MContentModelException {
        StringBuffer dataXML = new StringBuffer();
        try {
            dataXML.append(XOManager.getXML((String)R01MConstants.CONTENTMODEL_MAPFILE, (Object)businessErrors));
        }
        catch (XOMarshallerException xoExc) {
            R01FLog.to((String)LOG_TYPE_ID).severe("MANAGER(" + businessErrors.getDocumentOid() + ") > Error al mapear el objeto businessErrors a XML. Error:" + xoExc.getMessage());
            xoExc.printStackTrace(System.out);
            throw new R01MContentModelException("Error al mapear el objeto businessErrors a XML: " + xoExc.getMessage());
        }
        R01DBusinessErrorsCMPValue packageVO = new R01DBusinessErrorsCMPValue();
        packageVO.setDocumentOid(businessErrors.getDocumentOid());
        packageVO.setXMLErrors(dataXML.toString());
        errorsCMPUtil.setR01DBusinessErrorsCMPValue(packageVO);
    }

    public R01MLinkedResource doGetLinkedTranslated(R01MLinkedResource srcLink, String dstLang, String translateDocumentOid) throws R01MContentModelException {
        R01MLinkedResource dstLink = null;
        if (!StringUtils.isEmptyString((String)dstLang)) {
            int type = srcLink.getLinkType();
            boolean existLink = false;
            try {
                dstLink = (R01MLinkedResource)R01MDozerMappingUtils.map((String)R01MConstants.CONTENTMANAGER_APPCODE, (Object)srcLink, R01MLinkedResource.class);
            }
            catch (Exception ex) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al hacer el mapping de la URL");
                ex.printStackTrace(System.out);
                throw new R01MContentModelException("Error al hacer el mapping de la URL. Error:" + ex.getMessage());
            }
            Matcher matcher = null;
            StringBuffer buf = new StringBuffer();
            boolean cambiado = false;
            block5 : switch (type) {
                case 8: {
                    break;
                }
                case 5: {
                    if (StringUtils.isEmptyString((String)srcLink.getLinkUrl())) break;
                    try {
                        int opeLnkResYear = Integer.parseInt(dstLink.getLink().getFirstLinkItem().getNewsLetterPart(R01MConstantsReferencerConfig.NEWSLETTER_PUBLISHYEAR_KEY));
                        int opeLnkResMonth = Integer.parseInt(dstLink.getLink().getFirstLinkItem().getNewsLetterPart(R01MConstantsReferencerConfig.NEWSLETTER_PUBLISHMONTH_KEY));
                        int opeLnkResNumberCode = Integer.parseInt(dstLink.getLink().getFirstLinkItem().getNewsLetterPart(R01MConstantsReferencerConfig.NEWSLETTER_NUMBERCODE_KEY));
                        String opeLnkResLang = dstLink.getLink().getFirstLinkItem().getNewsLetterPart(R01MConstantsReferencerConfig.NEWSLETTER_LANG_KEY);
                        if (opeLnkResYear <= 2011 && (opeLnkResYear != 2011 || opeLnkResMonth <= 7 && (opeLnkResMonth != 7 || opeLnkResNumberCode < 3444))) break;
                        if ("a".equals(opeLnkResLang)) {
                            if (!"eu".equals(dstLang)) break;
                            dstLink.getLink().getFirstLinkItem().setUrl(StringUtils.replaceString((String)dstLink.getLinkUrl(), (String)"a.pdf", (String)"e.pdf"));
                            break;
                        }
                        if ("eu".equals(dstLang)) break;
                        dstLink.getLink().getFirstLinkItem().setUrl(StringUtils.replaceString((String)dstLink.getLinkUrl(), (String)"e.pdf", (String)"a.pdf"));
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        R01FLog.to((String)LOG_TYPE_ID).warning("Error al obtener las partes del bolet\u00edn. No se puede traducuir el v\u00ednculo:. Error:" + ex.getMessage());
                    }
                    break;
                }
                case 3: {
                    if (StringUtils.isEmptyString((String)srcLink.getLinkUrl())) break;
                    R01MPortalURL url = new R01MPortalURL(srcLink.getLinkUrl());
                    if (!StringUtils.isEmptyString((String)url.getPortalCode())) {
                        buf.append('/').append(url.getPortalCode()).append('-').append(url.getPageCode()).append('/').append(dstLang);
                        cambiado = true;
                    }
                    if (StringUtils.isEmptyString((String)url.getURLPart("queryType"))) break;
                    buf.append('?').append(url.getURLPart("queryType")).append('=');
                    String queryValue = url.getURLPart("queryValue");
                    String patternStr = "(.*documentLanguage\\.EQ\\.)([^.;&,]+)(.*)";
                    Pattern pattern = Pattern.compile(patternStr);
                    matcher = pattern.matcher(queryValue);
                    if (matcher.find()) {
                        buf.append(matcher.group(1));
                        buf.append(dstLang);
                        buf.append(matcher.group(3));
                    }
                    cambiado = true;
                    break;
                }
                case 1: {
                    String patternStr;
                    Pattern pattern;
                    if (StringUtils.isEmptyString((String)srcLink.getLinkUrl()) || !(matcher = (pattern = Pattern.compile(patternStr = "^(?:(http)://)?(?:([^/]+))?/([^-/]+)-([^/]+)/([^/]+)/?$")).matcher(srcLink.getLinkUrl())).find()) break;
                    buf.append('/').append(matcher.group(3)).append('-').append(matcher.group(4)).append('/').append(dstLang);
                    cambiado = true;
                    break;
                }
                case 2: {
                    if (StringUtils.isEmptyString((String)srcLink.getLinkUrl())) break;
                    R01MPortalURL contentUrl = new R01MPortalURL((String)srcLink.getLink().getFirstLinkItem().getData().get("url"));
                    R01MSearchedDocuments srchDoc = new R01MSearchedDocuments();
                    srchDoc.setContentOid(srcLink.getRelatedDocumentContentOid());
                    srchDoc.setInternalName(contentUrl.getURLPart("documentInternalName"));
                    try {
                        R01DDAOContentModelLoader loader = new R01DDAOContentModelLoader();
                        List docsResume = loader.executeSearchDocuments(srchDoc);
                        R01MDocument docResume = this._obtainDocumentResumeLangVersion(docsResume, dstLang);
                        if (docResume == null) break;
                        dstLink.getLink().setLinks(new ArrayList());
                        dstLink.linkToContent(srcLink.getRelatedDocumentContentOid(), docResume.getOid());
                        dstLink.setLinkType(2);
                        dstLink.setRelatedDocumentLinkedResourceOid(null);
                        if (StringUtils.isEmptyString((String)translateDocumentOid)) break;
                        R01MLinkedResourcesGroup lnkResGroupVersion = null;
                        try {
                            lnkResGroupVersion = this.doGetDocumentLinkedResources(R01MAuthManager.createMasterSystemUserContext(), translateDocumentOid);
                            for (R01MLinkedResource lnkResVersion : lnkResGroupVersion.getResources().values()) {
                                if (!dstLink.getRelatedDocumentDocumentOid().equals(lnkResVersion.getRelatedDocumentDocumentOid())) continue;
                                dstLink.setOid(lnkResVersion.getOid());
                                dstLink.setRelatedDocumentLinkedResourceOid(lnkResVersion.getRelatedDocumentLinkedResourceOid());
                                existLink = true;
                                break block5;
                            }
                        }
                        catch (R01MSecurityException ex) {
                            R01FLog.to((String)LOG_TYPE_ID).info("Error de seguridad al cargar v\u00ednculos del documento " + translateDocumentOid);
                        }
                    }
                    catch (R01DContentModelPersistenceException ex) {
                        R01FLog.to((String)LOG_TYPE_ID).warning("Error al cargar los documentos con los criterios seleccinados:." + srchDoc.debugInfo("\t") + " Error:" + ex.getMessage());
                    }
                    break;
                }
            }
            try {
                if (cambiado) {
                    dstLink.setLinkUrl(buf.toString());
                }
                if (!existLink) {
                    dstLink.setOid(R01MUtils.generateNewOid((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"content"));
                }
            }
            catch (GUIDDispenserException guidDispEx) {
                guidDispEx.printStackTrace(System.out);
            }
            if (dstLink != null && dstLink.getLink() != null && dstLink.getLink().getFirstLinkItem() != null) {
                dstLink.getLink().getFirstLinkItem().getData().remove("resourceHTML");
            }
            if (dstLink != null) {
                R01MLinkUtils.composeHtmlLinks((R01MLink)dstLink.getLink());
            } else {
                R01FLog.to((String)LOG_TYPE_ID).warning("V\u00ednculo nulo.");
            }
        }
        return dstLink;
    }

    public List<R01MDocumentPublishResume> doLoadContentDocumentsPublishResume(R01MUserContext userCtx, String contentOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Carga de los documentos para el publicador del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
            List documents = loaderHelper.loadContentDocumentsPublishResume(contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return documents;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public R01MContentPublishResume doLoadContentPublishResume(R01MUserContext userCtx, String contentOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Carga para el publicador del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
            R01MContentPublishResume cont = loaderHelper.loadContentPublishResume(contentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return cont;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public R01MDocumentPublishResume doLoadDocumentPublishResume(R01MUserContext userCtx, String documentOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Carga para el publicador del documento " + documentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentModelLoaderHelper loaderHelper = new R01DContentModelLoaderHelper(userCtx);
            R01MDocumentPublishResume document = loaderHelper.loadDocumentPublishResume(documentOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
            }
            return document;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException(cmEx.getMessage());
        }
    }

    public R01MDocumentPublicationTarget doUpdatePublicationState(R01MContent content, String documentOid, int publicationType, Date publicationDate, String repositoryOid) throws R01MSecurityException, R01MContentModelException {
        R01MDocument document = content.getDocument(documentOid);
        R01MLogicalPublicationInfo logicalPublicationInfo = null;
        try {
            logicalPublicationInfo = R01MClientFactory.getPublisherConfigAPI().getLogicalPublicationConfig(repositoryOid);
        }
        catch (R01MConfigLoadException cfgEx) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar la informaci\u00f3n l\u00f3gica de la publicaci\u00f3n de " + repositoryOid + ". " + "Error: " + cfgEx.getMessage());
            }
            throw new R01MContentModelException((Exception)((Object)cfgEx));
        }
        List<String> logicalDestinationNames = Arrays.asList(logicalPublicationInfo.getDestinationSystemsOids());
        ArrayList<R01MPublicationDestination> publicationDestinationList = new ArrayList<R01MPublicationDestination>(logicalDestinationNames.size());
        for (String logicalDestinationName : logicalDestinationNames) {
            R01MPublicationDestination logicalDest = new R01MPublicationDestination(logicalDestinationName);
            publicationDestinationList.add(logicalDest);
        }
        R01MDataFile datafileInitialPage = document.getDocumentInitialDataFile();
        if (datafileInitialPage == null) {
            throw new R01MContentModelException("\u00a1\u00a1\u00a1 El documento de oid " + document.getOid() + " no tiene ARCHIVO DE INICIO !!!");
        }
        R01MDocumentPublicationTarget newPublicationTarget = new R01MDocumentPublicationTarget();
        newPublicationTarget.setOid(repositoryOid);
        try {
            newPublicationTarget.setPublicationOid(R01MUtils.generateNewOid((String)R01MConstants.PUBLISHER_APPCODE));
        }
        catch (GUIDDispenserException gdEx) {
            gdEx.printStackTrace(System.out);
            throw new R01MContentModelException("Error al crear el OID de publicaci\u00f3n para el documento " + document.getOid() + " en el repositorio " + repositoryOid + " para el tipo de publicaci\u00f3n " + publicationType + ". Error: " + gdEx.getMessage());
        }
        newPublicationTarget.setState(publicationType == 0 || publicationType == 1 ? 4 : 5);
        newPublicationTarget.setPublishDate(publicationDate);
        newPublicationTarget.setUrl(publicationType == 0 || publicationType == 1 ? R01MURLHelpper.getDefaultGeneratedDataFileViewURL((String)document.getLanguage(), (R01MContentTypologyInfo)content.getTypo(), (R01MContentLocation)content.getStoreLocation(), (String)content.getOid(), (String)content.getInternalName(), (String)content.getName(), (String)document.getOid(), (String)document.getLanguage(), (String)document.getInternalName(), (String)datafileInitialPage.getOid(), (String)datafileInitialPage.getInternalName(), (String)datafileInitialPage.getName(), (String)datafileInitialPage.getTemplateOid(), (String)repositoryOid, (String)((R01MPublicationDestination)publicationDestinationList.get(0)).getOid()) : "/");
        ArrayList<R01MDocumentPublicationTarget> docPublicationInfoInDB = document.getPublicationInfo();
        if (docPublicationInfoInDB == null) {
            docPublicationInfoInDB = new ArrayList<R01MDocumentPublicationTarget>();
        } else {
            ArrayList<R01MDocumentPublicationTarget> objectsToRemove = new ArrayList<R01MDocumentPublicationTarget>();
            for (R01MDocumentPublicationTarget publicationInDB : docPublicationInfoInDB) {
                if (!publicationInDB.getOid().equals(repositoryOid) || (publicationInDB.getState() != 4 || publicationType != 1 && publicationType != 0) && (publicationInDB.getState() != 5 || publicationType != 3 && publicationType != 2)) continue;
                R01MPublisherAPI publisherAPI = R01MClientFactory.getPublisherAPI();
                try {
                    if (publicationInDB.getPublishDate() != null && publicationInDB.getPublishDate().after(new Date())) {
                        R01MPublish pub = publisherAPI.obtainPublicationInfoObject(null, document.getOid(), 1, null, null, null, publicationInDB.getOid(), publicationType, publicationInDB.getPublishDate());
                        pub.setOid(publicationInDB.getPublicationOid());
                        publisherAPI.removeDeployment(pub);
                    }
                }
                catch (Exception pEx) {
                    throw new R01MContentModelException("Error al cargar o guardar la informaci\u00f3n de publicaci\u00f3n del documento " + document.getOid() + ": " + pEx.getMessage());
                }
                objectsToRemove.add(publicationInDB);
                break;
            }
            docPublicationInfoInDB.removeAll(objectsToRemove);
        }
        docPublicationInfoInDB.add(newPublicationTarget);
        document.setPublicationInfo(docPublicationInfoInDB);
        return newPublicationTarget;
    }

    private void _publishDocuments(List<String> documentOids, int publicationType, Date publicationDate, List<R01MPublishActionObject> stepsActions, String userName, String pubRepositoryOid) throws R01MContentModelException {
        String opDesc = "Peticion de publicacion/despublicacion de varios documentos.";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        if (publicationType != 0 && publicationType != 2 && publicationType != 1 && publicationType != 3) {
            throw new R01MContentModelException("El tipo de publicaci\u00f3n '" + publicationType + "' es incorrecto. " + "Ver R01MDocumenPublicationRequested");
        }
        if (!(publicationType != 1 && publicationType != 3 || publicationDate != null && !publicationDate.before(R01MDateUtils.today()))) {
            throw new R01MContentModelException("La fecha de publicaci\u00f3n '" + (publicationDate == null ? "null" : publicationDate.toString()) + "' es incorrecta.");
        }
        try {
            if (publicationType == 0 || publicationType == 2) {
                Object[] parameters = new Object[]{documentOids, stepsActions, publicationType, !StringUtils.isEmptyString((String)pubRepositoryOid) ? pubRepositoryOid : "Inter", userName};
                R01PMessagePatternsManagerAPI.runAggregatorDefinition((String)"r01PublishDocuments_inmediate", (Object[])parameters);
            } else if (publicationType == 1 || publicationType == 3) {
                Object[] parameters = new Object[]{documentOids, stepsActions, publicationDate, new Integer(publicationType), !StringUtils.isEmptyString((String)pubRepositoryOid) ? pubRepositoryOid : "Inter", userName};
                R01PMessagePatternsManagerAPI.runAggregatorDefinition((String)"r01PublishDocuments_scheduled", (Object[])parameters);
            }
        }
        catch (R01PMessagePatternsManagerException mgsPattEx) {
            throw new R01MContentModelException("Se ha producido un error al lanzar el objeto de definici\u00f3n correspodiente: " + mgsPattEx.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    private R01MContent _publishDocuments(R01MUserContext userCtx, String contentOid, List<String> documentsToPublishOids, boolean allDocuments, int publicationType, Date publicationDate, boolean onlyPublished, List<R01MPublishActionObject> stepsActions) throws R01MContentModelException {
        R01MContent content;
        String opDesc = "Peticion de publicacion/despublicacion de los documentos del contenido " + contentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        if (publicationType != 0 && publicationType != 2 && publicationType != 1 && publicationType != 3) {
            throw new R01MContentModelException("El tipo de publicaci\u00f3n '" + publicationDate.toString() + "' es incorrecto.Ver R01MDocumenPublicationRequested");
        }
        if (!(publicationType != 1 && publicationType != 3 || publicationDate != null && !publicationDate.before(R01MDateUtils.today()))) {
            throw new R01MContentModelException("La fecha de publicaci\u00f3n '" + (publicationDate != null ? publicationDate.toString() + ", beforeToday es: " + publicationDate.before(R01MDateUtils.today()) + ",today es:" + R01MDateUtils.today() : "null") + "' del tipo '" + publicationType + "' es incorrecta.");
        }
        try {
            content = this.doLoadContent(userCtx, contentOid);
        }
        catch (Exception ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar el contenido de identificador " + contentOid + ".Error:" + ex.getMessage());
            ex.printStackTrace(System.out);
            throw new R01MContentModelException("NO se ha podido cargar el contenido " + contentOid + ".Error:" + ex.getMessage());
        }
        if (content != null && content.getDocuments() != null && !content.getDocuments().isEmpty()) {
            R01MPublicationConfig pub;
            R01DContentModelManager cmManager = new R01DContentModelManager();
            Collection<String> documentsOidToPublish = allDocuments ? content.getDocuments().keySet() : documentsToPublishOids;
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER >> Obteniendo la informaci\u00f3n de publicaci\u00f3n del workarea donde se encuentra el contenido contenido con oid " + content.getOid() + ".");
            }
            try {
                pub = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(content.getStoreLocation().getWorkAreaOid()).getAllowedPublicationTargetsConfig();
            }
            catch (R01MConfigLoadException cfgExc) {
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener los repositorios de publicaci\u00f3n de la workarea. Los documentos del contenido " + content.getOid() + " " + "no se publican. Error:" + cfgExc.getMessage());
                throw new R01MContentModelException("Error al obtener los repositorios de publicaci\u00f3n de la workarea. Los documentos del contenido " + content.getOid() + " " + "no se publican.", (Exception)((Object)cfgExc));
            }
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER >> Obtenida la informaci\u00f3n de publicaci\u00f3n del workarea donde se encuentra el contenido contenido con oid " + content.getOid() + ".");
            }
            if (pub.getAllowedTargets() != null && !pub.getAllowedTargets().isEmpty()) {
                boolean existsPublicationsRequested = false;
                for (String documentOid : documentsOidToPublish) {
                    if (StringUtils.isEmptyString((String)documentOid) || !content.getDocuments().containsKey(documentOid)) continue;
                    for (String targetRepOid : pub.getAllowedTargets().keySet()) {
                        try {
                            if ((onlyPublished || publicationType == 2 || publicationType == 3) && !cmManager.isDocumentPublished(userCtx, targetRepOid, documentOid)) {
                                continue;
                            }
                        }
                        catch (R01MContentModelException ex) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("MODEL SERVER >> Error al validar si el documento " + documentOid + " esta publicado. " + "Error:" + ex.getMessage());
                            throw new R01MContentModelException("Error al validar si el documento " + documentOid + " esta publicado.", (Exception)((Object)ex));
                        }
                        R01MDocumentPublicationRequested pubReq = new R01MDocumentPublicationRequested();
                        pubReq.setRepositoryOid(targetRepOid);
                        pubReq.setOperationType(publicationType);
                        if (publicationType == 0 || publicationType == 2) {
                            pubReq.setOperationDate(R01MDateUtils.today());
                        } else {
                            pubReq.setOperationDate(publicationDate);
                        }
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER >> Registrando la petici\u00f3n de publicaci\u00f3n para el documento " + documentOid + ":" + pubReq.debugInfo(""));
                        }
                        content.getDocument(documentOid).addPublicationRequest(pubReq);
                        try {
                            content.getDocument(documentOid).setRevisionState(cmManager.doRequestDocumentRevision(userCtx, content.getOid(), documentOid));
                        }
                        catch (R01MContentModelException cmExc) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("R01DContentModelManager.doPublishAllDocuments >> Error al solicitar la revisi\u00f3n del documento " + documentOid + ". " + "Error:" + cmExc.getMessage());
                            throw new R01MContentModelException("Error al solicitar la revisi\u00f3n del documento " + documentOid, (Exception)((Object)cmExc));
                        }
                        existsPublicationsRequested = true;
                    }
                }
                if (existsPublicationsRequested) {
                    if (DEBUG) {
                        R01FLog.to((String)LOG_TYPE_ID).info("R01DContentModelManager.doPublishAllDocuments >> Actualizando el contenido " + content.getOid() + " con las peticiones de publicacion.");
                    }
                    try {
                        cmManager.doSaveContent(userCtx, content);
                    }
                    catch (Exception ex) {
                        R01FLog.to((String)LOG_TYPE_ID).severe("R01DContentModelManager.doPublishAllDocuments >> Error al guardar el contenido " + content.getOid() + " " + "con las peticiones de publicacion. " + "Error:" + ex.getMessage());
                        ex.printStackTrace(System.out);
                        throw new R01MContentModelException("Error al guardar el contenido de oid " + content.getOid() + " " + "con las peticiones de publicaci\u00f3n de los documentos.Error:" + ex.getMessage());
                    }
                    for (String documentOid : documentsOidToPublish) {
                        R01MDocument document;
                        if (StringUtils.isEmptyString((String)documentOid) || !content.getDocuments().containsKey(documentOid) || (document = content.getDocument(documentOid)).getRequestedPublications() == null || document.getRequestedPublications().isEmpty()) continue;
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("R01DContentModelManager.doPublishAllDocuments >> Publicando el documento " + documentOid + " " + "del contenido " + content.getOid() + ".");
                        }
                        try {
                            R01MDocumentRevisionState revisionState;
                            while ((revisionState = cmManager.doAproveDocument(userCtx, content, documentOid, stepsActions)).getRemainingRevisions() != 0) {
                            }
                        }
                        catch (Exception ex) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("R01DContentModelManager.doPublishAllDocuments >> Error al publicar el documento " + documentOid + " " + "del contendo " + content.getOid() + ". " + "Error:" + ex.getMessage());
                            ex.printStackTrace(System.out);
                            throw new R01MContentModelException("Error al publicar el documento " + documentOid + " " + "del contenido " + content.getOid() + ". " + "Error:" + ex.getMessage());
                        }
                    }
                }
            }
        } else if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("R01DContentModelManager.doPublishAllDocuments >> El contenido con oid " + content.getOid() + " no tiene ning\u00fan documento por lo que no se realiza ninguna acci\u00f3n");
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
        return content;
    }

    private void _generateDataFileContentAsync(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, boolean useAllPresentationTemplates, String presentationTemplateOid, boolean syncWorkflow, boolean uploadToDocumentFolder) throws R01MContentModelException {
        String opDesc = "Generar el contenido del dataFile " + dataFileOid + " mediante el proceso as\u00edncrono.";
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
            }
            ArrayList<R01MJmsQueueParam> paramList = new ArrayList<R01MJmsQueueParam>();
            paramList.add(new R01MJmsQueueParam(1, "userContextName", (Object)userCtx.getUserName()));
            paramList.add(new R01MJmsQueueParam(1, "contentOid", (Object)contentOid));
            paramList.add(new R01MJmsQueueParam(1, "documentOid", (Object)documentOid));
            paramList.add(new R01MJmsQueueParam(1, "datafileOid", (Object)dataFileOid));
            paramList.add(new R01MJmsQueueParam(2, "useAllPresentationTemplates", (Object)Boolean.toString(useAllPresentationTemplates)));
            paramList.add(new R01MJmsQueueParam(1, "presentationTemplateOid", (Object)presentationTemplateOid));
            paramList.add(new R01MJmsQueueParam(2, "syncWorkflow", (Object)Boolean.toString(syncWorkflow)));
            paramList.add(new R01MJmsQueueParam(2, "uploadToDocumentFolder", (Object)Boolean.toString(uploadToDocumentFolder)));
            R01MJMSUtils.sendJMSMessage((String)"r01GenerateDatafiles", paramList);
        }
        catch (R01MJMSException jmsExc) {
            jmsExc.printStackTrace(System.out);
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al enviar el mensaje de generar el contenido del datafile '" + dataFileOid + "'. Error:" + jmsExc.getMessage());
            throw new R01MContentModelException("Error al enviar el mensaje de generar el contenido del datafile '" + dataFileOid + "'. Error:" + jmsExc.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    private void _generateDataFileContentSync(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, boolean useAllPresentationTemplates, String presentationTemplateOid, boolean syncWorkflow, int numIterations, boolean uploadToDocumentFolder) throws R01MContentModelException {
        int state;
        R01MContent content;
        String opDesc = "Generaci\u00f3n de el/los archivo/s usando las respectivas plantillas del archivo " + dataFileOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (init): " + opDesc);
        }
        if ((content = this.doLoadContent(userCtx, contentOid)) == null) {
            throw new R01MContentModelException("NO se ha podido cargar el contenido " + contentOid);
        }
        try {
            R01DDataFileGenerationHelper genHelper = new R01DDataFileGenerationHelper(userCtx);
            if (useAllPresentationTemplates) {
                genHelper.doGenerateDataFileUsingAllPresentationTemplates(content, documentOid, dataFileOid, syncWorkflow, uploadToDocumentFolder);
            } else {
                genHelper.doGenerateDataFileUsingPresentationTemplate(content, documentOid, dataFileOid, presentationTemplateOid, syncWorkflow, uploadToDocumentFolder);
            }
        }
        catch (R01MDataStoreException dsExc) {
            throw new R01MContentModelException("Error en el gestor de contenidos al generar el/los archivo/s " + content.getOid() + ":" + documentOid + ":" + dataFileOid + " usando " + (useAllPresentationTemplates ? "TODAS las plantillas disponibles." : "la plantilla '" + presentationTemplateOid + "'."), (Exception)((Object)dsExc));
        }
        if (COPY_DATAFILES_TO_DOCUMENTFOLDER) {
            R01DContentInDataStore contentDataStore = new R01DContentInDataStore(userCtx, content);
            try {
                contentDataStore.copyDataFileFromSystemAreaToDocumentFolder(documentOid, dataFileOid);
            }
            catch (R01MDataStoreException dsEx) {
                R01FLog.to((String)LOG_TYPE_ID).warning("Preparacion de la indexacion: NO se ha podido copiar el dataFile " + dataFileOid + " del contenido:documento " + content.getOid() + ":" + documentOid + " desde el area de sistema a la carpeta del documento > " + dsEx.getMessage());
                dsEx.printStackTrace(System.out);
            }
        }
        if (!StringUtils.isEmptyString((String)documentOid) && !StringUtils.isEmptyString((String)dataFileOid)) {
            this._sendHistoryMessage(userCtx.getUserName(), content, (R01MBaseDocumentInterface)content.getDocument(documentOid), content.getDocument(documentOid).getDataFile(dataFileOid), 2, 6, "Archivo " + dataFileOid + " modificado correctamente.");
        }
        R01DEjbContentModelLoader loader = new R01DEjbContentModelLoader();
        R01DEjbCoreModelObjsManager mngr = new R01DEjbCoreModelObjsManager();
        try {
            state = loader.executeGetDataFileStateOfGeneration(dataFileOid);
        }
        catch (R01DContentModelPersistenceException sqlExc) {
            sqlExc.printStackTrace(System.out);
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener el estado de la regeneraci\u00f3n del datafile " + dataFileOid + ".Error:" + sqlExc.getMessage());
            throw new R01MContentModelException("No se puede obtener el estado de generaci\u00f3n del dataFile.Error:" + sqlExc.getMessage());
        }
        if (numIterations < 3 && state == 2) {
            try {
                mngr.updateDataFileStateOfGeneration(dataFileOid, 1);
            }
            catch (R01DContentModelPersistenceException sqlExc) {
                sqlExc.printStackTrace(System.out);
                R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener el estado de la regeneraci\u00f3n del datafile " + dataFileOid + ".Error:" + sqlExc.getMessage());
                throw new R01MContentModelException("No se puede obtener el estado de generaci\u00f3n del dataFile.Error:" + sqlExc.getMessage());
            }
            this._generateDataFileContentSync(userCtx, contentOid, documentOid, dataFileOid, useAllPresentationTemplates, presentationTemplateOid, syncWorkflow, numIterations + 1, uploadToDocumentFolder);
        }
        try {
            mngr.updateDataFileStateOfGeneration(dataFileOid, 3);
            mngr.updateDataFileDateOfGeneration(dataFileOid);
        }
        catch (R01DContentModelPersistenceException sqlExc) {
            sqlExc.printStackTrace(System.out);
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la actualizaci\u00f3n del estado de la regeneraci\u00f3n del datafile " + dataFileOid + ".Error:" + sqlExc.getMessage());
            throw new R01MContentModelException("No se puede obtener el estado y fecha de generaci\u00f3n del dataFile.Error:" + sqlExc.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : " + opDesc);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean _isDocumentInitialDataFileChange(R01MDocument updateDocument, R01MDocument initialDocument) {
        if (updateDocument != null && updateDocument.getDocumentInitialDataFile() != null) {
            if (initialDocument.getDocumentInitialDataFile() == null) return true;
            if (updateDocument.getDocumentInitialDataFile().getInternalName().equals(initialDocument.getDocumentInitialDataFile().getInternalName())) return false;
            return true;
        }
        if (initialDocument.getDocumentInitialDataFile() == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean _isDocumentInitialDataFileURLChange(R01MDocument updateDocument, R01MDocument initialDocument) throws R01MContentModelException {
        if (updateDocument.getDocumentInitialDataFile() != null && !StringUtils.isEmptyString((String)updateDocument.getDocumentInitialDataFile().getGeneratedFileName())) {
            if (initialDocument.getDocumentInitialDataFile() == null || StringUtils.isEmptyString((String)initialDocument.getDocumentInitialDataFile().getGeneratedFileName())) return true;
            if (updateDocument.getDocumentInitialDataFile().getGeneratedFileName().equals(initialDocument.getDocumentInitialDataFile().getGeneratedFileName())) return false;
            return true;
        }
        if (initialDocument.getDocumentInitialDataFile() == null || StringUtils.isEmptyString((String)initialDocument.getDocumentInitialDataFile().getGeneratedFileName())) return false;
        return true;
    }

    private R01MDataStoreManager _obtainDataStoreManager(R01MUserContext userCtx) throws R01MDataStoreException, R01MDataStoreAuthenticationException {
        String dataStoreManagerClassName = XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"dataStoreManager/implClassName");
        try {
            R01MDataStoreAuthObject authenticationObject = new R01MDataStoreAuthObject(R01MConstants.API_APPCODE);
            authenticationObject.fillAuthInfo(R01MConstants.API_APPCODE, userCtx);
            R01MDataStoreManager dsManager = (R01MDataStoreManager)ReflectionUtils.getObjectInstance((String)dataStoreManagerClassName);
            dsManager.doBeginSession(authenticationObject);
            return dsManager;
        }
        catch (ReflectionException refEx) {
            throw new R01MDataStoreException("NO se ha podido instanciar el manager del DataStore con la clase " + dataStoreManagerClassName + ": " + refEx.getMessage(), (Exception)((Object)refEx));
        }
    }

    private R01MDocument _obtainDocumentResumeLangVersion(List<R01MDocument> documentResumeList, String langVersion) {
        try {
            Map documentResumeMap = CollectionUtils.convertListIntoMap(documentResumeList, (String)"language", (boolean)true);
            if (documentResumeMap.containsKey(langVersion)) {
                return (R01MDocument)documentResumeMap.get(langVersion);
            }
            if (documentResumeMap.containsKey("es")) {
                return (R01MDocument)documentResumeMap.get("es");
            }
            if (documentResumeMap.containsKey("eu")) {
                return (R01MDocument)documentResumeMap.get("eu");
            }
            if (!documentResumeMap.isEmpty()) {
                return (R01MDocument)documentResumeMap.entrySet().iterator().next();
            }
        }
        catch (CollectionConverterException collectionConverterException) {
            // empty catch block
        }
        return null;
    }

    private void _createcontentHeader(R01MUserContext userCtx, R01MContent content, R01MDocument document) {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("R01DContentModelManager._createcontentHeader()");
        }
        if (content == null) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la generaci\u00f3n del html de cabecera del contenido: Contenido nulo ");
            return;
        }
        if (document == null) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en la generaci\u00f3n del html de cabecera del contenido: Documento nulo ");
            return;
        }
        StringBuilder contentHeaderLines = new StringBuilder(238);
        if (content.isHideEntityHeader()) {
            contentHeaderLines.append("<!--#set var=\"R01_HIDE_ENTITY_ON_CONTENT_HEADER\" value=\"true\" -->\r\n");
        } else {
            Map contentCatalogForEntities;
            contentHeaderLines.append("<!--#set var=\"R01_HIDE_ENTITY_ON_CONTENT_HEADER\" value=\"false\" -->\r\n");
            if (content != null && content.getLabels() != null && !content.getLabels().isEmpty() && (contentCatalogForEntities = R01MCatalogUtils.getContentCatalogLabelsFromStructure((String)CONTENT_HEADER_ENTITY_STRUCTUREOID_XPATH, (String)content.getOid())) != null && !contentCatalogForEntities.isEmpty()) {
                R01MLabel entityLabel = (R01MLabel)contentCatalogForEntities.values().iterator().next();
                try {
                    R01MEntity entity = R01MClientFactory.getEntitiesConfigAPI().getEntityConfigFromCatalogOid(entityLabel.getOid());
                    if (entity != null) {
                        contentHeaderLines.append("<!--#set var=\"R01_ENTITY\" value=\"").append(entity.getOid()).append("\" -->\r\n");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (content.isHideTypeHeader()) {
            contentHeaderLines.append("<!--#set var=\"R01_HIDE_TYPE_ON_CONTENT_HEADER\" value=\"true\" -->\r\n");
        } else {
            contentHeaderLines.append("<!--#set var=\"R01_HIDE_TYPE_ON_CONTENT_HEADER\" value=\"false\" -->\r\n");
        }
        contentHeaderLines.append("<!--#set var=\"R01_CONTAINER_HEADER_TYPE\" value=\"").append(content.getTypo().getTypeOid()).append("\" -->\r\n<!--#set var=\"R01_DOC_HEADER_LANGUAGE\" value=\"").append(document.getLanguage()).append("\" -->\r\n");
        R01DContentInDataStore contInDS = new R01DContentInDataStore(userCtx, content);
        try {
            contInDS.uploadAttachmentFile(document.getOid(), XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"contentHeader/r01ContHeadDocumentRelativePath", (String)"r01Index/r01ContHead.containerHeader.shtml"), (InputStream)new ByteArrayInputStream(contentHeaderLines.toString().getBytes()));
        }
        catch (R01MDataStoreException dsEx) {
            R01FLog.to((String)LOG_TYPE_ID).warning("Error al crear el fichero de cabecera del contenido. Error:" + dsEx.getMessage());
        }
    }

    public void _reviseDocumentAlias(R01MDocument document) {
        List aliases;
        if (document != null && (aliases = document.getUrlAliases()) != null) {
            for (R01MURLAlias currentAlias : aliases) {
                if (!currentAlias.getAlias().startsWith("/")) continue;
                currentAlias.setAlias(currentAlias.getAlias().replaceAll("^/+", ""));
            }
        }
    }

    private void _updateDocumentFriendlyUrl(R01MUserContext userCtx, R01MDocument initialDocument, R01MDocument document) throws R01MContentModelException {
        if (document != null) {
            R01PAliasManagerAPI aliasAPI;
            boolean isUrlAliasesChanged;
            boolean isDocumentInitialDataFileURLChange;
            boolean isDocumentInitialDataFileChange = initialDocument == null | document == null ? false : this._isDocumentInitialDataFileChange(document, initialDocument);
            boolean bl = isDocumentInitialDataFileURLChange = initialDocument == null | document == null ? false : this._isDocumentInitialDataFileURLChange(document, initialDocument);
            if ((isDocumentInitialDataFileChange || isDocumentInitialDataFileURLChange) && document.getDocumentInitialDataFile() != null && document.getUrlAliases() != null && !document.getUrlAliases().isEmpty()) {
                for (R01MURLAlias urlAlias : document.getUrlAliases()) {
                    StringBuffer buf = new StringBuffer();
                    String patternStr = "(/.*/)[^/]+(\\.s?html)";
                    Pattern pattern = Pattern.compile(patternStr);
                    Matcher matcher = pattern.matcher(urlAlias.getUrl());
                    if (!matcher.find()) continue;
                    buf.append(matcher.group(1));
                    buf.append(document.getDocumentInitialDataFile().getGeneratedFileName());
                    urlAlias.setUrl(buf.toString());
                }
            }
            if (((isUrlAliasesChanged = this._saveDataBaseDocumentAlias(userCtx, initialDocument, document, document.getUrlAliases())) || isDocumentInitialDataFileChange || isDocumentInitialDataFileURLChange) && (aliasAPI = new R01PAliasManagerAPI()).updateDocumentApacheRules(userCtx, document.getOid(), document.getUrlAliases())) {
                this.doUpdateDocumentAliasesState(userCtx, document.getOid(), 1, 2);
            }
        } else if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).warning("R01DContentModelManager._updateDocumentFriendlyUrl(): Ha llegado un documento null" + initialDocument == null ? "" : " para " + initialDocument.getOid());
        }
    }

    private void _sendRenderMessage(R01MUserContext userCtx, R01MContent content, R01MDocument document, String renderGroup, String renderId, List<R01MJmsQueueParam> params) {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("R01DContentModelManager.doSendRenderMessage()");
        }
        if (content == null) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en doSendRenderMessage: Contenido nulo ");
            return;
        }
        if (document == null) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error en doSendRenderMessage: Documento nulo ");
            return;
        }
        try {
            boolean isInitialParamsEmpty = false;
            if (params == null) {
                isInitialParamsEmpty = true;
                params = new ArrayList<R01MJmsQueueParam>();
            }
            params.add(new R01MJmsQueueParam(1, "contentOid", (Object)content.getOid()));
            params.add(new R01MJmsQueueParam(1, "documentOid", (Object)document.getOid()));
            params.add(new R01MJmsQueueParam(1, "typeOid", (Object)content.getTypo().getTypeOid()));
            params.add(new R01MJmsQueueParam(1, "documentLanguage", (Object)document.getLanguage()));
            params.add(new R01MJmsQueueParam(1, "contentName", (Object)content.getName()));
            params.add(new R01MJmsQueueParam(1, "documentInternalName", (Object)document.getInternalName()));
            String renderList = "";
            if (StringUtils.isEmptyString((String)renderId)) {
                R01MResourcesRenderGroup rendererGroup = null;
                try {
                    rendererGroup = R01MDocumentResourcesUtils.getTypologyRenders((String)content.getTypo().getTypeOid(), (String)renderGroup);
                }
                catch (R01MContentModelException e) {
                    // empty catch block
                }
                if (rendererGroup != null && rendererGroup.getRenders() != null && !rendererGroup.getRenders().isEmpty()) {
                    for (R01MResourcesRenderConfig render : rendererGroup.getRenders().values()) {
                        renderList = renderList + ";" + render.getId();
                    }
                }
            } else {
                renderList = renderId;
            }
            String renderType = null;
            String values = null;
            if (renderGroup.equals("saveDocument")) {
                renderType = "r01SaveDocumentRender";
                if (renderList.indexOf("tag") != -1) {
                    values = document.getTags();
                }
                if (renderList.indexOf("dcat") != -1) {
                    try {
                        params.add(new R01MJmsQueueParam(1, "contentXML", (Object)XOManager.getXML((String)R01MConstants.CONTENTMODEL_MAPFILE, (Object)content)));
                    }
                    catch (XOMarshallerException e) {
                        R01FLog.to((String)LOG_TYPE_ID).warning("Error al meter parametro contentXML.Error:" + e.getMessage());
                    }
                }
            } else if (renderGroup.equals("geocatalog")) {
                renderType = "r01GeoCatalogRender";
                try {
                    if (isInitialParamsEmpty) {
                        params.add(new R01MJmsQueueParam(1, "geoCatalogXML", (Object)XOManager.getXML((String)R01MConstants.CONTENTMODEL_MAPFILE, (Object)this.doLoadContentGeoLabels(userCtx, content.getOid()))));
                    }
                }
                catch (XOMarshallerException e) {
                    R01FLog.to((String)LOG_TYPE_ID).warning("Error al meter parametro geoCatalogXML.Error:" + e.getMessage());
                }
                catch (R01MContentModelException e) {
                    R01FLog.to((String)LOG_TYPE_ID).warning("Error al cargar valores del geocatalog.Error:" + e.getMessage());
                }
            } else if (renderGroup.equals("gallery")) {
                renderType = "r01GalleryRender";
                try {
                    R01MGallery gallery;
                    if (isInitialParamsEmpty && (gallery = (R01MGallery)this.doGetDocumentGalleryResources(userCtx, document.getOid()).getGalleries().get("def")) != null) {
                        params.add(new R01MJmsQueueParam(1, "galleryXML", (Object)XOManager.getXML((String)R01MConstants.LINK_MAPFILE, (Object)gallery)));
                    }
                }
                catch (XOMarshallerException e) {
                    R01FLog.to((String)LOG_TYPE_ID).warning("Error al meter parametro galleryXML.Error:" + e.getMessage());
                }
                catch (R01MContentModelException e) {
                    R01FLog.to((String)LOG_TYPE_ID).warning("Error al cargar valores del geocatalog.Error:" + e.getMessage());
                }
            }
            params.add(new R01MJmsQueueParam(1, "resources", (Object)values));
            params.add(new R01MJmsQueueParam(1, "renderList", (Object)renderList));
            long timeToDeliver = -1L;
            if (renderGroup.equals("saveDocument") && renderList.indexOf("dcat") != -1) {
                timeToDeliver = 5000L;
            }
            R01MJMSUtils.sendJMSMessage((String)renderType, params, (long)timeToDeliver);
        }
        catch (R01MJMSException jmsExc) {
            R01FLog.to((String)LOG_TYPE_ID).warning("Error al enviar mensaje al renderizador .Error:" + jmsExc.getMessage());
        }
    }
}

