/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services;

import com.ejie.r01d.datastore.R01DContentInDataStore;
import com.ejie.r01d.datastore.R01DContentReadOnlyFilter;
import com.ejie.r01d.filters.R01DDocsFileFilter;
import com.ejie.r01d.filters.R01DNotDocsDirFilter;
import com.ejie.r01d.filters.R01DNotDocsFileFilter;
import com.ejie.r01d.filters.R01DSecondLevelDirsOnlyFilter;
import com.ejie.r01d.services.R01DContentModelManager;
import com.ejie.r01f.file.DirectoryExtractor;
import com.ejie.r01f.file.FileCompressorUtils;
import com.ejie.r01f.file.FileUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.reflection.ReflectionException;
import com.ejie.r01f.reflection.ReflectionUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.datastore.R01MDataStoreAuthObject;
import com.ejie.r01m.datastore.R01MDataStoreItemFilter;
import com.ejie.r01m.datastore.R01MDataStoreManager;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MDataStoreAuthenticationException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDataFile;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.datastore.R01MDataStoreItem;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.bzd.R01MContentDataManagerBzd;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.R01MPathHelpper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class R01DContentDataManager
implements R01MContentDataManagerBzd {
    private static String LOG_TYPE_ID = "r01d.dataManager";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)LOG_TYPE_ID).intValue() != Level.OFF.intValue();
    private static final boolean COPY_DATAFILES_TO_DOCUMENTFOLDER = XMLProperties.getBoolean((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentIndexPrepareOps/copyDataFilesToDocumentFolder", (boolean)true);
    private R01DContentInDataStore _theContentInDataStore;

    public R01DContentDataManager() {
    }

    public R01DContentDataManager(R01MUserContext userCtx, R01MContent cont) throws R01MSecurityException, R01MContentModelException {
        this();
        this._obtainContentInDataStore(userCtx, cont);
    }

    private R01DContentInDataStore _obtainContentInDataStore(R01MUserContext userCtx, String contentOid) throws R01MSecurityException, R01MContentModelException {
        R01DContentModelManager cmManager;
        R01MContent content;
        if (this._theContentInDataStore == null && (content = (cmManager = new R01DContentModelManager()).doLoadContent(null, contentOid)) != null) {
            this._obtainContentInDataStore(userCtx, content);
        }
        return this._theContentInDataStore;
    }

    private R01DContentInDataStore _obtainContentInDataStore(R01MUserContext userCtx, R01MContent content) throws R01MSecurityException, R01MContentModelException {
        if (this._theContentInDataStore == null) {
            this._theContentInDataStore = new R01DContentInDataStore(userCtx, content);
        } else if (!this._theContentInDataStore.getContent().getOid().equals(content.getOid())) {
            throw new R01MContentModelException("Se est\u00e1 intentando reutilizar el mismo datamanager con dos contenidos distintos!!! Crear un objeto datamanager para cada uno de ellos");
        }
        return this._theContentInDataStore;
    }

    public boolean doCheckDataFile(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doCheckDataFile > contentOid=" + contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            return contentInDataStore.existsDataFile(documentOid, dataFileOid);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al chequedar el fichero de datos " + dataFileOid + " en el documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public boolean doCheckAttachmentFile(R01MUserContext userCtx, String contentOid, String documentOid, String fileDocumentRelativePath) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doCheckAttachmentFile > contentOid=" + contentOid + " documentOid=" + documentOid + " attachmentFile=" + fileDocumentRelativePath;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            return contentInDataStore.existsAttachmentFile(documentOid, fileDocumentRelativePath);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al chequedar el fichero de adjunto " + fileDocumentRelativePath + " en el documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public byte[] doDownloadDataFileChunk(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, long offset, int length) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doDownloadDataFileChunk > contentOid=" + contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            return contentInDataStore.downloadDataFileChunk(documentOid, dataFileOid, offset, length);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al obtener el fichero de datos " + dataFileOid + " en el documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public InputStream doDownloadDataFile(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doDownloadDataFile > contentOid=" + contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            return contentInDataStore.downloadDataFile(documentOid, dataFileOid);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al obtener el fichero de datos " + dataFileOid + " en el documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public byte[] doDownloadDocumentFileChunk(R01MUserContext userCtx, String contentOid, String documentOid, String fileDocumentRelativePath, long offset, int length) throws R01MSecurityException, R01MContentModelException {
        return this.doDownloadAttachmentFileChunk(userCtx, contentOid, documentOid, fileDocumentRelativePath, offset, length);
    }

    public byte[] doDownloadAttachmentFileChunk(R01MUserContext userCtx, String contentOid, String documentOid, String fileDocumentRelativePath, long offset, int length) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doDownloadAttachmentFileChunk > contentOid=" + contentOid + " documentOid=" + documentOid + " documentRelativePath=" + fileDocumentRelativePath;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            return contentInDataStore.downloadAttachmentFileChunk(documentOid, fileDocumentRelativePath, offset, length);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al obtener el fichero " + fileDocumentRelativePath + " en el documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public InputStream doDownloadDocumentFile(R01MUserContext userCtx, String contentOid, String documentOid, String fileDocumentRelativePath) throws R01MSecurityException, R01MContentModelException {
        return this.doDownloadAttachmentFile(userCtx, contentOid, documentOid, fileDocumentRelativePath);
    }

    public InputStream doDownloadAttachmentFile(R01MUserContext userCtx, String contentOid, String documentOid, String fileDocumentRelativePath) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doDownloadDocumentFile > contentOid=" + contentOid + " documentOid=" + documentOid + " documentRelativePath=" + fileDocumentRelativePath;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            return contentInDataStore.downloadAttachmentFile(documentOid, fileDocumentRelativePath);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al obtener el fichero " + fileDocumentRelativePath + " en el documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public R01MDataStoreItem[] doGetDocumentFolderContents(R01MUserContext userCtx, String contentOid, String documentOid, String folderDocumentRelativePath, boolean recursive) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doGetDocumentFolderContents > contentOid=" + contentOid + " documentOid=" + documentOid + " documentRelativePath=" + folderDocumentRelativePath;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            return contentInDataStore.listDocumentFolderContents(documentOid, folderDocumentRelativePath, recursive);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al obtener los contenidos de la carpeta " + folderDocumentRelativePath + " en el documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public R01MDataStoreItem[] doGetDocumentFolderContents(R01MUserContext userCtx, String contentOid, String documentOid, String folderDocumentRelativePath, boolean recursive, R01MDataStoreItemFilter filter, R01MDataStoreItemFilter readOnlyFilter) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doGetDocumentFolderContents > contentOid=" + contentOid + " documentOid=" + documentOid + " documentRelativePath=" + folderDocumentRelativePath;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            return contentInDataStore.listDocumentFolderContents(documentOid, folderDocumentRelativePath, recursive, filter, readOnlyFilter);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al obtener los contenidos de la carpeta " + folderDocumentRelativePath + " en el documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public R01MDataStoreItem[] doGetContentFolderContents(R01MUserContext userCtx, String contentOid, boolean recursive, R01MDataStoreItemFilter filter, R01MDataStoreItemFilter readOnlyFilter) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doGetContentFolderContents > contentOid=" + contentOid + ".";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        R01DContentReadOnlyFilter newReadOnlyFilter = null;
        newReadOnlyFilter = readOnlyFilter == null ? new R01DContentReadOnlyFilter(this._theContentInDataStore.getContent()) : (R01DContentReadOnlyFilter)readOnlyFilter;
        ArrayList<String> allowedWAs = new ArrayList<String>();
        allowedWAs.add(this._theContentInDataStore.getContent().getStoreLocation().getWorkAreaOid());
        newReadOnlyFilter.setAllowedWorkareas(allowedWAs);
        try {
            return contentInDataStore.listContentFolderContents(recursive, filter, (R01MDataStoreItemFilter)newReadOnlyFilter);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al obtener los archivos/directorios del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public Properties doGetDataFileAttributes(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doGetDataFileExtendedAttributes > contentOid=" + contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            return contentInDataStore.getDataFileAttributes(documentOid, dataFileOid);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al devolver los atributos extendidos del fichero de datos " + dataFileOid + " en el documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadDataFileChunk(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, byte[] fileChunk, long offset) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doUploadDataFileChunk > contentOid=" + contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            contentInDataStore.uploadDataFileChunk(documentOid, dataFileOid, fileChunk, offset);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al enviar el fichero de datos " + dataFileOid + " al documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
        if (COPY_DATAFILES_TO_DOCUMENTFOLDER) {
            try {
                contentInDataStore.copyDataFileFromSystemAreaToDocumentFolder(documentOid, dataFileOid);
            }
            catch (R01MDataStoreException dsEx) {
                R01FLog.to((String)LOG_TYPE_ID).warning("Preparacion de la indexacion: NO se ha podido copiar el dataFile " + dataFileOid + " del contenido:documento " + contentOid + ":" + documentOid + " desde el area de sistema a la carpeta del documento > " + dsEx.getMessage());
                dsEx.printStackTrace(System.out);
            }
        }
    }

    public void doUploadDataFileChunkToDocumentFolder(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, byte[] fileChunk, long offset) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doUploadDataFileChunkToDocumentFolder > contentOid=" + contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            contentInDataStore.uploadDataFileChunkToDocumentFolder(documentOid, dataFileOid, fileChunk, offset);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al enviar el fichero de datos " + dataFileOid + " al documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadDataFile(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, InputStream file) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doUploadDataFile > contentOid=" + contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        if (file != null) {
            R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
            try {
                contentInDataStore.uploadDataFile(documentOid, dataFileOid, file);
            }
            catch (R01MDataStoreException dsEx) {
                throw new R01MContentModelException("Error al enviar el fichero de datos " + dataFileOid + " al documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
            }
            if (COPY_DATAFILES_TO_DOCUMENTFOLDER) {
                try {
                    contentInDataStore.copyDataFileFromSystemAreaToDocumentFolder(documentOid, dataFileOid);
                }
                catch (R01MDataStoreException dsEx) {
                    R01FLog.to((String)LOG_TYPE_ID).warning("Preparacion de la indexacion: NO se ha podido copiar el dataFile " + dataFileOid + " del contenido:documento " + contentOid + ":" + documentOid + " desde el area de sistema a la carpeta del documento > " + dsEx.getMessage());
                    dsEx.printStackTrace(System.out);
                }
            }
        }
    }

    public void doUploadDataFileToDocumentFolder(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, InputStream file) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doUploadDataFileToDocumentFolder > contentOid=" + contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            contentInDataStore.uploadDataFileToDocumentFolder(documentOid, dataFileOid, file);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al enviar el fichero de datos " + dataFileOid + " al documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doUploadGeneratedFileChunk(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, String presentationTemplateOid, String presentationTemplateInstanceId, String generatedFileId, byte[] fileChunk, long offset) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doUploadGeneratedFileChunk > contentOid=" + contentOid + " documentOid=" + documentOid + " generatedFileId=" + generatedFileId + " (tpl=" + presentationTemplateOid + ")";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        if (fileChunk != null && fileChunk.length > 0) {
            R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
            try {
                contentInDataStore.uploadGeneratedFileChunk(documentOid, dataFileOid, presentationTemplateOid, presentationTemplateInstanceId, generatedFileId, fileChunk, offset);
            }
            catch (R01MDataStoreException dsEx) {
                throw new R01MContentModelException("Error al enviar el fichero de datos generado al documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
            }
        }
    }

    public void doUploadGeneratedFile(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, String presentationTemplateOid, String presentationTemplateInstanceId, String generatedFileId, InputStream file) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doUploadGeneratedFile > contentOid=" + contentOid + " documentOid=" + documentOid + " generatedFileId=" + generatedFileId + " (tpl=" + presentationTemplateOid + ")";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        if (file != null) {
            R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
            try {
                contentInDataStore.uploadGeneratedFile(documentOid, dataFileOid, presentationTemplateOid, presentationTemplateInstanceId, generatedFileId, file);
            }
            catch (R01MDataStoreException dsEx) {
                throw new R01MContentModelException("Error al enviar el fichero de datos generado al documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
            }
        }
    }

    public void doUploadAttachmentFileChunk(R01MUserContext userCtx, String contentOid, String documentOid, String attachmentDocumentRelativePath, byte[] attachChunk, long offset) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doUploadAttachmentFileChunk > contentOid=" + contentOid + " documentOid=" + documentOid + " attachmentDocumentRelativePath=" + attachmentDocumentRelativePath;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        if (attachChunk != null && attachChunk.length > 0) {
            R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
            try {
                contentInDataStore.uploadAttachmentFileChunk(documentOid, attachmentDocumentRelativePath, attachChunk, offset);
            }
            catch (R01MDataStoreException dsEx) {
                throw new R01MContentModelException("Error al enviar el fichero de datos generado al documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
            }
        }
    }

    public void doUploadAttachmentFile(R01MUserContext userCtx, String contentOid, String documentOid, String attachmentDocumentRelativePath, InputStream attach) throws R01MSecurityException, R01MContentModelException {
        StringBuffer opDesc = new StringBuffer().append("doUploadAttachmentFile > contentOid=").append(contentOid).append(" documentOid=").append(documentOid).append(" attachmentDocumentRelativePath=").append(attachmentDocumentRelativePath);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc.toString());
        }
        if (attach != null) {
            R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
            try {
                contentInDataStore.uploadAttachmentFile(documentOid, attachmentDocumentRelativePath, attach);
            }
            catch (R01MDataStoreException dsEx) {
                throw new R01MContentModelException("Error al enviar el fichero adjunto al documento " + documentOid + " del contenido " + contentOid + " en el path relativo al documento " + attachmentDocumentRelativePath + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
            }
        }
    }

    public void doUploadFileInContent(R01MUserContext userCtx, String contentOid, String fileInContentRelativePath, InputStream attach) throws R01MSecurityException, R01MContentModelException {
        StringBuffer opDesc = new StringBuffer().append("doUploadFileInContent > contentOid=").append(contentOid).append(" fileInContentRelativePath=").append(fileInContentRelativePath);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc.toString());
        }
        if (attach != null) {
            R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
            try {
                contentInDataStore.uploadFileInContent(fileInContentRelativePath, attach);
            }
            catch (R01MDataStoreException dsEx) {
                throw new R01MContentModelException("Error al enviar el fichero adjunto al contenido " + contentOid + " en el path relativo " + fileInContentRelativePath + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
            }
        }
    }

    public void doUploadFileInContentChunk(R01MUserContext userCtx, String contentOid, String fileInContentRelativePath, byte[] attachChunk, long offset) throws R01MSecurityException, R01MContentModelException {
        StringBuffer opDesc = new StringBuffer().append("doUploadFileInContentChunk > contentOid=").append(contentOid).append(" fileInContentRelativePath=").append(fileInContentRelativePath);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        if (attachChunk != null && attachChunk.length > 0) {
            R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
            try {
                contentInDataStore.uploadFileInContent(fileInContentRelativePath, attachChunk, offset);
            }
            catch (R01MDataStoreException dsEx) {
                throw new R01MContentModelException("Error al enviar el fichero adjunto al contenido " + contentOid + " en el path relativo " + fileInContentRelativePath + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
            }
        }
    }

    public void doCopyFilesFromContentToContent(R01MUserContext userCtx, String srcContentOid, String srcContentRelativePath, String dstContentOid, String dstContentRelativePath, R01MDataStoreItemFilter filter) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doCopyFilesFromContentToContent > copiar los archivos definidos en el filtro\n\t desde el directorio " + srcContentRelativePath + " del contenido " + srcContentOid + "\n\t al directorio " + dstContentRelativePath + " del contenido " + dstContentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA INIT: " + opDesc);
        }
        R01DContentInDataStore srcContentInDataStore = new R01DContentInDataStore(userCtx, new R01DContentModelManager().doLoadContent(null, srcContentOid));
        String srcContentWARelPath = srcContentInDataStore.getContentWorkAreaRelativePath();
        R01MDataStoreItem[] filesInContent = null;
        try {
            filesInContent = srcContentInDataStore.listContentFolderContents(true, srcContentRelativePath, filter, null);
        }
        catch (R01MDataStoreException dsEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al leer los archivos del directorio " + srcContentRelativePath + " del contenido " + srcContentWARelPath + ". Error: " + dsEx.getMessage());
            throw new R01MContentModelException("Error al leer los archivos del directorio " + srcContentRelativePath + " del contenido " + srcContentWARelPath + ".", (Exception)((Object)dsEx));
        }
        ArrayList<String> srcFilesWARelPaths = new ArrayList<String>();
        if (filesInContent != null && filesInContent.length > 0) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Existen " + filesInContent.length + " archivos a copiar:");
            }
            for (int i = 0; i < filesInContent.length; ++i) {
                R01MDataStoreItem item = filesInContent[i];
                if (item.getItemType() != 0 && item.getItemType() != 1) continue;
                String pathFile = item.getWorkAreaRelativePath();
                srcFilesWARelPaths.add(pathFile);
                if (!DEBUG) continue;
                R01FLog.to((String)LOG_TYPE_ID).info("\tCopiar >>> " + pathFile);
            }
            R01DContentInDataStore dstContentInDataStore = new R01DContentInDataStore(userCtx, new R01DContentModelManager().doLoadContent(null, dstContentOid));
            String dstContentWARelPath = dstContentInDataStore.getContentWorkAreaRelativePath();
            R01DContentModelManager cmMngr = new R01DContentModelManager();
            R01MContent srcContent = cmMngr.doLoadContent(userCtx, srcContentOid);
            String srcWAPath = R01MPathHelpper.getLocationPath((R01MBaseLocationObject)srcContent.getStoreLocation());
            R01MContent dstContent = cmMngr.doLoadContent(userCtx, dstContentOid);
            String dstWAPath = R01MPathHelpper.getLocationPath((R01MBaseLocationObject)dstContent.getStoreLocation());
            try {
                R01MClientFactory.getRawDataAPI((R01MUserContext)userCtx).copyFiles(srcWAPath, srcContentWARelPath + "/" + srcContentRelativePath, dstWAPath, dstContentWARelPath + "/" + dstContentRelativePath, srcFilesWARelPaths.toArray(new String[srcFilesWARelPaths.size()]));
            }
            catch (R01MDataStoreException dsEx) {
                throw new R01MContentModelException("Error al copiar los archivos definidos en el filtro, desde el directorio " + srcContentRelativePath + " del contenido " + srcContentOid + " al directorio " + dstContentRelativePath + " del contenido " + dstContentOid, (Exception)((Object)dsEx));
            }
        } else if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("No existen archivos para copiar desde el directorio " + srcContentRelativePath + " del contenido " + srcContentOid + " al directorio " + dstContentRelativePath + " del contenido " + dstContentOid);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA END: " + opDesc);
        }
    }

    public void doCopyAttachmentFileFromDocumentToAnother(R01MUserContext userCtx, String contentOid, String srcDocumentOid, String targetDocumentOid, String attachmentDocumentRelativePath) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doCopyAttachmentFileOfDocument > contentOid=" + contentOid + " documentSourceOid=" + srcDocumentOid + " documentTargetOid=" + targetDocumentOid + " attachmentDocumentRelativePath=" + attachmentDocumentRelativePath;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            contentInDataStore.copyDocumentAttachmentFile(srcDocumentOid, targetDocumentOid, attachmentDocumentRelativePath);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al copiar el fichero adjunto " + attachmentDocumentRelativePath + " del documento " + srcDocumentOid + " al documento " + targetDocumentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doExtractZipFileIntoContent(R01MUserContext userCtx, String contentOid, String srcZipFileName) throws R01MSecurityException, R01MContentModelException {
        File zippedDir;
        R01MDataStoreItem[] dirsInContent;
        File dstFolder;
        String targetPath = XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"contentManager/extractFilesDir", (String)"/datos/r01nt/file/extract/");
        String fileToExtractAbsolutePath = targetPath + srcZipFileName;
        String directoryToExtractAbsolutePath = targetPath + srcZipFileName.substring(0, srcZipFileName.indexOf(46));
        String opDesc = "Subir al contenido '" + contentOid + "' los archivos del empaquetado " + fileToExtractAbsolutePath + ".";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        if ((dstFolder = new File(directoryToExtractAbsolutePath)).exists()) {
            try {
                FileUtils.delete((File)dstFolder);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                R01FLog.to((String)LOG_TYPE_ID).warning("No se ha podido borrar el directorio " + directoryToExtractAbsolutePath);
            }
        }
        try {
            FileCompressorUtils.extractContentsFromZipFile((String)fileToExtractAbsolutePath, (String)targetPath);
        }
        catch (IOException ioExc) {
            ioExc.printStackTrace(System.err);
            throw new R01MContentModelException("Error al extraer el contenido del fichero " + fileToExtractAbsolutePath + " en el directorio " + directoryToExtractAbsolutePath + ".Error:" + ioExc.getMessage());
        }
        File zippedFile = new File(fileToExtractAbsolutePath);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("Borrando el archivo " + fileToExtractAbsolutePath);
        }
        if (zippedFile.exists()) {
            try {
                FileUtils.delete((File)zippedFile);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                R01FLog.to((String)LOG_TYPE_ID).warning("Error al borrar el archivo empaquetado " + zippedFile.getPath());
            }
        }
        DirectoryExtractor dirExtract = new DirectoryExtractor(directoryToExtractAbsolutePath);
        Collection allDocumentFilesAndDirs = dirExtract.getFilesAndDirectories((FileFilter)new R01DDocsFileFilter(directoryToExtractAbsolutePath));
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        for (File currFile : allDocumentFilesAndDirs) {
            String contentRelativePathAndFile = currFile.getAbsolutePath().substring(directoryToExtractAbsolutePath.length() + 1);
            if (currFile.isFile()) {
                try {
                    contentInDataStore.uploadFileInContent(contentRelativePathAndFile, (InputStream)new FileInputStream(currFile));
                }
                catch (R01MDataStoreException dsEx) {
                    R01FLog.to((String)LOG_TYPE_ID).warning("Error al subir el archivo " + currFile.getAbsolutePath() + " al contenido " + contentOid + ": " + dsEx.getMessage());
                }
                catch (FileNotFoundException fnfEx) {
                    R01FLog.to((String)LOG_TYPE_ID).warning("El archivo " + currFile.getAbsolutePath() + " no existe. Error: " + fnfEx.getMessage());
                }
                continue;
            }
            if (!currFile.isDirectory()) continue;
            try {
                contentInDataStore.createContentDir(contentRelativePathAndFile);
            }
            catch (R01MDataStoreException dsEx) {
                R01FLog.to((String)LOG_TYPE_ID).warning("El directorio " + currFile.getAbsolutePath() + " no se puede crear. Error: " + dsEx.getMessage());
            }
        }
        R01DContentModelManager cmMgr = new R01DContentModelManager();
        R01MContent content = cmMgr.doLoadContent(userCtx, contentOid);
        if (content.getDocuments() != null && !content.getDocuments().isEmpty()) {
            for (Map.Entry me : content.getDocuments().entrySet()) {
                R01MDocument doc = (R01MDocument)me.getValue();
                if (doc.getDataFiles() == null || doc.getDataFiles().isEmpty()) continue;
                for (Map.Entry meDf : doc.getDataFiles().entrySet()) {
                    R01MDataFile df = (R01MDataFile)meDf.getValue();
                    try {
                        contentInDataStore.copyDataFileFromDocumentFolderToSystemArea(doc.getOid(), df.getOid());
                    }
                    catch (R01MDataStoreException ex) {
                        R01FLog.to((String)LOG_TYPE_ID).warning("Error al copiar la DCR del documento " + doc.getInternalName() + " y del archivo " + df.getInternalName() + ". Error: " + ex.getMessage());
                    }
                }
            }
        }
        Collection allNotDocumentFilesAndDirs = dirExtract.getFilesAndDirectories((FileFilter)new R01DNotDocsFileFilter(directoryToExtractAbsolutePath));
        ArrayList<String> contentDirs = new ArrayList<String>();
        for (File currFile : allNotDocumentFilesAndDirs) {
            String contentRelativePathAndFileName = currFile.getAbsolutePath().substring(directoryToExtractAbsolutePath.length() + 1);
            if (currFile.isFile()) {
                try {
                    contentInDataStore.uploadFileInContent(contentRelativePathAndFileName, (InputStream)new FileInputStream(currFile));
                }
                catch (R01MDataStoreException dsEx) {
                    R01FLog.to((String)LOG_TYPE_ID).warning("Error al subir el archivo " + currFile.getAbsolutePath() + " al contenido " + contentOid + ": " + dsEx.getMessage());
                }
                catch (FileNotFoundException fnfEx) {
                    R01FLog.to((String)LOG_TYPE_ID).warning("El archivo " + currFile.getAbsolutePath() + " no existe. Error: " + fnfEx.getMessage());
                }
                continue;
            }
            if (!currFile.isDirectory() || StringUtils.isEmptyString((String)contentRelativePathAndFileName)) continue;
            contentDirs.add(contentRelativePathAndFileName);
            try {
                contentInDataStore.createContentDir(contentRelativePathAndFileName);
            }
            catch (R01MDataStoreException dsEx) {
                R01FLog.to((String)LOG_TYPE_ID).warning("El directorio " + currFile.getAbsolutePath() + " no se puede crear. Error: " + dsEx.getMessage());
            }
        }
        try {
            dirsInContent = contentInDataStore.listContentFolderContents(false, (R01MDataStoreItemFilter)new R01DNotDocsDirFilter(contentInDataStore.getContentWorkAreaRelativePath()), null);
        }
        catch (R01MDataStoreException dsEx) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al leer los directorios del contenido " + contentOid + ". Error: " + dsEx.getMessage());
            throw new R01MContentModelException("Error al leer los directorios del contenido " + contentOid + ".", (Exception)((Object)dsEx));
        }
        if (dirsInContent != null && dirsInContent.length > 0) {
            for (int i = 0; i < dirsInContent.length; ++i) {
                R01MDataStoreItem[] dirsInSubfolderContent;
                R01MDataStoreItem itemDir = dirsInContent[i];
                if (itemDir.isReadOnly()) continue;
                String contentWARelPath = contentInDataStore.getContentWorkAreaRelativePath();
                int previousDirLength = contentWARelPath.length();
                String contentFolder = itemDir.getWorkAreaRelativePath().substring(previousDirLength + 1);
                if (!contentDirs.contains(contentFolder)) {
                    try {
                        contentInDataStore.deleteContentDir(contentFolder);
                    }
                    catch (R01MDataStoreException dsEx) {
                        R01FLog.to((String)LOG_TYPE_ID).warning("El directorio " + contentWARelPath + " no se puede borrar. Error: " + dsEx.getMessage());
                    }
                    continue;
                }
                try {
                    dirsInSubfolderContent = contentInDataStore.listContentFolderContents(true, contentFolder, (R01MDataStoreItemFilter)new R01DSecondLevelDirsOnlyFilter(contentInDataStore.getContentWorkAreaRelativePath() + "/" + contentFolder), null);
                }
                catch (R01MDataStoreException dsEx) {
                    R01FLog.to((String)LOG_TYPE_ID).severe("Error al leer los directorios del contenido " + contentOid + ". Error: " + dsEx.getMessage());
                    throw new R01MContentModelException("Error al leer los directorios del contenido " + contentOid + ".", (Exception)((Object)dsEx));
                }
                if (dirsInSubfolderContent == null || dirsInSubfolderContent.length <= 0) continue;
                for (int j = 0; j < dirsInSubfolderContent.length; ++j) {
                    R01MDataStoreItem itemSubfolderDir = dirsInSubfolderContent[j];
                    int contentWARelPathLength = contentWARelPath.length();
                    String contentSubfolder = itemSubfolderDir.getWorkAreaRelativePath().substring(contentWARelPathLength + 1);
                    if (contentDirs.contains(contentSubfolder)) continue;
                    try {
                        contentInDataStore.deleteContentDir(contentSubfolder);
                        continue;
                    }
                    catch (R01MDataStoreException dsEx) {
                        R01FLog.to((String)LOG_TYPE_ID).warning("El directorio " + contentWARelPath + " no se puede borrar. Error: " + dsEx.getMessage());
                    }
                }
            }
        }
        if ((zippedDir = new File(directoryToExtractAbsolutePath)).exists()) {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("Borrando el directorio " + directoryToExtractAbsolutePath);
            }
            try {
                FileUtils.delete((File)zippedDir);
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                R01FLog.to((String)LOG_TYPE_ID).warning("Error al borrar el directorio del empaquetado " + directoryToExtractAbsolutePath);
            }
        } else {
            R01FLog.to((String)LOG_TYPE_ID).warning("El directorio del empaquetado " + directoryToExtractAbsolutePath + " no existe.");
        }
    }

    public void doUploadPublishFile(R01MUserContext userCtx, String contentOid, String publishFileWARelPath, ByteArrayInputStream byteArrayInputStreamFileList) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doUploadPublishFile > contentOid=" + contentOid + " publishFileWARelPath=" + publishFileWARelPath;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        if (byteArrayInputStreamFileList != null) {
            R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
            try {
                contentInDataStore.uploadPublishFile(publishFileWARelPath, (InputStream)byteArrayInputStreamFileList);
            }
            catch (R01MDataStoreException dsEx) {
                throw new R01MContentModelException("Error al enviar el fichero de publicaci\u00f3n de recursos del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
            }
        }
    }

    public InputStream doDownloadPublishFile(R01MUserContext userCtx, String contentOid, String publishFileWARelPath) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doDownloadPublishFile > contentOid=" + contentOid + " publishFileWARelPath=" + publishFileWARelPath;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            return contentInDataStore.downloadPublishFile(publishFileWARelPath);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al enviar el fichero de publicaci\u00f3n de recursos del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doSetDataFileAttributes(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, Properties attrs) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doSetDataFileExtendedAttributes > contentOid=" + contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("SERVER DATA: " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            contentInDataStore.setDataFileAttributes(documentOid, dataFileOid, attrs);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al establecer los atributos extendidos del fichero de datos " + dataFileOid + " en el documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doDeleteDataFile(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doDeleteDataFile > contentOid=" + contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (init): " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            contentInDataStore.deleteDataFile(documentOid, dataFileOid, true);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al borrar el fichero de datos " + dataFileOid + " del documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doDeleteGeneratedFile(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, String presentationTemplateOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doDeleteGeneratedFile > contentOid=" + contentOid + " documentOid=" + documentOid + " dataFileOid=" + dataFileOid + " (presentationTemplateOid=" + presentationTemplateOid + ")";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (init): " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            contentInDataStore.deleteGeneratedFile(documentOid, dataFileOid, presentationTemplateOid);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al borrar el fichero de datos generado " + dataFileOid + " del documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doDeleteAttachmentFile(R01MUserContext userCtx, String contentOid, String documentOid, String attachmentDocumentRelativePath) throws R01MContentModelException, R01MSecurityException {
        String opDesc = "doDeleteAttachmentFile > contentOid=" + contentOid + " documentOid=" + documentOid + " attachmentDocumentRelativePath=" + attachmentDocumentRelativePath;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (init): " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            contentInDataStore.deleteAttachmentFile(documentOid, attachmentDocumentRelativePath);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al borrar el fichero de datos generado " + attachmentDocumentRelativePath + " del documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doSubmmitDocument(R01MUserContext userCtx, String contentOid, String documentOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doSubmmitDocument > contentOid=" + contentOid + " documentOid=" + documentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (init): " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            contentInDataStore.consolidateDocument(documentOid);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al consolidar el documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doSubmmitContent(R01MUserContext userCtx, String contentOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doSubmmitContent > contentOid=" + contentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (init): " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            contentInDataStore.consolidate();
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al consolidar el contenido " + contentOid + ": " + dsEx.getMessage());
        }
    }

    public void doSubmmitDocumentFolder(R01MUserContext userCtx, String contentOid, String documentOid, String folderDocumentRelativePath) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doSubmmitDocumentFolder > contentOid=" + contentOid + " documentOid=" + documentOid + " folderDocumentRelativePath=" + folderDocumentRelativePath;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (init): " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            contentInDataStore.consolidateFolder(documentOid, folderDocumentRelativePath);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al consolidar la carpeta " + folderDocumentRelativePath + " del documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doSubmmitDocumentFile(R01MUserContext userCtx, String contentOid, String documentOid, String fileDocumentRelativePath) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doSubmmitDocumentFile > contentOid=" + contentOid + " documentOid=" + documentOid + " fileDocumentRelativePath=" + fileDocumentRelativePath;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (init): " + opDesc);
        }
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            contentInDataStore.consolidateAttachmentFile(documentOid, fileDocumentRelativePath);
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al consolidar el fichero " + fileDocumentRelativePath + " del documento " + documentOid + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public void doSubmmitFileInContent(R01MUserContext userCtx, String contentOid, String fileContentRelativePath) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "doSubmmitFileInContent > contentOid=" + contentOid + " fileContentRelativePath=" + fileContentRelativePath;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("CLIENT DATA API (init): " + opDesc);
        }
        String dataStoreManagerClassName = XMLProperties.get((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"dataStoreManager/implClassName");
        R01DContentInDataStore contentInDataStore = this._obtainContentInDataStore(userCtx, contentOid);
        try {
            R01MDataStoreManager dsManager = this._getDsManager(userCtx, dataStoreManagerClassName);
            if (dsManager.doCheckFolder((R01MBaseLocationObject)contentInDataStore.getContent().getStoreLocation(), contentInDataStore.getContentWorkAreaRelativePath() + fileContentRelativePath)) {
                contentInDataStore.consolidateContentDir(fileContentRelativePath);
            } else {
                contentInDataStore.consolidateContentFile(fileContentRelativePath);
            }
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("Error al consolidar el fichero/directorio " + fileContentRelativePath + " del contenido " + contentOid + ": " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    private R01MDataStoreManager _getDsManager(R01MUserContext userCtx, String dataStoreManagerClassName) throws R01MDataStoreException {
        R01MDataStoreManager dsManager = null;
        R01MDataStoreAuthObject authenticationObject = null;
        try {
            authenticationObject = new R01MDataStoreAuthObject();
            authenticationObject.fillAuthInfo(R01MConstants.API_APPCODE, userCtx);
        }
        catch (R01MDataStoreAuthenticationException dsaEx) {
            dsaEx.printStackTrace();
            throw new R01MDataStoreException("Error al autenticarse en el datastore a la hora de crear la estructura de aliases", (Exception)((Object)dsaEx));
        }
        try {
            dsManager = (R01MDataStoreManager)ReflectionUtils.getObjectInstance((String)dataStoreManagerClassName);
            dsManager.doBeginSession(authenticationObject);
        }
        catch (ReflectionException refEx) {
            refEx.printStackTrace();
            throw new R01MDataStoreException("Error al crear la estructura de aliases.Error al instanciar el DataStore (" + dataStoreManagerClassName == null ? "NULL" : dataStoreManagerClassName + ").", (Exception)((Object)refEx));
        }
        catch (R01MDataStoreAuthenticationException authEx) {
            authEx.printStackTrace();
            throw new R01MDataStoreException("Error al crear la estructura de aliases.Error al instanciar el DataStore (" + dataStoreManagerClassName == null ? "NULL" : dataStoreManagerClassName + ").", (Exception)((Object)authEx));
        }
        return dsManager;
    }
}

