/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services;

import com.ejie.r01d.datastore.R01DContentInDataStore;
import com.ejie.r01d.exceptions.R01DContentModelPersistenceException;
import com.ejie.r01d.gestorcontenidos.dbhelppers.R01DContentModelLoaderHelper;
import com.ejie.r01d.gestorcontenidos.dbhelppers.dao.R01DDAOContentModelLoader;
import com.ejie.r01d.gestorcontenidos.dbhelppers.dao.R01DDAOStorageContentsLoader;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.content.R01DContentCMPLocal;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.content.R01DContentCMPLocalHome;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.content.R01DContentCMPPK;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.content.R01DContentCMPUtil;
import com.ejie.r01d.services.R01DComboUtilsHelper;
import com.ejie.r01d.services.R01DContentModelManager;
import com.ejie.r01d.services.helpers.R01DContentExportHelper;
import com.ejie.r01d.services.helpers.R01DContentImportHelper;
import com.ejie.r01d.services.helpers.R01DContentMigrationHelper;
import com.ejie.r01d.services.helpers.R01DContentTestHelper;
import com.ejie.r01d.services.helpers.R01DDataFileGenerationHelper;
import com.ejie.r01d.services.helpers.R01DLocationPublishHelper;
import com.ejie.r01d.services.helpers.R01DPackageHelper;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MDataStoreException;
import com.ejie.r01m.exceptions.R01MJMSException;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MSearchedDocuments;
import com.ejie.r01m.objects.misc.R01MOperationInModelObjectResult;
import com.ejie.r01m.objects.opendata.R01MBaseOpendataPackageInterface;
import com.ejie.r01m.objects.opendata.R01MOpendataPackage;
import com.ejie.r01m.objects.opendata.R01MOpendataPackageExtended;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.bzd.R01MContentAdminBzd;
import com.ejie.r01m.utils.jms.R01MJMSUtils;
import com.ejie.r01m.utils.jms.R01MJmsQueueParam;
import com.ejie.r01p.datastore.R01PPhysicalDataStoreManagerFileSystemImpl;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.Weeks;
import org.joda.time.Years;

public class R01DContentAdminManager
implements R01MContentAdminBzd {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.manager").intValue() != Level.OFF.intValue();
    private static final String LOG_TYPE_ID = "r01d.manager";
    private R01MUserContext _userCtx;

    public R01DContentAdminManager() {
    }

    public R01DContentAdminManager(R01MUserContext userCtx) {
        this._userCtx = userCtx;
    }

    public String doLoadContentDescriptor(R01MUserContext userCtx, String contentOid) throws R01MSecurityException, R01MContentModelException {
        String xml = null;
        try {
            R01DContentCMPLocalHome contentCMPHome = R01DContentCMPUtil.getLocalHome();
            R01DContentCMPLocal contentCMP = contentCMPHome.findByPrimaryKey(new R01DContentCMPPK(contentOid));
            if (contentCMP == null) {
                throw new R01MContentModelException("No se ha podido cargar desde BD el contenido oid=" + contentOid);
            }
            xml = contentCMP.getDescriptor();
        }
        catch (NamingException namEx) {
            namEx.printStackTrace(System.out);
            throw new R01MContentModelException("No se encuentra el EJB CMP de contenido: " + namEx.getMessage());
        }
        catch (FinderException findEx) {
            findEx.printStackTrace(System.out);
            throw new R01MContentModelException("No se encuentra el CMP para el contenido oid=" + contentOid);
        }
        return xml;
    }

    public void doSaveContentDescriptor(R01MUserContext userCtx, String contentOid, String contentXML, boolean updateDataStoreDescriptor) throws R01MSecurityException, R01MContentModelException {
        try {
            R01DContentCMPLocalHome contentCMPHome = R01DContentCMPUtil.getLocalHome();
            R01DContentCMPLocal contentCMP = contentCMPHome.findByPrimaryKey(new R01DContentCMPPK(contentOid));
            if (contentCMP == null) {
                throw new R01MContentModelException("No se ha podido cargar desde BD el contenido oid=" + contentOid);
            }
            contentCMP.setDescriptor(contentXML);
            if (updateDataStoreDescriptor) {
                R01MContent cont = R01MClientFactory.getContentModelAPI((R01MUserContext)userCtx).loadContent(contentOid);
                R01DContentInDataStore contInDS = new R01DContentInDataStore(userCtx, cont);
                contInDS.updateContentDescriptor(contentXML);
            }
        }
        catch (NamingException namEx) {
            namEx.printStackTrace(System.out);
            throw new R01MContentModelException("No se encuentra el EJB CMP de contenido: " + namEx.getMessage());
        }
        catch (FinderException findEx) {
            findEx.printStackTrace(System.out);
            throw new R01MContentModelException("No se encuentra el CMP para el contenido oid=" + contentOid + ".Error:" + (Object)((Object)findEx));
        }
        catch (R01MDataStoreException dsEx) {
            throw new R01MContentModelException("NO se ha podido actualizar el descriptor en el dataStore: " + dsEx.getMessage(), (Exception)((Object)dsEx));
        }
    }

    public List[] doPublicateLocationContentsDocuments(R01MUserContext userCtx, R01MContentLocation loc, String publishRepositoryOid, int publicationType) throws R01MSecurityException, R01MPublisherException, R01MContentModelException {
        String opDesc = "Publicaci\u00f3n de los contenidos de la workArea > " + loc.composeMemoCode() + " en el repositorio de oid " + publishRepositoryOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DContentModelManager mgr = new R01DContentModelManager();
        R01DLocationPublishHelper pubHelp = new R01DLocationPublishHelper(userCtx, mgr);
        List[] result = pubHelp.doPublicateLocationContentsDocuments(loc, publishRepositoryOid, publicationType);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return result;
    }

    public List[] doPublicateContentDocuments(R01MUserContext userCtx, String contentOid, String publishRepositoryOid, int publicationType) throws R01MSecurityException, R01MPublisherException, R01MContentModelException {
        R01MContent currCont;
        String opDesc = "Publicaci\u00f3n del contenido > " + contentOid + " en el repositorio de oid " + publishRepositoryOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DContentModelLoaderHelper cmLoader = new R01DContentModelLoaderHelper(this._userCtx);
        try {
            currCont = cmLoader.loadContentFromDBXML(contentOid);
        }
        catch (R01DContentModelPersistenceException cmEx) {
            R01MOperationInModelObjectResult res = new R01MOperationInModelObjectResult(contentOid, 0, false, "NO se ha podido cargar el contenido: " + cmEx.getMessage());
            List[] result = new List[2];
            result[1].add(res);
            return result;
        }
        R01DContentModelManager mgr = new R01DContentModelManager();
        R01DLocationPublishHelper pubHelp = new R01DLocationPublishHelper(userCtx, mgr);
        List[] result = pubHelp.doPublicateContentDocuments(currCont, new ArrayList<String>(currCont.getDocuments().keySet()), publishRepositoryOid, publicationType);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return result;
    }

    public List[] doPublicateDocument(R01MUserContext userCtx, String documentOid, String publishRepositoryOid, int publicationType) throws R01MSecurityException, R01MPublisherException, R01MContentModelException {
        return null;
    }

    public List[] doPublicateDocument(R01MUserContext userCtx, String contentOid, String documentOid, String publishRepositoryOid, int publicationType) throws R01MSecurityException, R01MPublisherException, R01MContentModelException {
        R01MContent content;
        String opDesc = "Publicaci\u00f3n del documento > " + documentOid + " en el repositorio de oid " + publishRepositoryOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DContentModelLoaderHelper cmLoader = new R01DContentModelLoaderHelper(userCtx);
        try {
            content = cmLoader.loadContentFromDBXML(contentOid);
        }
        catch (R01DContentModelPersistenceException cmEx) {
            List[] result = new List[2];
            R01MOperationInModelObjectResult res = new R01MOperationInModelObjectResult(documentOid, 1, false, "NO se ha podido cargar el contenido: " + cmEx.getMessage());
            result[1].add(res);
            return result;
        }
        R01DContentModelManager mgr = new R01DContentModelManager();
        R01DLocationPublishHelper pubHelp = new R01DLocationPublishHelper(userCtx, mgr);
        ArrayList<String> docToPublish = new ArrayList<String>();
        docToPublish.add(documentOid);
        List[] result = pubHelp.doPublicateContentDocuments(content, docToPublish, publishRepositoryOid, publicationType);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return result;
    }

    public List[] doGenerateLocationContentsDataFiles(R01MUserContext userCtx, R01MContentLocation loc) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Regeneracion de los contenidos de la workArea > " + loc.composeMemoCode();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DDataFileGenerationHelper dfGenHelper = new R01DDataFileGenerationHelper(userCtx);
        List[] results = dfGenHelper.doGenerateAllLocationContentsDataFiles(loc);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return results;
    }

    public List[] doGenerateDatafileHTMLsBydocumentOid(R01MUserContext userCtx, String documentOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Regeneracion de los HTMLs de datafiles de una lista de documentos pasados";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DDataFileGenerationHelper dfGenHelper = new R01DDataFileGenerationHelper(userCtx);
        List[] results = dfGenHelper.doGenerateDatafileHTMLsBydocumentOid(documentOid);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return results;
    }

    public List doTestContent(R01MUserContext userCtx, String contentOid, boolean repair) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "TESTER >>>>Testeo del contenido " + contentOid;
        if (DEBUG) {
            R01FLog.to((String)"r01d.tester").info("ADMIN SERVER (init):" + opDesc);
        }
        R01DContentModelManager mgr = new R01DContentModelManager();
        R01DContentTestHelper testHelper = new R01DContentTestHelper(userCtx, mgr);
        List results = testHelper.testContent(contentOid, repair);
        if (DEBUG) {
            R01FLog.to((String)"r01d.tester").info("ADMIN SERVER (end):" + opDesc);
        }
        return results;
    }

    public List doTestLocation(R01MUserContext userCtx, R01MContentLocation loc, boolean repair) throws R01MSecurityException, R01MContentModelException {
        ArrayList results = new ArrayList();
        String opDesc = "TESTER >>>>Testeo de los contenidos de la workArea> " + loc.composeMemoCode();
        try {
            R01DDAOStorageContentsLoader loader;
            String[] contentOids;
            if (DEBUG) {
                R01FLog.to((String)"r01d.tester").info("ADMIN SERVER (init):" + opDesc);
            }
            if ((contentOids = (loader = new R01DDAOStorageContentsLoader(userCtx)).executeLoadWorkareaContentsOids(loc)) != null) {
                if (DEBUG) {
                    R01FLog.to((String)"r01d.tester").info("\n\tTesteando " + contentOids.length + "contenidos...");
                }
                for (int i = 0; i < contentOids.length; ++i) {
                    results.addAll(this.doTestContent(userCtx, contentOids[i], repair));
                    if (!DEBUG) continue;
                    R01FLog.to((String)"r01d.tester").info("\n\t<<<<<<<<<<<<<< QUEDAN " + (contentOids.length - (i + 1)) + " CONTENIDOS POR TRATAR en " + loc.composeMemoCode() + ">>>>>>>>>>>>>>>>>>>>>>>>");
                }
            }
            return results;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException("NO se ha podido cargar el contenido de la workarea " + loc.composeMemoCode() + ": " + cmEx.getMessage());
        }
    }

    public R01MOperationInModelObjectResult doImportContent(R01MUserContext userCtx, R01MContentLocation loc, String contentType, String contentName, boolean importDataFilesToSystemArea) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Importaci\u00f3n del contenido " + contentName + " de la localizaci\u00f3n " + loc.composeMemoCode();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DContentImportHelper importHelp = new R01DContentImportHelper(userCtx);
        R01MOperationInModelObjectResult outResult = importHelp.doImportContent(loc, contentType, contentName, importDataFilesToSystemArea);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return outResult;
    }

    public void doImportContentsFromZipFile(R01MUserContext userCtx, String fileName, String prefix) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Importaci\u00f3n del contenido del fichero " + fileName;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DContentImportHelper importHelp = new R01DContentImportHelper(userCtx);
        importHelp.doImportContentsFromZipFile(fileName, prefix);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
    }

    public List[] doImportLocationContents(R01MUserContext userCtx, R01MContentLocation loc, boolean importDataFilesToSystemArea) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Importacion de los contenidos de la workArea> " + loc.composeMemoCode();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DContentImportHelper migHelp = new R01DContentImportHelper(userCtx);
        List[] result = migHelp.doImportLocationContents(loc, importDataFilesToSystemArea);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return result;
    }

    public List[] doCopyDataFilesFromSystemAreaToDocumentFolder(R01MUserContext userCtx, R01MContentLocation loc) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Copia de los dataFiles de los contenidos de la workArea> " + loc.composeMemoCode() + " desde el area de sistema a la estructura de cada uno de los documentos";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DContentImportHelper migHelp = new R01DContentImportHelper(userCtx);
        List[] result = migHelp.doCopyDataFilesFromSystemAreaToDocumentFolder(loc);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return result;
    }

    public List[] doImportContentsFromFile(R01MUserContext userCtx, String fileToImport, String prefix) throws R01MSecurityException, R01MContentModelException {
        return this.doImportContentsFromFile(userCtx, fileToImport, prefix, false);
    }

    public List[] doImportContentFromArchives(R01MUserContext userCtx, String effectiveImportRootDir, Properties contentDescriptionData) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Carga del contenido " + contentDescriptionData.getProperty("contentInternalName") + " ubicado en el directorio temporal " + effectiveImportRootDir;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DContentImportHelper migHelp = new R01DContentImportHelper(userCtx);
        List[] result = migHelp.doImportContentFromArchives(effectiveImportRootDir, contentDescriptionData);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return result;
    }

    public List[] doImportContentLinkedData(R01MUserContext userCtx, String effectiveImportRootDir, Properties contentToLinkData) throws R01MSecurityException, R01MContentModelException {
        R01MContent newCreatedContent;
        String opDesc = "Carga de las relaciones del contenido " + contentToLinkData.getProperty("contentInternalName") + " ubicado en el directorio temporal " + effectiveImportRootDir;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DContentModelManager mngr = new R01DContentModelManager();
        R01DDAOContentModelLoader loader = new R01DDAOContentModelLoader();
        try {
            String newContentOid = loader.executeGetContentOidByTypeAndName(contentToLinkData.getProperty("typeOid"), contentToLinkData.getProperty("contentInternalName"));
            if (StringUtils.isEmptyString((String)newContentOid)) {
                List[] results = new List[]{new ArrayList(), new ArrayList()};
                results[0].add(new R01MOperationInModelObjectResult(null, 0, true, "El contenido " + contentToLinkData.getProperty("contentInternalName") + " de la tipologia " + contentToLinkData.getProperty("typeOid") + " no existe."));
                return results;
            }
            newCreatedContent = mngr.doLoadContent(userCtx, newContentOid);
        }
        catch (R01DContentModelPersistenceException cmExc) {
            throw new R01MContentModelException("El contenido no existe. Error:" + cmExc.getMessage());
        }
        R01DContentImportHelper migHelp = new R01DContentImportHelper(userCtx);
        List[] result = migHelp.doImportContentLinkedData(effectiveImportRootDir, contentToLinkData, newCreatedContent);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return result;
    }

    public void doImportAttachments(R01MUserContext userCtx, String fileName, String contentOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Importacion de los adjuntos del contenido " + contentOid + " en el fichero " + fileName;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        ArrayList<R01MJmsQueueParam> params = new ArrayList<R01MJmsQueueParam>();
        params.add(new R01MJmsQueueParam(1, "fileName", (Object)fileName));
        params.add(new R01MJmsQueueParam(1, "contentOid", (Object)contentOid));
        try {
            R01MJMSUtils.sendJMSMessage((String)"r01ImportAttachments", params);
        }
        catch (R01MJMSException jmsExc) {
            R01FLog.to((String)"r01n.upload").severe("Error en el env\u00edo del mensaje para el procesado del fichero " + fileName + ".Error:" + jmsExc.getMessage());
            throw new R01MContentModelException("Error en el env\u00edo del mensaje para el procesado del fichero " + fileName + ".Error:" + jmsExc.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
    }

    public List<R01MOperationInModelObjectResult>[] doImportAttachmentsFromContent(R01MUserContext userCtx, String effectiveImportRootDir, String contentOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Carga de los adjuntos del contenido " + contentOid + " ubicado en el directorio temporal " + effectiveImportRootDir;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DContentImportHelper migHelp = new R01DContentImportHelper(userCtx);
        List<R01MOperationInModelObjectResult>[] results = migHelp.doImportAttachmentsFromContent(effectiveImportRootDir, contentOid);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return results;
    }

    public void doExportContentToFile(R01MUserContext userCtx, String contentOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Generacion del empaquetado del contenido " + contentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DContentExportHelper expHelp = new R01DContentExportHelper(userCtx, new R01DContentModelManager());
        expHelp.doExportContentToFile(contentOid);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
    }

    public void doExportQueryToFile(R01MUserContext userCtx, R01MQueryObject query, String fileName, R01MBaseLocationObject targetLocation, String waRelativePath, boolean exportAttachments) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Notificacion del empaquetado de contenidos para la busqueda: " + query.composeDebugInfo() + " en el directorio " + waRelativePath + " de la WA " + targetLocation.composeMemoCode() + (exportAttachments ? " con adjuntos." : " sin adjuntos.");
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DContentExportHelper expHelp = new R01DContentExportHelper(userCtx, new R01DContentModelManager());
        expHelp.doExportQueryToFile(query, fileName, targetLocation, waRelativePath, exportAttachments);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
    }

    public boolean doProcessExportQueryToFile(R01MUserContext userCtx, R01MQueryObject query, String fileName, R01MBaseLocationObject targetLocation, String waRelativePath, boolean exportAttachments) throws R01MSecurityException, R01MContentModelException, UnsupportedEncodingException {
        String opDesc = "Generacion del empaquetado de contenidos para la busqueda: " + query.composeDebugInfo() + " en el directorio " + waRelativePath + " de la WA " + targetLocation.composeMemoCode() + (exportAttachments ? " con adjuntos." : " sin adjuntos.");
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DContentExportHelper expHelp = new R01DContentExportHelper(userCtx, new R01DContentModelManager());
        boolean processOk = expHelp.doProcessExportQueryToFile(query, fileName, targetLocation, waRelativePath, exportAttachments);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return processOk;
    }

    public void doUploadFileToServer(R01MUserContext userCtx, String fileName, String dstDirAbsolutePath, byte[] buffer, long offset) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Subiendo archivo " + dstDirAbsolutePath + fileName + " al servidor........";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01PPhysicalDataStoreManagerFileSystemImpl rawData = new R01PPhysicalDataStoreManagerFileSystemImpl();
        try {
            rawData.execDoUpdateFileChunk(dstDirAbsolutePath, fileName, buffer, offset, null, true);
        }
        catch (R01MDataStoreException ex) {
            throw new R01MContentModelException("Error al subir el fichero: " + dstDirAbsolutePath + fileName);
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
    }

    public void doGenerateContentXMLDescriptorFromDBRecords(R01MUserContext userCtx, String contentOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Migraci\u00f3n del contenido " + contentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DContentMigrationHelper importHelp = new R01DContentMigrationHelper(userCtx);
        importHelp.doGenerateContentXMLDescriptorFromDBRecords(contentOid);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
    }

    public List[] doGenerateLocationContentsXMLDescriptorFromDBRecords(R01MUserContext userCtx, R01MContentLocation loc) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Migraci\u00f3n de los contenidos de la workArea> " + loc.getServerOid() + ":" + loc.getDataRepositoryOid() + ":" + loc.getAreaOid() + ":" + loc.getWorkAreaOid();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DContentMigrationHelper migHelp = new R01DContentMigrationHelper(userCtx);
        List[] result = migHelp.doGenerateLocationContentsXMLDescriptorFromDBRecords(loc);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return result;
    }

    public List doGetContentOidsByTypo(R01MContentTypologyInfo typo) throws R01MContentModelException {
        List result;
        String opDesc = "Cargando los identificadores de contenidos con la tipolog\u00eda " + typo.composeMemoCode();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DDAOContentModelLoader contentLoader = new R01DDAOContentModelLoader(this._userCtx);
        try {
            result = contentLoader.executeGetContentOidsByTypo(typo);
        }
        catch (R01DContentModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar los contenidos con la tipolog\u00eda " + typo.composeMemoCode() + ".Error:" + ex.getMessage());
            ex.printStackTrace(System.out);
            throw new R01MContentModelException("Error al cargar los contenidos con la tipolog\u00eda " + typo.composeMemoCode() + ".Error:" + ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return result;
    }

    public void doSaveOpendataPackage(R01MUserContext userCtx, R01MOpendataPackage opendataPackage) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Creando/actualizando el empaquetado " + opendataPackage.getOid() + " con nombre " + opendataPackage.getNamePackage();
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DPackageHelper migHelp = new R01DPackageHelper(userCtx);
        migHelp.doSavePackage(opendataPackage);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
    }

    public boolean doDeleteOpendataPackage(R01MUserContext userCtx, String opendataPackageOid) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Borrando el empaquetado " + opendataPackageOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        try {
            if (!this._doCheckPackageExistence(opendataPackageOid)) {
                if (DEBUG) {
                    R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER (end) : El empaquetado de OID " + opendataPackageOid + " no EXISTE, o no se puede borrar!!!.");
                }
                return false;
            }
            R01DPackageHelper migHelp = new R01DPackageHelper(userCtx);
            migHelp.doDeletePackage(opendataPackageOid);
        }
        catch (R01MContentModelException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            throw new R01MContentModelException(opDesc + ".Error:" + ex.getMessage(), (Exception)((Object)ex));
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return true;
    }

    public List doLoadOpendataPackages(R01MUserContext userCtx) throws R01MSecurityException, R01MContentModelException {
        List result;
        String opDesc = "Cargando los empaquetados opendata ";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DDAOContentModelLoader contentLoader = new R01DDAOContentModelLoader(userCtx);
        try {
            result = contentLoader.executeLoadOpendataPackages();
        }
        catch (R01DContentModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar los empaquetados opendata. Error:" + ex.getMessage());
            ex.printStackTrace(System.out);
            throw new R01MContentModelException("Error al cargar los empaquetados opendata. Error:" + ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return result;
    }

    public List<R01MOpendataPackageExtended> doLoadOpendataPackagesExtended(R01MUserContext userCtx) throws R01MSecurityException, R01MContentModelException {
        List result;
        String opDesc = "Cargando los empaquetados opendata ";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DDAOContentModelLoader contentLoader = new R01DDAOContentModelLoader(userCtx);
        try {
            result = contentLoader.executeLoadOpendataPackagesExtended();
        }
        catch (R01DContentModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar los empaquetados opendata. Error:" + ex.getMessage());
            ex.printStackTrace(System.out);
            throw new R01MContentModelException("Error al cargar los empaquetados opendata. Error:" + ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return result;
    }

    public List<R01MOpendataPackage> doLoadOpendataPackagesByContent(R01MUserContext userCtx, String contentOid) throws R01MSecurityException, R01MContentModelException {
        List result;
        String opDesc = "Cargando los empaquetados opendata para un contentOid " + contentOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DDAOContentModelLoader contentLoader = new R01DDAOContentModelLoader(userCtx);
        try {
            result = contentLoader.executeLoadOpendataPackagesByContent(contentOid);
        }
        catch (R01DContentModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar los empaquetados opendata. Error:" + ex.getMessage());
            ex.printStackTrace(System.out);
            throw new R01MContentModelException("Error al cargar los empaquetados opendata. Error:" + ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return result;
    }

    public R01MBaseOpendataPackageInterface doLoadOpendataPackage(R01MUserContext userCtx, String packageOid) throws R01MSecurityException, R01MContentModelException {
        R01MBaseOpendataPackageInterface opendataPackage;
        String opDesc = "Cargando el  empaquetado opendata " + packageOid;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DDAOContentModelLoader contentLoader = new R01DDAOContentModelLoader(userCtx);
        try {
            opendataPackage = contentLoader.executeLoadOpendataPackage(packageOid);
        }
        catch (R01DContentModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar los empaquetados opendata. Error:" + ex.getMessage());
            ex.printStackTrace(System.out);
            throw new R01MContentModelException("Error al cargar los empaquetados opendata. Error:" + ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return opendataPackage;
    }

    public List doLoadOpendataPackagesActivedAndProcessed(R01MUserContext userCtx) throws R01MSecurityException, R01MContentModelException {
        List result;
        String opDesc = "Cargando los empaquetados opendata ";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DDAOContentModelLoader contentLoader = new R01DDAOContentModelLoader(userCtx);
        try {
            result = contentLoader.executeLoadOpendataPackagesActivedAndProcessed();
        }
        catch (R01DContentModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar los empaquetados opendata. Error:" + ex.getMessage());
            ex.printStackTrace(System.out);
            throw new R01MContentModelException("Error al cargar los empaquetados opendata. Error:" + ex.getMessage());
        }
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return result;
    }

    public List doExecutedOpendataPackages(R01MUserContext userCtx) throws R01MSecurityException, R01MContentModelException {
        List result;
        String opDesc = "ejecutando los empaquetados opendata ";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DDAOContentModelLoader contentLoader = new R01DDAOContentModelLoader();
        try {
            result = contentLoader.executeActiveOpendataPackages();
        }
        catch (R01DContentModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar los empaquetados opendata activos. Error:" + ex.getMessage());
            ex.printStackTrace(System.out);
            throw new R01MContentModelException("Error al cargar los empaquetados opendata activos. Error:" + ex.getMessage());
        }
        List<R01MOpendataPackage> activePackages = this._doPeriodicityProcedure(result);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return activePackages;
    }

    public List doLoadActiveOpendataPackages(R01MUserContext userCtx, String lang) throws R01MSecurityException, R01MContentModelException {
        List result;
        String opDesc = "ejecutando los empaquetados opendata ";
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DDAOContentModelLoader contentLoader = new R01DDAOContentModelLoader();
        try {
            result = contentLoader.loadActiveOpendataPackages(lang);
        }
        catch (R01DContentModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error al cargar los empaquetados opendata activos. Error:" + ex.getMessage());
            ex.printStackTrace(System.out);
            throw new R01MContentModelException("Error al cargar los empaquetados opendata activos. Error:" + ex.getMessage());
        }
        List<R01MOpendataPackage> activePackages = this._doPeriodicityProcedure(result);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return activePackages;
    }

    public String doLoadComboOptionDescription(String lang, String comboId, String comboOptionId, String useHTMLFieldAsKey) throws EJBException, R01MContentModelException {
        return R01DComboUtilsHelper.getComboOptionDescription(lang, comboId, comboOptionId, useHTMLFieldAsKey);
    }

    public String doLoadComboOptions(String lang, String comboId, String useHTMLFieldAsKey) throws EJBException, R01MContentModelException {
        return R01DComboUtilsHelper.getComboOptions(lang, comboId, useHTMLFieldAsKey);
    }

    public String doLoadComboOptions(String lang, String comboId, String useHTMLFieldAsKey, String orderCriterium) throws EJBException, R01MContentModelException {
        return R01DComboUtilsHelper.getComboOptions(lang, comboId, useHTMLFieldAsKey, orderCriterium);
    }

    public Map doLoadComboOptionsMap(String lang, String comboId, String useHTMLFieldAsKey) throws R01MContentModelException {
        return R01DComboUtilsHelper.getComboOptionsMap(lang, comboId, useHTMLFieldAsKey);
    }

    public Map doLoadComboOptionsMap(String lang, String comboId, String useHTMLFieldAsKey, String orderCriterium) throws R01MContentModelException {
        return R01DComboUtilsHelper.getComboOptionsMap(lang, comboId, useHTMLFieldAsKey, orderCriterium);
    }

    private boolean _doCheckPackageExistence(String opendataPackageOid) throws R01MContentModelException {
        String opDesc = "Comprobar la existencia del empaquetado " + opendataPackageOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init): " + opDesc);
            }
            R01DDAOContentModelLoader contentLoader = new R01DDAOContentModelLoader(this._userCtx);
            boolean exist = contentLoader.executeCheckPackageExistence(opendataPackageOid);
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end) : " + opDesc + ".Resultado:" + exist);
            }
            return exist;
        }
        catch (R01DContentModelPersistenceException cmEx) {
            cmEx.printStackTrace(System.out);
            throw new R01MContentModelException("Error >>" + opDesc + ".Error:" + cmEx.getMessage());
        }
    }

    private List<R01MOpendataPackage> _doPeriodicityProcedure(List<R01MOpendataPackage> packages) {
        ArrayList<R01MOpendataPackage> activePackages = new ArrayList<R01MOpendataPackage>();
        String packagePeriodicity = null;
        DateTime packageDateTime = null;
        DateTime currentDateTime = new DateTime();
        LocalDate currentDate = new LocalDate((Object)currentDateTime);
        if (packages != null) {
            for (R01MOpendataPackage opendataPackage : packages) {
                int years;
                Interval interval;
                String packDate = opendataPackage.getDatePackage();
                String[] arPackDate = packDate.split("/");
                int packageDay = new Integer(arPackDate[0]);
                int packageMonth = new Integer(arPackDate[1]);
                int packageYear = new Integer(arPackDate[2]);
                packageDateTime = new DateTime(packageYear, packageMonth, packageDay, 0, 0, 0, 0);
                LocalDate packageDate = new LocalDate((Object)packageDateTime);
                packagePeriodicity = opendataPackage.getPeriodicityPackage();
                int valor = currentDateTime.compareTo((Object)packageDateTime);
                if (valor < 0) continue;
                if (packageDate.equals((Object)currentDate)) {
                    activePackages.add(opendataPackage);
                    continue;
                }
                if (packagePeriodicity.equals("D")) {
                    interval = new Interval((ReadableInstant)packageDateTime, (ReadableInstant)currentDateTime);
                    int days = Days.daysIn((ReadableInterval)interval).getDays();
                    if (days == 0 || !currentDate.minusDays(days).equals((Object)packageDate)) continue;
                    activePackages.add(opendataPackage);
                    continue;
                }
                if (packagePeriodicity.equals("S")) {
                    interval = new Interval((ReadableInstant)packageDateTime, (ReadableInstant)currentDateTime);
                    int weeks = Weeks.weeksIn((ReadableInterval)interval).getWeeks();
                    if (weeks == 0 || !currentDate.minusWeeks(weeks).equals((Object)packageDate)) continue;
                    activePackages.add(opendataPackage);
                    continue;
                }
                if (packagePeriodicity.equals("Q")) {
                    interval = new Interval((ReadableInstant)packageDateTime, (ReadableInstant)currentDateTime);
                    int biWeeks = Weeks.weeksIn((ReadableInterval)interval).dividedBy(2).getWeeks();
                    if (biWeeks == 0 || !currentDate.minusWeeks(Weeks.weeks((int)biWeeks).multipliedBy(2).getWeeks()).equals((Object)packageDate)) continue;
                    activePackages.add(opendataPackage);
                    continue;
                }
                if (packagePeriodicity.equals("M")) {
                    interval = new Interval((ReadableInstant)packageDateTime, (ReadableInstant)currentDateTime);
                    int months = Months.monthsIn((ReadableInterval)interval).getMonths();
                    if (months == 0 || !currentDate.minusMonths(months).equals((Object)packageDate)) continue;
                    activePackages.add(opendataPackage);
                    continue;
                }
                if (packagePeriodicity.equals("T")) {
                    interval = new Interval((ReadableInstant)packageDateTime, (ReadableInstant)currentDateTime);
                    int quarterly = Months.monthsIn((ReadableInterval)interval).multipliedBy(3).getMonths();
                    if (quarterly == 0 || !currentDate.minusMonths(Months.months((int)quarterly).dividedBy(3).getMonths()).equals((Object)packageDate)) continue;
                    activePackages.add(opendataPackage);
                    continue;
                }
                if (!packagePeriodicity.equals("A") || (years = Years.yearsIn((ReadableInterval)(interval = new Interval((ReadableInstant)packageDateTime, (ReadableInstant)currentDateTime))).getYears()) == 0 || !currentDate.minusYears(years).equals((Object)packageDate)) continue;
                activePackages.add(opendataPackage);
            }
        }
        return activePackages;
    }

    public List doSearchDocuments(R01MSearchedDocuments srchDocsCriteria) throws R01MContentModelException {
        String opDesc = "Buscar documentos que cumplen el criterio \n " + srchDocsCriteria.debugInfo("");
        R01DDAOContentModelLoader loader = new R01DDAOContentModelLoader();
        try {
            return loader.executeSearchDocuments(srchDocsCriteria);
        }
        catch (R01DContentModelPersistenceException ex) {
            R01FLog.to((String)LOG_TYPE_ID).severe("Error> " + opDesc + ": " + ex.getMessage());
            ex.printStackTrace(System.out);
            throw new R01MContentModelException("Error >>" + opDesc + "Error:" + ex.getMessage());
        }
    }

    public List<String> doGetAllowedTargetsToPublishDocuments() throws R01MContentModelException {
        R01DContentModelLoaderHelper cmLoader = new R01DContentModelLoaderHelper();
        try {
            return cmLoader.loadAllowedTargets();
        }
        catch (R01DContentModelPersistenceException cmEx) {
            R01FLog.to((String)"r01d.services").severe("Error al obtener los repositorios de publicaci\u00f3n para contenidos.Error:" + cmEx.getMessage());
            throw new R01MContentModelException("Error al obtener los repositorios de publicaci\u00f3n para contenidos.Error:" + cmEx.getMessage());
        }
    }

    public List doGetAllowedTargetsAndNamesToPublishDocuments() throws R01MContentModelException {
        R01DContentModelLoaderHelper cmLoader = new R01DContentModelLoaderHelper();
        try {
            return cmLoader.loadAllowedTargetsAndNames();
        }
        catch (R01DContentModelPersistenceException cmEx) {
            R01FLog.to((String)"r01d.services").severe("Error al obtener los repositorios de publicaci\u00f3n para contenidos.Error:" + cmEx.getMessage());
            throw new R01MContentModelException("Error al obtener los repositorios de publicaci\u00f3n para contenidos.Error:" + cmEx.getMessage());
        }
    }

    public List[] doImportContentsFromFile(R01MUserContext userCtx, String fileToImport, String prefix, boolean keepOids) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Carga de los contenidos ubicados en el directorio temporal " + fileToImport;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (init):" + opDesc);
        }
        R01DContentImportHelper migHelp = new R01DContentImportHelper(userCtx);
        List[] result = migHelp.doImportContentsFromArchiveFile(fileToImport, prefix, keepOids);
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("ADMIN SERVER (end):" + opDesc);
        }
        return result;
    }
}

