/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services;

import com.ejie.r01f.sql.DBManager;
import com.ejie.r01f.util.CollectionUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.utils.R01MConstants;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class R01DComboUtilsHelper {
    public static String getComboOptions(String lang, String comboId, String useHTMLFieldAsKey) throws R01MContentModelException {
        if (comboId == null) {
            return "ERROR: No se puede obtener los valores del combo porque el identificador del combo es NULO.";
        }
        StringBuffer outSb = null;
        try {
            boolean bUseHTMLFieldAsKey = StringUtils.isEmptyString((String)useHTMLFieldAsKey) ? false : useHTMLFieldAsKey.equalsIgnoreCase("true");
            Map comboValues = R01DComboUtilsHelper._obtainComboValues(comboId, bUseHTMLFieldAsKey, lang);
            if (comboValues != null && !comboValues.isEmpty()) {
                Map.Entry me2 = null;
                String key = null;
                String val = null;
                outSb = new StringBuffer(comboValues.size() * 64);
                for (Map.Entry me2 : comboValues.entrySet()) {
                    key = (String)me2.getKey();
                    val = (String)me2.getValue();
                    outSb.append("<option value='");
                    outSb.append(key);
                    outSb.append("' label='");
                    outSb.append(val);
                    outSb.append("' selected='true'/>\n");
                }
            } else {
                outSb = new StringBuffer(64);
                outSb.append("NO se han encontrado opciones para el combo ");
                outSb.append(comboId);
                outSb.append(" en ");
                outSb.append(lang);
            }
        }
        catch (SQLException sqlEx) {
            throw new R01MContentModelException("ERROR SQL obtener las opciones del combo " + comboId + "> " + sqlEx.getMessage());
        }
        catch (Exception ex) {
            throw new R01MContentModelException("ERROR desconocido obtener las opciones del combo " + comboId + "> " + ex.getMessage());
        }
        return outSb != null ? outSb.toString() : "";
    }

    public static String getComboOptions(String lang, String comboId, String useHTMLFieldAsKey, String orderCriterium) throws R01MContentModelException {
        if (comboId == null) {
            return "ERROR: No se puede obtener los valores del combo porque el identificador es NULO.";
        }
        StringBuffer outSb = null;
        try {
            boolean bUseHTMLFieldAsKey = StringUtils.isEmptyString((String)useHTMLFieldAsKey) ? false : useHTMLFieldAsKey.equalsIgnoreCase("true");
            int[] lstOrderCriterium = new int[1];
            if (bUseHTMLFieldAsKey && "1".equals(orderCriterium)) {
                orderCriterium = "3";
            }
            lstOrderCriterium[0] = Integer.parseInt(orderCriterium);
            Map comboValues = R01DComboUtilsHelper._obtainComboValues(comboId, bUseHTMLFieldAsKey, lang, lstOrderCriterium);
            if (comboValues != null && !comboValues.isEmpty()) {
                Map.Entry me2 = null;
                String key = null;
                String val = null;
                outSb = new StringBuffer(comboValues.size() * 64);
                for (Map.Entry me2 : comboValues.entrySet()) {
                    key = (String)me2.getKey();
                    val = (String)me2.getValue();
                    outSb.append("<option value='");
                    outSb.append(key);
                    outSb.append("' label='");
                    outSb.append(val);
                    outSb.append("' selected='true'/>\n");
                }
            } else {
                outSb = new StringBuffer(64);
                outSb.append("NO se han encontrado opciones para el combo ");
                outSb.append(comboId);
                outSb.append(" en ");
                outSb.append(lang);
            }
        }
        catch (SQLException sqlEx) {
            throw new R01MContentModelException("ERROR SQL obtener las opciones del combo " + comboId + "> " + sqlEx.getMessage());
        }
        catch (Exception ex) {
            throw new R01MContentModelException("ERROR desconocido obtener las opciones del combo " + comboId + "> " + ex.getMessage());
        }
        return outSb != null ? outSb.toString() : "";
    }

    public static Map getComboOptionsMap(String lang, String comboId, String useHTMLFieldAsKey) throws R01MContentModelException {
        Map comboValues = new HashMap();
        try {
            boolean bUseHTMLFieldAsKey = StringUtils.isEmptyString((String)useHTMLFieldAsKey) ? false : useHTMLFieldAsKey.equalsIgnoreCase("true");
            comboValues = R01DComboUtilsHelper._obtainComboValues(comboId, bUseHTMLFieldAsKey, lang);
        }
        catch (SQLException sqlEx) {
            throw new R01MContentModelException("ERROR SQL obtener las opciones del combo " + comboId + "> " + sqlEx.getMessage());
        }
        catch (Exception ex) {
            throw new R01MContentModelException("ERROR desconocido obtener las opciones del combo " + comboId + "> " + ex.getMessage());
        }
        return comboValues;
    }

    public static Map getComboOptionsMap(String lang, String comboId, String useHTMLFieldAsKey, String orderCriterium) throws R01MContentModelException {
        Map comboValues = new HashMap();
        int[] lstOrderCriterium = new int[]{Integer.parseInt(orderCriterium)};
        try {
            boolean bUseHTMLFieldAsKey;
            boolean bl = StringUtils.isEmptyString((String)useHTMLFieldAsKey) ? false : (bUseHTMLFieldAsKey = useHTMLFieldAsKey.equalsIgnoreCase("true"));
            if (bUseHTMLFieldAsKey && "1".equals(orderCriterium)) {
                orderCriterium = "3";
            }
            comboValues = R01DComboUtilsHelper._obtainComboValues(comboId, bUseHTMLFieldAsKey, lang, lstOrderCriterium);
        }
        catch (SQLException sqlEx) {
            throw new R01MContentModelException("ERROR SQL obtener las opciones del combo " + comboId + "> " + sqlEx.getMessage());
        }
        catch (Exception ex) {
            throw new R01MContentModelException("ERROR desconocido obtener las opciones del combo " + comboId + "> " + ex.getMessage());
        }
        return comboValues;
    }

    public static String getComboOptionDescription(String lang, String comboId, String comboOptionId, String useHTMLFieldAsKey) throws R01MContentModelException {
        return R01DComboUtilsHelper.getComboOptionDescription(lang, comboId, comboOptionId, useHTMLFieldAsKey, null, null);
    }

    public static String getComboOptionDescription(String lang, String comboId, String comboOptionId, String useHTMLFieldAsKey, String alt, String target) throws R01MContentModelException {
        if (comboId == null) {
            return "ERROR: No se puede obtener la descripcion de la opcion id=" + comboOptionId + " porque el identificador del combo es NULO.";
        }
        try {
            boolean bUseHTMLFieldAsKey = StringUtils.isEmptyString((String)useHTMLFieldAsKey) ? false : useHTMLFieldAsKey.equalsIgnoreCase("true");
            return R01DComboUtilsHelper._obtainComboOptionDescription(comboId, comboOptionId, bUseHTMLFieldAsKey, "NOMBRE_21", lang, alt, target);
        }
        catch (SQLException sqlEx) {
            throw new R01MContentModelException("ERROR SQL obtener la descripcion de la opcion id=" + comboOptionId + " del combo " + comboId + "> " + sqlEx.getMessage());
        }
        catch (Exception ex) {
            throw new R01MContentModelException("ERROR desconocido obtener la descripcion de la opcion id=" + comboOptionId + " del combo " + comboId + "> " + ex.getMessage());
        }
    }

    public static String getMultipleComboOptionDescription(String lang, String comboId, String comboOptionId, String useHTMLFieldAsKey) {
        if (comboId == null) {
            return "ERROR: No se puede obtener la descripcion de la opcion id=" + comboOptionId + " porque el identificador del combo es NULO.";
        }
        try {
            boolean bUseHTMLFieldAsKey = StringUtils.isEmptyString((String)useHTMLFieldAsKey) ? false : useHTMLFieldAsKey.equalsIgnoreCase("true");
            return R01DComboUtilsHelper._obtainMultipleComboOptionDescription(comboId, comboOptionId, bUseHTMLFieldAsKey, "NOMBRE_21", lang);
        }
        catch (SQLException sqlEx) {
            sqlEx.printStackTrace(System.out);
            return "ERROR SQL obtener la descripcion de la opcion id=" + comboOptionId + " del combo " + comboId + "> " + sqlEx.getMessage();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            return "ERROR desconocido obtener la descripcion de la opcion id=" + comboOptionId + " del combo " + comboId + "> " + ex.getMessage();
        }
    }

    public static String getComboAppLangs(String userLang) {
        if (userLang == null) {
            return null;
        }
        StringBuffer outSb = new StringBuffer(20);
        StringBuffer comboHtml = null;
        outSb.append("<params>");
        try {
            Map comboValues = R01MClientFactory.getMiscellaneousAPI().getLanguages(userLang);
            if (comboValues != null && !comboValues.isEmpty()) {
                Map.Entry me2 = null;
                String key = null;
                String val = null;
                comboHtml = new StringBuffer(comboValues.size() * 64);
                for (Map.Entry me2 : comboValues.entrySet()) {
                    key = (String)me2.getKey();
                    val = (String)me2.getValue();
                    comboHtml.append("<option value='");
                    comboHtml.append(key);
                    comboHtml.append("' label='");
                    comboHtml.append(val);
                    comboHtml.append("' selected='true'/>\n");
                }
            } else {
                comboHtml = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
            comboHtml = null;
        }
        return comboHtml == null ? null : comboHtml.toString();
    }

    private static String _obtainComboOptionDescription(String comboOid, String optionOid, boolean useHTMLFieldAsKey, String field, String lang, String alt, String target) throws SQLException {
        String keyCol = useHTMLFieldAsKey ? "HTML_21" : "PK_21";
        String[] cols = new String[]{"R01D21T01." + field};
        String[] tables = new String[]{"R01D21T01"};
        String where = "R01D21T01.COMBO_ID_21 = ? AND R01D21T01." + keyCol + " = ? AND R01D21T01.IDIOMA_COMBO_21 = ?";
        ArrayList<String> params = new ArrayList<String>(3);
        params.add(comboOid);
        params.add(optionOid);
        params.add(lang);
        DBManager dbManager = new DBManager(R01MConstants.CONTENTMANAGER_APPCODE, "contentQueryConnection");
        List rdo = dbManager.executeSelect(CollectionUtils.strArrayToList((String[])cols), CollectionUtils.strArrayToList((String[])tables), params, where, null, false, false);
        Map aux = rdo != null ? (Map)rdo.get(0) : null;
        String optionDesc = aux != null ? (String)aux.get(field) : null;
        String targetValue = target;
        if (comboOid.equals("535") && !field.equals("HTML_21") && optionDesc != null) {
            String urlElemento = R01DComboUtilsHelper._obtainComboOptionDescription(comboOid, optionOid, useHTMLFieldAsKey, "HTML_21", lang, alt, targetValue);
            if (targetValue != null && !StringUtils.isEmptyString((String)targetValue)) {
                targetValue = "target=\"" + targetValue + "\"";
            }
            return urlElemento != null ? "<a  " + targetValue + " href=\"" + urlElemento + "\" alt=\"" + alt + "\">" + StringUtils.encodeUTF((String)optionDesc) + "</a>" : StringUtils.encodeUTF((String)optionDesc);
        }
        return optionDesc != null ? StringUtils.encodeUTF((String)optionDesc) : "";
    }

    private static String _obtainMultipleComboOptionDescription(String comboOid, String optionOid, boolean useHTMLFieldAsKey, String field, String lang) throws SQLException {
        if (optionOid == null || StringUtils.isEmptyString((String)optionOid)) {
            return "";
        }
        String keyCol = useHTMLFieldAsKey ? "HTML_21" : "PK_21";
        String[] cols = new String[]{"R01D21T01." + field};
        String[] tables = new String[]{"R01D21T01"};
        String where = "R01D21T01.COMBO_ID_21 = ? AND R01D21T01." + keyCol + " IN (" + optionOid + ") AND R01D21T01.IDIOMA_COMBO_21 = ?";
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(comboOid);
        params.add(lang);
        DBManager dbManager = new DBManager(R01MConstants.CONTENTMANAGER_APPCODE, "contentQueryConnection");
        List rdo = dbManager.executeSelect(CollectionUtils.strArrayToList((String[])cols), CollectionUtils.strArrayToList((String[])tables), params, where, null, false, false);
        StringBuffer optionDesc = new StringBuffer();
        if (rdo != null && !rdo.isEmpty()) {
            for (int i = 0; i < rdo.size(); ++i) {
                Map aux = (Map)rdo.get(i);
                optionDesc.append(aux != null ? (String)aux.get(field) : null);
                optionDesc.append(',');
            }
            optionDesc.deleteCharAt(optionDesc.length() - 1);
        }
        return optionDesc != null ? StringUtils.encodeUTF((String)optionDesc.toString()) : "";
    }

    private static Map _obtainComboValues(String comboOid, boolean useHTMLFieldAsKey, String lang) throws SQLException {
        String keyCol = useHTMLFieldAsKey ? "HTML_21" : "PK_21";
        String[] cols = new String[]{"R01D21T01." + keyCol, "R01D21T01.NOMBRE_21"};
        String[] tables = new String[]{"R01D21T01"};
        String where = "COMBO_ID_21= ? AND IDIOMA_COMBO_21 = ? ORDER BY R01D21T01.NOMBRE_21";
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(comboOid);
        params.add(lang);
        DBManager dbManager = new DBManager(R01MConstants.CONTENTMANAGER_APPCODE, "contentQueryConnection");
        List rows = dbManager.executeSelect(CollectionUtils.strArrayToList((String[])cols), CollectionUtils.strArrayToList((String[])tables), params, where, null, false, false);
        if (rows == null) {
            return null;
        }
        LinkedHashMap comboValues = new LinkedHashMap(rows.size());
        Map aux = null;
        for (int i = 0; i < rows.size(); ++i) {
            aux = (Map)rows.get(i);
            comboValues.put(aux.get(keyCol), StringUtils.encodeUTF((String)aux.get("NOMBRE_21").toString()));
        }
        return comboValues;
    }

    private static Map _obtainComboValues(String comboOid, boolean useHTMLFieldAsKey, String lang, int[] lstOrderCriterium) throws SQLException {
        String keyCol = useHTMLFieldAsKey ? "HTML_21" : "PK_21";
        String[] cols = new String[]{"R01D21T01.PK_21,R01D21T01.NOMBRE_21,R01D21T01.HTML_21"};
        String[] tables = new String[]{"R01D21T01"};
        String where = "COMBO_ID_21= ? AND IDIOMA_COMBO_21 = ?";
        ArrayList<String> params = new ArrayList<String>(3);
        params.add(comboOid);
        params.add(lang);
        DBManager dbManager = new DBManager(R01MConstants.CONTENTMANAGER_APPCODE, "contentQueryConnection");
        List rows = dbManager.executeSelect(CollectionUtils.strArrayToList((String[])cols), CollectionUtils.strArrayToList((String[])tables), params, where, lstOrderCriterium, false, false);
        if (rows == null) {
            return null;
        }
        LinkedHashMap comboValues = new LinkedHashMap(rows.size());
        Map aux = null;
        for (int i = 0; i < rows.size(); ++i) {
            aux = (Map)rows.get(i);
            comboValues.put(aux.get(keyCol), StringUtils.encodeUTF((String)aux.get("NOMBRE_21").toString()));
        }
        return comboValues;
    }
}

