/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services;

import com.ejie.r01d.exceptions.R01DContentModelPersistenceException;
import com.ejie.r01d.gestorcontenidos.dbhelppers.dao.R01DDAOStorageContentsLoader;
import com.ejie.r01d.services.R01DContentModelManager;
import com.ejie.r01f.clone.CloneUtils;
import com.ejie.r01f.exceptions.ExceptionUtils;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelOperation;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsOperationImpl;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsOperationsGroup;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsOperationsList;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsPacket;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MCatalogException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MSearchIndexerException;
import com.ejie.r01m.objects.cataloguing.R01MStructureCatalog;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexDefinition;
import com.ejie.r01m.utils.R01MConstants;
import com.ejie.r01m.utils.catalog.R01MCatalogUtils;
import com.ejie.r01m.utils.jms.R01MJMSUtils;
import com.ejie.r01p.config.objects.cataloguing.R01PChangesLabelsOperationBase;
import com.ejie.r01p.services.R01PClientFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class R01DChangesLabelsOperationManager
extends R01PChangesLabelsOperationBase
implements R01MChangesLabelsOperationImpl {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.changeslabelslistener").intValue() != Level.OFF.intValue();
    private transient R01DContentModelManager manager = new R01DContentModelManager();

    public boolean doProcessOperationGroup(R01MUserContext userCtx, String packetOid, R01MChangesLabelsOperationsGroup operationGroup) {
        R01MContent content;
        boolean hasErrors = false;
        if (DEBUG) {
            R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Procesando el grupo de operaciones :\r\n" + operationGroup.composeDebugInfo().toString());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Cargando el contenido " + operationGroup.getObjectOid());
        }
        try {
            content = this.manager.doLoadContent(userCtx, operationGroup.getObjectOid());
        }
        catch (R01MContentModelException cmExc) {
            R01FLog.to((String)"r01d.changeslabelslistener").severe("CONTENT CHANGESLABELSOPERATIONMANAGER >> Error en la carga del contenido " + operationGroup.getObjectOid() + ".Error:" + cmExc.getMessage());
            R01MJMSUtils.sendContentOperationError((String)packetOid, (String)operationGroup.getObjectOid(), (String)("Error en la carga del contenido:" + ExceptionUtils.serializeExceptionStackTrace((Throwable)cmExc)));
            return true;
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01d.changeslabelslistener").severe("CONTENT CHANGESLABELSOPERATIONMANAGER >> Error GENERAL en la carga del contenido " + operationGroup.getObjectOid() + ".Error:" + ex.getMessage());
            R01MJMSUtils.sendContentOperationError((String)packetOid, (String)operationGroup.getObjectOid(), (String)("Error GENERAL en la carga del contenido:" + ExceptionUtils.serializeExceptionStackTrace((Throwable)ex)));
            return true;
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Cargado el contenido " + content.getOid());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Procesando un grupo de operaciones para el contenido " + content.getOid());
        }
        hasErrors = this._doProcessOperationsGroup(userCtx, packetOid, content, operationGroup);
        return hasErrors;
    }

    public Map doCreateOperationsGroups(R01MChangesLabelsPacket changesPacket) throws R01MCatalogException {
        return super.doCreateOperationsGroups(changesPacket, 2);
    }

    public List doReorganizedAdmOperations(List operations) throws R01MCatalogException {
        ArrayList<R01MChangesLabelOperation> newPacketOperations = new ArrayList<R01MChangesLabelOperation>();
        R01DDAOStorageContentsLoader loader = new R01DDAOStorageContentsLoader();
        for (R01MChangesLabelOperation operation : operations) {
            if (operation.getOperationType() >= 1 && operation.getOperationType() <= 6) {
                String[] contentOids;
                try {
                    if (operation.getOperationType() == 4) {
                        if (DEBUG) {
                            R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Buscando contenidos para la operaci\u00f3n DELETE");
                        }
                        contentOids = loader.executeLoadContentsOidsWithCatalog(null, operation.getLabelOid(), null);
                    } else {
                        if (DEBUG) {
                            R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Buscando contenidos con b\u00fasqueda com\u00fan...");
                        }
                        contentOids = loader.executeLoadContentsOidsWithCatalog(operation.getSourceStructureOid(), operation.getLabelOid(), Integer.toString(operation.getSourceRole()));
                    }
                }
                catch (R01DContentModelPersistenceException ex) {
                    throw new R01MCatalogException("Error al consultar los contenidos catalogados en la catalogaci\u00f3n de la operaci\u00f3n " + operation.getOperationOid());
                }
                if (contentOids != null && contentOids.length > 0) {
                    if (DEBUG) {
                        R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Existen " + contentOids.length + " contenidos para ejecutar la operaci\u00f3n solicitada.");
                    }
                    for (int i = 0; i < contentOids.length; ++i) {
                        R01MChangesLabelOperation newOperation = (R01MChangesLabelOperation)CloneUtils.cloneByReflection((Object)operation);
                        newOperation.setObjectOid(contentOids[i]);
                        newOperation.setObjectType(0);
                        newPacketOperations.add(newOperation);
                    }
                    continue;
                }
                R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> No existen contenidos para ejecutar la operaci\u00f3n solicitada.");
                continue;
            }
            R01FLog.to((String)"r01d.changeslabelslistener").warning("CONTENT CHANGESLABELSOPERATIONMANAGER >> Tipo de operaci\u00f3n desconocida");
        }
        return newPacketOperations;
    }

    private boolean _doProcessOperationsGroup(R01MUserContext userCtx, String packetOid, R01MContent content, R01MChangesLabelsOperationsGroup operationGroup) {
        R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Ejecuci\u00f3n de un grupo de operaciones de recatalogaci\u00f3n DE ADMINISTRACION sobre el contenido \"" + content.getOid() + "\"");
        boolean hasErrors = false;
        ArrayList sourceLabels = new ArrayList();
        if (content.getLabels() != null && !content.getLabels().isEmpty()) {
            Iterator itSourceLabels = content.getLabels().iterator();
            while (itSourceLabels.hasNext()) {
                sourceLabels.add(itSourceLabels.next());
            }
        }
        R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Obtener las operaciones...");
        List contentOperations = null;
        try {
            contentOperations = ((R01MChangesLabelsOperationsList)XOManager.getObject((String)R01MConstants.STRUCTURESMODEL_MAPFILE, (String)operationGroup.getOperationsGroupXML())).getOperations();
        }
        catch (XOMarshallerException xoExc) {
            R01FLog.to((String)"r01d.changeslabelslistener").severe("CONTENT CHANGESLABELSOPERATIONMANAGER >> Error al mapear el XML de lista de operaciones a objeto. Error:" + xoExc.getMessage());
            return true;
        }
        R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Tratar las operaciones...");
        boolean bRecatalogContent = false;
        if (contentOperations != null && !contentOperations.isEmpty()) {
            block8: for (R01MChangesLabelOperation operation : contentOperations) {
                if (DEBUG) {
                    R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Ejecutando la operaci\u00f3n :\r\n" + operation.composeDebugInfo("\t").toString());
                }
                if (operation.getOperationType() >= 1 && operation.getOperationType() <= 6) {
                    R01MStructureCatalog newStructureCatalog = null;
                    if (operation.getOperationType() == 2) {
                        newStructureCatalog = new R01MStructureCatalog();
                        newStructureCatalog.setStructureOid(operation.getTargetStructureOid());
                        newStructureCatalog.setOid(operation.getLabelOid());
                        newStructureCatalog.setRole(Integer.toString(operation.getTargetRole()));
                    }
                    if (operation.getOperationType() == 5) {
                        newStructureCatalog = new R01MStructureCatalog();
                        newStructureCatalog.setStructureOid(operation.getSourceStructureOid());
                        newStructureCatalog.setOid(operation.getLabelOid());
                        newStructureCatalog.setRole(Integer.toString(operation.getSourceRole()));
                        if (content.getLabels() != null) {
                            if (R01MCatalogUtils.existCatalogInList((R01MStructureCatalog)newStructureCatalog, (List)content.getLabels())) continue;
                            content.getLabels().add(newStructureCatalog);
                            bRecatalogContent = true;
                            continue;
                        }
                        ArrayList<R01MStructureCatalog> newLabels = new ArrayList<R01MStructureCatalog>();
                        newLabels.add(newStructureCatalog);
                        content.setLabels(newLabels);
                        bRecatalogContent = true;
                        continue;
                    }
                    if (content.getLabels() == null || content.getLabels().isEmpty()) continue;
                    boolean bHitLabel = false;
                    for (R01MStructureCatalog catalog : sourceLabels) {
                        switch (operation.getOperationType()) {
                            case 3: 
                            case 4: 
                            case 6: {
                                if (!catalog.getStructureOid().equals(operation.getSourceStructureOid()) || !catalog.getOid().equals(operation.getLabelOid()) || Integer.parseInt(catalog.getRole()) != operation.getSourceRole()) break;
                                content.setLabels(R01MCatalogUtils.removeCatalogFromList((R01MStructureCatalog)catalog, (List)content.getLabels()));
                                bRecatalogContent = true;
                                bHitLabel = true;
                                break;
                            }
                            case 2: {
                                if (!catalog.getStructureOid().equals(operation.getSourceStructureOid()) || !catalog.getOid().equals(operation.getLabelOid()) || Integer.parseInt(catalog.getRole()) != operation.getSourceRole()) break;
                                content.setLabels(R01MCatalogUtils.removeCatalogFromList((R01MStructureCatalog)catalog, (List)content.getLabels()));
                                content.getLabels().add(newStructureCatalog);
                                bRecatalogContent = true;
                                bHitLabel = true;
                                break;
                            }
                            case 1: {
                                bRecatalogContent = true;
                                break;
                            }
                        }
                        if (!bHitLabel) continue;
                        continue block8;
                    }
                    continue;
                }
                R01FLog.to((String)"r01d.changeslabelslistener").warning("CONTENT CHANGESLABELSOPERATIONMANAGER >> Tipo de operaci\u00f3n desconocida");
            }
            if (bRecatalogContent) {
                if (DEBUG) {
                    R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> EJECUTANDO LA RECATALOGACION DEL CONTENIDO (" + content.getOid() + ")");
                }
                hasErrors = this._launchRecatalogContent(userCtx, packetOid, content);
            } else if (DEBUG) {
                R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> No hay cambios en la catalogaci\u00f3n del contenido de oid " + content.getOid() + ".");
            }
            if (DEBUG) {
                R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Notificando fin de catalogaci\u00f3n del contenido de oid " + content.getOid() + ".");
            }
            R01MJMSUtils.sendContentOperationOK((String)packetOid, (String)content.getOid());
            if (DEBUG) {
                R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Mensaje de la recatalogaci\u00f3n del contenido de oid " + content.getOid() + " enviado.");
            }
        }
        return hasErrors;
    }

    private boolean _launchRecatalogContent(R01MUserContext userCtx, String packetOid, R01MContent content) {
        if (DEBUG) {
            R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Cambiando la catalogaci\u00f3n del contenido de oid " + content.getOid() + ".");
        }
        boolean hasErrors = false;
        if (XMLProperties.get((String)R01MConstants.API_APPCODE, (String)"recatalogConfig/recatalogEnabled", (String)"true").trim().equalsIgnoreCase("true")) {
            try {
                hasErrors = this._recatalogContent(userCtx, packetOid, content);
            }
            catch (Exception ex) {
                R01FLog.to((String)"r01d.changeslabelslistener").severe("CONTENT CHANGESLABELSOPERATIONMANAGER >> Error GENERAL en la RECATALOGACION del contenido " + content.getOid() + ".Error:" + ex.getMessage());
                R01MJMSUtils.sendContentOperationError((String)packetOid, (String)content.getOid(), (String)("Error GENERAL en la RECATALOGACION del contenido:" + ExceptionUtils.serializeExceptionStackTrace((Throwable)ex)));
                hasErrors = true;
            }
        } else {
            StringBuffer msg = new StringBuffer();
            msg.append("Recatalogando el contenido \"");
            msg.append(content.getOid());
            msg.append("\" de nombre \"");
            msg.append(content.getName());
            msg.append("\" en la catalogaci\u00f3n :\n");
            if (content.getLabels() != null && !content.getLabels().isEmpty()) {
                for (R01MStructureCatalog label : content.getLabels()) {
                    msg.append(label.debugInfo("\t"));
                }
            }
            msg.append("\r\n");
            R01MJMSUtils.writeSimulateRecatalogLog((String)packetOid, (String)"Content", (String)msg.toString());
        }
        if (DEBUG) {
            R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Cambiada la catalogaci\u00f3n del contenido de oid " + content.getOid() + ".");
        }
        return hasErrors;
    }

    private boolean _recatalogContent(R01MUserContext userCtx, String packetOid, R01MContent content) {
        R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Guardando el contenido " + content.getOid());
        try {
            this.manager.doSaveContent(userCtx, content);
        }
        catch (Exception ex) {
            R01FLog.to((String)"r01d.changeslabelslistener").severe("CONTENT CHANGESLABELSOPERATIONMANAGER >> Error al guardar el contenido " + content.getOid() + " recatalogado.Error:" + ex.getMessage());
            R01MJMSUtils.sendContentOperationError((String)packetOid, (String)content.getOid(), (String)("Error al guardar el contenido recatalogado:" + ExceptionUtils.serializeExceptionStackTrace((Throwable)ex)));
            return true;
        }
        R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Reindexando el contenido " + content.getOid());
        StringBuffer indexFilesToPublish = new StringBuffer("r01Index/" + content.getName() + "-idxContent.xml");
        if (content.getDocuments() != null && !content.getDocuments().isEmpty()) {
            boolean isDocumentPublished = false;
            block8: for (Map.Entry meDocument : content.getDocuments().entrySet()) {
                R01MDocument document = (R01MDocument)meDocument.getValue();
                List publicationInfo = document.getPublicationInfo();
                if (publicationInfo == null || publicationInfo.isEmpty()) continue;
                for (R01MDocumentPublicationTarget repository : publicationInfo) {
                    try {
                        isDocumentPublished = this.manager.isDocumentPublished(userCtx, repository.getOid(), document.getOid());
                    }
                    catch (R01MContentModelException cmExc) {
                        R01FLog.to((String)"r01d.changeslabelslistener").severe("CONTENT CHANGESLABELSOPERATIONMANAGER >> Error al consultar si el documento " + document.getOid() + " del contenido " + content.getOid() + " est\u00e1 publicado.Error:" + cmExc.getMessage());
                        R01MJMSUtils.sendContentOperationError((String)packetOid, (String)content.getOid(), (String)("Error al consultar si el documento " + document.getOid() + " est\u00e1 publicado:" + ExceptionUtils.serializeExceptionStackTrace((Throwable)cmExc)));
                        return true;
                    }
                    catch (Exception ex) {
                        R01FLog.to((String)"r01d.changeslabelslistener").severe("CONTENT CHANGESLABELSOPERATIONMANAGER >> Error GENERAL al consultar si el documento " + document.getOid() + " del contenido " + content.getOid() + " est\u00e1 publicado.Error:" + ex.getMessage());
                        R01MJMSUtils.sendContentOperationError((String)packetOid, (String)content.getOid(), (String)("Error general al consultar si el documento " + document.getOid() + " est\u00e1 publicado:" + ExceptionUtils.serializeExceptionStackTrace((Throwable)ex)));
                        return true;
                    }
                    if (!isDocumentPublished) continue;
                    indexFilesToPublish.append(",").append(document.getLanguage()).append("_").append(document.getInternalName()).append("/r01Index/").append("catalog.idx").append(",").append(document.getLanguage()).append("_").append(document.getInternalName()).append("/r01Index/").append("r01ContVars.catalog.shtml").append(",").append(document.getLanguage()).append("_").append(document.getInternalName()).append("/r01Index/").append("r01ContMetas.content.inc");
                    continue block8;
                }
            }
            R01FLog.to((String)"r01d.changeslabelslistener").info("CONTENT CHANGESLABELSOPERATIONMANAGER >> Reindexando el contenido " + content.getOid());
            try {
                R01MIndexDefinition indexDefinition = new R01MIndexDefinition(0, content.getOid(), 0, Arrays.asList("catalog.idx", "r01ContMetas.content.inc"), null, isDocumentPublished, 0, null, XMLProperties.getPropertyList((String)R01MConstants.CONTENTMANAGER_APPCODE, (String)"contentIndexConfiguration/indexpublicationRepositories/repository"), indexFilesToPublish.toString());
                R01PClientFactory.getSearchEngineIndexerAPI().index(indexDefinition, R01MConstants.CONTENT_INDEXER_MANAGER);
            }
            catch (R01MSearchIndexerException idxExc) {
                R01FLog.to((String)"r01d.changeslabelslistener").severe("CONTENT CHANGESLABELSOPERATIONMANAGER >> Error al indexar la catalogaci\u00f3n del contenido " + content.getOid() + ".Error:" + idxExc.getMessage());
                R01MJMSUtils.sendContentOperationError((String)packetOid, (String)content.getOid(), (String)("Error al indexar la catalogaci\u00f3n del contenido:" + ExceptionUtils.serializeExceptionStackTrace((Throwable)idxExc)));
                return true;
            }
            catch (Exception ex) {
                R01FLog.to((String)"r01d.changeslabelslistener").severe("CONTENT CHANGESLABELSOPERATIONMANAGER >> Error GENERAL al indexar la catalogaci\u00f3n del contenido " + content.getOid() + ".Error:" + ex.getMessage());
                R01MJMSUtils.sendContentOperationError((String)packetOid, (String)content.getOid(), (String)("Error GENERAL al indexar la catalogaci\u00f3n del contenido:" + ExceptionUtils.serializeExceptionStackTrace((Throwable)ex)));
                return true;
            }
        }
        return false;
    }
}

