/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.services;

import com.ejie.r01d.gestorcontenidos.ejb.cmp.alias.R01DDocumentAliasCMPLocal;
import com.ejie.r01d.gestorcontenidos.ejb.cmp.alias.R01DDocumentAliasCMPUtil;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MContentModelException;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

public class R01DAliasAdminManager {
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.aliasManager").intValue() != Level.OFF.intValue();

    public R01DAliasAdminManager(R01MUserContext userCtx) {
    }

    public void doDeleteDocumentAliasesInState(String documentOid, int state) throws R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)"r01d.aliasManager").info("ALIAS DE DOCUMENTO Y ESTADO (" + documentOid + ", " + state + ") > " + "DELETE > Eliminando los aliases ...");
        }
        try {
            Collection aliasesInState = R01DDocumentAliasCMPUtil.getLocalHome().findByDocumentOidAndState(documentOid, state);
            Iterator itAliasesToUpdate = aliasesInState.iterator();
            while (itAliasesToUpdate.hasNext()) {
                try {
                    ((R01DDocumentAliasCMPLocal)itAliasesToUpdate.next()).remove();
                }
                catch (EJBException ejbEx) {
                    R01FLog.to((String)"r01g.aliasManager").info("Error al eliminar un alias del documento " + documentOid + ". Se continua con el siguiente: " + (Object)((Object)ejbEx));
                }
                catch (RemoveException rEx) {
                    R01FLog.to((String)"r01g.aliasManager").info("Error al eliminar un alias del documento " + documentOid + ". Se continua con el siguiente: " + (Object)((Object)rEx));
                }
            }
        }
        catch (NamingException namEx) {
            R01FLog.to((String)"r01g.aliasManager").severe("ALIAS DE DOCUMENTO Y ESTADO (" + documentOid + ", " + state + ") > " + "Error al encontrar el home del CMP de aliases.");
            namEx.printStackTrace(System.out);
            throw new R01MContentModelException("Error al encontrar el home del CMP de aliases: " + namEx.getMessage());
        }
        catch (FinderException findEx) {
            R01FLog.to((String)"r01g.aliasManager").info("No existen alias para el documento " + documentOid + " y el estado " + state + ". " + "No se actualiza nada.");
        }
        if (DEBUG) {
            R01FLog.to((String)"r01g.aliasManager").info("ALIAS DE DOCUMENTO Y ESTADO (" + documentOid + ", " + state + ") > UPDATE > Aliases actualizados.");
        }
    }
}

