/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.ejb.services.contentpublisher;

import com.ejie.r01d.services.R01DPublisherManager;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01p.objects.publisher.R01PPublishDefinition;
import com.ejie.r01p.services.bzd.R01PPublisherManagerBzd;
import java.rmi.RemoteException;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class R01DContentPublisherServicesSLBaseBean
implements SessionBean,
R01PPublisherManagerBzd {
    private static final long serialVersionUID = 8249740202355959864L;
    private static final String LOG_TYPE_ID = "r01d.services";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.services").intValue() != Level.OFF.intValue();
    private SessionContext context;

    public void setSessionContext(SessionContext newContext) throws EJBException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentPublisherServicesSLBaseBean.setSessionContext()...");
        }
        this.context = newContext;
    }

    public void ejbRemove() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentPublisherServicesSLBaseBean.ejbRemove()...");
        }
    }

    public void ejbActivate() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentPublisherServicesSLBaseBean.ejbActivate()...");
        }
    }

    public void ejbPassivate() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentPublisherServicesSLBaseBean.ejbPassivate()...");
        }
    }

    public void ejbCreate() throws CreateException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentPublisherServicesSLBaseBean.ejbCreate()");
        }
    }

    public void prepareToPublish(R01PPublishDefinition pubDef) throws R01MPublisherException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentPublisherServicesSL.prepareToPublish()...");
        }
        R01MUserContext adminContext = null;
        try {
            adminContext = R01MAuthManager.createMasterSystemUserContext();
            if (pubDef != null && pubDef.getUserName() != null) {
                adminContext.setUserName(pubDef.getUserName());
            }
        }
        catch (R01MSecurityException secEx) {
            throw new R01MPublisherException("Error al tratar de obtener el contexto del usuario administrador", (Exception)((Object)secEx));
        }
        try {
            R01DPublisherManager service = new R01DPublisherManager(adminContext);
            service.prepareToPublish(pubDef);
        }
        catch (R01MPublisherException pEx) {
            throw new EJBException((Exception)((Object)pEx));
        }
    }

    public void prePublish(R01PPublishDefinition pubDef) throws R01MPublisherException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentPublisherServicesSL.prePublish()...");
        }
        R01MUserContext adminContext = null;
        try {
            adminContext = R01MAuthManager.createMasterSystemUserContext();
            if (pubDef != null && pubDef.getUserName() != null) {
                adminContext.setUserName(pubDef.getUserName());
            }
        }
        catch (R01MSecurityException secEx) {
            throw new R01MPublisherException("Error al tratar de obtener el contexto del usuario administrador", (Exception)((Object)secEx));
        }
        try {
            R01DPublisherManager service = new R01DPublisherManager(adminContext);
            service.prePublish(pubDef);
        }
        catch (R01MPublisherException pEx) {
            throw new EJBException((Exception)((Object)pEx));
        }
    }

    public void publish(R01PPublishDefinition pubDef) throws R01MPublisherException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentPublisherServicesSL.publish()...");
        }
        R01MUserContext adminContext = null;
        try {
            adminContext = R01MAuthManager.createMasterSystemUserContext();
            if (pubDef != null && pubDef.getUserName() != null) {
                adminContext.setUserName(pubDef.getUserName());
            }
        }
        catch (R01MSecurityException secEx) {
            throw new R01MPublisherException("Error al tratar de obtener el contexto del usuario administrador", (Exception)((Object)secEx));
        }
        try {
            R01DPublisherManager service = new R01DPublisherManager(adminContext);
            service.publish(pubDef);
        }
        catch (R01MPublisherException pEx) {
            throw new EJBException((Exception)((Object)pEx));
        }
    }

    public void postPublish(R01PPublishDefinition pubDef) throws R01MPublisherException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentPublisherServicesSL.postPublish()...");
        }
        R01MUserContext adminContext = null;
        try {
            adminContext = R01MAuthManager.createMasterSystemUserContext();
            if (pubDef != null && pubDef.getUserName() != null) {
                adminContext.setUserName(pubDef.getUserName());
            }
        }
        catch (R01MSecurityException secEx) {
            throw new R01MPublisherException("Error al tratar de obtener el contexto del usuario administrador", (Exception)((Object)secEx));
        }
        R01DPublisherManager service = new R01DPublisherManager(adminContext);
        try {
            this.postPublishProcess(service, pubDef);
            this.postPublishSendIndex(service, pubDef);
        }
        catch (R01MPublisherException pEx) {
            throw new EJBException((Exception)((Object)pEx));
        }
    }

    public void postPublishProcess(R01DPublisherManager service, R01PPublishDefinition pubDef) throws R01MPublisherException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentPublisherServicesSLBaseBean.postPublishProcess()...");
        }
        service.postPublish(pubDef);
    }

    public void postPublishSendIndex(R01DPublisherManager service, R01PPublishDefinition pubDef) throws R01MPublisherException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentPublisherServicesSLBaseBean.postPublishSendIndex()...");
        }
        service.postPublishIndex(pubDef);
    }

    public void updateStatePublishInfo(String objectOid, int objectType, String publicationOid, int publicationState) throws R01MPublisherException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentPublisherServicesSL.updateStatePublishInfo()...");
        }
        R01MUserContext adminContext = null;
        try {
            adminContext = R01MAuthManager.createMasterSystemUserContext();
        }
        catch (R01MSecurityException secEx) {
            throw new R01MPublisherException("Error al tratar de obtener el contexto del usuario administrador", (Exception)((Object)secEx));
        }
        try {
            R01DPublisherManager service = new R01DPublisherManager(adminContext);
            service.updateStatePublishInfo(objectOid, objectType, publicationOid, publicationState);
        }
        catch (R01MPublisherException pEx) {
            throw new EJBException((Exception)((Object)pEx));
        }
    }
}

