/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.ejb.services.content;

import com.ejie.r01d.services.R01DContentModelManager;
import com.ejie.r01d.services.helpers.R01DIndexerHelper;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.r01m.config.objects.cataloguing.R01MChangesLabelsPacket;
import com.ejie.r01m.config.objects.publisher.R01MPublicationConfig;
import com.ejie.r01m.config.objects.typology.R01MResourcesRenderConfig;
import com.ejie.r01m.context.R01MRoleRights;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MConfigLoadException;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MContentModelObjectsValidatorException;
import com.ejie.r01m.exceptions.R01MDeleteContentException;
import com.ejie.r01m.exceptions.R01MDeleteDataFileException;
import com.ejie.r01m.exceptions.R01MDeleteDocumentException;
import com.ejie.r01m.exceptions.R01MDeleteModelObjectException;
import com.ejie.r01m.exceptions.R01MDirtyContentModelException;
import com.ejie.r01m.exceptions.R01MDuplicateContentException;
import com.ejie.r01m.exceptions.R01MDuplicateDataFileException;
import com.ejie.r01m.exceptions.R01MDuplicateDocumentException;
import com.ejie.r01m.exceptions.R01MDuplicateModelObjectException;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.businesserrors.R01MBusinessErrors;
import com.ejie.r01m.objects.cataloguing.picks.R01MGeoPicks;
import com.ejie.r01m.objects.contentmodel.R01MContent;
import com.ejie.r01m.objects.contentmodel.R01MContentHistory;
import com.ejie.r01m.objects.contentmodel.R01MContentHistoryFilter;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentPublishResume;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MDocument;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublicationTarget;
import com.ejie.r01m.objects.contentmodel.R01MDocumentPublishResume;
import com.ejie.r01m.objects.contentmodel.R01MDocumentRevisionState;
import com.ejie.r01m.objects.contentmodel.R01MLinkedRelationsGroup;
import com.ejie.r01m.objects.contentmodel.R01MSaveContentResult;
import com.ejie.r01m.objects.publisher.R01MPublishActionObject;
import com.ejie.r01m.objects.resources.R01MGallery;
import com.ejie.r01m.objects.resources.R01MGalleryResourcesGroup;
import com.ejie.r01m.objects.resources.R01MLinkedResource;
import com.ejie.r01m.objects.resources.R01MLinkedResourcesGroup;
import com.ejie.r01m.objects.resources.R01MResourceInterface;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexDefinition;
import com.ejie.r01m.objects.searchengine.indexer.R01MIndexableContent;
import com.ejie.r01m.services.R01MClientFactory;
import com.ejie.r01m.services.bzd.R01MContentModelManagerBzd;
import com.ejie.r01m.utils.R01MConstants;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class R01DContentServicesSLBaseBean
implements SessionBean,
R01MContentModelManagerBzd {
    private static final long serialVersionUID = 3360501073894640985L;
    private static final String LOG_TYPE_ID = "r01d.services";
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.services").intValue() != Level.OFF.intValue();
    private SessionContext context;
    private static R01DContentModelManager _linkedResources = new R01DContentModelManager();
    private static R01DContentModelManager _contentCatalog = new R01DContentModelManager();

    public void setSessionContext(SessionContext newContext) throws EJBException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.setSessionContext()...");
        }
        this.context = newContext;
    }

    public void ejbRemove() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.ejbRemove()...");
        }
    }

    public void ejbActivate() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.ejbActivate()...");
        }
    }

    public void ejbPassivate() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.ejbPassivate()...");
        }
    }

    public void ejbCreate() throws CreateException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.ejbCreate()");
        }
    }

    public R01MRoleRights doGetRoleRightsInContent(R01MUserContext userCtx, String contentOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadContentLocation()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doGetRoleRightsInContent(userCtx, contentOid);
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MIndexableContent doGetIndexableContent(R01MUserContext userCtx, String contentOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doGetIndexableContent()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doGetIndexableContent(userCtx, contentOid);
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doSaveContent(R01MUserContext userCtx, R01MContent content, String oidObjectToIndex, int typeObjectToIndex) throws EJBException, R01MSecurityException, R01MContentModelException, R01MDuplicateContentException, R01MDuplicateDocumentException, R01MDuplicateDataFileException, R01MDeleteContentException, R01MDeleteDocumentException, R01MDeleteDataFileException {
        this.doSaveContent(userCtx, content);
    }

    public Map<String, Long> doSaveContent(R01MUserContext userCtx, R01MContent content) throws EJBException, R01MSecurityException, R01MContentModelException, R01MDuplicateContentException, R01MDuplicateDocumentException, R01MDuplicateDataFileException, R01MDeleteContentException, R01MDeleteDocumentException, R01MDeleteDataFileException {
        R01MSaveContentResult result;
        try {
            result = this.doSaveContentReturningPlanTable(userCtx, content);
            this.doIndexContent(content, result.getPlanTableIterator());
        }
        catch (R01MDuplicateContentException dupEx) {
            throw new EJBException((Exception)((Object)dupEx));
        }
        catch (R01MDuplicateDocumentException delEx) {
            throw new EJBException((Exception)((Object)delEx));
        }
        catch (R01MDuplicateDataFileException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        catch (R01MDeleteContentException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        catch (R01MDeleteDocumentException delEx) {
            throw new EJBException((Exception)((Object)delEx));
        }
        catch (R01MDeleteDataFileException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        catch (R01MDirtyContentModelException dirtExc) {
            throw new EJBException((Exception)((Object)dirtExc));
        }
        return result != null ? result.getContentTS() : null;
    }

    public R01MSaveContentResult doSaveContentReturningPlanTable(R01MUserContext userCtx, R01MContent content) throws EJBException, R01MDuplicateContentException, R01MDuplicateDocumentException, R01MDuplicateDataFileException, R01MDeleteContentException, R01MDeleteDocumentException, R01MDeleteDataFileException, R01MContentModelException, R01MSecurityException, R01MDirtyContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doSaveContentReturningPlanTable()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doSaveContentReturningPlanTable(userCtx, content);
        }
        catch (R01MDuplicateContentException dupEx) {
            throw new EJBException((Exception)((Object)dupEx));
        }
        catch (R01MDuplicateDocumentException delEx) {
            throw new EJBException((Exception)((Object)delEx));
        }
        catch (R01MDuplicateDataFileException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        catch (R01MDeleteContentException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        catch (R01MDeleteDocumentException delEx) {
            throw new EJBException((Exception)((Object)delEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        catch (R01MDirtyContentModelException dirtExc) {
            throw new EJBException((Exception)((Object)dirtExc));
        }
    }

    public Long doSaveDocument(R01MUserContext userCtx, String contentOid, R01MDocument document) throws R01MSecurityException, R01MDuplicateContentException, R01MDuplicateDocumentException, R01MDuplicateDataFileException, R01MDeleteContentException, R01MDeleteDocumentException, R01MDeleteDataFileException, R01MContentModelException, R01MDirtyContentModelException {
        R01MSaveContentResult result;
        try {
            result = this.doSaveDocumentReturningPlanTable(userCtx, contentOid, document);
            this.doIndexDocument(document.getOid(), result);
        }
        catch (R01MDuplicateContentException dupEx) {
            throw new EJBException((Exception)((Object)dupEx));
        }
        catch (R01MDuplicateDocumentException delEx) {
            throw new EJBException((Exception)((Object)delEx));
        }
        catch (R01MDuplicateDataFileException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        catch (R01MDeleteContentException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        catch (R01MDeleteDocumentException delEx) {
            throw new EJBException((Exception)((Object)delEx));
        }
        catch (R01MDeleteDataFileException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        return result != null && result.getContentTS() != null && !result.getContentTS().isEmpty() && result.getContentTS().containsKey(document.getOid()) ? (Long)result.getContentTS().get(document.getOid()) : null;
    }

    public R01MSaveContentResult doSaveDocumentReturningPlanTable(R01MUserContext userCtx, String contentOid, R01MDocument document) throws EJBException, R01MDuplicateContentException, R01MDuplicateDocumentException, R01MDuplicateDataFileException, R01MDeleteContentException, R01MDeleteDocumentException, R01MDeleteDataFileException, R01MContentModelException, R01MSecurityException, R01MDirtyContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doSaveDocumentReturningPlanTable()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doSaveDocumentReturningPlanTable(userCtx, contentOid, document);
        }
        catch (R01MDuplicateContentException dupEx) {
            throw new EJBException((Exception)((Object)dupEx));
        }
        catch (R01MDuplicateDocumentException delEx) {
            throw new EJBException((Exception)((Object)delEx));
        }
        catch (R01MDuplicateDataFileException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        catch (R01MDeleteContentException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        catch (R01MDeleteDocumentException delEx) {
            throw new EJBException((Exception)((Object)delEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        catch (R01MDirtyContentModelException dirtExc) {
            throw new EJBException((Exception)((Object)dirtExc));
        }
    }

    public void doIndexContent(R01MContent content, Iterator planTableIterator) throws EJBException, R01MContentModelException {
        if (planTableIterator != null && this.doCheckContentExistence(content.getOid())) {
            R01DContentModelManager service = new R01DContentModelManager();
            service.doIndexContent(content, planTableIterator);
        }
    }

    public void doIndexDocument(String documentOid, R01MSaveContentResult result) throws EJBException, R01MContentModelException {
        if (result != null && result.getPlanTableIterator() != null && this.doCheckDocumentExistence(documentOid)) {
            R01DContentModelManager service = new R01DContentModelManager();
            service.doIndexDocument(documentOid, result.getPlanTableIterator());
        }
    }

    public void doInsertHistoryRecord(R01MUserContext userCtx, R01MContentHistory historyReg, int type) throws EJBException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doInsertHistoryRecord()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            service.doInsertHistoryRecord(userCtx, historyReg, type);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        catch (R01MContentModelObjectsValidatorException ex) {
            throw new EJBException((Exception)((Object)ex));
        }
    }

    public void doGenerateRenders(R01MUserContext userCtx, List<R01MResourcesRenderConfig> renders, Map<String, List<?>> values, Properties props) throws EJBException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doExecuteRender()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            service.doGenerateRenders(userCtx, renders, values, props);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doGenerateRenders(R01MUserContext userCtx, R01MContent content, R01MDocument document, String renderGroup, String renderId) throws EJBException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doSendRenderMessage()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            service.doGenerateRenders(userCtx, content, document, renderGroup, renderId);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doChangeContentCluster(R01MUserContext userCtx, String contentOid, String clusterOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doChangeClusterContent()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            List indexers = new ArrayList();
            indexers = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/default/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer"));
            R01DContentModelManager service = new R01DContentModelManager();
            service.doChangeContentCluster(userCtx, contentOid, clusterOid);
            R01MIndexDefinition indexDefinition = new R01MIndexDefinition(0, contentOid, 0, null, indexers, false, -1, null, null, null);
            R01DIndexerHelper.doIndexObject(indexDefinition);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doChangeContentLocation(R01MUserContext userCtx, String contentOid, R01MContentLocation locTarget) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doChangeLocationContent()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            service.doChangeContentLocation(userCtx, contentOid, locTarget);
            List indexers = new ArrayList();
            indexers = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/default/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer"));
            R01MIndexDefinition indexDefinition = new R01MIndexDefinition(0, contentOid, 0, null, indexers, false, -1, null, null, null);
            R01DIndexerHelper.doIndexObject(indexDefinition);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
    }

    public String doCopyContent(R01MUserContext userCtx, String contentOid, R01MContentLocation locTarget, String newContentName) throws EJBException, R01MSecurityException, R01MDuplicateContentException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doCopyContent()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            String newContentOid = service.doCopyContent(userCtx, contentOid, locTarget, newContentName);
            return newContentOid;
        }
        catch (R01MDuplicateModelObjectException dupEx) {
            throw new EJBException((Exception)((Object)dupEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public String doMoveContentToAnotherArea(R01MUserContext userCtx, String contentOid, String newAreaOid, String newWorkAreaOid, boolean publishDocuments, int actionType, String contentNameTarget, String newDataRepositoryOid, String newServerOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        Object[] components = this.doMoveContentToAnotherAreaTX(userCtx, contentOid, newAreaOid, newWorkAreaOid, publishDocuments, actionType, contentNameTarget, newDataRepositoryOid, newServerOid);
        this.doIndexContent((R01MContent)components[0], ((R01MSaveContentResult)components[1]).getPlanTableIterator());
        return ((R01MContent)components[0]).getOid();
    }

    public Object[] doMoveContentToAnotherAreaTX(R01MUserContext userCtx, String contentOid, String newAreaOid, String newWorkAreaOid, boolean publishDocuments, int actionType, String contentNameTarget, String newDataRepositoryOid, String newServerOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doMoveContentToAnotherArea()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doMoveContentToAnotherAreaTX(userCtx, contentOid, newAreaOid, newWorkAreaOid, publishDocuments, actionType, contentNameTarget, newDataRepositoryOid, newServerOid);
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doDeleteContent(R01MUserContext userCtx, String contentOid) throws EJBException, R01MDeleteContentException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doDeleteContent()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            service.doDeleteContent(userCtx, contentOid);
            R01MIndexDefinition indexDefinition = new R01MIndexDefinition(1, contentOid, 0, null, null, false, -1, null, null, null);
            R01DIndexerHelper.doUnIndexObject(indexDefinition);
        }
        catch (R01MDeleteModelObjectException delEx) {
            throw new EJBException((Exception)((Object)delEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doForceDeleteContent(R01MUserContext userCtx, String contentOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doForceDeleteContent()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            service.doForceDeleteContent(userCtx, contentOid);
            R01MIndexDefinition indexDefinition = new R01MIndexDefinition(1, contentOid, 0, null, null, false, -1, null, null, null);
            R01DIndexerHelper.doUnIndexObject(indexDefinition);
        }
        catch (R01MContentModelException delEx) {
            throw new EJBException((Exception)((Object)delEx));
        }
    }

    public void doForceDeleteDocuments(R01MUserContext userCtx, String contentOid, List documentOids, boolean deleteLinked, boolean forceLinkedUnpublish, boolean deleteEmptyContents) throws EJBException, R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doForceDeleteDocument()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            service.doForceDeleteDocuments(userCtx, contentOid, documentOids, deleteLinked, forceLinkedUnpublish, deleteEmptyContents);
        }
        catch (R01MContentModelException delEx) {
            throw new EJBException((Exception)((Object)delEx));
        }
    }

    public void doDeleteDocuments(R01MUserContext userCtx, Map documentsContentsOids, boolean deleteLinked, boolean forceUnpublish, boolean forceLinkedUnpublish, boolean deleteEmptyContents) throws EJBException, R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doDeleteDocuments()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            service.doDeleteDocuments(userCtx, documentsContentsOids, deleteLinked, forceUnpublish, forceLinkedUnpublish, deleteEmptyContents);
        }
        catch (R01MSecurityException delEx) {
            throw new EJBException((Exception)((Object)delEx));
        }
    }

    public boolean doCheckContentCatalogs(R01MUserContext userCtx, R01MContent content) throws R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doCheckContentCatalogs()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doCheckContentCatalogs(userCtx, content);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doSaveContentGeoLabels(R01MUserContext userCtx, String contentOid, R01MGeoPicks geoCatalogs) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doSaveContentGeoLabels()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            service.doSaveContentGeoLabels(userCtx, contentOid, geoCatalogs);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
    }

    public boolean doCheckContentExistence(String contentOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doCheckContentExistence()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doCheckContentExistence(contentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public boolean doCheckAliasExistence(String alias) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doCheckContentExistence()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doCheckAliasExistence(alias);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public boolean doCheckContentDocumentRelation(String contentOid, String documentOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doCheckContentDocumentRelation()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doCheckContentDocumentRelation(contentOid, documentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public boolean doCheckContentDocumentDatafileRelation(String contentOid, String documentOid, String datafileOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doCheckContentDocumentDatafileRelation()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doCheckContentDocumentDatafileRelation(contentOid, documentOid, datafileOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public boolean doCheckDocumentDatafileRelation(String documentOid, String datafileOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doCheckDocumentDatafileRelation()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doCheckDocumentDatafileRelation(documentOid, datafileOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public boolean doCheckDocumentExistence(String documentOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doCheckDocumentExistence()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doCheckDocumentExistence(documentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public boolean doCheckDatafileExistence(String datafileOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doCheckDatafileExistence()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doCheckDatafileExistence(datafileOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MContent doLoadContent(R01MUserContext userCtx, String contentOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadContent()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadContent(userCtx, contentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MDocument doLoadDocument(R01MUserContext userCtx, String documentOid) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadDocument()...");
        }
        try {
            if (!this.doCheckDocumentExistence(documentOid)) {
                throw new R01MContentModelException("El documento de identificador '" + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadDocument(userCtx, documentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MContent doLoadContentLazy(R01MUserContext userCtx, String contentOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadContentLazy()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadContentLazy(userCtx, contentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doGetDefaultLabels(R01MContentLocation loc, R01MContentTypologyInfo typo) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadContentLocation()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doGetDefaultLabels(loc, typo);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MContentLocation doLoadContentLocation(R01MUserContext userCtx, String contentOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadContentLocation()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadContentLocation(userCtx, contentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MContentTypologyInfo doLoadContentTypology(R01MUserContext userCtx, String contentOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadContentTypology()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadContentTypology(userCtx, contentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MContentTypologyInfo doLoadContentTypology(R01MUserContext userCtx, String objectOid, int objectType) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadContentTypology()...");
        }
        try {
            switch (objectType) {
                case 0: {
                    if (this.doCheckContentExistence(objectOid)) break;
                    throw new R01MContentModelException("El contenido de identificador '" + objectOid + "' NO EXISTE.");
                }
                case 1: {
                    if (this.doCheckDocumentExistence(objectOid)) break;
                    throw new R01MContentModelException("El documento de identificador '" + objectOid + "' NO EXISTE.");
                }
                case 2: {
                    if (this.doCheckDatafileExistence(objectOid)) break;
                    throw new R01MContentModelException("El archivo de datos de identificador '" + objectOid + "' NO EXISTE.");
                }
                default: {
                    return null;
                }
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadContentTypology(userCtx, objectOid, objectType);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doLoadContentStructureLabels(R01MUserContext userCtx, String contentOid, String structureOid, String role, boolean strictRole) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadContentStructureCatalogs()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadContentStructureLabels(userCtx, contentOid, structureOid, role, strictRole);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MGeoPicks doLoadContentGeoLabels(R01MUserContext userCtx, String contentOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadContentGeoCatalogs()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadContentGeoLabels(userCtx, contentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doLoadContentHistory(R01MUserContext userCtx, String contentOid, R01MContentHistoryFilter filter) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadContentHistory()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadContentHistory(userCtx, contentOid, filter);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doLoadUserContentLastActions(R01MUserContext userCtx, int numActions, String lang) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadUserContentLastActions()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadUserContentLastActions(userCtx, numActions, lang);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doFrequentlyModifyUserActivity(R01MUserContext userCtx, int numActions) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doFrequentlyModifyUserActivity()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doFrequentlyModifyUserActivity(userCtx, numActions);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doFrequentlyCreatedUserActivity(R01MUserContext userCtx, int numActions) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doFrequentlyModifyUserActivity()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doFrequentlyCreatedUserActivity(userCtx, numActions);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public boolean isDocumentPublished(R01MUserContext userCtx, String target, String documentOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.isDocumentPublished()...");
        }
        try {
            if (!this.doCheckDocumentExistence(documentOid)) {
                throw new R01MContentModelException("El documento de identificador '" + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.isDocumentPublished(userCtx, target, documentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MContent doLoadContentDocumentLazy(R01MUserContext userCtx, R01MContent inContent, String documentOid) throws EJBException, R01MContentModelException, R01MSecurityException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadContentDocumentLazy()...");
        }
        try {
            if (!this.doCheckContentDocumentRelation(inContent.getOid(), documentOid)) {
                throw new R01MContentModelException("La relacion contenido <-> documento de identificador '" + inContent.getOid() + " <-> " + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadContentDocumentLazy(userCtx, inContent, documentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public Map doLoadRunningPublications(R01MUserContext userCtx) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadRunningPublications()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadRunningPublications(userCtx);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public Date doLoadContentIndexStartDate(R01MUserContext userCtx, String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadContentIndexStartDate()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadContentIndexStartDate(userCtx, contentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public Date doLoadDocumentIndexStartDate(R01MUserContext userCtx, String documentOid) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadDocumentIndexStartDate()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadDocumentIndexStartDate(userCtx, documentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doSetContentIndexStartDate(R01MUserContext userCtx, String contentOid, Date indexStartDate) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doSetContentIndexStartDate()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            service.doSetContentIndexStartDate(userCtx, contentOid, indexStartDate);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doSetDocumentIndexStartDate(R01MUserContext userCtx, String documentOid, Date indexStartDate) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doSetDocumentIndexStartDate()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            service.doSetDocumentIndexStartDate(userCtx, documentOid, indexStartDate);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public String doLoadContentIndexersState(R01MUserContext userCtx, String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadContentIndexersState()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadContentIndexersState(userCtx, contentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doLoadDocumentAliasesInState(R01MUserContext userCtx, String documentOid, int state) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadDocumentAliasesInState()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadDocumentAliasesInState(userCtx, documentOid, state);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public String doLoadDocumentIndexersState(R01MUserContext userCtx, String documentOid) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadDocumentIndexersState()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadDocumentIndexersState(userCtx, documentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doSetContentIndexersState(R01MUserContext userCtx, String contentOid, String indexersState) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doSetContentIndexersState()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            service.doSetContentIndexersState(userCtx, contentOid, indexersState);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doSetDocumentIndexersState(R01MUserContext userCtx, String documentOid, String indexersState) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doSetDocumentIndexersState()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            service.doSetDocumentIndexersState(userCtx, documentOid, indexersState);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doSetContentPublishIndexFiles(R01MUserContext userCtx, String contentOid, boolean hasToPublishIndexFiles) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doSetContentPublishIndexFiles()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            service.doSetContentPublishIndexFiles(userCtx, contentOid, hasToPublishIndexFiles);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doSetDocumentPublishIndexFiles(R01MUserContext userCtx, String documentoOid, boolean hasToPublishIndexFiles) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doSetDocumentPublishIndexFiles()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            service.doSetDocumentPublishIndexFiles(userCtx, documentoOid, hasToPublishIndexFiles);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public String doGetContentOidFromContentTypeAndName(String contentType, String contentName) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doGetContentOidFromContentTypeAndName()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doGetContentOidFromContentTypeAndName(contentType, contentName);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public String doGetDocumentParentContent(String documentOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doGetDocumentParentContent()...");
        }
        try {
            if (!this.doCheckDocumentExistence(documentOid)) {
                throw new R01MContentModelException("El documento de identificador '" + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doGetDocumentParentContent(documentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public Map doGetAvailableLanguagesToTranslateDocument(R01MUserContext userCtx, String documentOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadAvailableLanguagesToTranslateDocument()...");
        }
        try {
            if (!this.doCheckDocumentExistence(documentOid)) {
                throw new R01MContentModelException("El documento de identificador '" + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doGetAvailableLanguagesToTranslateDocument(userCtx, documentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MDocumentRevisionState doRequestDocumentRevision(R01MUserContext userCtx, String contentOid, String documentOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doRequestDocumentRevision()...");
        }
        try {
            if (!this.doCheckContentDocumentRelation(contentOid, documentOid)) {
                throw new R01MContentModelException("La relacion contenido <-> documento '" + contentOid + " <-> " + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doRequestDocumentRevision(userCtx, contentOid, documentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MContent doPublishAllDocuments(R01MUserContext userCtx, String contentOid, int publicationType, Date publicationDate, boolean onlyPublished, List stepsActions) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doPublishAllDocuments()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doPublishAllDocuments(userCtx, contentOid, publicationType, publicationDate, onlyPublished, stepsActions);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MContent doPublishAllDocuments(R01MUserContext userCtx, String contentOid, int publicationType, Date publicationDate, boolean onlyPublished) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doPublishAllDocuments()...");
        }
        try {
            return this.doPublishAllDocuments(userCtx, contentOid, publicationType, publicationDate, onlyPublished, null);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MDocument doPublishDocument(R01MUserContext userCtx, String documentOid, int publicationType, Date publicationDate) throws R01MSecurityException, R01MPublisherException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doPublishAllDocuments()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doPublishDocument(userCtx, documentOid, publicationType, publicationDate);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MContent doPublishDocuments(R01MUserContext userCtx, String contentOid, List documentOids, int publicationType, Date publicationDate, boolean onlyPublished, List stepsActions) throws EJBException, R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doPublishDocuments()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doPublishDocuments(userCtx, contentOid, documentOids, publicationType, publicationDate, onlyPublished, stepsActions);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doPublishDocuments(R01MUserContext userCtx, List documentOids, int publicationType, Date publicationDate, List stepsActions, String pubRepositoryOid) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doPublishDocuments()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            service.doPublishDocuments(userCtx, documentOids, publicationType, publicationDate, stepsActions, pubRepositoryOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doPublishDocuments(R01MUserContext userCtx, List documentOids, int publicationType, Date publicationDate, List stepsActions) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doPublishDocuments()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            service.doPublishDocuments(userCtx, documentOids, publicationType, publicationDate, stepsActions);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MDocumentRevisionState doAproveDocument(R01MUserContext userCtx, String contentOid, String documentOid, List stepsActions) throws EJBException, R01MPublisherException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doAproveDocument()...");
        }
        try {
            if (!this.doCheckContentDocumentRelation(contentOid, documentOid)) {
                throw new R01MContentModelException("La relacion contenido <-> documento de identificador '" + contentOid + " <-> " + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doAproveDocument(userCtx, contentOid, documentOid, (List<R01MPublishActionObject>)stepsActions);
        }
        catch (R01MPublisherException pubEx) {
            throw new EJBException((Exception)((Object)pubEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MDocumentRevisionState doAproveDocument(R01MUserContext userCtx, R01MContent content, String documentOid, List stepsActions) throws EJBException, R01MPublisherException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doAproveDocument()...");
        }
        try {
            if (!this.doCheckContentDocumentRelation(content.getOid(), documentOid)) {
                throw new R01MContentModelException("La relacion contenido <-> documento de identificador '" + content + " <-> " + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doAproveDocument(userCtx, content, documentOid, (List<R01MPublishActionObject>)stepsActions);
        }
        catch (R01MPublisherException pubEx) {
            throw new EJBException((Exception)((Object)pubEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MDocumentRevisionState doAproveDocument(R01MUserContext userCtx, String contentOid, String documentOid) throws EJBException, R01MPublisherException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doAproveDocument()...");
        }
        try {
            if (!this.doCheckContentDocumentRelation(contentOid, documentOid)) {
                throw new R01MContentModelException("La relacion contenido <-> documento de identificador '" + contentOid + " <-> " + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doAproveDocument(userCtx, contentOid, documentOid, null);
        }
        catch (R01MPublisherException pubEx) {
            throw new EJBException((Exception)((Object)pubEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MDocumentRevisionState doRejectDocument(R01MUserContext userCtx, String contentOid, String documentOid, String notes) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doRejectDocument()...");
        }
        try {
            if (!this.doCheckContentDocumentRelation(contentOid, documentOid)) {
                throw new R01MContentModelException("La relacion contenido <-> documento de identificador '" + contentOid + " <-> " + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doRejectDocument(userCtx, contentOid, documentOid, notes);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MDocumentRevisionState doEditDocument(R01MUserContext userCtx, String contentOid, String documentOid, String notes) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doEditDocument()...");
        }
        try {
            if (!this.doCheckContentDocumentRelation(contentOid, documentOid)) {
                throw new R01MContentModelException("La relacion contenido <-> documento de identificador '" + contentOid + " <-> " + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doEditDocument(userCtx, contentOid, documentOid, notes);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MDocument doTranslateDocument(R01MUserContext userCtx, String contentOid, String documentOid, String languageOid, boolean copyAttachment) throws EJBException, R01MSecurityException, R01MDuplicateDocumentException, R01MContentModelException {
        R01MDocument dr = null;
        try {
            dr = this.doTranslateDocumentLanguage(userCtx, contentOid, documentOid, languageOid, copyAttachment);
            this.doTranslateLinks(userCtx, contentOid, documentOid, dr.getOid(), languageOid, true);
        }
        catch (R01MDuplicateDocumentException dupEx) {
            throw new EJBException((Exception)((Object)dupEx));
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        return dr;
    }

    public R01MDocument doTranslateDocumentLanguage(R01MUserContext userCtx, String contentOid, String documentOid, String languageOid, boolean copyAttachment) throws EJBException, R01MDuplicateDocumentException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doTranslateDocument()...");
        }
        try {
            if (!this.doCheckContentDocumentRelation(contentOid, documentOid)) {
                throw new R01MContentModelException("La relacion contenido <-> documento de identificador '" + contentOid + " <-> " + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            R01MDocument documentResume = service.doTranslateDocument(userCtx, contentOid, documentOid, languageOid, copyAttachment);
            List indexers = new ArrayList();
            indexers = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/default/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer"));
            R01MIndexDefinition indexDefinition = new R01MIndexDefinition(0, contentOid, 0, null, indexers, false, -1, null, null, null);
            R01DIndexerHelper.doIndexObject(indexDefinition);
            return documentResume;
        }
        catch (R01MDuplicateModelObjectException dupEx) {
            throw new EJBException((Exception)((Object)dupEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MLinkedResource doTranslateLinks(R01MUserContext userCtx, String contentOid, String srcDocumentOid, String translatedDocumentOid, String srcLanguageOid, boolean generateHTMLAsync) throws EJBException, R01MSecurityException, R01MContentModelException {
        R01MLinkedResource currLnkNuevo = null;
        R01MLinkedResourcesGroup docLinkedRelations = this.doGetDocumentLinkedResources(userCtx, srcDocumentOid);
        if (docLinkedRelations != null) {
            R01MLinkedResourcesGroup docTranslationLinkedRelations = new R01MLinkedResourcesGroup();
            R01DContentModelManager service = new R01DContentModelManager();
            if (docLinkedRelations.getResourcesGroupByContainer() != null && !docLinkedRelations.getResourcesGroupByContainer().isEmpty()) {
                docTranslationLinkedRelations.setTitleGroupLabel(docLinkedRelations.getTitleGroupLabel());
                for (Map.Entry me : docLinkedRelations.getResourcesGroupByContainer().entrySet()) {
                    List listaLink = (List)me.getValue();
                    if (listaLink == null || listaLink.isEmpty()) continue;
                    for (R01MLinkedResource currLnkRes : listaLink) {
                        currLnkNuevo = service.doGetLinkedTranslated(currLnkRes, srcLanguageOid, srcDocumentOid);
                        docTranslationLinkedRelations.setResources(docLinkedRelations.getResources());
                    }
                    try {
                        R01MPublicationConfig pub;
                        R01MContent content = this.doLoadContent(userCtx, contentOid);
                        if (content == null) {
                            throw new R01MContentModelException("NO se ha podido cargar el contenido " + contentOid);
                        }
                        try {
                            pub = R01MClientFactory.getStorageConfigAPI().getWorkAreaConfig(content.getStoreLocation().getWorkAreaOid()).getAllowedPublicationTargetsConfig();
                        }
                        catch (R01MConfigLoadException cfgExc) {
                            R01FLog.to((String)LOG_TYPE_ID).severe("Error al obtener los repositorios de publicaci\u00f3n de la workarea. Los documentos del contenido " + content.getOid() + " " + "no se publican. Error:" + cfgExc.getMessage());
                            throw new R01MContentModelException("Error al obtener los repositorios de publicaci\u00f3n de la workarea. Los documentos del contenido " + content.getOid() + " " + "no se publican.", (Exception)((Object)cfgExc));
                        }
                        if (DEBUG) {
                            R01FLog.to((String)LOG_TYPE_ID).info("MODEL SERVER >> Obtenida la ihnformaci\u00f3n de publicaci\u00f3n del workarea donde se encuentra el contenido contenido con oid " + content.getOid() + ".");
                        }
                        if (pub.getAllowedTargets() == null || pub.getAllowedTargets().isEmpty()) continue;
                        for (String targetRepOid : pub.getAllowedTargets().keySet()) {
                            this.doSetDocumentLinkedResources(userCtx, contentOid, translatedDocumentOid, targetRepOid, docTranslationLinkedRelations, null, generateHTMLAsync);
                        }
                    }
                    catch (R01MContentModelObjectsValidatorException cmvalExc) {
                        throw new R01MContentModelException("Los objetos de vinculaci\u00f3n son incorrectos. Error:" + cmvalExc.getMessage(), (Exception)((Object)cmvalExc));
                    }
                }
            }
        }
        return currLnkNuevo;
    }

    public R01MDocument doCopyDocument(R01MUserContext userCtx, String contentOid, String documentOid, String newInternalName, boolean copyAttachment) throws EJBException, R01MSecurityException, R01MDuplicateDocumentException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doCopyDocument()...");
        }
        try {
            if (!this.doCheckContentDocumentRelation(contentOid, documentOid)) {
                throw new R01MContentModelException("La relacion contenido <-> documento de identificador '" + contentOid + " <-> " + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            R01MDocument documentResume = service.doCopyDocument(userCtx, contentOid, documentOid, newInternalName, copyAttachment);
            List indexers = new ArrayList();
            indexers = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/default/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer"));
            R01MIndexDefinition indexDefinition = new R01MIndexDefinition(0, contentOid, 0, null, indexers, false, -1, null, null, null);
            R01DIndexerHelper.doIndexObject(indexDefinition);
            return documentResume;
        }
        catch (R01MDuplicateModelObjectException dupEx) {
            throw new EJBException((Exception)((Object)dupEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List<R01MDocument> doCopyDocumentInto(R01MUserContext userCtx, String contentOid, String sourceDocumentOid, String targetDocumentOid, boolean copyAttachment) throws EJBException, R01MSecurityException, R01MDuplicateDocumentException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doCopyDocument()...");
        }
        try {
            if (!this.doCheckContentDocumentRelation(contentOid, sourceDocumentOid)) {
                throw new R01MContentModelException("La relacion contenido <-> documento origen de identificador '" + contentOid + " <-> " + sourceDocumentOid + "' NO EXISTE.");
            }
            if (!this.doCheckContentDocumentRelation(contentOid, targetDocumentOid)) {
                throw new R01MContentModelException("La relacion contenido <-> documento destino de identificador '" + contentOid + " <-> " + targetDocumentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            List<R01MDocument> result = service.doCopyDocumentInto(userCtx, contentOid, sourceDocumentOid, targetDocumentOid, copyAttachment);
            List indexers = new ArrayList();
            indexers = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/default/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer"));
            R01MIndexDefinition indexDefinition = new R01MIndexDefinition(0, contentOid, 0, null, indexers, false, -1, null, null, null);
            R01DIndexerHelper.doIndexObject(indexDefinition);
            return result;
        }
        catch (R01MDuplicateModelObjectException dupEx) {
            throw new EJBException((Exception)((Object)dupEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MDocument doSetDocumentInitialPage(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doSetDocumentInitialPage()...");
        }
        try {
            if (!this.doCheckContentDocumentDatafileRelation(contentOid, documentOid, dataFileOid)) {
                throw new R01MContentModelException("La relacion contenido <-> documento <-> archivo de identificador '" + contentOid + " <-> " + documentOid + " <-> " + dataFileOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doSetDocumentInitialPage(userCtx, contentOid, documentOid, dataFileOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MLinkedResourcesGroup doSetDocumentLinkedResources(R01MUserContext userCtx, String contentOid, String documentOid, String docPublishRepoOid, R01MLinkedResourcesGroup resourcesGroup, Map inversePresentationTagIds, boolean generateHTMLAsync) throws EJBException, R01MSecurityException, R01MContentModelObjectsValidatorException, R01MContentModelException {
        R01MLinkedResourcesGroup updateResourcesGroup = null;
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doSetDocumentLinkedResources()...");
        }
        try {
            if (!this.doCheckContentDocumentRelation(contentOid, documentOid)) {
                throw new R01MContentModelException("La relacion contenido <-> documento '" + contentOid + " <-> " + documentOid + "' NO EXISTE.");
            }
            R01MContent content = this.doLoadContent(userCtx, contentOid);
            if (content.getDocument(documentOid).getDataFiles() == null || content.getDocument(documentOid).getDataFiles().isEmpty()) {
                throw new R01MContentModelObjectsValidatorException("El documento no tiene archivos creados, debe tener al menos uno para poder crear vinculaciones.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            updateResourcesGroup = service.doSetDocumentLinkedResources(userCtx, contentOid, documentOid, docPublishRepoOid, resourcesGroup, inversePresentationTagIds, generateHTMLAsync);
            List indexers = new ArrayList();
            indexers = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/default/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer"));
            R01MIndexDefinition indexDefinition = new R01MIndexDefinition(0, documentOid, 1, null, indexers, false, -1, null, null, null);
            R01DIndexerHelper.doIndexObject(indexDefinition);
        }
        catch (R01MContentModelObjectsValidatorException valEx) {
            throw new EJBException((Exception)((Object)valEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
        return updateResourcesGroup;
    }

    public void doRenderAndPublishDocumentLinkedResources(R01MUserContext userCtx, String contentOid, String documentOid, List repositories) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doRenderAndPublishDocumentLinkedResources()...");
        }
        try {
            if (!this.doCheckDocumentExistence(documentOid)) {
                throw new R01MContentModelException("El documento '" + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            service.doRenderAndPublishDocumentLinkedResources(userCtx, contentOid, documentOid, repositories);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MLinkedRelationsGroup doGetDocumentAvailableLinkedRelations(R01MUserContext userCtx, String documentSrcOid, String documentDstOid, String containerId) throws EJBException, R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doSetDocumentLinkedResources()...");
        }
        try {
            if (!this.doCheckDocumentExistence(documentSrcOid)) {
                throw new R01MContentModelException("El documento '" + documentSrcOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doGetDocumentAvailableLinkedRelations(userCtx, documentSrcOid, documentDstOid, containerId);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MLinkedResourcesGroup doGetDocumentLinkedResources(R01MUserContext userCtx, String documentOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doSetDocumentLinkedResources()...");
        }
        try {
            if (!this.doCheckDocumentExistence(documentOid)) {
                throw new R01MContentModelException("El documento '" + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doGetDocumentLinkedResources(userCtx, documentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doSetDocumentGalleryResources(R01MUserContext userCtx, String contentOid, String documentOid, String docPublishRepoOid, R01MGallery galleryResources) throws EJBException, R01MSecurityException, R01MContentModelObjectsValidatorException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doSetDocumentGalleryResources()...");
        }
        try {
            if (!this.doCheckContentDocumentRelation(contentOid, documentOid)) {
                throw new R01MContentModelException("La relacion contenido <-> documento '" + contentOid + " <-> " + documentOid + "' NO EXISTE.");
            }
            if (galleryResources != null && galleryResources.getResources() != null && !galleryResources.getResources().isEmpty()) {
                for (R01MResourceInterface currResource : galleryResources.getResources().values()) {
                    currResource.validateObject();
                }
            }
            R01DContentModelManager service = new R01DContentModelManager();
            service.doSetDocumentGalleryResources(userCtx, contentOid, documentOid, docPublishRepoOid, galleryResources);
            List indexers = new ArrayList();
            indexers = XMLProperties.getPropertyList((String)R01MConstants.API_APPCODE, (String)"indexersConfigurations/default/indexer", Arrays.asList("com.ejie.r01k.searchorchestrator.indexer.indexers.R01KDataBaseIndexer"));
            R01MIndexDefinition indexDefinition = new R01MIndexDefinition(0, documentOid, 1, null, indexers, false, -1, null, null, null);
            R01DIndexerHelper.doIndexObject(indexDefinition);
        }
        catch (R01MContentModelObjectsValidatorException valEx) {
            throw new EJBException((Exception)((Object)valEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MGalleryResourcesGroup doGetDocumentGalleryResources(R01MUserContext userCtx, String documentOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doGetDocumentGalleryResources()...");
        }
        try {
            if (!this.doCheckDocumentExistence(documentOid)) {
                throw new R01MContentModelException("El documento '" + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doGetDocumentGalleryResources(userCtx, documentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MContent doLoadContentDataFileLazy(R01MUserContext userCtx, R01MContent inContent, String documentOid, String dataFileOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadContentDataFileLazy()...");
        }
        try {
            if (!this.doCheckContentDocumentDatafileRelation(inContent.getOid(), documentOid, dataFileOid)) {
                throw new R01MContentModelException("La relacion contenido <-> documento <-> archivo de identificador '" + inContent.getOid() + " <-> " + documentOid + " <-> " + dataFileOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadContentDataFileLazy(userCtx, inContent, documentOid, dataFileOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public String doGetDataFileParentDocument(String dataFileOid) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doGetDataFileParentDocument()...");
        }
        try {
            if (!this.doCheckDatafileExistence(dataFileOid)) {
                throw new R01MContentModelException("El archivo de datos de identificador '" + dataFileOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doGetDataFileParentDocument(dataFileOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public int doGetStateOfGeneratedDatafile(R01MUserContext userCtx, String dataFileOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doGenerateDataFileContent()...");
        }
        try {
            if (!this.doCheckDatafileExistence(dataFileOid)) {
                throw new R01MContentModelException("El archivo de identificador '" + dataFileOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doGetStateOfGeneratedDatafile(userCtx, dataFileOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doGenerateDataFileContent(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, boolean generateAsync, boolean useAllPresentationTemplates, String presentationTemplateOid, boolean syncWorkflow, boolean uploadToDocumentFolder) throws EJBException, R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doGenerateDataFileContent()...");
        }
        try {
            if (!this.doCheckContentDocumentDatafileRelation(contentOid, documentOid, dataFileOid)) {
                throw new R01MContentModelException("La relacion contenido <-> documento <-> archivo de identificador '" + contentOid + " <-> " + documentOid + " <-> " + dataFileOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            service.doGenerateDataFileContent(userCtx, contentOid, documentOid, dataFileOid, generateAsync, useAllPresentationTemplates, presentationTemplateOid, syncWorkflow, uploadToDocumentFolder);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doGenerateDataFileUsingAllPresentationTemplates(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid) throws EJBException, R01MContentModelException {
        try {
            this.doGenerateDataFileContent(userCtx, contentOid, documentOid, dataFileOid, false, true, "", false, false);
        }
        catch (R01MSecurityException secExc) {
            throw new R01MContentModelException("No se tiene acceso al contenido. Error:" + secExc.getMessage());
        }
    }

    public void doGenerateDataFileUsingAllPresentationTemplates(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, boolean syncWorkflow) throws EJBException, R01MContentModelException {
        try {
            this.doGenerateDataFileContent(userCtx, contentOid, documentOid, dataFileOid, false, true, "", syncWorkflow, false);
        }
        catch (R01MSecurityException secExc) {
            throw new R01MContentModelException("No se tiene acceso al contenido. Error:" + secExc.getMessage());
        }
    }

    public void doGenerateDataFileUsingPresentationTemplate(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, String presentationTemplateOid) throws EJBException, R01MContentModelException {
        try {
            this.doGenerateDataFileContent(userCtx, contentOid, documentOid, dataFileOid, false, false, presentationTemplateOid, false, false);
        }
        catch (R01MSecurityException secExc) {
            throw new R01MContentModelException("No se tiene acceso al contenido. Error:" + secExc.getMessage());
        }
    }

    public void doGenerateDataFileUsingPresentationTemplate(R01MUserContext userCtx, String contentOid, String documentOid, String dataFileOid, String presentationTemplateOid, boolean syncWorkflow) throws EJBException, R01MContentModelException {
        try {
            this.doGenerateDataFileContent(userCtx, contentOid, documentOid, dataFileOid, false, false, presentationTemplateOid, syncWorkflow, false);
        }
        catch (R01MSecurityException secExc) {
            throw new R01MContentModelException("No se tiene acceso al contenido. Error:" + secExc.getMessage());
        }
    }

    public Map doLoadWorkAreaContents(R01MUserContext userCtx, R01MContentLocation loc) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadWorkareaContents()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadWorkAreaContents(userCtx, loc);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public String[] doLoadWorkAreaContentsOids(R01MUserContext userCtx, R01MContentLocation loc) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadWorkareaContentsOids()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadWorkAreaContentsOids(userCtx, loc);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MIndexableContent doPrepareContentToBeIndexed(R01MUserContext userCtx, String contentOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadWorkareaContentsOids()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doPrepareContentToBeIndexed(userCtx, contentOid);
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public Map doGetOperationsGroupByContents(R01MUserContext userCtx, R01MChangesLabelsPacket changesPacket) throws EJBException, R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doGetOperationsGroupByContents()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doGetOperationsGroupByContents(userCtx, changesPacket);
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doUploadIndexableObject(R01MUserContext userCtx, R01MContent content, R01MIndexableContent idxCont) throws EJBException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doUploadIndexableObject()...");
        }
        try {
            if (!this.doCheckContentExistence(content.getOid())) {
                throw new R01MContentModelException("El identificador de contenido '" + content.getOid() + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            service.doUploadIndexableObject(userCtx, content, idxCont);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MDocumentPublicationTarget doUpdatePublicationState(R01MContent content, String documentOid, int publicationType, Date publicationDate, String repositoryOid) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doUpdatePublicationState()...");
        }
        try {
            if (!this.doCheckDocumentExistence(documentOid)) {
                throw new R01MContentModelException("El identificador de documento '" + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doUpdatePublicationState(content, documentOid, publicationType, publicationDate, repositoryOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doUpdateDocumentAliasesState(R01MUserContext userCtx, String documentOid, int initialState, int finalState) throws R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doUpdateDocumentAliasesState()...");
        }
        try {
            if (!this.doCheckDocumentExistence(documentOid)) {
                throw new R01MContentModelException("El identificador de documento '" + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            service.doUpdateDocumentAliasesState(userCtx, documentOid, initialState, finalState);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doLoadContentDocumentsPublishResume(R01MUserContext userCtx, String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadContent()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El documento de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadContentDocumentsPublishResume(userCtx, contentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MContentPublishResume doLoadContentPublishResume(R01MUserContext userCtx, String contentOid) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadContent()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadContentPublishResume(userCtx, contentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MDocumentPublishResume doLoadDocumentPublishResume(R01MUserContext userCtx, String documentOid) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadContent()...");
        }
        try {
            if (!this.doCheckDocumentExistence(documentOid)) {
                throw new R01MContentModelException("El documento de identificador '" + documentOid + "' NO EXISTE.");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doLoadDocumentPublishResume(userCtx, documentOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MBusinessErrors doLoadBusinessErrors(R01MUserContext userCtx, String documentOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadBusinessErrors()...");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            R01MBusinessErrors bussinesErrors = service.doLoadBusinessErrors(userCtx, documentOid);
            return bussinesErrors;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doLoadBusinessErrorsList(R01MUserContext userCtx, List documentOids) throws EJBException, R01MSecurityException, R01MContentModelException {
        try {
            if (DEBUG) {
                R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doLoadBusinessErrorsList()...");
            }
            R01DContentModelManager service = new R01DContentModelManager();
            List bussinesErrorsList = service.doLoadBusinessErrorsList(userCtx, documentOids);
            return bussinesErrorsList;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doSetBusinessErrors(R01MUserContext userCtx, String documentOid, R01MBusinessErrors documentErrors) throws EJBException, R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doSetBusinessErrors()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            service.doSetBusinessErrors(userCtx, documentOid, documentErrors);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public String doComposeContentName(R01MUserContext userCtx, String typologyOid, String metadataOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doComposeContentName()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            String contentName = service.doComposeContentName(userCtx, typologyOid, metadataOid);
            return contentName;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MLinkedResource doGetLinkedTranslated(R01MLinkedResource srcLink, String dstLang, String documentOid) throws R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)"r01n.services").info("\tR01DContentServicesSL.doGetLinkedTranslated()...");
        }
        try {
            return _linkedResources.doGetLinkedTranslated(srcLink, dstLang, documentOid);
        }
        catch (Exception ex) {
            throw new R01MContentModelException(ex);
        }
    }

    public R01MContent doChangeContentCatalog(R01MUserContext userCtx, String contentOid, List newLabels) throws R01MContentModelException, R01MSecurityException {
        if (DEBUG) {
            R01FLog.to((String)"r01n.services").info("\tR01DContentServicesSL.doChangeContentCatalog()...");
        }
        try {
            if (!this.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            return _contentCatalog.doChangeContentCatalog(userCtx, contentOid, newLabels);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public int doGetUiState(R01MUserContext userCtx, String target, String oidDcocument) throws R01MSecurityException, R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doGetUiState()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            int uiState = service.doGetUiState(userCtx, target, oidDcocument);
            return uiState;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doGetActiveNotices(R01MUserContext userCtx, String lang) throws R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doGetActiveNotices()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doGetActiveNotices(userCtx, lang);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doGetNoticesNotReadByUser(R01MUserContext userCtx, String lang) throws R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doGetNoticeNotReadedByUser()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doGetNoticesNotReadByUser(userCtx, lang);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doSetNoticeReadByUser(R01MUserContext userCtx, List readedList) throws R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doSetNoticeReadedByUser()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            service.doSetNoticeReadByUser(userCtx, readedList);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public Map doGetNoticesReadByUserLazy(R01MUserContext userCtx) throws R01MContentModelException {
        if (DEBUG) {
            R01FLog.to((String)LOG_TYPE_ID).info("\tR01DContentServicesSL.doGetNoticeNotReadedByUser()...");
        }
        try {
            R01DContentModelManager service = new R01DContentModelManager();
            return service.doGetNoticesReadByUserLazy(userCtx);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }
}

