/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.r01d.ejb.services.admin;

import com.ejie.r01d.services.R01DContentAdminManager;
import com.ejie.r01d.services.R01DContentModelManager;
import com.ejie.r01f.log.R01FLog;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01m.context.R01MAuthManager;
import com.ejie.r01m.context.R01MUserContext;
import com.ejie.r01m.exceptions.R01MContentModelException;
import com.ejie.r01m.exceptions.R01MPublisherException;
import com.ejie.r01m.exceptions.R01MSecurityException;
import com.ejie.r01m.objects.R01MBaseLocationObject;
import com.ejie.r01m.objects.contentmodel.R01MContentLocation;
import com.ejie.r01m.objects.contentmodel.R01MContentTypologyInfo;
import com.ejie.r01m.objects.contentmodel.R01MSearchedDocuments;
import com.ejie.r01m.objects.misc.R01MOperationInModelObjectResult;
import com.ejie.r01m.objects.opendata.R01MBaseOpendataPackageInterface;
import com.ejie.r01m.objects.opendata.R01MOpendataPackage;
import com.ejie.r01m.objects.opendata.R01MOpendataPackageExtended;
import com.ejie.r01m.objects.searchengine.query.R01MQueryObject;
import com.ejie.r01m.services.bzd.R01MContentAdminBzd;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class R01DContentAdminServicesSLBaseBean
implements SessionBean,
R01MContentAdminBzd {
    private static final long serialVersionUID = 3360501073694640985L;
    private static final boolean DEBUG = R01FLog.getLogLevel((String)"r01d.services").intValue() != Level.OFF.intValue();
    private SessionContext context;
    private R01DContentModelManager _cmManager = new R01DContentModelManager();

    public void setSessionContext(SessionContext newContext) throws EJBException {
        if (DEBUG) {
            R01FLog.to((String)"r01d.services").info("\tR01DContentAdminServicesSL.setSessionContext()...");
        }
        this.context = newContext;
    }

    public void ejbRemove() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)"r01d.services").info("\tR01DContentAdminServicesSL.ejbRemove()...");
        }
    }

    public void ejbActivate() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)"r01d.services").info("\tR01DContentAdminServicesSL.ejbActivate()...");
        }
    }

    public void ejbPassivate() throws EJBException, RemoteException {
        if (DEBUG) {
            R01FLog.to((String)"r01d.services").info("\tR01DContentAdminServicesSL.ejbPassivate()...");
        }
    }

    public void ejbCreate() throws CreateException {
        if (DEBUG) {
            R01FLog.to((String)"r01d.services").info("\tR01DContentAdminServicesSL.ejbCreate()");
        }
    }

    public String doLoadContentDescriptor(R01MUserContext userCtx, String contentOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Obteniendo el xml descriptor del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            if (StringUtils.isEmptyString((String)contentOid)) {
                throw new R01MContentModelException("El identificador de contenido es incorrecto.");
            }
            if (!this._cmManager.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            String xml = adminMgr.doLoadContentDescriptor(userCtx, contentOid);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return xml;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doSaveContentDescriptor(R01MUserContext userCtx, String contentOid, String contentXML, boolean updataDataStoreDescriptor) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Guardando el xml descriptor del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            if (StringUtils.isEmptyString((String)contentOid) || StringUtils.isEmptyString((String)contentXML)) {
                throw new R01MContentModelException("No se ha pasado el identificador de contenido o el XML del mismo");
            }
            if (!this._cmManager.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            adminMgr.doSaveContentDescriptor(userCtx, contentOid, contentXML, updataDataStoreDescriptor);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List[] doPublicateLocationContentsDocuments(R01MUserContext userCtx, R01MContentLocation loc, String publishRepositoryOid, int publicationType) throws EJBException, R01MSecurityException, R01MPublisherException, R01MContentModelException {
        String opDesc = "Publicando todos los documentos de todos los contenidos de la localizacion " + loc.composeMemoCode();
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List[] results = adminMgr.doPublicateLocationContentsDocuments(userCtx, loc, publishRepositoryOid, publicationType);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MPublisherException pubEx) {
            throw new EJBException((Exception)((Object)pubEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List[] doPublicateContentDocuments(R01MUserContext userCtx, String contentOid, String publishRepositoryOid, int publicationType) throws EJBException, R01MSecurityException, R01MPublisherException, R01MContentModelException {
        String opDesc = "Publicando todos los documentos del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            if (StringUtils.isEmptyString((String)contentOid) || StringUtils.isEmptyString((String)publishRepositoryOid)) {
                throw new R01MContentModelException("El identificador de contenido o del repositorio de publicacion es incorrecto.");
            }
            if (!this._cmManager.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List[] results = adminMgr.doPublicateContentDocuments(userCtx, contentOid, publishRepositoryOid, publicationType);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MPublisherException pubEx) {
            throw new EJBException((Exception)((Object)pubEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List[] doPublicateDocument(R01MUserContext userCtx, String documentOid, String publishRepositoryOid, int publicationType) throws R01MSecurityException, R01MPublisherException, R01MContentModelException {
        R01DContentModelManager cmMgr = new R01DContentModelManager();
        return this.doPublicateDocument(userCtx, cmMgr.doGetDocumentParentContent(documentOid), documentOid, publishRepositoryOid, publicationType);
    }

    public List[] doPublicateDocument(R01MUserContext userCtx, String contentOid, String documentOid, String publishRepositoryOid, int publicationType) throws R01MSecurityException, R01MPublisherException, R01MContentModelException {
        String opDesc = "Publicando el documento " + documentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            if (StringUtils.isEmptyString((String)documentOid) || StringUtils.isEmptyString((String)publishRepositoryOid)) {
                throw new R01MContentModelException("El identificador de documento o del repositorio de publicacion es incorrecto.");
            }
            if (!this._cmManager.doCheckDocumentExistence(documentOid)) {
                throw new R01MContentModelException("El documento de identificador '" + documentOid + "' NO EXISTE.");
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List[] results = adminMgr.doPublicateDocument(userCtx, contentOid, documentOid, publishRepositoryOid, publicationType);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MPublisherException pubEx) {
            throw new EJBException((Exception)((Object)pubEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List[] doGenerateLocationContentsDataFiles(R01MUserContext userCtx, R01MContentLocation loc) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Regenerando los dataFiles de todos los contenidos de la localizacion " + loc.composeMemoCode();
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List[] results = adminMgr.doGenerateLocationContentsDataFiles(userCtx, loc);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List[] doGenerateDatafileHTMLsBydocumentOid(R01MUserContext userCtx, String documentOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Regenerando los dataFiles de todos los documentos pasados.";
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List[] results = adminMgr.doGenerateDatafileHTMLsBydocumentOid(userCtx, documentOid);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doTestContent(R01MUserContext userCtx, String contentOid, boolean repair) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Testeando el contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            if (StringUtils.isEmptyString((String)contentOid)) {
                return new ArrayList();
            }
            if (!this._cmManager.doCheckContentExistence(contentOid)) {
                return new ArrayList();
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List results = adminMgr.doTestContent(userCtx, contentOid, repair);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doTestLocation(R01MUserContext userCtx, R01MContentLocation loc, boolean repair) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Testeando la localizacion " + loc.composeMemoCode();
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List results = adminMgr.doTestLocation(userCtx, loc, repair);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MOperationInModelObjectResult doImportContent(R01MUserContext userCtx, R01MContentLocation loc, String contentType, String contentName, boolean importDataFilesToSystemArea) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Importando el contenido " + contentName + " de la localizaci\u00f3n " + loc.composeMemoCode();
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            R01MOperationInModelObjectResult res = adminMgr.doImportContent(userCtx, loc, contentType, contentName, importDataFilesToSystemArea);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return res;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doImportContentsFromZipFile(R01MUserContext userCtx, String fileName, String prefix) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Importando los contenidos del fichero de empaquetado de contenidos " + fileName;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            adminMgr.doImportContentsFromZipFile(userCtx, fileName, prefix);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List[] doImportLocationContents(R01MUserContext userCtx, R01MContentLocation loc, boolean importDataFilesToSystemArea) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Importando contenidos de la localizacion " + loc.composeMemoCode();
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List[] results = adminMgr.doImportLocationContents(userCtx, loc, importDataFilesToSystemArea);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List[] doCopyDataFilesFromSystemAreaToDocumentFolder(R01MUserContext userCtx, R01MContentLocation loc) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Copiando los dataFiles de los contenidos de la localizacion " + loc.composeMemoCode() + " desde el area de sistema a la estructura de cada documento";
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List[] results = adminMgr.doCopyDataFilesFromSystemAreaToDocumentFolder(userCtx, loc);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List[] doImportContentsFromFile(R01MUserContext userCtx, String fileToImport, String importTS) throws EJBException, R01MSecurityException, R01MContentModelException {
        return this.doImportContentsFromFile(userCtx, fileToImport, importTS, false);
    }

    public List[] doImportContentFromArchives(R01MUserContext userCtx, String effectiveImportRootDir, Properties contentDescriptionData) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Importacion del contenido " + contentDescriptionData.getProperty("contentInternalName") + " ubicado en el directorio temporal " + effectiveImportRootDir;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List[] results = adminMgr.doImportContentFromArchives(userCtx, effectiveImportRootDir, contentDescriptionData);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List[] doImportContentLinkedData(R01MUserContext userCtx, String effectiveImportRootDir, Properties contentDescriptionData) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Crear las relaciones del contenido importado " + contentDescriptionData.getProperty("contentInternalName") + " ubicado en el directorio temporal " + effectiveImportRootDir;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List[] results = adminMgr.doImportContentLinkedData(userCtx, effectiveImportRootDir, contentDescriptionData);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doImportAttachments(R01MUserContext userCtx, String fileName, String contentOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Importanci\u00f3n de adjuntos del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            adminMgr.doImportAttachments(userCtx, fileName, contentOid);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List[] doImportAttachmentsFromContent(R01MUserContext userCtx, String effectiveImportRootDir, String contentOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Importacion de los adjuntos del contenido " + contentOid + " ubicado en el directorio temporal " + effectiveImportRootDir;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List[] results = adminMgr.doImportAttachmentsFromContent(userCtx, effectiveImportRootDir, contentOid);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doExportContentToFile(R01MUserContext userCtx, String contentOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Generacion del empaquetado del contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            if (StringUtils.isEmptyString((String)contentOid)) {
                throw new R01MContentModelException("El identificador de contenido es incorrecto.");
            }
            if (!this._cmManager.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            adminMgr.doExportContentToFile(userCtx, contentOid);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doExportQueryToFile(R01MUserContext userCtx, R01MQueryObject query, String fileName, R01MBaseLocationObject targetLocation, String waRelativePath, boolean exportAttachments) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Notificacion del empaquetado de contenidos para la busqueda: " + query.composeDebugInfo() + " en el directorio " + waRelativePath + " de la WA " + targetLocation.composeMemoCode() + (exportAttachments ? " con adjuntos." : " sin adjuntos.");
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            adminMgr.doExportQueryToFile(userCtx, query, fileName, targetLocation, waRelativePath, exportAttachments);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public boolean doProcessExportQueryToFile(R01MUserContext userCtx, R01MQueryObject query, String fileName, R01MBaseLocationObject targetLocation, String waRelativePath, boolean exportAttachments) throws EJBException, R01MSecurityException, R01MContentModelException, UnsupportedEncodingException {
        if (query == null || targetLocation == null || StringUtils.isEmptyString((String)waRelativePath) || StringUtils.isEmptyString((String)fileName)) {
            R01FLog.to((String)"r01d.services").severe("Los par\u00e1metros recibidos son incorrectos.Query:" + query + ",fileName:" + fileName + ",targetLocation:" + targetLocation + ",waRelativePath:" + waRelativePath);
            throw new R01MContentModelException("Los par\u00e1metros recibidos son incorrectos.");
        }
        String opDesc = "Generacion del empaquetado de contenidos para la busqueda: " + query.composeDebugInfo() + " en el directorio " + waRelativePath + " de la WA " + targetLocation.composeMemoCode() + (exportAttachments ? " con adjuntos." : " sin adjuntos.");
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            boolean processOk = adminMgr.doProcessExportQueryToFile(userCtx, query, fileName, targetLocation, waRelativePath, exportAttachments);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return processOk;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doUploadFileToServer(R01MUserContext userCtx, String fileName, String dstDirAbsolutePath, byte[] buffer, long offset) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Subiendo el fichero " + fileName + " al directorio " + dstDirAbsolutePath + ".";
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            adminMgr.doUploadFileToServer(userCtx, fileName, dstDirAbsolutePath, buffer, offset);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doGenerateContentXMLDescriptorFromDBRecords(R01MUserContext userCtx, String contentOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Migrando el contenido " + contentOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            if (StringUtils.isEmptyString((String)contentOid)) {
                throw new R01MContentModelException("El identificador de contenido es incorrecto.");
            }
            if (!this._cmManager.doCheckContentExistence(contentOid)) {
                throw new R01MContentModelException("El contenido de identificador '" + contentOid + "' NO EXISTE.");
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            adminMgr.doGenerateContentXMLDescriptorFromDBRecords(userCtx, contentOid);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List[] doGenerateLocationContentsXMLDescriptorFromDBRecords(R01MUserContext userCtx, R01MContentLocation loc) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Migrando contenidos de la localizacion " + loc.composeMemoCode();
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List[] results = adminMgr.doGenerateLocationContentsXMLDescriptorFromDBRecords(userCtx, loc);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doGetContentOidsByTypo(R01MUserContext userCtx, R01MContentTypologyInfo typo) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Carga de los identificadores de contenidos con la tipolog\u00eda  " + typo.composeMemoCode();
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List results = adminMgr.doGetContentOidsByTypo(typo);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public void doSaveOpendataPackage(R01MUserContext userCtx, R01MOpendataPackage opendataPackage) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Guardando el empaquetado  " + opendataPackage.getOid();
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            adminMgr.doSaveOpendataPackage(userCtx, opendataPackage);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public boolean doDeleteOpendataPackage(R01MUserContext userCtx, String opendataPackageOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Borrando el empaquetado  " + opendataPackageOid;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            return adminMgr.doDeleteOpendataPackage(userCtx, opendataPackageOid);
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doLoadOpendataPackages(R01MUserContext userCtx) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Devolviendo los empaquetados existentes en bd";
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List results = adminMgr.doLoadOpendataPackages(userCtx);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List<R01MOpendataPackageExtended> doLoadOpendataPackagesExtended(R01MUserContext userCtx) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Devolviendo los empaquetados existentes en bd";
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List<R01MOpendataPackageExtended> results = adminMgr.doLoadOpendataPackagesExtended(userCtx);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doLoadOpendataPackagesByContent(R01MUserContext userCtx, String contentOid) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Devolviendo los empaquetados existentes en bd";
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List<R01MOpendataPackage> results = adminMgr.doLoadOpendataPackagesByContent(userCtx, contentOid);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public R01MBaseOpendataPackageInterface doLoadOpendataPackage(R01MUserContext userCtx, String oidPackage) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Devolviendo los empaquetados existentes en bd";
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            R01MBaseOpendataPackageInterface opendataPackage = adminMgr.doLoadOpendataPackage(userCtx, oidPackage);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return opendataPackage;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doLoadOpendataPackagesActivedAndProcessed(R01MUserContext userCtx) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Devolviendo los empaquetados existentes en bd";
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List results = adminMgr.doLoadOpendataPackages(userCtx);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doExecutedOpendataPackages(R01MUserContext userCtx) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Ejecutando los empaquetados";
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List activePackages = adminMgr.doExecutedOpendataPackages(userCtx);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return activePackages;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doLoadActiveOpendataPackages(R01MUserContext userCtx, String lang) throws EJBException, R01MSecurityException, R01MContentModelException {
        String opDesc = "Ejecutando los empaquetados";
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List activePackages = adminMgr.doLoadActiveOpendataPackages(userCtx, lang);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return activePackages;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public String doLoadComboOptions(String lang, String comboId, String useHTMLFieldAsKey) throws EJBException, R01MContentModelException {
        try {
            R01DContentAdminManager adminMgr;
            String opDesc = "Devolviendo las opciones del combo existentes en bd";
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            try {
                adminMgr = new R01DContentAdminManager(R01MAuthManager.createMasterSystemUserContext());
            }
            catch (R01MSecurityException ex) {
                throw new EJBException((Exception)((Object)ex));
            }
            String comboOptions = adminMgr.doLoadComboOptions(lang, comboId, useHTMLFieldAsKey);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return comboOptions;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public String doLoadComboOptions(String lang, String comboId, String useHTMLFieldAsKey, String orderCriterium) throws EJBException, R01MContentModelException {
        try {
            R01DContentAdminManager adminMgr;
            String opDesc = "Devolviendo las opciones del combo ecistentes en bd";
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            try {
                adminMgr = new R01DContentAdminManager(R01MAuthManager.createMasterSystemUserContext());
            }
            catch (R01MSecurityException ex) {
                throw new EJBException((Exception)((Object)ex));
            }
            String comboOptions = adminMgr.doLoadComboOptions(lang, comboId, useHTMLFieldAsKey, orderCriterium);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return comboOptions;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public String doLoadComboOptionDescription(String lang, String comboId, String comboOptionId, String useHTMLFieldAsKey) throws EJBException, R01MContentModelException {
        try {
            R01DContentAdminManager adminMgr;
            String opDesc = "Devolviendo el valor de la opcion del combo";
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            try {
                adminMgr = new R01DContentAdminManager(R01MAuthManager.createMasterSystemUserContext());
            }
            catch (R01MSecurityException ex) {
                throw new EJBException((Exception)((Object)ex));
            }
            String optionDescription = adminMgr.doLoadComboOptionDescription(lang, comboId, comboOptionId, useHTMLFieldAsKey);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return optionDescription;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public Map doLoadComboOptionsMap(String lang, String comboId, String useHTMLFieldAsKey) throws R01MContentModelException {
        try {
            R01DContentAdminManager adminMgr;
            String opDesc = "Devolviendo las opciones del combo ecistentes en bd";
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            try {
                adminMgr = new R01DContentAdminManager(R01MAuthManager.createMasterSystemUserContext());
            }
            catch (R01MSecurityException ex) {
                throw new EJBException((Exception)((Object)ex));
            }
            Map comboOptions = adminMgr.doLoadComboOptionsMap(lang, comboId, useHTMLFieldAsKey);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return comboOptions;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public Map doLoadComboOptionsMap(String lang, String comboId, String useHTMLFieldAsKey, String orderCriterium) throws R01MContentModelException {
        try {
            R01DContentAdminManager adminMgr;
            String opDesc = "Devolviendo las opciones del combo ecistentes en bd";
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            try {
                adminMgr = new R01DContentAdminManager(R01MAuthManager.createMasterSystemUserContext());
            }
            catch (R01MSecurityException ex) {
                throw new EJBException((Exception)((Object)ex));
            }
            Map comboOptions = adminMgr.doLoadComboOptionsMap(lang, comboId, useHTMLFieldAsKey, orderCriterium);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return comboOptions;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doSearchDocuments(R01MSearchedDocuments srchDocsCriteria) throws EJBException, R01MContentModelException {
        String opDesc = "B\u00fasqueda de documentos que cumplen el criterio de b\u00fasqueda.";
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
                R01FLog.to((String)"r01d.services").info(srchDocsCriteria.debugInfo("").toString());
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager();
            List results = adminMgr.doSearchDocuments(srchDocsCriteria);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doGetAllowedTargetsToPublishDocuments() throws EJBException, R01MContentModelException {
        String opDesc = "B\u00fasqueda de documentos que cumplen el criterio de b\u00fasqueda.";
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager();
            List<String> allowedTargets = adminMgr.doGetAllowedTargetsToPublishDocuments();
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return allowedTargets;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List doGetAllowedTargetsAndNamesToPublishDocuments() throws EJBException, R01MContentModelException {
        String opDesc = "B\u00fasqueda de documentos que cumplen el criterio de b\u00fasqueda.";
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager();
            List allowedTargets = adminMgr.doGetAllowedTargetsAndNamesToPublishDocuments();
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return allowedTargets;
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }

    public List[] doImportContentsFromFile(R01MUserContext userCtx, String fileToImport, String importTS, boolean keepOids) throws R01MSecurityException, R01MContentModelException {
        String opDesc = "Importacion de los contenidos ubicados en el directorio temporal " + fileToImport;
        try {
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (init): " + opDesc);
            }
            R01DContentAdminManager adminMgr = new R01DContentAdminManager(userCtx);
            List[] results = adminMgr.doImportContentsFromFile(userCtx, fileToImport, importTS, keepOids);
            if (DEBUG) {
                R01FLog.to((String)"r01d.services").info("MODEL SERVER (end) : " + opDesc);
            }
            return results;
        }
        catch (R01MSecurityException secEx) {
            throw new EJBException((Exception)((Object)secEx));
        }
        catch (R01MContentModelException cmEx) {
            throw new EJBException((Exception)((Object)cmEx));
        }
    }
}

