/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.server.runner;

import java.text.NumberFormat;
import java.util.Locale;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.apache.cactus.server.runner.XMLConstants;
import org.apache.cactus.util.JUnitVersionHelper;
import org.apache.cactus.util.StringUtil;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class XMLFormatter
implements XMLConstants,
TestListener {
    public static final String[] DEFAULT_STACK_FILTER_PATTERNS;
    private String xslFileName;
    private String suiteClassName;
    private long totalDuration;
    private long currentTestStartTime;
    private NumberFormat durationFormat = NumberFormat.getInstance(Locale.US);
    private StringBuffer currentTestCaseResults = new StringBuffer();
    private String currentTestFailure;
    public static final JoinPoint.StaticPart ajc$tjp_0;
    public static final JoinPoint.StaticPart ajc$tjp_1;
    public static final JoinPoint.StaticPart ajc$tjp_2;
    public static final JoinPoint.StaticPart ajc$tjp_3;
    public static final JoinPoint.StaticPart ajc$tjp_4;
    public static final JoinPoint.StaticPart ajc$tjp_5;
    public static final JoinPoint.StaticPart ajc$tjp_6;
    public static final JoinPoint.StaticPart ajc$tjp_7;

    static {
        Factory factory = new Factory("XMLFormatter.java", Class.forName("org.apache.cactus.server.runner.XMLFormatter"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setXslFileName-org.apache.cactus.server.runner.XMLFormatter-java.lang.String:-theXslFileName:--void-"), 145);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setSuiteClassName-org.apache.cactus.server.runner.XMLFormatter-java.lang.String:-theSuiteClassName:--void-"), 163);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setTotalDuration-org.apache.cactus.server.runner.XMLFormatter-long:-theDuration:--void-"), 192);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-toXML-org.apache.cactus.server.runner.XMLFormatter-junit.framework.TestResult:-theResult:--java.lang.String-"), 203);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-startTest-org.apache.cactus.server.runner.XMLFormatter-junit.framework.Test:-theTest:--void-"), 237);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-addError-org.apache.cactus.server.runner.XMLFormatter-junit.framework.Test:java.lang.Throwable:-theTest:theThrowable:--void-"), 249);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-addFailure-org.apache.cactus.server.runner.XMLFormatter-junit.framework.Test:junit.framework.AssertionFailedError:-theTest:theError:--void-"), 271);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-endTest-org.apache.cactus.server.runner.XMLFormatter-junit.framework.Test:-theTest:--void-"), 292);
        DEFAULT_STACK_FILTER_PATTERNS = new String[]{"org.apache.cactus.AbstractTestCase", "org.apache.cactus.AbstractWebTestCase", "org.apache.cactus.FilterTestCase", "org.apache.cactus.JspTestCase", "org.apache.cactus.ServletTestCase", "junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestSuite", "junit.framework.Assert.", "java.lang.reflect.Method.invoke("};
    }

    public void setXslFileName(String string) {
        String string2 = string;
        Object[] objectArray = new Object[]{string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        XMLFormatter.setXslFileName_aroundBody1$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getSuiteClassName() {
        return this.suiteClassName;
    }

    public void setSuiteClassName(String string) {
        String string2 = string;
        Object[] objectArray = new Object[]{string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        XMLFormatter.setSuiteClassName_aroundBody3$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getTotalDurationAsString() {
        return this.getDurationAsString(this.totalDuration);
    }

    private String getDurationAsString(long theDuration) {
        return this.durationFormat.format((double)theDuration / 1000.0);
    }

    public void setTotalDuration(long l) {
        long l2 = l;
        Object[] objectArray = new Object[]{Conversions.longObject((long)l2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        XMLFormatter.setTotalDuration_aroundBody5$advice(this, l2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String toXML(TestResult testResult) {
        TestResult testResult2 = testResult;
        Object[] objectArray = new Object[]{testResult2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        return (String)XMLFormatter.toXML_aroundBody7$advice(this, testResult2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void startTest(Test test) {
        Test test2 = test;
        Object[] objectArray = new Object[]{test2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        XMLFormatter.startTest_aroundBody9$advice(this, test2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void addError(Test test, Throwable throwable) {
        Test test2 = test;
        Throwable throwable2 = throwable;
        Object[] objectArray = new Object[]{test2, throwable2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        XMLFormatter.addError_aroundBody11$advice(this, test2, throwable2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void addFailure(Test test, AssertionFailedError assertionFailedError) {
        Test test2 = test;
        AssertionFailedError assertionFailedError2 = assertionFailedError;
        Object[] objectArray = new Object[]{test2, assertionFailedError2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        XMLFormatter.addFailure_aroundBody13$advice(this, test2, assertionFailedError2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void endTest(Test test) {
        Test test2 = test;
        Object[] objectArray = new Object[]{test2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        XMLFormatter.endTest_aroundBody15$advice(this, test2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    private String xmlEncode(String theString) {
        String newString = XMLFormatter.replace(theString, '&', "&amp;");
        newString = XMLFormatter.replace(newString, '<', "&lt;");
        newString = XMLFormatter.replace(newString, '>', "&gt;");
        newString = XMLFormatter.replace(newString, '\"', "&quot;");
        return newString;
    }

    private static String replace(String theBaseString, char theChar, String theNewString) {
        if (theBaseString == null) {
            return null;
        }
        int len = theBaseString.length() - 1;
        int pos = -1;
        while ((pos = theBaseString.indexOf(theChar, pos + 1)) > -1) {
            String before;
            if (pos == 0) {
                String after = theBaseString.substring(1);
                theBaseString = String.valueOf(theNewString) + after;
                continue;
            }
            if (pos == len) {
                before = theBaseString.substring(0, pos);
                theBaseString = String.valueOf(before) + theNewString;
                continue;
            }
            before = theBaseString.substring(0, pos);
            String after = theBaseString.substring(pos + 1);
            theBaseString = String.valueOf(before) + theNewString + after;
        }
        return theBaseString;
    }

    static final void setXslFileName_aroundBody0(XMLFormatter xMLFormatter, String string, JoinPoint joinPoint) {
        xMLFormatter.xslFileName = string;
    }

    /*
     * WARNING - void declaration
     */
    static final Object setXslFileName_aroundBody1$advice(XMLFormatter this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            XMLFormatter.setXslFileName_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        XMLFormatter.setXslFileName_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    static final void setSuiteClassName_aroundBody2(XMLFormatter xMLFormatter, String string, JoinPoint joinPoint) {
        xMLFormatter.suiteClassName = string;
    }

    /*
     * WARNING - void declaration
     */
    static final Object setSuiteClassName_aroundBody3$advice(XMLFormatter this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            XMLFormatter.setSuiteClassName_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        XMLFormatter.setSuiteClassName_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    static final void setTotalDuration_aroundBody4(XMLFormatter xMLFormatter, long l, JoinPoint joinPoint) {
        xMLFormatter.totalDuration = l;
    }

    /*
     * WARNING - void declaration
     */
    static final Object setTotalDuration_aroundBody5$advice(XMLFormatter this_, long ajc_aroundClosure, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void result;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            XMLFormatter.setTotalDuration_aroundBody4(this_, ajc_aroundClosure, (JoinPoint)target);
            Object var9_9 = null;
            log.debug((Object)(String.valueOf('>') + joinPoint2.getSignature().getName()));
            return var9_9;
        }
        void var11_10 = result;
        XMLFormatter.setTotalDuration_aroundBody4(this_, ajc_aroundClosure, (JoinPoint)target);
        return null;
    }

    static final String toXML_aroundBody6(XMLFormatter xMLFormatter, TestResult testResult, JoinPoint joinPoint) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        if (xMLFormatter.xslFileName != null) {
            stringBuffer.append("<?xml-stylesheet type=\"text/xsl\" href=\"" + xMLFormatter.xslFileName + "\"?>");
        }
        stringBuffer.append("<testsuites>");
        stringBuffer.append("<testsuite name=\"" + xMLFormatter.getSuiteClassName() + "\" " + "tests" + "=\"" + testResult.runCount() + "\" " + "failures" + "=\"" + testResult.failureCount() + "\" " + "errors" + "=\"" + testResult.errorCount() + "\" " + "time" + "=\"" + xMLFormatter.getTotalDurationAsString() + "\">");
        stringBuffer.append(xMLFormatter.currentTestCaseResults.toString());
        stringBuffer.append("</testsuite>");
        stringBuffer.append("</testsuites>");
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    static final Object toXML_aroundBody7$advice(XMLFormatter this_, TestResult ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var10_8 = logger;
            String string = XMLFormatter.toXML_aroundBody6(this_, ajc_aroundClosure, thisJoinPoint);
            StringBuffer stringBuffer = new StringBuffer(result.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append((Object)string);
            stringBuffer.append(']');
            log.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return string;
        }
        void var11_11 = logger;
        return XMLFormatter.toXML_aroundBody6(this_, ajc_aroundClosure, thisJoinPoint);
    }

    static final void startTest_aroundBody8(XMLFormatter xMLFormatter, Test test, JoinPoint joinPoint) {
        xMLFormatter.currentTestStartTime = System.currentTimeMillis();
        xMLFormatter.currentTestFailure = null;
    }

    /*
     * WARNING - void declaration
     */
    static final Object startTest_aroundBody9$advice(XMLFormatter this_, Test ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            XMLFormatter.startTest_aroundBody8(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        XMLFormatter.startTest_aroundBody8(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    static final void addError_aroundBody10(XMLFormatter xMLFormatter, Test test, Throwable throwable, JoinPoint joinPoint) {
        TestFailure testFailure = new TestFailure(test, throwable);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<error message=\"" + xMLFormatter.xmlEncode(testFailure.thrownException().getMessage()) + "\" " + "type" + "=\"" + testFailure.thrownException().getClass().getName() + "\">");
        stringBuffer.append(xMLFormatter.xmlEncode(StringUtil.exceptionToString(testFailure.thrownException(), DEFAULT_STACK_FILTER_PATTERNS)));
        stringBuffer.append("</error>");
        xMLFormatter.currentTestFailure = stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    static final Object addError_aroundBody11$advice(XMLFormatter this_, Test ajc_aroundClosure, Throwable thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void result;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            XMLFormatter.addError_aroundBody10(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
            Object var9_10 = null;
            log.debug((Object)(String.valueOf('>') + joinPoint2.getSignature().getName()));
            return var9_10;
        }
        void var11_11 = result;
        XMLFormatter.addError_aroundBody10(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
        return null;
    }

    static final void addFailure_aroundBody12(XMLFormatter xMLFormatter, Test test, AssertionFailedError assertionFailedError, JoinPoint joinPoint) {
        TestFailure testFailure = new TestFailure(test, (Throwable)assertionFailedError);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<failure message=\"" + xMLFormatter.xmlEncode(testFailure.thrownException().getMessage()) + "\" " + "type" + "=\"" + testFailure.thrownException().getClass().getName() + "\">");
        stringBuffer.append(xMLFormatter.xmlEncode(StringUtil.exceptionToString(testFailure.thrownException(), DEFAULT_STACK_FILTER_PATTERNS)));
        stringBuffer.append("</failure>");
        xMLFormatter.currentTestFailure = stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    static final Object addFailure_aroundBody13$advice(XMLFormatter this_, Test ajc_aroundClosure, AssertionFailedError thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void result;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            XMLFormatter.addFailure_aroundBody12(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
            Object var9_10 = null;
            log.debug((Object)(String.valueOf('>') + joinPoint2.getSignature().getName()));
            return var9_10;
        }
        void var11_11 = result;
        XMLFormatter.addFailure_aroundBody12(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
        return null;
    }

    static final void endTest_aroundBody14(XMLFormatter xMLFormatter, Test test, JoinPoint joinPoint) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = xMLFormatter.getDurationAsString(System.currentTimeMillis() - xMLFormatter.currentTestStartTime);
        stringBuffer.append("<testcase name=\"" + JUnitVersionHelper.getTestCaseName(test) + "\" " + "time" + "=\"" + string + "\">");
        if (xMLFormatter.currentTestFailure != null) {
            stringBuffer.append(xMLFormatter.currentTestFailure);
        }
        stringBuffer.append("</testcase>");
        xMLFormatter.currentTestCaseResults.append(stringBuffer.toString());
    }

    /*
     * WARNING - void declaration
     */
    static final Object endTest_aroundBody15$advice(XMLFormatter this_, Test ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            XMLFormatter.endTest_aroundBody14(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        XMLFormatter.endTest_aroundBody14(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }
}

