/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.cactus.RequestDirectives;
import org.apache.cactus.WebRequest;
import org.apache.cactus.client.ClientException;
import org.apache.cactus.client.WebResponseObjectFactory;
import org.apache.cactus.client.connector.http.DefaultHttpClient;
import org.apache.cactus.configuration.Configuration;
import org.apache.cactus.configuration.WebConfiguration;
import org.apache.cactus.internal.client.ClientTestCaseDelegate;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class WebClientTestCaseDelegate
extends ClientTestCaseDelegate {
    public static final JoinPoint.StaticPart ajc$tjp_0;

    public WebClientTestCaseDelegate(Test theDelegatedTest, Test theWrappedTest, Configuration theConfiguration) {
        super(theDelegatedTest, theWrappedTest, theConfiguration);
    }

    private Object callGenericEndMethod(WebRequest theRequest, HttpURLConnection theConnection, String theMethodName, Object theResponse) throws Throwable {
        Method methodToCall = null;
        Object paramObject = null;
        Method[] methods = this.getTest().getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(theMethodName)) {
                Class<?>[] parameters;
                if (!methods[i].getReturnType().getName().equals("void")) {
                    Assert.fail((String)("The method [" + methods[i].getName() + "] should return void and not [" + methods[i].getReturnType().getName() + "]"));
                }
                if (!Modifier.isPublic(methods[i].getModifiers())) {
                    Assert.fail((String)("Method [" + methods[i].getName() + "] should be declared public"));
                }
                if ((parameters = methods[i].getParameterTypes()).length != 1) {
                    Assert.fail((String)("The method [" + methods[i].getName() + "] must only have a single parameter"));
                }
                if ((paramObject = theResponse) == null) {
                    try {
                        paramObject = new WebResponseObjectFactory().getResponseObject(parameters[0].getName(), theRequest, theConnection);
                    }
                    catch (ClientException e) {
                        throw new ClientException("The method [" + methods[i].getName() + "] has a bad parameter of type [" + parameters[0].getName() + "]", e);
                    }
                }
                if (methodToCall != null) {
                    Assert.fail((String)("There can only be one method [" + methods[i].getName() + "] per test case. " + "Test case [" + this.getCurrentTestName() + "] has two at least !"));
                }
                methodToCall = methods[i];
            }
            ++i;
        }
        if (methodToCall != null) {
            try {
                methodToCall.invoke((Object)this.getTest(), paramObject);
            }
            catch (InvocationTargetException e) {
                e.fillInStackTrace();
                throw e.getTargetException();
            }
            catch (IllegalAccessException e) {
                e.fillInStackTrace();
                throw e;
            }
        }
        return paramObject;
    }

    protected void callClientGlobalEnd(WebRequest theRequest, HttpURLConnection theConnection, Object theResponse) throws Throwable {
        this.callGenericEndMethod(theRequest, theConnection, "end", theResponse);
    }

    public Object callEndMethod(WebRequest webRequest, HttpURLConnection httpURLConnection) throws Throwable {
        WebRequest webRequest2 = webRequest;
        HttpURLConnection httpURLConnection2 = httpURLConnection;
        Object[] objectArray = new Object[]{webRequest2, httpURLConnection2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        return WebClientTestCaseDelegate.callEndMethod_aroundBody1$advice(this, webRequest2, httpURLConnection2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void runTest() throws Throwable {
        this.runGenericTest(new DefaultHttpClient((WebConfiguration)this.getConfiguration()));
    }

    protected void runGenericTest(DefaultHttpClient theHttpClient) throws Throwable {
        WebRequest request = new WebRequest((WebConfiguration)this.getConfiguration());
        this.callClientGlobalBegin(request);
        this.callBeginMethod(request);
        HttpURLConnection connection = this.runWebTest(request, theHttpClient);
        Object response = this.callEndMethod(request, connection);
        this.callClientGlobalEnd(request, connection, response);
        connection.getInputStream().close();
    }

    private HttpURLConnection runWebTest(WebRequest theRequest, DefaultHttpClient theHttpClient) throws Throwable {
        RequestDirectives directives = new RequestDirectives(theRequest);
        directives.setClassName(this.getDelegatedTest().getClass().getName());
        directives.setMethodName(this.getCurrentTestName());
        directives.setAutoSession(theRequest.getAutomaticSession() ? "true" : "false");
        if (this.isWrappingATest()) {
            directives.setWrappedTestName(this.getWrappedTestName());
        }
        if (theRequest.getURL() != null) {
            theRequest.getURL().saveToRequest(theRequest);
        }
        HttpURLConnection connection = theHttpClient.doTest(theRequest);
        return connection;
    }

    static {
        Factory factory = new Factory("WebClientTestCaseDelegate.java", Class.forName("org.apache.cactus.internal.client.WebClientTestCaseDelegate"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-callEndMethod-org.apache.cactus.internal.client.WebClientTestCaseDelegate-org.apache.cactus.WebRequest:java.net.HttpURLConnection:-theRequest:theConnection:-java.lang.Throwable:-java.lang.Object-"), 242);
    }

    static final Object callEndMethod_aroundBody0(WebClientTestCaseDelegate webClientTestCaseDelegate, WebRequest webRequest, HttpURLConnection httpURLConnection, JoinPoint joinPoint) {
        return webClientTestCaseDelegate.callGenericEndMethod(webRequest, httpURLConnection, webClientTestCaseDelegate.getEndMethodName(), null);
    }

    /*
     * WARNING - void declaration
     */
    static final Object callEndMethod_aroundBody1$advice(WebClientTestCaseDelegate this_, WebRequest ajc_aroundClosure, HttpURLConnection thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void result;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            Object object = WebClientTestCaseDelegate.callEndMethod_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
            StringBuffer stringBuffer = new StringBuffer(joinPoint2.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append(object);
            stringBuffer.append(']');
            log.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return object;
        }
        void var12_12 = result;
        return WebClientTestCaseDelegate.callEndMethod_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
    }
}

