/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.internal.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.cactus.Request;
import org.apache.cactus.configuration.Configuration;
import org.apache.cactus.util.JUnitVersionHelper;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class ClientTestCaseDelegate
extends Assert {
    protected static final String TEST_METHOD_PREFIX = "test";
    protected static final String BEGIN_METHOD_PREFIX = "begin";
    protected static final String END_METHOD_PREFIX = "end";
    protected static final String CLIENT_GLOBAL_BEGIN_METHOD = "begin";
    protected static final String CLIENT_GLOBAL_END_METHOD = "end";
    private Log logger;
    private Configuration configuration;
    private Test wrappedTest;
    private Test delegatedTest;
    static /* synthetic */ Class class$0;
    public static final JoinPoint.StaticPart ajc$tjp_0;
    public static final JoinPoint.StaticPart ajc$tjp_1;
    public static final JoinPoint.StaticPart ajc$tjp_2;
    public static final JoinPoint.StaticPart ajc$tjp_3;

    public ClientTestCaseDelegate(Test theDelegatedTest, Test theWrappedTest, Configuration theConfiguration) {
        if (theDelegatedTest == null) {
            throw new IllegalStateException("The test object passed must not be null");
        }
        this.setDelegatedTest(theDelegatedTest);
        this.setWrappedTest(theWrappedTest);
        this.setConfiguration(theConfiguration);
    }

    public void setWrappedTest(Test test) {
        Test test2 = test;
        Object[] objectArray = new Object[]{test2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        ClientTestCaseDelegate.setWrappedTest_aroundBody1$advice(this, test2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void setDelegatedTest(Test test) {
        Test test2 = test;
        Object[] objectArray = new Object[]{test2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        ClientTestCaseDelegate.setDelegatedTest_aroundBody3$advice(this, test2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public Test getWrappedTest() {
        return this.wrappedTest;
    }

    public Test getDelegatedTest() {
        return this.delegatedTest;
    }

    public Test getTest() {
        Test activeTest = this.getWrappedTest() != null ? this.getWrappedTest() : this.getDelegatedTest();
        return activeTest;
    }

    public final Log getLogger() {
        return this.logger;
    }

    protected void setLogger(Log theLogger) {
        this.logger = theLogger;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        Configuration configuration2 = configuration;
        Object[] objectArray = new Object[]{configuration2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        ClientTestCaseDelegate.setConfiguration_aroundBody5$advice(this, configuration2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    private String getBaseMethodName() {
        if (!this.getCurrentTestName().startsWith(TEST_METHOD_PREFIX)) {
            throw new RuntimeException("bad name [" + this.getCurrentTestName() + "]. It should start with [" + TEST_METHOD_PREFIX + "].");
        }
        return this.getCurrentTestName().substring(TEST_METHOD_PREFIX.length());
    }

    protected String getBeginMethodName() {
        return "begin" + this.getBaseMethodName();
    }

    protected String getEndMethodName() {
        return "end" + this.getBaseMethodName();
    }

    public void runBareInit() {
        this.logger = LogFactory.getLog(((Object)((Object)this)).getClass());
        this.getLogger().debug((Object)("------------- Test: " + this.getCurrentTestName()));
    }

    private void callGenericBeginMethod(Request theRequest, String theMethodName) throws Throwable {
        Method[] methods = this.getTest().getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(theMethodName)) {
                Class<?>[] parameters;
                if (!methods[i].getReturnType().getName().equals("void")) {
                    Assert.fail((String)("The method [" + methods[i].getName() + "] should return void and not [" + methods[i].getReturnType().getName() + "]"));
                }
                if (!Modifier.isPublic(methods[i].getModifiers())) {
                    Assert.fail((String)("Method [" + methods[i].getName() + "] should be declared public"));
                }
                if ((parameters = methods[i].getParameterTypes()).length != 1) {
                    StringBuffer stringBuffer = new StringBuffer("The method [").append(methods[i].getName()).append("] must accept a single parameter derived from ").append("class [");
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.apache.cactus.WebRequest");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Assert.fail((String)stringBuffer.append(clazz.getName()).append("], ").append("but ").append(parameters.length).append(" parameters were found").toString());
                } else if (!theRequest.getClass().isAssignableFrom(parameters[0])) {
                    Assert.fail((String)("The method [" + methods[i].getName() + "] must accept a single parameter derived from " + "class [" + theRequest.getClass().getName() + "], " + "but found a [" + parameters[0].getName() + "] " + "parameter instead"));
                }
                try {
                    methods[i].invoke((Object)this.getTest(), theRequest);
                    break;
                }
                catch (InvocationTargetException e) {
                    e.fillInStackTrace();
                    throw e.getTargetException();
                }
                catch (IllegalAccessException e) {
                    e.fillInStackTrace();
                    throw e;
                }
            }
            ++i;
        }
    }

    protected void callClientGlobalBegin(Request theRequest) throws Throwable {
        this.callGenericBeginMethod(theRequest, "begin");
    }

    public void callBeginMethod(Request request) throws Throwable {
        Request request2 = request;
        Object[] objectArray = new Object[]{request2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        ClientTestCaseDelegate.callBeginMethod_aroundBody7$advice(this, request2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    protected String getCurrentTestMethod() {
        return this.getCurrentTestName();
    }

    protected String getCurrentTestName() {
        return JUnitVersionHelper.getTestCaseName(this.getDelegatedTest());
    }

    public String getWrappedTestName() {
        if (this.isWrappingATest()) {
            return this.getWrappedTest().getClass().getName();
        }
        return null;
    }

    public boolean isWrappingATest() {
        return this.getWrappedTest() != null;
    }

    static {
        Factory factory = new Factory("ClientTestCaseDelegate.java", Class.forName("org.apache.cactus.internal.client.ClientTestCaseDelegate"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setWrappedTest-org.apache.cactus.internal.client.ClientTestCaseDelegate-junit.framework.Test:-theWrappedTest:--void-"), 167);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setDelegatedTest-org.apache.cactus.internal.client.ClientTestCaseDelegate-junit.framework.Test:-theDelegatedTest:--void-"), 175);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setConfiguration-org.apache.cactus.internal.client.ClientTestCaseDelegate-org.apache.cactus.configuration.Configuration:-theConfiguration:--void-"), 246);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-callBeginMethod-org.apache.cactus.internal.client.ClientTestCaseDelegate-org.apache.cactus.Request:-theRequest:-java.lang.Throwable:-void-"), 400);
    }

    static final void setWrappedTest_aroundBody0(ClientTestCaseDelegate clientTestCaseDelegate, Test test, JoinPoint joinPoint) {
        clientTestCaseDelegate.wrappedTest = test;
    }

    /*
     * WARNING - void declaration
     */
    static final Object setWrappedTest_aroundBody1$advice(ClientTestCaseDelegate this_, Test ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            ClientTestCaseDelegate.setWrappedTest_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        ClientTestCaseDelegate.setWrappedTest_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    static final void setDelegatedTest_aroundBody2(ClientTestCaseDelegate clientTestCaseDelegate, Test test, JoinPoint joinPoint) {
        clientTestCaseDelegate.delegatedTest = test;
    }

    /*
     * WARNING - void declaration
     */
    static final Object setDelegatedTest_aroundBody3$advice(ClientTestCaseDelegate this_, Test ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            ClientTestCaseDelegate.setDelegatedTest_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        ClientTestCaseDelegate.setDelegatedTest_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    static final void setConfiguration_aroundBody4(ClientTestCaseDelegate clientTestCaseDelegate, Configuration configuration, JoinPoint joinPoint) {
        clientTestCaseDelegate.configuration = configuration;
    }

    /*
     * WARNING - void declaration
     */
    static final Object setConfiguration_aroundBody5$advice(ClientTestCaseDelegate this_, Configuration ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            ClientTestCaseDelegate.setConfiguration_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        ClientTestCaseDelegate.setConfiguration_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    static final void callBeginMethod_aroundBody6(ClientTestCaseDelegate clientTestCaseDelegate, Request request, JoinPoint joinPoint) {
        clientTestCaseDelegate.callGenericBeginMethod(request, clientTestCaseDelegate.getBeginMethodName());
    }

    /*
     * WARNING - void declaration
     */
    static final Object callBeginMethod_aroundBody7$advice(ClientTestCaseDelegate this_, Request ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            ClientTestCaseDelegate.callBeginMethod_aroundBody6(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        ClientTestCaseDelegate.callBeginMethod_aroundBody6(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }
}

