/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.configuration;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.cactus.util.ChainedRuntimeException;
import org.apache.cactus.util.ClassLoaderUtils;

public class ConfigurationInitializer {
    private static final String DEFAULT_CONFIG_NAME = "cactus";
    private static final String CACTUS_CONFIG_PROPERTY = "cactus.config";
    private static final String CACTUS_LOGGING_CONFIG_PROPERTY = "cactus.logging.config";
    private static boolean isInitialized;
    static /* synthetic */ Class class$0;

    public static final synchronized void initialize() {
        if (!isInitialized) {
            ConfigurationInitializer.initializeConfig();
            ConfigurationInitializer.initializeLoggingConfig();
            isInitialized = true;
        }
    }

    private static final void initializeConfig() {
        ResourceBundle config;
        String configOverride = System.getProperty(CACTUS_CONFIG_PROPERTY);
        if (configOverride == null) {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.apache.cactus.configuration.ConfigurationInitializer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                config = ClassLoaderUtils.loadPropertyResourceBundle(DEFAULT_CONFIG_NAME, clazz);
            }
            catch (MissingResourceException missingResourceException) {
                return;
            }
        }
        try {
            config = new PropertyResourceBundle(new FileInputStream(configOverride));
        }
        catch (IOException e) {
            throw new ChainedRuntimeException("Cannot read cactus configuration file [" + configOverride + "]", e);
        }
        ConfigurationInitializer.addSystemProperties(config);
    }

    private static final void initializeLoggingConfig() {
        String logConfig = System.getProperty(CACTUS_LOGGING_CONFIG_PROPERTY);
        if (logConfig != null) {
            PropertyResourceBundle bundle;
            try {
                bundle = new PropertyResourceBundle(new FileInputStream(logConfig));
            }
            catch (IOException iOException) {
                throw new ChainedRuntimeException("Failed to load logging configuration file [" + logConfig + "]");
            }
            ConfigurationInitializer.addSystemProperties(bundle);
        }
    }

    private static void addSystemProperties(ResourceBundle theBundle) {
        Enumeration<String> keys = theBundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (System.getProperty(key) != null) continue;
            System.setProperty(key, theBundle.getString(key));
        }
    }
}

