/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.client.connector.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import org.apache.cactus.WebRequest;
import org.apache.cactus.client.authentication.Authentication;
import org.apache.cactus.client.connector.http.ConnectionHelper;
import org.apache.cactus.client.connector.http.HttpUtil;
import org.apache.cactus.configuration.Configuration;
import org.apache.cactus.util.ChainedRuntimeException;
import org.apache.cactus.util.CookieUtil;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class JdkConnectionHelper
implements ConnectionHelper {
    private static final Log LOGGER;
    private String url;
    static /* synthetic */ Class class$0;
    public static final JoinPoint.StaticPart ajc$tjp_0;

    static {
        Factory factory = new Factory("JdkConnectionHelper.java", Class.forName("org.apache.cactus.client.connector.http.JdkConnectionHelper"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-connect-org.apache.cactus.client.connector.http.JdkConnectionHelper-org.apache.cactus.WebRequest:org.apache.cactus.configuration.Configuration:-theRequest:theConfiguration:-java.lang.Throwable:-java.net.HttpURLConnection-"), 123);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.cactus.client.connector.http.JdkConnectionHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = LogFactory.getLog((Class)clazz);
        HttpURLConnection.setFollowRedirects(false);
    }

    public JdkConnectionHelper(String theURL) {
        this.url = theURL;
    }

    public HttpURLConnection connect(WebRequest webRequest, Configuration configuration) throws Throwable {
        WebRequest webRequest2 = webRequest;
        Configuration configuration2 = configuration;
        Object[] objectArray = new Object[]{webRequest2, configuration2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        return (HttpURLConnection)JdkConnectionHelper.connect_aroundBody1$advice(this, webRequest2, configuration2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    private void addUserData(WebRequest theRequest, URLConnection theConnection) throws IOException {
        int length;
        if (theRequest.getUserData() == null) {
            return;
        }
        OutputStream out = this.getConnectionStream(theConnection);
        InputStream stream = theRequest.getUserData();
        byte[] buffer = new byte[2048];
        while ((length = stream.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
        out.close();
    }

    private void addHttpPostParameters(WebRequest theRequest, URLConnection theConnection) {
        int i;
        String[] values;
        String key;
        if (!theRequest.getParameterNamesPost().hasMoreElements()) {
            return;
        }
        PrintWriter out = new PrintWriter(this.getConnectionStream(theConnection));
        StringBuffer queryString = new StringBuffer();
        Enumeration keys = theRequest.getParameterNamesPost();
        if (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            values = theRequest.getParameterValuesPost(key);
            queryString.append(key);
            queryString.append('=');
            queryString.append(URLEncoder.encode(values[0]));
            i = 1;
            while (i < values.length) {
                queryString.append('&');
                queryString.append(key);
                queryString.append('=');
                queryString.append(URLEncoder.encode(values[i]));
                ++i;
            }
        }
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            values = theRequest.getParameterValuesPost(key);
            i = 0;
            while (i < values.length) {
                queryString.append('&');
                queryString.append(key);
                queryString.append('=');
                queryString.append(URLEncoder.encode(values[i]));
                ++i;
            }
        }
        out.print(queryString.toString());
        out.close();
    }

    private OutputStream getConnectionStream(URLConnection theConnection) {
        OutputStream out;
        try {
            out = theConnection.getOutputStream();
        }
        catch (IOException e) {
            String reason = "Cannot connect to URL [" + theConnection.getURL() + "]. Reason : [" + e.getMessage() + "]\r\n";
            reason = String.valueOf(reason) + "Possible reasons :\r\n";
            reason = String.valueOf(reason) + "\t- The server is not running,\r\n";
            reason = String.valueOf(reason) + "\t- The server redirector is not correctly mapped in web.xml,\r\n";
            reason = String.valueOf(reason) + "\t- Something else ... !";
            throw new ChainedRuntimeException(reason);
        }
        return out;
    }

    private void addHeaders(WebRequest theRequest, URLConnection theConnection) {
        Enumeration keys = theRequest.getHeaderNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String[] values = theRequest.getHeaderValues(key);
            StringBuffer fullHeaderValue = new StringBuffer(values[0]);
            int i = 1;
            while (i < values.length) {
                fullHeaderValue.append("," + values[i]);
                ++i;
            }
            theConnection.setRequestProperty(key, fullHeaderValue.toString());
        }
    }

    static final HttpURLConnection connect_aroundBody0(JdkConnectionHelper jdkConnectionHelper, WebRequest webRequest, Configuration configuration, JoinPoint joinPoint) {
        URL uRL = new URL(jdkConnectionHelper.url);
        Authentication authentication = webRequest.getAuthentication();
        if (authentication != null) {
            authentication.configure(webRequest, configuration);
        }
        uRL = HttpUtil.addHttpGetParameters(webRequest, uRL);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setDoInput(true);
        if (webRequest.getParameterNamesPost().hasMoreElements() || webRequest.getUserData() != null) {
            httpURLConnection.setDoOutput(true);
        } else {
            httpURLConnection.setDoOutput(false);
        }
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Content-type", webRequest.getContentType());
        jdkConnectionHelper.addHeaders(webRequest, httpURLConnection);
        String string = CookieUtil.getCookieString(webRequest, uRL);
        if (string != null) {
            httpURLConnection.setRequestProperty("Cookie", string);
        }
        if (webRequest.getUserData() != null) {
            jdkConnectionHelper.addUserData(webRequest, httpURLConnection);
        } else {
            jdkConnectionHelper.addHttpPostParameters(webRequest, httpURLConnection);
        }
        LOGGER.debug((Object)("ContentLength = [" + httpURLConnection.getContentLength() + "]"));
        httpURLConnection.connect();
        return httpURLConnection;
    }

    /*
     * WARNING - void declaration
     */
    static final Object connect_aroundBody1$advice(JdkConnectionHelper this_, WebRequest ajc_aroundClosure, Configuration thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void result;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            HttpURLConnection httpURLConnection = JdkConnectionHelper.connect_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
            StringBuffer stringBuffer = new StringBuffer(joinPoint2.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append(httpURLConnection);
            stringBuffer.append(']');
            log.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return httpURLConnection;
        }
        void var12_12 = result;
        return JdkConnectionHelper.connect_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
    }
}

