/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.client.connector.http;

import java.net.HttpURLConnection;
import org.apache.cactus.RequestDirectives;
import org.apache.cactus.ServiceEnumeration;
import org.apache.cactus.WebRequest;
import org.apache.cactus.WebTestResult;
import org.apache.cactus.client.AssertionFailedErrorWrapper;
import org.apache.cactus.client.ParsingException;
import org.apache.cactus.client.ServletExceptionWrapper;
import org.apache.cactus.client.WebTestResultParser;
import org.apache.cactus.client.connector.http.AutoReadHttpURLConnection;
import org.apache.cactus.client.connector.http.ConnectionHelper;
import org.apache.cactus.client.connector.http.ConnectionHelperFactory;
import org.apache.cactus.configuration.WebConfiguration;
import org.apache.cactus.util.ChainedRuntimeException;
import org.apache.cactus.util.IoUtil;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class DefaultHttpClient {
    protected WebConfiguration configuration;
    public static final JoinPoint.StaticPart ajc$tjp_0;

    public DefaultHttpClient(WebConfiguration theConfiguration) {
        this.configuration = theConfiguration;
    }

    public HttpURLConnection doTest(WebRequest webRequest) throws Throwable {
        WebRequest webRequest2 = webRequest;
        Object[] objectArray = new Object[]{webRequest2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        return (HttpURLConnection)DefaultHttpClient.doTest_aroundBody1$advice(this, webRequest2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    private HttpURLConnection callRunTest(WebRequest theRequest) throws Throwable {
        theRequest.addParameter("Cactus_Service", ServiceEnumeration.CALL_TEST_SERVICE.toString(), "GET");
        ConnectionHelper helper = ConnectionHelperFactory.getConnectionHelper(this.configuration.getRedirectorURL(theRequest), this.configuration);
        HttpURLConnection connection = helper.connect(theRequest, this.configuration);
        connection = new AutoReadHttpURLConnection(connection);
        connection.getInputStream();
        return connection;
    }

    private WebTestResult callGetResult(WebRequest theOriginalRequest) throws Throwable {
        ConnectionHelper helper;
        HttpURLConnection resultConnection;
        WebRequest resultsRequest = new WebRequest(this.configuration);
        RequestDirectives directives = new RequestDirectives(resultsRequest);
        directives.setService(ServiceEnumeration.GET_RESULTS_SERVICE);
        resultsRequest.setRedirectorName(theOriginalRequest.getRedirectorName());
        if (theOriginalRequest.getAuthentication() != null) {
            resultsRequest.setAuthentication(theOriginalRequest.getAuthentication());
        }
        if ((resultConnection = (helper = ConnectionHelperFactory.getConnectionHelper(this.configuration.getRedirectorURL(resultsRequest), this.configuration)).connect(resultsRequest, this.configuration)).getResponseCode() != 200) {
            throw new ParsingException("Not a valid response [" + resultConnection.getResponseCode() + " " + resultConnection.getResponseMessage() + "]");
        }
        WebTestResultParser parser = new WebTestResultParser();
        return parser.parse(IoUtil.getText(resultConnection.getInputStream(), "UTF-8"));
    }

    static {
        Factory factory = new Factory("DefaultHttpClient.java", Class.forName("org.apache.cactus.client.connector.http.DefaultHttpClient"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-doTest-org.apache.cactus.client.connector.http.DefaultHttpClient-org.apache.cactus.WebRequest:-theRequest:-java.lang.Throwable:-java.net.HttpURLConnection-"), 119);
    }

    static final HttpURLConnection doTest_aroundBody0(DefaultHttpClient defaultHttpClient, WebRequest webRequest, JoinPoint joinPoint) {
        HttpURLConnection httpURLConnection = defaultHttpClient.callRunTest(webRequest);
        WebTestResult webTestResult = null;
        try {
            webTestResult = defaultHttpClient.callGetResult(webRequest);
        }
        catch (ParsingException parsingException) {
            String string = defaultHttpClient.configuration.getRedirectorURL(webRequest);
            throw new ChainedRuntimeException("Failed to get the test results at [" + string + "]", parsingException);
        }
        if (webTestResult.hasException()) {
            if (webTestResult.getExceptionClassName().equals("junit.framework.AssertionFailedError") || webTestResult.getExceptionClassName().equals("junit.framework.ComparisonFailure")) {
                throw new AssertionFailedErrorWrapper(webTestResult.getExceptionMessage(), webTestResult.getExceptionClassName(), webTestResult.getExceptionStackTrace());
            }
            throw new ServletExceptionWrapper(webTestResult.getExceptionMessage(), webTestResult.getExceptionClassName(), webTestResult.getExceptionStackTrace());
        }
        return httpURLConnection;
    }

    /*
     * WARNING - void declaration
     */
    static final Object doTest_aroundBody1$advice(DefaultHttpClient this_, WebRequest ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var10_8 = logger;
            HttpURLConnection httpURLConnection = DefaultHttpClient.doTest_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
            StringBuffer stringBuffer = new StringBuffer(result.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append(httpURLConnection);
            stringBuffer.append(']');
            log.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return httpURLConnection;
        }
        void var11_11 = logger;
        return DefaultHttpClient.doTest_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
    }
}

