/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.client.authentication;

import java.text.StringCharacterIterator;
import org.apache.cactus.WebRequest;
import org.apache.cactus.client.authentication.AbstractAuthentication;
import org.apache.cactus.configuration.Configuration;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class BasicAuthentication
extends AbstractAuthentication {
    private static char[] alphabet;
    private static byte[] codes;
    public static final JoinPoint.StaticPart ajc$tjp_0;

    static {
        Factory factory = new Factory("BasicAuthentication.java", Class.forName("org.apache.cactus.client.authentication.BasicAuthentication"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-configure-org.apache.cactus.client.authentication.BasicAuthentication-org.apache.cactus.WebRequest:org.apache.cactus.configuration.Configuration:-theRequest:theConfiguration:--void-"), 225);
        alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        codes = new byte[256];
        int i = 0;
        while (i < 256) {
            BasicAuthentication.codes[i] = -1;
            ++i;
        }
        i = 65;
        while (i <= 90) {
            BasicAuthentication.codes[i] = (byte)(i - 65);
            ++i;
        }
        i = 97;
        while (i <= 122) {
            BasicAuthentication.codes[i] = (byte)(26 + i - 97);
            ++i;
        }
        i = 48;
        while (i <= 57) {
            BasicAuthentication.codes[i] = (byte)(52 + i - 48);
            ++i;
        }
        BasicAuthentication.codes[43] = 62;
        BasicAuthentication.codes[47] = 63;
    }

    public BasicAuthentication(String theName, String thePassword) {
        super(theName, thePassword);
    }

    protected void validateName(String theName) {
        if (theName == null) {
            return;
        }
        String illegalChars = "()<>@,;:\\\"/[]?={} \t";
        StringCharacterIterator iter = new StringCharacterIterator(theName);
        char c = iter.first();
        while (c != '\uffff') {
            if (illegalChars.indexOf(c) != -1 || c >= '\u0000' && c <= '\u001f' || c == '\u007f') {
                throw new IllegalArgumentException("[" + theName + "] contains illegal characters.");
            }
            c = iter.next();
        }
    }

    protected void validatePassword(String thePassword) {
        if (thePassword == null) {
            return;
        }
        String exceptionChars = "\r\n \t";
        StringCharacterIterator iter = new StringCharacterIterator(thePassword);
        char c = iter.first();
        while (c != '\uffff') {
            if ((c >= '\u0000' && c <= '\u001f' || c == '\u007f') && exceptionChars.indexOf(c) == -1) {
                throw new IllegalArgumentException("Given thePassword contains illegal characters.");
            }
            c = iter.next();
        }
    }

    public void configure(WebRequest webRequest, Configuration configuration) {
        WebRequest webRequest2 = webRequest;
        Configuration configuration2 = configuration;
        Object[] objectArray = new Object[]{webRequest2, configuration2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        BasicAuthentication.configure_aroundBody1$advice(this, webRequest2, configuration2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    private static char[] base64Encode(byte[] theData) {
        char[] out = new char[(theData.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < theData.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & theData[i];
            val <<= 8;
            if (i + 1 < theData.length) {
                val |= 0xFF & theData[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < theData.length) {
                val |= 0xFF & theData[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    static final void configure_aroundBody0(BasicAuthentication basicAuthentication, WebRequest webRequest, Configuration configuration, JoinPoint joinPoint) {
        String string = String.valueOf(basicAuthentication.getName()) + ":" + basicAuthentication.getPassword();
        String string2 = "Basic " + new String(BasicAuthentication.base64Encode(string.getBytes()));
        webRequest.addHeader("Authorization", string2);
    }

    /*
     * WARNING - void declaration
     */
    static final Object configure_aroundBody1$advice(BasicAuthentication this_, WebRequest ajc_aroundClosure, Configuration thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void result;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            BasicAuthentication.configure_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
            Object var9_10 = null;
            log.debug((Object)(String.valueOf('>') + joinPoint2.getSignature().getName()));
            return var9_10;
        }
        void var11_11 = result;
        BasicAuthentication.configure_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
        return null;
    }
}

