/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus;

import javax.servlet.http.HttpServletRequest;
import org.apache.cactus.WebRequest;
import org.apache.cactus.server.ServletUtil;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.reflect.Factory;

public class ServletURL {
    public static final String URL_PROTOCOL_PARAM = "Cactus_URL_Protocol";
    public static final String URL_SERVER_NAME_PARAM = "Cactus_URL_Server";
    public static final String URL_CONTEXT_PATH_PARAM = "Cactus_URL_ContextPath";
    public static final String URL_SERVLET_PATH_PARAM = "Cactus_URL_ServletPath";
    public static final String URL_PATH_INFO_PARAM = "Cactus_URL_PathInfo";
    public static final String URL_QUERY_STRING_PARAM = "Cactus_URL_QueryString";
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_HTTPS = "https";
    private static final int DEFAULT_PORT_HTTP = 80;
    private static final int DEFAULT_PORT_HTTPS = 443;
    private static final Log LOGGER;
    private String serverName;
    private String contextPath;
    private String servletPath;
    private String pathInfo;
    private String queryString;
    private String protocol = "http";
    static /* synthetic */ Class class$0;
    public static final JoinPoint.StaticPart ajc$tjp_0;
    public static final JoinPoint.StaticPart ajc$tjp_1;
    public static final JoinPoint.StaticPart ajc$tjp_2;
    public static final JoinPoint.StaticPart ajc$tjp_3;
    public static final JoinPoint.StaticPart ajc$tjp_4;
    public static final JoinPoint.StaticPart ajc$tjp_5;
    public static final JoinPoint.StaticPart ajc$tjp_6;
    public static final JoinPoint.StaticPart ajc$tjp_7;

    static {
        Factory factory = new Factory("ServletURL.java", Class.forName("org.apache.cactus.ServletURL"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setProtocol-org.apache.cactus.ServletURL-java.lang.String:-theProtocol:--void-"), 313);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setServerName-org.apache.cactus.ServletURL-java.lang.String:-theServerName:--void-"), 346);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setContextPath-org.apache.cactus.ServletURL-java.lang.String:-theContextPath:--void-"), 447);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setServletPath-org.apache.cactus.ServletURL-java.lang.String:-theServletPath:--void-"), 482);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setPathInfo-org.apache.cactus.ServletURL-java.lang.String:-thePathInfo:--void-"), 513);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setQueryString-org.apache.cactus.ServletURL-java.lang.String:-theQueryString:--void-"), 549);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-saveToRequest-org.apache.cactus.ServletURL-org.apache.cactus.WebRequest:-theRequest:--void-"), 582);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-loadFromRequest-org.apache.cactus.ServletURL-javax.servlet.http.HttpServletRequest:-theRequest:--org.apache.cactus.ServletURL-"), 626);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.cactus.ServletURL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOGGER = LogFactory.getLog((Class)clazz);
    }

    public ServletURL() {
    }

    public ServletURL(String theProtocol, String theServerName, String theContextPath, String theServletPath, String thePathInfo, String theQueryString) {
        this.setProtocol(theProtocol);
        this.setServerName(theServerName);
        this.setContextPath(theContextPath);
        this.setServletPath(theServletPath);
        this.setPathInfo(thePathInfo);
        this.setQueryString(theQueryString);
    }

    public ServletURL(String theServerName, String theContextPath, String theServletPath, String thePathInfo, String theQueryString) {
        this(PROTOCOL_HTTP, theServerName, theContextPath, theServletPath, thePathInfo, theQueryString);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        String string2 = string;
        Object[] objectArray = new Object[]{string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        ServletURL.setProtocol_aroundBody1$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        String string2 = string;
        Object[] objectArray = new Object[]{string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        ServletURL.setServerName_aroundBody3$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getHost() {
        int pos;
        String host = this.getServerName();
        if (host != null && (pos = host.indexOf(":")) > 0) {
            host = host.substring(0, pos);
        }
        return host;
    }

    public int getPort() {
        int port = -1;
        if (this.getServerName() != null) {
            int pos = this.getServerName().indexOf(":");
            if (pos < 0) {
                port = this.getDefaultPort();
            } else {
                try {
                    port = Integer.parseInt(this.getServerName().substring(pos + 1));
                    if (port < 0) {
                        port = -1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    port = -1;
                }
            }
        }
        return port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String string) {
        String string2 = string;
        Object[] objectArray = new Object[]{string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        ServletURL.setContextPath_aroundBody5$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String string) {
        String string2 = string;
        Object[] objectArray = new Object[]{string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        ServletURL.setServletPath_aroundBody7$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String string) {
        String string2 = string;
        Object[] objectArray = new Object[]{string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        ServletURL.setPathInfo_aroundBody9$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        String string2 = string;
        Object[] objectArray = new Object[]{string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        ServletURL.setQueryString_aroundBody11$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getPath() {
        String path = this.getContextPath() == null ? "" : this.getContextPath();
        path = String.valueOf(path) + (this.getServletPath() == null ? "" : this.getServletPath());
        if ((path = String.valueOf(path) + (this.getPathInfo() == null ? "" : this.getPathInfo())).length() == 0) {
            path = null;
        }
        return path;
    }

    public void saveToRequest(WebRequest webRequest) {
        WebRequest webRequest2 = webRequest;
        Object[] objectArray = new Object[]{webRequest2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        ServletURL.saveToRequest_aroundBody13$advice(this, webRequest2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public static ServletURL loadFromRequest(HttpServletRequest httpServletRequest) {
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        Object[] objectArray = new Object[]{httpServletRequest2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object[])objectArray);
        return (ServletURL)ServletURL.loadFromRequest_aroundBody15$advice(httpServletRequest2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("protocol = [" + this.getProtocol() + "], ");
        buffer.append("host name = [" + this.getHost() + "], ");
        buffer.append("port = [" + this.getPort() + "], ");
        buffer.append("context path = [" + this.getContextPath() + "], ");
        buffer.append("servlet path = [" + this.getServletPath() + "], ");
        buffer.append("path info = [" + this.getPathInfo() + "], ");
        buffer.append("query string = [" + this.getQueryString() + "]");
        return buffer.toString();
    }

    private int getDefaultPort() {
        if (PROTOCOL_HTTPS.equals(this.getProtocol())) {
            return 443;
        }
        return 80;
    }

    static final void setProtocol_aroundBody0(ServletURL servletURL, String string, JoinPoint joinPoint) {
        if (!string.equals(PROTOCOL_HTTP) && !string.equals(PROTOCOL_HTTPS)) {
            throw new RuntimeException("Invalid protocol [" + string + "]. Currently supported protocols are [" + PROTOCOL_HTTP + "] and [" + PROTOCOL_HTTPS + "].");
        }
        servletURL.protocol = string;
    }

    /*
     * WARNING - void declaration
     */
    static final Object setProtocol_aroundBody1$advice(ServletURL this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            ServletURL.setProtocol_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        ServletURL.setProtocol_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    static final void setServerName_aroundBody2(ServletURL servletURL, String string, JoinPoint joinPoint) {
        servletURL.serverName = string;
    }

    /*
     * WARNING - void declaration
     */
    static final Object setServerName_aroundBody3$advice(ServletURL this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            ServletURL.setServerName_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        ServletURL.setServerName_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    static final void setContextPath_aroundBody4(ServletURL servletURL, String string, JoinPoint joinPoint) {
        if (string != null && string.length() > 0) {
            if (!string.startsWith("/")) {
                throw new IllegalArgumentException("The Context Path must start with a \"/\" character.");
            }
            if (string.endsWith("/")) {
                throw new IllegalArgumentException("The Context Path must not end with a \"/\" character.");
            }
        }
        servletURL.contextPath = string;
    }

    /*
     * WARNING - void declaration
     */
    static final Object setContextPath_aroundBody5$advice(ServletURL this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            ServletURL.setContextPath_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        ServletURL.setContextPath_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    static final void setServletPath_aroundBody6(ServletURL servletURL, String string, JoinPoint joinPoint) {
        if (string != null && string.length() > 0 && !string.startsWith("/")) {
            throw new IllegalArgumentException("The Servlet Path must start with a \"/\" character.");
        }
        servletURL.servletPath = string;
    }

    /*
     * WARNING - void declaration
     */
    static final Object setServletPath_aroundBody7$advice(ServletURL this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            ServletURL.setServletPath_aroundBody6(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        ServletURL.setServletPath_aroundBody6(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    static final void setPathInfo_aroundBody8(ServletURL servletURL, String string, JoinPoint joinPoint) {
        if (string != null && string.length() == 0) {
            throw new IllegalArgumentException("The Path Info must not be an empty string. Use null if you don't want to have a path info.");
        }
        if (string != null && !string.startsWith("/")) {
            throw new IllegalArgumentException("The Path Info must start with a \"/\" character.");
        }
        servletURL.pathInfo = string;
    }

    /*
     * WARNING - void declaration
     */
    static final Object setPathInfo_aroundBody9$advice(ServletURL this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            ServletURL.setPathInfo_aroundBody8(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        ServletURL.setPathInfo_aroundBody8(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    static final void setQueryString_aroundBody10(ServletURL servletURL, String string, JoinPoint joinPoint) {
        servletURL.queryString = string;
    }

    /*
     * WARNING - void declaration
     */
    static final Object setQueryString_aroundBody11$advice(ServletURL this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            ServletURL.setQueryString_aroundBody10(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        ServletURL.setQueryString_aroundBody10(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    static final void saveToRequest_aroundBody12(ServletURL servletURL, WebRequest webRequest, JoinPoint joinPoint) {
        webRequest.addParameter(URL_PROTOCOL_PARAM, servletURL.getProtocol(), "GET");
        if (servletURL.getServerName() != null) {
            webRequest.addParameter(URL_SERVER_NAME_PARAM, servletURL.getServerName(), "GET");
        }
        if (servletURL.getContextPath() != null) {
            webRequest.addParameter(URL_CONTEXT_PATH_PARAM, servletURL.getContextPath(), "GET");
        }
        if (servletURL.getServletPath() != null) {
            webRequest.addParameter(URL_SERVLET_PATH_PARAM, servletURL.getServletPath(), "GET");
        }
        if (servletURL.getPathInfo() != null) {
            webRequest.addParameter(URL_PATH_INFO_PARAM, servletURL.getPathInfo(), "GET");
        }
        if (servletURL.getQueryString() != null) {
            webRequest.addParameter(URL_QUERY_STRING_PARAM, servletURL.getQueryString(), "GET");
        }
    }

    /*
     * WARNING - void declaration
     */
    static final Object saveToRequest_aroundBody13$advice(ServletURL this_, WebRequest ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            ServletURL.saveToRequest_aroundBody12(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        ServletURL.saveToRequest_aroundBody12(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    static final ServletURL loadFromRequest_aroundBody14(HttpServletRequest httpServletRequest, JoinPoint joinPoint) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6 = httpServletRequest.getQueryString();
        boolean bl = false;
        ServletURL servletURL = new ServletURL();
        String string7 = ServletUtil.getQueryStringParameter(string6, URL_PROTOCOL_PARAM);
        if (string7 != null) {
            bl = true;
            servletURL.setProtocol(string7);
        }
        if ((string5 = ServletUtil.getQueryStringParameter(string6, URL_SERVER_NAME_PARAM)) != null) {
            bl = true;
            servletURL.setServerName(string5);
        }
        if ((string4 = ServletUtil.getQueryStringParameter(string6, URL_CONTEXT_PATH_PARAM)) != null) {
            bl = true;
            servletURL.setContextPath(string4);
        }
        if ((string3 = ServletUtil.getQueryStringParameter(string6, URL_SERVLET_PATH_PARAM)) != null) {
            bl = true;
            servletURL.setServletPath(string3);
        }
        if ((string2 = ServletUtil.getQueryStringParameter(string6, URL_PATH_INFO_PARAM)) != null) {
            bl = true;
            servletURL.setPathInfo(string2);
        }
        if ((string = ServletUtil.getQueryStringParameter(string6, URL_QUERY_STRING_PARAM)) != null) {
            bl = true;
            servletURL.setQueryString(string);
        }
        if (!bl) {
            LOGGER.debug((Object)"Undefined simulation URL");
            servletURL = null;
        } else {
            LOGGER.debug((Object)("Simulation URL = [" + servletURL + "]"));
        }
        return servletURL;
    }

    /*
     * WARNING - void declaration
     */
    static final Object loadFromRequest_aroundBody15$advice(HttpServletRequest this_, JoinPoint ajc_aroundClosure, LogAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Log log = LogFactory.getLog((Class)joinPoint.getSignature().getDeclaringType());
        if (log.isDebugEnabled()) {
            void exitString;
            void result;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature(thisJoinPoint, joinPoint)));
            void var8_6 = logger;
            ServletURL servletURL = ServletURL.loadFromRequest_aroundBody14(this_, ajc_aroundClosure);
            StringBuffer stringBuffer = new StringBuffer(result.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append(servletURL);
            stringBuffer.append(']');
            exitString.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return servletURL;
        }
        void var9_9 = logger;
        return ServletURL.loadFromRequest_aroundBody14(this_, ajc_aroundClosure);
    }
}

