/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.cactus.configuration.ConfigurationInitializer;
import org.apache.cactus.configuration.ServletConfiguration;
import org.apache.cactus.internal.client.WebClientTestCaseDelegate;
import org.apache.cactus.internal.server.ServerTestCaseDelegate;
import org.apache.cactus.server.HttpServletRequestWrapper;
import org.apache.cactus.server.ServletConfigWrapper;

public class ServletTestCase
extends TestCase {
    public HttpServletRequestWrapper request;
    public HttpServletResponse response;
    public HttpSession session;
    public ServletConfigWrapper config;
    private WebClientTestCaseDelegate clientDelegate;
    private ServerTestCaseDelegate serverDelegate;

    static {
        ConfigurationInitializer.initialize();
    }

    public ServletTestCase() {
        this.init(null);
    }

    public ServletTestCase(String theName) {
        super(theName);
        this.init(null);
    }

    public ServletTestCase(String theName, Test theTest) {
        super(theName);
        this.init(theTest);
    }

    void init(Test theTest) {
        this.setClientDelegate(new WebClientTestCaseDelegate((Test)this, theTest, new ServletConfiguration()));
        this.setServerDelegate(new ServerTestCaseDelegate((Test)this, theTest));
    }

    void setClientDelegate(WebClientTestCaseDelegate theDelegate) {
        this.clientDelegate = theDelegate;
    }

    void setServerDelegate(ServerTestCaseDelegate theDelegate) {
        this.serverDelegate = theDelegate;
    }

    WebClientTestCaseDelegate getClientDelegate() {
        return this.clientDelegate;
    }

    private ServerTestCaseDelegate getServerDelegate() {
        return this.serverDelegate;
    }

    private boolean isServerSide() {
        boolean result = false;
        if (this.request != null) {
            result = true;
        }
        return result;
    }

    public void runBare() throws Throwable {
        if (this.isServerSide()) {
            this.getServerDelegate().runBareInit();
        } else {
            this.getClientDelegate().runBareInit();
        }
        try {
            this.runCactusTest();
        }
        catch (Throwable t) {
            if (!this.isServerSide()) {
                this.getClientDelegate().getLogger().debug((Object)"Exception in test", t);
            }
            throw t;
        }
    }

    protected void runCactusTest() throws Throwable {
        if (this.isServerSide()) {
            if (this.getServerDelegate().getWrappedTest() != null) {
                ((TestCase)this.getServerDelegate().getWrappedTest()).runBare();
            } else {
                super.runBare();
            }
        } else {
            this.getClientDelegate().runTest();
        }
    }
}

