/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus;

import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.cactus.configuration.ConfigurationInitializer;
import org.apache.cactus.configuration.FilterConfiguration;
import org.apache.cactus.internal.client.WebClientTestCaseDelegate;
import org.apache.cactus.internal.server.ServerTestCaseDelegate;
import org.apache.cactus.server.FilterConfigWrapper;
import org.apache.cactus.server.HttpServletRequestWrapper;

public class FilterTestCase
extends TestCase {
    public HttpServletRequestWrapper request;
    public HttpServletResponse response;
    public FilterConfigWrapper config;
    public FilterChain filterChain;
    private WebClientTestCaseDelegate clientDelegate;
    private ServerTestCaseDelegate serverDelegate;

    static {
        ConfigurationInitializer.initialize();
    }

    public FilterTestCase() {
        this.init(null);
    }

    public FilterTestCase(String theName) {
        super(theName);
        this.init(null);
    }

    public FilterTestCase(String theName, Test theTest) {
        super(theName);
        this.init(theTest);
    }

    void init(Test theTest) {
        this.setClientDelegate(new WebClientTestCaseDelegate((Test)this, theTest, new FilterConfiguration()));
        this.setServerDelegate(new ServerTestCaseDelegate((Test)this, theTest));
    }

    void setClientDelegate(WebClientTestCaseDelegate theDelegate) {
        this.clientDelegate = theDelegate;
    }

    void setServerDelegate(ServerTestCaseDelegate theDelegate) {
        this.serverDelegate = theDelegate;
    }

    WebClientTestCaseDelegate getClientDelegate() {
        return this.clientDelegate;
    }

    private ServerTestCaseDelegate getServerDelegate() {
        return this.serverDelegate;
    }

    private boolean isServerSide() {
        boolean result = false;
        if (this.request != null) {
            result = true;
        }
        return result;
    }

    public void runBare() throws Throwable {
        if (this.isServerSide()) {
            this.getServerDelegate().runBareInit();
        } else {
            this.getClientDelegate().runBareInit();
        }
        try {
            this.runCactusTest();
        }
        catch (Throwable t) {
            if (!this.isServerSide()) {
                this.getClientDelegate().getLogger().debug((Object)"Exception in test", t);
            }
            throw t;
        }
    }

    protected void runCactusTest() throws Throwable {
        if (this.isServerSide()) {
            if (this.getServerDelegate().getWrappedTest() != null) {
                ((TestCase)this.getServerDelegate().getWrappedTest()).runBare();
            } else {
                super.runBare();
            }
        } else {
            this.getClientDelegate().runTest();
        }
    }
}

