/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.cactus.ServletTestCase;
import org.apache.cactus.util.log.LogAspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.AroundClosure;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public abstract class AbstractTestSuite
implements Test {
    private Vector tests = new Vector(10);
    private String name;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    public static final JoinPoint.StaticPart ajc$tjp_0;
    public static final JoinPoint.StaticPart ajc$tjp_1;
    public static final JoinPoint.StaticPart ajc$tjp_2;
    public static final JoinPoint.StaticPart ajc$tjp_3;
    public static final JoinPoint.StaticPart ajc$tjp_4;
    public static final JoinPoint.StaticPart ajc$tjp_5;
    public static final JoinPoint.StaticPart ajc$tjp_6;

    public AbstractTestSuite() {
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AbstractTestSuite(Class theClass) {
        Class clazz;
        Constructor constructor;
        this.setName(theClass.getName());
        try {
            constructor = AbstractTestSuite.getTestConstructor(theClass);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.addTest(AbstractTestSuite.warning("Class " + theClass.getName() + " has no public constructor TestCase(String name)"));
            return;
        }
        if (!Modifier.isPublic(theClass.getModifiers())) {
            this.addTest(AbstractTestSuite.warning("Class " + theClass.getName() + " is not public"));
            return;
        }
        Class superClass = theClass;
        Vector names = new Vector();
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                Method[] methods = superClass.getDeclaredMethods();
                int i = 0;
                while (i < methods.length) {
                    this.addTestMethod(methods[i], names, constructor);
                    ++i;
                }
                superClass = superClass.getSuperclass();
            }
            if ((clazz = class$0) != null) continue;
            try {
                clazz = Class.forName("junit.framework.Test");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz.isAssignableFrom(superClass));
        if (this.tests.size() == 0) {
            this.addTest(AbstractTestSuite.warning("No tests found in " + theClass.getName()));
        }
    }

    public AbstractTestSuite(String theName) {
        this.setName(theName);
    }

    public void addTest(Test test) {
        Test test2 = test;
        Object[] objectArray = new Object[]{test2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        AbstractTestSuite.addTest_aroundBody1$advice(this, test2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void addTestSuite(Class clazz) {
        Class clazz2 = clazz;
        Object[] objectArray = new Object[]{clazz2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        AbstractTestSuite.addTestSuite_aroundBody3$advice(this, clazz2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    private void addTestMethod(Method theMethod, Vector theNames, Constructor theConstructor) {
        String name = theMethod.getName();
        if (theNames.contains(name)) {
            return;
        }
        if (this.isPublicTestMethod(theMethod)) {
            theNames.addElement(name);
            try {
                Object constructorInstance;
                if (theConstructor.getParameterTypes().length == 0) {
                    constructorInstance = theConstructor.newInstance(new Object[0]);
                    if (constructorInstance instanceof TestCase) {
                        ((TestCase)constructorInstance).setName(name);
                    }
                } else {
                    constructorInstance = theConstructor.newInstance(name);
                }
                this.addTest((Test)new ServletTestCase(name, (Test)constructorInstance));
            }
            catch (InstantiationException e) {
                this.addTest(AbstractTestSuite.warning("Cannot instantiate test case: " + name + " (" + this.exceptionToString(e) + ")"));
            }
            catch (InvocationTargetException e) {
                this.addTest(AbstractTestSuite.warning("Exception in constructor: " + name + " (" + this.exceptionToString(e.getTargetException()) + ")"));
            }
            catch (IllegalAccessException e) {
                this.addTest(AbstractTestSuite.warning("Cannot access test case: " + name + " (" + this.exceptionToString(e) + ")"));
            }
        } else if (this.isTestMethod(theMethod)) {
            this.addTest(AbstractTestSuite.warning("Test method isn't public: " + theMethod.getName()));
        }
    }

    private String exceptionToString(Throwable theThrowable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        theThrowable.printStackTrace(writer);
        return stringWriter.toString();
    }

    public int countTestCases() {
        int count = 0;
        Enumeration e = this.tests();
        while (e.hasMoreElements()) {
            Test test = (Test)e.nextElement();
            count += test.countTestCases();
        }
        return count;
    }

    private boolean isPublicTestMethod(Method theMethod) {
        return this.isTestMethod(theMethod) && Modifier.isPublic(theMethod.getModifiers());
    }

    private boolean isTestMethod(Method theMethod) {
        String name = theMethod.getName();
        Class<?>[] parameters = theMethod.getParameterTypes();
        Class<?> returnType = theMethod.getReturnType();
        return parameters.length == 0 && name.startsWith("test") && returnType.equals(Void.TYPE);
    }

    public void run(TestResult testResult) {
        TestResult testResult2 = testResult;
        Object[] objectArray = new Object[]{testResult2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        AbstractTestSuite.run_aroundBody5$advice(this, testResult2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public void runTest(Test test, TestResult testResult) {
        Test test2 = test;
        TestResult testResult2 = testResult;
        Object[] objectArray = new Object[]{test2, testResult2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        AbstractTestSuite.runTest_aroundBody7$advice(this, test2, testResult2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public Test testAt(int n) {
        int n2 = n;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        return (Test)AbstractTestSuite.testAt_aroundBody9$advice(this, n2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public static Constructor getTestConstructor(Class clazz) throws NoSuchMethodException {
        Class clazz2 = clazz;
        Object[] objectArray = new Object[]{clazz2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object[])objectArray);
        return (Constructor)AbstractTestSuite.getTestConstructor_aroundBody11$advice(clazz2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public int testCount() {
        return this.tests.size();
    }

    public Enumeration tests() {
        return this.tests.elements();
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }

    public void setName(String string) {
        String string2 = string;
        Object[] objectArray = new Object[]{string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        AbstractTestSuite.setName_aroundBody13$advice(this, string2, joinPoint, LogAspect.aspectOf(), null, joinPoint);
    }

    public String getName() {
        return this.name;
    }

    private static Test warning(final String theMessage) {
        return new TestCase("warning"){

            protected void runTest() {
                Assert.fail((String)theMessage);
            }
        };
    }

    protected abstract Test createTestSuite(Class var1);

    protected abstract Test createCactusTestCase(String var1, Test var2);

    static {
        Factory factory = new Factory("AbstractTestSuite.java", Class.forName("org.apache.cactus.AbstractTestSuite"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-addTest-org.apache.cactus.AbstractTestSuite-junit.framework.Test:-theTest:--void-"), 155);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-addTestSuite-org.apache.cactus.AbstractTestSuite-java.lang.Class:-theTestClass:--void-"), 163);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.apache.cactus.AbstractTestSuite-junit.framework.TestResult:-theResult:--void-"), 280);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-runTest-org.apache.cactus.AbstractTestSuite-junit.framework.Test:junit.framework.TestResult:-theTest:theResult:--void-"), 296);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-testAt-org.apache.cactus.AbstractTestSuite-int:-theIndex:--junit.framework.Test-"), 304);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getTestConstructor-org.apache.cactus.AbstractTestSuite-java.lang.Class:-theClass:-java.lang.NoSuchMethodException:-java.lang.reflect.Constructor-"), 319);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setName-org.apache.cactus.AbstractTestSuite-java.lang.String:-theName:--void-"), 364);
    }

    static final void addTest_aroundBody0(AbstractTestSuite abstractTestSuite, Test test, JoinPoint joinPoint) {
        abstractTestSuite.tests.addElement(test);
    }

    /*
     * WARNING - void declaration
     */
    static final Object addTest_aroundBody1$advice(AbstractTestSuite this_, Test ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            AbstractTestSuite.addTest_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        AbstractTestSuite.addTest_aroundBody0(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    static final void addTestSuite_aroundBody2(AbstractTestSuite abstractTestSuite, Class clazz, JoinPoint joinPoint) {
        abstractTestSuite.addTest(abstractTestSuite.createTestSuite(clazz));
    }

    /*
     * WARNING - void declaration
     */
    static final Object addTestSuite_aroundBody3$advice(AbstractTestSuite this_, Class ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            AbstractTestSuite.addTestSuite_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        AbstractTestSuite.addTestSuite_aroundBody2(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    static final void run_aroundBody4(AbstractTestSuite abstractTestSuite, TestResult testResult, JoinPoint joinPoint) {
        Enumeration enumeration = abstractTestSuite.tests();
        while (enumeration.hasMoreElements()) {
            if (testResult.shouldStop()) break;
            Test test = (Test)enumeration.nextElement();
            abstractTestSuite.runTest(test, testResult);
        }
    }

    /*
     * WARNING - void declaration
     */
    static final Object run_aroundBody5$advice(AbstractTestSuite this_, TestResult ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            AbstractTestSuite.run_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        AbstractTestSuite.run_aroundBody4(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }

    static final void runTest_aroundBody6(AbstractTestSuite abstractTestSuite, Test test, TestResult testResult, JoinPoint joinPoint) {
        test.run(testResult);
    }

    /*
     * WARNING - void declaration
     */
    static final Object runTest_aroundBody7$advice(AbstractTestSuite this_, Test ajc_aroundClosure, TestResult thisJoinPoint, JoinPoint joinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint2) {
        void result;
        void target;
        Class<?> clazz = joinPoint2.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void logger;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)logger, joinPoint2)));
            AroundClosure aroundClosure2 = aroundClosure;
            AbstractTestSuite.runTest_aroundBody6(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
            Object var9_10 = null;
            log.debug((Object)(String.valueOf('>') + joinPoint2.getSignature().getName()));
            return var9_10;
        }
        void var11_11 = result;
        AbstractTestSuite.runTest_aroundBody6(this_, ajc_aroundClosure, thisJoinPoint, (JoinPoint)target);
        return null;
    }

    static final Test testAt_aroundBody8(AbstractTestSuite abstractTestSuite, int n, JoinPoint joinPoint) {
        return (Test)abstractTestSuite.tests.elementAt(n);
    }

    /*
     * WARNING - void declaration
     */
    static final Object testAt_aroundBody9$advice(AbstractTestSuite this_, int ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var10_8 = logger;
            Test test = AbstractTestSuite.testAt_aroundBody8(this_, ajc_aroundClosure, thisJoinPoint);
            StringBuffer stringBuffer = new StringBuffer(result.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append(test);
            stringBuffer.append(']');
            log.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return test;
        }
        void var11_11 = logger;
        return AbstractTestSuite.testAt_aroundBody8(this_, ajc_aroundClosure, thisJoinPoint);
    }

    static final Constructor getTestConstructor_aroundBody10(Class clazz, JoinPoint joinPoint) {
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Class[] classArray2 = classArray;
        try {
            return clazz.getConstructor(classArray2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return clazz.getConstructor(new Class[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    static final Object getTestConstructor_aroundBody11$advice(Class this_, JoinPoint ajc_aroundClosure, LogAspect thisJoinPoint, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Log log = LogFactory.getLog((Class)joinPoint.getSignature().getDeclaringType());
        if (log.isDebugEnabled()) {
            void exitString;
            void result;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature(thisJoinPoint, joinPoint)));
            void var8_6 = logger;
            Constructor constructor = AbstractTestSuite.getTestConstructor_aroundBody10(this_, ajc_aroundClosure);
            StringBuffer stringBuffer = new StringBuffer(result.getSignature().getName());
            stringBuffer.append(' ');
            stringBuffer.append('=');
            stringBuffer.append(' ');
            stringBuffer.append('[');
            stringBuffer.append(constructor);
            stringBuffer.append(']');
            exitString.debug((Object)(String.valueOf('>') + stringBuffer.toString()));
            return constructor;
        }
        void var9_9 = logger;
        return AbstractTestSuite.getTestConstructor_aroundBody10(this_, ajc_aroundClosure);
    }

    static final void setName_aroundBody12(AbstractTestSuite abstractTestSuite, String string, JoinPoint joinPoint) {
        abstractTestSuite.name = string;
    }

    /*
     * WARNING - void declaration
     */
    static final Object setName_aroundBody13$advice(AbstractTestSuite this_, String ajc_aroundClosure, JoinPoint thisJoinPoint, LogAspect logAspect, AroundClosure aroundClosure, JoinPoint joinPoint) {
        void logger;
        Class<?> clazz = joinPoint.getTarget().getClass();
        Log log = LogFactory.getLog(clazz);
        if (log.isDebugEnabled()) {
            void result;
            void target;
            log.debug((Object)(String.valueOf('<') + LogAspect.ajc$inlineAccessMethod$org_apache_cactus_util_log_LogAspect$org_apache_cactus_util_log_LogAspect$getFullSignature((LogAspect)target, joinPoint)));
            void var9_8 = logger;
            AbstractTestSuite.setName_aroundBody12(this_, ajc_aroundClosure, thisJoinPoint);
            Object var8_9 = null;
            log.debug((Object)(String.valueOf('>') + result.getSignature().getName()));
            return var8_9;
        }
        void var10_10 = logger;
        AbstractTestSuite.setName_aroundBody12(this_, ajc_aroundClosure, thisJoinPoint);
        return null;
    }
}

