/*
 * Decompiled with CFR 0.152.
 */
package bilbofrmk.valueObjects;

import bilbofrmk.context.BConfig;
import bilbofrmk.valueObjects.BBaseValueObject;
import bilbofrmk.valueObjects.BIDocumento;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

public class BDocumento
extends BBaseValueObject
implements BIDocumento {
    static final long serialVersionUID = 3739556752731526429L;
    private static final int bufferSize = 1204;
    protected long idDocumento;
    protected String contentType;
    protected long fileSize;
    protected String fileName;
    protected String tempPath;
    protected String uniqueId;
    protected InputStream document;
    protected boolean bDocumento;

    public BDocumento(long idDocumento) {
        this.setIdDocumento(idDocumento);
        this.bDocumento = false;
    }

    public BDocumento(String fileName, String contentType) {
        this.fileName = fileName;
        this.contentType = contentType;
        this.bDocumento = false;
        this.fileSize = 0L;
        this.initDocumento();
    }

    public BDocumento() {
        this.bDocumento = false;
        this.fileSize = 0L;
        this.initDocumento();
    }

    public void initDocumento() {
        try {
            this.tempPath = BConfig.getInstance().getValue("bilbo.WORK_PATH");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.uniqueId = this.calculateUniqueId();
    }

    public boolean isInitDocumento() {
        return this.uniqueId != null;
    }

    public boolean hasDocument() {
        return this.bDocumento;
    }

    public void destroy() {
        File tempFile = new File(this.getFilePath());
        if (tempFile.exists()) {
            tempFile.delete();
        }
        this.bDocumento = false;
    }

    public long getIdDocumento() {
        return this.idDocumento;
    }

    public void setIdDocumento(long idDocumento) {
        this.idDocumento = idDocumento;
    }

    public void setFileName(String filename) {
        this.fileName = filename;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public InputStream getDocument() throws FileNotFoundException, IOException {
        return new FileInputStream(this.getFilePath());
    }

    public byte[] getDocumentBytes() throws FileNotFoundException, IOException {
        File file = new File(this.getFilePath());
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Fichero demasiado largo");
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("No se ha podido leer completamente el fichero: " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    @Override
    public void setDocument(InputStream in) throws FileNotFoundException, IOException {
        FileOutputStream fout = new FileOutputStream(this.getFilePath());
        int readLength = 0;
        long totalReaded = 0L;
        byte[] bytes = new byte[1204];
        while ((readLength = in.read(bytes, 0, 1204)) != -1) {
            fout.write(bytes, 0, readLength);
            totalReaded += (long)readLength;
        }
        in.close();
        fout.flush();
        fout.close();
        this.bDocumento = true;
        this.fileSize = totalReaded;
    }

    public String getFilePath() {
        return String.valueOf(this.tempPath) + "/" + this.fileName + "." + this.uniqueId;
    }

    protected String calculateUniqueId() {
        Date now = new Date();
        return Integer.toString(now.hashCode());
    }
}

