/*
 * Decompiled with CFR 0.152.
 */
package bilbofrmk.valueObjects;

import bilbofrmk.context.BIContext;
import bilbofrmk.exceptions.BDuplicateKeyException;
import bilbofrmk.exceptions.BPersistenceException;
import bilbofrmk.exceptions.BReferentialIntegrityException;
import bilbofrmk.util.BLogger;
import bilbofrmk.valueObjects.BBaseValueObject;
import bilbofrmk.valueObjects.BIDocumento;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.NamingException;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import weblogic.jdbc.wrapper.Clob;

public abstract class BBasePersistence {
    public static final String GETOBJECTBYID = "0";
    public static final String CREATEOBJECT = "1";
    public static final String UPDATEOBJECT = "2";
    public static final String DELETEOBJECT = "3";
    protected BBaseValueObject objetoPesistible;
    protected BIContext context;

    protected abstract BBaseValueObject updateObject() throws BPersistenceException;

    protected abstract BBaseValueObject createObject() throws BPersistenceException;

    protected abstract BBaseValueObject deleteObject() throws BPersistenceException;

    protected abstract BBaseValueObject getObjectById() throws BPersistenceException;

    protected abstract void loadObject(ResultSet var1) throws SQLException, BPersistenceException;

    protected void loadObject(ResultSet rs, int iObject) throws SQLException, BPersistenceException {
    }

    public BBaseValueObject doPersistence(BIContext context, BBaseValueObject oPersist, String op) throws BPersistenceException {
        this.objetoPesistible = oPersist;
        this.context = context;
        int ope = Integer.parseInt(op);
        switch (ope) {
            case 0: {
                return this.getObjectById();
            }
            case 1: {
                return this.createObject();
            }
            case 2: {
                return this.updateObject();
            }
            case 3: {
                return this.deleteObject();
            }
        }
        return null;
    }

    protected int doStatement(String strSql, ArrayList parameters) throws BPersistenceException {
        Statement ps = null;
        Connection con = null;
        int iRows = 0;
        try {
            try {
                con = this.context.lookupBConnection();
                BLogger.blog(3, "Se realiza la SQL:" + strSql);
                ps = con.prepareStatement(strSql);
                int i = 0;
                while (i < parameters.size()) {
                    ArrayList up = (ArrayList)parameters.get(i);
                    int j = 0;
                    while (j < up.size()) {
                        BLogger.blog(3, "parametro SQL " + j + ":" + up.get(j));
                        if (up.get(j) != null) {
                            ps.setObject(j + 1, up.get(j));
                        } else {
                            try {
                                ps.setNull(j + 1, 12);
                            }
                            catch (SQLException e) {
                                try {
                                    ps.setNull(j + 1, 2);
                                }
                                catch (SQLException e2) {
                                    ps.setNull(j + 1, 91);
                                }
                            }
                        }
                        ++j;
                    }
                    iRows += ps.executeUpdate();
                    ++i;
                }
            }
            catch (SQLException e) {
                BLogger.blog(1, "Error de SQL en BBasePersistence.doPersistence()", e);
                if (e.getMessage().indexOf("ORA-00001") != -1) {
                    throw new BDuplicateKeyException("PersitenceBase", e);
                }
                if (e.getMessage().indexOf("ORA-02292") != -1) {
                    throw new BReferentialIntegrityException("PersitenceBase", e);
                }
                throw new BPersistenceException("Error de SQL en BBasePersistence.doPersistence()", e);
            }
            catch (NamingException e) {
                throw new BPersistenceException("Error en la obtenci\u00f3n de la conexion a BD", e);
            }
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                throw new BPersistenceException("Error cerrando conexiones SQL en BBasePersistence.doPersistence()", e);
            }
        }
        return iRows;
    }

    protected Object doPLSQLFunctionStatement(String strSql, ArrayList parameters, int type) throws BPersistenceException {
        Statement cs = null;
        Connection con = null;
        Object result = null;
        try {
            try {
                con = this.context.lookupBConnection();
                BLogger.blog(3, "Se realiza la SQL:" + strSql);
                cs = con.prepareCall(strSql);
                cs.registerOutParameter(1, type);
                int j = 0;
                while (j < parameters.size()) {
                    BLogger.blog(3, "parametro SQL " + j + ":" + parameters.get(j));
                    if (parameters.get(j) != null) {
                        cs.setObject(j + 2, parameters.get(j));
                    } else {
                        try {
                            cs.setNull(j + 2, 12);
                        }
                        catch (SQLException e) {
                            try {
                                cs.setNull(j + 2, 2);
                            }
                            catch (SQLException e2) {
                                cs.setNull(j + 2, 91);
                            }
                        }
                    }
                    ++j;
                }
                cs.execute();
                result = cs.getObject(1);
            }
            catch (SQLException e) {
                BLogger.blog(1, "Error de SQL en BBasePersistence.doPersistence()", e);
                if (e.getMessage().indexOf("ORA-00001") != -1) {
                    throw new BDuplicateKeyException("PersitenceBase", e);
                }
                if (e.getMessage().indexOf("ORA-02292") != -1) {
                    throw new BReferentialIntegrityException("PersitenceBase", e);
                }
                throw new BPersistenceException("Error de SQL en BBasePersistence.doPersistence()", e);
            }
            catch (NamingException e) {
                throw new BPersistenceException("Error en la obtenci\u00f3n de la conexion a BD", e);
            }
        }
        finally {
            try {
                if (cs != null) {
                    cs.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                throw new BPersistenceException("Error cerrando conexiones SQL en BBasePersistence.doPersistence()", e);
            }
        }
        return result;
    }

    protected int doLobStatement(String strSql, ArrayList parameters) throws BPersistenceException {
        PreparedStatement ps = null;
        Connection con = null;
        int iRows = 0;
        ArrayList<java.sql.Clob> clobs = new ArrayList<java.sql.Clob>();
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        try {
            try {
                con = this.context.lookupBConnection();
                BLogger.blog(3, "Se realiza la SQL:" + strSql);
                ps = con.prepareStatement(strSql);
                int i = 0;
                while (i < parameters.size()) {
                    ArrayList up = (ArrayList)parameters.get(i);
                    int j = 0;
                    while (j < up.size()) {
                        BLogger.blog(3, "parametro SQL " + j + ":" + up.get(j));
                        if (up.get(j) != null) {
                            if (up.get(j) instanceof Reader || up.get(j) instanceof String && ((String)up.get(j)).length() > 3900) {
                                java.sql.Clob clob = this.getNewCLob(up.get(j));
                                clobs.add(clob);
                                ps.setObject(j + 1, clob);
                            } else if (up.get(j) instanceof BIDocumento) {
                                Blob blob = this.getNewBLob((BIDocumento)up.get(j));
                                blobs.add(blob);
                                ps.setObject(j + 1, blob);
                            } else {
                                ps.setObject(j + 1, up.get(j));
                            }
                        } else {
                            try {
                                ps.setNull(j + 1, 12);
                            }
                            catch (SQLException e) {
                                try {
                                    ps.setNull(j + 1, 2);
                                }
                                catch (SQLException e2) {
                                    ps.setNull(j + 1, 91);
                                }
                            }
                        }
                        ++j;
                    }
                    iRows += ps.executeUpdate();
                    ++i;
                }
            }
            catch (SQLException e) {
                BLogger.blog(1, "Error de SQL en BBasePersistence.doPersistence()", e);
                if (e.getMessage().indexOf("ORA-00001") != -1) {
                    throw new BDuplicateKeyException("PersitenceBase", e);
                }
                if (e.getMessage().indexOf("ORA-02292") != -1) {
                    throw new BReferentialIntegrityException("PersitenceBase", e);
                }
                throw new BPersistenceException("Error de SQL en BBasePersistence.doPersistence()", e);
            }
            catch (NamingException e) {
                throw new BPersistenceException("Error en la obtenci\u00f3n de la conexion a BD", e);
            }
        }
        finally {
            try {
                int i = 0;
                while (i < clobs.size()) {
                    java.sql.Clob clob = (java.sql.Clob)clobs.get(i);
                    this.freeClob(clob);
                    ++i;
                }
                i = 0;
                while (i < blobs.size()) {
                    Blob blob = (Blob)blobs.get(i);
                    this.freeBlob(blob);
                    ++i;
                }
                if (ps != null) {
                    ps.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                throw new BPersistenceException("Error cerrando conexiones SQL en BBasePersistence.doPersistence()", e);
            }
        }
        return iRows;
    }

    protected void doQuery(String strSql, ArrayList parameters) throws BPersistenceException {
        Statement ps = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            try {
                BLogger.blog(3, "Se realiza la query:" + strSql);
                con = this.context.lookupBConnection();
                ps = con.prepareStatement(strSql, 1003, 1007);
                int i = 0;
                while (i < parameters.size()) {
                    BLogger.blog(3, "parametro query " + i + ":" + parameters.get(i));
                    ps.setObject(i + 1, parameters.get(i));
                    ++i;
                }
                rs = ps.executeQuery();
                this.loadObject(rs);
            }
            catch (SQLException e) {
                BLogger.blog(1, "Error de SQL en BBasePersistence.doQuery()", e);
                throw new BPersistenceException("Error de SQL en BBasePersistence.doQuery()", e);
            }
            catch (NamingException e) {
                throw new BPersistenceException("Error en la obtenci\u00f3n de la conexion a BD", e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                throw new BPersistenceException("Error cerrando conexiones SQL en BBasePersistence.doQuery()", e);
            }
        }
    }

    protected void doQuery(String strSql, ArrayList parameters, int iObject) throws BPersistenceException {
        Statement ps = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            try {
                BLogger.blog(3, "Se realiza la query:" + strSql);
                con = this.context.lookupBConnection();
                ps = con.prepareStatement(strSql, 1003, 1007);
                int i = 0;
                while (i < parameters.size()) {
                    BLogger.blog(3, "parametro query " + i + ":" + parameters.get(i));
                    ps.setObject(i + 1, parameters.get(i));
                    ++i;
                }
                rs = ps.executeQuery();
                this.loadObject(rs, iObject);
            }
            catch (SQLException e) {
                BLogger.blog(1, "Error de SQL en BBasePersistence.doQuery()", e);
                throw new BPersistenceException("Error de SQL en BBasePersistence.doQuery()", e);
            }
            catch (NamingException e) {
                throw new BPersistenceException("Error en la obtenci\u00f3n de la conexion a BD", e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                throw new BPersistenceException("Error cerrando conexiones SQL en BBasePersistence.doQuery()", e);
            }
        }
    }

    protected Long getNextVal(String strSequence) throws BPersistenceException {
        Long val = null;
        try {
            Connection con = this.context.lookupBConnection();
            String sql = "Select " + strSequence + ".nextval from dual";
            PreparedStatement ps = con.prepareStatement(sql, 1003, 1007);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                val = new Long(rs.getLong(1));
            }
            rs.close();
            ps.close();
            con.close();
        }
        catch (SQLException e) {
            throw new BPersistenceException("Error obteniendo sequencia", e);
        }
        catch (NamingException e) {
            throw new BPersistenceException("Error obteniendo conexion a BD pidiendo una sequencia", e);
        }
        return val;
    }

    protected java.sql.Clob getNewCLob(Object obj) throws BPersistenceException {
        Connection con = null;
        Statement stmt = null;
        java.sql.Clob clobTemp = null;
        try {
            con = this.context.lookupBConnection();
            String strSql = "BEGIN DBMS_LOB.CREATETEMPORARY(?, TRUE,DBMS_LOB.SESSION); END;";
            stmt = con.prepareCall(strSql);
            stmt.registerOutParameter(1, 2005);
            stmt.execute();
            clobTemp = stmt.getClob(1);
            Clob clobWraper = (Clob)clobTemp;
            CLOB clobOracle = (CLOB)clobWraper.getVendorObj();
            if (obj instanceof String) {
                clobOracle.putString(1L, obj.toString());
            } else {
                Reader r = (Reader)obj;
                Writer w = clobOracle.setCharacterStream(0L);
                BufferedReader br = new BufferedReader(r);
                String str = null;
                while ((str = br.readLine()) != null) {
                    w.write(str);
                }
                w.flush();
            }
            java.sql.Clob clob = clobTemp;
            return clob;
        }
        catch (SQLException e) {
            throw new BPersistenceException("Error obteniendo Clob temporal", e);
        }
        catch (NamingException e) {
            throw new BPersistenceException("Error obteniendo conexion a BD pidiendo una sequencia", e);
        }
        catch (IOException e) {
            throw new BPersistenceException("Error E/S leyendo fichero y escribiendo Clog", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                throw new BPersistenceException("Error cerrando conexiones SQL en BBasePersistence.doQuery()", e);
            }
        }
    }

    protected Blob getNewBLob(BIDocumento doc) throws BPersistenceException {
        Connection con = null;
        Statement stmt = null;
        Blob blobTemp = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            con = this.context.lookupBConnection();
            String strSql = "BEGIN DBMS_LOB.CREATETEMPORARY(?, TRUE,DBMS_LOB.SESSION); END;";
            stmt = con.prepareCall(strSql);
            stmt.registerOutParameter(1, 2004);
            stmt.execute();
            blobTemp = stmt.getBlob(1);
            weblogic.jdbc.wrapper.Blob blobWraper = (weblogic.jdbc.wrapper.Blob)blobTemp;
            BLOB blobOracle = (BLOB)blobWraper.getVendorObj();
            os = blobOracle.setBinaryStream(0L);
            is = doc.getDocument();
            byte[] inBytes = new byte[65534];
            int numBytes = is.read(inBytes);
            while (numBytes > 0) {
                os.write(inBytes, 0, numBytes);
                numBytes = is.read(inBytes);
            }
            os.flush();
            Blob blob = blobTemp;
            return blob;
        }
        catch (SQLException e) {
            throw new BPersistenceException("Error obteniendo Blob temporal", e);
        }
        catch (NamingException e) {
            throw new BPersistenceException("Error obteniendo conexion a BD pidiendo una sequencia", e);
        }
        catch (FileNotFoundException e) {
            throw new BPersistenceException("No se encuentra el fichero temporal del documento", e);
        }
        catch (IOException e) {
            throw new BPersistenceException("Error E/S leyendo el fichero y escribiendo blog", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                throw new BPersistenceException("Error cerrando conexiones SQL en BBasePersistence.doQuery()", e);
            }
        }
    }

    protected void freeClob(java.sql.Clob clob) throws BPersistenceException {
        try {
            Clob clobWraper = (Clob)clob;
            CLOB clobOracle = (CLOB)clobWraper.getVendorObj();
            clobOracle.freeTemporary();
        }
        catch (SQLException e) {
            throw new BPersistenceException("Error liberando Clob temporal", e);
        }
    }

    protected void freeBlob(Blob blob) throws BPersistenceException {
        try {
            weblogic.jdbc.wrapper.Blob blobWraper = (weblogic.jdbc.wrapper.Blob)blob;
            BLOB blobOracle = (BLOB)blobWraper.getVendorObj();
            blobOracle.freeTemporary();
        }
        catch (SQLException e) {
            throw new BPersistenceException("Error liberando Blob temporal", e);
        }
    }

    protected Integer readInt(ResultSet rs, String nombreCampo) throws SQLException {
        if (rs.getString(nombreCampo) != null) {
            return new Integer(rs.getInt(nombreCampo));
        }
        return null;
    }

    protected Double readDouble(ResultSet rs, String nombreCampo) throws SQLException {
        if (rs.getString(nombreCampo) != null) {
            return new Double(rs.getDouble(nombreCampo));
        }
        return null;
    }

    protected String readClob(ResultSet rs, String nombreCampo) throws SQLException {
        java.sql.Clob clob = rs.getClob(nombreCampo);
        if (clob != null) {
            return clob.getSubString(1L, (int)clob.length());
        }
        return null;
    }

    protected Reader readClobAsReader(ResultSet rs, String nombreCampo) throws SQLException {
        java.sql.Clob clob = rs.getClob(nombreCampo);
        if (clob != null) {
            return clob.getCharacterStream();
        }
        return null;
    }

    protected InputStream readBlob(ResultSet rs, String nombreCampo) throws SQLException {
        Blob blob = rs.getBlob(nombreCampo);
        if (blob != null) {
            return blob.getBinaryStream();
        }
        return null;
    }
}

