/*
 * Decompiled with CFR 0.152.
 */
package bilbofrmk.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.ejb.EJBException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class BWebAppUtil {
    public static Locale getLocaleFromCookie(HttpServletRequest request) {
        Locale locale = null;
        Cookie cookie = null;
        String country = null;
        String language = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                cookie = cookies[i];
                if ("Language".equals(cookie.getName())) {
                    language = cookie.getValue();
                } else if (cookie.getName().equals("Country")) {
                    country = cookie.getValue();
                }
                ++i;
            }
        }
        if (country != null && language != null) {
            locale = new Locale(language, country);
        }
        return locale;
    }

    public static boolean isValidLocale(Locale locale) {
        return locale.getLanguage().equals("ja") || locale.getLanguage().equals("en") || locale.getLanguage().equals("es");
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isEmpty(String str) {
        return !BWebAppUtil.isNotEmpty(str);
    }

    public static String cleanParam(Object obj) {
        String str = String.valueOf(obj);
        if (str == null || str.equals("null")) {
            str = "";
        }
        return str.trim();
    }

    public static boolean isValidString(String str) {
        boolean valid = true;
        if (valid) {
            String[] invalid = new String[]{"#", "&", "^", "%", "*", "/", "\\", "(", ")"};
            int i = 0;
            while (i < invalid.length) {
                if (str.indexOf(invalid[i]) >= 0) {
                    valid = false;
                }
                ++i;
            }
        }
        return valid;
    }

    public static String trimToSummaryStr(String str) {
        int endLength = 40;
        if (BWebAppUtil.isEmpty(str)) {
            return str;
        }
        if (str.length() > endLength) {
            String tmpStr = str.substring(0, str.indexOf(" ", endLength));
            tmpStr = String.valueOf(tmpStr) + "...";
            return tmpStr;
        }
        return str;
    }

    public static String getDisplayDate(Calendar pCalendar) {
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        if (pCalendar != null) {
            return format.format(pCalendar.getTime());
        }
        return "";
    }

    public static Calendar str2Calendar(String str) {
        Calendar cal = null;
        if (!BWebAppUtil.isEmpty(str)) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
                Date d = sdf.parse(str);
                cal = Calendar.getInstance();
                cal.setTime(d);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return cal;
    }

    public static String getCurrentDate() {
        return BWebAppUtil.getDisplayDate(GregorianCalendar.getInstance());
    }

    public static String col2Str(Collection col, String type) {
        StringBuffer str = new StringBuffer();
        if (col != null && !col.isEmpty()) {
            str.append(" Num of " + type + ": " + col.size() + " |");
            for (Object obj : col) {
                str.append(" " + obj.toString());
            }
        } else {
            str.append(String.valueOf(type) + ": [null]");
        }
        return str.toString();
    }

    public static String getFullContextPath(HttpServletRequest request) {
        String serverName = request.getServerName();
        int serverPort = request.getServerPort();
        String nextPage = "http://" + serverName + ":" + serverPort;
        return nextPage;
    }

    public static String getFullContext(HttpServletRequest request, ActionMapping mapping, String name) {
        ActionForward forward = mapping.findForward(name);
        String path = forward.getPath();
        return String.valueOf(BWebAppUtil.getFullContextPath(request)) + path.substring(path.indexOf("/") + 1);
    }

    public static String getServletName(ActionMapping mapping, String name) {
        ActionForward forward = mapping.findForward(name);
        String path = forward.getPath();
        return path.substring(path.indexOf("/") + 1);
    }

    public static String getStackTrace(Throwable th) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        th.printStackTrace(new PrintStream(stream));
        return stream.toString();
    }

    public static String getRootErrMsg(Throwable th) {
        if (th.getCause() != null) {
            return BWebAppUtil.getRootError(th.getCause()).getLocalizedMessage();
        }
        return th.getLocalizedMessage();
    }

    public static Throwable getRootError(Throwable th) {
        if (th instanceof EJBException) {
            Exception nested = ((EJBException)th).getCausedByException();
            if (nested != null) {
                return BWebAppUtil.getRootError(nested);
            }
            return th;
        }
        if (th instanceof RemoteException) {
            Throwable nested = th.getCause();
            if (nested != null) {
                return BWebAppUtil.getRootError(nested);
            }
            return th;
        }
        if (th instanceof AccessException) {
            Throwable nested = th.getCause();
            if (nested != null) {
                return BWebAppUtil.getRootError(nested);
            }
            return th;
        }
        if (th instanceof SQLException) {
            Throwable nested = th.getCause();
            if (nested != null) {
                return BWebAppUtil.getRootError(nested);
            }
            return th;
        }
        return th;
    }
}

