/*
 * Decompiled with CFR 0.152.
 */
package bilbofrmk.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class BValidationUtil {
    protected static final String[] NIFChars = new String[]{"T", "R", "W", "A", "G", "M", "Y", "F", "P", "D", "X", "B", "N", "J", "Z", "S", "Q", "V", "H", "L", "C", "K", "E"};

    public boolean isNotEmpty(String str) {
        return str != null && str.trim().length() > 0;
    }

    public boolean isEmpty(String str) {
        return !this.isNotEmpty(str);
    }

    public boolean isValidEmail(String email) {
        boolean valid = true;
        if (email == null) {
            valid = false;
        }
        if (valid) {
            String[] invalid = new String[]{" ", "#", "&", ":", ";", "^", "%", "!", "*", "(", ")"};
            int i = 0;
            while (i < invalid.length) {
                if (email.indexOf(invalid[i]) >= 0) {
                    valid = false;
                }
                ++i;
            }
        }
        if (valid) {
            int atFound = email.indexOf("@");
            int dotFound = email.indexOf(".", atFound);
            if (atFound < 0 || dotFound < 0 || atFound + 1 == dotFound) {
                valid = false;
            }
        }
        return valid;
    }

    public boolean isValidDate(HttpServletRequest request, String strDate) {
        Locale locale = request.getLocale();
        return this.isValidDate(locale, strDate);
    }

    public boolean isValidDate(Locale locale, String strDate) {
        boolean bResult = true;
        if (strDate.length() - strDate.lastIndexOf("/") < 5 && locale.getLanguage().equals("es")) {
            bResult = false;
            return false;
        }
        if (strDate.indexOf("/") < 4 && locale.getLanguage().equals("eu")) {
            bResult = false;
            return false;
        }
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        if (locale.getLanguage().equals("eu")) {
            df = new SimpleDateFormat("yyyy/MM/dd");
        }
        df.setLenient(false);
        if (this.isNotEmpty(strDate)) {
            try {
                df.parse(strDate);
            }
            catch (ParseException e) {
                bResult = false;
            }
        } else {
            bResult = false;
        }
        return bResult;
    }

    public boolean isValidNumber(String str) {
        boolean valid = true;
        try {
            long tmpLong = Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return valid;
    }

    public boolean isValidNumber(String str, int lenght) {
        boolean valid = true;
        try {
            long tmpLong = Long.parseLong(str);
            if (tmpLong <= 0L) {
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        if (str.trim().length() != lenght) {
            return false;
        }
        return valid;
    }

    public boolean isValidStrNumber(String pStr, String pDelimitator) {
        String tmpStr = "";
        boolean valid = true;
        int location = pStr.indexOf(pDelimitator);
        tmpStr = location < 0 ? pStr : pStr.replaceFirst("\\" + pDelimitator, "");
        valid = this.isValidNumber(tmpStr);
        return valid;
    }

    public boolean isValidISBN(String anyISBN) {
        int total = 0;
        if (anyISBN.length() < 10) {
            return false;
        }
        int i = 1;
        while (i < 10) {
            total += i * BValidationUtil.charToInt(anyISBN.charAt(i - 1));
            ++i;
        }
        int mod11 = total % 11;
        int checkDigit = anyISBN.charAt(anyISBN.length() - 1) == 'X' ? 10 : BValidationUtil.charToInt(anyISBN.charAt(anyISBN.length() - 1));
        return mod11 == checkDigit;
    }

    static int charToInt(char ch) {
        return ch - 48;
    }

    public boolean isCCValid(String entidad, String oficina, String dc, String cc) {
        if (this.isEmpty(entidad) || entidad.length() != 4) {
            return false;
        }
        if (this.isEmpty(oficina) || oficina.length() != 4) {
            return false;
        }
        if (this.isEmpty(dc) || dc.length() != 2) {
            return false;
        }
        if (this.isEmpty(cc) || cc.length() != 10) {
            return false;
        }
        if (!this.isValidNumber(entidad)) {
            return false;
        }
        if (!this.isValidNumber(oficina)) {
            return false;
        }
        if (!this.isValidNumber(dc)) {
            return false;
        }
        if (!this.isValidNumber(cc)) {
            return false;
        }
        return BValidationUtil.getDigitoControl("00" + entidad + oficina) == Integer.parseInt("" + dc.charAt(0)) && BValidationUtil.getDigitoControl(cc) == Integer.parseInt("" + dc.charAt(1));
    }

    static int getDigitoControl(String valor) {
        int[] valores = new int[]{1, 2, 4, 8, 5, 10, 9, 7, 3, 6};
        int control = 0;
        int i = 0;
        while (i <= 9) {
            control += Integer.parseInt("" + valor.charAt(i)) * valores[i];
            ++i;
        }
        if ((control = 11 - control % 11) == 11) {
            control = 0;
        } else if (control == 10) {
            control = 1;
        }
        return control;
    }

    public boolean isValidCurrency(String strDinero, int max) {
        NumberFormat nf = NumberFormat.getNumberInstance(new Locale("es", "ES"));
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(0);
        Number nDinero = new Double(0.0);
        try {
            nDinero = nf.parse(strDinero);
        }
        catch (ParseException e) {
            return false;
        }
        if (nf.format(nDinero).equals(strDinero)) {
            if (nDinero.doubleValue() > Math.pow(10.0, max)) {
                return false;
            }
        } else {
            nf.setMinimumFractionDigits(2);
            if (nf.format(nDinero).equals(strDinero)) {
                if (nDinero.doubleValue() > Math.pow(10.0, max)) {
                    return false;
                }
            } else {
                nf.setGroupingUsed(false);
                if (nf.format(nDinero).equals(strDinero)) {
                    if (nDinero.doubleValue() > Math.pow(10.0, max)) {
                        return false;
                    }
                } else {
                    nf.setMinimumFractionDigits(0);
                    if (nf.format(nDinero).equals(strDinero) && nDinero.doubleValue() > Math.pow(10.0, max)) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isValidstrFormatNumber(String strNumber) {
        NumberFormat nf = NumberFormat.getNumberInstance(new Locale("es", "ES"));
        Double doub = null;
        try {
            Number nNumber = nf.parse(strNumber);
            doub = new Double(nNumber.doubleValue());
        }
        catch (ParseException e) {
            return false;
        }
        if (nf.format(doub).equals(strNumber)) {
            return true;
        }
        nf.setMinimumFractionDigits(2);
        if (nf.format(doub).equals(strNumber)) {
            return true;
        }
        nf.setGroupingUsed(false);
        if (nf.format(doub).equals(strNumber)) {
            return true;
        }
        nf.setMinimumFractionDigits(0);
        return nf.format(doub).equals(strNumber);
    }

    public boolean isValidstrFormatNumber(String strNumber, double min, double max, int digtmin, int digtmax) {
        double dou;
        DecimalFormat df = (DecimalFormat)DecimalFormat.getNumberInstance(new Locale("es", "ES"));
        df.setMaximumFractionDigits(digtmax);
        df.setMinimumFractionDigits(digtmin);
        Double doub = null;
        try {
            Number number = df.parse(strNumber);
            doub = new Double(number.doubleValue());
            dou = doub;
        }
        catch (ParseException e) {
            return false;
        }
        if (df.format(doub).equals(strNumber)) {
            if (dou > max || dou < min) {
                return false;
            }
        } else {
            df.setGroupingUsed(false);
            if (df.format(doub).equals(strNumber)) {
                if (dou > max || dou < min) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean isValidNIF(String strNIF) {
        boolean bResult = false;
        if (!this.isNotEmpty(strNIF)) {
            return bResult;
        }
        if (strNIF.length() != 9) {
            return bResult;
        }
        if (!this.isValidNumber(strNIF.substring(0, 8))) {
            return bResult;
        }
        if (this.isValidNumber(strNIF.substring(8, 9))) {
            return bResult;
        }
        long NIFNumber = Long.parseLong(strNIF.substring(0, 8));
        String NIFChar = strNIF.substring(8, 9);
        NIFChar = NIFChar.toUpperCase();
        double ControlValue = NIFNumber / (long)NIFChars.length;
        ControlValue = Math.floor(ControlValue);
        int NIFCharIndex = new Double((double)NIFNumber - (ControlValue *= (double)NIFChars.length)).intValue();
        if (NIFChar.equals(NIFChars[NIFCharIndex])) {
            bResult = true;
        }
        return bResult;
    }

    public boolean isValidPartPresupuestaria(String partPresupuestaria) {
        String sPF_LetraControl;
        String strCaracter = "";
        String strLetra = "";
        int nCont = 1;
        String strAplicacion = "";
        String strAscii = "";
        char nASCII = '\u0000';
        long nParte1 = 0L;
        long nParte2 = 0L;
        long nResto = 0L;
        if (partPresupuestaria.length() < 29) {
            return false;
        }
        strLetra = partPresupuestaria.substring(28, 29);
        strAplicacion = partPresupuestaria.substring(0, 28);
        while (nCont < 29) {
            strCaracter = strAplicacion.substring(nCont - 1, nCont);
            nASCII = strCaracter.charAt(0);
            strAscii = nASCII < 'A' ? String.valueOf(strAscii) + strCaracter : String.valueOf(strAscii) + (nASCII - 64);
            ++nCont;
        }
        while (strAscii.length() < 30) {
            strAscii = String.valueOf(strAscii) + "0";
        }
        nParte1 = Long.parseLong(strAscii.substring(0, 15));
        nResto = nParte1 % 13L + (nParte2 = Long.parseLong(strAscii.substring(15, 30))) % 12L + 1L;
        if (nResto > 14L) {
            ++nResto;
        }
        return strLetra.equals(sPF_LetraControl = String.valueOf((char)(nResto + 64L)));
    }

    public boolean validarSeo(String campoSeo) {
        String regex = "[A-Za-z0-9|.,-/*\u00a1!\u00bf?\u00f1\u00d1\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00e2\u00ea\u00ee\u00f4\u00fb\u00c2\u00ca\u00ce\u00d4\u00db\u00e0\u00e8\u00ec\u00f2\u00f9\u00c0\u00c8\u00cc\u00d2\u00d9\u00e4\u00eb\u00ef\u00f6\u00fc\u00ff\u00c4\u00cb\u00cf\u00d6\u00dc\u0178'\u00df:;()\u00aa\u00ba%`\u00b4&\u00ab\u00bb\u00b2\u2019\\u0301\\u201D\\u201C\\u201E\\u2019\\u00E7\\u00C7\\u00E6\\u00C6\\u008C\\u009C\\s\"]*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(campoSeo);
        return matcher.matches();
    }

    public boolean validarUrlSeo(String urlSeo) {
        boolean match = true;
        if (this.isNotEmpty(urlSeo)) {
            String regex = "[A-Za-z0-9/-]*/$";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(urlSeo);
            match = matcher.matches();
        }
        return match;
    }
}

