/*
 * Decompiled with CFR 0.152.
 */
package bilbofrmk.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class BPresentationUtil {
    private static final String[] mesesEus = new String[]{"Urtarrila", "Otsaila", "Martxoa", "Apirila", "Maiatza", "Ekaina", "Uztaila", "Abuztua", "Iraila", "Urria", "Azaroa", "Abendua"};

    public String DateToStr(HttpServletRequest request, Date date) {
        Locale locale = request.getLocale();
        return this.DateToStr(locale, date);
    }

    public String DateToStr(Locale locale, Date date) {
        SimpleDateFormat df = new SimpleDateFormat();
        if (locale.getLanguage().equals("es")) {
            df = new SimpleDateFormat("dd/MM/yyyy");
        }
        if (locale.getLanguage().equals("eu")) {
            df = new SimpleDateFormat("yyyy/MM/dd");
        }
        if (locale.getLanguage().equals("en")) {
            df = new SimpleDateFormat("MM/dd/yyyy");
        }
        if (locale.getLanguage().equals("fr")) {
            df = new SimpleDateFormat("dd/MM/yyyy");
        }
        if (locale.getLanguage().equals("de")) {
            df = new SimpleDateFormat("dd.MM.yyyy");
        }
        return df.format(date);
    }

    public Date strToDate(HttpServletRequest request, String strDate) {
        Locale locale = request.getLocale();
        return this.strToDate(locale, strDate);
    }

    public Date strToDate(Locale locale, String strDate) {
        SimpleDateFormat df = new SimpleDateFormat();
        if (locale.getLanguage().equals("es")) {
            df = new SimpleDateFormat("dd/MM/yyyy");
        }
        if (locale.getLanguage().equals("eu")) {
            df = new SimpleDateFormat("yyyy/MM/dd");
        }
        df.setLenient(false);
        Date date = new Date();
        try {
            date.setTime(df.parse(strDate).getTime());
        }
        catch (ParseException e) {
            return null;
        }
        return date;
    }

    public String currencyToStr(HttpServletRequest request, Double dinero) {
        return this.currencyToStr(dinero);
    }

    public String currencyToStr(Double dinero) {
        NumberFormat nf = NumberFormat.getNumberInstance(new Locale("es", "ES"));
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        return nf.format(dinero);
    }

    public String currencyToStr(Double dinero, Locale loc) {
        NumberFormat nf = NumberFormat.getNumberInstance(loc);
        if (loc.getLanguage().equals("eu")) {
            nf = NumberFormat.getNumberInstance(new Locale("es", "ES"));
        }
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        return nf.format(dinero);
    }

    public Double strFormatNumberToNumber(HttpServletRequest request, String strNumber) {
        return this.strFormatNumberToNumber(strNumber);
    }

    public Double strFormatNumberToNumber(String strNumber) {
        NumberFormat nf = NumberFormat.getNumberInstance(new Locale("es", "ES"));
        Double doub = null;
        try {
            Number nNumber = nf.parse(strNumber);
            doub = new Double(nNumber.doubleValue());
        }
        catch (ParseException e) {
            return null;
        }
        return doub;
    }

    public Double strFormatNumberToNumber(String strNumber, Locale loc) {
        NumberFormat nf = NumberFormat.getNumberInstance(loc);
        Double doub = null;
        try {
            Number nNumber = nf.parse(strNumber);
            doub = new Double(nNumber.doubleValue());
        }
        catch (ParseException e) {
            return null;
        }
        return doub;
    }

    public String DateToLongStr(HttpServletRequest request, Date date) {
        Locale locale = request.getLocale();
        return this.DateToLongStr(locale, date);
    }

    public String DateToLongStr(Locale locale, Date date) {
        if (locale.getLanguage().equals("es")) {
            SimpleDateFormat df = new SimpleDateFormat("dd 'de' MMMM 'de' yyyy", new Locale("ES", "es"));
            return df.format(date);
        }
        if (locale.getLanguage().equals("eu")) {
            Calendar calendario = Calendar.getInstance();
            calendario.setTime(date);
            int dia = calendario.get(5);
            int mes = calendario.get(2);
            int anio = calendario.get(1);
            return String.valueOf(anio) + "Ko " + mesesEus[mes] + "ren " + dia;
        }
        SimpleDateFormat df = new SimpleDateFormat();
        return df.format(date);
    }

    public String DateTimeToStr(HttpServletRequest request, Date date) {
        Locale locale = request.getLocale();
        return this.DateTimeToStr(locale, date);
    }

    public String DateTimeToStr(Locale locale, Date date) {
        if (locale.getLanguage().equals("es")) {
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            return df.format(date);
        }
        if (locale.getLanguage().equals("eu")) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            return df.format(date);
        }
        SimpleDateFormat df = new SimpleDateFormat();
        return df.format(date);
    }

    public String booleanToString(boolean b, String str) {
        if (b) {
            return str;
        }
        return "0";
    }

    public boolean StringToboolean(String str, String strTrue) {
        return str.equals(strTrue);
    }
}

