/*
 * Decompiled with CFR 0.152.
 */
package bilbofrmk.util;

import bilbofrmk.context.BConfig;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class BLogger {
    private static Logger loggerw = null;
    private static FileHandler fhw = null;
    private static Logger loggerb = null;
    private static FileHandler fhb = null;
    private static Logger loggerbatch = null;
    private static FileHandler fhbatch = null;
    public static final int OFF = 0;
    public static final int ERROR = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;

    public static void resetLoggers() {
        loggerw = null;
        loggerb = null;
        loggerbatch = null;
    }

    private static void initWLogger() throws IOException {
        if (loggerw == null) {
            loggerw = Logger.getLogger(BConfig.getInstance().getValue("bilbo.WEB_LOGNAME"));
            String strLogPath = BConfig.getInstance().getValue("bilbo.LOG_PATH");
            fhw = new FileHandler(String.valueOf(strLogPath) + "/bilbofrmkWeb.log", 500000, 1, true);
            fhw.setFormatter(new SimpleFormatter());
            loggerw.addHandler(fhw);
            String strLogLevel = BConfig.getInstance().getValue("bilbo.LOG_LEVEL");
            int iLevel = Integer.parseInt(strLogLevel);
            switch (iLevel) {
                case 0: {
                    loggerw.setLevel(Level.OFF);
                    break;
                }
                case 1: {
                    loggerw.setLevel(Level.SEVERE);
                    break;
                }
                case 2: {
                    loggerw.setLevel(Level.INFO);
                    break;
                }
                case 3: {
                    loggerw.setLevel(Level.FINEST);
                }
            }
        }
    }

    private static void initBLogger() throws IOException {
        if (loggerb == null) {
            loggerb = Logger.getLogger(BConfig.getInstance().getValue("bilbo.BACK_LOGNAME"));
            String strLogPath = BConfig.getInstance().getValue("bilbo.LOG_PATH");
            fhb = new FileHandler(String.valueOf(strLogPath) + "/bilbofrmkback.log", 500000, 1, true);
            fhb.setFormatter(new SimpleFormatter());
            loggerb.addHandler(fhb);
            String strLogLevel = BConfig.getInstance().getValue("bilbo.LOG_LEVEL");
            int iLevel = Integer.parseInt(strLogLevel);
            switch (iLevel) {
                case 0: {
                    loggerb.setLevel(Level.OFF);
                    break;
                }
                case 1: {
                    loggerb.setLevel(Level.SEVERE);
                    break;
                }
                case 2: {
                    loggerb.setLevel(Level.INFO);
                    break;
                }
                case 3: {
                    loggerb.setLevel(Level.FINEST);
                }
            }
        }
    }

    private static void initBatchLogger() throws IOException {
        if (loggerbatch == null) {
            loggerbatch = Logger.getLogger(BConfig.getInstance().getValue("bilbo.BATCH_LOGNAME"));
            String strLogPath = BConfig.getInstance().getValue("bilbo.LOG_PATH");
            fhbatch = new FileHandler(String.valueOf(strLogPath) + "/bilbofrmkbatch.log", 500000, 1, true);
            fhbatch.setFormatter(new SimpleFormatter());
            loggerbatch.addHandler(fhbatch);
            String strLogLevel = BConfig.getInstance().getValue("bilbo.LOG_LEVEL");
            int iLevel = Integer.parseInt(strLogLevel);
            switch (iLevel) {
                case 0: {
                    loggerbatch.setLevel(Level.OFF);
                    break;
                }
                case 1: {
                    loggerbatch.setLevel(Level.SEVERE);
                    break;
                }
                case 2: {
                    loggerbatch.setLevel(Level.INFO);
                    break;
                }
                case 3: {
                    loggerbatch.setLevel(Level.FINEST);
                }
            }
        }
    }

    private static Level matchLevel(int i) {
        switch (i) {
            case 1: {
                return Level.SEVERE;
            }
            case 2: {
                return Level.INFO;
            }
            case 3: {
                return Level.FINE;
            }
        }
        return Level.OFF;
    }

    public static void wlog(int level, String msg) {
        try {
            BLogger.initWLogger();
            loggerw.log(BLogger.matchLevel(level), "thId:" + System.identityHashCode(Thread.currentThread()) + " " + msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void wlog(int level, String msg, Object o) {
        try {
            BLogger.initWLogger();
            loggerw.log(BLogger.matchLevel(level), "thId:" + System.identityHashCode(Thread.currentThread()) + " " + msg, o);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void wlog(int level, String msg, Throwable th) {
        try {
            BLogger.initWLogger();
            loggerw.log(BLogger.matchLevel(level), "thId:" + System.identityHashCode(Thread.currentThread()) + " " + msg, th);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void blog(int level, String msg) {
        try {
            BLogger.initBLogger();
            loggerb.log(BLogger.matchLevel(level), "thId:" + System.identityHashCode(Thread.currentThread()) + " " + msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void blog(int level, String msg, Object o) {
        try {
            BLogger.initBLogger();
            loggerb.log(BLogger.matchLevel(level), "thId:" + System.identityHashCode(Thread.currentThread()) + " " + msg, o);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void blog(int level, String msg, Throwable th) {
        try {
            BLogger.initBLogger();
            loggerb.log(BLogger.matchLevel(level), "thId:" + System.identityHashCode(Thread.currentThread()) + " " + msg, th);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void batchlog(int level, String msg) {
        try {
            BLogger.initBatchLogger();
            loggerbatch.log(BLogger.matchLevel(level), "thId:" + System.identityHashCode(Thread.currentThread()) + " " + msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void batchlog(int level, String msg, Object o) {
        try {
            BLogger.initBatchLogger();
            loggerbatch.log(BLogger.matchLevel(level), "thId:" + System.identityHashCode(Thread.currentThread()) + " " + msg, o);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void batchlog(int level, String msg, Throwable th) {
        try {
            BLogger.initBatchLogger();
            loggerbatch.log(BLogger.matchLevel(level), "thId:" + System.identityHashCode(Thread.currentThread()) + " " + msg, th);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

