/*
 * Decompiled with CFR 0.152.
 */
package bilbofrmk.search;

import bilbofrmk.search.BBaseQuery;
import bilbofrmk.search.BIRecord;
import java.util.ArrayList;

public class BBaseSessionPagQuery
extends BBaseQuery {
    private static final long serialVersionUID = 2039808223272286097L;
    protected static final int MAX_PAGE_SIZE = 200;
    protected int pageSize = 200;
    protected int currentPage = 0;
    protected boolean next = false;
    protected boolean prev = false;
    protected int rcdFrom = 0;
    protected int rcdTo = 0;

    public boolean next() {
        if (!this.isNext()) {
            return false;
        }
        ++this.currentPage;
        return true;
    }

    public boolean prev() {
        if (!this.isPrev() || this.currentPage == 0) {
            return false;
        }
        --this.currentPage;
        return true;
    }

    public boolean first() {
        this.currentPage = 0;
        this.prev = false;
        if (this.mResults.size() > this.pageSize) {
            this.next = true;
        }
        return true;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public boolean isNext() {
        this.next = this.currentPage * this.pageSize <= this.mResults.size();
        return this.next;
    }

    public boolean isPrev() {
        this.prev = this.currentPage > 0;
        return this.prev;
    }

    @Override
    public int validate() {
        return 0;
    }

    public int getRcdFrom() {
        return this.rcdFrom;
    }

    public int getRcdTo() {
        return this.rcdTo;
    }

    public int getRcdTotal() {
        return this.mResults.size();
    }

    public ArrayList<BIRecord> getPagedResults() {
        ArrayList<BIRecord> paginaResultados = new ArrayList<BIRecord>();
        int initialPagePosition = this.currentPage * this.pageSize;
        int i = 0;
        i = initialPagePosition;
        while (i < initialPagePosition + this.pageSize) {
            paginaResultados.add((BIRecord)this.mResults.get(i));
            ++i;
        }
        this.rcdFrom = initialPagePosition + 1;
        this.rcdTo = initialPagePosition + i;
        return paginaResultados;
    }
}

