/*
 * Decompiled with CFR 0.152.
 */
package bilbofrmk.reports;

import bilbofrmk.context.BIContext;
import bilbofrmk.exceptions.BReportException;
import bilbofrmk.reports.BBaseReport;
import bilbofrmk.search.BBaseQuery;
import bilbofrmk.search.BIRecord;
import bilbofrmk.util.BLogger;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public abstract class BBaseReportSolver {
    protected static final String xmlCab = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>";
    protected BBaseReport report = null;
    private Locale loc;
    protected BIContext context;

    protected abstract void doXMLReport() throws BReportException;

    public BBaseReport doReport() throws BReportException {
        if (this.report.getReportXML() == null) {
            this.doXMLReport();
        }
        BLogger.blog(3, this.report.getReportXML().toString());
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StreamSource xsltSrc = new StreamSource(this.getClass().getResourceAsStream(String.valueOf(this.report.getXSLPath()) + "/" + this.report.getXSLTemplateFile()));
        try {
            Transformer transformer = transformerFactory.newTransformer(xsltSrc);
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            StreamResult res = new StreamResult(bao);
            StreamSource src = new StreamSource(new StringReader(this.report.getReportXML().toString()));
            transformer.transform(src, res);
            this.report.setTransformedXML(new StringBuffer(bao.toString()));
        }
        catch (TransformerConfigurationException e) {
            throw new BReportException("Error de Tranformacion", e);
        }
        catch (TransformerException e) {
            throw new BReportException("Error de Tranformacion", e);
        }
        return this.report;
    }

    public void setReport(BBaseReport report) {
        this.report = report;
    }

    protected String DateToStr(Date date) {
        Locale loc = this.context.getUserLocale();
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        if (loc.getLanguage().equals("eu")) {
            df = new SimpleDateFormat("yyyy/MM/dd");
        }
        return df.format(date);
    }

    protected String DateToStr(Date date, int i) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        if (i == 2) {
            df = new SimpleDateFormat("yyyy/MM/dd");
        }
        return df.format(date);
    }

    protected String currencyToStr(Double dinero) {
        NumberFormat nf = NumberFormat.getNumberInstance(this.loc);
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        return nf.format(dinero);
    }

    protected String formatNumberToStr(Number n) {
        NumberFormat nf = NumberFormat.getInstance(this.loc);
        return nf.format(n);
    }

    public void setContext(BIContext context) {
        this.context = context;
        this.loc = context.getUserLocale();
    }

    protected String xmlData(String data) {
        if (data != null) {
            return "<![CDATA[" + data + "]]>";
        }
        return "";
    }

    protected StringBuffer getXML(BBaseQuery query, ArrayList<String> columNames) throws BReportException {
        StringBuffer xml = new StringBuffer();
        xml.append("<registros>");
        int i = 0;
        while (i < query.getResults().size()) {
            xml.append("<registro>");
            BIRecord rcd = query.getRecordByPosition(i);
            int j = 0;
            while (j < columNames.size()) {
                String columName = columNames.get(j);
                try {
                    Method m = rcd.getClass().getDeclaredMethod(columName, new Class[0]);
                    String data = (String)m.invoke((Object)rcd, new Object[0]);
                    xml.append("<columna>");
                    xml.append(this.xmlData(data));
                    xml.append("</columna>");
                }
                catch (NoSuchMethodException e) {
                    throw new BReportException("El metodo proporcionado no existe en el record", e);
                }
                catch (SecurityException e) {
                    throw new BReportException("El metodo proporcionado no es publico en el record", e);
                }
                catch (IllegalAccessException e) {
                    throw new BReportException("Se produjo un error invocando el metodo del record", e);
                }
                catch (InvocationTargetException e) {
                    throw new BReportException("Se produjo un error invocando el metodo del record", e);
                }
                ++j;
            }
            xml.append("</registro>");
            ++i;
        }
        xml.append("</registros>");
        return xml;
    }
}

