/*
 * Decompiled with CFR 0.152.
 */
package bilbofrmk.email;

import bilbofrmk.email.BEMailMessage;
import bilbofrmk.exceptions.BEMailSendingException;
import bilbofrmk.valueObjects.BDocumento;
import java.util.ArrayList;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class BEMailSender {
    public void send(BEMailMessage objMsg) throws BEMailSendingException {
        Session session = this.getSession(objMsg);
        MimeMessage message = new MimeMessage(session);
        this.setRecipes(message, objMsg);
        this.setSubject(message, objMsg);
        this.setFrom(message, objMsg);
        MimeMultipart multipart = new MimeMultipart();
        this.setBodyContent((Multipart)multipart, objMsg);
        this.setAttachments((Multipart)multipart, objMsg);
        try {
            message.setContent((Multipart)multipart);
            Transport.send((Message)message);
        }
        catch (SendFailedException e) {
            Address[] recipes = e.getInvalidAddresses();
            this.removeRecipesFromMessage(message, recipes);
            try {
                Transport.send((Message)message);
            }
            catch (MessagingException e1) {
                throw new BEMailSendingException("Fallo el envio de email. Error escribiendo los contenidos o enviando", e1);
            }
        }
        catch (MessagingException e) {
            throw new BEMailSendingException("Fallo el envio de email. Error escribiendo los contenidos o enviando", e);
        }
    }

    private void setAttachments(Multipart multipart, BEMailMessage objMsg) throws BEMailSendingException {
        try {
            int i = 0;
            while (i < objMsg.getAttachments().size()) {
                BDocumento documento = objMsg.getAttachments().get(i);
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                FileDataSource source = new FileDataSource(documento.getFilePath());
                messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                messageBodyPart.setFileName(documento.getFileName());
                multipart.addBodyPart((BodyPart)messageBodyPart);
                ++i;
            }
        }
        catch (MessagingException e) {
            throw new BEMailSendingException("Fallo el envio de email. Error escribiendo el contenido del attachment", e);
        }
    }

    private void setBodyContent(Multipart multipart, BEMailMessage objMsg) throws BEMailSendingException {
        try {
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)objMsg.getMsgBodyText(), "text/html; charset=iso-8859-1");
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        catch (MessagingException e) {
            throw new BEMailSendingException("Fallo el envio de email. Error escribiendo el contenido del body", e);
        }
    }

    private void setFrom(MimeMessage message, BEMailMessage objMsg) throws BEMailSendingException {
        try {
            if (objMsg.getFrom() != null) {
                message.setFrom((Address)new InternetAddress(objMsg.getFrom()));
            }
        }
        catch (AddressException e) {
            throw new BEMailSendingException("Fallo el envio de email. Direcci\u00f3n del From es erronea", e);
        }
        catch (MessagingException e) {
            throw new BEMailSendingException("Fallo el envio de email. Direcci\u00f3n del From es erronea", e);
        }
    }

    private void setSubject(MimeMessage message, BEMailMessage objMsg) throws BEMailSendingException {
        try {
            if (objMsg.getSubject() != null) {
                message.setSubject(objMsg.getSubject());
            } else {
                message.setSubject("");
            }
        }
        catch (MessagingException e) {
            throw new BEMailSendingException("Fallo el envio de email. Subject incorrectp", e);
        }
    }

    private void setRecipes(MimeMessage message, BEMailMessage objMsg) throws BEMailSendingException {
        try {
            InternetAddress address;
            int i = 0;
            while (i < objMsg.getTo().size()) {
                address = new InternetAddress(objMsg.getTo().get(i));
                message.addRecipient(Message.RecipientType.TO, (Address)address);
                ++i;
            }
            i = 0;
            while (i < objMsg.getCC().size()) {
                address = new InternetAddress(objMsg.getCC().get(i));
                message.addRecipient(Message.RecipientType.CC, (Address)address);
                ++i;
            }
            i = 0;
            while (i < objMsg.getBCC().size()) {
                address = new InternetAddress(objMsg.getBCC().get(i));
                message.addRecipient(Message.RecipientType.BCC, (Address)address);
                ++i;
            }
        }
        catch (AddressException e) {
            throw new BEMailSendingException("Fallo el envio de email. Direcci\u00f3n es erronea", e);
        }
        catch (MessagingException e) {
            throw new BEMailSendingException("Fallo el envio de email. Direcci\u00f3n es erronea", e);
        }
    }

    private Session getSession(BEMailMessage objMsg) {
        Properties props = new Properties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.host", objMsg.getEmailServer());
        if (objMsg.getNotDeliveryAddress() != null && objMsg.getNotDeliveryAddress().length() > 0) {
            props.put("mail.smtp.from", objMsg.getNotDeliveryAddress());
        }
        Session session = Session.getInstance((Properties)props);
        return session;
    }

    private void removeRecipesFromMessage(MimeMessage message, Address[] recipients) throws BEMailSendingException {
        try {
            int i;
            ArrayList<Address> to = new ArrayList<Address>();
            Address[] arto = message.getRecipients(Message.RecipientType.TO);
            if (arto != null) {
                int i2 = 0;
                while (i2 < arto.length) {
                    to.add(arto[i2]);
                    ++i2;
                }
            }
            ArrayList<Address> cc = new ArrayList<Address>();
            Address[] arcc = message.getRecipients(Message.RecipientType.CC);
            if (arcc != null) {
                int i3 = 0;
                while (i3 < arcc.length) {
                    cc.add(arcc[i3]);
                    ++i3;
                }
            }
            ArrayList<Address> bcc = new ArrayList<Address>();
            Address[] arbcc = message.getRecipients(Message.RecipientType.BCC);
            if (arbcc != null) {
                i = 0;
                while (i < arbcc.length) {
                    bcc.add(arbcc[i]);
                    ++i;
                }
            }
            i = 0;
            while (i < recipients.length) {
                Address recipient = recipients[i];
                if (to.contains(recipient)) {
                    to.remove(recipient);
                } else if (cc.contains(recipient)) {
                    cc.remove(recipient);
                } else if (bcc.contains(recipient)) {
                    bcc.remove(recipient);
                }
                ++i;
            }
            arbcc = null;
            arto = null;
            arcc = null;
            if (to.size() > 0) {
                arto = new Address[to.size()];
                i = 0;
                while (i < to.size()) {
                    arto[i] = (Address)to.get(i);
                    ++i;
                }
            }
            if (cc.size() > 0) {
                arcc = new Address[cc.size()];
                i = 0;
                while (i < cc.size()) {
                    arcc[i] = (Address)cc.get(i);
                    ++i;
                }
            }
            if (bcc.size() > 0) {
                arbcc = new Address[bcc.size()];
                i = 0;
                while (i < bcc.size()) {
                    arbcc[i] = (Address)bcc.get(i);
                    ++i;
                }
            }
            message.setRecipients(Message.RecipientType.TO, arto);
            message.setRecipients(Message.RecipientType.CC, arcc);
            message.setRecipients(Message.RecipientType.BCC, arbcc);
        }
        catch (MessagingException e) {
            throw new BEMailSendingException("Fallo el envio de email. Direcci\u00f3n es erronea", e);
        }
    }
}

