/*
 * Decompiled with CFR 0.152.
 */
package bilbofrmk.context;

import bilbofrmk.context.BIContext;
import bilbofrmk.context.BIlookupBConnection;
import bilbofrmk.util.BServiceLocator;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class BContext
implements BIContext,
BIlookupBConnection {
    static final long serialVersionUID = -1295393196063227065L;
    private String wlInitialContextFactory = null;
    private String urlContextProvider = null;
    private String dataSourceName = null;
    private String userLogin = null;
    private Locale userLocale = null;
    private transient BServiceLocator mServiceLocator = null;
    private boolean contextoBD;
    private BIlookupBConnection lookupBConnectionObject = this;

    @Override
    public void initBContext() throws NamingException {
        this.mServiceLocator = new BServiceLocator(this.getWlInitialContextFactory(), this.getUrlContextProvider());
    }

    @Override
    public void bind(String jndi, Object obj) throws NamingException {
        this.mServiceLocator.bind(jndi, obj);
    }

    @Override
    public QueueConnectionFactory lookupQueueConnectionFactory(String name) throws NamingException {
        return this.mServiceLocator.lookupQCFactory(name);
    }

    @Override
    public Queue lookupQueue(String name) throws NamingException {
        return this.mServiceLocator.lookupQueue(name);
    }

    @Override
    public EJBLocalHome lookupLocalHome(String name, Class homeClass) throws NamingException, ClassCastException {
        String JNDIName = "java:comp/env/" + name;
        return this.mServiceLocator.lookupLocalHome(JNDIName, homeClass);
    }

    @Override
    public EJBHome lookupHome(String name, Class homeClass) throws NamingException, ClassCastException {
        String JNDIName = "java:comp/env/" + name;
        return this.mServiceLocator.lookupHome(JNDIName, homeClass);
    }

    @Override
    public EJBHome lookupInternalHome(String name, Class homeClass) throws NamingException, ClassCastException {
        String JNDIName = name;
        return this.mServiceLocator.lookupHome(JNDIName, homeClass);
    }

    @Override
    public Connection lookupBConnection() throws NamingException, SQLException {
        String JNDIName = this.getDataSourceName();
        return this.lookupBConnectionObject.lookupBConnection(JNDIName);
    }

    @Override
    public Connection lookupBConnection(String dataSourceName) throws NamingException, SQLException {
        DataSource ds = this.mServiceLocator.lookupDataSource(dataSourceName);
        Connection con = ds.getConnection();
        return con;
    }

    public void setDBContext() throws NamingException, SQLException {
        if (this.isContextoBD()) {
            Connection con = this.lookupBConnection();
            CallableStatement cstm = con.prepareCall("begin dbms_session.set_identifier(?); end;");
            cstm.setString(1, this.getUserLogin());
            cstm.execute();
            cstm.close();
            con.close();
        }
    }

    public void releaseDBContext() throws NamingException, SQLException {
        if (this.isContextoBD()) {
            Connection con = this.lookupBConnection();
            CallableStatement cstm = con.prepareCall("begin dbms_session.set_identifier(null); end;");
            cstm.execute();
            cstm.close();
            con.close();
        }
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getUrlContextProvider() {
        return this.urlContextProvider;
    }

    public void setUrlContextProvider(String urlContextProvider) {
        this.urlContextProvider = urlContextProvider;
    }

    @Override
    public Locale getUserLocale() {
        return this.userLocale;
    }

    public void setUserLocale(Locale userLocale) {
        this.userLocale = userLocale;
    }

    public String getWlInitialContextFactory() {
        return this.wlInitialContextFactory;
    }

    public void setWlInitialContextFactory(String wlInitialContextFactory) {
        this.wlInitialContextFactory = wlInitialContextFactory;
    }

    @Override
    public String getUserLogin() {
        return this.userLogin;
    }

    public void setUserLogin(String userLogin) {
        this.userLogin = userLogin;
    }

    public boolean isContextoBD() {
        return this.contextoBD;
    }

    public void setContextoBD(boolean contextoBD) {
        this.contextoBD = contextoBD;
    }

    public void setLookupBConnectionObject(BIlookupBConnection lookupBConnectionObject) {
        this.lookupBConnectionObject = lookupBConnectionObject;
    }
}

