/*
 * Decompiled with CFR 0.152.
 */
package bilbofrmk.context;

import bilbofrmk.context.IBConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class BConfig
implements IBConfig {
    private Properties mProp;
    private static final String PROPFILENAME = "/bilbofrmk/bconfig.properties";
    private static BConfig mInstance = null;
    public static final String LOG_LEVEL = "bilbo.LOG_LEVEL";
    public static final String LOG_PATH = "bilbo.LOG_PATH";
    public static final String WORK_PATH = "bilbo.WORK_PATH";
    public static final String XSL_PATH = "bilbo.XSL_PATH";
    public static final String BATCH_LOGNAME = "bilbo.BATCH_LOGNAME";
    public static final String BACK_LOGNAME = "bilbo.BACK_LOGNAME";
    public static final String WEB_LOGNAME = "bilbo.WEB_LOGNAME";
    public static final String APP_CONFIGCLASS = "app.CONFIGCLASS";
    public static final String TRANSACTION_TIMEOUT = "bilbo.TRANSACTION_TIMEOUT_SECONDS";
    private IBConfig appConfig;

    private BConfig() throws IOException {
        InputStream in = this.getClass().getResourceAsStream(PROPFILENAME);
        if (in == null) {
            throw new IOException("No se encontro el recurso/bilbofrmk/bconfig.properties");
        }
        this.mProp = new Properties();
        this.mProp.load(in);
        in.close();
        String appClassName = this.getValue(APP_CONFIGCLASS);
        try {
            this.appConfig = (IBConfig)Class.forName(appClassName).newInstance();
        }
        catch (InstantiationException e) {
            this.appConfig = null;
        }
        catch (IllegalAccessException e) {
            this.appConfig = null;
        }
        catch (ClassNotFoundException e) {
            this.appConfig = null;
        }
    }

    @Override
    public String getValue(String param) {
        if (this.mProp.getProperty(param) != null) {
            return this.mProp.getProperty(param);
        }
        if (this.appConfig != null) {
            return this.appConfig.getValue(param);
        }
        return null;
    }

    public static BConfig getInstance() throws IOException {
        if (mInstance == null) {
            mInstance = new BConfig();
        }
        return mInstance;
    }

    public static void reRead() throws IOException {
        mInstance = new BConfig();
    }
}

