/*
 * Decompiled with CFR 0.152.
 */
package bilbofrmk.FacadeEJB;

import bilbofrmk.FacadeEJB.BFActionsFactory;
import bilbofrmk.FacadeEJB.BFBaseAction;
import bilbofrmk.FacadeEJB.BFBaseMultiTransactionalAction;
import bilbofrmk.FacadeEJB.BFacade;
import bilbofrmk.context.BConfig;
import bilbofrmk.context.BContext;
import bilbofrmk.exceptions.BFActionException;
import bilbofrmk.trasport.BBussinessPack;
import bilbofrmk.trasport.BTransport;
import bilbofrmk.util.BLogger;
import java.io.IOException;
import java.sql.SQLException;
import javax.annotation.Resource;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class BFacadeBean
implements BFacade {
    @Resource
    private SessionContext ctx;

    @Override
    public BBussinessPack executeAction(BContext context, BBussinessPack pack) throws BFActionException {
        String operationName = "";
        UserTransaction uts = null;
        try {
            int transactionTimeOutSeconds = Integer.parseInt(BConfig.getInstance().getValue("bilbo.TRANSACTION_TIMEOUT_SECONDS"));
            boolean areErrors = false;
            BBussinessPack returnPack = new BBussinessPack();
            BContext mSessionContext = context;
            mSessionContext.initBContext();
            this.DBContext(mSessionContext, 1);
            int i = 0;
            while (i < pack.getPackSize()) {
                uts = this.ctx.getUserTransaction();
                uts.setTransactionTimeout(transactionTimeOutSeconds);
                BTransport transport = pack.getTransport(i);
                operationName = transport.getIdBackAction();
                BFBaseAction action = BFActionsFactory.getFAction(transport.getIdBackAction());
                if (!(action instanceof BFBaseMultiTransactionalAction)) {
                    uts.begin();
                } else {
                    BFBaseMultiTransactionalAction mAction = (BFBaseMultiTransactionalAction)action;
                    mAction.setUts(uts);
                }
                BTransport backTransport = action.doBaseExecute(mSessionContext, transport);
                backTransport.setIdTransport(transport.getIdTransport());
                returnPack.addTransport(backTransport);
                if (backTransport.areErrors()) {
                    areErrors = true;
                    break;
                }
                if (!(action instanceof BFBaseMultiTransactionalAction)) {
                    uts.commit();
                }
                ++i;
            }
            this.DBContext(mSessionContext, 0);
            if (areErrors) {
                try {
                    uts.rollback();
                    BLogger.blog(1, "S41 --> Transaction Rolled Back. Bussiness Errors in Bussiness Operation: " + operationName);
                }
                catch (SecurityException eo) {
                    throw new BFActionException("executeAction", "<B Error in transaction control>", eo);
                }
                catch (IllegalStateException o) {
                    throw new BFActionException("executeAction", "<B Error in transaction control>", o);
                }
            }
            return returnPack;
        }
        catch (BFActionException th) {
            try {
                uts.rollback();
                BLogger.blog(1, "S41 --> Transaction Rolled Back. Exception in Bussiness Operation: " + operationName);
            }
            catch (SecurityException i) {
                throw new BFActionException("executeAction", "<B Error in transaction control>", i);
            }
            catch (IllegalStateException o) {
                throw new BFActionException("executeAction", "<B Error in transaction control>", o);
            }
            catch (SystemException s) {
                throw new BFActionException("executeAction", "<B Error in transaction control>", s);
            }
            throw th;
        }
        catch (NamingException e) {
            throw new BFActionException("executeAction", "<B Error in config parameters initial context factoy or url context provider>", e);
        }
        catch (SecurityException i) {
            throw new BFActionException("executeAction", "<B Error in transaction control>", i);
        }
        catch (IllegalStateException o) {
            throw new BFActionException("executeAction", "<B Error in transaction control>", o);
        }
        catch (SystemException s) {
            throw new BFActionException("executeAction", "<B Error in transaction control>", s);
        }
        catch (RollbackException r) {
            throw new BFActionException("executeAction", "<B Error in transaction control>", r);
        }
        catch (NotSupportedException n) {
            throw new BFActionException("executeAction", "<B Error in transaction control>", n);
        }
        catch (HeuristicRollbackException h) {
            throw new BFActionException("executeAction", "<B Error in transaction control>", h);
        }
        catch (HeuristicMixedException hm) {
            throw new BFActionException("executeAction", "<B Error in transaction control>", hm);
        }
        catch (IOException e) {
            throw new BFActionException("executeAction", "<B Error in transaction configuration reading>", e);
        }
    }

    private void DBContext(BContext mSessionContext, int i) throws BFActionException {
        try {
            if (i == 1) {
                mSessionContext.setDBContext();
            }
            if (i == 0) {
                mSessionContext.releaseDBContext();
            }
        }
        catch (NamingException e) {
            throw new BFActionException("BFacadeBean", "Error de localizaci\u00f3n del DataSource", e);
        }
        catch (SQLException e) {
            throw new BFActionException("BFacadeBean", "Error fijando o eliminando el contexto de usuario de Oracle", e);
        }
    }
}

