/*
 * Decompiled with CFR 0.152.
 */
package bilbofrmk.FacadeEJB;

import bilbofrmk.FacadeEJB.BFBaseAction;
import bilbofrmk.context.BConfig;
import bilbofrmk.exceptions.BFActionException;
import java.io.IOException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public abstract class BFBaseMultiTransactionalAction
extends BFBaseAction {
    private UserTransaction uts;

    protected void openTransaction() throws BFActionException {
        try {
            int transactionTimeOutSeconds = Integer.parseInt(BConfig.getInstance().getValue("bilbo.TRANSACTION_TIMEOUT_SECONDS"));
            this.uts.setTransactionTimeout(transactionTimeOutSeconds);
            this.uts.begin();
        }
        catch (NotSupportedException n) {
            throw new BFActionException("executeAction", "<B Error in transaction control>", n);
        }
        catch (SystemException s) {
            throw new BFActionException("executeAction", "<B Error in transaction control>", s);
        }
        catch (IOException e) {
            throw new BFActionException("executeAction", "<B Error in transaction configuration reading>", e);
        }
    }

    protected void commitTransaction() throws BFActionException {
        try {
            this.uts.commit();
        }
        catch (SystemException s) {
            throw new BFActionException("executeAction", "<B Error in transaction control>", s);
        }
        catch (RollbackException r) {
            throw new BFActionException("executeAction", "<B Error in transaction control>", r);
        }
        catch (HeuristicRollbackException h) {
            throw new BFActionException("executeAction", "<B Error in transaction control>", h);
        }
        catch (HeuristicMixedException hm) {
            throw new BFActionException("executeAction", "<B Error in transaction control>", hm);
        }
    }

    public void setUts(UserTransaction uts) {
        this.uts = uts;
    }
}

