/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.logic;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.action.ActionForward;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;

public class ForwardTag
extends TagSupport {
    protected static MessageResources messages = MessageResources.getMessageResources("org.apache.struts.taglib.logic.LocalStrings");
    protected String name = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int doStartTag() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        ForwardConfig forward = null;
        ModuleConfig config = RequestUtils.getModuleConfig(this.pageContext);
        if (config != null) {
            forward = (ActionForward)config.findForwardConfig(this.name);
        }
        if (forward == null) {
            JspException e = new JspException(messages.getMessage("forward.lookup", (Object)this.name));
            RequestUtils.saveException(this.pageContext, e);
            throw e;
        }
        String path = forward.getPath();
        path = config.getPrefix() + path;
        if (forward.getRedirect()) {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
            try {
                if (path.startsWith("/")) {
                    path = request.getContextPath() + path;
                }
                response.sendRedirect(response.encodeRedirectURL(path));
            }
            catch (Exception e) {
                RequestUtils.saveException(this.pageContext, e);
                throw new JspException(messages.getMessage("forward.redirect", (Object)this.name, (Object)e.toString()));
            }
        }
        try {
            this.pageContext.forward(path);
        }
        catch (Exception e) {
            RequestUtils.saveException(this.pageContext, e);
            throw new JspException(messages.getMessage("forward.forward", (Object)this.name, (Object)e.toString()));
        }
        return 5;
    }

    public void release() {
        super.release();
        this.name = null;
    }
}

