package aa14f.server.rest.resources.delegates;

import java.net.URI;

import javax.ws.rs.core.Response;

import aa14f.api.interfaces.AA14FindServicesForOrganizationalEntityBase;
import aa14f.model.oids.AA14IDs.AA14ModelObjectID;
import aa14f.model.oids.AA14OIDs.AA14ModelObjectOID;
import r01f.locale.Language;
import r01f.model.PersistableModelObject;
import r01f.model.persistence.FindResult;
import r01f.rest.RESTOperationsResponseBuilder;
import r01f.securitycontext.SecurityContext;

public class AA14RESTFindDelegateBaseForOrganizationalEntity<O extends AA14ModelObjectOID,ID extends AA14ModelObjectID<O>,
															 M extends PersistableModelObject<O>>
	 extends AA14RESTFindDelegateBaseForEntity<O,ID,M> {
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14RESTFindDelegateBaseForOrganizationalEntity(final Class<M> modelObjectType,
														   final AA14FindServicesForOrganizationalEntityBase<O,ID,M> findServices) {
		super(modelObjectType,
			  findServices);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//	EXTENSION METHODS
/////////////////////////////////////////////////////////////////////////////////////////
	@SuppressWarnings("unchecked")
	public Response findByNameIn(final SecurityContext securityContext,final String resourcePath,
								 final Language lang,final String name) {
		FindResult<M> findResult = this.getFindServicesAs(AA14FindServicesForOrganizationalEntityBase.class)
												.findByNameIn(securityContext,
															  lang,name);
		return RESTOperationsResponseBuilder.findOn(_modelObjectType)
											.at(URI.create(resourcePath))
											.build(findResult);
	}
}
