package aa14f.server.rest.resources.delegates;

import java.net.URI;

import javax.ws.rs.core.Response;

import aa14f.api.context.AA14SecurityContext;
import aa14f.api.interfaces.AA14CRUDServicesBase;
import aa14f.model.oids.AA14IDs.AA14ModelObjectID;
import aa14f.model.oids.AA14OIDs.AA14ModelObjectOID;
import r01f.model.PersistableModelObject;
import r01f.model.persistence.CRUDResult;
import r01f.model.persistence.PersistenceException;
import r01f.rest.RESTOperationsResponseBuilder;
import r01f.rest.resources.delegates.RESTCRUDDelegateBase;

public abstract class AA14RESTCRUDDelegateBaseForEntity<O extends AA14ModelObjectOID,ID extends AA14ModelObjectID<O>,M extends PersistableModelObject<O>>
	          extends RESTCRUDDelegateBase<O,M> {
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14RESTCRUDDelegateBaseForEntity(final Class<M> modelObjectType,
											 final AA14CRUDServicesBase<O,ID,M> crudServices) {
		super(modelObjectType,
			  crudServices);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////
	@SuppressWarnings("unchecked")
	public Response loadById(final AA14SecurityContext userContext,final String resourcePath,
						 	 final ID id) throws PersistenceException {
		CRUDResult<M> loadResult = this.getCRUDServicesAs(AA14CRUDServicesBase.class)
												.loadById(userContext,
						  					     	 	  id);
		Response outResponse = RESTOperationsResponseBuilder.crudOn(_modelObjectType)
														    .at(URI.create(resourcePath))
															.build(loadResult);
		return outResponse;
	}
}
