package aa14f.server.rest.resources;

import java.util.Collection;

import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import aa14f.api.context.AA14SecurityContext;
import r01f.model.search.SearchFilter;
import r01f.model.search.SearchResultItem;
import r01f.model.search.query.SearchResultsOrdering;
import r01f.rest.RESTResourceBase;
import r01f.rest.resources.delegates.RESTSearchDelegateBase;

/**
 * This base type MUST be public... otherwise jersey throws a null exception WTF!
 * @param <O>
 * @param <M>
 * @param <F>
 * @param <I>
 */
public abstract class AA14RESTResourceForSearchBase<F extends SearchFilter,I extends SearchResultItem>
			  extends RESTResourceBase {
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public <SD extends RESTSearchDelegateBase<F,I>>
		   AA14RESTResourceForSearchBase(final SD searchDelegate) {
		super(searchDelegate);	// do not use the base delegate field
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  SEARCH
/////////////////////////////////////////////////////////////////////////////////////////
	@GET 
	@Produces(MediaType.APPLICATION_XML)
	@SuppressWarnings("unchecked")
	public Response search(@HeaderParam("userContext") final AA14SecurityContext userContext,
						   @QueryParam("filter")	   final F filter,
						   @QueryParam("order")		   final Collection<SearchResultsOrdering> ordering,
						   @QueryParam("start")	   	   final int startingRow,
						   @QueryParam("items")		   final int itemsToReturn) {
		return this.getDelegateAs(RESTSearchDelegateBase.class)
						.search(userContext,_req.getPathInfo(),
					   		  	filter,ordering,
					   		  	startingRow,itemsToReturn);
	}

}
