package aa14f.server.rest.resources;

import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import aa14f.api.context.AA14SecurityContext;
import aa14f.model.oids.AA14IDs.AA14ModelObjectID;
import aa14f.model.oids.AA14OIDs.AA14ModelObjectOID;
import aa14f.server.rest.resources.delegates.AA14RESTFindDelegateBaseForOrganizationalEntity;
import lombok.experimental.Accessors;
import r01f.locale.Language;
import r01f.model.PersistableModelObject;
import r01f.model.persistence.PersistenceException;
import r01f.rest.resources.delegates.RESTDelegate;

/**
 * The implementation must follow the HTTP 1.1 spec (http://www.w3.org/Protocols/rfc2616/rfc2616.html), specifically
 * the section about the methods (GET, PUT, POST, DELETE...)
 *
 * Log: see web.xml
 */
@Accessors(prefix="_")
public class AA14RESTFindResourceBaseForOrganizationalEntity<O extends AA14ModelObjectOID,ID extends AA14ModelObjectID<O>,
									  						 M extends PersistableModelObject<O>>
	 extends AA14RESTFindResourceBaseForEntity<O,ID,M> {
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14RESTFindResourceBaseForOrganizationalEntity(final RESTDelegate persistenceDelegate) {
		super(persistenceDelegate);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	@GET @Path("byName")	
	@Produces(MediaType.APPLICATION_XML)
	public Response findByNameIn(@HeaderParam("userContext")	final AA14SecurityContext userContext,
							 	 @QueryParam("lang")			final Language lang,
							 	 @QueryParam("name")			final String name) throws PersistenceException {
		return this.getDelegateAs(AA14RESTFindDelegateBaseForOrganizationalEntity.class)
						.findByNameIn(userContext,_req.getPathInfo(),
									  lang,
									  name);
	}
}
