package aa14f.server.rest.resources;

import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import aa14f.api.context.AA14SecurityContext;
import aa14f.model.oids.AA14IDs.AA14ModelObjectID;
import aa14f.model.oids.AA14OIDs.AA14ModelObjectOID;
import r01f.guids.CommonOIDs.UserCode;
import r01f.model.PersistableModelObject;
import r01f.rest.RESTResourceBase;
import r01f.rest.resources.delegates.RESTDelegate;
import r01f.rest.resources.delegates.RESTFindDelegateBase;
import r01f.util.types.Ranges.DateRange;

/**
 * This base type MUST be public... otherwise jersey throws a null exception WTF!
 * @param <O>
 * @param <ID>
 * @param <M>
 */
public abstract class AA14RESTFindResourceBaseForEntity<O extends AA14ModelObjectOID,ID extends AA14ModelObjectID<O>,
												  		M extends PersistableModelObject<O>>
		      extends RESTResourceBase {
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14RESTFindResourceBaseForEntity(final RESTDelegate persistenceDelegate) {
		super(persistenceDelegate);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  FIND
/////////////////////////////////////////////////////////////////////////////////////////
	@GET 
	@Produces(MediaType.APPLICATION_XML)
	public Response findAll(@HeaderParam("userContext") 	final AA14SecurityContext userContext) {
		return this.getDelegateAs(RESTFindDelegateBase.class)
						.findAll(userContext,_req.getPathInfo());
	}
	@GET @Path("byCreateDate/{dateRange}") 
	@Produces(MediaType.APPLICATION_XML)
	@SuppressWarnings("unchecked")
	public Response findByCreateDate(@HeaderParam("userContext") 	final AA14SecurityContext userContext,
									 @PathParam("dateRange")		final DateRange createDate) {
		return this.getDelegateAs(RESTFindDelegateBase.class)
						.findByCreateDate(userContext,_req.getPathInfo(),
										  createDate.getRange());
	}
	@GET @Path("byLastUpdateDate/{dateRange}") 
	@Produces(MediaType.APPLICATION_XML)
	@SuppressWarnings("unchecked")
	public Response findByLastUpdateDate(@HeaderParam("userContext") 	final AA14SecurityContext userContext,
										 @PathParam("dateRange")  		final DateRange lastUpdateDate) {
		return this.getDelegateAs(RESTFindDelegateBase.class)
						.findByLastUpdateDate(userContext,_req.getPathInfo(),
										  	  lastUpdateDate.getRange());
	}
	@GET @Path("byCreator/{userCode}")
	@Produces(MediaType.APPLICATION_XML)
	public Response findByCreator(@HeaderParam("userContext") 	final AA14SecurityContext userContext,
								  @PathParam("userCode")		final UserCode creatorUserCode) {
		return this.getDelegateAs(RESTFindDelegateBase.class)
						.findByCreator(userContext,_req.getPathInfo(),
									   creatorUserCode);
	}
	@GET @Path("byLastUpdator/{userCode}") 
	@Produces(MediaType.APPLICATION_XML)
	public Response findByLastUpdator(@HeaderParam("userContext") 	final AA14SecurityContext userContext,
									  @PathParam("userCode")		final UserCode lastUpdatorUserCode) {
		return this.getDelegateAs(RESTFindDelegateBase.class)
						.findByLastUpdator(userContext,_req.getPathInfo(),
									   	   lastUpdatorUserCode);
	}
}
