package aa14f.server.rest.resources;


import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import aa14f.api.context.AA14SecurityContext;
import aa14f.model.oids.AA14IDs.AA14ModelObjectID;
import aa14f.model.oids.AA14OIDs.AA14ModelObjectOID;
import aa14f.server.rest.resources.delegates.AA14RESTCRUDDelegateBaseForEntity;
import r01f.model.PersistableModelObject;
import r01f.model.persistence.PersistenceException;
import r01f.rest.RESTResourceBase;
import r01f.rest.resources.delegates.RESTCRUDDelegateBase;
import r01f.rest.resources.delegates.RESTDelegate;

/**
 * This base type MUST be public... otherwise jersey throws a null exception WTF!
 * @param <O>
 * @param <M>
 */
public abstract class AA14RESTCRUDResourceBaseForEntity<O extends AA14ModelObjectOID,ID extends AA14ModelObjectID<O>,
												  		M extends PersistableModelObject<O>>
		      extends RESTResourceBase {
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14RESTCRUDResourceBaseForEntity(final RESTDelegate crudDelegate) {
		super(crudDelegate);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  CRUD
/////////////////////////////////////////////////////////////////////////////////////////	
	@GET @Path("{oid: .+}") 
	@Produces(MediaType.APPLICATION_XML)
	@SuppressWarnings("unchecked")
	public Response load(@HeaderParam("userContext")	final AA14SecurityContext userContext,
						 @PathParam("oid")  			final O oid) throws PersistenceException {
		return this.getDelegateAs(RESTCRUDDelegateBase.class)
						.load(userContext,_req.getPathInfo(),
					 		  oid);
	}
	@POST 
	@Produces(MediaType.APPLICATION_XML)
	@SuppressWarnings({ "unchecked","unused" })
	public Response create(@HeaderParam("userContext")   final AA14SecurityContext userContext,
						   @PathParam("oid") 	 		 final O requestOid,
								 		 	 			 final M modelObj) throws PersistenceException {
		return this.getDelegateAs(RESTCRUDDelegateBase.class)
						.create(userContext,_req.getPathInfo(),
					 	  		modelObj);
	}
	@PUT @Path("{oid: .+}") 
	@Produces(MediaType.APPLICATION_XML)
	@SuppressWarnings({ "unchecked","unused" })
	public Response update(@HeaderParam("userContext") 	 final AA14SecurityContext userContext,
						   @PathParam("oid") 	 		 final O oid,
							 	 		 	 			 final M modelObj) throws PersistenceException {
		return this.getDelegateAs(RESTCRUDDelegateBase.class)
						.update(userContext,_req.getPathInfo(),
					 	  		modelObj);
	}
	@DELETE @Path("{oid: .+}")
	@Produces(MediaType.APPLICATION_XML)
	@SuppressWarnings("unchecked")
	public Response delete(@HeaderParam("userContext") 	final AA14SecurityContext userContext,
						   @PathParam("oid") 			final O oid) throws PersistenceException {
		return this.getDelegateAs(RESTCRUDDelegateBase.class)
						.delete(userContext,_req.getPathInfo(),
					   		    oid);
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  CRUD EXTENSIONS
/////////////////////////////////////////////////////////////////////////////////////////	
	@GET @Path("byId/{id: .+}")
	@Produces(MediaType.APPLICATION_XML)
	@SuppressWarnings("unchecked")
	public Response loadById(@HeaderParam("userContext")	final AA14SecurityContext userContext,
						 	 @PathParam("id")  				final ID id) throws PersistenceException {
		Response outResponse = this.getDelegateAs(AA14RESTCRUDDelegateBaseForEntity.class)
										.loadById(userContext,_req.getPathInfo(),
												  id);
		return outResponse;
	}
}
