package aa14f.server.rest;

import javax.inject.Inject;
import javax.ws.rs.ext.Provider;

import r01f.guids.OID;
import r01f.model.ModelObject;
import r01f.model.annotations.ModelObjectsMarshaller;
import r01f.objectstreamer.Marshaller;
import r01f.rest.RESTRequestTypeMappersForBasicTypes.DateRangeRequestTypeMapperBase;
import r01f.rest.RESTRequestTypeMappersForModelObjects.EnqueuedJobRequestTypeMapperBase;
import r01f.rest.RESTRequestTypeMappersForModelObjects.IndexManagementCommandRequestTypeMapperBase;
import r01f.rest.RESTRequestTypeMappersForModelObjects.ModelObjectRequestTypeMapperBase;
import r01f.rest.RESTRequestTypeMappersForModelObjects.OIDRequestTypeMapperBase;

/**
 * Type mappers for user types
 */
public class AA14RESTRequestTypeMappers {

/////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////
	@Provider
	public static class AA14ModelObjectRequestTypeMapper 
		  	    extends ModelObjectRequestTypeMapperBase<ModelObject> {
		@Inject
		public AA14ModelObjectRequestTypeMapper(@ModelObjectsMarshaller final Marshaller marshaller) {
			super(marshaller);
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////
//	
/////////////////////////////////////////////////////////////////////////////////////////
	@Provider
	public static class AA14OIDRequestTypeMapper 
		  	    extends OIDRequestTypeMapperBase<OID> {
		@Inject
		public AA14OIDRequestTypeMapper(@ModelObjectsMarshaller final Marshaller marshaller) {
			super(marshaller);
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////////////////////////////
	@Provider
	public static class AA14IndexManagementCommandRequestTypeMapper 
		  	    extends IndexManagementCommandRequestTypeMapperBase {
		@Inject
		public AA14IndexManagementCommandRequestTypeMapper(@ModelObjectsMarshaller final Marshaller marshaller) {
			super(marshaller);
		}
	}
	@Provider
	public static class AA14EnqueuedJobRequestTypeMapper 
		  	    extends EnqueuedJobRequestTypeMapperBase {
		@Inject
		public AA14EnqueuedJobRequestTypeMapper(@ModelObjectsMarshaller final Marshaller marshaller) {
			super(marshaller);
		}
	}
/////////////////////////////////////////////////////////////////////////////////////////
//	Ranges
// 	Jersey only scans at the locations defined under web.xml com.sun.jersey.config.property.packages
//  <init-param>
/////////////////////////////////////////////////////////////////////////////////////////
	@Provider
	public static class DateRangeRequestTypeMapper
	  		    extends DateRangeRequestTypeMapperBase {
		/* just extends */
	}
}
