package aa14f.model.summaries;

import aa14f.model.AA14Appointment;
import aa14f.model.AA14AppointmentSubject;
import aa14f.model.AA14BookedSlotType;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import r01f.objectstreamer.annotations.MarshallField;
import r01f.objectstreamer.annotations.MarshallField.MarshallFieldAsXml;
import r01f.objectstreamer.annotations.MarshallType;
import r01f.types.contact.NIFPersonID;
import r01f.types.contact.Person;

@MarshallType(as="summarizedAppointment")
@Accessors(prefix="_")
public class AA14SummarizedAppointment 
	 extends AA14SummarizedBookedSlotBase<AA14Appointment,
	 									  AA14SummarizedAppointment> {

	private static final long serialVersionUID = -4373243410730886004L;
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	@MarshallField(as="subject",
				   whenXml=@MarshallFieldAsXml(attr=true))
	@Getter @Setter private AA14AppointmentSubject _subject;
	
	@MarshallField(as="person") 
	@Getter @Setter private Person<NIFPersonID> _person;
	
/////////////////////////////////////////////////////////////////////////////////////////
//  CONSTRUCTOR & BUILDER
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14SummarizedAppointment() {
		super(AA14Appointment.class,
			  AA14BookedSlotType.APPOINTMENT);
	}
	public static AA14SummarizedAppointment create() {
		return new AA14SummarizedAppointment();
	}
/////////////////////////////////////////////////////////////////////////////////////////
//  
/////////////////////////////////////////////////////////////////////////////////////////
	public AA14SummarizedAppointment forPerson(final Person<NIFPersonID> person) {
		_person = person;
		return this;
	}
	public AA14SummarizedAppointment subject(final AA14AppointmentSubject subject) {
		_subject = subject;
		return this;
	}
}
